/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.clientapp.client.ClientApp;
import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.G2dPanelProp;
import hec.gfx2d.G2dPlotProp;
import hec.gfx2d.HotPlotDefaults;
import hec.gfx2d.PlotDefaults;
import hec.gfx2d.PlotDefaultsManager;
import hec.gfx2d.SimplePairedValuesData;
import hec.model.PairedValues;
import hec.model.PairedValuesTableModel;
import hec.rss.client.JOperationsPanel;
import hec.rss.client.JVariableRateChangeElevPanel$MyG2dPanel;
import hec.rss.model.OpRule;
import hec.rss.model.OpRuleRef;
import hec.rss.model.RateChangeElevLimitOpRule;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.EventObject;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableModel;
import rma.swing.DefaultJPanel;
import rma.swing.RmaGridBagConstraints;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJDescriptionField;
import rma.swing.RmaJDialog;
import rma.swing.RmaJDssPathPartField;
import rma.swing.RmaJFrame;
import rma.swing.RmaJLabel;
import rma.swing.RmaJRadioButton;
import rma.swing.RmaJTable;
import rma.swing.RmaJTextField;
import rma.swing.print.PageText;
import rma.util.RMAIO;

public class JVariableRateChangeElevPanel
extends DefaultJPanel
implements ActionListener,
FocusListener,
ItemListener,
CellEditorListener {
    public static final String FUNCTION_CONSTANT_STRING = "Constant";
    public static final String FUNCTION_OF_RELEASE_STRING = "Release";
    public static final String FUNCTION_OF_INFLOW_STRING = "Reservoir Inflow";
    public static final String FUNCTION_OF_ELEVATION_STRING = "Pool Elevation";
    public static final int FUNCTION_UNDEFINED = -1;
    Insets INSETS5555 = new Insets(5, 5, 5, 5);
    Insets INSETS5500 = new Insets(5, 5, 0, 0);
    Insets INSETS5505 = new Insets(5, 5, 0, 5);
    Insets INSETS5550 = new Insets(5, 5, 5, 0);
    Insets INSETS0500 = new Insets(0, 5, 0, 0);
    Insets INSETS0000 = new Insets(0, 0, 0, 0);
    String xUnits = "";
    String yUnits = "";
    String _oldRuleName = "";
    int _functionType = -1;
    PairedValues _pvFunctionOfInflow;
    PairedValues _pvFunctionOfRelease;
    PairedValues _pvFunctionOfElevation;
    SimplePairedValuesData _rateOfChangeLimitData = this.getReleaseInflowData();
    OpRuleRef _currentRuleRef = null;
    DefaultJPanel _parent = null;
    JPanel jNameDescPanel = new JPanel();
    RmaJTextField jRuleTxt = new RmaJDssPathPartField();
    RmaJDescriptionField jRuleDescTxt = new RmaJDescriptionField();
    RmaJDecimalField jMaxChangeTxt = new RmaJDecimalField();
    RmaJComboBox jTypeCombo = new RmaJComboBox();
    RmaJComboBox jInterpCombo = new RmaJComboBox();
    RmaJComboBox jFunctionCombo = new RmaJComboBox();
    RmaJRadioButton jRadioInstantaneous = new RmaJRadioButton("Instantaneous");
    RmaJRadioButton jRadioPeriodAverage = new RmaJRadioButton("Period Average");
    String[] colLabels = new String[]{"Reservoir Inflow (%S)", "Rate Change (cfs/hr)"};
    RmaJTable jReleaseTable;
    JVariableRateChangeElevPanel$MyG2dPanel jReleasePlot;
    JLabel jLimitLabel;
    JLabel jFunctionLabel;
    JLabel jInterpLabel;
    JLabel jRuleLabel;
    JLabel jDescriptionLabel;
    RmaJLabel jMaxRateChangeLbl;
    RmaJLabel jPeriodChangeLbl;
    RmaJLabel jPeriodChangeLbl2;
    RmaJDecimalField jPeriodChangeTxt;
    JPanel jChangePanel;
    JLabel spacerLabel;

    public JVariableRateChangeElevPanel() {
        JVariableRateChangeElevPanel jVariableRateChangeElevPanel = this;
        this.jReleaseTable = new RmaJTable((Component)((Object)jVariableRateChangeElevPanel), (Object[])jVariableRateChangeElevPanel.colLabels);
        this.jReleasePlot = new JVariableRateChangeElevPanel$MyG2dPanel(this);
        this.jLimitLabel = new JLabel("Type:");
        this.jFunctionLabel = new JLabel("Function Of:");
        this.jInterpLabel = new JLabel("Interpolate");
        this.jRuleLabel = new JLabel("Elevation Rate of Change Limit:");
        this.jDescriptionLabel = new JLabel("Description");
        this.jMaxRateChangeLbl = new RmaJLabel("Max Rate of Change (%S/hr):");
        this.jPeriodChangeLbl = new RmaJLabel("over");
        this.jPeriodChangeLbl2 = new RmaJLabel("hours");
        this.jPeriodChangeTxt = new RmaJDecimalField();
        this.spacerLabel = new JLabel("");
        this.setLayout(new GridBagLayout());
        this.jRuleTxt.setModifiable(false);
        this.jRuleTxt.setEditable(false);
        this.jNameDescPanel.setLayout(new GridBagLayout());
        this.jNameDescPanel.add((Component)this.jRuleLabel, new RmaGridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 18, 0, this.INSETS5500, 0, 0));
        this.jNameDescPanel.add((Component)this.jDescriptionLabel, new RmaGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, this.INSETS5500, 0, 0));
        this.jNameDescPanel.add((Component)this.jRuleTxt, new RmaGridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 18, 2, this.INSETS5500, 0, 0));
        this.jNameDescPanel.add((Component)new JLabel(), new RmaGridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 18, 2, this.INSETS5505, 0, 0));
        this.jNameDescPanel.add((Component)this.jRuleDescTxt, new RmaGridBagConstraints(1, 1, 4, 1, 1.0, 0.0, 18, 2, this.INSETS5555, 0, 0));
        JVariableRateChangeElevPanel jVariableRateChangeElevPanel2 = this;
        jVariableRateChangeElevPanel2.add(jVariableRateChangeElevPanel2.jNameDescPanel, new RmaGridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        Serializable serializable = new JPanel(new GridBagLayout());
        this.add((Component)serializable, new RmaGridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        serializable.add(this.jFunctionLabel, new RmaGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, this.INSETS5500, 0, 0));
        this.jFunctionCombo.addItem((Object)FUNCTION_CONSTANT_STRING);
        this.jFunctionCombo.addItem((Object)FUNCTION_OF_INFLOW_STRING);
        this.jFunctionCombo.addItem((Object)FUNCTION_OF_RELEASE_STRING);
        this.jFunctionCombo.setSelectedIndex(0);
        this.jFunctionCombo.setModifiable(true);
        serializable.add((Component)this.jFunctionCombo, new RmaGridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, this.INSETS5500, 0, 0));
        serializable.add(this.jLimitLabel, new RmaGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, this.INSETS5500, 0, 0));
        this.jTypeCombo.addItem((Object)"Increasing");
        this.jTypeCombo.addItem((Object)"Decreasing");
        this.jTypeCombo.setModifiable(true);
        serializable.add((Component)this.jTypeCombo, new RmaGridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 1, this.INSETS5500, 0, 0));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.jRadioInstantaneous, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(5, 5, 0, 5), 0, 0));
        jPanel.add((Component)this.jRadioPeriodAverage, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 5, 0, 5), 0, 0));
        serializable.add(jPanel, new RmaGridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 18, 2, new Insets(0, 10, 0, 0), 0, 0));
        for (int i = 0; i < PairedValues.INTERP_STRINGS.length; ++i) {
            this.jInterpCombo.addItem((Object)PairedValues.INTERP_STRINGS[i]);
        }
        this.jInterpCombo.setModifiable(true);
        this.jReleaseTable.setModel((TableModel)new PairedValuesTableModel(this.colLabels, new boolean[]{true, true}));
        ((PairedValuesTableModel)this.jReleaseTable.getModel()).setShouldAddBlankRows(true);
        this.jReleaseTable.setUnitsHeaderRenderer();
        this.jReleaseTable.setDoubleCellEditor(0, false);
        this.jReleaseTable.setDoubleCellEditor(1, false);
        this.jReleaseTable.setNumRows(10);
        serializable.add(this.jInterpLabel, new RmaGridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 0, this.INSETS5500, 0, 0));
        serializable.add((Component)this.jInterpCombo, new RmaGridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 18, 2, this.INSETS5550, 0, 0));
        serializable.add(this.jReleaseTable.getScrollPane(), new RmaGridBagConstraints(0, 5, 2, 1, 1.0, 1.0, 18, 1, this.INSETS5550, 0, 0));
        serializable.add((Component)((Object)this.jReleasePlot), new RmaGridBagConstraints(3, 0, 1, 6, 0.0, 0.0, 13, 0, new Insets(5, 10, 5, 5), 120, 150));
        this.jChangePanel = new JPanel(new GridBagLayout());
        serializable.add(this.jChangePanel, new RmaGridBagConstraints(0, 3, 3, 1, 0.0, 0.0, 18, 2, this.INSETS0000, 0, 0));
        this.jChangePanel.add((Component)this.jMaxRateChangeLbl, new RmaGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, this.INSETS5500, 0, 0));
        this.jChangePanel.add((Component)this.jMaxChangeTxt, new RmaGridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, this.INSETS5550, 0, 0));
        this.jChangePanel.add((Component)this.jPeriodChangeLbl, new RmaGridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 18, 0, this.INSETS5500, 0, 0));
        this.jChangePanel.add((Component)this.jPeriodChangeTxt, new RmaGridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 18, 0, this.INSETS5500, 60, 0));
        this.jChangePanel.add((Component)this.jPeriodChangeLbl2, new RmaGridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 18, 0, this.INSETS5500, 0, 0));
        serializable.add(this.spacerLabel, new RmaGridBagConstraints(4, 5, 1, 1, 2.0, 1.0, 18, 2, this.INSETS5550, 0, 0));
        this.jMaxRateChangeLbl.setLabelFor((Component)this.jMaxChangeTxt);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)this.jRadioInstantaneous);
        buttonGroup.add((AbstractButton)this.jRadioPeriodAverage);
        this.jRadioInstantaneous.setSelected(true);
        JVariableRateChangeElevPanel jVariableRateChangeElevPanel3 = this;
        jVariableRateChangeElevPanel3.configureFlowPlot(jVariableRateChangeElevPanel3.jReleasePlot);
        serializable = new Vector<SimplePairedValuesData>();
        ((Vector)serializable).addElement(this._rateOfChangeLimitData);
        this.jReleasePlot.setPlotObjects((List)((Object)serializable));
        this.jRadioInstantaneous.addItemListener((ItemListener)this);
        this.jRadioPeriodAverage.addItemListener((ItemListener)this);
        this.jReleaseTable.addCellEditorListener((CellEditorListener)this);
        this.jInterpCombo.addItemListener((ItemListener)this);
        this.jTypeCombo.addItemListener((ItemListener)this);
        this.jFunctionCombo.addItemListener((ItemListener)this);
        this.jRuleTxt.addFocusListener((FocusListener)this);
    }

    @Override
    public void editingCanceled(ChangeEvent changeEvent) {
    }

    @Override
    public void editingStopped(ChangeEvent changeEvent) {
        this.replotRateOfChangeLimit();
    }

    public void fillPanel() {
        if (this._currentRuleRef == null) {
            return;
        }
        this.clearPanel();
        Object object = (RateChangeElevLimitOpRule)this._currentRuleRef.getRule();
        this._oldRuleName = object.getName();
        this.jRuleTxt.setText(object.getName());
        this.jRuleDescTxt.setText(object.getDescription());
        this.jTypeCombo.removeItemListener((ItemListener)this);
        this.jInterpCombo.removeItemListener((ItemListener)this);
        this.jFunctionCombo.removeItemListener((ItemListener)this);
        this.jRadioInstantaneous.removeItemListener((ItemListener)this);
        this.jRadioPeriodAverage.removeItemListener((ItemListener)this);
        if (((RateChangeElevLimitOpRule)object).getType() == 1) {
            this.jTypeCombo.setSelectedIndex(0);
        } else {
            ((RateChangeElevLimitOpRule)object).getType();
            this.jTypeCombo.setSelectedIndex(1);
        }
        this.jInterpCombo.setSelectedIndex(((RateChangeElevLimitOpRule)object).getInterpolationType());
        int n = ((RateChangeElevLimitOpRule)object).getFunctionType();
        if (n == 1) {
            this.jFunctionCombo.setSelectedItem((Object)FUNCTION_OF_INFLOW_STRING);
        } else if (n == 2) {
            this.jFunctionCombo.setSelectedItem((Object)FUNCTION_OF_RELEASE_STRING);
        } else {
            this.jFunctionCombo.setSelectedItem((Object)FUNCTION_CONSTANT_STRING);
        }
        ParamDouble paramDouble = new ParamDouble();
        ((RateChangeElevLimitOpRule)object).getMaxRateOfChange(paramDouble);
        this.jMaxChangeTxt.setValue(paramDouble);
        paramDouble = ((RateChangeElevLimitOpRule)object).getChangeLimitCurve();
        this.fillFunction(n, (PairedValues)paramDouble);
        if (((RateChangeElevLimitOpRule)object).isInstantaneous()) {
            this.jRadioInstantaneous.setSelected(true);
            this.setInstantaneousMode();
        } else {
            this.jPeriodChangeTxt.setValue(((RateChangeElevLimitOpRule)object).getPeriodAverageTime());
            this.jRadioPeriodAverage.setSelected(true);
            this.setPeriodAverageMode();
        }
        ClientApp.app();
        object = new String("Workspace: " + ClientApp.Workspace().getTitleName());
        object = (String)object + "\n ResSim System: " + ((JOperationsPanel)this._parent)._reservoir.getSystem().getName();
        object = (String)object + "\n Reservoir: " + ((JOperationsPanel)this._parent)._reservoir.getName();
        object = (String)object + "\n Operation Set: " + ((JOperationsPanel)this._parent)._currentOpSet.getName();
        object = (String)object + "\n Flow Release Rule: " + this._currentRuleRef.getName() + " \n ";
        object = new PageText((String)object, 0);
        this.jReleaseTable.setPrintTitle((PageText)object);
        this.setModified(false);
        this.jTypeCombo.addItemListener((ItemListener)this);
        this.jInterpCombo.addItemListener((ItemListener)this);
        this.jFunctionCombo.addItemListener((ItemListener)this);
        this.jRadioInstantaneous.addItemListener((ItemListener)this);
        this.jRadioPeriodAverage.addItemListener((ItemListener)this);
    }

    private void fillFunction(int n, PairedValues pairedValues) {
        this._functionType = n;
        n = -1;
        int n2 = Parameter.PARAMID_ELEV;
        String string = "Rate Change (%S/hr)";
        String string2 = "";
        if (this._functionType == 1) {
            n = Parameter.PARAMID_FLOW;
            string2 = "Reservoir Inflow (%S)";
        } else if (this._functionType == 2) {
            n = Parameter.PARAMID_FLOW;
            string2 = "Release (%S)";
        }
        if (this._functionType == 0) {
            this.jReleaseTable.getScrollPane().setVisible(false);
            this.jReleasePlot.setVisible(false);
            this.jInterpLabel.setVisible(false);
            this.jInterpCombo.setVisible(false);
            this.jMaxRateChangeLbl.setVisible(true);
            this.jMaxChangeTxt.setVisible(true);
            this.spacerLabel.setVisible(true);
            return;
        }
        PairedValuesTableModel pairedValuesTableModel = (PairedValuesTableModel)this.jReleaseTable.getModel();
        String[] stringArray = new String[2];
        String[] stringArray2 = stringArray;
        stringArray[0] = new String(string2);
        stringArray2[1] = new String(string);
        if (pairedValues == null) {
            pairedValues = new PairedValues();
            OpRule opRule = this._currentRuleRef.getRule();
            pairedValues.setUnitSystem(opRule.getUnitSystem());
        }
        pairedValues.setParamXId(n);
        pairedValues.setParamYId(n2);
        pairedValuesTableModel.setPairedValues(pairedValues);
        this.jReleaseTable.setColumnLabels(stringArray2);
        int n3 = pairedValues.getUnitSystem();
        JVariableRateChangeElevPanel jVariableRateChangeElevPanel = this;
        jVariableRateChangeElevPanel.configureFlowPlot(jVariableRateChangeElevPanel.jReleasePlot, new String(string2), new String(string), n3);
        this.jReleaseTable.getScrollPane().setVisible(true);
        this.jReleasePlot.setVisible(true);
        this.jInterpLabel.setVisible(true);
        this.jInterpCombo.setVisible(true);
        this.jMaxRateChangeLbl.setVisible(false);
        this.jMaxChangeTxt.setVisible(false);
        this.spacerLabel.setVisible(false);
        Window window = SwingUtilities.windowForComponent((Component)((Object)this));
        if (window instanceof RmaJDialog) {
            ((RmaJDialog)window).updateUnitSystem((Container)((Object)this));
        } else if (window instanceof RmaJFrame) {
            ((RmaJFrame)window).updateUnitSystem((Container)((Object)this));
        }
        this.replotRateOfChangeLimit();
    }

    void updateLabels(String string) {
        String[] stringArray = this.jReleaseTable.getColumnLabels();
        Object object = stringArray;
        stringArray[1] = string;
        this.jReleaseTable.setColumnLabels(object);
        object = object[0];
        RateChangeElevLimitOpRule rateChangeElevLimitOpRule = (RateChangeElevLimitOpRule)this._currentRuleRef.getRule();
        int n = rateChangeElevLimitOpRule.getUnitSystem();
        JVariableRateChangeElevPanel jVariableRateChangeElevPanel = this;
        jVariableRateChangeElevPanel.configureFlowPlot(jVariableRateChangeElevPanel.jReleasePlot, (String)object, string, n);
        this.replotRateOfChangeLimit();
    }

    @Override
    public void itemStateChanged(ItemEvent object) {
        if (((ItemEvent)object).getStateChange() == 2) {
            return;
        }
        if ((object = ((EventObject)object).getSource()) == this.jInterpCombo) {
            this.setModified(true);
            this.replotRateOfChangeLimit();
            return;
        }
        if (object == this.jTypeCombo) {
            this.setModified(true);
            return;
        }
        if (object == this.jFunctionCombo) {
            this.setModified(true);
            JVariableRateChangeElevPanel jVariableRateChangeElevPanel = this;
            jVariableRateChangeElevPanel.setFunctionType((String)jVariableRateChangeElevPanel.jFunctionCombo.getSelectedItem());
            return;
        }
        if (object == this.jRadioInstantaneous) {
            this.setInstantaneousMode();
            return;
        }
        if (object == this.jRadioPeriodAverage) {
            this.setPeriodAverageMode();
        }
    }

    public void setFunctionType(String string) {
        JVariableRateChangeElevPanel jVariableRateChangeElevPanel = this;
        PairedValues pairedValues = jVariableRateChangeElevPanel.saveTable(jVariableRateChangeElevPanel._functionType);
        if (this._functionType == 1) {
            this._pvFunctionOfInflow = pairedValues;
        }
        if (this._functionType == 2) {
            this._pvFunctionOfRelease = pairedValues;
        }
        if (string.equals(FUNCTION_CONSTANT_STRING)) {
            this._functionType = 0;
        }
        if (string.equals(FUNCTION_OF_INFLOW_STRING)) {
            this._functionType = 1;
        }
        if (string.equals(FUNCTION_OF_RELEASE_STRING)) {
            this._functionType = 2;
        }
        if (this._functionType == 1) {
            pairedValues = this._pvFunctionOfInflow;
        }
        if (this._functionType == 2) {
            pairedValues = this._pvFunctionOfRelease;
        }
        JVariableRateChangeElevPanel jVariableRateChangeElevPanel2 = this;
        jVariableRateChangeElevPanel2.fillFunction(jVariableRateChangeElevPanel2._functionType, pairedValues);
        if (this.jRadioInstantaneous.isSelected()) {
            this.setInstantaneousMode();
            return;
        }
        this.setPeriodAverageMode();
    }

    private void setInstantaneousMode() {
        Object object;
        if (this._functionType == 0) {
            this.jChangePanel.setVisible(true);
        } else {
            this.jChangePanel.setVisible(false);
            object = "Rate Change (%S/hr)";
            this.updateLabels((String)object);
        }
        this.jMaxRateChangeLbl.setText("Max Rate of Change (%S/hr)");
        this.jPeriodChangeLbl.setVisible(false);
        this.jPeriodChangeTxt.setVisible(false);
        this.jPeriodChangeLbl2.setText(" ");
        object = SwingUtilities.windowForComponent((Component)((Object)this));
        ((RmaJDialog)object).updateUnitSystem((Container)((Object)this));
        if (this._functionType == 0) {
            this.jReleasePlot.setVisible(false);
        }
    }

    private void setPeriodAverageMode() {
        Object object;
        this.jChangePanel.setVisible(true);
        this.jMaxRateChangeLbl.setText("Max Change of (%S)");
        this.jPeriodChangeLbl.setVisible(true);
        if (this._functionType == 0) {
            this.jMaxRateChangeLbl.setVisible(true);
            this.jPeriodChangeLbl.setText(" over");
        } else {
            this.jMaxRateChangeLbl.setVisible(false);
            this.jPeriodChangeLbl.setText("Max change over");
            object = "Max Change (%S)";
            this.updateLabels((String)object);
        }
        this.jPeriodChangeTxt.setVisible(true);
        this.jPeriodChangeLbl2.setText("hours");
        object = SwingUtilities.windowForComponent((Component)((Object)this));
        ((RmaJDialog)object).updateUnitSystem((Container)((Object)this));
        if (this._functionType == 0) {
            this.jReleasePlot.setVisible(false);
        }
    }

    public void refresh() {
    }

    public boolean savePanel() {
        int n;
        if (this._currentRuleRef == null) {
            return false;
        }
        if (this.jRuleTxt.getName() != null && this.jRuleTxt.getText().equals("")) {
            RMAIO.postError((Component)((Object)this), (String)"Cannot have an empty rule name!");
            return false;
        }
        RateChangeElevLimitOpRule rateChangeElevLimitOpRule = (RateChangeElevLimitOpRule)this._currentRuleRef.getRule();
        if (rateChangeElevLimitOpRule == null) {
            return false;
        }
        this._currentRuleRef.getRule().setName(this.jRuleTxt.getText());
        this._currentRuleRef.setName(this.jRuleTxt.getText());
        this._oldRuleName = this.jRuleTxt.getText();
        rateChangeElevLimitOpRule.setDescription(this.jRuleDescTxt.getText());
        String string = (String)this.jTypeCombo.getSelectedItem();
        if (string.equals("Increasing")) {
            rateChangeElevLimitOpRule.setType(1);
        } else {
            rateChangeElevLimitOpRule.setType(0);
        }
        string = (String)this.jFunctionCombo.getSelectedItem();
        if (string.equals(FUNCTION_OF_INFLOW_STRING)) {
            n = 1;
        } else if (string.equals(FUNCTION_OF_RELEASE_STRING)) {
            n = 2;
        } else if (string.equals(FUNCTION_CONSTANT_STRING)) {
            n = 0;
        } else {
            return false;
        }
        rateChangeElevLimitOpRule.setFunctionType(n);
        if (n == 0) {
            rateChangeElevLimitOpRule.setMaxRateOfChange(this.jMaxChangeTxt.getParamValue());
        } else {
            this.jReleaseTable.commitEdit(true);
            PairedValuesTableModel pairedValuesTableModel = (PairedValuesTableModel)this.jReleaseTable.getModel();
            PairedValues pairedValues = new PairedValues();
            pairedValuesTableModel.storeData(pairedValues);
            if (pairedValues.size() > 1 && !pairedValues.canInterpX()) {
                JVariableRateChangeElevPanel jVariableRateChangeElevPanel = this;
                JOptionPane.showMessageDialog((Component)((Object)jVariableRateChangeElevPanel), "The " + String.valueOf(jVariableRateChangeElevPanel.jFunctionCombo.getSelectedItem()) + " values of your function must be a continuously increasing sequence.", "Error", 0);
            }
            rateChangeElevLimitOpRule.setChangeLimitCurve(pairedValues);
            rateChangeElevLimitOpRule.setInterpolationType(this.jInterpCombo.getSelectedIndex());
        }
        rateChangeElevLimitOpRule.setInstantaneous(this.jRadioInstantaneous.isSelected());
        if (this.jRadioPeriodAverage.isSelected()) {
            rateChangeElevLimitOpRule.setPeriodAverageTime(this.jPeriodChangeTxt.getValueUndefined());
        }
        this.setModified(false);
        return true;
    }

    private PairedValues saveTable(int n) {
        if (n != 1 && n != 2) {
            return null;
        }
        this.jReleaseTable.commitEdit(true);
        PairedValuesTableModel pairedValuesTableModel = (PairedValuesTableModel)this.jReleaseTable.getModel();
        PairedValues pairedValues = new PairedValues();
        pairedValuesTableModel.storeData(pairedValues);
        return pairedValues;
    }

    private void replotRateOfChangeLimit() {
        Object object = new PairedValues();
        if (this._rateOfChangeLimitData == null) {
            this._rateOfChangeLimitData = this.getReleaseInflowData();
        }
        Object object2 = (String[])this.jReleaseTable.getModel();
        object2.storeData(object);
        this.jReleasePlot.clearPanel();
        object2 = this.jReleaseTable.getColumnLabels();
        JVariableRateChangeElevPanel jVariableRateChangeElevPanel = this;
        jVariableRateChangeElevPanel.configureFlowPlot(jVariableRateChangeElevPanel.jReleasePlot, object2[0], object2[1], object.getUnitSystem());
        object2 = (String)this.jInterpCombo.getSelectedItem();
        this._rateOfChangeLimitData.setInterpolationType((String)object2);
        this._rateOfChangeLimitData.setData(object);
        this._rateOfChangeLimitData.calcPlotArrays();
        this._rateOfChangeLimitData.name = "Rate of Change Limit";
        object = new Vector<SimplePairedValuesData>();
        object.addElement(this._rateOfChangeLimitData);
        this.jReleasePlot.setPlotObjects((List)object);
        int n = ClientApp.app().getClientUnitSystem();
        this.jReleasePlot.setDisplayUnitsSystem(n);
    }

    private void configureFlowPlot(G2dPanel g2dPanel) {
        PlotDefaults plotDefaults = PlotDefaultsManager.getDefaults();
        PlotDefaultsManager.setDefaults((PlotDefaults)new HotPlotDefaults());
        G2dPanelProp g2dPanelProp = new G2dPanelProp();
        new G2dPanelProp().hasTitle = false;
        g2dPanelProp.hasToolbar = false;
        g2dPanelProp.hasLegend = false;
        G2dPlotProp g2dPlotProp = new G2dPlotProp();
        new G2dPlotProp().hasXScroll = false;
        g2dPlotProp.hasYScroll = false;
        g2dPlotProp.x1AxisProp.name = FUNCTION_OF_INFLOW_STRING;
        g2dPlotProp.y1AxisProp.name = "Rate of Change";
        g2dPlotProp.y1AxisProp.isReversed = true;
        g2dPanelProp.addPlotProp(g2dPlotProp);
        g2dPanel.configurePanel(g2dPanelProp);
        PlotDefaultsManager.setDefaults((PlotDefaults)plotDefaults);
    }

    private void configureFlowPlot(G2dPanel g2dPanel, String string, String string2, int n) {
        PlotDefaults plotDefaults = PlotDefaultsManager.getDefaults();
        PlotDefaultsManager.setDefaults((PlotDefaults)new HotPlotDefaults());
        G2dPanelProp g2dPanelProp = new G2dPanelProp();
        new G2dPanelProp().hasTitle = false;
        g2dPanelProp.hasToolbar = false;
        g2dPanelProp.hasLegend = false;
        G2dPlotProp g2dPlotProp = new G2dPlotProp();
        new G2dPlotProp().hasXScroll = false;
        g2dPlotProp.hasYScroll = false;
        g2dPlotProp.x1AxisProp.name = string;
        g2dPlotProp.y1AxisProp.name = string2;
        g2dPlotProp.y1AxisProp.isReversed = true;
        g2dPanelProp.addPlotProp(g2dPlotProp);
        g2dPlotProp = new SimplePairedValuesData();
        new SimplePairedValuesData().xunits = string;
        g2dPlotProp.yunits = string2;
        g2dPlotProp.setUnitSystem(n);
        g2dPlotProp.resetData();
        this._rateOfChangeLimitData = g2dPlotProp;
        g2dPanel.configurePanel(g2dPanelProp);
        PlotDefaultsManager.setDefaults((PlotDefaults)plotDefaults);
    }

    private SimplePairedValuesData getReleaseInflowData() {
        SimplePairedValuesData simplePairedValuesData = new SimplePairedValuesData();
        new SimplePairedValuesData().xunits = "Inflow (%S)";
        simplePairedValuesData.yunits = FUNCTION_OF_RELEASE_STRING;
        PairedValues pairedValues = new PairedValues();
        pairedValues.setInterpolationType(0);
        simplePairedValuesData.resetData();
        return simplePairedValuesData;
    }

    public void clearPanel() {
        this.jReleaseTable.clearCells();
        Vector vector = new Vector();
        this.jReleasePlot.setPlotObjects(vector);
        this.jReleasePlot.paintGfx();
        this.jReleasePlot.revalidate();
    }

    public void setRuleRef(OpRuleRef opRuleRef) {
        if (opRuleRef == null) {
            return;
        }
        if (this.isModified()) {
            this.savePanel();
        }
        this._currentRuleRef = opRuleRef;
        this.fillPanel();
    }

    public void setParent(JPanel jPanel) {
        this._parent = (JOperationsPanel)((Object)jPanel);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent object) {
        if ((object = ((EventObject)object).getSource()) == this.jRuleTxt) {
            if (this.jRuleTxt.getText().equals("")) {
                this.jRuleTxt.setText(this._currentRuleRef.getRule().getName());
                RMAIO.postError((Component)((Object)this), (String)"Cannot have a blank Rule Name!");
                return;
            }
            this._currentRuleRef.getRule().setName(this.jRuleTxt.getText());
            this._currentRuleRef.setName(this.jRuleTxt.getText());
            ((JOperationsPanel)this._parent).treeDataChanged(0, this._oldRuleName, this.jRuleTxt.getText());
        }
    }

    public void deselectPanel() {
        if (this.isModified()) {
            this.savePanel();
        }
    }
}

