/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.clientapp.client.ClientApp;
import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.G2dPanelProp;
import hec.gfx2d.G2dPlotProp;
import hec.gfx2d.HotPlotDefaults;
import hec.gfx2d.PlotDefaults;
import hec.gfx2d.PlotDefaultsManager;
import hec.gfx2d.SimplePairedValuesData;
import hec.model.PairedValues;
import hec.model.PairedValuesTableModel;
import hec.rss.client.ElementOpsEditorPanel;
import hec.rss.client.JVariableRateChangeFlowPanel$MyG2dPanel;
import hec.rss.model.OpRule;
import hec.rss.model.OpRuleRef;
import hec.rss.model.RateChangeLimitOpRule;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableModel;
import rma.swing.DefaultJPanel;
import rma.swing.RmaGridBagConstraints;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJDescriptionField;
import rma.swing.RmaJDialog;
import rma.swing.RmaJFrame;
import rma.swing.RmaJLabel;
import rma.swing.RmaJTable;
import rma.swing.RmaJTextField;
import rma.swing.event.TableChangeListener;
import rma.swing.event.TableUpdateEvent;
import rma.swing.print.PageText;
import rma.util.RMAIO;

public class JVariableRateChangeFlowPanel
extends DefaultJPanel
implements ActionListener,
FocusListener,
ItemListener,
CellEditorListener,
TableChangeListener {
    public static final String FUNCTION_CONSTANT_STRING = "Constant";
    public static final String FUNCTION_OF_RELEASE_STRING = "Release";
    public static final String FUNCTION_OF_INFLOW_STRING = "Reservoir Inflow";
    public static final String FUNCTION_OF_ELEVATION_STRING = "Pool Elevation";
    public static final int FUNCTION_UNDEFINED = -1;
    Insets INSETS5555 = new Insets(5, 5, 5, 5);
    Insets INSETS5500 = new Insets(5, 5, 0, 0);
    Insets INSETS5505 = new Insets(5, 5, 0, 5);
    Insets INSETS5550 = new Insets(5, 5, 5, 0);
    String xUnits = "";
    String yUnits = "";
    String _oldRuleName = "";
    int _functionType = -1;
    PairedValues _pvFunctionOfInflow;
    PairedValues _pvFunctionOfRelease;
    PairedValues _pvFunctionOfElevation;
    SimplePairedValuesData _rateOfChangeLimitData = JVariableRateChangeFlowPanel.a();
    OpRuleRef _currentRuleRef = null;
    ElementOpsEditorPanel _parent = null;
    JPanel jNameDescPanel = new JPanel();
    RmaJTextField jRuleTxt = new RmaJTextField();
    RmaJDescriptionField jRuleDescTxt = new RmaJDescriptionField();
    RmaJDecimalField jMaxChangeTxt = new RmaJDecimalField();
    RmaJComboBox<String> jTypeCombo = new RmaJComboBox();
    RmaJComboBox<String> jInterpCombo = new RmaJComboBox();
    RmaJComboBox<String> jFunctionCombo = new RmaJComboBox();
    String[] colLabels = new String[]{"Reservoir Inflow (%S)", "Rate Change (cfs/hr)"};
    RmaJTable jReleaseTable;
    JVariableRateChangeFlowPanel$MyG2dPanel jReleasePlot;
    JLabel jLimitLabel;
    JLabel jFunctionLabel;
    JLabel jInterpLabel;
    JLabel jRuleLabel;
    JLabel jDescriptionLabel;
    RmaJLabel jMaxRateChangeLbl;
    JLabel spacerLabel;

    public JVariableRateChangeFlowPanel() {
        this(true);
    }

    public JVariableRateChangeFlowPanel(boolean n) {
        super((LayoutManager)new GridBagLayout());
        JVariableRateChangeFlowPanel jVariableRateChangeFlowPanel = this;
        this.jReleaseTable = new RmaJTable((Component)((Object)jVariableRateChangeFlowPanel), (Object[])jVariableRateChangeFlowPanel.colLabels);
        this.jReleasePlot = new JVariableRateChangeFlowPanel$MyG2dPanel(this);
        this.jLimitLabel = new JLabel("Type:");
        this.jFunctionLabel = new JLabel("Function Of:");
        this.jInterpLabel = new JLabel("Interpolate");
        this.jRuleLabel = new JLabel("Release Rate of Change Limit:");
        this.jDescriptionLabel = new JLabel("Description:");
        this.jMaxRateChangeLbl = new RmaJLabel("Max Rate of Change (%S/hr):");
        this.spacerLabel = new JLabel("");
        this.jNameDescPanel.setLayout(new GridBagLayout());
        this.jNameDescPanel.add((Component)this.jRuleLabel, new RmaGridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 18, 0, this.INSETS5500, 0, 0));
        this.jNameDescPanel.add((Component)this.jDescriptionLabel, new RmaGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, this.INSETS5500, 0, 0));
        this.jNameDescPanel.add((Component)this.jRuleTxt, new RmaGridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 18, 2, this.INSETS5500, 0, 0));
        this.jRuleTxt.setEditable(false);
        this.jNameDescPanel.add((Component)new JLabel(), new RmaGridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 18, 2, this.INSETS5505, 0, 0));
        this.jNameDescPanel.add((Component)this.jRuleDescTxt, new RmaGridBagConstraints(1, 1, 4, 1, 1.0, 0.0, 18, 2, this.INSETS5555, 0, 0));
        JVariableRateChangeFlowPanel jVariableRateChangeFlowPanel2 = this;
        jVariableRateChangeFlowPanel2.add(jVariableRateChangeFlowPanel2.jNameDescPanel, new RmaGridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.add(jPanel, new RmaGridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.jFunctionLabel, new RmaGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, this.INSETS5500, 0, 0));
        this.jFunctionCombo.addItem((Object)FUNCTION_CONSTANT_STRING);
        if (n != 0) {
            this.jFunctionCombo.addItem((Object)FUNCTION_OF_INFLOW_STRING);
        }
        this.jFunctionCombo.addItem((Object)FUNCTION_OF_RELEASE_STRING);
        if (n != 0) {
            this.jFunctionCombo.addItem((Object)FUNCTION_OF_ELEVATION_STRING);
        }
        this.jFunctionCombo.setSelectedIndex(0);
        this.jFunctionCombo.setModifiable(true);
        jPanel.add((Component)this.jFunctionCombo, new RmaGridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, this.INSETS5500, 0, 0));
        jPanel.add((Component)this.jLimitLabel, new RmaGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, this.INSETS5500, 0, 0));
        this.jTypeCombo.addItem((Object)"Increasing");
        this.jTypeCombo.addItem((Object)"Decreasing");
        this.jTypeCombo.setModifiable(true);
        jPanel.add((Component)this.jTypeCombo, new RmaGridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 1, this.INSETS5500, 0, 0));
        for (n = 0; n < PairedValues.INTERP_STRINGS.length; ++n) {
            this.jInterpCombo.addItem((Object)PairedValues.INTERP_STRINGS[n]);
        }
        this.jInterpCombo.setModifiable(true);
        this.jReleaseTable.setModel((TableModel)new PairedValuesTableModel(this.colLabels, new boolean[]{true, true}));
        ((PairedValuesTableModel)this.jReleaseTable.getModel()).setShouldAddBlankRows(true);
        this.jReleaseTable.setUnitsHeaderRenderer();
        this.jReleaseTable.setDoubleCellEditor(0, false);
        this.jReleaseTable.setDoubleCellEditor(1, false);
        this.jReleaseTable.setNumRows(10);
        jPanel.add((Component)this.jInterpLabel, new RmaGridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, this.INSETS5500, 0, 0));
        jPanel.add((Component)this.jInterpCombo, new RmaGridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 2, this.INSETS5550, 0, 0));
        jPanel.add((Component)this.jReleaseTable.getScrollPane(), new RmaGridBagConstraints(0, 3, 2, 1, 1.0, 1.0, 18, 1, this.INSETS5550, 0, 0));
        jPanel.add((Component)((Object)this.jReleasePlot), new RmaGridBagConstraints(3, 0, 1, 4, 0.0, 0.0, 13, 0, new Insets(5, 10, 5, 5), 120, 150));
        jPanel.add((Component)this.jMaxRateChangeLbl, new RmaGridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, this.INSETS5500, 0, 0));
        jPanel.add((Component)this.jMaxChangeTxt, new RmaGridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 18, 2, this.INSETS5550, 0, 0));
        jPanel.add((Component)this.spacerLabel, new RmaGridBagConstraints(2, 3, 1, 1, 2.0, 1.0, 18, 2, this.INSETS5550, 0, 0));
        this.jMaxRateChangeLbl.setLabelFor((Component)this.jMaxChangeTxt);
        Object object = this.jReleasePlot;
        jPanel = PlotDefaultsManager.getDefaults();
        PlotDefaultsManager.setDefaults((PlotDefaults)new HotPlotDefaults());
        G2dPanelProp g2dPanelProp = new G2dPanelProp();
        new G2dPanelProp().hasTitle = false;
        g2dPanelProp.hasToolbar = false;
        g2dPanelProp.hasLegend = false;
        G2dPlotProp g2dPlotProp = new G2dPlotProp();
        new G2dPlotProp().hasXScroll = false;
        g2dPlotProp.hasYScroll = false;
        g2dPlotProp.x1AxisProp.name = FUNCTION_OF_INFLOW_STRING;
        g2dPlotProp.y1AxisProp.name = "Rate of Change";
        g2dPlotProp.y1AxisProp.isReversed = true;
        g2dPanelProp.addPlotProp(g2dPlotProp);
        object.configurePanel(g2dPanelProp);
        PlotDefaultsManager.setDefaults((PlotDefaults)jPanel);
        object = new ArrayList<SimplePairedValuesData>();
        object.add(this._rateOfChangeLimitData);
        this.jReleasePlot.setPlotObjects((List)object);
        this.addListeners();
    }

    protected void addListeners() {
        this.jReleaseTable.addCellEditorListener((CellEditorListener)this);
        this.jReleaseTable.addTableChangeListener((TableChangeListener)this);
        this.jInterpCombo.addItemListener((ItemListener)this);
        this.jTypeCombo.addItemListener((ItemListener)this);
        this.jFunctionCombo.addItemListener((ItemListener)this);
    }

    @Override
    public void editingCanceled(ChangeEvent changeEvent) {
    }

    @Override
    public void editingStopped(ChangeEvent changeEvent) {
        this.replotRateOfChangeLimit();
    }

    public void tableDataChanged(TableUpdateEvent tableUpdateEvent) {
        this.replotRateOfChangeLimit();
    }

    public void fillPanel() {
        if (this._currentRuleRef == null) {
            return;
        }
        this.clearPanel();
        Object object = (RateChangeLimitOpRule)this._currentRuleRef.getRule();
        this._oldRuleName = object.getName();
        this.jRuleTxt.setText(object.getName());
        this.jRuleDescTxt.setText(object.getDescription());
        if (((RateChangeLimitOpRule)object).getType() == 1) {
            this.jTypeCombo.setSelectedIndex(0);
        } else {
            ((RateChangeLimitOpRule)object).getType();
            this.jTypeCombo.setSelectedIndex(1);
        }
        this.jInterpCombo.removeItemListener((ItemListener)this);
        this.jInterpCombo.setSelectedIndex(((RateChangeLimitOpRule)object).getInterpolationType());
        this.jInterpCombo.addItemListener((ItemListener)this);
        this.jFunctionCombo.removeItemListener((ItemListener)this);
        int n = ((RateChangeLimitOpRule)object).getFunctionType();
        if (n == 1) {
            this.jFunctionCombo.setSelectedItem((Object)FUNCTION_OF_INFLOW_STRING);
        } else if (n == 2) {
            this.jFunctionCombo.setSelectedItem((Object)FUNCTION_OF_RELEASE_STRING);
        } else if (n == 3) {
            this.jFunctionCombo.setSelectedItem((Object)FUNCTION_OF_ELEVATION_STRING);
        } else {
            this.jFunctionCombo.setSelectedItem((Object)FUNCTION_CONSTANT_STRING);
        }
        this.jFunctionCombo.addItemListener((ItemListener)this);
        ParamDouble paramDouble = new ParamDouble();
        ((RateChangeLimitOpRule)object).getMaxRateOfChange(paramDouble);
        this.jMaxChangeTxt.setValue(paramDouble);
        object = ((RateChangeLimitOpRule)object).getChangeLimitCurve();
        this.fillFunction(n, (PairedValues)object);
        object = "Workspace: " + ClientApp.Workspace().getTitleName();
        object = (String)object + "\n ResSim System: " + this._parent.getSystem().getName();
        object = (String)object + "\n Reservoir: " + this._parent.getElement().getName();
        object = (String)object + "\n Operation Set: " + this._parent.getCurrentOpSet().getName();
        object = (String)object + "\n Flow Release Rule: " + this._currentRuleRef.getName() + " \n ";
        object = new PageText((String)object, 0);
        this.jReleaseTable.setPrintTitle((PageText)object);
        this.setModified(false);
    }

    private void fillFunction(int n, PairedValues pairedValues) {
        this._functionType = n;
        n = -1;
        int n2 = Parameter.PARAMID_FLOW;
        String string = "Rate Change (%S/hr)";
        String string2 = "";
        if (this._functionType == 1) {
            n = Parameter.PARAMID_FLOW;
            string2 = "Reservoir Inflow (%S)";
        } else if (this._functionType == 2) {
            n = Parameter.PARAMID_FLOW;
            string2 = "Release (%S)";
        } else if (this._functionType == 3) {
            n = Parameter.PARAMID_ELEV;
            string2 = "Pool Elevation (%S)";
        }
        if (this._functionType == 0) {
            this.jReleaseTable.getScrollPane().setVisible(false);
            this.jReleasePlot.setVisible(false);
            this.jInterpLabel.setVisible(false);
            this.jInterpCombo.setVisible(false);
            this.jMaxRateChangeLbl.setVisible(true);
            this.jMaxChangeTxt.setVisible(true);
            this.spacerLabel.setVisible(true);
            return;
        }
        PairedValuesTableModel pairedValuesTableModel = (PairedValuesTableModel)this.jReleaseTable.getModel();
        String[] stringArray = new String[2];
        String[] stringArray2 = stringArray;
        stringArray[0] = string2;
        stringArray2[1] = string;
        if (pairedValues == null) {
            pairedValues = new PairedValues();
            OpRule opRule = this._currentRuleRef.getRule();
            pairedValues.setUnitSystem(opRule.getUnitSystem());
        }
        pairedValues.setParamXId(n);
        pairedValues.setParamYId(n2);
        pairedValuesTableModel.setPairedValues(pairedValues);
        this.jReleaseTable.setColumnLabels(stringArray2);
        int n3 = pairedValues.getUnitSystem();
        JVariableRateChangeFlowPanel jVariableRateChangeFlowPanel = this;
        jVariableRateChangeFlowPanel.configureFlowPlot(jVariableRateChangeFlowPanel.jReleasePlot, string2, string, n3);
        this.jReleaseTable.getScrollPane().setVisible(true);
        this.jReleasePlot.setVisible(true);
        this.jInterpLabel.setVisible(true);
        this.jInterpCombo.setVisible(true);
        this.jMaxRateChangeLbl.setVisible(false);
        this.jMaxChangeTxt.setVisible(false);
        this.spacerLabel.setVisible(false);
        Window window = SwingUtilities.windowForComponent((Component)((Object)this));
        if (window instanceof RmaJDialog) {
            ((RmaJDialog)window).updateUnitSystem((Container)((Object)this));
        } else if (window instanceof RmaJFrame) {
            ((RmaJFrame)window).updateUnitSystem((Container)((Object)this));
        }
        this.replotRateOfChangeLimit();
    }

    @Override
    public void itemStateChanged(ItemEvent object) {
        if (((ItemEvent)object).getStateChange() == 2) {
            return;
        }
        if ((object = ((EventObject)object).getSource()) == this.jInterpCombo) {
            this.setModified(true);
            this.replotRateOfChangeLimit();
            return;
        }
        if (object == this.jTypeCombo) {
            this.setModified(true);
            return;
        }
        if (object == this.jFunctionCombo) {
            this.setModified(true);
            JVariableRateChangeFlowPanel jVariableRateChangeFlowPanel = this;
            jVariableRateChangeFlowPanel.setFunctionType((String)jVariableRateChangeFlowPanel.jFunctionCombo.getSelectedItem());
        }
    }

    public void setFunctionType(String string) {
        JVariableRateChangeFlowPanel jVariableRateChangeFlowPanel = this;
        PairedValues pairedValues = jVariableRateChangeFlowPanel.saveTable(jVariableRateChangeFlowPanel._functionType);
        if (this._functionType == 1) {
            this._pvFunctionOfInflow = pairedValues;
        }
        if (this._functionType == 2) {
            this._pvFunctionOfRelease = pairedValues;
        }
        if (this._functionType == 3) {
            this._pvFunctionOfElevation = pairedValues;
        }
        if (string.equals(FUNCTION_CONSTANT_STRING)) {
            this._functionType = 0;
        }
        if (string.equals(FUNCTION_OF_INFLOW_STRING)) {
            this._functionType = 1;
        }
        if (string.equals(FUNCTION_OF_RELEASE_STRING)) {
            this._functionType = 2;
        }
        if (string.equals(FUNCTION_OF_ELEVATION_STRING)) {
            this._functionType = 3;
        }
        if (this._functionType == 1) {
            pairedValues = this._pvFunctionOfInflow;
        }
        if (this._functionType == 2) {
            pairedValues = this._pvFunctionOfRelease;
        }
        if (this._functionType == 3) {
            pairedValues = this._pvFunctionOfElevation;
        }
        JVariableRateChangeFlowPanel jVariableRateChangeFlowPanel2 = this;
        jVariableRateChangeFlowPanel2.fillFunction(jVariableRateChangeFlowPanel2._functionType, pairedValues);
    }

    public void refresh() {
    }

    public boolean savePanel() {
        int n;
        if (this._currentRuleRef == null) {
            return false;
        }
        if (this.jRuleTxt.getName() != null && this.jRuleTxt.getName().isEmpty()) {
            RMAIO.postError((Component)((Object)this), (String)"Cannot have an empty rule name!");
            return false;
        }
        RateChangeLimitOpRule rateChangeLimitOpRule = (RateChangeLimitOpRule)this._currentRuleRef.getRule();
        if (rateChangeLimitOpRule == null) {
            return false;
        }
        this._currentRuleRef.getRule().setName(this.jRuleTxt.getText());
        this._currentRuleRef.setName(this.jRuleTxt.getText());
        this._oldRuleName = this.jRuleTxt.getText();
        rateChangeLimitOpRule.setDescription(this.jRuleDescTxt.getText());
        String string = (String)this.jTypeCombo.getSelectedItem();
        if (string.equals("Increasing")) {
            rateChangeLimitOpRule.setType(1);
        } else {
            rateChangeLimitOpRule.setType(0);
        }
        string = (String)this.jFunctionCombo.getSelectedItem();
        if (string.equals(FUNCTION_OF_INFLOW_STRING)) {
            n = 1;
        } else if (string.equals(FUNCTION_OF_RELEASE_STRING)) {
            n = 2;
        } else if (string.equals(FUNCTION_OF_ELEVATION_STRING)) {
            n = 3;
        } else if (string.equals(FUNCTION_CONSTANT_STRING)) {
            n = 0;
        } else {
            return false;
        }
        rateChangeLimitOpRule.setFunctionType(n);
        if (n == 0) {
            rateChangeLimitOpRule.setMaxRateOfChange(this.jMaxChangeTxt.getParamValue());
        } else {
            this.jReleaseTable.commitEdit(true);
            PairedValuesTableModel pairedValuesTableModel = (PairedValuesTableModel)this.jReleaseTable.getModel();
            PairedValues pairedValues = new PairedValues();
            pairedValuesTableModel.storeData(pairedValues);
            if (pairedValues.size() > 1 && !pairedValues.canInterpX()) {
                JVariableRateChangeFlowPanel jVariableRateChangeFlowPanel = this;
                JOptionPane.showMessageDialog((Component)((Object)jVariableRateChangeFlowPanel), "The " + String.valueOf(jVariableRateChangeFlowPanel.jFunctionCombo.getSelectedItem()) + " values of your function must be a continuously increasing sequence.", "Error", 0);
            }
            rateChangeLimitOpRule.setChangeLimitCurve(pairedValues);
            rateChangeLimitOpRule.setInterpolationType(this.jInterpCombo.getSelectedIndex());
        }
        this.setModified(false);
        return true;
    }

    private PairedValues saveTable(int n) {
        if (n != 1 && n != 2 && n != 3) {
            return null;
        }
        this.jReleaseTable.commitEdit(true);
        PairedValuesTableModel pairedValuesTableModel = (PairedValuesTableModel)this.jReleaseTable.getModel();
        PairedValues pairedValues = new PairedValues();
        pairedValuesTableModel.storeData(pairedValues);
        return pairedValues;
    }

    private void replotRateOfChangeLimit() {
        ArrayList<SimplePairedValuesData> arrayList = new ArrayList<SimplePairedValuesData>();
        PairedValues pairedValues = new PairedValues();
        if (this._rateOfChangeLimitData == null) {
            this._rateOfChangeLimitData = JVariableRateChangeFlowPanel.a();
        }
        Object object = (PairedValuesTableModel)this.jReleaseTable.getModel();
        object.storeData(pairedValues);
        object = (String)this.jInterpCombo.getSelectedItem();
        this._rateOfChangeLimitData.setInterpolationType((String)object);
        this._rateOfChangeLimitData.setData(pairedValues);
        this._rateOfChangeLimitData.calcPlotArrays();
        this._rateOfChangeLimitData.name = "Rate of Change Limit";
        this.jReleasePlot.setVisible(false);
        arrayList.add(this._rateOfChangeLimitData);
        this.jReleasePlot.setPlotObjects(arrayList);
        this.jReleasePlot.setVisible(true);
        this.jReleasePlot.paintGfx();
    }

    private void configureFlowPlot(G2dPanel g2dPanel, String string, String string2, int n) {
        PlotDefaults plotDefaults = PlotDefaultsManager.getDefaults();
        PlotDefaultsManager.setDefaults((PlotDefaults)new HotPlotDefaults());
        G2dPanelProp g2dPanelProp = new G2dPanelProp();
        new G2dPanelProp().hasTitle = false;
        g2dPanelProp.hasToolbar = false;
        g2dPanelProp.hasLegend = false;
        G2dPlotProp g2dPlotProp = new G2dPlotProp();
        new G2dPlotProp().hasXScroll = false;
        g2dPlotProp.hasYScroll = false;
        g2dPlotProp.x1AxisProp.name = string;
        g2dPlotProp.y1AxisProp.name = string2;
        g2dPlotProp.y1AxisProp.isReversed = true;
        g2dPanelProp.addPlotProp(g2dPlotProp);
        g2dPlotProp = new SimplePairedValuesData();
        new SimplePairedValuesData().xunits = string;
        g2dPlotProp.yunits = string2;
        g2dPlotProp.setUnitSystem(n);
        g2dPlotProp.resetData();
        this._rateOfChangeLimitData = g2dPlotProp;
        g2dPanel.configurePanel(g2dPanelProp);
        PlotDefaultsManager.setDefaults((PlotDefaults)plotDefaults);
    }

    private static SimplePairedValuesData a() {
        SimplePairedValuesData simplePairedValuesData = new SimplePairedValuesData();
        new SimplePairedValuesData().xunits = "Inflow (%S)";
        simplePairedValuesData.yunits = FUNCTION_OF_RELEASE_STRING;
        PairedValues pairedValues = new PairedValues();
        pairedValues.setInterpolationType(0);
        simplePairedValuesData.resetData();
        return simplePairedValuesData;
    }

    public static void a(String[] object) {
        object = new JFrame();
        ((JFrame)object).getContentPane().setLayout(new GridBagLayout());
        ((JFrame)object).getContentPane().add((Component)((Object)new JVariableRateChangeFlowPanel()), new RmaGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
        ((Window)object).setSize(550, 500);
        ((Window)object).setVisible(true);
    }

    public void clearPanel() {
        this.jReleaseTable.clearCells();
        try {
            this.setIgnoreModifiedEvents(true);
            this.jTypeCombo.setSelectedIndex(1);
            this.jFunctionCombo.setSelectedItem((Object)FUNCTION_CONSTANT_STRING);
            this.jMaxChangeTxt.setValue(0.0);
        }
        finally {
            this.setIgnoreModifiedEvents(false);
        }
        ArrayList arrayList = new ArrayList();
        this.jReleasePlot.setPlotObjects(arrayList);
        this.jReleasePlot.paintGfx();
        this.jReleasePlot.revalidate();
    }

    public void setRuleRef(OpRuleRef opRuleRef) {
        if (opRuleRef == null) {
            return;
        }
        if (this.isModified()) {
            this.savePanel();
        }
        this._currentRuleRef = opRuleRef;
        this.fillPanel();
    }

    public void setParent(JPanel jPanel) {
        this._parent = (ElementOpsEditorPanel)((Object)jPanel);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent object) {
        if ((object = ((EventObject)object).getSource()) == this.jRuleTxt.getText()) {
            if (this.jRuleTxt.getText().isEmpty()) {
                this.jRuleTxt.setText(this._currentRuleRef.getRule().getName());
                RMAIO.postError((Component)((Object)this), (String)"Cannot have a blank Rule Name!");
                return;
            }
            this._currentRuleRef.getRule().setName(this.jRuleTxt.getText());
            this._currentRuleRef.setName(this.jRuleTxt.getText());
            this._parent.treeDataChanged(0, this._oldRuleName, this.jRuleTxt.getText());
        }
    }

    public void deselectPanel() {
        if (this.isModified()) {
            this.savePanel();
        }
    }
}

