/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.clientapp.client.ClientApp;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.G2dPanelProp;
import hec.gfx2d.G2dPlotProp;
import hec.gfx2d.HotPlotDefaults;
import hec.gfx2d.PlotDefaults;
import hec.gfx2d.PlotDefaultsManager;
import hec.gfx2d.SimplePairedValuesData;
import hec.model.PairedValues;
import hec.model.PairedValuesTableModel;
import hec.rss.client.JOperationsPanel;
import hec.rss.client.JVariableTSBasedRulePanel$1;
import hec.rss.client.JVariableTSBasedRulePanel$2;
import hec.rss.client.JVariableTSBasedRulePanel$3;
import hec.rss.client.ReservoirJFrame;
import hec.rss.client.RisingFallingCondDialog;
import hec.rss.model.OpRuleRef;
import hec.rss.model.RssSystem;
import hec.rss.model.VariableTSBasedOpRule;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.Collection;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableModel;
import rma.swing.DefaultJPanel;
import rma.swing.RmaGridBagConstraints;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDialog;
import rma.swing.RmaJDssPathPartField;
import rma.swing.RmaJTable;
import rma.swing.RmaJTextField;
import rma.swing.list.RmaListModel;
import rma.swing.print.PageText;
import rma.util.RMAIO;

public class JVariableTSBasedRulePanel
extends DefaultJPanel
implements ActionListener,
FocusListener,
ItemListener,
CellEditorListener {
    Insets INSETS5555 = new Insets(5, 5, 5, 5);
    Insets INSETS5500 = new Insets(5, 5, 0, 0);
    Insets INSETS5505 = new Insets(5, 5, 0, 5);
    Insets INSETS5550 = new Insets(5, 5, 5, 0);
    String xUnits = new String("");
    String yUnits = new String("");
    String _oldRuleName = "";
    SimplePairedValuesData _elevReleaseData = this.getElevReleaseData();
    OpRuleRef _currentRuleRef = null;
    DefaultJPanel _parent = null;
    RmaJComboBox jElementCombo = new RmaJComboBox((ComboBoxModel)new RmaListModel(false));
    RmaJComboBox jVariableCombo = new RmaJComboBox();
    RmaJComboBox jLimitCombo = new RmaJComboBox();
    RmaJComboBox jInterpCombo = new RmaJComboBox();
    RmaJTextField jRuleTxt = new RmaJDssPathPartField();
    RmaJTextField jRuleDescTxt = new RmaJTextField();
    String[] colLabels = new String[]{"Elevation (%S)", "Release (%S)"};
    boolean[] colEditable = new boolean[]{true, true};
    RmaJTable jParameterReleaseTable = new RmaJTable((Component)((Object)this));
    G2dPanel jFlowReleasePlot = new G2dPanel();
    JLabel jElementLabel = new JLabel("Element");
    JLabel jVariableLabel = new JLabel("Variable");
    JLabel jLimitLabel = new JLabel("Limit Type");
    JLabel jInterpLabel = new JLabel("Interpolation Type");
    JLabel jRuleLabel = new JLabel("Release as function of Variable");
    JLabel jDescriptionLabel = new JLabel("Description");
    JPanel jNameDescPanel = new JPanel();
    JPanel jRisingFallingOptPanel = new JPanel();
    JCheckBox jRisingFallingCheck = new JCheckBox("Apply Rising / Falling Cond");
    JButton jRisingFallingButton = new JButton("Edit");

    public JVariableTSBasedRulePanel() {
        UIManager.getColor("text");
        UIManager.getFont("TextField.font");
        this.setLayout(new GridBagLayout());
        this.jRuleTxt.setModifiable(false);
        this.jRuleTxt.setEditable(false);
        this.jNameDescPanel.setLayout(new GridBagLayout());
        this.jNameDescPanel.add((Component)this.jRuleLabel, new RmaGridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 18, 0, this.INSETS5500, 0, 0));
        this.jNameDescPanel.add((Component)this.jDescriptionLabel, new RmaGridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 18, 0, this.INSETS5500, 0, 0));
        this.jNameDescPanel.add((Component)this.jRuleTxt, new RmaGridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 18, 2, this.INSETS5500, 0, 0));
        this.jNameDescPanel.add((Component)new JLabel(), new RmaGridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 18, 2, this.INSETS5505, 0, 0));
        this.jNameDescPanel.add((Component)this.jRuleDescTxt, new RmaGridBagConstraints(1, 1, 4, 1, 1.0, 1.0, 18, 2, this.INSETS5555, 0, 0));
        JVariableTSBasedRulePanel jVariableTSBasedRulePanel = this;
        jVariableTSBasedRulePanel.add(jVariableTSBasedRulePanel.jNameDescPanel, new RmaGridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.add(jPanel, new RmaGridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.jElementLabel, new RmaGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, this.INSETS5500, 0, 0));
        jPanel.add((Component)this.jElementCombo, new RmaGridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 2, this.INSETS5505, 0, 0));
        jPanel.add((Component)this.jVariableLabel, new RmaGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, this.INSETS5500, 0, 0));
        jPanel.add((Component)this.jVariableCombo, new RmaGridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 2, this.INSETS5505, 0, 0));
        jPanel.add((Component)this.jLimitLabel, new RmaGridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, this.INSETS5500, 0, 0));
        this.jVariableCombo.addItem((Object)"Stage");
        this.jLimitCombo.addItem((Object)"Minimum Flow");
        this.jLimitCombo.addItem((Object)"Maximum Flow");
        this.jLimitCombo.addItem((Object)"Specified Flow");
        jPanel.add((Component)this.jLimitCombo, new RmaGridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 2, this.INSETS5505, 0, 0));
        jPanel.add((Component)this.jInterpLabel, new RmaGridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, this.INSETS5550, 0, 0));
        for (int i = 0; i < PairedValues.INTERP_STRINGS.length; ++i) {
            this.jInterpCombo.addItem((Object)PairedValues.INTERP_STRINGS[i]);
        }
        jPanel.add((Component)this.jInterpCombo, new RmaGridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 18, 2, this.INSETS5555, 0, 0));
        this.jParameterReleaseTable.setModel((TableModel)new PairedValuesTableModel(this.colLabels, this.colEditable));
        this.jParameterReleaseTable.setUnitsHeaderRenderer();
        this.jParameterReleaseTable.setDoubleCellEditor(0, false);
        this.jParameterReleaseTable.setDoubleCellEditor(1, false);
        this.jParameterReleaseTable.setNumRows(10);
        JVariableTSBasedRulePanel jVariableTSBasedRulePanel2 = this;
        jVariableTSBasedRulePanel2.add(jVariableTSBasedRulePanel2.jParameterReleaseTable.getScrollPane(), new RmaGridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 1, this.INSETS5550, 0, 0));
        JVariableTSBasedRulePanel jVariableTSBasedRulePanel3 = this;
        jVariableTSBasedRulePanel3.add((Component)jVariableTSBasedRulePanel3.jFlowReleasePlot, new RmaGridBagConstraints(1, 1, 1, 3, 0.0, 0.0, 12, 0, new Insets(5, 5, 5, 5), 150, 150));
        JVariableTSBasedRulePanel jVariableTSBasedRulePanel4 = this;
        jVariableTSBasedRulePanel4.configureFlowPlot(jVariableTSBasedRulePanel4.jFlowReleasePlot);
        Vector<SimplePairedValuesData> vector = new Vector<SimplePairedValuesData>();
        vector.addElement(this._elevReleaseData);
        this.jFlowReleasePlot.setPlotObjects(vector);
        this.jRisingFallingOptPanel.setLayout(new GridBagLayout());
        this.jRisingFallingOptPanel.add((Component)this.jRisingFallingCheck, new RmaGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 16, 0, new Insets(0, 5, 2, 10), 0, 0));
        this.jRisingFallingOptPanel.add((Component)this.jRisingFallingButton, new RmaGridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 16, 0, new Insets(0, 5, 2, 5), 10, 0));
        JVariableTSBasedRulePanel jVariableTSBasedRulePanel5 = this;
        jVariableTSBasedRulePanel5.add(jVariableTSBasedRulePanel5.jRisingFallingOptPanel, new RmaGridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 18, 2, INSETS0000, 0, 0));
        this.jParameterReleaseTable.addCellEditorListener((CellEditorListener)this);
        this.jRuleTxt.addFocusListener((FocusListener)this);
        this.jVariableCombo.addFocusListener((FocusListener)this);
        this.jRisingFallingButton.addActionListener(this);
        this.jInterpCombo.addItemListener((ItemListener)new JVariableTSBasedRulePanel$1(this));
        this.jLimitCombo.addItemListener((ItemListener)new JVariableTSBasedRulePanel$2(this));
        this.jElementCombo.addItemListener((ItemListener)new JVariableTSBasedRulePanel$3(this));
    }

    @Override
    public void editingCanceled(ChangeEvent changeEvent) {
    }

    @Override
    public void editingStopped(ChangeEvent changeEvent) {
        this.paramReleaseReplot();
    }

    @Override
    public void actionPerformed(ActionEvent object) {
        if ((object = ((EventObject)object).getSource()) == this.jRisingFallingButton) {
            this.risingFallingButton_ActionPerformed();
        }
    }

    public void risingFallingButton_ActionPerformed() {
        Object object = SwingUtilities.windowForComponent((Component)((Object)this));
        if (!(object instanceof ReservoirJFrame)) {
            return;
        }
        if (this._currentRuleRef == null) {
            return;
        }
        object = new RisingFallingCondDialog((Dialog)object, true);
        ((RisingFallingCondDialog)object).fillForm(this._currentRuleRef.getRule());
        object.setVisible(true);
        if (((RisingFallingCondDialog)object).isOk()) {
            this.setModified(true);
        }
    }

    public void fillPanel() {
        if (this._currentRuleRef == null) {
            return;
        }
        this.clearPanel();
        Serializable serializable = (VariableTSBasedOpRule)this._currentRuleRef.getRule();
        this._oldRuleName = serializable.getName();
        this.jRuleTxt.setText(serializable.getName());
        this.jRuleDescTxt.setText(serializable.getDescription());
        if (serializable.getLimitType() == -1) {
            this.jLimitCombo.setSelectedIndex(0);
        } else if (serializable.getLimitType() == 1) {
            this.jLimitCombo.setSelectedIndex(1);
        } else {
            this.jLimitCombo.setSelectedIndex(2);
        }
        Object object = serializable.getParameterValueRelease();
        PairedValuesTableModel pairedValuesTableModel = (PairedValuesTableModel)this.jParameterReleaseTable.getModel();
        pairedValuesTableModel.setPairedValues((PairedValues)object);
        ClientApp.app();
        object = new String("Workspace: " + ClientApp.Workspace().getTitleName());
        object = (String)object + "\n ResSim System: " + ((JOperationsPanel)this._parent)._reservoir.getSystem().getName();
        object = (String)object + "\n Reservoir: " + ((JOperationsPanel)this._parent)._reservoir.getName();
        object = (String)object + "\n Operation Set: " + ((JOperationsPanel)this._parent)._currentOpSet.getName();
        object = (String)object + "\n Elevation Release Rule: " + this._currentRuleRef.getName() + " \n ";
        object = new PageText((String)object, 0);
        this.jParameterReleaseTable.setPrintTitle((PageText)object);
        String[] stringArray = new String[2];
        object = stringArray;
        stringArray[1] = pairedValuesTableModel.getColumnName(1);
        object[0] = serializable.getParameterName();
        pairedValuesTableModel.setColumnNames((String[])object);
        this.jParameterReleaseTable.setColumnLabels((String[])object);
        this.paramReleaseReplot();
        this.jInterpCombo.setSelectedIndex(serializable.getInterpolationType());
        this.jRisingFallingCheck.removeItemListener(this);
        this.jRisingFallingCheck.setSelected(serializable.getEnableRiseFallCondition());
        this.jRisingFallingCheck.addItemListener(this);
        object = ((JOperationsPanel)this._parent)._reservoir.getSystem();
        object.getClass();
        object = (Vector)((RssSystem)object).getElementVector().clone();
        object = new RmaListModel(false, (Collection)object);
        this.jElementCombo.setModel((ComboBoxModel)object);
        this.jElementCombo.setSelectedIndex(serializable.getElementType());
        serializable = SwingUtilities.windowForComponent((Component)((Object)this));
        ((RmaJDialog)serializable).updateUnitSystem((Container)((Object)this));
        this.setModified(false);
    }

    public void clearPanel() {
        this.jInterpCombo.setSelectedIndex(0);
        this.jLimitCombo.setSelectedIndex(0);
        this.jParameterReleaseTable.clearCells();
        Vector vector = new Vector();
        this.jFlowReleasePlot.setPlotObjects(vector);
        this.jFlowReleasePlot.paintGfx();
        this.jFlowReleasePlot.revalidate();
    }

    @Override
    public void itemStateChanged(ItemEvent object) {
        if ((object = ((EventObject)object).getSource()) == this.jRisingFallingCheck) {
            this.risingFallingCheck_itemStateChanged();
        }
    }

    public void risingFallingCheck_itemStateChanged() {
        this.setModified(true);
    }

    public void refresh() {
    }

    public boolean savePanel() {
        if (this._currentRuleRef == null) {
            return false;
        }
        if (this.jRuleTxt.getText().equals("")) {
            RMAIO.postError((Component)((Object)this), (String)"Cannot have an empty rule name!");
            return false;
        }
        VariableTSBasedOpRule variableTSBasedOpRule = (VariableTSBasedOpRule)this._currentRuleRef.getRule();
        if (variableTSBasedOpRule == null) {
            return false;
        }
        this._currentRuleRef.getRule().setName(this.jRuleTxt.getText());
        this._currentRuleRef.setName(this.jRuleTxt.getText());
        this._oldRuleName = this.jRuleTxt.getText();
        variableTSBasedOpRule.setDescription(this.jRuleDescTxt.getText());
        if (this.jLimitCombo.getSelectedIndex() == 0) {
            variableTSBasedOpRule.setLimitType(-1);
        } else if (this.jLimitCombo.getSelectedIndex() == 1) {
            variableTSBasedOpRule.setLimitType(1);
        } else {
            variableTSBasedOpRule.setLimitType(0);
        }
        variableTSBasedOpRule.setInterpolationType(this.jInterpCombo.getSelectedIndex());
        this.jParameterReleaseTable.commitEdit(true);
        PairedValuesTableModel pairedValuesTableModel = (PairedValuesTableModel)this.jParameterReleaseTable.getModel();
        pairedValuesTableModel.storeData(variableTSBasedOpRule.getParameterValueRelease());
        variableTSBasedOpRule.setElementType(this.jElementCombo.getSelectedIndex());
        variableTSBasedOpRule.setEnableRiseFallCondition(this.jRisingFallingCheck.isSelected());
        this.setModified(false);
        return true;
    }

    private void paramReleaseReplot() {
        Vector<SimplePairedValuesData> vector = new Vector<SimplePairedValuesData>();
        PairedValues pairedValues = new PairedValues();
        Object object = (PairedValuesTableModel)this.jParameterReleaseTable.getModel();
        if (!(object instanceof PairedValuesTableModel)) {
            return;
        }
        object.storeData(pairedValues);
        JVariableTSBasedRulePanel jVariableTSBasedRulePanel = this;
        jVariableTSBasedRulePanel.configureFlowPlot(jVariableTSBasedRulePanel.jFlowReleasePlot);
        object = (String)this.jInterpCombo.getSelectedItem();
        this._elevReleaseData.setInterpolationType((String)object);
        object = "Elevation";
        if (this.jParameterReleaseTable != null) {
            object = this.jParameterReleaseTable.getColumnName(0);
        }
        this._elevReleaseData.yunits = object;
        this._elevReleaseData.resetData();
        this._elevReleaseData.setPlotXvsY(true);
        this._elevReleaseData.setData(pairedValues);
        vector.addElement(this._elevReleaseData);
        this.jFlowReleasePlot.setPlotObjects(vector);
        this.jFlowReleasePlot.paintGfx();
        this.jFlowReleasePlot.revalidate();
    }

    private void configureFlowPlot(G2dPanel g2dPanel) {
        PlotDefaults plotDefaults = PlotDefaultsManager.getDefaults();
        PlotDefaultsManager.setDefaults((PlotDefaults)new HotPlotDefaults());
        G2dPanelProp g2dPanelProp = new G2dPanelProp();
        new G2dPanelProp().hasTitle = false;
        g2dPanelProp.hasToolbar = false;
        g2dPanelProp.hasLegend = false;
        String string = "Elevation";
        if (this.jParameterReleaseTable != null) {
            string = this.jParameterReleaseTable.getColumnName(0);
        }
        G2dPlotProp g2dPlotProp = new G2dPlotProp();
        new G2dPlotProp().hasXScroll = false;
        g2dPlotProp.hasYScroll = false;
        g2dPlotProp.x1AxisProp.name = "Release (%S)";
        g2dPlotProp.y1AxisProp.name = string;
        g2dPlotProp.y1AxisProp.isReversed = true;
        g2dPanelProp.addPlotProp(g2dPlotProp);
        g2dPanel.configurePanel(g2dPanelProp);
        PlotDefaultsManager.setDefaults((PlotDefaults)plotDefaults);
    }

    public void setRuleRef(OpRuleRef opRuleRef) {
        if (opRuleRef == null) {
            return;
        }
        if (this.isModified()) {
            this.savePanel();
        }
        this._currentRuleRef = opRuleRef;
        this.fillPanel();
    }

    private SimplePairedValuesData getElevReleaseData() {
        SimplePairedValuesData simplePairedValuesData = new SimplePairedValuesData();
        new SimplePairedValuesData().xunits = "Release (%S)";
        String string = "Elevation";
        if (this.jParameterReleaseTable != null) {
            string = this.jParameterReleaseTable.getColumnName(0);
        }
        simplePairedValuesData.yunits = string;
        string = new PairedValues();
        string.setInterpolationType(0);
        simplePairedValuesData.setPlotXvsY(true);
        simplePairedValuesData.resetData();
        return simplePairedValuesData;
    }

    public void setParent(JPanel jPanel) {
        this._parent = (JOperationsPanel)((Object)jPanel);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent object) {
        if ((object = ((EventObject)object).getSource()) == this.jRuleTxt) {
            if (this.jRuleTxt.getText().equals("")) {
                this.jRuleTxt.setText(this._currentRuleRef.getRule().getName());
                RMAIO.postError((Component)((Object)this), (String)"Cannot have a blank Rule Name!");
                return;
            }
            this._currentRuleRef.getRule().setName(this.jRuleTxt.getText());
            this._currentRuleRef.setName(this.jRuleTxt.getText());
            ((JOperationsPanel)this._parent).treeDataChanged(0, this._oldRuleName, this.jRuleTxt.getText());
        } else if (object == this.jVariableCombo) {
            object = new String[2];
            PairedValuesTableModel pairedValuesTableModel = (PairedValuesTableModel)this.jParameterReleaseTable.getModel();
            object[1] = pairedValuesTableModel.getColumnName(1);
            object[0] = this.jVariableLabel.getText();
            pairedValuesTableModel.setColumnNames((String[])object);
            this.jParameterReleaseTable.setColumnLabels((String[])object);
            this.paramReleaseReplot();
            object = SwingUtilities.windowForComponent((Component)((Object)this));
            ((RmaJDialog)object).updateUnitSystem((Container)((Object)this));
        }
        object = (VariableTSBasedOpRule)this._currentRuleRef.getRule();
        this.jElementCombo.setSelectedIndex(((VariableTSBasedOpRule)object).getElementType());
    }

    public void deselectPanel() {
        if (this.isModified()) {
            this.savePanel();
        }
    }
}

