/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.client.IdentifierTableModel;
import hec.clientapp.client.ClientApp;
import hec.clientapp.client.ClientWorkspace;
import hec.io.Identifier;
import hec.rss.client.ManagerChooserPanel$1;
import hec.rss.client.ManagerChooserPanel$2;
import hec.rss.client.ManagerChooserPanel$SymItem;
import hec.rss.client.ManagerChooserPanel$SymText;
import hec.watershed.client.NameDescriptionPanel;
import hec.watershed.model.Condition;
import hec.watershed.model.ConditionDataList;
import hec.watershed.model.StudyDataList;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseListener;
import java.awt.event.TextEvent;
import java.io.Serializable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import javax.swing.text.Document;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaJTable;
import rma.swing.text.FilenameDocument;
import rma.util.RMAIO;
import rma.util.RMASort;

public class ManagerChooserPanel
extends JPanel
implements ButtonCmdPanelListener {
    public static final String ALL_FILTER = ".*";
    public static final String NO_CAVI_NAMES_FILTER = "^[#_a-zA-Z0-9][^:].*";
    boolean _ok = false;
    public static final int LOAD = 0;
    public static final int SAVE = 1;
    public static final int DELETE = 2;
    public static final int NEW = 3;
    public static final int OPEN = 4;
    public static final int SAVEAS = 5;
    public static final int RENAME = 6;
    public static final long USES_TABLE = 1L;
    public static final long USES_CONFIGURATION = 2L;
    public static final long UNIQUE_NAME = 4L;
    public static final long REQUIRES_CONFIGURATION = 8L;
    public static final long NO_COMMAND_BUTTONS = 128L;
    String _model;
    int _mode;
    ClientWorkspace _Workspace;
    String _className;
    String _typeName;
    String _extension = "dat";
    int _selection = -1;
    long _flags;
    protected NameDescriptionPanel _namePanel;
    IdentifierTableModel _idTableModel;
    protected RmaJTable _idTable;
    JLabel label1;
    JTextField textFieldSelectManager;
    JLabel labelWorkspace;
    JLabel labelType;
    JScrollPane _existingMangersScrollPane;
    ButtonCmdPanel panelButtons;
    private Vector _allIdVector;
    protected Pattern _pattern = Pattern.compile(".*");

    public ManagerChooserPanel(int n, long l) {
        this._mode = n;
        this._flags = l;
        this.buildDefaultComponents(2);
    }

    public ManagerChooserPanel(boolean bl) {
        this.buildDefaultComponents(1);
    }

    protected void buildDefaultComponents(int n) {
        Serializable serializable = new GridBagLayout();
        this.setLayout((LayoutManager)((Object)serializable));
        this.label1 = new JLabel("Watershed:");
        this.label1.setBounds(this.getInsets().left + 10, this.getInsets().top + 10, 76, 23);
        serializable = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        ((GridBagConstraints)serializable).gridy = 0;
        ((GridBagConstraints)serializable).anchor = 17;
        ((GridBagConstraints)serializable).fill = 0;
        ((GridBagConstraints)serializable).insets = new Insets(5, 5, 0, 0);
        ManagerChooserPanel managerChooserPanel = this;
        managerChooserPanel.add((Component)managerChooserPanel.label1, serializable);
        this.labelWorkspace = new JLabel("Watershed name");
        this.labelWorkspace.setBounds(this.getInsets().left + 91, this.getInsets().top + 10, 259, 23);
        serializable = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        ((GridBagConstraints)serializable).gridy = 0;
        ((GridBagConstraints)serializable).weightx = 1.0;
        ((GridBagConstraints)serializable).fill = 2;
        ((GridBagConstraints)serializable).insets = new Insets(5, 5, 0, 5);
        ManagerChooserPanel managerChooserPanel2 = this;
        managerChooserPanel2.add((Component)managerChooserPanel2.labelWorkspace, serializable);
        this._idTableModel = this.createDefaultTableModel(null, n);
        this._idTable = new ManagerChooserPanel$1(this);
        this._idTable.setProcessKeyEvents(false);
        this._idTable.setModel((TableModel)this._idTableModel);
        this._idTable.setRowSelectionAllowed(true);
        this._idTable.setColumnSelectionAllowed(false);
        this._idTable.setSelectionMode(0);
        this._idTable.setPopupMenuEnabled(false);
        this._idTable.setShowGrid(false);
        this._idTable.setRowHeight(20);
        this._idTable.setEditable(false);
        serializable = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        ((GridBagConstraints)serializable).gridy = 2;
        ((GridBagConstraints)serializable).gridwidth = 2;
        ((GridBagConstraints)serializable).weightx = 1.0;
        ((GridBagConstraints)serializable).weighty = 1.0;
        ((GridBagConstraints)serializable).fill = 1;
        ((GridBagConstraints)serializable).insets = new Insets(5, 5, 0, 5);
        this._existingMangersScrollPane = this._idTable.getScrollPane();
        this._existingMangersScrollPane.setVerticalScrollBarPolicy(22);
        this._existingMangersScrollPane.setHorizontalScrollBarPolicy(30);
        this._existingMangersScrollPane.setBorder(BorderFactory.createTitledBorder("Existing Managers"));
        ManagerChooserPanel managerChooserPanel3 = this;
        managerChooserPanel3.add((Component)managerChooserPanel3._existingMangersScrollPane, serializable);
        this.textFieldSelectManager = new JTextField((Document)new FilenameDocument(), "", 20);
        this.textFieldSelectManager.setBounds(this.getInsets().left + 10, this.getInsets().top + 252, 340, 23);
        serializable = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        ((GridBagConstraints)serializable).gridy = 3;
        ((GridBagConstraints)serializable).gridwidth = 2;
        ((GridBagConstraints)serializable).weightx = 1.0;
        ((GridBagConstraints)serializable).fill = 2;
        ((GridBagConstraints)serializable).insets = new Insets(5, 5, 0, 5);
        this.labelType = new JLabel("manager type");
        this.labelType.setBounds(this.getInsets().left + 91, this.getInsets().top + 38, 259, 23);
        serializable = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        ((GridBagConstraints)serializable).gridy = 1;
        ((GridBagConstraints)serializable).weightx = 1.0;
        ((GridBagConstraints)serializable).fill = 2;
        ((GridBagConstraints)serializable).insets = new Insets(5, 5, 0, 5);
        long l = 1L;
        if ((this._flags & 2L) > 0L || (this._flags & 8L) > 0L) {
            l = 5L;
        }
        this._namePanel = new NameDescriptionPanel(l);
        this._namePanel.setBorder(this.getNamePanelBorder(null));
        ClientApp.app();
        Object object = ClientApp.Workspace();
        serializable = (StudyDataList)object.getDataListContainer().getDataList("hec.watershed.model.Study");
        if (serializable != null) {
            serializable.getOpenStudy();
        } else {
            System.out.println("ManagerChooser.buildDefaultComponents: Failed to find StudyDataList");
        }
        object = (ConditionDataList)object.getDataListContainer().getDataList("hec.watershed.model.Condition");
        if (object != null) {
            object = object.getObjects();
            this._namePanel.setConfigurationList(object);
        }
        serializable = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        ((GridBagConstraints)serializable).gridy = 4;
        ((GridBagConstraints)serializable).gridwidth = 2;
        ((GridBagConstraints)serializable).weightx = 1.0;
        ((GridBagConstraints)serializable).fill = 2;
        ((GridBagConstraints)serializable).insets = new Insets(5, 5, 0, 5);
        ManagerChooserPanel managerChooserPanel4 = this;
        managerChooserPanel4.add((Component)managerChooserPanel4._namePanel, serializable);
        new ManagerChooserPanel$SymText(this);
        object = new ManagerChooserPanel$SymItem(this);
        this._idTable.getSelectionModel().addListSelectionListener((ListSelectionListener)object);
        this._idTable.addMouseListener((MouseListener)new ManagerChooserPanel$2(this));
        ManagerChooserPanel managerChooserPanel5 = this;
        managerChooserPanel5.setMode(managerChooserPanel5._mode);
        object = KeyStroke.getKeyStroke(10, 0);
        serializable = KeyStroke.getKeyStroke(27, 0);
        this._idTable.getInputMap(1).put((KeyStroke)object, "none");
        this._idTable.getInputMap(1).put((KeyStroke)object, "none");
        this._idTable.getInputMap(1).put((KeyStroke)object, "none");
        this._idTable.getInputMap(1).put((KeyStroke)serializable, "none");
        this._idTable.getInputMap(1).put((KeyStroke)serializable, "none");
        this._idTable.getInputMap(1).put((KeyStroke)serializable, "none");
        ManagerChooserPanel managerChooserPanel6 = this;
        managerChooserPanel6.setSize(managerChooserPanel6.getInsets().left + this.getInsets().right + 360, this.getInsets().top + this.getInsets().bottom + 318);
    }

    public Border getNamePanelBorder(String string) {
        String string2 = "";
        switch (this._mode) {
            case 4: {
                string2 = "Open";
                break;
            }
            case 0: {
                string2 = "Load";
                break;
            }
            case 1: {
                string2 = "Save";
                break;
            }
            case 2: {
                string2 = "Delete";
                break;
            }
            case 3: {
                string2 = "New";
                break;
            }
            case 5: {
                string2 = "Save As";
                break;
            }
            case 6: {
                string2 = "Rename";
            }
        }
        if (string != null && string.length() > 0) {
            string2 = string2.concat(" ").concat(string);
        }
        return BorderFactory.createTitledBorder(string2);
    }

    public void buttonCmdActionPerformed(ActionEvent actionEvent) {
        switch (actionEvent.getID()) {
            case 32: {
                this.buttonOpen_Action(actionEvent);
                return;
            }
            case 16: {
                this.buttonOpen_Action(actionEvent);
                return;
            }
            case 64: {
                this.buttonOpen_Action(actionEvent);
                return;
            }
            case 512: {
                this.buttonNew_Action(actionEvent);
                return;
            }
            case 4: {
                this.buttonCancel_Action(actionEvent);
                return;
            }
            case 1024: {
                this.buttonOpen_Action(actionEvent);
            }
        }
    }

    void buttonOpen_Action(ActionEvent object) {
        this._ok = true;
        object = this._idTableModel.getIdentifierAt(this._selection);
        if (object == null && this._mode != 5 && this._mode != 6) {
            JOptionPane.showMessageDialog(this, "Please select an item.", "Warning", 2);
            return;
        }
        if (this._mode == 2) {
            int n;
            if (this._selection < 0) {
                return;
            }
            object = this._namePanel.getName();
            if (((String)object).indexOf(",") >= 0) {
                StringTokenizer stringTokenizer = new StringTokenizer((String)object, ",");
                StringBuffer stringBuffer = new StringBuffer();
                while (stringTokenizer.hasMoreTokens()) {
                    stringBuffer.append(stringTokenizer.nextToken().trim());
                    if (!stringTokenizer.hasMoreTokens()) continue;
                    stringBuffer.append("<br>");
                }
                object = stringBuffer.toString();
            }
            if ((n = RMAIO.postYesNoCancelWarning((Component)this, (String)("<html>Do you really want to remove from use<br><b>" + (String)object + "</b> ?</html>"))) == 2) {
                return;
            }
            this._ok = n != 1;
        } else if (this._mode == 5 || this._mode == 6) {
            ClientApp.app();
            object = ClientApp.Workspace().getManagerIDList(this._model, this._className);
            String string = this._namePanel.getName();
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                Identifier identifier = (Identifier)((Vector)object).get(i);
                if (!identifier.getName().equals(string)) continue;
                ManagerChooserPanel managerChooserPanel = this;
                JOptionPane.showMessageDialog(managerChooserPanel, "A " + managerChooserPanel.labelType.getText() + " already exists with the name selected", "Warning", 2);
                return;
            }
        }
        this.setVisible(false);
    }

    void buttonNew_Action(ActionEvent object) {
        this._ok = true;
        object = this._namePanel.getName();
        if (object == null || ((String)object).length() == 0) {
            JOptionPane.showMessageDialog(this, "Please enter a name.", "Warning", 2);
            return;
        }
        if (!this.nameIsUnique((String)object)) {
            JOptionPane.showMessageDialog(this, "Please enter a unique name.", "Warning", 2);
            return;
        }
        if (((this._flags & 2L) > 0L || (this._flags & 8L) == 8L) && this._namePanel.getConfiguration() == null) {
            if ((this._flags & 8L) == 8L) {
                JOptionPane.showMessageDialog(this, "You have not selected a configuration.  If there are no configurations to choose from\npress the \"Cancel\" button and create one.", "Warning", 2);
                return;
            }
            int n = JOptionPane.showConfirmDialog(this, "You have not selected a configuration.  If there are no configurations to choose from\npress the \"Cancel\" button and create one. \n\nWould you like to continue without a configuration?", "Warning", 0, 2);
            if (n == 1) {
                return;
            }
        }
        this.setVisible(false);
    }

    boolean nameIsUnique(String string) {
        if (this._allIdVector != null) {
            for (int i = 0; i < this._allIdVector.size(); ++i) {
                Identifier identifier = (Identifier)this._allIdVector.get(i);
                if (!string.equalsIgnoreCase(identifier.getName())) continue;
                return false;
            }
            return true;
        }
        if (this._idTableModel == null) {
            return true;
        }
        int n = this._idTableModel.getRowCount();
        for (int i = 0; i < n; ++i) {
            String string2 = (String)this._idTableModel.getValueAt(i, 0);
            if (!string.equalsIgnoreCase(string2)) continue;
            return false;
        }
        return true;
    }

    void buttonCancel_Action(ActionEvent actionEvent) {
        this._ok = false;
        this.setVisible(false);
    }

    void textFieldSelectManager_TextValueChanged(TextEvent textEvent) {
    }

    void idTable_ItemStateChanged() {
        if (this._idTable.getSelectionModel().getSelectionMode() == 0) {
            this._selection = this._idTable.getSelectedRow();
            if (this._selection >= 0) {
                Identifier identifier = this._idTableModel.getIdentifierAt(this._selection);
                var1_1 = identifier;
                if (identifier != null) {
                    this._namePanel.setName(var1_1.getName());
                    this._namePanel.setDescription(var1_1.getDescription());
                }
            }
        } else {
            var1_1 = this._idTable.getSelectedRows();
            if (var1_1 == null || ((int[])var1_1).length == 0) {
                this._selection = -1;
            } else {
                this._selection = var1_1[0];
                String string = "";
                for (int i = 0; i < ((int[])var1_1).length; ++i) {
                    Identifier identifier = this._idTableModel.getIdentifierAt(var1_1[i]);
                    if (identifier == null) continue;
                    string = string.concat(identifier.getName());
                    if (i >= ((int[])var1_1).length - 1) continue;
                    string = string.concat(", ");
                }
                this._namePanel.setName(string);
                if (((int[])var1_1).length == 1) {
                    this._namePanel.setDescription(this._idTableModel.getIdentifierAt(var1_1[0]).getDescription());
                } else {
                    this._namePanel.setDescription("");
                }
            }
        }
        int n = -1;
        boolean bl = this._selection != -1;
        switch (this._mode) {
            case 1: {
                n = 16;
                break;
            }
            case 0: {
                n = 32;
                break;
            }
            case 2: {
                n = 64;
            }
        }
        if (n != -1) {
            this.panelButtons.setButtonEnable(n, bl);
        }
    }

    public boolean ok() {
        return this._ok;
    }

    public void setMode(int n) {
        this._mode = n;
        if (this.panelButtons != null) {
            ManagerChooserPanel managerChooserPanel = this;
            managerChooserPanel.remove((Component)managerChooserPanel.panelButtons);
            this.panelButtons.removeCmdPanelListener((ButtonCmdPanelListener)this);
        }
        switch (this._mode) {
            case 6: {
                this._idTable.setIsEditable(false);
                this.panelButtons = new ButtonCmdPanel(1028);
                this._namePanel.setPanelEditable(true);
                break;
            }
            case 5: {
                this._idTable.setIsEditable(false);
            }
            case 1: {
                this.panelButtons = new ButtonCmdPanel(20);
                this._namePanel.setPanelEditable(true);
                break;
            }
            case 0: 
            case 4: {
                this.panelButtons = new ButtonCmdPanel(36);
                this._namePanel.setPanelEditable(false);
                break;
            }
            case 2: {
                this.panelButtons = new ButtonCmdPanel(68);
                this._namePanel.setPanelEditable(false);
                break;
            }
            case 3: {
                this.panelButtons = new ButtonCmdPanel(516);
                this._namePanel.setPanelEditable(true);
            }
        }
        if ((this._flags & 0x80L) <= 0L) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            new GridBagConstraints().gridx = 0;
            gridBagConstraints.gridy = 7;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            ManagerChooserPanel managerChooserPanel = this;
            managerChooserPanel.add((Component)managerChooserPanel.panelButtons, gridBagConstraints);
            this.panelButtons.addCmdPanelListener((ButtonCmdPanelListener)this);
        }
    }

    public void setMultipleSelectionsAllowed(boolean bl) {
        if (bl) {
            this._idTable.setSelectionMode(2);
            return;
        }
        this._idTable.setSelectionMode(0);
    }

    public void setManagerType(String string, String string2, String string3) {
        this._model = string;
        this.setManagerType(string, string2, string3, "dat");
    }

    public void setManagerType(String object, String string, String string2, String string3) {
        this._model = object;
        this._className = string;
        this._extension = string3;
        this.labelWorkspace.setText(ClientApp.Workspace().getTitleName());
        this.labelType.setText(string2);
        if (this._existingMangersScrollPane != null) {
            object = "Existing ";
            if (string2 != null && string2.length() > 0) {
                object = (String)object + string2 + "s";
            }
            ((TitledBorder)this._existingMangersScrollPane.getBorder()).setTitle((String)object);
        }
        if (this._namePanel != null) {
            this._namePanel.setBorder(this.getNamePanelBorder(string2));
        }
        if ((object = ClientApp.Workspace().getManagerIDList(this._model, string)) == null) {
            return;
        }
        this._allIdVector = object;
        RMASort.quickSort((List)object);
        object = this.filterIdVector((Vector)object);
        if (this._idTableModel != null) {
            this._idTableModel.setIdentifierList((Vector)object);
        }
    }

    protected Vector filterIdVector(Vector vector) {
        if (this._pattern == null) {
            return vector;
        }
        Vector<Identifier> vector2 = new Vector<Identifier>(vector.size());
        for (int i = 0; i < vector.size(); ++i) {
            Identifier identifier = (Identifier)vector.get(i);
            if (!this._pattern.matcher(identifier.getName()).matches()) continue;
            vector2.add(identifier);
        }
        return vector2;
    }

    public Identifier getIdentifier() {
        switch (this._mode) {
            case 0: 
            case 2: {
                if (this._selection < 0) break;
                return this._idTableModel.getIdentifierAt(this._selection);
            }
            case 3: {
                Identifier identifier = new Identifier();
                identifier.setName(this._namePanel.getName());
                identifier.setDescription(this._namePanel.getDescription());
                return identifier;
            }
            case 4: {
                if (this._selection >= 0) {
                    return this._idTableModel.getIdentifierAt(this._selection);
                }
                return null;
            }
            case 1: {
                String string = this.textFieldSelectManager.getText();
                if (string == null || string.length() <= 0) {
                    return null;
                }
                return ClientApp.Workspace().getManagerIdentifier(this._model, this._className, string, this._extension);
            }
            case 6: {
                String string = this._namePanel.getName();
                if (string == null || string.length() <= 0) {
                    return null;
                }
                ClientApp.app();
                string = ClientApp.Workspace().getManagerIdentifier(this._model, this._className, string, this._extension);
                string.setDescription(this._namePanel.getDescription());
                return string;
            }
            case 5: {
                Identifier identifier = new Identifier();
                identifier.setName(this._namePanel.getName());
                identifier.setDescription(this._namePanel.getDescription());
                if (this._selection >= 0) {
                    Identifier identifier2 = this._idTableModel.getIdentifierAt(this._selection);
                    identifier.setPath(identifier2.getPath());
                }
                return identifier;
            }
        }
        return null;
    }

    public Vector getIdentifierList() {
        Vector<Identifier> vector = new Vector<Identifier>();
        if (this._idTable.getSelectionModel().getSelectionMode() == 0) {
            Identifier identifier = this.getIdentifier();
            if (identifier != null) {
                vector.add(identifier);
            }
        } else {
            int[] nArray = this._idTable.getSelectedRows();
            if (nArray != null && nArray.length > 0) {
                for (int i = 0; i < nArray.length; ++i) {
                    vector.add(this._idTableModel.getIdentifierAt(nArray[i]));
                }
            }
        }
        return vector;
    }

    public Vector getTableIdentifierList() {
        Vector<Identifier> vector = new Vector<Identifier>();
        int n = this._idTable.getNumRows();
        for (int i = 0; i < n; ++i) {
            Identifier identifier = this._idTableModel.getIdentifierAt(i);
            if (!(identifier instanceof Identifier)) continue;
            vector.add(identifier);
        }
        return vector;
    }

    public Condition getConfiguration() {
        if ((this._flags & 2L) > 0L || (this._flags & 8L) > 0L) {
            return this._namePanel.getConfiguration();
        }
        return null;
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            if ((this._mode == 0 || this._mode == 4) && this._idTable.getRowCount() > 0) {
                this._idTable.updateSelection(0, 0, false, false);
            }
            if ((this._flags & 8L) == 8L && this._namePanel.getConfigurationList().size() == 0) {
                ManagerChooserPanel managerChooserPanel = this;
                JOptionPane.showMessageDialog(managerChooserPanel, "There are no Configurations. " + managerChooserPanel.labelType.getText() + " Requires that a Configuration be selected.\nPlease create one.", "Warning", 2);
                return;
            }
        }
        super.setVisible(bl);
    }

    protected IdentifierTableModel createDefaultTableModel(Vector vector, int n) {
        return new IdentifierTableModel(vector, n);
    }

    @Override
    public void setName(String string) {
        this._namePanel.setName(string);
    }

    public void setDescription(String string) {
        this._namePanel.setDescription(string);
    }

    public void setAccessoryPanel(JPanel jPanel) {
        this.setAccessoryPanel(jPanel, 3);
    }

    public void setAccessoryPanel(JPanel jPanel, int n) {
        if (jPanel == null) {
            return;
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)jPanel, gridBagConstraints);
    }

    public void setNameFilter(String string) {
        if (string == null) {
            this._pattern = Pattern.compile(ALL_FILTER);
            return;
        }
        try {
            this._pattern = Pattern.compile(string);
            return;
        }
        catch (Exception exception) {
            System.out.println("setNameFilter: Error compiling filter " + string);
            this._pattern = Pattern.compile(ALL_FILTER);
            return;
        }
    }

    public void setNameDocument(Document document) {
        this._namePanel.setNameDocument(document);
    }
}

