/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import com.google.common.flogger.FluentLogger;
import hec.rss.client.NetworkConversionMessage$NetworkChangeStatus;
import hec.rss.client.RSS;
import hec.rss.model.RssSystem;
import java.awt.Component;
import javax.swing.JOptionPane;

public class NetworkConversionMessage {
    private static final FluentLogger a = FluentLogger.forEnclosingClass();
    public static final String SAVE_NETWORK_ON_OPEN_MSG = "<html><b>WARNING</b>: The Reservoir Network, <b>%s</b> (last saved with version %s), has been updated to include new features and enhancements in the current ResSim version %s.<br>Saving the revised network will make it incompatible with older versions of ResSim, potentially leading to irreversible data loss.<br><br>Proceed with caution and ensure you are using the appropriate ResSim version before saving.<br>Selecting Continue Without Saving incurs the risk of accidental or auto-saves. ";

    public static NetworkConversionMessage$NetworkChangeStatus a(RssSystem object) {
        if (object != null && ((RssSystem)object).didConversionOccur()) {
            Object[] objectArray = new String[]{"Save Now", "Continue Without Saving"};
            if (RSS.frame() != null && RSS.frame().isVisible()) {
                String string = ((RssSystem)object).getLastSavedInResSimVersion();
                if (string.startsWith("6") && string.endsWith("R")) {
                    string = "a version prior to HEC-ResSim v3.5";
                }
                object = String.format(SAVE_NETWORK_ON_OPEN_MSG, object.getName(), string, RSS.getResSimVersion());
                int n = JOptionPane.showOptionDialog((Component)RSS.frame(), object, "Confirm Conversion", 0, 2, null, objectArray, objectArray[1]);
                if (n == 0) {
                    return NetworkConversionMessage$NetworkChangeStatus.ShouldBeSaved;
                }
                return NetworkConversionMessage$NetworkChangeStatus.DoNoSave;
            }
            ((FluentLogger.Api)a.atInfo()).log("The reservoir network: %s has been updated to conform with several new enhancements and features.", (Object)object.getName());
        }
        return NetworkConversionMessage$NetworkChangeStatus.NoSaveNeeded;
    }
}

