/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.clientapp.client.ClientApp;
import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.io.HecFile;
import hec.io.Identifier;
import hec.lang.NamedType;
import hec.model.Node;
import hec.model.PairedValues;
import hec.model.PairedValuesExt;
import hec.model.StreamElement;
import hec.model.StreamSegment;
import hec.rss.client.RSimSimulationMode;
import hec.rss.model.AdjustableFlow;
import hec.rss.model.AdjustableParameter;
import hec.rss.model.Dam;
import hec.rss.model.DiversionElement;
import hec.rss.model.DivertedOutletElement;
import hec.rss.model.Element;
import hec.rss.model.Function;
import hec.rss.model.Junction;
import hec.rss.model.JunctionElement;
import hec.rss.model.PowerPlantFlow;
import hec.rss.model.PumpFlow;
import hec.rss.model.ReachElement;
import hec.rss.model.ReservoirDamElement;
import hec.rss.model.ReservoirElement;
import hec.rss.model.RssNode;
import hec.rss.model.RssSystem;
import hec.rss.model.Spillway;
import hec.rss.model.Storage;
import hec.rss.model.StorageTableModel;
import hec.rss.model.TailwaterElevation;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import rma.util.RMAConst;
import rma.util.RMAIO;

public class NetworkReport {
    private RssSystem a;
    private Identifier b;

    public NetworkReport(RssSystem rssSystem, Identifier identifier) {
        this.a = rssSystem;
        this.b = identifier;
    }

    /*
     * Loose catch block
     */
    public boolean a() {
        block15: {
            int n;
            HecFile hecFile = this.b.getFile();
            if (hecFile == null) {
                System.out.println("writeReport:no file for " + String.valueOf(this.b));
                return false;
            }
            BufferedWriter bufferedWriter = hecFile.getBufferedWriter();
            Vector vector = this.a.getElementVector();
            vector = (Vector)vector.clone();
            List<JunctionElement> list = this.a.getHeadwaterJunctions();
            Object object = bufferedWriter;
            ((Writer)object).write("#JNC:Junction Name,Stream Name, Stream Station, IN, OUT");
            ((BufferedWriter)object).newLine();
            ((Writer)object).write("#RCH:Reach Name,Stream Name,Inflow Stream Station,Outflow Stream Station, IN, OUT");
            ((BufferedWriter)object).newLine();
            ((Writer)object).write("#DIV:Diversion Name,Inflow Stream Name,Inflow Stream Station,Outflow Stream Name, Outflow Stream Station");
            ((BufferedWriter)object).newLine();
            ((Writer)object).write("#RES:Reservoir Name,# Streams, Stream Name,Inflow Stream Station,Outflow Stream Station, ...");
            ((BufferedWriter)object).newLine();
            ((Writer)object).write("#RES:POOL:Reservoir Name:IN,OUT");
            ((BufferedWriter)object).newLine();
            ((Writer)object).write("#   Elevation      Storage         Area");
            ((BufferedWriter)object).newLine();
            ((Writer)object).write("#RES:DAM:Reservoir Name,Dam name,Stream Name,Stream Station,Dam Height,Dam Width,units");
            ((BufferedWriter)object).newLine();
            ((Writer)object).write("#RES:SPILL:Reservoir Name,SpillwayName,Elevation:1,Wier Coef,length,units");
            ((BufferedWriter)object).newLine();
            ((Writer)object).write("#  or ");
            ((BufferedWriter)object).newLine();
            ((Writer)object).write("#RES:SPILL:Reservoir Name,SpillwayName,Elevation:2,units");
            ((BufferedWriter)object).newLine();
            ((Writer)object).write("#   Elevation     Outflow");
            ((BufferedWriter)object).newLine();
            ((Writer)object).write("#RES:TWELEV:Reservoir Name,Power Plant Tailwater name,Constant Elevation,0,units");
            ((BufferedWriter)object).newLine();
            ((Writer)object).write("#  or ");
            ((BufferedWriter)object).newLine();
            ((Writer)object).write("#RES:TWELEV:Reservoir Name,Power Plant Tailwater name,Constant Elevation,1,units");
            ((BufferedWriter)object).newLine();
            ((Writer)object).write("#       Stage    Discharge");
            ((BufferedWriter)object).newLine();
            ((Writer)object).write("#RES:POWER:Reservoir Name,Power Plant Name,Gate Count,max rate of increase,max rate of decrease,units");
            ((BufferedWriter)object).newLine();
            ((Writer)object).write("#   Elevation     Capacity");
            ((BufferedWriter)object).newLine();
            ((Writer)object).write("#RES:PWRTW:Reservoir Name,Power Plant Tailwater name,Constant Elevation,0,units");
            ((BufferedWriter)object).newLine();
            ((Writer)object).write("#  or ");
            ((BufferedWriter)object).newLine();
            ((Writer)object).write("#RES:PWRTW:Reservoir Name,Power Plant Tailwater name,Constant Elevation,1,units");
            ((BufferedWriter)object).newLine();
            ((Writer)object).write("#       Stage    Discharge");
            ((BufferedWriter)object).newLine();
            ((Writer)object).write("#RES:OUTLET:Reservoir Name,Outlet Name,Gate Count,Max Rate of Increase,Max Rate of Decrease,units");
            ((BufferedWriter)object).newLine();
            ((Writer)object).write("#   Elevation     Capacity");
            ((BufferedWriter)object).newLine();
            ((Writer)object).write("#RES:PUMP:Reservoir Name,Pump Name,number of pumps,capacity,units");
            ((BufferedWriter)object).newLine();
            ((Writer)object).write("#   Elevation         Head");
            ((BufferedWriter)object).newLine();
            ((Writer)object).write("#RES:DAM:Reservoir Name, Dam Name,END");
            ((BufferedWriter)object).newLine();
            ((Writer)object).write("#RES:DIVOUT:Reservoir Name,Diverted Outlet Name");
            ((BufferedWriter)object).newLine();
            ((Writer)object).write("#RES:DIVOUT:Reservoir Name, Diverted OutletName,END");
            ((BufferedWriter)object).newLine();
            ((Writer)object).write("#RES:Reservoir Name,END");
            ((BufferedWriter)object).newLine();
            ((Writer)object).write("#SIM:ResSim Simulation Name used in F Part,END");
            ((BufferedWriter)object).newLine();
            ((Writer)object).write("#DSS:ResSim DSS pathname,END");
            ((BufferedWriter)object).newLine();
            object = bufferedWriter;
            if (ClientApp.frame().getCurrentModule() instanceof RSimSimulationMode && ((RSimSimulationMode)ClientApp.frame().getCurrentModule())._activeSimRun != null) {
                String string = ((RSimSimulationMode)ClientApp.frame().getCurrentModule())._activeSimRun.getRssAlt()._name;
                string = string.substring(0, 11);
                ((Writer)object).write("SIM:" + string + ",END");
                ((BufferedWriter)object).newLine();
                string = ((RSimSimulationMode)ClientApp.frame().getCurrentModule()).getDSSFilename();
                ((Writer)object).write("DSS:" + string + ",END");
                ((BufferedWriter)object).newLine();
            }
            for (n = 0; n < list.size(); ++n) {
                object = list.get(n);
                if (!vector.contains(object)) continue;
                vector.remove(object);
                NetworkReport.a((JunctionElement)object, bufferedWriter);
                object = this.a.getDownstreamElements((Element)object);
                Iterator iterator = ((Vector)object).iterator();
                while (iterator.hasNext()) {
                    object = (Element)iterator.next();
                    if (!vector.contains(object)) continue;
                    this.a((Element)object, bufferedWriter);
                    vector.remove(object);
                }
            }
            bufferedWriter.write("#");
            bufferedWriter.newLine();
            for (n = 0; n < vector.size(); ++n) {
                object = (Element)vector.get(n);
                this.a((Element)object, bufferedWriter);
            }
            try {
                bufferedWriter.close();
            }
            catch (IOException iOException) {}
            break block15;
            catch (IOException iOException) {
                try {
                    System.out.println("writeReport:IOError writing " + hecFile.getPath() + " Error:" + String.valueOf(iOException));
                }
                catch (Throwable throwable) {
                    try {
                        bufferedWriter.close();
                    }
                    catch (IOException iOException2) {}
                    throw throwable;
                }
                try {
                    bufferedWriter.close();
                }
                catch (IOException iOException3) {}
                return false;
            }
        }
        return true;
    }

    private void a(Element element, BufferedWriter bufferedWriter) throws IOException {
        if (element instanceof JunctionElement) {
            NetworkReport.a((JunctionElement)element, bufferedWriter);
            return;
        }
        if (element instanceof ReachElement) {
            NetworkReport.a((ReachElement)element, bufferedWriter);
            return;
        }
        if (element instanceof DiversionElement) {
            NetworkReport.a((DiversionElement)element, bufferedWriter);
            return;
        }
        if (element instanceof ReservoirElement) {
            this.a((ReservoirElement)element, bufferedWriter);
        }
    }

    private void a(ReservoirElement reservoirElement, BufferedWriter bufferedWriter) throws IOException {
        Object object;
        Vector<StreamSegment> vector = reservoirElement.getStreamSegmentVector();
        bufferedWriter.write("RES:" + reservoirElement.getName() + "," + vector.size());
        Object object2 = "";
        Object object3 = "";
        Object object4 = reservoirElement.getNodeVector();
        Vector vector2 = reservoirElement.getNodeDirVector();
        if (object4 != null && ((Vector)object4).size() > 0) {
            for (int i = 0; i < ((Vector)object4).size(); ++i) {
                object = (RssNode)((Vector)object4).get(i);
                int n = (Integer)vector2.get(i);
                if (n == 1) {
                    object2 = (String)object2 + Integer.toString(object.getIndex()) + ",";
                    continue;
                }
                object3 = (String)object3 + Integer.toString(object.getIndex()) + ",";
            }
        }
        for (int i = 0; i < vector.size(); ++i) {
            double d;
            double d2;
            object = vector.get(i);
            StreamElement streamElement = object.stream;
            if (streamElement != null) {
                object4 = streamElement.getName();
                d2 = RMAConst.isUndefinedValue((double)object.upstreamStation) ? streamElement.getStationByCoord(object.upstreamCoord) : object.upstreamStation;
                d = RMAConst.isUndefinedValue((double)object.downstreamStation) ? streamElement.getStationByCoord(object.downstreamCoord) : object.downstreamStation;
            } else {
                object4 = object.streamName;
                d = object.downstreamStation;
                d2 = object.upstreamStation;
            }
            if (object4 == null) {
                object4 = "unknown";
            }
            bufferedWriter.write("," + (String)object4 + "," + RMAIO.setPrecision2((double)d2, (int)3) + "," + RMAIO.setPrecision2((double)d, (int)3));
        }
        bufferedWriter.newLine();
        Vector vector3 = reservoirElement.getElementVector();
        int n = this.a.getUnitSystem();
        String string = Parameter.getUnitsStringForSystem((int)Parameter.PARAMID_ELEV, (int)n);
        for (int i = 0; i < vector3.size(); ++i) {
            NamedType namedType;
            Object object5 = (Element)vector3.get(i);
            if (object5 instanceof ReservoirDamElement) {
                namedType = (ReservoirDamElement)object5;
                object = namedType.getDownstreamNode();
                Dam dam = namedType.getDamFunction();
                bufferedWriter.write("RES:DAM:" + reservoirElement.getName() + "," + namedType.getName() + "," + object.getStreamName() + "," + RMAIO.setPrecision2((double)object.getStreamStation(), (int)3) + "," + dam.getTopOfDam() + "," + dam.getWidthOfDam() + "," + string);
                bufferedWriter.newLine();
                object5 = ((Element)object5).getElementVector();
                System.out.println("writeReservoir:res=" + reservoirElement.getName());
                this.a(reservoirElement, (Vector)object5, bufferedWriter);
                bufferedWriter.write("RES:DAM:" + reservoirElement.getName() + namedType.getName() + ",END");
                bufferedWriter.newLine();
                continue;
            }
            if (((Element)object5).getFunction() instanceof Storage) {
                namedType = (Storage)((Element)object5).getFunction();
                ((Storage)namedType).getCapacityVector();
                bufferedWriter.write("RES:POOL:" + reservoirElement.getName() + ",IN," + (String)object2 + "OUT," + (String)object3);
                bufferedWriter.newLine();
                this.a((Storage)namedType, bufferedWriter);
                continue;
            }
            if (object5 instanceof DivertedOutletElement) {
                namedType = (DivertedOutletElement)object5;
                this.a((DivertedOutletElement)namedType, reservoirElement, bufferedWriter);
                continue;
            }
            System.out.println("writeReservoir:kid=" + String.valueOf(object5));
        }
        bufferedWriter.write("RES:" + reservoirElement.getName() + ",END");
        bufferedWriter.newLine();
    }

    private void a(DivertedOutletElement divertedOutletElement, ReservoirElement reservoirElement, BufferedWriter bufferedWriter) throws IOException {
        bufferedWriter.write("RES:DIVOUT:" + reservoirElement.getName() + "," + divertedOutletElement.getName());
        bufferedWriter.newLine();
        Vector vector = divertedOutletElement.getElementVector();
        this.a(reservoirElement, vector, bufferedWriter);
        bufferedWriter.write("RES:DIVOUT:" + reservoirElement.getName() + "," + divertedOutletElement.getName() + ",END");
        bufferedWriter.newLine();
    }

    private void a(ReservoirElement reservoirElement, Vector vector, BufferedWriter bufferedWriter) throws IOException {
        for (int i = 0; i < vector.size(); ++i) {
            Object object = (Element)vector.get(i);
            NamedType namedType = ((Element)object).getFunction();
            if (namedType instanceof Spillway) {
                int n = this.a.getUnitSystem();
                String string = Parameter.getUnitsStringForSystem((int)Parameter.PARAMID_AREA, (int)n);
                namedType = (Spillway)namedType;
                double d = namedType.getTopOfDam();
                bufferedWriter.write("RES:SPILL:" + reservoirElement.getName() + ",," + namedType.getName() + "," + RMAIO.setPrecision2((double)d, (int)1));
                int n2 = namedType.getSpillFunctionType();
                if (n2 == 0) {
                    bufferedWriter.write("," + string + ",1," + RMAIO.setPrecision2((double)namedType.getWeirCoef(), (int)1) + "," + RMAIO.setPrecision2((double)namedType.getWidthOfDam(), (int)1));
                    bufferedWriter.newLine();
                    continue;
                }
                bufferedWriter.write(",2");
                bufferedWriter.write("," + string);
                bufferedWriter.newLine();
                bufferedWriter.write(RMAIO.leftJustify((int)12, (String)"Elevation").toString());
                bufferedWriter.write(RMAIO.leftJustify((int)12, (String)"Outflow").toString());
                bufferedWriter.newLine();
                string = Parameter.getUnitsStringForSystem((int)Parameter.PARAMID_ELEV, (int)n);
                bufferedWriter.write(RMAIO.leftJustify((int)12, (String)string).toString());
                bufferedWriter.write(" ");
                string = Parameter.getUnitsStringForSystem((int)Parameter.PARAMID_FLOW, (int)n);
                bufferedWriter.write(RMAIO.leftJustify((int)12, (String)string).toString());
                bufferedWriter.newLine();
                object = namedType.getElevOutflowValues();
                bufferedWriter.write(object.toTableForm(1));
                continue;
            }
            if (namedType instanceof PowerPlantFlow) {
                PowerPlantFlow powerPlantFlow = (PowerPlantFlow)namedType;
                int n = powerPlantFlow.getGateCount();
                bufferedWriter.write("RES:POWER:" + reservoirElement.getName() + "," + powerPlantFlow.getName() + "," + n + ",");
                this.a(powerPlantFlow, bufferedWriter);
                namedType = powerPlantFlow.getTailwaterElevation();
                if (!powerPlantFlow.hasTailElev() || namedType == null || !namedType.usesConstElev() && !namedType.usesRatingCurveElev()) continue;
                bufferedWriter.write("RES:PWRTW:" + reservoirElement.getName() + "," + powerPlantFlow.getName() + ",");
                this.a((TailwaterElevation)namedType, bufferedWriter);
                continue;
            }
            if (namedType instanceof PumpFlow) {
                int n = this.a.getUnitSystem();
                PumpFlow pumpFlow = (PumpFlow)namedType;
                namedType = pumpFlow.getPump();
                int n3 = namedType.getNumberOfPumps();
                double d = namedType.getPumpCapacityConstant();
                bufferedWriter.write("RES:PUMP:" + reservoirElement.getName() + "," + object.getName() + "," + n3 + "," + RMAIO.setPrecision2((double)d, (int)1));
                object = Parameter.getUnitsStringForSystem((int)Parameter.PARAMID_FLOW, (int)n);
                bufferedWriter.write("," + (String)object);
                bufferedWriter.newLine();
                namedType = namedType.getOperatingLimitFunction();
                bufferedWriter.write(RMAIO.leftJustify((int)12, (String)"Elevation").toString());
                bufferedWriter.write(" ");
                bufferedWriter.write(RMAIO.leftJustify((int)12, (String)"Head").toString());
                bufferedWriter.newLine();
                object = Parameter.getUnitsStringForSystem((int)Parameter.PARAMID_ELEV, (int)n);
                bufferedWriter.write(RMAIO.leftJustify((int)12, (String)object).toString());
                bufferedWriter.write(" ");
                object = Parameter.getUnitsStringForSystem((int)Parameter.PARAMID_ELEV, (int)n);
                bufferedWriter.write(RMAIO.leftJustify((int)12, (String)object).toString());
                bufferedWriter.newLine();
                bufferedWriter.write(namedType.toTableForm(2));
                if (!pumpFlow.hasTailElev() || (object = pumpFlow.getTailwaterElevation()) == null || !((TailwaterElevation)object).usesConstElev() && !((TailwaterElevation)object).usesRatingCurveElev()) continue;
                bufferedWriter.write("RES:PMPTW:" + reservoirElement.getName() + "," + pumpFlow.getName() + ",");
                this.a((TailwaterElevation)object, bufferedWriter);
                continue;
            }
            if (namedType instanceof AdjustableFlow) {
                AdjustableFlow adjustableFlow = (AdjustableFlow)namedType;
                int n = adjustableFlow.getGateCount();
                bufferedWriter.write("RES:OUTLET:" + reservoirElement.getName() + "," + object.getName() + "," + n + ",");
                this.a(adjustableFlow, bufferedWriter);
                continue;
            }
            if (namedType instanceof Junction) {
                Junction junction = (Junction)namedType;
                if (!junction.hasTailElev()) continue;
                TailwaterElevation tailwaterElevation = junction.getTailwaterElevation();
                bufferedWriter.write("RES:TWELEV:" + reservoirElement.getName() + "," + ((Element)object).toString() + ",");
                this.a(tailwaterElevation, bufferedWriter);
                continue;
            }
            System.out.println("writeReservoir:damkid=" + String.valueOf(object) + " cls=" + object.getClass().getName() + " func=" + (namedType != null ? namedType.getClass().getName() : "none"));
        }
    }

    private void a(TailwaterElevation object, BufferedWriter bufferedWriter) throws IOException {
        Object object2;
        int n = this.a.getUnitSystem();
        if (((TailwaterElevation)object).usesConstElev()) {
            object2 = new ParamDouble();
            ((TailwaterElevation)object).getConstElev((ParamDouble)object2);
            bufferedWriter.write(RMAIO.setPrecision2((double)object2.getValue(), (int)3));
        } else {
            bufferedWriter.write(" ");
        }
        bufferedWriter.write(",");
        if (((TailwaterElevation)object).usesRatingCurveElev()) {
            object2 = ((TailwaterElevation)object).getRatingCurve();
            if (object2.size() > 0) {
                bufferedWriter.write("1,");
                object = Parameter.getUnitsStringForSystem((int)Parameter.PARAMID_ELEV, (int)n);
                bufferedWriter.write((String)object);
                bufferedWriter.newLine();
                bufferedWriter.write(RMAIO.leftJustify((int)12, (String)"Stage").toString());
                bufferedWriter.write(" ");
                bufferedWriter.write(RMAIO.leftJustify((int)12, (String)"Discharge").toString());
                bufferedWriter.newLine();
                object = Parameter.getUnitsStringForSystem((int)Parameter.PARAMID_STAGE, (int)n);
                bufferedWriter.write(RMAIO.leftJustify((int)12, (String)object).toString());
                bufferedWriter.write(" ");
                object = Parameter.getUnitsStringForSystem((int)Parameter.PARAMID_FLOW, (int)n);
                bufferedWriter.write(RMAIO.leftJustify((int)12, (String)object).toString());
                bufferedWriter.newLine();
                bufferedWriter.write(object2.toTableForm(3));
                bufferedWriter.newLine();
            } else {
                bufferedWriter.write("0,");
                object = Parameter.getUnitsStringForSystem((int)Parameter.PARAMID_ELEV, (int)n);
                bufferedWriter.write((String)object);
            }
        } else {
            bufferedWriter.write("0,");
            object2 = Parameter.getUnitsStringForSystem((int)Parameter.PARAMID_ELEV, (int)n);
            bufferedWriter.write((String)object2);
        }
        bufferedWriter.newLine();
    }

    private void a(AdjustableFlow adjustableFlow, BufferedWriter bufferedWriter) throws IOException {
        int n;
        AdjustableParameter adjustableParameter = ((Function)adjustableFlow).findAdjParam("Flow");
        double d = adjustableParameter.getMaxRateOfIncrease();
        if (RMAConst.isValidValue((double)d)) {
            bufferedWriter.write(RMAIO.setPrecision2((double)d, (int)2));
        } else {
            bufferedWriter.write(" ");
        }
        bufferedWriter.write(",");
        double d2 = adjustableParameter.getMaxRateOfDecrease();
        if (RMAConst.isValidValue((double)d2)) {
            bufferedWriter.write(RMAIO.setPrecision2((double)d2, (int)2));
        } else {
            bufferedWriter.write(" ");
        }
        bufferedWriter.write(",");
        int n2 = this.a.getUnitSystem();
        String string = Parameter.getUnitsStringForSystem((int)Parameter.PARAMID_FLOW, (int)n2);
        bufferedWriter.write(string + "/hr");
        bufferedWriter.newLine();
        if (!adjustableFlow.hasMultipleGateSettings()) {
            PairedValues pairedValues = adjustableFlow.getCapacityValues();
            if (pairedValues != null) {
                bufferedWriter.write(RMAIO.leftJustify((int)12, (String)"Elevation").toString());
                bufferedWriter.write(" ");
                bufferedWriter.write(RMAIO.leftJustify((int)12, (String)"Capacity").toString());
                bufferedWriter.newLine();
                string = Parameter.getUnitsStringForSystem((int)Parameter.PARAMID_ELEV, (int)n2);
                bufferedWriter.write(RMAIO.leftJustify((int)12, (String)string).toString());
                bufferedWriter.write(" ");
                string = Parameter.getUnitsStringForSystem((int)Parameter.PARAMID_FLOW, (int)n2);
                bufferedWriter.write(RMAIO.leftJustify((int)12, (String)string).toString());
                bufferedWriter.newLine();
                bufferedWriter.write(pairedValues.toTableForm(1));
            }
            return;
        }
        double[] dArray = adjustableFlow.getGateSettings();
        bufferedWriter.write(RMAIO.leftJustify((int)12, (String)"Elevation").toString());
        bufferedWriter.write(" ");
        for (n = 0; n < dArray.length; ++n) {
            bufferedWriter.write(RMAIO.leftJustify((int)12, (String)("Capacity " + RMAIO.setPrecision2((double)dArray[n], (int)2))).toString());
        }
        bufferedWriter.newLine();
        string = Parameter.getUnitsStringForSystem((int)Parameter.PARAMID_ELEV, (int)n2);
        bufferedWriter.write(RMAIO.leftJustify((int)12, (String)string).toString());
        bufferedWriter.write(" ");
        for (n = 0; n < dArray.length; ++n) {
            string = Parameter.getUnitsStringForSystem((int)Parameter.PARAMID_AREA, (int)n2);
            bufferedWriter.write(RMAIO.leftJustify((int)12, (String)string).toString());
        }
        bufferedWriter.newLine();
        PairedValuesExt pairedValuesExt = adjustableFlow.getCapacityValuesBySetting();
        if (pairedValuesExt != null) {
            bufferedWriter.write(pairedValuesExt.toTableForm(1));
        }
    }

    private void a(Storage object, BufferedWriter bufferedWriter) throws IOException {
        String[] stringArray = new String[]{"Elevation\n(%S)", "Storage\n(%S)", "Area\n(%S)"};
        Object object2 = new boolean[]{true, true, true};
        object = object.useConicInterpolation() ? new StorageTableModel(stringArray, (Storage)object, (boolean[])object2, true) : new StorageTableModel(stringArray, (Storage)object, (boolean[])object2, false);
        bufferedWriter.write(RMAIO.leftJustify((int)12, (String)"Elevation").toString());
        int n = this.a.getUnitSystem();
        bufferedWriter.write(RMAIO.leftJustify((int)12, (String)"Storage").toString());
        bufferedWriter.write(" ");
        bufferedWriter.write(RMAIO.leftJustify((int)12, (String)"Area").toString());
        bufferedWriter.newLine();
        object2 = Parameter.getUnitsStringForSystem((int)Parameter.PARAMID_ELEV, (int)n);
        bufferedWriter.write(RMAIO.leftJustify((int)12, (String)object2).toString());
        bufferedWriter.write(" ");
        object2 = Parameter.getUnitsStringForSystem((int)Parameter.PARAMID_STOR, (int)n);
        bufferedWriter.write(RMAIO.leftJustify((int)12, (String)object2).toString());
        bufferedWriter.write(" ");
        object2 = Parameter.getUnitsStringForSystem((int)Parameter.PARAMID_AREARESERVOIR, (int)n);
        bufferedWriter.write(RMAIO.leftJustify((int)12, (String)object2).toString());
        bufferedWriter.newLine();
        for (int i = 0; i < object.getRowCount(); ++i) {
            Object object3 = ((StorageTableModel)((Object)object)).getValueAt(i, 0);
            object2 = ((StorageTableModel)((Object)object)).getValueAt(i, 1);
            Object object4 = ((StorageTableModel)((Object)object)).getValueAt(i, 2);
            if (object3 == null || object3.toString().trim().length() == 0 || object2 == null || object2.toString().trim().length() == 0 || object4 == null || object4.toString().trim().length() == 0) break;
            bufferedWriter.write(RMAIO.leftJustify((int)12, (String)object3.toString()).toString());
            bufferedWriter.write(" ");
            bufferedWriter.write(RMAIO.leftJustify((int)12, (String)object2.toString()).toString());
            bufferedWriter.write(" ");
            bufferedWriter.write(RMAIO.leftJustify((int)12, (String)object4.toString()).toString());
            bufferedWriter.newLine();
        }
    }

    private static void a(DiversionElement diversionElement, BufferedWriter bufferedWriter) throws IOException {
        Object object = ((Element)diversionElement).getUpstreamNode();
        RssNode rssNode = ((Element)diversionElement).getDownstreamNode();
        StreamElement streamElement = ((RssNode)object).getStream();
        double d = object.getStreamStation();
        object = "unknown";
        String string = "unknown";
        if (streamElement != null) {
            object = streamElement.getName();
        }
        streamElement = null;
        double d2 = -1.0;
        if (rssNode != null) {
            streamElement = rssNode.getStream();
            d2 = rssNode.getStreamStation();
            if (streamElement != null) {
                string = streamElement.getName();
            }
        }
        bufferedWriter.write("DIV:" + diversionElement.getName() + "," + (String)object + "," + RMAIO.setPrecision2((double)d, (int)3));
        if (streamElement != null) {
            bufferedWriter.write("," + string + "," + d2);
        }
        bufferedWriter.newLine();
    }

    private static void a(ReachElement reachElement, BufferedWriter bufferedWriter) throws IOException {
        Object object = ((Element)reachElement).getUpstreamNode();
        Object object2 = ((Element)reachElement).getDownstreamNode();
        Object object3 = ((RssNode)object).getStream();
        ((RssNode)object2).getStream();
        double d = object2.getStreamStation();
        double d2 = object.getStreamStation();
        object = "unknown";
        if (object3 != null) {
            object = object3.getName();
        }
        object2 = "";
        object3 = "";
        if (((Element)reachElement).getUpstreamNode() != null) {
            object2 = Integer.toString(((Element)reachElement).getUpstreamNode().getIndex());
        }
        ((Element)reachElement).getDownstreamNode();
        if (((Element)reachElement).getDownstreamNode() != null) {
            object3 = Integer.toString(((Element)reachElement).getDownstreamNode().getIndex());
        }
        bufferedWriter.write("RCH:" + reachElement.getName() + "," + (String)object + "," + RMAIO.setPrecision2((double)d2, (int)3) + "," + RMAIO.setPrecision2((double)d, (int)3) + ",IN," + (String)object2 + ",OUT," + (String)object3);
        bufferedWriter.newLine();
    }

    private static void a(JunctionElement object, BufferedWriter bufferedWriter) throws IOException {
        Object object2 = ((JunctionElement)object).getStream();
        String string = "unknown";
        if (object2 != null) {
            string = object2.getName();
        }
        object2 = "";
        Object object3 = "";
        Object object4 = ((Element)object).getNodeVector();
        Vector vector = ((Element)object).getNodeDirVector();
        for (int i = 0; i < ((Vector)object4).size(); ++i) {
            if ((Integer)vector.get(i) != 1) continue;
            if (((String)object2).length() > 0) {
                object2 = ((String)object2).concat(",");
            }
            object2 = ((String)object2).concat(String.valueOf(((Node)((Vector)object4).get(i)).getIndex()));
        }
        ArrayList arrayList = new ArrayList();
        ((Element)object).getDownstreamNodes(arrayList);
        if (arrayList.size() > 0) {
            for (int i = 0; i < arrayList.size(); ++i) {
                object4 = (RssNode)arrayList.get(i);
                object3 = (String)object3 + Integer.toString(object4.getIndex()) + ",";
            }
        }
        double d = ((JunctionElement)object).getStreamStation();
        bufferedWriter.write("JNC:" + object.getName() + "," + string + "," + RMAIO.setPrecision2((double)d, (int)3) + ",IN," + (String)object2 + ",OUT," + (String)object3);
        bufferedWriter.newLine();
        object = ((JunctionElement)object).getLocalFlowVector();
        for (int i = 0; i < ((Vector)object).size(); ++i) {
            object2 = (String[])((Vector)object).get(i);
            bufferedWriter.write("LOC:" + (String)object2[0]);
            bufferedWriter.newLine();
        }
    }
}

