/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.gui.MoverPanel;
import hec.rss.model.ReservoirElement;
import hec.rss.model.ReservoirSysOp;
import hec.rss.model.RssSystem;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import rma.swing.RmaJButton;
import rma.swing.RmaJDialog;
import rma.swing.RmaJLabel;
import rma.swing.RmaJPanel;
import rma.swing.RmaJTextField;

public class NewReservoirSystemDialog
extends RmaJDialog {
    boolean _controlsCreated = false;
    boolean _isCanceled = true;
    private int VERTICAL_GAP = 5;
    private int HORIZONTAL_GAP = 5;
    RssSystem _rssSystem;
    private JLabel _nameLabel;
    JTextField _nameField;
    JLabel _descLabel;
    JTextField _descField;
    MoverPanel _moverPanel;
    JButton _okButton;
    JButton _cancelButton;

    public NewReservoirSystemDialog(Dialog dialog, boolean bl, RssSystem rssSystem) {
        super(dialog, bl);
        this.setTitle("New Reservoir System");
        this._rssSystem = rssSystem;
        this.createControls();
    }

    public void editReservoir(ReservoirSysOp object) {
        this.setTitle("Edit Reservoir System");
        this._nameField.setText(object.getName());
        this._nameField.setEnabled(false);
        this._nameField.setEditable(false);
        this._descField.setText(object.getDescription());
        object = ((ReservoirSysOp)object).getReservoirList();
        List<ReservoirElement> list = this.getSystemReservoirList();
        this._moverPanel.clearForm();
        this._moverPanel.setData(list, (List)object);
    }

    protected void createControls() {
        if (this._controlsCreated) {
            return;
        }
        this.getContentPane().setLayout(new BorderLayout(this.HORIZONTAL_GAP, 0));
        JPanel jPanel = this.buildNorthPanel();
        this.add(jPanel, "North");
        jPanel = this.buildCenterPanel();
        this.add(jPanel, "Center");
        jPanel = this.buildSouthPanel();
        this.add(jPanel, "South");
    }

    private JPanel buildNorthPanel() {
        this._nameLabel = new RmaJLabel("Name:");
        this._nameField = new RmaJTextField();
        this._descLabel = new RmaJLabel("Description:");
        this._descField = new RmaJTextField();
        RmaJPanel rmaJPanel = new RmaJPanel((LayoutManager)new BorderLayout(this.HORIZONTAL_GAP, this.VERTICAL_GAP));
        rmaJPanel.setBorder((Border)new EmptyBorder(new Insets(5, 5, 5, 5)));
        GridLayout gridLayout = new GridLayout(2, 1, this.HORIZONTAL_GAP, this.VERTICAL_GAP);
        gridLayout = new RmaJPanel((LayoutManager)gridLayout);
        gridLayout.add(this._nameLabel);
        gridLayout.add(this._descLabel);
        rmaJPanel.add((Component)((Object)gridLayout), (Object)"West");
        gridLayout = new GridLayout(2, 1, this.HORIZONTAL_GAP, this.VERTICAL_GAP);
        gridLayout = new RmaJPanel((LayoutManager)gridLayout);
        gridLayout.add(this._nameField);
        gridLayout.add(this._descField);
        rmaJPanel.add((Component)((Object)gridLayout), (Object)"Center");
        return rmaJPanel;
    }

    private JPanel buildCenterPanel() {
        this._moverPanel = new MoverPanel();
        this._moverPanel.setDescVisible(false);
        this._moverPanel.setMoveUpDownVisible(false);
        Object object = new TitledBorder("Select the Reservoirs that Operate as a System");
        this._moverPanel.setBorder((Border)object);
        object = this.getSystemReservoirList();
        this._moverPanel.setData((List)object, new ArrayList());
        object = new RmaJPanel((LayoutManager)new BorderLayout());
        object.add((Component)this._moverPanel, (Object)"Center");
        object.setBorder((Border)new EmptyBorder(new Insets(0, 5, 0, 5)));
        return object;
    }

    private List<ReservoirElement> getSystemReservoirList() {
        Vector<ReservoirElement> vector = this._rssSystem.getElementVectorByClass(ReservoirElement.class);
        ArrayList<ReservoirElement> arrayList = new ArrayList<ReservoirElement>();
        ReservoirSysOp[] reservoirSysOpArray = this._rssSystem.getReservoirSysOps();
        for (int i = 0; i < reservoirSysOpArray.length; ++i) {
            Object object = reservoirSysOpArray[i];
            object = ((ReservoirSysOp)object).getReservoirList();
            object.forEach(reservoirElement -> vector.remove(reservoirElement));
        }
        arrayList.addAll(vector);
        return arrayList;
    }

    public List<ReservoirElement> getAssignedReservoirs() {
        ArrayList<ReservoirElement> arrayList = new ArrayList<ReservoirElement>();
        Vector vector = this._moverPanel.getSelectedObjectsVector();
        arrayList.addAll(vector);
        return arrayList;
    }

    private JPanel buildSouthPanel() {
        this._okButton = new RmaJButton("OK");
        this._cancelButton = new RmaJButton("Cancel");
        this._okButton.addActionListener(actionEvent -> this.okAction());
        this._cancelButton.addActionListener(actionEvent -> this.cancelAction());
        GridLayout gridLayout = new GridLayout(1, 2);
        gridLayout.setVgap(this.VERTICAL_GAP);
        gridLayout.setHgap(this.HORIZONTAL_GAP);
        gridLayout = new RmaJPanel((LayoutManager)gridLayout);
        gridLayout.add(this._okButton);
        gridLayout.add(this._cancelButton);
        RmaJPanel rmaJPanel = new RmaJPanel((LayoutManager)new BorderLayout(this.HORIZONTAL_GAP, this.VERTICAL_GAP));
        rmaJPanel.setBorder((Border)new EmptyBorder(new Insets(5, 5, 5, 5)));
        rmaJPanel.add((Component)((Object)gridLayout), (Object)"East");
        return rmaJPanel;
    }

    private void okAction() {
        if (!this.isValidData()) {
            return;
        }
        this._isCanceled = false;
        this.setVisible(false);
        this.dispose();
    }

    public String getName() {
        return this._nameField.getText().trim();
    }

    public String getDescription() {
        String string = "";
        if (!this._descField.getText().isEmpty()) {
            string = this._descField.getText().trim();
        }
        return string;
    }

    private void cancelAction() {
        this._isCanceled = true;
        this.setVisible(false);
        this.dispose();
    }

    protected boolean isValidData() {
        Object[] objectArray = this._nameField.getText().trim();
        if (objectArray.length() == 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Please enter a name", "Empty Name", 2);
            this._nameField.requestFocus();
            return false;
        }
        objectArray = this._moverPanel.getSelectedObjects();
        if (objectArray == null || objectArray.length < 2) {
            JOptionPane.showMessageDialog((Component)((Object)this), "At least 2 reservoirs should be selected to create a Reservoir System", "Empty Name", 2);
            this._nameField.requestFocus();
            return false;
        }
        return true;
    }

    public boolean isCanceled() {
        return this._isCanceled;
    }
}

