/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.gui.NameDialog;
import hec.rss.model.OpSet;
import hec.rss.model.ResSystemOpSet;
import hec.rss.model.ReservoirElement;
import hec.rss.model.ReservoirSysOp;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.text.Document;
import rma.swing.RmaGridBagConstraints;
import rma.swing.RmaJDescriptionField;
import rma.swing.RmaJTable;
import rma.swing.text.DssPathnamePartDocument;
import rma.util.RMAIO;

public class NewSystemOpSetJDialog
extends NameDialog {
    RmaJTable reservoirJTable;
    RmaJDescriptionField _descriptionFld;
    boolean _controlsCreated = false;
    ReservoirElement[] _resElem = null;
    ReservoirSysOp _resSysOp = null;

    public NewSystemOpSetJDialog(Frame frame, boolean bl) {
        super(frame, "New System Operation Set", bl, 0);
    }

    public NewSystemOpSetJDialog(Dialog dialog, boolean bl) {
        super(dialog, "New System Operation Set", bl, 0);
    }

    public NewSystemOpSetJDialog(Dialog dialog, String string, boolean bl) {
        this(dialog, bl);
        this.setTitle(string);
    }

    public NewSystemOpSetJDialog(Frame frame, String string, boolean bl) {
        this(frame, bl);
        this.setTitle(string);
    }

    public NewSystemOpSetJDialog(Frame frame) {
        this(frame, false);
    }

    public NewSystemOpSetJDialog(Dialog dialog) {
        this(dialog, false);
    }

    protected void createControls(int n) {
        if (this._controlsCreated) {
            return;
        }
        super.createControls(n);
        Serializable serializable = (GridBagLayout)this.getContentPane().getLayout();
        GridBagConstraints gridBagConstraints = ((GridBagLayout)serializable).getConstraints(this._labelTxt);
        ((GridBagLayout)serializable).getConstraints(this._labelTxt).weighty = 0.0;
        ((GridBagLayout)serializable).setConstraints(this._labelTxt, gridBagConstraints);
        serializable = new JLabel("Description:");
        ((JLabel)serializable).setDisplayedMnemonic('D');
        new GridBagConstraints();
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(5, 12, 0, 0);
        this.getContentPane().add((Component)serializable, gridBagConstraints);
        this._descriptionFld = new RmaJDescriptionField();
        ((JLabel)serializable).setLabelFor((Component)this._descriptionFld);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.getContentPane().add((Component)this._descriptionFld, gridBagConstraints);
        this.setNameFieldDocument((Document)new DssPathnamePartDocument());
        this.getContentPane().remove(this.buttonPanel);
        this.reservoirJTable = new RmaJTable((Component)((Object)this));
        this.reservoirJTable.setRowHeight(this.reservoirJTable.getRowHeight() + 5);
        this.reservoirJTable.setEditable(false);
        this.reservoirJTable.getScrollPane().setHorizontalScrollBarPolicy(30);
        serializable = new JLabel("Select Operation Sets");
        this.getContentPane().add((Component)serializable, new RmaGridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 18, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.getContentPane().add((Component)this.reservoirJTable.getScrollPane(), new RmaGridBagConstraints(0, 4, 2, 1, 1.0, 1.5, 18, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.getContentPane().add((Component)this.buttonPanel, new RmaGridBagConstraints(0, 5, 2, 1, 1.0, 0.0, 16, 2, new Insets(5, 5, 5, 5), 0, 0));
        this._controlsCreated = true;
        this.setSize(300, 400);
        this.setMinimumSize(new Dimension(300, 400));
    }

    public NewSystemOpSetJDialog(String string) {
        this();
        this.setTitle(string);
    }

    public NewSystemOpSetJDialog() {
        this((Frame)null);
    }

    void NewSystemOpSetJDialog_WindowClosing(WindowEvent windowEvent) {
        this.dispose();
        this._isCanceled = true;
    }

    protected void cmdOk_Action(ActionEvent actionEvent) {
        if (this._labelTxt.getText().trim().length() == 0) {
            return;
        }
        if (!this.validateData()) {
            return;
        }
        this._isCanceled = false;
        this._label = this._labelTxt.getText();
        this._description = this._descriptionFld.getText();
        this.setVisible(false);
        this.dispose();
    }

    private boolean validateData() {
        if (this._labelTxt.getText().equals("")) {
            RMAIO.postError((Component)((Object)this), (String)"Name cannot be blank");
            return false;
        }
        this.reservoirJTable.commitEdit(true);
        for (int i = 0; i < this.reservoirJTable.getRowCount(); ++i) {
            Object object = this.reservoirJTable.getCell(i, 1);
            if (!object.toString().trim().equals("")) continue;
            RMAIO.postError((Component)((Object)this), (String)"You must choose an Operation Set for all Reservoirs");
            return false;
        }
        return true;
    }

    public void setData(ReservoirElement[] reservoirElementArray, ReservoirSysOp stringArray) {
        if (reservoirElementArray == null || stringArray == null) {
            RMAIO.postError((Component)((Object)this), (String)"Error Setting data for this dialog");
            return;
        }
        this._resElem = reservoirElementArray;
        this._resSysOp = stringArray;
        this.reservoirJTable.setNumColumns(2);
        stringArray = new String[]{"Reservoir", "Operation Set"};
        this.reservoirJTable.setColumnLabels(stringArray);
        this.reservoirJTable.setNumRows(reservoirElementArray.length);
        for (int i = 0; i < reservoirElementArray.length; ++i) {
            Vector<OpSet> vector = reservoirElementArray[i].getReservoirOp().getOperationSets();
            this.reservoirJTable.setComboBoxRowEditor(i, 1, vector);
            this.reservoirJTable.setCellEnabled(true, i, 1);
            this.reservoirJTable.setCellEnabled(false, i, 0);
            if (vector.size() > 0) {
                this.reservoirJTable.setCell((Object)vector.elementAt(0), i, 1);
            }
            this.reservoirJTable.setCell((Object)reservoirElementArray[i], i, 0);
        }
        this.reservoirJTable.setEnabled(true);
        this.reservoirJTable.setEditable(true);
        this.reservoirJTable.getTableHeader();
    }

    public void editData(ReservoirElement[] reservoirElementArray, ReservoirSysOp reservoirSysOp, ResSystemOpSet resSystemOpSet) {
        this.setData(reservoirElementArray, reservoirSysOp);
        this._labelTxt.setText(resSystemOpSet.getName());
        this._labelTxt.setEditable(false);
        this._descriptionFld.setText(resSystemOpSet.getDescription());
        this._descriptionFld.setEditable(false);
        for (int i = 0; i < reservoirElementArray.length; ++i) {
            this.reservoirJTable.setColumnEnabled(!reservoirSysOp.exists(reservoirElementArray[i]), i);
        }
    }

    public ResSystemOpSet getNewOperationSet() {
        ResSystemOpSet resSystemOpSet = this._resSysOp.createNewSystemOpSet(this._label, this._description);
        for (int i = 0; i < this.reservoirJTable.getRowCount(); ++i) {
            Object object = this.reservoirJTable.getCell(i, 1);
            resSystemOpSet.addReservoirOpSet((OpSet)object);
        }
        return resSystemOpSet;
    }
}

