/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.client.PanelEditor;
import hec.clientapp.client.ClientApp;
import hec.clientapp.client.ShortcutsAccessory;
import hec.gui.AbstractEditorPanel;
import hec.gui.NameDescriptionPanel;
import hec.io.Identifier;
import hec.model.WatershedLocation;
import hec.rss.client.NewWatershedDlg$1;
import hec.rss.client.NewWatershedDlg$2;
import hec.rss.client.NewWatershedDlg$3;
import hec.rss.client.NewWatershedDlg$4;
import hec.rss.client.NewWatershedDlg$5;
import hec.rss.client.NewWatershedDlg$6;
import hec.rss.client.NewWatershedDlg$TimeZoneButton;
import hec.watershed.model.StreamAlignmentUnits;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.filechooser.FileSystemView;
import javax.swing.text.Document;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.DefaultJPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDialog;
import rma.swing.RmaJPanel;
import rma.swing.list.RmaListModel;
import rma.swing.text.DssPathnamePartDocument;
import rma.util.RMAIO;

public class NewWatershedDlg
extends RmaJDialog {
    String[] timeZones = null;
    int[] gmtOffsets = new int[]{-9, -8, -7, -6, -5, -4, 0};
    NameDescriptionPanel nameDescPanel;
    JLabel unitsLabel;
    JLabel timeZoneLabel;
    JLabel _locationsLabel;
    JRadioButton englishRadio;
    JRadioButton siRadio;
    NewWatershedDlg$TimeZoneButton timeZoneButton;
    RmaJComboBox _availableLocations;
    ButtonCmdPanel cmdPanel;
    boolean fComponentsAdjusted = false;
    private boolean _controlsCreated = false;
    private boolean _canceled = false;
    PanelEditor _timeZoneEditor;
    private JPanel _accessoriesPanel;
    private JButton _selectLocationBtn;
    private List<DefaultJPanel> _accPanels = new ArrayList<DefaultJPanel>();
    private RmaJComboBox<StreamAlignmentUnits> _streamAlignUnitsCombo;

    public NewWatershedDlg(Frame frame, boolean bl) {
        super(frame, bl);
        this.setTitle("New Workspace");
        this.createControls();
    }

    public NewWatershedDlg(Dialog dialog, boolean bl) {
        super(dialog, bl);
        this.setTitle("New Workspace");
        this.createControls();
    }

    public NewWatershedDlg(Dialog dialog, String string, boolean bl) {
        this(dialog, bl);
        this.setTitle(string);
    }

    public NewWatershedDlg(Frame frame, String string, boolean bl) {
        this(frame, bl);
        this.setTitle(string);
    }

    public NewWatershedDlg(Frame frame) {
        this(frame, true);
    }

    public NewWatershedDlg(Dialog dialog) {
        this(dialog, false);
    }

    public NewWatershedDlg(String string) {
        this();
        this.setTitle(string);
    }

    public NewWatershedDlg() {
        this((Frame)null);
    }

    public void setWatershedLocations(Vector vector) {
        if (this._availableLocations != null) {
            ((RmaListModel)this._availableLocations.getModel()).clear();
            if (vector != null) {
                ((RmaListModel)this._availableLocations.getModel()).addAll((Collection)vector);
                if (this._availableLocations.getItemCount() > 0) {
                    this._availableLocations.setSelectedIndex(0);
                }
            }
        }
    }

    public int getUnitSystemId() {
        if (this.englishRadio.isSelected()) {
            return 1;
        }
        return 2;
    }

    public int getGmtOffset() {
        return this.timeZoneButton.getTimeZoneOffset();
    }

    public StreamAlignmentUnits getStreamAlignmentUnits() {
        return (StreamAlignmentUnits)this._streamAlignUnitsCombo.getSelectedItem();
    }

    public boolean isCanceled() {
        return this._canceled;
    }

    public String getDescription() {
        return this.nameDescPanel.getDescription();
    }

    public String getName() {
        return this.nameDescPanel.getName();
    }

    public String getWatershedLocation() {
        if (this._availableLocations != null) {
            Object object = this._availableLocations.getSelectedItem();
            if (object instanceof WatershedLocation) {
                object = ((WatershedLocation)object).getDirectory();
                while (((String)object).endsWith("/")) {
                    object = ((String)object).substring(0, ((String)object).length() - 1);
                }
                return object;
            }
        } else {
            return this._selectLocationBtn.getName();
        }
        return null;
    }

    public void addNotify() {
        Component[] componentArray = this.getSize();
        super.addNotify();
        if (this.fComponentsAdjusted) {
            return;
        }
        Insets insets = this.getInsets();
        this.setSize(insets.left + insets.right + componentArray.width, insets.top + insets.bottom + componentArray.height);
        componentArray = this.getContentPane().getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            Point point = componentArray[i].getLocation();
            point.translate(insets.left, insets.top);
            componentArray[i].setLocation(point);
        }
        this.fComponentsAdjusted = true;
    }

    protected void createControls() {
        if (this._controlsCreated) {
            return;
        }
        this.getContentPane().setLayout(new GridBagLayout());
        this.nameDescPanel = new NameDescriptionPanel();
        this.getContentPane().add((Component)this.nameDescPanel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 18, 2, RmaInsets.insets((int)0, (int)5, (int)0, (int)5), 0, 0));
        this.nameDescPanel.setNameDocument((Document)new DssPathnamePartDocument());
        this.timeZones = new String[]{"(GMT -09:00) Alaska", "(GMT -08:00) Pacific Time", "(GMT -07:00) Mountain Time", "(GMT -06:00) Central Time", "(GMT -05:00) Eastern Time", "(GMT -04:00) Atlantic Time", "(GMT -00:00) Greenwich Mean Time"};
        this.unitsLabel = new JLabel("Units:");
        this.siRadio = new JRadioButton("SI");
        this.englishRadio = new JRadioButton("English");
        Serializable serializable = new ButtonGroup();
        ((ButtonGroup)serializable).add(this.siRadio);
        ((ButtonGroup)serializable).add(this.englishRadio);
        this.timeZoneLabel = new JLabel("          ");
        this.timeZoneButton = new NewWatershedDlg$TimeZoneButton(this);
        this.timeZoneLabel.setLabelFor(this.timeZoneButton);
        this._locationsLabel = new JLabel("Location:");
        this.getContentPane().add((Component)this._locationsLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 2, RmaInsets.insets((int)5, (int)10, (int)0, (int)0), 0, 0));
        if (Boolean.getBoolean("NO_PREDEFINED_WKSP")) {
            this._selectLocationBtn = new JButton("Select Location");
            this._selectLocationBtn.setMnemonic('S');
            this.getContentPane().add((Component)this._selectLocationBtn, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 2, RmaInsets.insets((int)5, (int)10, (int)0, (int)10), 0, 0));
        } else {
            this._availableLocations = new NewWatershedDlg$1(this, (ComboBoxModel)new RmaListModel(true));
            this._availableLocations.setToolTipText("");
            this.getContentPane().add((Component)this._availableLocations, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 2, RmaInsets.insets((int)5, (int)10, (int)0, (int)10), 0, 0));
            this._locationsLabel.setLabelFor((Component)this._availableLocations);
        }
        this.getContentPane().add((Component)this.unitsLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, RmaInsets.insets((int)5, (int)10, (int)0, (int)0), 0, 0));
        serializable = new JPanel(new GridBagLayout());
        this.englishRadio.setMargin(RmaInsets.INSETS0000);
        this.siRadio.setMargin(RmaInsets.INSETS0000);
        ((Container)serializable).add(this.englishRadio, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, RmaInsets.insets((int)5, (int)5, (int)0, (int)0), 0, 0));
        ((Container)serializable).add(this.siRadio, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, RmaInsets.insets((int)5, (int)5, (int)0, (int)5), 0, 0));
        this.getContentPane().add((Component)serializable, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 18, 2, RmaInsets.insets((int)0, (int)0, (int)0, (int)0), 0, 0));
        this.getContentPane().add((Component)this.timeZoneLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 0, RmaInsets.insets((int)5, (int)5, (int)0, (int)0), 35, 0));
        this.getContentPane().add((Component)this.timeZoneButton, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 18, 2, RmaInsets.insets((int)5, (int)8, (int)0, (int)10), 0, 0));
        serializable = new RmaJPanel((LayoutManager)new GridBagLayout());
        JLabel jLabel = new JLabel("Stream Alignment Units:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        ((Container)serializable).add(jLabel, gridBagConstraints);
        this._streamAlignUnitsCombo = new RmaJComboBox((Object[])StreamAlignmentUnits.values());
        this._streamAlignUnitsCombo.setModifiable(true);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.01;
        gridBagConstraints.weighty = 0.01;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        ((Container)serializable).add((Component)this._streamAlignUnitsCombo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.01;
        gridBagConstraints.weighty = 0.01;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS0500;
        this.add((Component)serializable, gridBagConstraints);
        this._controlsCreated = true;
        this._accessoriesPanel = new JPanel(new GridBagLayout());
        this.getContentPane().add((Component)this._accessoriesPanel, new GridBagConstraints(0, 6, 2, 1, 1.0, 0.0, 16, 2, RmaInsets.insets((int)0, (int)0, (int)0, (int)0), 0, 0));
        this.cmdPanel = new ButtonCmdPanel(12);
        this.getContentPane().add((Component)this.cmdPanel, new GridBagConstraints(0, 7, 2, 1, 1.0, 0.0, 16, 2, RmaInsets.insets((int)5, (int)5, (int)10, (int)10), 0, 0));
        this.cmdPanel.addCmdPanelListener((ButtonCmdPanelListener)new NewWatershedDlg$2(this));
        this._locationsLabel.setDisplayedMnemonic('L');
        this.unitsLabel.setLabelFor(this.englishRadio);
        this.unitsLabel.setDisplayedMnemonic('U');
        this.timeZoneLabel.setLabelFor(this.timeZoneButton);
        this.timeZoneLabel.setDisplayedMnemonic('T');
        this.pack();
        serializable = this.getPreferredSize();
        if (((Dimension)serializable).width < 400) {
            ((Dimension)serializable).width = 400;
        }
        this.setDefaultSize(((Dimension)serializable).width, ((Dimension)serializable).height);
        this.pack();
        NewWatershedDlg newWatershedDlg = this;
        newWatershedDlg.setLocationRelativeTo(newWatershedDlg.getParent());
        this.setResizable(false);
        this.addWindowListener(new NewWatershedDlg$3(this));
        this.timeZoneButton.addActionListener(new NewWatershedDlg$4(this));
        if (this._selectLocationBtn != null) {
            this._selectLocationBtn.addActionListener(new NewWatershedDlg$5(this));
        }
    }

    protected void selectWatershedDirectory() {
        Serializable serializable = new JFileChooser();
        FileSystemView.getFileSystemView();
        Object object = new ShortcutsAccessory((JFileChooser)serializable, "demo");
        ((JFileChooser)serializable).setAccessory((JComponent)object);
        ((JFileChooser)serializable).setCurrentDirectory(ClientApp.app().getDefaultWatershedFolder());
        object.setFileShortcutAllowed(false);
        object = this._selectLocationBtn.getName();
        if (!"Select Location".equals(object)) {
            object = (String)object + "/x";
            ((JFileChooser)serializable).setSelectedFile(new File((String)object));
        }
        object = new Dimension(600, 400);
        ((JComponent)serializable).setMinimumSize((Dimension)object);
        ((JComponent)serializable).setPreferredSize((Dimension)object);
        ((JFileChooser)serializable).setFileSelectionMode(1);
        ((JFileChooser)serializable).setDialogTitle("Select Watershed Folder");
        int n = ((JFileChooser)serializable).showOpenDialog((Component)ClientApp.frame());
        if (n == 0) {
            serializable = ((JFileChooser)serializable).getSelectedFile();
            int n2 = this._selectLocationBtn.getWidth();
            Object object2 = this._selectLocationBtn.getFont();
            FontMetrics fontMetrics = this._selectLocationBtn.getFontMetrics((Font)object2);
            Object object3 = "WWWWWWWW";
            int n3 = 50;
            object2 = ((File)serializable).getAbsolutePath().replace('\\', "/".charAt(0));
            if (fontMetrics.stringWidth((String)object2) > n2 - 5) {
                for (int i = 0; i < 100; ++i) {
                    if (fontMetrics.stringWidth((String)object3) > n2 - 5) {
                        n3 = ((String)object3).length();
                        break;
                    }
                    object3 = (String)object3 + "W";
                }
                this._selectLocationBtn.setText(RMAIO.getShortenedPathname((String)object2, (int)n3));
            } else {
                this._selectLocationBtn.setText((String)object2);
            }
            this._selectLocationBtn.setMnemonic(-1);
            this._selectLocationBtn.setName((String)object2);
            this._selectLocationBtn.setToolTipText((String)object2);
        }
    }

    void NewWorkspaceDlg_WindowClosing(WindowEvent windowEvent) {
        this.dispose();
    }

    private boolean isValidForm() {
        Object object = null;
        String string = null;
        if (this.nameDescPanel.getName().length() == 0) {
            string = "Please enter a Watershed name";
            object = this.nameDescPanel;
        } else if (!this.englishRadio.isSelected() && !this.siRadio.isSelected()) {
            string = "Please select the Watershed Units";
            object = this.englishRadio;
        } else if (this.timeZoneButton.getText().equals("Time Zones...")) {
            string = "Please select the Watershed Timezone";
            object = this.timeZoneButton;
        } else if (this._availableLocations != null) {
            if (this._availableLocations.getSelectedItem() == null) {
                string = "Please select a Watershed location";
                object = this._availableLocations;
            }
        } else if ("Select Location".equals(this._selectLocationBtn.getText())) {
            string = "Please select the Watershed's Location";
            object = this._selectLocationBtn;
        }
        if (object != null) {
            object.requestFocus();
        }
        if (string != null) {
            JOptionPane.showMessageDialog((Component)((Object)this), string, "Incomplete Information", 1);
            return false;
        }
        object = ClientApp.app().getAppServer();
        if (object != null) {
            try {
                string = this.getWatershedLocation();
                String string2 = ClientApp.app().getBaseWkspDirectory();
                if (string2 != null) {
                    string = string.concat(string2);
                }
                string2 = new Identifier();
                string2.setName(RMAIO.userNameToFileName((String)this.nameDescPanel.getName()));
                if (object.workspaceExists((Identifier)string2, string)) {
                    NewWatershedDlg newWatershedDlg = this;
                    JOptionPane.showMessageDialog((Component)((Object)newWatershedDlg), "Watershed '" + newWatershedDlg.nameDescPanel.getName() + "' already exists at\n" + string, "Watershed already Exists", 2);
                    return false;
                }
            }
            catch (RemoteException remoteException) {
                System.out.println("RMI Error checking for existing workspace " + String.valueOf(remoteException));
            }
        }
        return true;
    }

    public boolean setDefaultTimeZone(TimeZone timeZone) {
        if (timeZone == null) {
            this.timeZoneButton.setTimeZone(null, -1);
        } else {
            int n = timeZone.getRawOffset() / 3600000;
            this.timeZoneButton.setTimeZone(timeZone.toString(), n);
        }
        return false;
    }

    public boolean setDefaultUnits(int n) {
        switch (n) {
            case 1: {
                this.englishRadio.setSelected(true);
                break;
            }
            case 2: {
                this.siRadio.setSelected(true);
                break;
            }
            default: {
                this.siRadio.setSelected(false);
                this.englishRadio.setSelected(false);
                return false;
            }
        }
        return true;
    }

    public void setUnitsComboBoxVisible(boolean bl) {
        this.siRadio.setVisible(bl);
        this.englishRadio.setVisible(bl);
        this.unitsLabel.setVisible(bl);
    }

    public void setTimeZoneComboBoxVisible(boolean bl) {
        this.timeZoneButton.setVisible(bl);
        this.timeZoneLabel.setVisible(bl);
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
    }

    private void selectTimeZone() {
        if (this._timeZoneEditor == null) {
            this._timeZoneEditor = new PanelEditor((Dialog)((Object)this), false);
            NewWatershedDlg$6 newWatershedDlg$6 = new NewWatershedDlg$6(this);
            this._timeZoneEditor.setLocationRelativeTo((Component)ClientApp.frame().getMapPanel());
            this._timeZoneEditor.setTitle("Select a Time Zone");
            this._timeZoneEditor.addPanel((AbstractEditorPanel)newWatershedDlg$6);
            this._timeZoneEditor.fillForm(null);
            this._timeZoneEditor.pack();
        }
        this._timeZoneEditor.setVisible(true);
    }

    public String getTimeZoneText() {
        return this.timeZoneButton.getText();
    }

    public void addAccessoryPanel(DefaultJPanel object) {
        if (object == null) {
            return;
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS0000;
        this._accessoriesPanel.add((Component)object, gridBagConstraints);
        this._accPanels.add((DefaultJPanel)object);
        this.pack();
        object = this.getPreferredSize();
        if (object.width < 400) {
            object.width = 400;
        }
        this.setDefaultSize(object.width, object.height);
        this.pack();
    }
}

