/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.rss.client.reports.PrintableReport;
import hec.rss.model.Element;
import hec.rss.model.RssNode;
import hec.rss.model.RssSystem;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.TableModel;
import rma.swing.RmaInsets;
import rma.swing.RmaJFrame;
import rma.swing.RmaJTable;
import rma.swing.RmaJTableSorter;
import rma.swing.event.ReflectMultiListener;
import rma.swing.table.RmaTableModel;
import rma.swing.table.RmaTableModelInterface;
import rma.util.RMAConst;
import rma.util.RMAIO;

public class NodeReportDlg
extends RmaJFrame
implements PrintableReport {
    RmaJTable _table;
    private Vector _listenerList = new Vector();
    private ReflectMultiListener _listener = new ReflectMultiListener();
    RssSystem _network;
    private RmaTableModel _model;
    private RmaJTableSorter _sorter;

    public NodeReportDlg() {
        this.createComponents();
    }

    void createComponents() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.setSize(640, 450);
        this.setLocation();
        this.buildMenus();
        this._table = new RmaJTable((Component)((Object)this), (Object[])new String[]{"Node ID", "Name", "KeyStr", "Upstrm\nElem", "Dnstrm\nElem", "Stream", "Stream\nStation", "Stream\nCoord."});
        this._model = (RmaTableModel)this._table.getModel();
        this._sorter = new RmaJTableSorter((RmaTableModelInterface)this._model);
        this._sorter.addMouseListenerToHeaderInTable((JTable)this._table);
        this._table.setModel((TableModel)this._sorter);
        this._table.setMlHeaderRenderer();
        this._table.setEnabled(false);
        this._table.setCellSelectionEnabled(false);
        this._table.setColumnSelectionAllowed(false);
        this._table.setRowSelectionAllowed(true);
        this._table.setAddRemoveEnabled(false);
        this._table.getSelectionModel().setSelectionMode(0);
        Object object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        ((GridBagConstraints)object).gridy = 0;
        ((GridBagConstraints)object).weightx = 1.0;
        ((GridBagConstraints)object).weighty = 1.0;
        ((GridBagConstraints)object).fill = 1;
        ((GridBagConstraints)object).insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this._table.getScrollPane(), object);
        JLabel jLabel = new JLabel();
        object = new String("<html>Table Notes:");
        object = (String)object + "<br>In KeyStr fields, ~E# references the name of element with id #<html>";
        jLabel.setText((String)object);
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        ((GridBagConstraints)object).gridy = 1;
        ((GridBagConstraints)object).weightx = 1.0;
        ((GridBagConstraints)object).weighty = 0.0;
        ((GridBagConstraints)object).insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        ((GridBagConstraints)object).fill = 2;
        this.getContentPane().add((Component)jLabel, object);
    }

    private void buildMenus() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic('F');
        jMenuBar.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem("Export", 69);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        jMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)jMenuItem, "exportReport"));
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Print", 80);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        jMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)jMenuItem, "printReport"));
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Print Preview", 118);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 192));
        jMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)jMenuItem, "printPreviewReport"));
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Close", 67);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(87, 2));
        jMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)jMenuItem, "closeDialog"));
        jMenu.add(jMenuItem);
        jMenu = new JMenu("Edit");
        jMenu.setMnemonic('E');
        jMenuBar.add(jMenu);
        jMenuItem = new JMenuItem("Clean Network", 67);
        jMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)jMenuItem, "cleanNetwork"));
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Delete Node", 68);
        jMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)jMenuItem, "deleteNode"));
        jMenu.add(jMenuItem);
        this.setJMenuBar(jMenuBar);
    }

    public void fillForm(RssSystem rssSystem) {
        this._network = rssSystem;
        if (rssSystem == null) {
            return;
        }
        this.setTitle("ResSim Node Report - " + rssSystem.getName());
        this._table.clearColors();
        this._table.deleteCells();
        Vector vector = rssSystem.getNodeVector();
        if (vector == null) {
            return;
        }
        int n = vector.size();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            RssNode rssNode = (RssNode)vector.elementAt(i);
            if (rssNode == null) continue;
            n2 = this.addNodeRow(rssSystem, rssNode, n2);
        }
        this._sorter.reallocateIndexes();
    }

    int addNodeRow(RssSystem rssSystem, RssNode rssNode, int n) {
        Vector<Object> vector = new Vector<Object>();
        vector.add(new Integer(rssNode.getIndex()));
        vector.add(rssNode);
        vector.add(rssNode.getName());
        Element element = rssNode.getUpstreamElement();
        if (element != null) {
            vector.add(rssSystem.getNameForKeyString(element.getDisplayName()));
        } else {
            vector.add("");
        }
        element = rssNode.getDownstreamElement();
        if (element != null) {
            vector.add(rssSystem.getNameForKeyString(element.getDisplayName()));
        } else {
            vector.add("");
        }
        rssSystem = rssNode.getStream();
        if (rssSystem != null) {
            vector.add(rssSystem.getName());
        } else {
            vector.add("<not on stream>");
        }
        double d = rssNode.getStreamStation();
        if (RMAConst.isValidValue((double)d)) {
            vector.add(RMAIO.setPrecision2((double)d, (int)2));
        } else {
            vector.add("");
        }
        double d2 = rssNode.getStreamCoord();
        if (RMAConst.isValidValue((double)d2)) {
            vector.add(RMAIO.setPrecision2((double)d2, (int)4));
        } else {
            vector.add("");
        }
        this._model.addRow(vector);
        return ++n;
    }

    void cleanNetwork() {
        this._network.cleanVectors();
        NodeReportDlg nodeReportDlg = this;
        nodeReportDlg.fillForm(nodeReportDlg._network);
    }

    void deleteNode() {
        if (this._network == null) {
            return;
        }
        int n = this._table.getSelectedRow();
        if (n < 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "To delete a node you must first select a row in the table.", "", 1);
            return;
        }
        RssNode rssNode = (RssNode)this._table.getCell(n, 1);
        String string = this._network.getNameForKeyString(rssNode.getDisplayName());
        int n2 = JOptionPane.showConfirmDialog((Component)((Object)this), "Warning: deleting a node can break the network connectivity.\nAre you sure you want to delete node \"" + string + "\"?", "Confirm Delete Node", 0, 3);
        if (n2 != 0) {
            return;
        }
        this._network.deleteNode(rssNode);
        this._network.cleanVectors();
        NodeReportDlg nodeReportDlg = this;
        nodeReportDlg.fillForm(nodeReportDlg._network);
    }

    @Override
    public void exportReport() {
        this._table.exportData();
    }

    public void printReport() {
        this._table.printData();
    }

    @Override
    public void printPreviewReport() {
        this._table.printPreview();
    }

    void closeDialog() {
        this.setVisible(false);
    }

    static {
        new Color(170, 170, 170);
        new Color(220, 220, 220);
    }
}

