/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.clientapp.model.TSRecordProxy;
import hec.rss.model.Element;
import hec.rss.model.RssSystem;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import rma.lang.Modifiable;
import rma.swing.RmaInsets;
import rma.swing.RmaJTable;
import rma.util.RMAUtil;

public class ObsDataPanel
extends JPanel
implements Modifiable {
    private RmaJTable _obsTable;
    private boolean _controlsCreated = false;
    private boolean _modified = false;
    private boolean _ignoreModifiedEvents = false;

    public ObsDataPanel() {
        super(new GridBagLayout());
        this.createControls();
    }

    void createControls() {
        JLabel jLabel = new JLabel("Select Locations that display Observed data in output reports and plots");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.add((Component)jLabel, gridBagConstraints);
        this._obsTable = new RmaJTable((Component)this, (Object[])new String[]{"Location", "Variable", "Observed", "name"});
        this._obsTable.setColumnEnabled(false, 0);
        this._obsTable.setColumnEnabled(false, 1);
        this._obsTable.setColumnEnabled(false, 3);
        this._obsTable.setCheckBoxCellEditor(2);
        this._obsTable.setAddRemoveEnabled(false);
        this._obsTable.setColumnBackground(0, Color.lightGray);
        this._obsTable.setColumnBackground(1, Color.lightGray);
        this._obsTable.setColumnVisible(3, false, 0);
        this._obsTable.setMlHeaderRenderer();
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        ObsDataPanel obsDataPanel = this;
        obsDataPanel.add((Component)obsDataPanel._obsTable.getScrollPane(), gridBagConstraints);
        this._controlsCreated = true;
    }

    public void fillPanel(Element object) {
        try {
            this._ignoreModifiedEvents = true;
            this._obsTable.deleteCells();
            if (object == null) {
                return;
            }
            new Vector();
            ((Element)object).updateTSProxyList();
            Vector vector = ((Element)object).getComputedTSRecordProxies();
            if (vector == null) {
                return;
            }
            RssSystem rssSystem = ((Element)object).getSystem();
            Vector vector2 = ((Element)object).getObsDataVector();
            for (int i = 0; i < vector.size(); ++i) {
                object = (TSRecordProxy)vector.get(i);
                if (object == null) continue;
                Vector<Object> vector3 = new Vector<Object>();
                if (rssSystem != null) {
                    vector3.add(rssSystem.getNameForKeyString(object.getName()));
                } else {
                    vector3.add(object.getName());
                }
                vector3.add(object.getParamName());
                object = object.getName() + ":" + object.getVariableId();
                if (vector2 != null && vector2.contains(object)) {
                    vector3.add("true");
                } else {
                    vector3.add("false");
                }
                vector3.add(object);
                this._obsTable.appendRow(vector3);
            }
            return;
        }
        finally {
            this._ignoreModifiedEvents = false;
        }
    }

    public void clearPanel() {
        this._obsTable.deleteCells();
    }

    public boolean savePanel(Element element) {
        if (element == null) {
            return false;
        }
        int n = this._obsTable.getRowCount();
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < n; ++i) {
            String string = (String)this._obsTable.getCell(i, 3);
            if (!this._obsTable.getCell(i, 2).toString().equals("true")) continue;
            vector.add(string);
        }
        element.setObsDataVector(vector);
        return true;
    }

    public boolean areControlsCreated() {
        return this._controlsCreated;
    }

    public void setModified(boolean bl) {
        if (this._ignoreModifiedEvents) {
            return;
        }
        if (bl) {
            RMAUtil.setParentModified((Component)this);
        }
        this._modified = bl;
    }

    public boolean isModified() {
        return this._modified;
    }
}

