/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.appInterface.AppDaddy;
import hec.clientapp.client.ClientApp;
import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.gui.PanelSelectorCard;
import hec.rss.client.OperatingLimitsPanel$1;
import hec.rss.model.PowerPlant;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import rma.swing.DefaultJPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJDecimalField;
import rma.util.RMAConst;

public class OperatingLimitsPanel
extends DefaultJPanel
implements PanelSelectorCard {
    private JPanel _minimumOLPanel;
    private RmaJCheckBox _restrictMinimumCheckBox;
    private RmaJDecimalField _restrictMinimumDecimalBox;
    private RmaJCheckBox _efficiencyReleaseCheckBox;
    private RmaJDecimalField _efficiencyReleaseDecimalBox;
    private JPanel _maximumOLPanel;
    private RmaJCheckBox _restrictMaximumCheckBox;
    private RmaJDecimalField _restrictMaximumDecimalBox;
    private PowerPlant _powerPlant;
    private JLabel _noteLabel;

    public OperatingLimitsPanel() {
        super((LayoutManager)new GridBagLayout());
        this.buildControls();
        this.setToolTip();
        this.addActionListeners();
    }

    private void addActionListeners() {
        OperatingLimitsPanel$1 operatingLimitsPanel$1 = new OperatingLimitsPanel$1(this);
        this._restrictMaximumCheckBox.addActionListener((ActionListener)operatingLimitsPanel$1);
        this._restrictMinimumCheckBox.addActionListener((ActionListener)operatingLimitsPanel$1);
        this._efficiencyReleaseCheckBox.addActionListener((ActionListener)operatingLimitsPanel$1);
    }

    private void setToolTip() {
        this._restrictMinimumDecimalBox.setToolTipText("Release no less than a specified minimum flow. The user will enter a minimum flow for the turbineand the ResSim computational logic will not assign a release to that turbine less than the minimum flow. Note - flow for station service use (electrical power for the reservoir project or other bypass structures) should be accounted for separately.");
        this._efficiencyReleaseDecimalBox.setToolTipText("Release water through a power plant only when the plant can operate within a limited efficiency band. The user will enter a minimum efficiency and ResSim will not assign a release through the outlet that causes the plant to operate at less than the given efficiency");
        this._restrictMaximumDecimalBox.setToolTipText("Release no more than a specified maximum flow.  The user will enter a maximum flow for the outlet and the ResSim computational logic will not assign a release to that outlet greater than the maximum flow.  Although the outlets maximum capacity curve should be adequate to reflect a maximum release, the maximum turbine flow (flow used to generate power) may be less than the total outlet flow since a station service unit as well as other potential bypass structures may be included in the total flow capacity of a power plant).");
    }

    protected void buildControls() {
        this._minimumOLPanel = new JPanel(new GridBagLayout());
        this._minimumOLPanel.setBorder(BorderFactory.createTitledBorder("Minimum Operating Limits"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = RmaInsets.INSETS5050;
        gridBagConstraints.fill = 2;
        OperatingLimitsPanel operatingLimitsPanel = this;
        operatingLimitsPanel.add(operatingLimitsPanel._minimumOLPanel, gridBagConstraints);
        this._restrictMinimumCheckBox = new RmaJCheckBox("Restrict Power Release to at Least (%S):");
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = RmaInsets.INSETS5050;
        gridBagConstraints.fill = 0;
        this._minimumOLPanel.add((Component)this._restrictMinimumCheckBox, gridBagConstraints);
        this._restrictMinimumDecimalBox = new RmaJDecimalField();
        this._restrictMinimumDecimalBox.setDisplayUnitsSystem(AppDaddy.getApp().getClientUnitSystem());
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5555;
        this._minimumOLPanel.add((Component)this._restrictMinimumDecimalBox, gridBagConstraints);
        this._restrictMinimumCheckBox.setLabelFor((Component)this._restrictMinimumDecimalBox);
        this._efficiencyReleaseCheckBox = new RmaJCheckBox("Only Release for Power if Efficiency is at Least (%):");
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = RmaInsets.INSETS5050;
        this._minimumOLPanel.add((Component)this._efficiencyReleaseCheckBox, gridBagConstraints);
        this._efficiencyReleaseDecimalBox = new RmaJDecimalField();
        this._efficiencyReleaseDecimalBox.setMinValue(0.0);
        this._efficiencyReleaseDecimalBox.setMaxValue(100.0);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.01;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5555;
        this._minimumOLPanel.add((Component)this._efficiencyReleaseDecimalBox, gridBagConstraints);
        this._maximumOLPanel = new JPanel(new GridBagLayout());
        this._maximumOLPanel.setBorder(BorderFactory.createTitledBorder("Maximum Operating Limits"));
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.01;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = RmaInsets.INSETS5050;
        gridBagConstraints.fill = 2;
        OperatingLimitsPanel operatingLimitsPanel2 = this;
        operatingLimitsPanel2.add(operatingLimitsPanel2._maximumOLPanel, gridBagConstraints);
        this._restrictMaximumCheckBox = new RmaJCheckBox("Restrict Power Release to No More Than (%S):        ");
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = RmaInsets.INSETS5050;
        this._maximumOLPanel.add((Component)this._restrictMaximumCheckBox, gridBagConstraints);
        this._restrictMaximumDecimalBox = new RmaJDecimalField();
        this._restrictMaximumDecimalBox.setDisplayUnitsSystem(AppDaddy.getApp().getClientUnitSystem());
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.001;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5555;
        this._maximumOLPanel.add((Component)this._restrictMaximumDecimalBox, gridBagConstraints);
        this._restrictMaximumCheckBox.setLabelFor((Component)this._restrictMaximumDecimalBox);
        this.updateTextBoxStatus();
    }

    public String getTabname() {
        return "Operating Limits";
    }

    public void fillPanel(PowerPlant powerPlant) {
        if (powerPlant == null) {
            return;
        }
        this._powerPlant = powerPlant;
        this._restrictMinimumCheckBox.setSelected(this._powerPlant.isRestrictMinimum());
        this._restrictMaximumCheckBox.setSelected(this._powerPlant.isRestrictMaximum());
        this._efficiencyReleaseCheckBox.setSelected(this._powerPlant.isEfficiencyRelease());
        if (RMAConst.isValidValue((double)this._powerPlant.getRestrictMinimum())) {
            double d = this._powerPlant.getRestrictMinimum();
            ClientApp.app();
            this._restrictMinimumDecimalBox.setValue(new ParamDouble(d, Parameter.PARAMID_FLOW, ClientApp.Workspace().getUnitSystem()));
        }
        if (RMAConst.isValidValue((double)this._powerPlant.getRestrictMaximum())) {
            double d = this._powerPlant.getRestrictMaximum();
            ClientApp.app();
            this._restrictMaximumDecimalBox.setValue(new ParamDouble(d, Parameter.PARAMID_FLOW, ClientApp.Workspace().getUnitSystem()));
        }
        this._efficiencyReleaseDecimalBox.setValue(this._powerPlant.getEfficiencyRelease());
        this.updateTextBoxStatus();
    }

    public boolean savePanel() {
        if (this._powerPlant == null) {
            return false;
        }
        this._powerPlant.setIsRestrictMinimum(this._restrictMinimumCheckBox.isSelected());
        this._powerPlant.setRestrictMinimum(this._restrictMinimumDecimalBox.getParamValue().convertToUnitSystem(AppDaddy.getApp().getClientUnitSystem()));
        this._powerPlant.setIsRestrictMaximum(this._restrictMaximumCheckBox.isSelected());
        this._powerPlant.setRestrictMaximum(this._restrictMaximumDecimalBox.getParamValue().convertToUnitSystem(AppDaddy.getApp().getClientUnitSystem()));
        this._powerPlant.setIsEfficiencyRelease(this._efficiencyReleaseCheckBox.isSelected());
        this._powerPlant.setEfficiencyRelease(this._efficiencyReleaseDecimalBox.getValue());
        return true;
    }

    public boolean verifyPanel() {
        if (this._restrictMinimumCheckBox.isSelected() && RMAConst.isUndefinedValue((double)this._restrictMinimumDecimalBox.getValue())) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Must specify a minimum power release (or uncheck the box).", "Missing Power Restriction", 0);
            return false;
        }
        if (this._restrictMaximumCheckBox.isSelected() && RMAConst.isUndefinedValue((double)this._restrictMaximumDecimalBox.getValue())) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Must specify a maximum power release (or uncheck the box).", "Missing Power Restriction", 0);
            return false;
        }
        if (this._efficiencyReleaseCheckBox.isSelected() && RMAConst.isUndefinedValue((double)this._efficiencyReleaseDecimalBox.getValue())) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Must specify a minimum operating efficiency(or uncheck the box).", "Missing Power Efficiency", 0);
            return false;
        }
        return true;
    }

    private void updateTextBoxStatus() {
        this._restrictMinimumDecimalBox.setEnabled(this._restrictMinimumCheckBox.isSelected());
        this._restrictMaximumDecimalBox.setEnabled(this._restrictMaximumCheckBox.isSelected());
        this._efficiencyReleaseDecimalBox.setEnabled(this._efficiencyReleaseCheckBox.isSelected());
    }
}

