/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.rss.client.OperatingReservoirEditor$1;
import hec.rss.client.OperationSetRemoveRuleDialog;
import hec.rss.client.ReservoirJFrame;
import hec.rss.model.OpSet;
import hec.rss.model.ReservoirElement;
import hec.rss.model.StorageZone;
import hec.rss.model.SystemHydropowerOpRule;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaInsets;
import rma.swing.RmaJDialog;
import rma.swing.RmaJTable;

public class OperatingReservoirEditor
extends RmaJDialog
implements ActionListener {
    private RmaJTable _resTable;
    private ButtonCmdPanel _cmdPanel;
    private SystemHydropowerOpRule _hydroRule;
    private List<ReservoirElement> _removeRuleFromReservoirs = new ArrayList<ReservoirElement>();
    private Map<String, List<ReservoirElement>> _opsetToResTable = new HashMap<String, List<ReservoirElement>>();
    private Map<ReservoirElement, List<String>> _reservoirToOpset = new HashMap<ReservoirElement, List<String>>();

    public OperatingReservoirEditor(JDialog jDialog) {
        super((Dialog)jDialog, true);
        this.buildControls();
        this.setLocationRelativeTo(jDialog);
        this.setDefaultCloseOperation(2);
    }

    private void buildControls() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Hydropower - System Rule: Operating Reseroirs");
        this._resTable = new RmaJTable((Component)((Object)this), (Object[])new String[]{"Reservoir", "Operation Set(s)"});
        this._resTable.setAllColumnsEnabled(false);
        this._resTable.setSelectionMode(2);
        this._resTable.setColumnSelectionAllowed(false);
        this._resTable.setCellSelectionEnabled(false);
        this._resTable.setRowSelectionAllowed(true);
        this._resTable.setPopupMenu(this.createTablePopupMenu());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        this.getContentPane().add((Component)this._resTable.getScrollPane(), gridBagConstraints);
        this._cmdPanel = new ButtonCmdPanel(12);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this._cmdPanel, gridBagConstraints);
        this._cmdPanel.addCmdPanelListener((ButtonCmdPanelListener)new OperatingReservoirEditor$1(this));
        this.pack();
    }

    public void fill(Vector vector, SystemHydropowerOpRule namedType) {
        this._hydroRule = namedType;
        new ArrayList();
        this._resTable.deleteCells();
        for (int i = 0; i < vector.size(); ++i) {
            ArrayList<String> arrayList = new ArrayList<String>();
            Vector<Object> vector2 = new Vector<Object>();
            if (!(vector.get(i) instanceof ReservoirElement)) continue;
            namedType = (ReservoirElement)vector.get(i);
            Vector<OpSet> vector3 = namedType.getReservoirOp().getOperationSets();
            for (int j = 0; j < vector3.size(); ++j) {
                if (!(vector3.get(j) instanceof OpSet)) continue;
                OpSet opSet = vector3.get(j);
                Vector vector4 = new Vector();
                namedType.getRules(opSet._index, vector4);
                for (int k = 0; k < vector4.size(); ++k) {
                    if (!vector4.get(k).toString().equalsIgnoreCase(this._hydroRule.toString())) continue;
                    arrayList.add(opSet.getDisplayName());
                }
            }
            if (arrayList.isEmpty()) continue;
            vector2.add(namedType);
            vector2.add(arrayList);
            this._resTable.appendRow(vector2);
        }
        this._resTable.setColumnWidth(0, 25);
    }

    private void saveForm() {
        Iterator<ReservoirElement> iterator = this._reservoirToOpset.keySet().iterator();
        while (iterator.hasNext()) {
            ReservoirElement reservoirElement;
            ReservoirElement reservoirElement2 = reservoirElement = iterator.next();
            List<String> list = this._reservoirToOpset.get(reservoirElement);
            for (int i = 0; i < list.size(); ++i) {
                OpSet opSet = reservoirElement2.getReservoirOp().getOperationSet(list.get(i));
                if (opSet == null) continue;
                Vector vector = opSet.getZoneVector();
                new StorageZone();
                for (int j = 0; j < vector.size(); ++j) {
                    StorageZone storageZone = (StorageZone)vector.get(j);
                    storageZone.removeRule(this._hydroRule);
                    storageZone.setModified(true);
                    reservoirElement2.setModified(true);
                }
                if (!(this.getParent() instanceof ReservoirJFrame) || !reservoirElement2.getName().equalsIgnoreCase(((ReservoirJFrame)((Object)this.getParent()))._currentReservoir) || !opSet.getName().equalsIgnoreCase(((ReservoirJFrame)((Object)this.getParent())).getOperationsPanel()._currentOpSet._name)) continue;
                ((ReservoirJFrame)((Object)this.getParent())).getOperationsPanel().fillPanel(opSet);
            }
        }
        if (this.getParent() instanceof ReservoirJFrame) {
            ((ReservoirJFrame)((Object)this.getParent())).setModified(true);
        }
    }

    protected JPopupMenu createTablePopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Remove Rule from ALL Operation Sets");
        jMenuItem.setActionCommand("removeRuleFromAll");
        jMenuItem.addActionListener(this);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Remove Rule from Specific Operation Sets");
        jMenuItem.setActionCommand("removeRuleFromSpecific");
        jMenuItem.addActionListener(this);
        jPopupMenu.add(jMenuItem);
        return jPopupMenu;
    }

    @Override
    public void actionPerformed(ActionEvent object) {
        if ((object = ((EventObject)object).getSource()) instanceof JMenuItem) {
            object = (JMenuItem)object;
            if ("removeRuleFromAll".equals(object = ((AbstractButton)object).getActionCommand())) {
                this.removeRuleFromAllAction();
                return;
            }
            if ("removeRuleFromSpecific".equals(object)) {
                this.removeRuleFromSpecificAction();
            }
        }
    }

    private void removeRuleFromAllAction() {
        Object object;
        int n;
        int[] nArray = this._resTable.getSelectedRows();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (n = 0; n < nArray.length; ++n) {
            int n2 = nArray[n];
            object = this._resTable.getCell(n2, 0);
            if (!(object instanceof ReservoirElement) || (object = (ReservoirElement)object) == null) continue;
            arrayList.add(object);
        }
        if (!arrayList.isEmpty() && (n = JOptionPane.showConfirmDialog((Component)((Object)this), "Continue to remove the rule from ALL operating sets in the following Reservoir(s): \n" + ((Object)arrayList).toString() + "?", "Remove Rule", 2, 3)) == 0) {
            int n3;
            int n4;
            for (n4 = 0; n4 < nArray.length; ++n4) {
                int n5 = nArray[n4];
                List<Object> list = !this._reservoirToOpset.containsKey(arrayList.get(n4)) ? new ArrayList() : this._reservoirToOpset.get(arrayList.get(n4));
                object = this._resTable.getCell(n5, 1);
                if (!(object instanceof List)) continue;
                object = (List)object;
                for (n3 = 0; n3 < object.size(); ++n3) {
                    if (list.contains(object.get(n3))) continue;
                    list.add((String)object.get(n3));
                }
                this._reservoirToOpset.put((ReservoirElement)arrayList.get(n4), list);
            }
            n4 = 0;
            for (n3 = 0; n3 < nArray.length; ++n3) {
                int n6 = nArray[n3];
                if (n3 > 0 && (n6 -= ++n4) <= 0) {
                    n6 = 0;
                }
                this._resTable.deleteRow(n6);
            }
        }
    }

    private void removeRuleFromSpecificAction() {
        List<String> list;
        Object object;
        int n;
        Object object2 = this._resTable.getSelectedRows();
        ArrayList<ReservoirElement> arrayList = new ArrayList<ReservoirElement>();
        new ArrayList();
        for (int i = 0; i < ((int[])object2).length; ++i) {
            n = object2[i];
            object = this._resTable.getCell(n, 0);
            if (!(object instanceof ReservoirElement)) continue;
            ReservoirElement reservoirElement = (ReservoirElement)object;
            if (reservoirElement != null) {
                arrayList.add(reservoirElement);
            }
            if (!((object = this._resTable.getCell(n, 1)) instanceof List)) continue;
            list = (List<String>)object;
            for (int j = 0; j < list.size(); ++j) {
                List<ReservoirElement> list2;
                object = (String)list.get(j);
                if (!this._opsetToResTable.containsKey(object)) {
                    ArrayList arrayList2 = new ArrayList();
                    this._opsetToResTable.put((String)object, arrayList2);
                }
                if ((list2 = this._opsetToResTable.get(object)).contains(reservoirElement)) continue;
                list2.add(reservoirElement);
                this._opsetToResTable.put((String)object, list2);
            }
        }
        if (!arrayList.isEmpty()) {
            OperationSetRemoveRuleDialog operationSetRemoveRuleDialog = new OperationSetRemoveRuleDialog((JDialog)((Object)this));
            operationSetRemoveRuleDialog.fill(this._opsetToResTable);
            operationSetRemoveRuleDialog.setVisible(true);
            Map<ReservoirElement, List<String>> map = operationSetRemoveRuleDialog.getRemoveOpsetList();
            this._reservoirToOpset.putAll(map);
            n = this._resTable.getRowCount();
            for (int i = 0; i < n; ++i) {
                ReservoirElement reservoirElement;
                object = this._resTable.getCell(i, 0);
                if (!(object instanceof ReservoirElement) || !map.containsKey(reservoirElement = (ReservoirElement)object)) continue;
                list = map.get(reservoirElement);
                object = this._resTable.getCell(i, 1);
                if (!(object instanceof List)) continue;
                object2 = (List)object;
                for (int j = 0; j < list.size(); ++j) {
                    object = list.get(j);
                    if (!object2.contains(object)) continue;
                    object2.remove(object);
                }
                if (object2.isEmpty()) {
                    this._resTable.deleteRow(i);
                    --i;
                    continue;
                }
                this._resTable.setCell(object2, i, 1);
            }
        }
    }
}

