/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.rss.client.OutletUsageOptionsDialog$1;
import hec.rss.model.AdjustableFlow;
import hec.rss.model.Element;
import hec.rss.model.InducedSurchargeOpRule;
import hec.rss.model.OutletUsageModel;
import hec.rss.model.ReservoirOp;
import hec.rss.model.Spillway;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Vector;
import javax.swing.JDialog;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaInsets;
import rma.swing.RmaJTable;

public class OutletUsageOptionsDialog
extends JDialog {
    int[] _elem;
    InducedSurchargeOpRule _rule;
    private ButtonCmdPanel _cmdPanel;
    private RmaJTable _outletTable;
    private ReservoirOp _resOp;
    private OutletUsageModel _outletModel;
    private Vector _outlets;

    public OutletUsageOptionsDialog(Dialog dialog, boolean bl) {
        super(dialog, bl);
        this.buildControls();
    }

    public void setReservoirOp(ReservoirOp cloneable) {
        Boolean bl = Boolean.FALSE;
        this._resOp = cloneable;
        cloneable = this._resOp.getReservoirElement();
        this._outlets = new Vector();
        ((Element)((Object)cloneable)).getElementsByClass(AdjustableFlow.class, this._outlets);
        ((Element)((Object)cloneable)).getElementsByClass(Spillway.class, this._outlets);
        this._outletTable.deleteCells();
        this._elem = new int[this._outlets.size()];
        for (int i = 0; i < this._outlets.size(); ++i) {
            this._elem[i] = ((Element)this._outlets.get(i)).getIndex();
            cloneable = new Vector(3);
            ((Vector)cloneable).add(this._outlets.get(i));
            ((Vector)cloneable).add(bl);
            ((Vector)cloneable).add(bl);
            this._outletTable.appendRow((Vector)cloneable);
        }
    }

    public void fillForm(InducedSurchargeOpRule serializable) {
        int n;
        this._rule = serializable;
        this._outletModel = new OutletUsageModel();
        if (this._rule.getOutletUsageModel() == null) {
            this._outletModel.setGateElements(this._elem);
            return;
        }
        this._outletModel = this._rule.getOutletUsageModel();
        for (n = 0; n < this._outlets.size(); ++n) {
            if (this._outletModel.isUsed(this._elem[n])) {
                serializable = Boolean.TRUE;
                this._outletTable.setValueAt((Object)serializable, n, 1);
                continue;
            }
            serializable = Boolean.FALSE;
            this._outletTable.setValueAt((Object)serializable, n, 1);
        }
        for (n = 0; n < this._outlets.size(); ++n) {
            if (this._outletModel.isRequired(this._elem[n])) {
                serializable = Boolean.TRUE;
                this._outletTable.setValueAt((Object)serializable, n, 2);
                continue;
            }
            serializable = Boolean.FALSE;
            this._outletTable.setValueAt((Object)serializable, n, 2);
        }
    }

    public void save() {
        this._outletModel.setGateElements(this._elem);
        for (int i = 0; i < this._outletTable.getRowCount(); ++i) {
            int n = this._elem[i];
            boolean bl = (Boolean)this._outletTable.getValueAt(i, 1);
            this._outletModel.setUsed(n, bl);
            bl = (Boolean)this._outletTable.getValueAt(i, 2);
            this._outletModel.setRequired(n, bl);
        }
        this._rule.setOutletUsageModel(this._outletModel);
    }

    private void buildControls() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Outlet Usage Options");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this._outletTable = new RmaJTable((Component)this, (Object[])new String[]{"Outlet", "Uses", "Req'd"});
        this._outletTable.setColumnEnabled(false, 0);
        this._outletTable.setCheckBoxCellEditor(1);
        this._outletTable.setCheckBoxCellEditor(2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)this._outletTable.getScrollPane(), gridBagConstraints);
        this._cmdPanel = new ButtonCmdPanel(12);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)10, (int)5, (int)10, (int)10);
        this.getContentPane().add((Component)this._cmdPanel, gridBagConstraints);
        this._cmdPanel.addCmdPanelListener((ButtonCmdPanelListener)new OutletUsageOptionsDialog$1(this));
        this.setSize(250, 200);
        OutletUsageOptionsDialog outletUsageOptionsDialog = this;
        outletUsageOptionsDialog.setLocationRelativeTo(outletUsageOptionsDialog.getParent());
    }
}

