/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import com.google.common.flogger.FluentLogger;
import hec.clientapp.client.ClientApp;
import hec.clientapp.model.TSRecordProxy;
import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.dssgui.BrowseDSS;
import hec.dssgui.DSSListSelector;
import hec.gfx2d.G2dDialog;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.G2dPanelProp;
import hec.gfx2d.G2dPlotProp;
import hec.gfx2d.HotPlotDefaults;
import hec.gfx2d.PlotDefaults;
import hec.gfx2d.PlotDefaultsManager;
import hec.heclib.dss.DSSPathname;
import hec.heclib.dss.DataReference;
import hec.heclib.util.HecTime;
import hec.heclib.util.HecTimeArray;
import hec.io.DSSIdentifier;
import hec.io.TimeSeriesContainer;
import hec.model.Interpolate;
import hec.model.RunTimeWindow;
import hec.rss.client.AbstractElementOverridesPanel;
import hec.rss.client.OverridesPanel$1;
import hec.rss.client.OverridesPanel$2;
import hec.rss.client.OverridesPanel$3;
import hec.rss.client.OverridesPanel$MyG2dPanel;
import hec.rss.client.RssSpecifyOverridesDialog;
import hec.rss.client.UseAltResultsEditor;
import hec.rss.gfx2d.SimpleJTableData;
import hec.rss.model.AdjustableDiversion;
import hec.rss.model.AdjustableFlow;
import hec.rss.model.DiversionElement;
import hec.rss.model.Element;
import hec.rss.model.Function;
import hec.rss.model.ReleaseOverrides;
import hec.rss.model.ReservoirElement;
import hec.rss.model.RssModelVariableConstants;
import hec.rss.model.RssRun;
import hec.rss.model.RssSystem;
import hec.rss.model.Spillway;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.FileNotFoundException;
import java.lang.constant.Constable;
import java.rmi.RemoteException;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import mil.army.usace.hec.rmi.csinterface.BaseDSSManager;
import mil.army.usace.hec.rmi.csinterface.DSSManager;
import mil.army.usace.hec.rmi.gfx2d.SimpleDSSTimeSeries;
import mil.army.usace.hec.rmi.server.RmiFileCallBackImpl;
import rma.swing.DefaultJPanel;
import rma.swing.RmaGridBagConstraints;
import rma.swing.RmaImage;
import rma.swing.RmaInsets;
import rma.swing.RmaJButton;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJLabel;
import rma.swing.RmaJTable;
import rma.swing.event.ReflectMultiListener;
import rma.swing.event.TableChangeListener;
import rma.swing.event.TableUpdateEvent;
import rma.swing.list.RmaListModel;
import rma.swing.table.CellLocation;
import rma.swing.table.RmaCellEditor;
import rma.swing.table.RmaDateTimeRenderer;
import rma.swing.table.RmaTableModel;
import rma.util.RMAIO;

public class OverridesPanel
extends DefaultJPanel
implements RssModelVariableConstants,
ItemListener,
CellEditorListener,
TableChangeListener {
    private static final FluentLogger c = FluentLogger.forEnclosingClass();
    private static ImageIcon d = RmaImage.getImageIcon((String)"Images/Icons/checkBoxUnselected.gif");
    private static ImageIcon e = RmaImage.getImageIcon((String)"Images/Icons/checkBoxSelected.gif");
    public static final Color NEW_EDIT_COLOR = Color.blue;
    public static final Color PREV_EDIT_COLOR = Color.green;
    public static final Color MODEL_COLOR = Color.black;
    public static final String DEF_TITLE = "Release Overrides ";
    Frame _parent;
    int _overridesType = 0;
    RssRun _rssRun;
    Vector<String> _nameVec;
    boolean _first = true;
    boolean _useAnotherAlt = false;
    boolean _tableInitialized = false;
    String _currentName = "";
    SimpleDSSTimeSeries _currentTSData = null;
    Integer[] _hecMinutes = null;
    Hashtable _dssTsDataTable;
    ReleaseOverrides _releaseOverrides = null;
    BrowseDSS _browseDSS = null;
    DSSListSelector _selectFrame;
    DSSManager _dssManager = null;
    ReflectMultiListener _listener;
    JPanel tablePanel;
    JPanel specifyButtonPanel;
    JPanel plotPanel;
    private RmaJCheckBox _useAltResultsCheckbox;
    private RmaJButton _selectAltResultsButton;
    private JPanel _useAltResultsPanel;
    private UseAltResultsEditor _useAltResultsEditor;
    RmaJLabel _outletLbl = new RmaJLabel("Outlet:");
    RmaJComboBox _outletCombo;
    JButton unspecifyButton = new JButton("Unspecify");
    JButton unspecifyAllButton = new JButton("Unspecify All");
    JButton importButton = new JButton("Import...");
    RmaJTable releaseTable;
    G2dPanel outputPlot;
    int _wkspUnitSys;
    RmiFileCallBackImpl _lockCallback;
    String[] _releaseNames;
    String _keyString;
    AbstractElementOverridesPanel _parentPanel;
    RmaJDecimalField _valuesEditor;
    private String _ensemblePrefix;
    private Map<String, Hashtable> _overridesMap = new HashMap<String, Hashtable>();
    protected static final Insets a = new Insets(5, 0, 0, 0);
    protected static final Insets b = new Insets(0, 0, 0, 0);

    public OverridesPanel() {
        this.buildControls();
        this.setVisible(true);
    }

    public OverridesPanel(AbstractElementOverridesPanel abstractElementOverridesPanel) {
        this._parentPanel = abstractElementOverridesPanel;
        this.buildControls();
        this.setVisible(true);
    }

    protected void buildControls() {
        this.setLayout(new GridBagLayout());
        this._listener = new ReflectMultiListener();
        this._outletCombo = new OverridesPanel$1(this, (ComboBoxModel)new RmaListModel(false));
        this._outletCombo.setModifiable(false);
        OverridesPanel overridesPanel = this;
        overridesPanel.add((Component)overridesPanel._outletLbl, new RmaGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, INSETS5555, 0, 0));
        OverridesPanel overridesPanel2 = this;
        overridesPanel2.add((Component)overridesPanel2._outletCombo, new RmaGridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, INSETS5555, 0, 0));
        this._outletLbl.setLabelFor((Component)this._outletCombo);
        this.tablePanel = new JPanel(new GridBagLayout());
        OverridesPanel overridesPanel3 = this;
        overridesPanel3.add(overridesPanel3.tablePanel, new RmaGridBagConstraints(0, 3, 2, 2, 1.0, 1.0, 18, 1, b, 0, 0));
        Object object = new String[]{"Date", "Time", "Release (%S)"};
        this.releaseTable = new RmaJTable((Component)((Object)this), (Object[])object);
        this.releaseTable.setColumnEnabled(false, 0);
        this.releaseTable.setColumnEnabled(false, 1);
        this.releaseTable.setColumnBackground(0, Color.lightGray);
        this.releaseTable.setColumnBackground(1, Color.lightGray);
        this.releaseTable.setColumnWidth(1, 50);
        this.releaseTable.setColumnWidth(2, 50);
        this.releaseTable.setAddRemoveEnabled(false);
        this.releaseTable.setPasteForeground(NEW_EDIT_COLOR);
        this.releaseTable.setPrecision(2);
        this._valuesEditor = this.releaseTable.setDoubleCellEditor(2, true);
        this.releaseTable.setUnitsHeaderRenderer();
        this.releaseTable.getColumnModel().getColumn(0).setCellRenderer((TableCellRenderer)new RmaDateTimeRenderer(0, "ddMMMyyyy"));
        this.releaseTable.getColumnModel().getColumn(1).setCellRenderer((TableCellRenderer)new RmaDateTimeRenderer(1));
        this.tablePanel.add((Component)this.releaseTable.getScrollPane(), new RmaGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, b, 0, 0));
        this.specifyButtonPanel = new JPanel(new GridBagLayout());
        OverridesPanel overridesPanel4 = this;
        overridesPanel4.add(overridesPanel4.specifyButtonPanel, new RmaGridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 18, 0, a, 0, 0));
        this._useAltResultsPanel = new JPanel(new GridBagLayout());
        this._useAltResultsCheckbox = new RmaJCheckBox("Copy from Results");
        object = new RmaGridBagConstraints();
        new RmaGridBagConstraints().gridx = 0;
        object.gridy = 0;
        object.weightx = 0.0;
        object.weighty = 0.0;
        object.anchor = 18;
        object.fill = 2;
        this._useAltResultsCheckbox.addActionListener((ActionListener)new OverridesPanel$2(this));
        this._selectAltResultsButton = new RmaJButton("Use Results From ...");
        this._selectAltResultsButton.setMnemonic('U');
        this._selectAltResultsButton.setIcon((Icon)d);
        object = new RmaGridBagConstraints();
        new RmaGridBagConstraints().gridx = 1;
        object.gridy = 0;
        object.weightx = 1.0;
        object.weighty = 0.0;
        object.anchor = 18;
        object.fill = 2;
        object.insets = RmaInsets.INSETS5550;
        this._useAltResultsPanel.add((Component)this._selectAltResultsButton, object);
        this._selectAltResultsButton.addActionListener((ActionListener)new OverridesPanel$3(this));
        object = new RmaGridBagConstraints();
        new RmaGridBagConstraints().gridx = 0;
        object.gridy = 0;
        object.weightx = 0.0;
        object.weighty = 0.0;
        object.anchor = 11;
        object.fill = 2;
        object.insets = RmaInsets.INSETS0000;
        this.specifyButtonPanel.add((Component)this._useAltResultsPanel, object);
        this._useAltResultsPanel.setVisible(false);
        this.specifyButtonPanel.add((Component)this.unspecifyButton, new RmaGridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 11, 2, INSETS5505, 0, 0));
        this.specifyButtonPanel.add((Component)this.unspecifyAllButton, new RmaGridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 11, 2, INSETS5505, 0, 0));
        this.specifyButtonPanel.add((Component)this.importButton, new RmaGridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 11, 2, INSETS5505, 0, 0));
        this.plotPanel = new JPanel(new GridBagLayout());
        this.specifyButtonPanel.add((Component)this.plotPanel, new RmaGridBagConstraints(0, 6, 1, 1, 1.0, 1.0, 15, 1, a, 100, 120));
        this.outputPlot = new OverridesPanel$MyG2dPanel(this);
        OverridesPanel overridesPanel5 = this;
        overridesPanel5.configurePlotPanel(overridesPanel5.outputPlot);
        object = this.getPlotArray();
        Vector<RmaGridBagConstraints> vector = new Vector<RmaGridBagConstraints>();
        vector.addElement((RmaGridBagConstraints)object);
        this.outputPlot.setPlotObjects(vector);
        this.plotPanel.add((Component)this.outputPlot, new RmaGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 15, 1, INSETS5505, 0, 0));
        OverridesPanel overridesPanel6 = this;
        this.unspecifyButton.addActionListener((ActionListener)this._listener.add((Object)overridesPanel6, (Object)overridesPanel6.unspecifyButton, "unspecify_Action"));
        OverridesPanel overridesPanel7 = this;
        this.unspecifyAllButton.addActionListener((ActionListener)this._listener.add((Object)overridesPanel7, (Object)overridesPanel7.unspecifyAllButton, "unspecifyAll_Action"));
        OverridesPanel overridesPanel8 = this;
        this.importButton.addActionListener((ActionListener)this._listener.add((Object)overridesPanel8, (Object)overridesPanel8.importButton, "import_Action"));
        this.releaseTable.addCellEditorListener((CellEditorListener)this);
        this.releaseTable.addTableChangeListener((TableChangeListener)this);
        this._outletLbl.setDisplayedMnemonic('O');
        this.unspecifyButton.setMnemonic('U');
        this.unspecifyAllButton.setMnemonic('A');
        this.importButton.setMnemonic('I');
    }

    public void setUseAltResultsPanelVisible(boolean bl) {
        this._useAltResultsPanel.setVisible(bl);
    }

    public void useAltCheckboxAction() {
        if (this._useAltResultsCheckbox.isSelected()) {
            OverridesPanel overridesPanel = this;
            this._releaseOverrides.setUseOtherAlt(true, overridesPanel.getKeyStringForName(overridesPanel._currentName));
            this._selectAltResultsButton.setIcon((Icon)e);
            this.useAltEditButtonAction();
            this.unspecifyAllButton.setEnabled(false);
            this.unspecifyButton.setEnabled(false);
            this.importButton.setEnabled(false);
            return;
        }
        OverridesPanel overridesPanel = this;
        String string = overridesPanel.getKeyStringForName(overridesPanel._currentName);
        this._releaseOverrides.getUseOtherAltName(string);
        this._selectAltResultsButton.setIcon((Icon)d);
        this.releaseTable.setColumnEnabled(true, 2);
        this.unspecifyAllButton.setEnabled(true);
        this.unspecifyButton.setEnabled(true);
        this.importButton.setEnabled(true);
        this.unspecifyAll_Action();
        this._releaseOverrides.setUseOtherAlt(false, string);
    }

    public void useAltEditButtonAction() {
        if (this._useAltResultsEditor == null) {
            this._useAltResultsEditor = new UseAltResultsEditor(this._parentPanel.getEditor(), this._parentPanel.getReleasePanel(), this._rssRun);
            this._useAltResultsEditor.setLocationRelativeTo((Component)((Object)this._parentPanel.getEditor()));
        }
        OverridesPanel overridesPanel = this;
        this._useAltResultsEditor.setSelectedAlt(this._releaseOverrides.getUseOtherAltName(overridesPanel.getKeyStringForName(overridesPanel._currentName)));
        OverridesPanel overridesPanel2 = this;
        this._useAltResultsEditor.setCollectionSequence(this._releaseOverrides.getUseOtherAltCollectionSequence(overridesPanel2.getKeyStringForName(overridesPanel2._currentName)));
        this._useAltResultsEditor.setUseMulipleeRelease(this._releaseOverrides.replaceAllWithOtherAlt());
        ReservoirElement reservoirElement = this._rssRun.getNetwork().findReservoir(this._parentPanel.getSelectedElementName());
        if (reservoirElement != null) {
            this._useAltResultsEditor.setIsOutletsForThisReservoirRelease(reservoirElement.useOverridesForThisReservoir());
        }
        this._useAltResultsEditor.setVisible(true);
    }

    public void setSelectedAltData() {
        Object object = this._useAltResultsEditor.getSelectedAlt();
        if (object == null) {
            return;
        }
        String string = this._useAltResultsEditor.getCollectionSelected();
        if (object instanceof RssRun) {
            Object object2;
            object = (RssRun)object;
            String string2 = ((RssRun)object).getOutputFPart();
            this._useAltResultsCheckbox.setSelected(true);
            this._selectAltResultsButton.setIcon((Icon)e);
            this.specifyButtonPanel.setEnabled(false);
            this.releaseTable.setColumnEnabled(false, 2);
            Vector<DataReference> vector = new Vector<DataReference>();
            String string3 = ((RssRun)object).getDSSOutputFile();
            if (string != null) {
                object2 = new DSSPathname();
                object2.setFPart(string2);
                object2.setCollectionSequence(string);
                ((RssRun)object).setOutputFPart(object2.getFPart());
            }
            if (this._useAltResultsEditor.isSingleRelease()) {
                this._releaseOverrides.setReplaceAll(false);
                this._releaseOverrides.setOverrideOutletsForThisReservoir(false, this._parentPanel.getSelectedElementName());
                object2 = ((RssRun)object).getNetwork().getFlowContolTSRecordProxies();
                if (object2 != null && ((Vector)object2).size() > 0) {
                    for (int i = 0; i < ((Vector)object2).size(); ++i) {
                        Object object3 = (TSRecordProxy)((Vector)object2).elementAt(i);
                        OverridesPanel overridesPanel = this;
                        if (!object3.getName().equals(overridesPanel.getKeyStringForName(overridesPanel._currentName))) continue;
                        object3 = ((RssRun)object).constructTSRecordProxyDssPath((TSRecordProxy)object3, "-REG");
                        DataReference dataReference = new DataReference((String)object3, string3);
                        vector.add(dataReference);
                        break;
                    }
                }
            } else if (this._useAltResultsEditor.isMultipleRelease()) {
                Object object4;
                Vector vector2;
                int n;
                this._releaseOverrides.setReplaceAll(true);
                this._releaseOverrides.setOverrideOutletsForThisReservoir(false, this._parentPanel.getSelectedElementName());
                String[] stringArray = this._rssRun.getAlternative().getSystem().getReservoirNames();
                Vector<String> vector3 = new Vector<String>();
                for (n = 0; n < stringArray.length; ++n) {
                    ReservoirElement reservoirElement = this._rssRun.getAlternative().getSystem().findReservoir(stringArray[n]);
                    if (reservoirElement == null) continue;
                    Class<Element> clazz = Element.class;
                    vector2 = reservoirElement.getElementsByClass(clazz, null);
                    int n2 = vector2.size();
                    vector3 = new Vector<String>();
                    ReservoirElement reservoirElement2 = reservoirElement;
                    vector3.addElement(reservoirElement2.getKeyStringForObject(reservoirElement2.getStorageFunction()));
                    for (int i = 0; i < n2; ++i) {
                        object4 = (Element)vector2.elementAt(i);
                        if (((Element)object4).getFunction() != null && !(((Element)object4).getFunction() instanceof AdjustableFlow)) continue;
                        Hashtable<Integer, Double> hashtable = object4;
                        vector3.addElement(((Element)((Object)hashtable)).getKeyStringForObject(((Element)((Object)hashtable)).getDownstreamNode()));
                    }
                }
                object2 = ((RssRun)object).getNetwork().getFlowContolTSRecordProxies();
                if (object2 != null && ((Vector)object2).size() > 0) {
                    for (n = 0; n < ((Vector)object2).size(); ++n) {
                        TSRecordProxy tSRecordProxy = (TSRecordProxy)((Vector)object2).elementAt(n);
                        for (int i = 0; i < vector3.size(); ++i) {
                            if (!tSRecordProxy.getName().equals(vector3.get(i))) continue;
                            object4 = ((RssRun)object).constructTSRecordProxyDssPath(tSRecordProxy, "-REG");
                            vector2 = new DataReference((String)object4, string3);
                            vector.add((DataReference)vector2);
                            vector2 = new DSSIdentifier();
                            vector2.setDSSPath((String)object4);
                            vector2.setFileName(string3);
                            vector2.setTimeWindow(this._rssRun.getRunTimeWindow().getStartTime(), this._rssRun.getRunTimeWindow().getEndTime());
                            try {
                                vector2 = object.getDSSFileManager().readTS((DSSIdentifier)vector2, true);
                                object4 = new Hashtable<Integer, Double>();
                                if (((TimeSeriesContainer)vector2).numberValues <= 0) continue;
                                for (int j = 0; j < this._hecMinutes.length; ++j) {
                                    ((Hashtable)object4).put(new Integer(this._hecMinutes[j]), new Double(((TimeSeriesContainer)vector2).values[j]));
                                }
                                this._releaseOverrides.setReleaseValues(this.getKeyStringForName(tSRecordProxy.getName()), (Hashtable)object4, true, object.getName(), string);
                                continue;
                            }
                            catch (RemoteException remoteException) {
                                System.out.println("RemoteException " + String.valueOf(remoteException));
                                remoteException.printStackTrace();
                                continue;
                            }
                            catch (FileNotFoundException fileNotFoundException) {
                                FileNotFoundException fileNotFoundException2 = fileNotFoundException;
                                fileNotFoundException.printStackTrace();
                            }
                        }
                    }
                }
            } else if (this._useAltResultsEditor.isOutletsForThisReservoirRelease()) {
                this._releaseOverrides.setReplaceAll(false);
                this._releaseOverrides.setOverrideOutletsForThisReservoir(true, this._parentPanel.getSelectedElementName());
                object2 = ((Element)((RssRun)object).getNetwork().findReservoir(this._parentPanel.getSelectedElementName())).getFlowContolTSRecordProxies();
                if (object2 != null && ((Vector)object2).size() > 0) {
                    for (int i = 0; i < ((Vector)object2).size(); ++i) {
                        TSRecordProxy tSRecordProxy = (TSRecordProxy)((Vector)object2).elementAt(i);
                        for (int j = 0; j < this._nameVec.size(); ++j) {
                            if (!tSRecordProxy.getName().equals(this._nameVec.get(j))) continue;
                            Object object5 = ((RssRun)object).constructTSRecordProxyDssPath(tSRecordProxy, "-REG");
                            DataReference dataReference = new DataReference((String)object5, string3);
                            vector.add(dataReference);
                            DSSIdentifier dSSIdentifier = new DSSIdentifier();
                            dSSIdentifier.setDSSPath((String)object5);
                            dSSIdentifier.setFileName(string3);
                            dSSIdentifier.setTimeWindow(this._rssRun.getRunTimeWindow().getStartTime(), this._rssRun.getRunTimeWindow().getEndTime());
                            try {
                                dataReference = object.getDSSFileManager().readTS(dSSIdentifier, true);
                                object5 = new Hashtable();
                                for (int k = 0; k < this._hecMinutes.length; ++k) {
                                    ((Hashtable)object5).put(new Integer(this._hecMinutes[k]), new Double(dataReference.values[k]));
                                }
                                OverridesPanel overridesPanel = this;
                                this._releaseOverrides.setReleaseValues(overridesPanel.getKeyStringForName(overridesPanel._nameVec.get(j)), (Hashtable)object5, true, object.getName(), string);
                                continue;
                            }
                            catch (RemoteException remoteException) {
                                System.out.println("RemoteException " + String.valueOf(remoteException));
                                remoteException.printStackTrace();
                                continue;
                            }
                            catch (FileNotFoundException fileNotFoundException) {
                                FileNotFoundException fileNotFoundException3 = fileNotFoundException;
                                fileNotFoundException.printStackTrace();
                            }
                        }
                    }
                }
            }
            this.setDSSPathname(vector);
            ((RssRun)object).setOutputFPart(string2);
        } else {
            this._releaseOverrides.clearUserOtherAltOverrides();
            this._useAltResultsCheckbox.setSelected(false);
            this._selectAltResultsButton.setIcon((Icon)d);
            this.specifyButtonPanel.setEnabled(true);
            this.releaseTable.setColumnEnabled(true, 2);
        }
        this.useAltCheckboxAction();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (!this.isVisible()) {
            return;
        }
        Object object = itemEvent.getSource();
        if (object == this._outletCombo && itemEvent.getStateChange() == 1) {
            this.outletCombo_StateChange();
        }
    }

    void outletCombo_StateChange() {
        if (this.releaseTable.isModified()) {
            OverridesPanel overridesPanel = this;
            int n = JOptionPane.showConfirmDialog((Component)((Object)overridesPanel), "Save changes for " + overridesPanel._currentName + "?", "Save Outlet Input", 1);
            if (n == 2) {
                ItemListener[] itemListenerArray = this._outletCombo.getItemListeners();
                this._outletCombo.removeItemListener(itemListenerArray[0]);
                this._outletCombo.setSelectedItem((Object)this._currentName);
                this._outletCombo.addItemListener(itemListenerArray[0]);
                return;
            }
            if (n == 0) {
                this.savePanel();
                this.releaseTable.setModified(false);
            }
        }
        this.releaseTable.commitEdit(false);
        this.releaseTable.setModified(false);
        this.setCursor(Cursor.getPredefinedCursor(3));
        String string = (String)this._outletCombo.getSelectedItem();
        if (string == null) {
            return;
        }
        OverridesPanel overridesPanel = this;
        overridesPanel.fillForm(overridesPanel.releaseTable, string);
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.setModified(false);
        this._parentPanel._editor.setModified(false);
    }

    protected void setColumnHeader(RmaJTable rmaJTable, int n, int n2) {
        String[] stringArray = new String[]{"Date", "Time", "Release (%S)"};
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            nArray[i] = -1;
        }
        nArray[2] = n;
        if (n2 == 2) {
            stringArray[2] = "Elevation Target (%S)";
        } else if (n2 == 1) {
            stringArray[2] = "Release (%S)";
        } else if (n2 == 3) {
            stringArray[2] = "Gate Opening (%S)";
        } else if (n2 == 4) {
            stringArray[2] = "Factor";
            OverridesPanel overridesPanel = this;
            overridesPanel.configurePlotPanel(overridesPanel.outputPlot);
            SimpleJTableData simpleJTableData = this.getPlotArray();
            Vector<SimpleJTableData> vector = new Vector<SimpleJTableData>();
            vector.addElement(simpleJTableData);
            this.outputPlot.setPlotObjects(vector);
            this._valuesEditor.setMaxValue(1.0);
            this._valuesEditor.setMinValue(0.0);
        }
        rmaJTable.setColumnLabels(stringArray);
        rmaJTable.setColumnParameters(nArray);
    }

    public void setDiversion(DiversionElement diversionElement) {
        this._outletCombo.setVisible(false);
        this._outletLbl.setVisible(false);
        if (diversionElement == null || this._releaseOverrides == null) {
            return;
        }
        if (this._overridesType == 1) {
            Object object = Element.class;
            object = diversionElement.getElementsByClass((Class)object, null);
            int n = ((Vector)object).size();
            this._nameVec = new Vector();
            for (int i = 0; i < n; ++i) {
                Element element = (Element)((Vector)object).elementAt(i);
                if (element.getFunction() != null && !(element.getFunction() instanceof AdjustableDiversion) || element.getDownstreamNode() == null) continue;
                Element element2 = element;
                this._nameVec.addElement(element2.getKeyStringForObject(element2.getDownstreamNode()));
            }
            this._outletCombo.removeItemListener((ItemListener)this);
            this._outletCombo.removeAllItems();
            RssSystem rssSystem = diversionElement.getSystem();
            int n2 = this._nameVec.size();
            for (n = 0; n < n2; ++n) {
                object = rssSystem.getNameForKeyString(this._nameVec.elementAt(n));
                this._outletCombo.addItem(object);
            }
            if (this._outletCombo.getItemCount() <= 0) {
                return;
            }
            this._outletCombo.setSelectedIndex(0);
            String string = (String)this._outletCombo.getItemAt(0);
            this._outletCombo.addItemListener((ItemListener)this);
            OverridesPanel overridesPanel = this;
            overridesPanel.fillForm(overridesPanel.releaseTable, string);
        }
    }

    public void setReservoir(ReservoirElement object) {
        if (object == null || this._releaseOverrides == null) {
            return;
        }
        if (this._overridesType == 1 || this._overridesType == 3) {
            Class<Element> clazz = Element.class;
            Vector vector = ((Element)object).getElementsByClass(clazz, null);
            int n = vector.size();
            this._nameVec = new Vector();
            ReservoirElement reservoirElement = object;
            this._nameVec.addElement(reservoirElement.getKeyStringForObject(reservoirElement.getStorageFunction()));
            for (int i = 0; i < n; ++i) {
                Element element = (Element)vector.elementAt(i);
                if (element.getFunction() != null && !(element.getFunction() instanceof AdjustableFlow) || element.getDownstreamNode() == null) continue;
                Element element2 = element;
                this._nameVec.addElement(element2.getKeyStringForObject(element2.getDownstreamNode()));
            }
            this._outletCombo.removeItemListener((ItemListener)this);
            this._outletCombo.removeAllItems();
            RssSystem rssSystem = ((Element)object).getSystem();
            int n2 = this._nameVec.size();
            for (int i = 0; i < n2; ++i) {
                String string = rssSystem.getNameForKeyString(this._nameVec.elementAt(i));
                this._outletCombo.addItem((Object)string);
            }
            if (this._outletCombo.getItemCount() <= 0) {
                return;
            }
            this._outletCombo.setSelectedIndex(0);
            object = (String)this._outletCombo.getItemAt(0);
            this._outletCombo.addItemListener((ItemListener)this);
            this._outletCombo.setVisible(true);
            this._outletLbl.setVisible(true);
            OverridesPanel overridesPanel = this;
            overridesPanel.fillForm(overridesPanel.releaseTable, (String)object);
            return;
        }
        if (this._overridesType == 3) {
            Object object2 = AdjustableFlow.class;
            Vector vector = ((Element)object).getElementsByClass((Class)object2, null);
            int n = vector.size();
            object2 = new Vector();
            for (int i = 0; i < n; ++i) {
                Element element = (Element)vector.elementAt(i);
                AdjustableFlow adjustableFlow = (AdjustableFlow)element.getFunction();
                if (this._overridesType == 3 && !adjustableFlow.hasMultipleGateSettings()) continue;
                Element element3 = element;
                ((Vector)object2).addElement(element3.getKeyStringForObject(element3.getDownstreamNode()));
            }
            this._outletCombo.removeItemListener((ItemListener)this);
            this._outletCombo.removeAllItems();
            RssSystem rssSystem = ((Element)object).getSystem();
            int n3 = ((Vector)object2).size();
            for (int i = 0; i < n3; ++i) {
                object = rssSystem.getNameForKeyString((String)((Vector)object2).elementAt(i));
                this._outletCombo.addItem(object);
            }
            if (this._outletCombo.getItemCount() <= 0) {
                return;
            }
            this._outletCombo.setSelectedIndex(0);
            object = (String)this._outletCombo.getItemAt(0);
            this._outletCombo.addItemListener((ItemListener)this);
            this._outletCombo.setVisible(true);
            this._outletLbl.setVisible(true);
            OverridesPanel overridesPanel = this;
            overridesPanel.fillForm(overridesPanel.releaseTable, (String)object);
            return;
        }
        if (this._overridesType == 2) {
            this._outletCombo.setVisible(false);
            this._outletLbl.setVisible(false);
            TSRecordProxy tSRecordProxy = ((ReservoirElement)object).getStorageFunction().getTSRecordProxy(10);
            if (tSRecordProxy != null) {
                RssSystem rssSystem = ((Element)object).getSystem();
                object = rssSystem.getNameForKeyString(tSRecordProxy.getName());
                OverridesPanel overridesPanel = this;
                overridesPanel.fillForm(overridesPanel.releaseTable, (String)object);
            }
            return;
        }
        if (this._overridesType == 5 || this._overridesType == 6) {
            this.fillFormForStorage((ReservoirElement)object);
            return;
        }
        if (this._overridesType == 4) {
            Class<AdjustableFlow> clazz = AdjustableFlow.class;
            Object object3 = Spillway.class;
            Object object4 = ((Element)object).getElementsByClass(clazz, null);
            object4 = ((Element)object).getElementsByClass((Class)object3, (Vector)object4);
            int n = ((Vector)object4).size();
            Vector<String> vector = new Vector<String>();
            for (int i = 0; i < n; ++i) {
                Element element = (Element)((Vector)object4).elementAt(i);
                object3 = element.getFunction();
                vector.add(((Function)object3).getDisplayName());
            }
            this._outletCombo.removeItemListener((ItemListener)this);
            this._outletCombo.removeAllItems();
            RssSystem rssSystem = ((Element)object).getSystem();
            int n4 = vector.size();
            for (int i = 0; i < n4; ++i) {
                object4 = rssSystem.getNameForKeyString((String)vector.elementAt(i));
                this._outletCombo.addItem(object4);
            }
            if (this._outletCombo.getItemCount() <= 0) {
                return;
            }
            this._outletCombo.setSelectedIndex(0);
            String string = (String)this._outletCombo.getItemAt(0);
            this._outletCombo.addItemListener((ItemListener)this);
            this._outletCombo.setVisible(true);
            this._outletLbl.setVisible(true);
            OverridesPanel overridesPanel = this;
            overridesPanel.fillForm(overridesPanel.releaseTable, string);
        }
    }

    protected void fillFormForStorage(ReservoirElement reservoirElement) {
    }

    public void setRun(RssRun rssRun) {
        this._rssRun = rssRun;
        this.setDssManager();
        this._wkspUnitSys = ClientApp.Workspace().getUnitSystem();
    }

    public void setReleaseOverrides(ReleaseOverrides releaseOverrides) {
        this._releaseOverrides = releaseOverrides;
        this._overridesType = releaseOverrides.getOverridesType();
    }

    protected void fillForm(RmaJTable rmaJTable, String string) {
        if (this._rssRun == null) {
            System.out.println("OverridesPanel.fillForm: no Run!");
            return;
        }
        if (this._releaseOverrides == null || this._releaseOverrides.getOverridesType() == 0) {
            System.out.println("OverridesPanel.fillForm:no releaseOverrides Object or undefined!");
            return;
        }
        if ((this._useAltResultsCheckbox.isSelected() || this._releaseOverrides.useOtherAltResults(this.getKeyStringForName(string))) && this._releaseOverrides.getOverridesType() == 1) {
            this._useAltResultsCheckbox.setSelected(true);
            this.releaseTable.setColumnEnabled(false, 2);
            this.unspecifyAllButton.setEnabled(false);
            this.unspecifyButton.setEnabled(false);
            this.importButton.setEnabled(false);
        } else {
            this._useAltResultsCheckbox.setSelected(false);
            this.releaseTable.setColumnEnabled(true, 2);
            this.unspecifyAllButton.setEnabled(true);
            this.unspecifyButton.setEnabled(true);
            this.importButton.setEnabled(true);
        }
        this._releaseNames = null;
        this._currentName = string;
        this._rssRun.getDSSOutputFile();
        this._dssTsDataTable = new Hashtable();
        boolean bl = this.isModified();
        RunTimeWindow runTimeWindow = this._rssRun.getRunTimeWindow();
        if (runTimeWindow.getStartTime() == null || runTimeWindow.getEndTime() == null || runTimeWindow.getTimeStepMinutes() <= 0) {
            return;
        }
        HecTime hecTime = new HecTime(runTimeWindow.getStartTime());
        HecTime hecTime2 = new HecTime(runTimeWindow.getEndTime());
        int n = runTimeWindow.getTimeStepMinutes();
        hecTime.add(n);
        if (!this._tableInitialized) {
            this.initializeTable(rmaJTable, hecTime, hecTime2, n);
            this._tableInitialized = true;
        }
        this.fillTable(rmaJTable, string, hecTime, hecTime2, n);
        this.setModified(bl);
    }

    protected void initializeTable(RmaJTable rmaJTable, HecTime hecTime, HecTime hecTime2, int n) {
        rmaJTable.clearCells();
        rmaJTable.deleteCells();
        this.fillTimeColumns(rmaJTable, hecTime, hecTime2, n);
    }

    protected void fillTimeColumns(RmaJTable rmaJTable, HecTime hecTime, HecTime hecTime2, int n) {
        new HecTime();
        int n2 = hecTime.value();
        int n3 = hecTime2.value();
        n3 = (n3 - n2) / n + 1;
        int n4 = n2;
        TimeZone timeZone = ClientApp.Workspace().getTimeZone();
        this._hecMinutes = new Integer[n3];
        for (int i = 0; i < n3; ++i) {
            HecTime hecTime3 = new HecTime(1);
            hecTime3.set(n4);
            this._hecMinutes[i] = new Integer(hecTime3.value());
            HecTimeArray hecTimeArray = new HecTimeArray(1);
            hecTimeArray.setElementAt(hecTime3, 0);
            hecTimeArray.setTimeZone(timeZone);
            rmaJTable.setCell((Object)hecTimeArray, i, 0);
            rmaJTable.setCell((Object)hecTimeArray, i, 1);
            n4 += n;
        }
    }

    protected void fillTable(RmaJTable rmaJTable, String object, HecTime object2, HecTime object3, int n) {
        Object object4;
        String string = this._rssRun.getDSSOutputFile();
        ReleaseOverrides releaseOverrides = this._releaseOverrides;
        String string2 = this.getKeyStringForName((String)object);
        if ((object = releaseOverrides.getReleaseDssPath(string2)) == null) {
            this.setColumnHeader(rmaJTable, -1, this._overridesType);
            return;
        }
        if (this._ensemblePrefix != null) {
            object = new DSSPathname((String)object);
            object4 = object.getFPart();
            object4 = this._ensemblePrefix.concat((String)object4);
            object.setFPart((String)object4);
            object = object.getPathname();
        }
        object = new DSSIdentifier(string, (String)object);
        object.setTimeWindow(object2, (HecTime)object3);
        this.fillDssData(rmaJTable, (DSSIdentifier)object, releaseOverrides, string2, 0, (HecTime)object2, (HecTime)object3, n);
        releaseOverrides.setRun(this._rssRun);
        ((FluentLogger.Api)c.atInfo()).log("overrides for key : %s", (Object)string2);
        if (this._ensemblePrefix == null || (object = this._overridesMap.get(string2)) == null) {
            object = releaseOverrides.getReleaseValues(string2);
        }
        if (object != null && ((Hashtable)object).size() > 0) {
            object3 = ((Hashtable)object).keys();
            while (object3.hasMoreElements()) {
                object4 = (Integer)object3.nextElement();
                object2 = (Double)((Hashtable)object).get(object4);
                this.setCell(rmaJTable, 2, (Integer)object4, (Double)object2, PREV_EDIT_COLOR);
            }
        } else {
            this.unspecifyAll_Action();
        }
        OverridesPanel overridesPanel = this;
        overridesPanel.plot(overridesPanel.releaseTable);
    }

    void fillDssData(RmaJTable rmaJTable, DSSIdentifier dSSIdentifier, ReleaseOverrides object, String string, int n, HecTime hecTime, HecTime hecTime2, int n2) {
        int n3 = hecTime.value();
        hecTime2.value();
        object = ((ReleaseOverrides)object).getReleaseDssPath(string);
        if (object == null) {
            this.setColumnHeader(rmaJTable, -1, this._overridesType);
            return;
        }
        ((FluentLogger.Api)c.atInfo()).log("Reading DSS %s", (Object)dSSIdentifier);
        dSSIdentifier = new SimpleDSSTimeSeries((BaseDSSManager)this._dssManager, dSSIdentifier);
        this.setCurrentTSData((SimpleDSSTimeSeries)dSSIdentifier);
        dSSIdentifier.name = string + " Computed";
        dSSIdentifier.load();
        if (this._dssTsDataTable.get(string) == null) {
            this._dssTsDataTable.put(string, dSSIdentifier);
        }
        object = this._rssRun.getAlternative().getSystem().getNameForKeyString(string);
        dSSIdentifier.name = (String)object + " Computed";
        int n4 = dSSIdentifier.getYParameterId();
        if (this._wkspUnitSys == 1 && n4 == Parameter.PARAMID_FLOW) {
            rmaJTable.setPrecision(1);
        }
        OverridesPanel overridesPanel = this;
        overridesPanel.configurePlotPanel(overridesPanel.outputPlot);
        this.setColumnHeader(rmaJTable, n4, this._overridesType);
        if (dSSIdentifier.tdata != null) {
            for (int i = 0; i < dSSIdentifier.tdata.length; ++i) {
                int n5 = (dSSIdentifier.tdata[i] - n3) / n2;
                if (n5 < 0) continue;
                try {
                    string = new ParamDouble(dSSIdentifier.ydata[i], n4, this._wkspUnitSys);
                    rmaJTable.setCell((Object)string, n5, n + 2);
                }
                catch (NumberFormatException numberFormatException) {
                    rmaJTable.setCell((Object)"", n5, n + 2);
                }
                rmaJTable.setCellForeground(n5, n + 2, MODEL_COLOR);
            }
        }
    }

    protected void setCurrentTSData(SimpleDSSTimeSeries simpleDSSTimeSeries) {
        this._currentTSData = simpleDSSTimeSeries;
    }

    protected SimpleDSSTimeSeries getCurrentTSData() {
        return this._currentTSData;
    }

    private void setCell(RmaJTable rmaJTable, int n, Integer object, Double d, Color color) {
        int n2 = ((RmaTableModel)rmaJTable.getModel()).getColumnParameter(n);
        int n3 = 2;
        if (this._wkspUnitSys == 1 && n2 == Parameter.PARAMID_FLOW) {
            n3 = 1;
        }
        for (int i = 0; i < rmaJTable.getNumRows(); ++i) {
            if (!this._hecMinutes[i].equals(object)) continue;
            object = rmaJTable.getValueAt(i, n);
            if (object instanceof ParamDouble) {
                n2 = ((ParamDouble)object).getParameterId();
            }
            object = new ParamDouble(d.doubleValue(), n2, this._wkspUnitSys, n3);
            rmaJTable.setCell(object, i, n);
            rmaJTable.setCellForeground(i, n, color);
            return;
        }
        System.out.println("No match for col " + n + " key " + (Integer)object + " value " + d);
    }

    public boolean savePanel() {
        this.releaseTable.commitEdit(true);
        if (!this.isModified()) {
            return true;
        }
        ((FluentLogger.Api)c.atInfo()).log(" Table saving ");
        OverridesPanel overridesPanel = this;
        overridesPanel.saveTable(overridesPanel._currentName);
        this.setModified(false);
        return true;
    }

    protected void saveTable(String string) {
        if (string == null || string.length() <= 0) {
            return;
        }
        ReleaseOverrides releaseOverrides = this._releaseOverrides;
        TableColumn tableColumn = this.releaseTable.getColumnModel().getColumn(2);
        if (tableColumn == null) {
            this._rssRun.setModified(true);
            return;
        }
        this.saveTable(releaseOverrides, string, this.releaseTable);
        this._rssRun.setModified(true);
    }

    protected void saveTable(ReleaseOverrides releaseOverrides, String string, RmaJTable rmaJTable) {
        string = this.getKeyStringForName(string);
        Object object = rmaJTable.getColumnModel().getColumn(2);
        object = ((TableColumn)object).getCellRenderer();
        Hashtable<Integer, Double> hashtable = new Hashtable<Integer, Double>();
        for (int i = 0; i < rmaJTable.getRowCount(); ++i) {
            RmaJTable rmaJTable2 = rmaJTable;
            Object object2 = object.getTableCellRendererComponent((JTable)rmaJTable2, rmaJTable2.getValueAt(i, 2), false, false, i, 2);
            if (object2 == null || !((Component)object2).getForeground().equals(NEW_EDIT_COLOR) && !((Component)object2).getForeground().equals(PREV_EDIT_COLOR)) continue;
            object2 = rmaJTable.getValueAt(i, 2).toString();
            rmaJTable.setCellForeground(i, 2, PREV_EDIT_COLOR);
            if ("".equals(object2) || i >= this._hecMinutes.length) continue;
            hashtable.put(new Integer(this._hecMinutes[i].toString()), new Double((String)object2));
        }
        if (this._ensemblePrefix != null) {
            this._overridesMap.put(string, hashtable);
        }
        if (this._useAltResultsEditor == null || this._useAltResultsEditor.getSelectedAlt() == null) {
            ((FluentLogger.Api)c.atInfo()).log("Saving release overrides to %s", (Object)string);
            releaseOverrides.setReleaseValues(string, hashtable, false, null, null);
        } else {
            String string2 = ((RssRun)this._useAltResultsEditor.getSelectedAlt()).getName();
            ((FluentLogger.Api)c.atInfo()).log("Saving release overrides for %s to %s", (Object)string2, (Object)string);
            releaseOverrides.setReleaseValues(string, hashtable, this._useAltResultsCheckbox.isSelected(), string2, this._useAltResultsEditor.getCollectionSelected());
        }
        rmaJTable.repaint();
    }

    protected void unspecify_Action() {
        OverridesPanel overridesPanel = this;
        overridesPanel.unspecifyAction(overridesPanel.releaseTable);
    }

    protected void unspecifyAction(RmaJTable rmaJTable) {
        rmaJTable.commitEdit(true);
        Vector vector = rmaJTable.getSelectedCellRange();
        if (vector.size() <= 0) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            CellLocation cellLocation = (CellLocation)vector.elementAt(i);
            if (cellLocation == null) continue;
            int n = cellLocation.getRow();
            int n2 = cellLocation.getCol();
            if (n2 != 2) continue;
            this.resetCellColor(rmaJTable, n, n2);
        }
        rmaJTable.repaint();
        this.plot(rmaJTable);
        rmaJTable.setModified(true);
        this.setModified(true);
    }

    protected void unspecifyAll_Action() {
        OverridesPanel overridesPanel = this;
        overridesPanel.unspecifyAllAction(overridesPanel.releaseTable);
    }

    protected void unspecifyAllAction(RmaJTable rmaJTable) {
        rmaJTable.commitEdit(true);
        for (int i = 2; i < rmaJTable.getColumnCount(); ++i) {
            for (int j = 0; j < rmaJTable.getRowCount(); ++j) {
                this.resetCellColor(rmaJTable, j, i);
            }
        }
        rmaJTable.repaint();
        this.plot(rmaJTable);
        rmaJTable.setModified(true);
        this.setModified(true);
    }

    private void resetCellColor(RmaJTable rmaJTable, int n, int n2) {
        Constable constable;
        if (n2 != 2) {
            return;
        }
        int n3 = ((RmaTableModel)rmaJTable.getModel()).getColumnParameter(n2);
        int n4 = 2;
        if (this._wkspUnitSys == 1 && n3 == Parameter.PARAMID_FLOW) {
            n4 = 1;
        }
        Object object = rmaJTable.getColumnModel().getColumn(n2);
        this._rssRun.getReleaseOverrides();
        if (object == null) {
            return;
        }
        String cfr_ignored_0 = (String)((TableColumn)object).getHeaderValue();
        object = ((TableColumn)object).getCellRenderer();
        if (object == null) {
            constable = rmaJTable.getColumnClass(n2);
            object = rmaJTable.getDefaultRenderer(constable);
        }
        RmaJTable rmaJTable2 = rmaJTable;
        if ((object = object.getTableCellRendererComponent((JTable)rmaJTable2, rmaJTable2.getCell(n, n2), false, false, n, n2)) != null) {
            object = ((Component)object).getForeground();
            constable = this._overridesType == 4 ? Double.valueOf(1.0) : Double.valueOf(0.0);
            if (((Color)object).equals(NEW_EDIT_COLOR) || ((Color)object).equals(PREV_EDIT_COLOR)) {
                int n5;
                rmaJTable.setCellForeground(n, n2, MODEL_COLOR);
                object = this.getCurrentTSData();
                if (object == null || ((SimpleDSSTimeSeries)object).tdata == null) {
                    rmaJTable.setValueAt((Object)constable, n, n2);
                    return;
                }
                try {
                    n5 = this._hecMinutes[n];
                }
                catch (Exception exception) {
                    return;
                }
                if (((SimpleDSSTimeSeries)object).tdata[n] == n5) {
                    OverridesPanel.a(rmaJTable, ((SimpleDSSTimeSeries)object).ydata[n], n, n2, n4);
                    return;
                }
                if (((SimpleDSSTimeSeries)object).tdata[n] < n5) {
                    for (int i = n; i < ((SimpleDSSTimeSeries)object).tdata.length; ++i) {
                        if (((SimpleDSSTimeSeries)object).tdata[i] != n5) continue;
                        OverridesPanel.a(rmaJTable, ((SimpleDSSTimeSeries)object).ydata[i], n, n2, n4);
                        return;
                    }
                } else {
                    int cfr_ignored_1 = ((SimpleDSSTimeSeries)object).tdata[n];
                }
                rmaJTable.setValueAt((Object)constable, n, n2);
            }
        }
    }

    private static void a(RmaJTable rmaJTable, double d, int n, int n2, int n3) {
        Object object = rmaJTable.getValueAt(n, n2);
        if (object instanceof ParamDouble) {
            rmaJTable = (ParamDouble)object;
            n3 = rmaJTable.getPrecision();
            rmaJTable.setValue(d);
            rmaJTable.setPrecision(n3);
            return;
        }
        new ParamDouble();
        rmaJTable.setValueAt((Object)new Double(RMAIO.setPrecision2((double)d, (int)n3)), n, n2);
    }

    public void tableDataChanged(TableUpdateEvent tableUpdateEvent) {
        OverridesPanel overridesPanel = this;
        overridesPanel.plot(overridesPanel.releaseTable);
    }

    private void import_Action() {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            boolean cfr_ignored_0 = ClientApp.app().networked;
            Object object = SwingUtilities.windowForComponent((Component)((Object)this));
            if (object instanceof RssSpecifyOverridesDialog) {
                object = (RssSpecifyOverridesDialog)((Object)object);
                ((RssSpecifyOverridesDialog)((Object)object)).importOverridesAction();
            }
            return;
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public void setDSSPathname(Vector<DataReference> object) {
        if (((Vector)object).size() == 0) {
            return;
        }
        String string = ((Vector)object).elementAt(0).pathname();
        object = ((Vector)object).elementAt(0).getFilename();
        object = new DSSIdentifier((String)object, string);
        string = this._rssRun.getRunTimeWindow();
        object.setTimeWindow(string.getStartTime(), string.getEndTime());
        object = new SimpleDSSTimeSeries((BaseDSSManager)this._dssManager, (DSSIdentifier)object);
        object.load();
        string = object.getTimeSeriesContainer();
        OverridesPanel overridesPanel = this;
        DSSListSelector dSSListSelector = this._parentPanel.getDssListSelector();
        if (dSSListSelector != null) {
            overridesPanel = dSSListSelector;
        }
        if (string == null || ((TimeSeriesContainer)string).times.length <= 0) {
            JOptionPane.showMessageDialog((Component)((Object)overridesPanel), "Import of Overrides unsuccessful.  Check times on imported record.", "Import Release Overrides", 2);
            return;
        }
        this.setDSSPathname((SimpleDSSTimeSeries)object, this.releaseTable, (Component)((Object)overridesPanel));
    }

    protected void setDSSPathname(SimpleDSSTimeSeries object, RmaJTable rmaJTable, Component object2) {
        int n;
        int n2 = object.getYParameterId();
        int n3 = object.getUnitSystem();
        int n4 = ((RmaTableModel)rmaJTable.getModel()).getColumnParameter(2);
        if (n2 != n4 && (n = RMAIO.postYesNoWarning((Component)object2, (String)"Parameter type of Imported Data may be incorrect for Overrides!\nContinue with import?")) == 1) {
            return;
        }
        object2 = object.tdata;
        object = object.ydata;
        n2 = ((Object)object2).length;
        for (int i = 0; i < rmaJTable.getRowCount(); ++i) {
            n4 = this._hecMinutes[i];
            if (n4 < object2[0] || n4 > object2[n2 - 1]) continue;
            double d = Interpolate.linearInterpolate((int[])object2, (double[])object, (int)n4, (int)n2);
            Object object3 = rmaJTable.getValueAt(i, 2);
            if (!(object3 instanceof ParamDouble)) continue;
            object3 = (ParamDouble)object3;
            object3.setUnitSystem(n3);
            object3.setValue(d);
            rmaJTable.setCell(object3, i, 2);
            rmaJTable.setCellForeground(i, 2, NEW_EDIT_COLOR);
        }
        rmaJTable.commitEdit(true);
        rmaJTable.setModified(true);
        this.plot(rmaJTable);
    }

    private void plot_Action() {
        OverridesPanel overridesPanel = this;
        G2dDialog g2dDialog = overridesPanel.plot(overridesPanel.releaseTable);
        g2dDialog = new G2dDialog(this._parent, "Specified Releases", false, g2dDialog[0], g2dDialog[1]);
        g2dDialog.setTabulate(false);
        g2dDialog.setVisible(true);
    }

    public static void a(String[] object) {
        object = new JFrame();
        ((JFrame)object).getContentPane().setLayout(new GridBagLayout());
        ((JFrame)object).getContentPane().add((Component)((Object)new OverridesPanel()), new RmaGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
        ((Window)object).setVisible(true);
    }

    String getKeyStringForName(String string) {
        if (this._rssRun == null || this._rssRun.getAlternative().getSystem() == null) {
            return string;
        }
        RssSystem rssSystem = this._rssRun.getAlternative().getSystem();
        String[] stringArray = this._releaseOverrides;
        stringArray = this._releaseOverrides.getReleaseNames();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(rssSystem.getNameForKeyString(stringArray[i]))) continue;
            return stringArray[i];
        }
        return string;
    }

    @Override
    public void editingCanceled(ChangeEvent changeEvent) {
    }

    @Override
    public void editingStopped(ChangeEvent changeEvent) {
        this.updateTableCellColor(changeEvent, this.releaseTable);
    }

    protected void updateTableCellColor(ChangeEvent object, RmaJTable rmaJTable) {
        int n = -1;
        int n2 = 0;
        if ((object = ((EventObject)object).getSource()) instanceof RmaCellEditor) {
            object = (RmaCellEditor)object;
            object = object.getComponent();
            object = ((Component)object).getLocation();
            n = rmaJTable.rowAtPoint((Point)object);
            n2 = rmaJTable.columnAtPoint((Point)object);
        }
        if (n >= 0 && n2 >= 0 && !rmaJTable.getCell(n, n2).toString().equals("")) {
            rmaJTable.setCellForeground(n, n2, NEW_EDIT_COLOR);
        }
        this.plot(rmaJTable);
    }

    protected Vector[] plot(RmaJTable rmaJTable) {
        Vector<SimpleJTableData> vector = new Vector<SimpleJTableData>();
        Vector[] vectorArray = new Vector[2];
        if (this._currentName.length() <= 0) {
            System.out.println("no reservoir selected");
            return vectorArray;
        }
        Vector<Color> vector2 = new Vector<Color>();
        Color color = MODEL_COLOR;
        Color color2 = NEW_EDIT_COLOR;
        SimpleJTableData simpleJTableData = this.getPlotArray();
        simpleJTableData.setData(rmaJTable, 0, 2);
        simpleJTableData.setGmtOffset(ClientApp.Workspace().getGmtOffset());
        rmaJTable = this.getCurrentTSData();
        if (rmaJTable != null) {
            simpleJTableData.setYParameterId(rmaJTable.getYParameterId());
            simpleJTableData.yunits = rmaJTable.getYAxisName();
            simpleJTableData.xunits = rmaJTable.getXAxisName();
            if (this._overridesType == 2) {
                simpleJTableData.setCurveNames(new String[]{"Specified Target Elevation"});
            } else if (this._overridesType == 1) {
                simpleJTableData.setCurveNames(new String[]{"Specified Target Release"});
            } else if (this._overridesType == 3) {
                simpleJTableData.setCurveNames(new String[]{"Specified Target Gate Opening"});
            } else if (this._overridesType == 4) {
                simpleJTableData.setCurveNames(new String[]{"Specified Target Factor"});
            } else if (this._overridesType == 6) {
                simpleJTableData.setCurveNames(new String[]{"Specified Target Storage Elevation"});
            } else if (this._overridesType == 5) {
                simpleJTableData.setCurveNames(new String[]{"Specified Target Storage"});
            }
        }
        vector.addElement(simpleJTableData);
        vector2.addElement(color2);
        if (rmaJTable != null && this._overridesType != 4 && rmaJTable.numberValues > 0) {
            vector.addElement((SimpleJTableData)rmaJTable);
            vector2.addElement(color);
        } else {
            System.out.println("No computed release for " + simpleJTableData.name);
        }
        this.outputPlot.buildComponents(vector, vector2, false, false);
        this.outputPlot.setDisplayUnitsSystem(ClientApp.frame().getDisplayUnitSystem());
        this.outputPlot.paintGfx();
        this.outputPlot.revalidate();
        vectorArray[0] = vector;
        vectorArray[1] = vector2;
        return vectorArray;
    }

    protected void configurePlotPanel(G2dPanel g2dPanel) {
        G2dPanelProp g2dPanelProp = this.getPlotProp();
        g2dPanel.configurePanel(g2dPanelProp);
    }

    private G2dPanelProp getPlotProp() {
        PlotDefaults plotDefaults = PlotDefaultsManager.getDefaults();
        PlotDefaultsManager.setDefaults((PlotDefaults)new HotPlotDefaults());
        G2dPanelProp g2dPanelProp = new G2dPanelProp();
        new G2dPanelProp().hasTitle = false;
        g2dPanelProp.hasToolbar = false;
        g2dPanelProp.hasLegend = false;
        G2dPlotProp g2dPlotProp = new G2dPlotProp();
        new G2dPlotProp().hasXScroll = false;
        g2dPlotProp.hasYScroll = false;
        g2dPlotProp.x1AxisProp.name = "Minutes";
        g2dPlotProp.x1AxisProp.type = 1;
        g2dPlotProp.hasX1Label = false;
        g2dPlotProp.y1AxisProp.name = this._overridesType == 4 ? "Factor" : "CFS";
        g2dPlotProp.y1AxisProp.isReversed = true;
        if (this.getCurrentTSData() != null) {
            g2dPlotProp.y1AxisProp.name = this.getCurrentTSData().getYAxisName();
            g2dPlotProp.x1AxisProp.name = this.getCurrentTSData().getXAxisName();
        }
        g2dPlotProp.x1AxisProp.numTicLabelLayers = 2;
        g2dPanelProp.addPlotProp(g2dPlotProp);
        PlotDefaultsManager.setDefaults((PlotDefaults)plotDefaults);
        return g2dPanelProp;
    }

    private SimpleJTableData getPlotArray() {
        SimpleJTableData simpleJTableData = new SimpleJTableData();
        new SimpleJTableData().xunits = "Minutes";
        simpleJTableData.yunits = this._overridesType == 4 ? "Factor" : "CFS";
        simpleJTableData.setXAxisType(1);
        simpleJTableData.setStartRow(0);
        simpleJTableData.setData(null, -1, -1);
        return simpleJTableData;
    }

    void setDssManager() {
        if (this._dssManager == null) {
            try {
                this._dssManager = (DSSManager)ClientApp.Workspace().getData().getDSSFileManager().getRemote();
                return;
            }
            catch (RemoteException remoteException) {
                System.out.println("setDssManager(): failed to DSSManager from workspace " + String.valueOf(remoteException));
                this._dssManager = null;
            }
        }
    }

    public void setEnsemblePrefix(String string) {
        this._ensemblePrefix = string;
    }
}

