/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.clientapp.client.ClientApp;
import hec.data.Parameter;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.G2dPanelProp;
import hec.gfx2d.G2dPlotProp;
import hec.gfx2d.HotPlotDefaults;
import hec.gfx2d.PlotDefaults;
import hec.gfx2d.PlotDefaultsManager;
import hec.model.PairedValuesExt;
import hec.model.PairedValuesExtTableModel;
import hec.rss.client.PairedValuesExtPanel$1;
import hec.rss.client.PairedValuesExtPanel$MyG2dPanel;
import hec.rss.gfx2d.SimpleJTableData;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.table.TableModel;
import rma.swing.RmaGridBagConstraints;
import rma.swing.RmaJTable;
import rma.swing.print.PageText;
import rma.util.RMAIO;

public class PairedValuesExtPanel
extends JPanel {
    String _xColLabel = "Stage (%S)";
    String _yColLabel = "Discharge (%S)";
    String[] _colLabels = new String[]{this._xColLabel, this._yColLabel};
    String[] _plotLabels = new String[]{this._xColLabel, this._yColLabel};
    String[] _plotLegendNames = null;
    String _plotTitle = "";
    String _lineStyleName = "FLOW-OUT";
    RmaJTable _table = new RmaJTable((Component)this);
    PairedValuesExtPanel$MyG2dPanel _plot = new PairedValuesExtPanel$MyG2dPanel(this);
    boolean _reversePlot = false;
    SimpleJTableData _tableData;
    int[] _paramIDs = new int[]{Parameter.PARAMID_STAGE, Parameter.PARAMID_FLOW};

    public PairedValuesExtPanel() {
        this.createControls();
    }

    public PairedValuesExtPanel(String[] stringArray, int[] nArray) {
        this(stringArray, stringArray, nArray, true);
    }

    public PairedValuesExtPanel(String[] stringArray, int[] nArray, boolean bl) {
        this(stringArray, stringArray, nArray, bl);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this._table.setEnabled(bl);
        this._table.setBackground(bl ? Color.white : UIManager.getColor("TextField.disabledBackground"));
        this._plot.setEnabled(bl);
    }

    public PairedValuesExtPanel(String[] pairedValuesExt, String[] stringArray, int[] nArray, boolean bl) {
        this._colLabels = pairedValuesExt;
        this._plotLabels = stringArray;
        this._paramIDs = nArray;
        this._reversePlot = bl;
        this.createControls();
        pairedValuesExt = new PairedValuesExt();
        pairedValuesExt.setUnitSystem(ClientApp.Workspace().getUnitSystem());
        pairedValuesExt.setParamXId(this._paramIDs[0]);
        pairedValuesExt.setParamYId(this._paramIDs[1]);
        this.fillForm(pairedValuesExt);
    }

    void createControls() {
        this.setLayout(new GridBagLayout());
        this._table.setModel((TableModel)new PairedValuesExtTableModel(this._colLabels, new boolean[]{false, false, false, false}));
        this._table.setDoubleCellEditor(true);
        this._table.setPrecision(2);
        this._table.setUnitsHeaderRenderer();
        PairedValuesExtPanel pairedValuesExtPanel = this;
        pairedValuesExtPanel.add((Component)pairedValuesExtPanel._table.getScrollPane(), new RmaGridBagConstraints(0, 0, 1, 2, 1.0, 1.0, 18, 1, new Insets(5, 5, 5, 0), 0, 0));
        this._table.addCellEditorListener((CellEditorListener)new PairedValuesExtPanel$1(this));
        PairedValuesExtPanel pairedValuesExtPanel2 = this;
        pairedValuesExtPanel2.add((Component)((Object)pairedValuesExtPanel2._plot), new RmaGridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(2, 2, 2, 2), 75, 75));
        PairedValuesExtPanel pairedValuesExtPanel3 = this;
        pairedValuesExtPanel3.configurePlot(pairedValuesExtPanel3._plot);
        Vector<SimpleJTableData> vector = new Vector<SimpleJTableData>();
        this._tableData = this.getTableData(1);
        vector.addElement(this._tableData);
        this._plot.setPlotObjects(vector);
    }

    public void setTablePrintHeaders(String string) {
        string = new PageText(string, 0);
        this._table.setPrintTitle((PageText)string);
    }

    public void fillForm(PairedValuesExt pairedValuesExt) {
        this.clearPanel();
        if (pairedValuesExt == null) {
            return;
        }
        ((PairedValuesExtTableModel)this._table.getModel()).setPairedValues(pairedValuesExt);
        this.pairedValuesReplot();
    }

    public PairedValuesExt storeForm(PairedValuesExt pairedValuesExt) {
        pairedValuesExt = pairedValuesExt.clone();
        pairedValuesExt.clearValues();
        this._table.commitEdit(true);
        Vector vector = this._table.getCells();
        int n = this._table.getColumnCount();
        double[] dArray = new double[n - 1];
        for (int i = 0; i < vector.size(); ++i) {
            if (vector.elementAt(i) == null) continue;
            Vector vector2 = (Vector)vector.elementAt(i);
            double d = RMAIO.parseDouble(vector2 = vector2.elementAt(0));
            if (d == Double.NEGATIVE_INFINITY) continue;
            for (int j = 1; j < n; ++j) {
                Object e = ((Vector)vector.elementAt(i)).elementAt(i);
                dArray[i - 1] = RMAIO.parseDouble(e);
            }
            pairedValuesExt.addPair(d, dArray);
        }
        return pairedValuesExt;
    }

    public RmaJTable getTable() {
        return this._table;
    }

    public void clearPanel() {
        this._table.commitEdit(true);
        this._table.clearCells();
        this.pairedValuesReplot();
    }

    public void setPopupPlotLegendNames(String[] stringArray) {
        this._plotLegendNames = stringArray;
    }

    public void setPopupPlotTitle(String string) {
        this._plotTitle = string;
    }

    public void setLineStyleName(String string) {
        this._lineStyleName = string;
    }

    public void configurePlot(G2dPanel g2dPanel) {
        PlotDefaults plotDefaults = PlotDefaultsManager.getDefaults();
        PlotDefaultsManager.setDefaults((PlotDefaults)new HotPlotDefaults());
        G2dPanelProp g2dPanelProp = new G2dPanelProp();
        new G2dPanelProp().hasTitle = false;
        g2dPanelProp.hasToolbar = false;
        g2dPanelProp.hasLegend = false;
        G2dPlotProp g2dPlotProp = new G2dPlotProp();
        new G2dPlotProp().hasXScroll = false;
        g2dPlotProp.hasYScroll = false;
        if (!this._reversePlot) {
            g2dPlotProp.x1AxisProp.name = this._plotLabels[0];
            g2dPlotProp.y1AxisProp.name = this._plotLabels[1];
        } else {
            g2dPlotProp.x1AxisProp.name = this._plotLabels[1];
            g2dPlotProp.y1AxisProp.name = this._plotLabels[0];
        }
        g2dPlotProp.y1AxisProp.isReversed = true;
        g2dPanelProp.addPlotProp(g2dPlotProp);
        g2dPanel.configurePanel(g2dPanelProp);
        PlotDefaultsManager.setDefaults((PlotDefaults)plotDefaults);
    }

    private void pairedValuesReplot() {
        Vector<SimpleJTableData> vector = new Vector<SimpleJTableData>();
        for (int i = 1; i < this._table.getColumnModel().getColumnCount(); ++i) {
            SimpleJTableData simpleJTableData = this.getTableData(i);
            simpleJTableData.setData(this._table, i, 0);
            if (this._plotLegendNames != null && i - 1 < this._plotLegendNames.length && this._plotLegendNames[i - 1].length() > 0) {
                simpleJTableData.setName(this._plotLegendNames[i - 1]);
            }
            simpleJTableData.lineStyleName = this._lineStyleName;
            vector.addElement(simpleJTableData);
        }
        this._plot.setPlotObjects(vector);
        this._plot.paintGfx();
        this._plot.revalidate();
    }

    void cancel() {
        this._table.removeEditor();
    }

    private SimpleJTableData getTableData(int n) {
        SimpleJTableData simpleJTableData = new SimpleJTableData();
        if (!this._reversePlot) {
            simpleJTableData.xunits = this._plotLabels[0];
            simpleJTableData.yunits = this._plotLabels[n];
        } else {
            simpleJTableData.xunits = this._plotLabels[n];
            simpleJTableData.yunits = this._plotLabels[0];
        }
        simpleJTableData.setData(null, -1, -1);
        return simpleJTableData;
    }
}

