/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.clientapp.client.ClientApp;
import hec.data.Parameter;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.G2dPanelProp;
import hec.gfx2d.G2dPlotProp;
import hec.gfx2d.HotPlotDefaults;
import hec.gfx2d.PlotDefaults;
import hec.gfx2d.PlotDefaultsManager;
import hec.model.PairedValues;
import hec.model.PairedValuesTableModel;
import hec.rss.client.PairedValuesPanel$1;
import hec.rss.client.PairedValuesPanel$MyG2dPanel;
import hec.rss.gfx2d.SimpleJTableData;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.table.TableModel;
import rma.swing.RmaGridBagConstraints;
import rma.swing.RmaJTable;
import rma.swing.print.PageText;
import rma.util.RMAIO;

public class PairedValuesPanel
extends JPanel {
    String _xColLabel = "Stage (%S)";
    String _yColLabel = "Discharge (%S)";
    String[] _colLabels = new String[]{this._xColLabel, this._yColLabel};
    String[] _plotLabels = new String[]{this._xColLabel, this._yColLabel};
    RmaJTable _table = new RmaJTable((Component)this);
    PairedValuesPanel$MyG2dPanel _plot = new PairedValuesPanel$MyG2dPanel(this);
    boolean _reversePlot = false;
    String _plotLegendName = "";
    String _plotTitle = "";
    String _lineStyleName = "";
    SimpleJTableData _tableData;
    int[] _paramIDs = new int[]{Parameter.PARAMID_STAGE, Parameter.PARAMID_FLOW};

    public PairedValuesPanel() {
        this.createControls();
    }

    public PairedValuesPanel(String[] stringArray, int[] nArray) {
        this(stringArray, stringArray, nArray, true);
    }

    public PairedValuesPanel(String[] stringArray, int[] nArray, boolean bl) {
        this(stringArray, stringArray, nArray, bl);
    }

    public PairedValuesPanel(String[] pairedValues, String[] stringArray, int[] nArray, boolean bl) {
        this._colLabels = pairedValues;
        this._plotLabels = stringArray;
        this._paramIDs = nArray;
        this._reversePlot = bl;
        this.createControls();
        pairedValues = new PairedValues();
        pairedValues.setUnitSystem(ClientApp.Workspace().getUnitSystem());
        pairedValues.setParamXId(this._paramIDs[0]);
        pairedValues.setParamYId(this._paramIDs[1]);
        this.fillForm(pairedValues);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this._table.setEnabled(bl);
        this._table.setBackground(bl ? Color.white : (Color)UIManager.get("TextField.disabledBackground"));
        this._plot.setEnabled(bl);
    }

    public void setTablePrintHeaders(String string) {
        string = new PageText(string, 0);
        this._table.setPrintTitle((PageText)string);
    }

    public void fillForm(PairedValues pairedValues) {
        this.clearPanel();
        if (pairedValues == null) {
            return;
        }
        ((PairedValuesTableModel)this._table.getModel()).setPairedValues(pairedValues);
        this.pairedValuesReplot();
    }

    public PairedValues storeForm(PairedValues pairedValues) {
        pairedValues = (PairedValues)pairedValues.clone();
        pairedValues.clearValues();
        this._table.commitEdit(true);
        Vector vector = this._table.getCells();
        for (int i = 0; i < vector.size(); ++i) {
            if (vector.elementAt(i) == null || ((Vector)vector.elementAt(i)).size() < 2) continue;
            Object e = ((Vector)vector.elementAt(i)).elementAt(0);
            Object e2 = ((Vector)vector.elementAt(i)).elementAt(1);
            double d = RMAIO.parseDouble(e);
            double d2 = RMAIO.parseDouble(e2);
            if (d == Double.NEGATIVE_INFINITY && d2 == Double.NEGATIVE_INFINITY) continue;
            pairedValues.addPair(d, d2);
        }
        return pairedValues;
    }

    public void clearPanel() {
        this._table.commitEdit(true);
        this._table.clearCells();
        this.pairedValuesReplot();
    }

    public void configurePlot(G2dPanel g2dPanel) {
        PlotDefaults plotDefaults = PlotDefaultsManager.getDefaults();
        PlotDefaultsManager.setDefaults((PlotDefaults)new HotPlotDefaults());
        G2dPanelProp g2dPanelProp = new G2dPanelProp();
        new G2dPanelProp().hasTitle = false;
        g2dPanelProp.hasToolbar = false;
        g2dPanelProp.hasLegend = false;
        G2dPlotProp g2dPlotProp = new G2dPlotProp();
        new G2dPlotProp().hasXScroll = false;
        g2dPlotProp.hasYScroll = false;
        if (!this._reversePlot) {
            g2dPlotProp.x1AxisProp.name = this._plotLabels[0];
            g2dPlotProp.y1AxisProp.name = this._plotLabels[1];
        } else {
            g2dPlotProp.x1AxisProp.name = this._plotLabels[1];
            g2dPlotProp.y1AxisProp.name = this._plotLabels[0];
        }
        g2dPlotProp.y1AxisProp.isReversed = true;
        g2dPanelProp.addPlotProp(g2dPlotProp);
        g2dPanel.configurePanel(g2dPanelProp);
        PlotDefaultsManager.setDefaults((PlotDefaults)plotDefaults);
    }

    public void pairedValuesReplot() {
        if (!this._reversePlot) {
            this._tableData.setData(this._table, 0, 1);
        } else {
            this._tableData.setData(this._table, 1, 0);
        }
        if (this._plotLegendName != null && this._plotLegendName.length() > 0) {
            this._tableData.name = this._plotLegendName;
        }
        if (this._lineStyleName != null && this._lineStyleName.length() > 0) {
            this._tableData.lineStyleName = this._lineStyleName;
        }
    }

    void createControls() {
        this.setLayout(new GridBagLayout());
        this._table.setModel((TableModel)new PairedValuesTableModel(this._colLabels, new boolean[]{true, true}));
        this._table.setDoubleCellEditor(true);
        this._table.setPrecision(2);
        this._table.setUnitsHeaderRenderer();
        this._table.getScrollPane().setVerticalScrollBarPolicy(22);
        this._table.getScrollPane().setHorizontalScrollBarPolicy(30);
        PairedValuesPanel pairedValuesPanel = this;
        pairedValuesPanel.add((Component)pairedValuesPanel._table.getScrollPane(), new RmaGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 5, 0), 0, 0));
        this._table.addCellEditorListener((CellEditorListener)new PairedValuesPanel$1(this));
        PairedValuesPanel pairedValuesPanel2 = this;
        pairedValuesPanel2.add((Component)((Object)pairedValuesPanel2._plot), new RmaGridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(2, 2, 2, 2), 75, 75));
        PairedValuesPanel pairedValuesPanel3 = this;
        pairedValuesPanel3.configurePlot(pairedValuesPanel3._plot);
        Vector<SimpleJTableData> vector = new Vector<SimpleJTableData>();
        this._tableData = this.getTableData();
        vector.addElement(this._tableData);
        this._plot.setPlotObjects(vector);
    }

    void cancel() {
        this._table.removeEditor();
    }

    private SimpleJTableData getTableData() {
        SimpleJTableData simpleJTableData = new SimpleJTableData();
        if (!this._reversePlot) {
            simpleJTableData.xunits = this._plotLabels[0];
            simpleJTableData.yunits = this._plotLabels[1];
        } else {
            simpleJTableData.xunits = this._plotLabels[1];
            simpleJTableData.yunits = this._plotLabels[0];
        }
        simpleJTableData.setData(null, -1, -1);
        return simpleJTableData;
    }

    public void setPopupPlotLegendName(String string) {
        this._plotLegendName = string;
        this.pairedValuesReplot();
    }

    public void setPopupPlotTitle(String string) {
        this._plotTitle = string;
    }

    public void setLineStyleName(String string) {
        this._lineStyleName = string;
    }
}

