/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.clientapp.client.ClientApp;
import hec.clientapp.client.ClientWorkspace;
import hec.clientapp.rmi.csinterface.RmiApp;
import hec.clientapp.rmi.csinterface.RmiWorkspace;
import hec.gui.WizardPanel;
import hec.io.Identifier;
import hec.lang.UserId;
import hec.model.WatershedLocation;
import hec.watershed.model.Study;
import hec.watershed.model.StudyDataList;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import javax.swing.JLabel;
import mil.army.usace.hec.rmi.client.RmiFileChooserField;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;
import rma.swing.RmaInsets;
import rma.util.RMAFilenameFilter;

public class PickWatershedWizardPanel
extends WizardPanel {
    public static final String PANEL_NAME = "SelectWatershed";
    private RmiFileChooserField _wkspFileFld;
    private RmiApp _appServer;
    private ClientWorkspace _wksp;
    private JLabel _panelTitle;

    public PickWatershedWizardPanel() {
        super((LayoutManager)new GridBagLayout());
        this.buildControls();
        this.addListeners();
    }

    protected void buildControls() {
        this._panelTitle = new JLabel("Select the Watershed");
        Serializable serializable = this._panelTitle.getFont();
        this._panelTitle.setFont(new Font(serializable.getName(), 1, serializable.getSize()));
        new GridBagConstraints();
        serializable = new GridBagConstraints();
        new GridBagConstraints().gridwidth = 0;
        ((GridBagConstraints)serializable).weightx = 1.0;
        ((GridBagConstraints)serializable).anchor = 18;
        ((GridBagConstraints)serializable).fill = 2;
        ((GridBagConstraints)serializable).insets = RmaInsets.insets((int)4, (int)4, (int)4, (int)4);
        PickWatershedWizardPanel pickWatershedWizardPanel = this;
        pickWatershedWizardPanel.add(pickWatershedWizardPanel._panelTitle, serializable);
        JLabel jLabel = new JLabel("Watershed File:");
        ((GridBagConstraints)serializable).gridx = -1;
        ((GridBagConstraints)serializable).gridy = -1;
        ((GridBagConstraints)serializable).gridwidth = 1;
        ((GridBagConstraints)serializable).weightx = 0.0;
        ((GridBagConstraints)serializable).weighty = 0.0;
        ((GridBagConstraints)serializable).anchor = 18;
        ((GridBagConstraints)serializable).fill = 0;
        ((GridBagConstraints)serializable).insets = RmaInsets.INSETS5505;
        this.add(jLabel, serializable);
        this._wkspFileFld = new RmiFileChooserField();
        ArrayList<RMAFilenameFilter> arrayList = new ArrayList<RMAFilenameFilter>();
        arrayList.add(new RMAFilenameFilter("*.wksp", "Watershed Files"));
        this._wkspFileFld.setFilters(arrayList);
        jLabel.setLabelFor((Component)this._wkspFileFld);
        ((GridBagConstraints)serializable).gridx = -1;
        ((GridBagConstraints)serializable).gridy = -1;
        ((GridBagConstraints)serializable).gridwidth = 0;
        ((GridBagConstraints)serializable).weightx = 1.0;
        ((GridBagConstraints)serializable).weighty = 0.01;
        ((GridBagConstraints)serializable).anchor = 18;
        ((GridBagConstraints)serializable).fill = 2;
        ((GridBagConstraints)serializable).insets = RmaInsets.INSETS5505;
        PickWatershedWizardPanel pickWatershedWizardPanel2 = this;
        pickWatershedWizardPanel2.add((Component)pickWatershedWizardPanel2._wkspFileFld, serializable);
    }

    protected void addListeners() {
    }

    public boolean isValidPanel() {
        String string = this._wkspFileFld.getPath();
        if (string.isEmpty()) {
            return false;
        }
        try {
            if (!((RmiFileManager)ClientApp.app().getFileManager().getRemote()).fileExists(string)) {
                return false;
            }
        }
        catch (RemoteException remoteException) {}
        return true;
    }

    public String getPanelName() {
        return PANEL_NAME;
    }

    public void setAppServer(RmiApp rmiApp) {
        this._appServer = rmiApp;
    }

    public ClientWorkspace openSelectedWorkspace() {
        Identifier identifier = this.getSelectedWatershedIdentifier();
        if (identifier == null) {
            return this._wksp;
        }
        if (identifier.getPath().equals(ClientApp.Workspace().getWorkspaceConfigFile("main"))) {
            this._wksp = ClientApp.Workspace();
        } else if (this._wksp == null || !identifier.getPath().equals(this._wksp.getWorkspacePath())) {
            this.closeSelectedWorkspace();
            try {
                String[] stringArray = ClientApp.app().getAppServer().getBindingSites();
                String string = null;
                if (ClientApp.app().isNetworked() && stringArray != null && stringArray.length > 0) {
                    string = stringArray[0];
                }
                identifier = ClientApp.Workspace().getData().openWorkspace(identifier, string);
                this._wksp = new ClientWorkspace(ClientApp.app(), (RmiWorkspace)identifier);
                identifier = this._wksp.getDataListContainer();
                if (identifier != null && (identifier = (StudyDataList)identifier.getDataList(Study.class.getName())) != null) {
                    identifier.getOpenStudy();
                }
            }
            catch (RemoteException remoteException) {
                System.out.println("openWorkspace: RMI Error opening workspace " + String.valueOf(remoteException));
            }
        }
        return this._wksp;
    }

    public void closeSelectedWorkspace() {
        if (this._wksp != null && ClientApp.Workspace() != this._wksp) {
            this._wksp.close();
            this._wksp = null;
        }
    }

    private Identifier getSelectedWatershedIdentifier() {
        Identifier identifier = new Identifier(this._wkspFileFld.getPath());
        try {
            identifier = ((RmiFileManager)ClientApp.app().getFileManager().getRemote()).openFile(UserId.getUserId(), identifier);
            return identifier;
        }
        catch (RemoteException remoteException) {
            System.out.println("getSelectedWatershedIdentifier:error getting wksp file " + String.valueOf(remoteException));
            return null;
        }
    }

    public void setSelectedWatershedLocation(WatershedLocation watershedLocation) {
    }

    public void setSelectedWorkspace(Identifier identifier) {
        this._wkspFileFld.clearPerformed();
        if (identifier == null) {
            return;
        }
        this._wkspFileFld.setText(identifier.getPath());
    }
}

