/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.data.Parameter;
import hec.gui.PanelSelectorCard;
import hec.model.PairedValues;
import hec.rss.client.PairedValuesPanel;
import hec.rss.model.PowerPlant;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import rma.swing.DefaultJPanel;
import rma.swing.RmaGridBagConstraints;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJLabel;

public class PlantCapacityPanel
extends DefaultJPanel
implements PanelSelectorCard {
    PowerPlant _powerPlant;
    RmaJLabel _methodLabel = new RmaJLabel("Variable Capacity:");
    RmaJComboBox _methodSelector = new RmaJComboBox();
    RmaJLabel _constLabel = new RmaJLabel("Installed Capacity (MW)");
    RmaJDecimalField _constTxt = new RmaJDecimalField();
    JPanel _cardPanel = new JPanel();
    JPanel _constPanel = new JPanel();
    PairedValuesPanel _byElevPanel = new PairedValuesPanel(new String[]{"Elevation (%S)", "Capacity (%S)"}, new int[]{Parameter.PARAMID_ELEV, Parameter.PARAMID_POWER});
    PairedValuesPanel _byStoragePanel = new PairedValuesPanel(new String[]{"Storage (%S)", "Capacity (%S)"}, new int[]{Parameter.PARAMID_STOR, Parameter.PARAMID_POWER});
    PairedValuesPanel _byReleasePanel = new PairedValuesPanel(new String[]{"Release (%S)", "Capacity (%S)"}, new int[]{Parameter.PARAMID_FLOW, Parameter.PARAMID_POWER}, false);
    PairedValuesPanel _byOpHeadPanel = new PairedValuesPanel(new String[]{"Head (%S)", "Capacity (%S)"}, new int[]{Parameter.PARAMID_STAGE, Parameter.PARAMID_POWER});
    RmaJLabel _capacityLabel = new RmaJLabel("Installed Capacity (MW)");
    RmaJDecimalField _capacityTxt = new RmaJDecimalField();
    RmaJLabel _overloadLabel = new RmaJLabel("Overload Factor");
    RmaJDecimalField _overloadTxt = new RmaJDecimalField();

    public PlantCapacityPanel() {
        this.setLayout(new GridBagLayout());
        this._methodSelector.addItem((Object)"Installed Capacity with Overload Factor");
        this._methodSelector.addItem((Object)"Function of Reservoir Elevation");
        this._methodSelector.addItem((Object)"Function of Reservoir Storage");
        this._methodSelector.addItem((Object)"Function of Release");
        this._methodSelector.addItem((Object)"Function of Operating Head");
        this._cardPanel.setBorder(BorderFactory.createEtchedBorder());
        this._cardPanel.setLayout(new CardLayout());
        this._constPanel.setLayout(new GridBagLayout());
        this._constPanel.add((Component)this._overloadLabel, new RmaGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, INSETS5550, 0, 0));
        this._constPanel.add((Component)this._overloadTxt, new RmaGridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 18, 2, INSETS5555, 0, 0));
        this._cardPanel.add("Installed Capacity with Overload Factor", this._constPanel);
        this._cardPanel.add("Function of Reservoir Elevation", this._byElevPanel);
        this._cardPanel.add("Function of Reservoir Storage", this._byStoragePanel);
        this._cardPanel.add("Function of Release", this._byReleasePanel);
        this._cardPanel.add("Function of Operating Head", this._byOpHeadPanel);
        PlantCapacityPanel plantCapacityPanel = this;
        plantCapacityPanel.add((Component)plantCapacityPanel._constLabel, new RmaGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 15, 5), 0, 0));
        PlantCapacityPanel plantCapacityPanel2 = this;
        plantCapacityPanel2.add((Component)plantCapacityPanel2._constTxt, new RmaGridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, INSETS5555, 0, 0));
        PlantCapacityPanel plantCapacityPanel3 = this;
        plantCapacityPanel3.add((Component)plantCapacityPanel3._methodLabel, new RmaGridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, INSETS5550, 0, 0));
        PlantCapacityPanel plantCapacityPanel4 = this;
        plantCapacityPanel4.add((Component)plantCapacityPanel4._methodSelector, new RmaGridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 2, INSETS5555, 0, 0));
        PlantCapacityPanel plantCapacityPanel5 = this;
        plantCapacityPanel5.add(plantCapacityPanel5._cardPanel, new RmaGridBagConstraints(0, 3, 2, 1, 1.0, 1.0, 18, 1, INSETS0000, 0, 0));
        this._constLabel.setLabelFor((Component)this._constTxt);
        this._methodSelector.addItemListener((ItemListener)((Object)this));
    }

    public String getTabname() {
        return "Capacity";
    }

    public boolean savePanel() {
        if (this._powerPlant == null) {
            return false;
        }
        this._powerPlant.setConstCapacity(this._constTxt.getValue());
        this._powerPlant.setOverload(this._overloadTxt.getValue());
        PairedValues pairedValues = this._byElevPanel.storeForm(this._powerPlant.getCapacityByElev());
        this._powerPlant.setCapacityByElev(pairedValues);
        pairedValues = this._byStoragePanel.storeForm(this._powerPlant.getCapacityByStorage());
        this._powerPlant.setCapacityByStorage(pairedValues);
        pairedValues = this._byReleasePanel.storeForm(this._powerPlant.getCapacityByRelease());
        this._powerPlant.setCapacityByRelease(pairedValues);
        pairedValues = this._byOpHeadPanel.storeForm(this._powerPlant.getCapacityByOpHead());
        this._powerPlant.setCapacityByOpHead(pairedValues);
        this._powerPlant.setCapacityMethod(this._methodSelector.getSelectedIndex());
        return true;
    }

    public void fillPanel(PowerPlant object) {
        this._powerPlant = object;
        if (this._powerPlant == null) {
            return;
        }
        object = "temp name";
        this._constTxt.setValue(this._powerPlant.getConstCapacity());
        this._byElevPanel.fillForm(this._powerPlant.getCapacityByElev());
        this._byStoragePanel.fillForm(this._powerPlant.getCapacityByStorage());
        this._byReleasePanel.fillForm(this._powerPlant.getCapacityByRelease());
        this._byOpHeadPanel.fillForm(this._powerPlant.getCapacityByOpHead());
        this._byElevPanel.setLineStyleName("Capacity");
        this._byReleasePanel.setLineStyleName("Capacity");
        this._byStoragePanel.setLineStyleName("Capacity");
        this._byOpHeadPanel.setLineStyleName("Capacity");
        this._byElevPanel.setPopupPlotLegendName("Capacity");
        this._byReleasePanel.setPopupPlotLegendName("Capacity");
        this._byOpHeadPanel.setPopupPlotLegendName("Capacity");
        this._byElevPanel.setPopupPlotTitle("Power Plant Capacity: " + (String)object);
        this._byStoragePanel.setPopupPlotTitle("Power Plant Capacity: " + (String)object);
        this._byReleasePanel.setPopupPlotTitle("Power Plant Capacity: " + (String)object);
        this._byOpHeadPanel.setPopupPlotTitle("Power Plant Capacity: " + (String)object);
        this._methodSelector.setSelectedIndex(this._powerPlant.getCapacityMethod());
        this._capacityTxt.setValue(this._powerPlant.getCapacity());
        this._overloadTxt.setValue(this._powerPlant.getOverload());
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 2) {
            return;
        }
        if (itemEvent.getSource() == this._methodSelector) {
            ((CardLayout)this._cardPanel.getLayout()).show(this._cardPanel, (String)this._methodSelector.getSelectedItem());
        }
    }
}

