/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.data.Parameter;
import hec.gui.PanelSelectorCard;
import hec.model.PairedValues;
import hec.rss.client.EfficiencyHillCurvePanel;
import hec.rss.client.PairedValuesPanel;
import hec.rss.model.PowerPlant;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import rma.swing.DefaultJPanel;
import rma.swing.RmaGridBagConstraints;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJLabel;

public class PlantEfficiencyPanel
extends DefaultJPanel
implements PanelSelectorCard {
    PowerPlant _powerPlant;
    RmaJLabel _methodLabel = new RmaJLabel("Efficiency Method");
    RmaJComboBox _methodSelector = new RmaJComboBox();
    RmaJLabel _constLabel = new RmaJLabel("Constant Efficiency (%)");
    RmaJDecimalField _constTxt = new RmaJDecimalField();
    JPanel _cardPanel = new JPanel();
    JPanel _constPanel = new JPanel();
    PairedValuesPanel _byElevPanel = new PairedValuesPanel(new String[]{"Elevation (%S)", "Efficiency (%S)"}, new int[]{Parameter.PARAMID_ELEV, Parameter.PARAMID_PERCENT});
    PairedValuesPanel _byReleasePanel = new PairedValuesPanel(new String[]{"Release (%S)", "Efficiency (%S)"}, new int[]{Parameter.PARAMID_FLOW, Parameter.PARAMID_PERCENT}, false);
    PairedValuesPanel _byOpHeadPanel = new PairedValuesPanel(new String[]{"Head (%S)", "Efficiency (%S)"}, new int[]{Parameter.PARAMID_STAGE, Parameter.PARAMID_PERCENT});
    EfficiencyHillCurvePanel _byHillCurvePanel = new EfficiencyHillCurvePanel();

    public PlantEfficiencyPanel() {
        this.setLayout(new GridBagLayout());
        this._methodSelector.addItem((Object)"Constant");
        this._methodSelector.addItem((Object)"Function of Reservoir Elevation");
        this._methodSelector.addItem((Object)"Function of Release");
        this._methodSelector.addItem((Object)"Function of Operating Head");
        this._methodSelector.addItem((Object)"Hill Curve");
        this._cardPanel.setBorder(BorderFactory.createEtchedBorder());
        this._cardPanel.setLayout(new CardLayout());
        this._constPanel.setLayout(new GridBagLayout());
        this._constPanel.add((Component)this._constLabel, new RmaGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, INSETS5550, 0, 0));
        this._constPanel.add((Component)this._constTxt, new RmaGridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 18, 2, INSETS5555, 0, 0));
        this._cardPanel.add("Constant", this._constPanel);
        this._cardPanel.add("Function of Reservoir Elevation", this._byElevPanel);
        this._cardPanel.add("Function of Release", this._byReleasePanel);
        this._cardPanel.add("Function of Operating Head", this._byOpHeadPanel);
        this._cardPanel.add("Hill Curve", (Component)((Object)this._byHillCurvePanel));
        PlantEfficiencyPanel plantEfficiencyPanel = this;
        plantEfficiencyPanel.add((Component)plantEfficiencyPanel._methodLabel, new RmaGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, INSETS5550, 0, 0));
        PlantEfficiencyPanel plantEfficiencyPanel2 = this;
        plantEfficiencyPanel2.add((Component)plantEfficiencyPanel2._methodSelector, new RmaGridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, INSETS5555, 0, 0));
        PlantEfficiencyPanel plantEfficiencyPanel3 = this;
        plantEfficiencyPanel3.add(plantEfficiencyPanel3._cardPanel, new RmaGridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 18, 1, INSETS0000, 0, 0));
        this._constLabel.setLabelFor((Component)this._constTxt);
        this._methodSelector.addItemListener((ItemListener)((Object)this));
    }

    public String getTabname() {
        return "Efficiency";
    }

    public boolean savePanel() {
        if (this._powerPlant == null) {
            return false;
        }
        this._powerPlant.setConstEfficiency(this._constTxt.getValue());
        PairedValues pairedValues = this._byElevPanel.storeForm(this._powerPlant.getEfficiencyByElev());
        this._powerPlant.setEfficiencyByElev(pairedValues);
        pairedValues = this._byReleasePanel.storeForm(this._powerPlant.getEfficiencyByRelease());
        this._powerPlant.setEfficiencyByRelease(pairedValues);
        pairedValues = this._byOpHeadPanel.storeForm(this._powerPlant.getEfficiencyByOpHead());
        this._powerPlant.setEfficiencyByOpHead(pairedValues);
        this._byHillCurvePanel.savePanel(this._powerPlant);
        this._powerPlant.setEfficiencyMethod(this._methodSelector.getSelectedIndex());
        return true;
    }

    public void fillPanel(PowerPlant powerPlant, String string) {
        this._powerPlant = powerPlant;
        if (this._powerPlant == null) {
            return;
        }
        this._constTxt.setValue(this._powerPlant.getConstEfficiency());
        this._byElevPanel.fillForm(this._powerPlant.getEfficiencyByElev());
        this._byReleasePanel.fillForm(this._powerPlant.getEfficiencyByRelease());
        this._byOpHeadPanel.fillForm(this._powerPlant.getEfficiencyByOpHead());
        this._byHillCurvePanel.fillPanel(this._powerPlant);
        this._byElevPanel.setLineStyleName("Efficiency");
        this._byReleasePanel.setLineStyleName("Efficiency");
        this._byOpHeadPanel.setLineStyleName("Efficiency");
        this._byElevPanel.setPopupPlotLegendName("Efficiency");
        this._byReleasePanel.setPopupPlotLegendName("Efficiency");
        this._byOpHeadPanel.setPopupPlotLegendName("Efficiency");
        this._byElevPanel.setPopupPlotTitle("Power Plant Efficiency: " + string);
        this._byReleasePanel.setPopupPlotTitle("Power Plant Efficiency: " + string);
        this._byOpHeadPanel.setPopupPlotTitle("Power Plant Efficiency: " + string);
        this._methodSelector.setSelectedIndex(this._powerPlant.getEfficiencyMethod());
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 2) {
            return;
        }
        if (itemEvent.getSource() == this._methodSelector) {
            ((CardLayout)this._cardPanel.getLayout()).show(this._cardPanel, (String)this._methodSelector.getSelectedItem());
            this.setModified(true);
        }
    }
}

