/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.gui.PanelSelectorCard;
import hec.model.PairedValues;
import hec.rss.client.PairedValuesPanel;
import hec.rss.model.PowerPlant;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import rma.swing.DefaultJPanel;
import rma.swing.RmaGridBagConstraints;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJLabel;

public class PlantHydLossesPanel
extends DefaultJPanel
implements PanelSelectorCard {
    PowerPlant _powerPlant;
    RmaJLabel _methodLabel = new RmaJLabel("Hydraulic Losses Method");
    RmaJComboBox _methodSelector = new RmaJComboBox();
    RmaJLabel _constLabel = new RmaJLabel("Constant Hydraulic Loss (%S)");
    RmaJDecimalField _constTxt = new RmaJDecimalField();
    JPanel _cardPanel = new JPanel();
    JPanel _constPanel = new JPanel();
    PairedValuesPanel _byReleasePanel = new PairedValuesPanel(new String[]{"Release (%S)", "Loss (%S)"}, new int[]{Parameter.PARAMID_FLOW, Parameter.PARAMID_ELEV}, false);

    public PlantHydLossesPanel() {
        this.setLayout(new GridBagLayout());
        this._methodSelector.addItem((Object)"Constant");
        this._methodSelector.addItem((Object)"Function of Release");
        this._cardPanel.setBorder(BorderFactory.createEtchedBorder());
        this._cardPanel.setLayout(new CardLayout());
        this._constPanel.setLayout(new GridBagLayout());
        this._constPanel.add((Component)this._constLabel, new RmaGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, INSETS5550, 0, 0));
        this._constPanel.add((Component)this._constTxt, new RmaGridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 18, 2, INSETS5555, 0, 0));
        this._cardPanel.add("Constant", this._constPanel);
        this._cardPanel.add("Function of Release", this._byReleasePanel);
        PlantHydLossesPanel plantHydLossesPanel = this;
        plantHydLossesPanel.add((Component)plantHydLossesPanel._methodLabel, new RmaGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, INSETS5550, 0, 0));
        PlantHydLossesPanel plantHydLossesPanel2 = this;
        plantHydLossesPanel2.add((Component)plantHydLossesPanel2._methodSelector, new RmaGridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, INSETS5555, 0, 0));
        PlantHydLossesPanel plantHydLossesPanel3 = this;
        plantHydLossesPanel3.add(plantHydLossesPanel3._cardPanel, new RmaGridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 18, 1, INSETS0000, 0, 0));
        this._constLabel.setLabelFor((Component)this._constTxt);
        this._methodSelector.addItemListener((ItemListener)((Object)this));
    }

    public String getTabname() {
        return "Hyd. Losses";
    }

    public boolean savePanel() {
        if (this._powerPlant == null) {
            return false;
        }
        this._powerPlant.setConstHydLoss(this._constTxt.getParamValue());
        PairedValues pairedValues = this._byReleasePanel.storeForm(this._powerPlant.getHydLossByRelease());
        this._powerPlant.setHydLossByRelease(pairedValues);
        this._powerPlant.setHydLossMethod(this._methodSelector.getSelectedIndex());
        return true;
    }

    public void fillPanel(PowerPlant powerPlant, String string) {
        this._powerPlant = powerPlant;
        if (this._powerPlant == null) {
            return;
        }
        powerPlant = new ParamDouble();
        this._powerPlant.getConstHydLoss((ParamDouble)powerPlant);
        this._constTxt.setValue((ParamDouble)powerPlant);
        this._byReleasePanel.fillForm(this._powerPlant.getHydLossByRelease());
        this._byReleasePanel.setLineStyleName("Elev");
        this._byReleasePanel.setPopupPlotLegendName("Hydraulic Loss");
        this._byReleasePanel.setPopupPlotTitle("Power Plant Hydraulic Loss: " + string);
        this._methodSelector.setSelectedIndex(this._powerPlant.getHydLossMethod());
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 2) {
            return;
        }
        if (itemEvent.getSource() == this._methodSelector) {
            ((CardLayout)this._cardPanel.getLayout()).show(this._cardPanel, (String)this._methodSelector.getSelectedItem());
        }
    }
}

