/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import com.google.common.flogger.FluentLogger;
import hec.appInterface.AppDaddy;
import hec.clientapp.client.ClientApp;
import hec.clientapp.client.HecG2dDialog;
import hec.clientapp.model.TSDataSet;
import hec.clientapp.model.TSRecordProxy;
import hec.data.Parameter;
import hec.event.PlotTypeChangedEvent;
import hec.event.PlotTypeListener;
import hec.geometry.Scale;
import hec.gfx2d.DataTypeFactory;
import hec.gfx2d.G2dData;
import hec.gfx2d.G2dGlyph;
import hec.gfx2d.G2dLineProperties;
import hec.gfx2d.G2dObject;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.G2dPanelProp;
import hec.gfx2d.G2dTimeSeriesLine;
import hec.gfx2d.PlotType;
import hec.gfx2d.Viewport;
import hec.gfx2d.dss.G2dDssObject;
import hec.heclib.dss.DSSPathname;
import hec.heclib.dss.DataReference;
import hec.heclib.dss.Group;
import hec.io.HecFile;
import hec.io.Identifier;
import hec.lang.DSSPathString;
import hec.model.ModelVariable;
import hec.model.RunTimeWindow;
import hec.properties.HECProperties;
import hec.refresh.RefreshEvent;
import hec.rss.client.OpenPlotTypeDialog;
import hec.rss.client.PlotDialog$1;
import hec.rss.client.PlotDialog$2;
import hec.rss.client.PlotDialog$3;
import hec.rss.client.PlotDialog$4;
import hec.rss.client.PlotDialog$ModelVariableDataReference;
import hec.rss.client.RSS;
import hec.rss.client.RssFrame;
import hec.rss.client.SelectPlotVariablesJDialog;
import hec.rss.model.Element;
import hec.rss.model.RssModelVariableConstants;
import hec.rss.model.RssRun;
import hec.rss.plugins.model.AltPluginData;
import hec.watershed.res.model.PlottableObject;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.event.EventListenerList;
import mil.army.usace.hec.rmi.csinterface.BaseDSSManager;
import mil.army.usace.hec.rmi.csinterface.DSSManager;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;
import mil.army.usace.hec.rmi.gfx2d.SimpleDSSData;
import mil.army.usace.hec.rmi.gfx2d.SimpleDSSDataFactory;
import mil.army.usace.hec.rmi.gfx2d.SimpleDSSTimeSeries;
import mil.army.usace.hec.rmi.gfx2d.SimpleDSSTimeSeriesCollection;
import mil.army.usace.hec.rmi.gfx2d.SimpleDSSTimeSeriesGlyph;
import rma.util.RMAIO;

public class PlotDialog
extends HecG2dDialog
implements RssModelVariableConstants {
    private static final FluentLogger a = FluentLogger.forEnclosingClass();
    String basePlotTitle = "";
    private Vector<RssRun> _rssRuns;
    private JMenu _plotMenu;
    private Vector _tsDataVec;
    private EventListenerList _listenerList = new EventListenerList();
    private boolean _noRunsSelected = false;
    private int _dontPlot = 0;
    private ArrayList _doNotPlotList = new ArrayList();
    private RunTimeWindow _saveRunTimeWindow = null;
    private String _windowName = "";
    private int _offSet;
    private JCheckBoxMenuItem mRefreshMenuItem;
    private JCheckBoxMenuItem _showStatsButton;
    boolean mRefreshPlots = false;

    public PlotDialog(Frame frame, String string, boolean bl) {
        super(frame, string, bl);
        this.basePlotTitle = string;
        PlotDialog plotDialog = this;
        plotDialog.setTitle(plotDialog.dateTimeTitleFormat(string));
        this.addWindowListener(new PlotDialog$1(this));
    }

    public PlotDialog(Frame frame, String string, boolean bl, Group group) {
        super(frame, string, bl, group);
        this.addWindowListener(new PlotDialog$2(this));
    }

    public PlotDialog(Frame serializable, String string, boolean n, Vector vector, Vector vector2, String string2) {
        super((Frame)serializable, string, n != 0);
        this.addWindowListener(new PlotDialog$3(this));
        this.setRssRuns(vector2);
        this._dontPlot = 0;
        this._doNotPlotList = new ArrayList();
        this.setTimeWindow(string2);
        serializable = new Vector();
        for (int i = 0; i < vector.size(); ++i) {
            PlottableObject plottableObject = (PlottableObject)vector.get(i);
            ((Vector)serializable).addAll(plottableObject.getDefaultModelVariables());
        }
        Collections.sort(serializable);
        this.setPlotObjects(vector);
        Vector<G2dData> vector3 = new Vector<G2dData>();
        for (n = 0; n < ((Vector)serializable).size(); ++n) {
            vector3.addAll(this.getG2dObjects((ModelVariable)((Vector)serializable).get(n)));
        }
        DataTypeFactory.getFactory().reset();
        this._gfxPanel.buildComponents(vector3, DataTypeFactory.getFactory().getLineProperties(vector3));
        for (int i = 0; i < this._gfxPanel.getViewportVector().size(); ++i) {
            Viewport viewport = (Viewport)this._gfxPanel.getViewportVector().get(i);
            for (int j = 0; j < viewport.getGlyphVector().size(); ++j) {
                vector = (G2dGlyph)viewport.getGlyphVector().get(j);
                serializable = vector.getScale();
                if (!((vector = vector.getG2dObject()) instanceof SimpleDSSData) || (vector = ((SimpleDSSData)vector).getModelVariable()) == null) continue;
                serializable.getModelVariables().add(vector);
            }
        }
        if (this._dontPlot > 0) {
            Object object = "";
            for (int i = 0; i < this._doNotPlotList.size(); ++i) {
                object = (String)object + "     " + String.valueOf(this._doNotPlotList.get(i)) + "\n";
            }
            if (vector3.size() == 0) {
                JOptionPane.showMessageDialog((Component)RSS.frame(), "The DSS Output Data for the following DSS records may be turned \nOff in the Alternative Editor's DSS Output tab:\n" + (String)object, "DSS Output Data Turned Off", 1);
            }
            ((FluentLogger.Api)a.atInfo()).log("\nThe Dss Output Data in the Alterantive Editors Dss Output tb may be turned off for: %s\n", object);
            ((RssFrame)AppDaddy.getFrame()).printMessage(" \nThe Dss Output Data in the Alternative Editor's DSS Output tab may be turned off for: \n" + (String)object);
        }
    }

    public void makeMenus() {
        JMenu jMenu;
        int n;
        super.makeMenus();
        this.jConfigurePlotLayout.setVisible(false);
        this._plotMenu = new JMenu("Plot");
        this._plotMenu.setMnemonic('P');
        Serializable serializable = new JMenuItem("Select Variables ...", 83);
        ((AbstractButton)serializable).addActionListener((ActionListener)((Object)this));
        this._plotMenu.add((JMenuItem)serializable);
        this._plotMenu.addSeparator();
        serializable = new JMenuItem("Open Plot Type ...", 79);
        ((AbstractButton)serializable).addActionListener((ActionListener)((Object)this));
        this._plotMenu.add((JMenuItem)serializable);
        serializable = new JMenuItem("Save Plot Type ...", 80);
        ((AbstractButton)serializable).addActionListener((ActionListener)((Object)this));
        this._plotMenu.add((JMenuItem)serializable);
        serializable = new Vector();
        for (n = this.jmb.getMenuCount() - 1; n >= 0 && !(jMenu = this.jmb.getMenu(n)).getText().equals("Edit"); --n) {
            this.jmb.remove(jMenu);
            ((Vector)serializable).add(jMenu);
        }
        this.jmb.add(this._plotMenu);
        for (n = 0; n < ((Vector)serializable).size(); ++n) {
            this.jmb.add((JMenu)((Vector)serializable).get(n));
        }
        serializable = new JMenuItem("Refresh");
        ((AbstractButton)serializable).addActionListener((ActionListener)((Object)this));
        this._viewMenu.add((JMenuItem)serializable);
        this._viewMenu.addSeparator();
        this.mRefreshMenuItem = new JCheckBoxMenuItem("Live Display...");
        this.mRefreshMenuItem.addActionListener(new PlotDialog$4(this));
        this._viewMenu.add(this.mRefreshMenuItem);
        this._showStatsButton = new JCheckBoxMenuItem("Show Statistics");
        this._viewMenu.add(this._showStatsButton);
        this._showStatsButton.setSelected(false);
        this._showStatsButton.setVisible(false);
        this._showStatsButton.addActionListener((ActionListener)((Object)this));
    }

    public void setRssRuns(Vector vector) {
        this._rssRuns = vector;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = (JMenuItem)actionEvent.getSource();
        if ("Select Variables ...".equals(object = ((AbstractButton)object).getText())) {
            this.selectModelVariables();
            return;
        }
        if ("Save Plot Type ...".equals(object)) {
            this.savePlotType();
            return;
        }
        if ("Open Plot Type ...".equals(object)) {
            this.openPlotType();
            return;
        }
        if ("Refresh".equals(object)) {
            this.refreshPlot();
            return;
        }
        if ("Show Statistics".equals(object)) {
            this._gfxPanel.showStatistics(this._showStatsButton.isSelected());
            return;
        }
        super.actionPerformed(actionEvent);
    }

    public void setPlotObjects(Vector vector) {
        if (vector == null || vector.isEmpty()) {
            this._plotMenu.setVisible(false);
        } else {
            this._plotMenu.setVisible(true);
        }
        this._plotObjs = vector;
    }

    void selectModelVariables() {
        if (this._plotObjs == null) {
            return;
        }
        SelectPlotVariablesJDialog selectPlotVariablesJDialog = new SelectPlotVariablesJDialog((Frame)((Object)this));
        selectPlotVariablesJDialog.setAvailablePlotObjects(this._plotObjs);
        selectPlotVariablesJDialog.setSelectedViewports(this._gfxPanel.getViewportVector());
        selectPlotVariablesJDialog.setVisible(true);
    }

    void openPlotType() {
        OpenPlotTypeDialog openPlotTypeDialog = new OpenPlotTypeDialog((Frame)((Object)this), true, 0);
        openPlotTypeDialog.setTitle("Open Plot Type ...");
        openPlotTypeDialog.setFileManager((RmiFileManager)ClientApp.app().getFileManager().getRemote());
        openPlotTypeDialog.setElementTypes(this.getElementTypes());
        Object object = ClientApp.app().getAppType();
        openPlotTypeDialog.setSubDirectory((String)object);
        object = new Vector<String>();
        ((Vector)object).add("*.plotType");
        openPlotTypeDialog.setFileFilters((List)object);
        openPlotTypeDialog.setShowFileExtensions(false);
        openPlotTypeDialog.setVisible(true);
        if (openPlotTypeDialog.isCanceled()) {
            return;
        }
        if ((openPlotTypeDialog = openPlotTypeDialog.getIdentifier()) == null) {
            return;
        }
        if (!openPlotTypeDialog.getPath().endsWith(".plotType")) {
            OpenPlotTypeDialog openPlotTypeDialog2 = openPlotTypeDialog;
            openPlotTypeDialog2.setPath(openPlotTypeDialog2.getPath() + ".plotType");
        }
        this._gfxPanel.setVisible(false);
        this.openPlotType((Identifier)openPlotTypeDialog);
        this._gfxPanel.setVisible(true);
        if (this._saveRunTimeWindow != null) {
            PlotDialog plotDialog = this;
            plotDialog.plotTimeWindow(plotDialog._saveRunTimeWindow, this._offSet, "Time of Simulation");
        }
        this.refreshPlot();
    }

    public void openPlotType(Identifier identifier) {
        Identifier identifier2 = this.getOpenIdentifier(identifier, null, false);
        if (identifier2 == null) {
            return;
        }
        HecFile hecFile = identifier2.getFile();
        if (hecFile == null) {
            return;
        }
        hecFile = new PlotType();
        try {
            if (!hecFile.readFile(identifier2) || hecFile.getPanelProperties() == null) {
                ((FluentLogger.Api)a.atInfo()).log("openPlotType: failed to read %s correctly", (Object)identifier.getPath());
                return;
            }
            this.configurePlot((PlotType)hecFile);
        }
        catch (Exception exception) {
            ((FluentLogger.Api)a.atInfo()).log("openPlotType: error reading %s Error %s", (Object)identifier.getPath(), (Object)exception);
        }
    }

    public void plotTimeWindow(RunTimeWindow runTimeWindow, int n, String string) {
        this._saveRunTimeWindow = runTimeWindow;
        this._offSet = n;
        this._windowName = string;
        super.plotTimeWindow(runTimeWindow, n, string);
        this._gfxPanel.showStatistics(false);
    }

    public boolean openPlotType(BufferedReader bufferedReader) {
        if (bufferedReader == null) {
            return false;
        }
        PlotType plotType = new PlotType();
        try {
            if (plotType.readFile(bufferedReader) && plotType.getPanelProperties() != null) {
                return this.configurePlot(plotType);
            }
            ((FluentLogger.Api)a.atInfo()).log("openPlotType: failed to read plot type correctly");
            return false;
        }
        catch (Exception exception) {
            ((FluentLogger.Api)a.atInfo()).log("openPlotType: error reading plot type Error %s", (Object)exception);
            return false;
        }
    }

    boolean configurePlot(PlotType object) {
        this._gfxPanel.configurePanel(object.getPanelProperties());
        object = object.getPlotVariables();
        boolean bl = this.configurePlotVariables((Vector)object);
        this.repaint();
        return bl;
    }

    boolean configurePlotVariables(Vector vector) {
        int n;
        int n2;
        Vector<Object> vector2 = new Vector();
        this._dontPlot = 0;
        this._doNotPlotList = new ArrayList();
        DataTypeFactory.getFactory().reset();
        for (n2 = 0; n2 < vector.size(); ++n2) {
            Scale scale;
            Viewport viewport;
            ModelVariable modelVariable = (ModelVariable)vector.get(n2);
            if (this._rssRuns == null) {
                this.noRunsSelectedMessage("ResSim");
                break;
            }
            n = this._rssRuns.size();
            if (n <= 0) {
                this.noRunsSelectedMessage("ResSim");
                break;
            }
            vector2 = this.getG2dObjects(modelVariable);
            n = modelVariable.getViewportIndex();
            if (n < 0 || n >= this._gfxPanel.getViewportVector().size() || (viewport = (Viewport)this._gfxPanel.getViewportVector().get(n)) == null) continue;
            if (modelVariable.getScaleIndex() != -1) {
                scale = (Scale)viewport.getScaleVector().get(modelVariable.getScaleIndex());
                if (scale != null) {
                    scale.getModelVariables().add(modelVariable);
                }
            } else {
                scale = null;
            }
            if (vector2 == null || vector2.isEmpty()) continue;
            boolean bl = Boolean.getBoolean("PlotWindow.OldEnsemblePlot");
            if (bl) {
                List list = DataTypeFactory.getFactory().getLineProperties(vector2, this.getParamFromModelVariable(modelVariable));
                for (var8_12 = 0; var8_12 < vector2.size(); ++var8_12) {
                    if (scale != null) {
                        viewport.addG2dObject((G2dObject)vector2.get(var8_12), (G2dLineProperties)list.get(var8_12), scale);
                        continue;
                    }
                    viewport.addG2dObject((G2dObject)vector2.get(var8_12), (G2dLineProperties)list.get(var8_12));
                }
            } else {
                var8_12 = vector2.size();
                for (int i = 0; i < var8_12; ++i) {
                    G2dLineProperties g2dLineProperties = DataTypeFactory.getFactory().getLineProperties((G2dDssObject)((SimpleDSSData)vector2.get(i)), this.getParamFromModelVariable(modelVariable), true);
                    G2dObject g2dObject = (G2dObject)vector2.get(i);
                    if (g2dObject instanceof SimpleDSSTimeSeriesCollection) {
                        int n3 = ((SimpleDSSTimeSeriesCollection)vector2.get(i)).getCurveCount() - 5;
                        if (n3 > 1) {
                            n3 = 80 / n3;
                            g2dLineProperties._lineTransparency = n3 = 90 - n3;
                        } else {
                            g2dLineProperties._lineTransparency = 90;
                        }
                    } else if (g2dObject instanceof SimpleDSSTimeSeries) {
                        SimpleDSSTimeSeries simpleDSSTimeSeries = (SimpleDSSTimeSeries)g2dObject;
                        if (simpleDSSTimeSeries.numberValues == 0) {
                            ((FluentLogger.Api)a.atInfo()).log("Failed to load time series for %s, DSS Info=%s", (Object)simpleDSSTimeSeries.getName(), (Object)simpleDSSTimeSeries.getDSSIdentifer());
                            continue;
                        }
                    }
                    if (scale != null) {
                        viewport.addG2dObject(g2dObject, g2dLineProperties, scale);
                        continue;
                    }
                    viewport.addG2dObject(g2dObject, g2dLineProperties);
                }
            }
            if (!viewport.containsStatistics()) continue;
            this._showStatsButton.setVisible(true);
        }
        if (this._dontPlot > 0) {
            Object object = "";
            for (n = 0; n < this._doNotPlotList.size(); ++n) {
                object = (String)object + "     " + String.valueOf(this._doNotPlotList.get(n)) + "\n";
            }
            if (vector2 == null || vector2.isEmpty()) {
                JOptionPane.showMessageDialog((Component)RSS.frame(), "The DSS Output Data for the following DSS records may be turned \nOff in the Alternative Editor's DSS Output tab:\n" + (String)object, "DSS Output Data Turned Off", 1);
                ((FluentLogger.Api)a.atInfo()).log("\nThe Dss Output Data in the Alterantive Editors Dss Output tb may be turned off for: %s \n", object);
                ((RssFrame)AppDaddy.getFrame()).printMessage(" \nThe Dss Output Data in the Alterantive Editor's Dss Output tb may be turned off for: \n" + (String)object);
                return false;
            }
            ((FluentLogger.Api)a.atInfo()).log("\nThe Dss Output Data in the Alterantive Editors Dss Output tb may be turned off for: %s \n", object);
            ((RssFrame)AppDaddy.getFrame()).printMessage(" \nThe Dss Output Data in the Alterantive Editor's Dss Output tb may be turned off for: \n" + (String)object);
        }
        for (n2 = 0; this._gfxPanel.getLegendPanel() != null && n2 < this._gfxPanel.getViewportVector().size(); ++n2) {
            this._gfxPanel.getLegendPanel().addViewport((Viewport)this._gfxPanel.getViewportVector().get(n2));
        }
        return true;
    }

    public String getParamFromModelVariable(ModelVariable modelVariable) {
        if (modelVariable.getParamId() == -1) {
            return modelVariable.getNameQualifier();
        }
        Object object = Parameter.getParamString((int)modelVariable.getParamId());
        if (modelVariable.getNameQualifier() != null) {
            object = (String)object + "-" + modelVariable.getNameQualifier();
        }
        return object;
    }

    void savePlotType() {
        if (this._plotObjs == null) {
            return;
        }
        OpenPlotTypeDialog openPlotTypeDialog = new OpenPlotTypeDialog((Frame)((Object)this), true, 1);
        openPlotTypeDialog.setTitle("Save Plot Type ...");
        openPlotTypeDialog.setFileManager((RmiFileManager)ClientApp.app().getFileManager().getRemote());
        Object object = ClientApp.app().getAppType();
        openPlotTypeDialog.setSubDirectory((String)object);
        openPlotTypeDialog.setElementTypes(this.getElementTypes());
        object = new Vector<String>();
        ((Vector)object).add("*.plottype");
        openPlotTypeDialog.setFileFilters((List)object);
        openPlotTypeDialog.setVisible(true);
        if (openPlotTypeDialog.isCanceled()) {
            return;
        }
        if ((openPlotTypeDialog = openPlotTypeDialog.getIdentifier()) == null) {
            return;
        }
        this.savePlotType((Identifier)openPlotTypeDialog);
    }

    private void savePlotType(Identifier identifier) {
        Viewport viewport;
        int n = 0;
        Vector vector = new Vector();
        for (int i = 0; i < this._gfxPanel.getViewportVector().size(); ++i) {
            viewport = (Viewport)this._gfxPanel.getViewportVector().get(i);
            for (int j = 0; j < viewport.getScaleVector().size(); ++j) {
                Scale scale = (Scale)viewport.getScaleVector().get(j);
                scale.getAxis(1);
                Vector vector2 = scale.getModelVariables();
                if (vector2 == null || vector2.isEmpty()) continue;
                for (int k = 0; k < vector2.size(); ++k) {
                    scale = (ModelVariable)vector2.get(k);
                    scale.setViewportIndex(i);
                    n |= Element.a((ModelVariable)scale);
                }
                vector.addAll(vector2);
            }
        }
        String string = RMAIO.getFileFromPath((String)identifier.getPath());
        String string2 = RMAIO.getDirectoryFromPath((String)identifier.getPath());
        string = String.valueOf(n).concat("-").concat(string);
        identifier.setPath(string2 + "/" + string);
        Identifier identifier2 = this.getOpenIdentifier(identifier, ".plotType", true);
        if (identifier2 == null) {
            return;
        }
        Object object = identifier2.getFile();
        if (object == null) {
            return;
        }
        if ((object = object.getBufferedWriter()) == null) {
            return;
        }
        object = this._gfxPanel.getProperties();
        viewport = new PlotType();
        viewport.setName(identifier.getName());
        viewport.setPlotVariables(vector);
        viewport.setPanelProperties((G2dPanelProp)object);
        try {
            viewport.writeFile(identifier2);
        }
        catch (Exception exception) {
            ((FluentLogger.Api)a.atInfo()).log("Error writing PlotType %s", (Object)exception.getMessage());
        }
        this.firePlotTypesChanged(0);
    }

    Vector<G2dData> getG2dObjects(ModelVariable modelVariable) {
        Object object;
        TSRecordProxy tSRecordProxy = new Vector();
        if (modelVariable == null) {
            return new Vector<G2dData>();
        }
        if (this._plotObjs == null) {
            return new Vector<G2dData>();
        }
        for (int i = 0; i < this._plotObjs.size(); ++i) {
            object = this._plotObjs.get(i);
            if (!(object instanceof PlottableObject) || (object = (PlottableObject)object) == null) continue;
            object.getTSRecords(modelVariable, tSRecordProxy, this._rssRuns);
        }
        object = new Vector();
        int n = 0;
        if (ClientApp.app() != null && ClientApp.Workspace() != null) {
            n = ClientApp.Workspace().getWatershedTimeZone().getRawOffset() / 3600000;
        }
        Vector<TSDataSet> vector = this.getTSDataList(modelVariable);
        if (this._rssRuns != null) {
            Object object2;
            int n2;
            RssRun rssRun;
            int n3;
            int n4 = this._rssRuns.size();
            Vector<TSRecordProxy> vector2 = new Vector<TSRecordProxy>();
            for (n3 = 0; n3 < n4; ++n3) {
                rssRun = this._rssRuns.get(n3);
                for (n2 = 0; n2 < tSRecordProxy.size(); ++n2) {
                    if (rssRun.getAlternative().getWriteDSSOutputDataTable().writeRecord((TSRecordProxy)tSRecordProxy.get(n2))) {
                        if (vector2.contains(tSRecordProxy.get(n2))) continue;
                        vector2.add((TSRecordProxy)tSRecordProxy.get(n2));
                        continue;
                    }
                    ++this._dontPlot;
                    object2 = ((TSRecordProxy)tSRecordProxy.get(n2)).getName();
                    if (((String)object2).startsWith("~")) {
                        object2 = rssRun.getAlternative().getSystem().getNameForKeyString((String)object2);
                    }
                    this._doNotPlotList.add((String)object2 + "/" + ((TSRecordProxy)tSRecordProxy.get(n2)).getParamName());
                }
            }
            block3: for (n3 = 0; n3 < vector2.size(); ++n3) {
                tSRecordProxy = (TSRecordProxy)vector2.get(n3);
                if (tSRecordProxy == null) continue;
                for (n2 = 0; n2 < vector.size(); ++n2) {
                    Object object3 = vector.get(n2);
                    if ((object3 = object3.getTSRecord(tSRecordProxy.getName(), tSRecordProxy.getVariableId())) == null) continue;
                    object2 = new ArrayList();
                    DSSPathname dSSPathname = new DSSPathname();
                    String string = object3.getDSSFilename();
                    object3 = object3.getDSSPathname();
                    dSSPathname.setPathname((String)object3);
                    dSSPathname.setDPart("");
                    String string2 = dSSPathname.getFPart();
                    block5: for (int i = 0; i < this._rssRuns.size(); ++i) {
                        if (!string2.equalsIgnoreCase(this._rssRuns.get(i).getName()) || (rssRun = this._rssRuns.get(i)).getAlternative().getPluginDataList() == null || rssRun.getAlternative().getPluginDataList().isEmpty() || rssRun.getAlternative().useYieldAnalysis()) continue;
                        List<AltPluginData> list = rssRun.getAlternative().getPluginDataList();
                        for (int j = 0; j < list.size(); ++j) {
                            AltPluginData altPluginData = list.get(j);
                            if (!altPluginData.useCompute()) continue;
                            object2 = altPluginData.getCollectionNumbers(rssRun.getAlternative(), rssRun.getRunTimeWindow().getStartTime());
                            continue block5;
                        }
                    }
                    if (object2 != null && !object2.isEmpty()) {
                        dSSPathname.setCollectionSequence((String)object2.get(0));
                        if (tSRecordProxy.getVariableId() == 76) {
                            dSSPathname.setCollectionSequence((String)object2.get(0));
                            object3 = new PlotDialog$ModelVariableDataReference(this, dSSPathname.getPathname(), string, modelVariable);
                            object3.setGmtOffset(n);
                            object.add(object3);
                            continue block3;
                        }
                        object3 = new PlotDialog$ModelVariableDataReference(this, dSSPathname.getPathname(), string, modelVariable, (List<String>)object2);
                        object3.setGmtOffset(n);
                        object.add(object3);
                        continue;
                    }
                    object3 = new PlotDialog$ModelVariableDataReference(this, (String)object3, string, modelVariable);
                    object3.setGmtOffset(n);
                    object.add(object3);
                }
            }
        }
        return this.getDssList((Vector)object, this._timewindow);
    }

    public void setTSDataList(Vector vector) {
        this._tsDataVec = vector;
    }

    public G2dPanel getG2dPanel() {
        return this._gfxPanel;
    }

    public void addPlotTypeListener(PlotTypeListener plotTypeListener) {
        this._listenerList.add(PlotTypeListener.class, plotTypeListener);
    }

    public void removePlotTypeListener(PlotTypeListener plotTypeListener) {
        this._listenerList.remove(PlotTypeListener.class, plotTypeListener);
    }

    protected void firePlotTypesChanged(int n) {
        PlotTypeChangedEvent plotTypeChangedEvent = null;
        EventListener[] eventListenerArray = this._listenerList.getListeners(PlotTypeListener.class);
        for (int i = eventListenerArray.length - 1; i >= 0; --i) {
            if (plotTypeChangedEvent == null) {
                plotTypeChangedEvent = new PlotTypeChangedEvent((Object)this, n);
            }
            ((PlotTypeListener)eventListenerArray[i]).plotTypesChanged(plotTypeChangedEvent);
        }
    }

    Vector<TSDataSet> getTSDataList(ModelVariable object) {
        Vector<TSDataSet> vector = new Vector<TSDataSet>();
        if (object == null) {
            return vector;
        }
        int n = this._rssRuns.size();
        if (n <= 0) {
            return vector;
        }
        int n2 = object.getDataSetId();
        block7: for (int i = 0; i < n; ++i) {
            object = this._rssRuns.get(i);
            if (object == null) continue;
            switch (n2) {
                case 1: {
                    TSDataSet tSDataSet = ((RssRun)object).getInputTSData();
                    if (tSDataSet == null) continue block7;
                    vector.addElement(tSDataSet);
                    continue block7;
                }
                case 0: {
                    TSDataSet tSDataSet = ((RssRun)object).getRegOutputTSData();
                    if (tSDataSet != null) {
                        vector.addElement(tSDataSet);
                    }
                    if ((tSDataSet = ((RssRun)object).getObservedTSData()) == null) continue block7;
                    vector.addElement(tSDataSet);
                    continue block7;
                }
                case 2: {
                    TSDataSet tSDataSet = ((RssRun)object).getUnregOutputTSData();
                    if (tSDataSet == null) continue block7;
                    vector.addElement(tSDataSet);
                    continue block7;
                }
                case 3: {
                    TSDataSet tSDataSet = ((RssRun)object).getCumLocOutputTSData();
                    if (tSDataSet == null) continue block7;
                    vector.addElement(tSDataSet);
                    continue block7;
                }
                case 4: 
                case 5: {
                    continue block7;
                }
                default: {
                    ((FluentLogger.Api)a.atInfo()).log("getTSDataList: unknown source type %s", n2);
                }
            }
        }
        ((FluentLogger.Api)a.atInfo()).log("getTSDataList: got %d records", vector.size());
        return vector;
    }

    private void noRunsSelectedMessage(String string) {
        JOptionPane.showMessageDialog((Component)ClientApp.frame(), "No Runs selected or no selected Runs contain " + string + " models", "No Runs Found", 1);
        this._noRunsSelected = true;
    }

    public Vector getDssList(Vector vector, String string) {
        DataReference dataReference;
        int n;
        HECProperties hECProperties;
        Vector<DSSManager> vector2 = new Vector<DSSManager>();
        if (vector == null) {
            return vector2;
        }
        Object object = null;
        try {
            object = (DSSManager)ClientApp.Workspace().getData().getDSSFileManager().getRemote();
        }
        catch (Exception exception) {
            ((FluentLogger.Api)a.atInfo()).log("getDssList: failed to get dssfilemanager %s", (Object)exception);
        }
        if (object == null) {
            return vector2;
        }
        SimpleDSSDataFactory simpleDSSDataFactory = new SimpleDSSDataFactory((BaseDSSManager)object);
        boolean bl = false;
        if (Boolean.getBoolean("computeTesting") && (hECProperties = ClientApp.app().getProperties()) != null) {
            bl = Boolean.parseBoolean(hECProperties.getProp("computeTestingEnabled"));
        }
        for (n = 0; n < vector.size(); ++n) {
            block14: {
                if (!(vector.get(n) instanceof PlotDialog$ModelVariableDataReference)) continue;
                dataReference = (DataReference)vector.get(n);
                ((FluentLogger.Api)a.atInfo()).log("ref.getFilename = %s ref.getPath = %s", (Object)dataReference.getFilename(), (Object)dataReference.getPath());
                try {
                    object = simpleDSSDataFactory.newSimpleDSSData(dataReference.getFilename(), dataReference.getPath(), string, ((PlotDialog$ModelVariableDataReference)((Object)vector.get(n))).getCollections());
                    if (object == null || !(dataReference instanceof PlotDialog$ModelVariableDataReference)) break block14;
                    object.setModelVariable(((PlotDialog$ModelVariableDataReference)dataReference).getModelVariable());
                }
                catch (Exception exception) {
                    ((FluentLogger.Api)a.atInfo()).log("getDssList: error getting data for %s:%s", (Object)dataReference.getFilename(), (Object)dataReference.getPath());
                    continue;
                }
            }
            if (object == null || object.size() <= 0) {
                ((FluentLogger.Api)a.atInfo()).log("failed to get data for %s:%s", (Object)dataReference.getFilename(), (Object)dataReference.getPath());
                continue;
            }
            object.setGmtOffset(dataReference.getGmtOffset());
            vector2.add((DSSManager)object);
        }
        if (bl) {
            for (n = 0; n < vector.size(); ++n) {
                block15: {
                    dataReference = (DataReference)vector.get(n);
                    if (!dataReference.getFilename().endsWith("simulation.dss")) continue;
                    RMAIO.getDirectoryFromPath((String)dataReference.getFilename());
                    object = RMAIO.getDirectoryFromPath((String)dataReference.getFilename());
                    object = object.concat("/referenceResults/rss");
                    object = object.concat("/").concat(RMAIO.getFileFromPath((String)dataReference.getFilename()));
                    try {
                        object = simpleDSSDataFactory.newSimpleDSSData((String)object, dataReference.getPath(), string);
                        if (!(dataReference instanceof PlotDialog$ModelVariableDataReference)) break block15;
                        object.setModelVariable(((PlotDialog$ModelVariableDataReference)dataReference).getModelVariable());
                    }
                    catch (Exception exception) {
                        ((FluentLogger.Api)a.atInfo()).log("getDssList: error getting data for %s:%s", (Object)dataReference.getFilename(), (Object)dataReference.getPath());
                        continue;
                    }
                }
                if (object == null) continue;
                if ((dataReference = DSSPathString.parsePathname((String)dataReference.getPath())) != null) {
                    object.name = dataReference[1] + "." + dataReference[5] + "." + dataReference[2] + "." + dataReference[4] + " (REF)";
                }
                vector2.addElement((DSSManager)object);
            }
        }
        return vector2;
    }

    private int[] getElementTypes() {
        if (this._plotObjs == null) {
            return new int[0];
        }
        Vector vector = new Vector(this._plotObjs.size());
        for (int i = 0; i < this._plotObjs.size(); ++i) {
            Object object = this._plotObjs.get(i);
            if (!(object instanceof Element) || vector.contains(object = new Integer(((Element)object).getElementTypeId()))) continue;
            vector.add(object);
        }
        int[] nArray = new int[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            nArray[i] = (Integer)vector.get(i);
        }
        return nArray;
    }

    public void setVisible(boolean bl) {
        if (bl && this._noRunsSelected) {
            return;
        }
        super.setVisible(bl);
        if (!bl) {
            this._noRunsSelected = false;
            this.dispose();
        }
    }

    private void closeDialog() {
        this.setVisible(false);
    }

    public void refreshPlot() {
        Viewport[] viewportArray = this.getPlotpanel().getViewports();
        for (int i = 0; i < viewportArray.length; ++i) {
            Vector vector = viewportArray[i].getGlyphVector();
            for (int j = 0; j < vector.size(); ++j) {
                G2dGlyph g2dGlyph = (G2dGlyph)vector.get(j);
                if (!(g2dGlyph instanceof SimpleDSSTimeSeriesGlyph)) continue;
                g2dGlyph = (SimpleDSSTimeSeriesGlyph)g2dGlyph;
                SimpleDSSTimeSeries simpleDSSTimeSeries = (SimpleDSSTimeSeries)g2dGlyph.getG2dObject();
                simpleDSSTimeSeries.setLoaded(false);
                simpleDSSTimeSeries.load();
                g2dGlyph = (G2dTimeSeriesLine)g2dGlyph.getLine();
                g2dGlyph.clearLineData();
                g2dGlyph.setRawTimeSeriesData(simpleDSSTimeSeries.tdata, simpleDSSTimeSeries.ydata, null);
            }
            viewportArray[i].setDirty();
        }
        this.getPlotpanel().paintGfx();
    }

    private String notCurrentTitleFormat(String object) {
        object = (String)object + "- Not Current Data";
        return object;
    }

    private String dateTimeTitleFormat(String object) {
        object = (String)object + "-";
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        int n = gregorianCalendar.get(12);
        String string = "" + n;
        if (string.length() < 2) {
            string = "0" + string;
        }
        object = (String)object + " " + gregorianCalendar.get(10) + ":" + string + (gregorianCalendar.get(9) == 0 ? "AM" : "PM");
        return object;
    }

    public void refresh(RefreshEvent refreshEvent) {
        if (this.mRefreshPlots) {
            PlotDialog plotDialog = this;
            plotDialog.setTitle(plotDialog.dateTimeTitleFormat(this.basePlotTitle));
            super.refresh(refreshEvent);
            return;
        }
        PlotDialog plotDialog = this;
        plotDialog.setTitle(plotDialog.notCurrentTitleFormat(this.basePlotTitle));
    }

    public void setRefresh(boolean bl) {
        if (this.mRefreshMenuItem.isSelected() != bl) {
            this.mRefreshMenuItem.doClick(0);
        }
    }
}

