/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.rss.model.DaysOfWeek;
import hec.rss.model.PowerGenerationOptions;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.EventObject;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaGridBagConstraints;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDialog;
import rma.swing.list.RmaListModel;

public class PowerGenerationReqDlg
extends RmaJDialog
implements ActionListener,
ButtonCmdPanelListener {
    private static final String[] a = new String[]{"Monthly", "Seasonally"};
    private static final String[] b = new String[]{"Daily Total MWH", "Weekly Total MWH"};
    private static final String[] c = new String[]{"Each Time-Step", "Daily", "Weekly"};
    boolean m_cancled = true;
    PowerGenerationOptions m_hydropowerRule = null;
    MessageFormat m_labelFormat = new MessageFormat("<HTML>Week belongs to a {0}<br>when this day is in the {0}:</HTML>");
    JLabel m_monthSeasonLabel;
    RmaJComboBox m_requirementVariesCombo = new RmaJComboBox((ComboBoxModel)new RmaListModel(false, (Object[])a));
    RmaJComboBox m_requirementSpecifiedCombo = new RmaJComboBox((ComboBoxModel)new RmaListModel(false, (Object[])this.generateMonthlyTotalPowerStrings()));
    RmaJComboBox m_startingDayCombo = new RmaJComboBox((ComboBoxModel)new RmaListModel(false, (Object[])DaysOfWeek.DAYS));
    RmaJComboBox m_weekCombo = new RmaJComboBox((ComboBoxModel)new RmaListModel(false, (Object[])DaysOfWeek.DAYS));
    RmaJComboBox m_periodCombo = new RmaJComboBox((ComboBoxModel)new RmaListModel(false, (Object[])c));
    RmaJComboBox m_startingPeriodCombo = new RmaJComboBox((ComboBoxModel)new RmaListModel(false, (Object[])DaysOfWeek.DAYS));

    public PowerGenerationReqDlg() {
        this.buildControls();
    }

    public PowerGenerationReqDlg(JFrame jFrame, String string, boolean bl) {
        super((Frame)jFrame, string, bl);
        this.buildControls();
    }

    public PowerGenerationReqDlg(JDialog jDialog, String string, boolean bl) {
        super((Dialog)jDialog, string, bl);
        this.buildControls();
    }

    private void buildControls() {
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        RmaGridBagConstraints rmaGridBagConstraints = new RmaGridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        rmaGridBagConstraints.set(0, 0, 1, 1, 1.0, 0.0, 18, 2, RmaInsets.INSETS0000, 0, 0);
        container.add((Component)jPanel, rmaGridBagConstraints);
        JLabel jLabel = new JLabel("Requirement Varies");
        rmaGridBagConstraints.set(0, 0, 1, 1, 0.0, 0.0, 17, 0, RmaInsets.INSETS5500, 0, 0);
        jPanel.add((Component)jLabel, rmaGridBagConstraints);
        rmaGridBagConstraints.set(1, 0, 1, 1, 1.0, 0.0, 17, 2, RmaInsets.INSETS5505, 0, 0);
        jPanel.add((Component)this.m_requirementVariesCombo, rmaGridBagConstraints);
        jPanel = new JPanel(new GridBagLayout());
        jLabel = new JLabel("Requirement Specified as:");
        rmaGridBagConstraints.set(0, 0, 1, 1, 0.0, 0.0, 17, 0, RmaInsets.INSETS0500, 0, 0);
        jPanel.add((Component)jLabel, rmaGridBagConstraints);
        rmaGridBagConstraints.set(1, 0, 1, 1, 1.0, 0.0, 17, 2, RmaInsets.INSETS5505, 0, 0);
        jPanel.add((Component)this.m_requirementSpecifiedCombo, rmaGridBagConstraints);
        jLabel = new JLabel("Starting Day:");
        rmaGridBagConstraints.set(0, 1, 1, 1, 0.0, 0.0, 17, 0, RmaInsets.INSETS5500, 0, 0);
        jPanel.add((Component)jLabel, rmaGridBagConstraints);
        rmaGridBagConstraints.set(1, 1, 1, 1, 1.0, 0.0, 17, 2, RmaInsets.INSETS5505, 0, 0);
        jPanel.add((Component)this.m_startingDayCombo, rmaGridBagConstraints);
        this.m_monthSeasonLabel = new JLabel(this.m_labelFormat.format(new String[]{"season"}));
        rmaGridBagConstraints.set(0, 2, 1, 1, 0.0, 0.0, 17, 0, RmaInsets.INSETS5500, 0, 0);
        jPanel.add((Component)this.m_monthSeasonLabel, rmaGridBagConstraints);
        rmaGridBagConstraints.set(1, 2, 1, 1, 1.0, 0.0, 17, 2, RmaInsets.INSETS5505, 0, 0);
        jPanel.add((Component)this.m_weekCombo, rmaGridBagConstraints);
        jPanel.setBorder(BorderFactory.createTitledBorder("Requirement Specification"));
        rmaGridBagConstraints.set(0, 1, 1, 1, 1.0, 0.0, 18, 2, RmaInsets.INSETS0505, 0, 0);
        container.add((Component)jPanel, rmaGridBagConstraints);
        jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder("Period over which Generation Requirement is satisfied"));
        rmaGridBagConstraints.set(0, 2, 1, 1, 1.0, 1.0, 18, 2, RmaInsets.INSETS0505, 0, 0);
        container.add((Component)jPanel, rmaGridBagConstraints);
        jLabel = new JLabel("Period:");
        rmaGridBagConstraints.set(0, 0, 1, 1, 0.0, 0.0, 17, 0, RmaInsets.INSETS0500, 0, 0);
        jPanel.add((Component)jLabel, rmaGridBagConstraints);
        rmaGridBagConstraints.set(1, 0, 1, 1, 1.0, 0.0, 17, 2, RmaInsets.INSETS5505, 0, 0);
        jPanel.add((Component)this.m_periodCombo, rmaGridBagConstraints);
        jLabel = new JLabel("Starting Day of Period:");
        rmaGridBagConstraints.set(0, 1, 1, 1, 0.0, 0.0, 17, 0, RmaInsets.INSETS5550, 0, 0);
        jPanel.add((Component)jLabel, rmaGridBagConstraints);
        rmaGridBagConstraints.set(1, 1, 1, 1, 1.0, 0.0, 17, 2, RmaInsets.INSETS5555, 0, 0);
        jPanel.add((Component)this.m_startingPeriodCombo, rmaGridBagConstraints);
        jPanel = new ButtonCmdPanel(12);
        jPanel.addCmdPanelListener(this);
        rmaGridBagConstraints.set(0, 3, 1, 1, 1.0, 0.0, 16, 2, RmaInsets.INSETS5555, 0, 0);
        container.add((Component)jPanel, rmaGridBagConstraints);
        this.m_requirementVariesCombo.addActionListener((ActionListener)this);
        this.m_requirementSpecifiedCombo.addActionListener((ActionListener)this);
        this.m_startingDayCombo.addActionListener((ActionListener)this);
        this.m_weekCombo.addActionListener((ActionListener)this);
        this.m_periodCombo.addActionListener((ActionListener)this);
        this.m_startingPeriodCombo.addActionListener((ActionListener)this);
        this.m_startingPeriodCombo.setEnabled(false);
        this.m_startingPeriodCombo.setSelectedIndex(-1);
        this.m_weekCombo.setEnabled(false);
        this.m_weekCombo.setSelectedIndex(-1);
        this.m_startingDayCombo.setEnabled(false);
        this.m_startingDayCombo.setSelectedIndex(-1);
        this.setResizable(false);
    }

    @Override
    public void actionPerformed(ActionEvent object) {
        if ((object = ((EventObject)object).getSource()) == this.m_requirementVariesCombo) {
            this.RequirementVariation_ActionPerformed();
            return;
        }
        if (object == this.m_requirementSpecifiedCombo) {
            this.RequirementSpecification_ActionPerformed();
            return;
        }
        if (object != this.m_startingDayCombo && object != this.m_weekCombo) {
            if (object == this.m_periodCombo) {
                this.PeriodCombo_ActionPerfomred();
                return;
            }
        }
    }

    private void RequirementSpecification_ActionPerformed() {
        String string = (String)this.m_requirementSpecifiedCombo.getSelectedItem();
        boolean bl = string != null && string.indexOf("Weekly") >= 0;
        this.m_startingDayCombo.setEnabled(bl);
        this.m_weekCombo.setEnabled(bl);
    }

    private void RequirementVariation_ActionPerformed() {
        RmaListModel rmaListModel = (RmaListModel)this.m_requirementSpecifiedCombo.getModel();
        if (this.m_requirementVariesCombo.getSelectedItem() == a[0]) {
            rmaListModel.setAll((Object[])this.generateMonthlyTotalPowerStrings());
            this.m_monthSeasonLabel.setText(this.m_labelFormat.format(new String[]{"month"}));
        } else {
            rmaListModel.setAll((Object[])this.generateSeasonlTotalPowerStrings());
            this.m_monthSeasonLabel.setText(this.m_labelFormat.format(new String[]{"season"}));
        }
        int n = this.m_requirementSpecifiedCombo.getItemCount() >= 0 ? 0 : -1;
        this.m_requirementSpecifiedCombo.setSelectedIndex(n);
    }

    public void buttonCmdActionPerformed(ActionEvent actionEvent) {
        int n = actionEvent.getID();
        if (n == 8) {
            this.saveAndClose();
            return;
        }
        if (n == 4) {
            this.closeAndCancel();
        }
    }

    protected void saveAndClose() {
        this.m_cancled = false;
        if (this.m_requirementVariesCombo.getSelectedItem() == a[0]) {
            this.m_hydropowerRule.setRequirementVariation(0);
        } else {
            this.m_hydropowerRule.setRequirementVariation(1);
        }
        int n = 1;
        Object object = this.m_requirementSpecifiedCombo.getSelectedItem();
        if (object == "Monthly Total MWH") {
            n = 13;
        } else if (object == "Season Total MWH") {
            n = 14;
        } else if (object == "Plant Factor - Monthly Total" || object == "Plant Factor - Season Total") {
            n = 10;
        } else if (object == b[0]) {
            n = 11;
        } else if (object == b[1]) {
            n = 12;
        }
        this.m_hydropowerRule.setPowerReqSpecification(n);
        this.m_hydropowerRule.setStartingDay(DaysOfWeek.a((String)this.m_startingDayCombo.getSelectedItem()));
        this.m_hydropowerRule.setDayBelongsToTerm(DaysOfWeek.a((String)this.m_weekCombo.getSelectedItem()));
        this.m_hydropowerRule.setStartDayOfPeriod(DaysOfWeek.a((String)this.m_startingPeriodCombo.getSelectedItem()));
        object = this.m_periodCombo.getSelectedItem();
        n = 0;
        if (object == c[0]) {
            n = 0;
        } else if (object == c[1]) {
            n = 1;
        } else if (object == c[2]) {
            n = 2;
        }
        this.m_hydropowerRule.setGenerationPeriod(n);
        this.setVisible(false);
    }

    protected void closeAndCancel() {
        this.m_cancled = true;
        this.setVisible(false);
    }

    public boolean isCanceled() {
        return this.m_cancled;
    }

    public void setHydropowerRule(PowerGenerationOptions powerGenerationOptions) {
        this.m_hydropowerRule = powerGenerationOptions;
    }

    public void fillPanel() {
        if (this.m_hydropowerRule == null) {
            return;
        }
        if (this.m_hydropowerRule.getRequirementVariation() == 0) {
            this.m_requirementVariesCombo.setSelectedItem((Object)a[0]);
        } else {
            this.m_requirementVariesCombo.setSelectedItem((Object)a[1]);
        }
        int n = this.m_hydropowerRule.getPowerReqSpecification();
        switch (n) {
            case 10: {
                if (this.m_hydropowerRule.getRequirementVariation() == 0) {
                    this.m_requirementSpecifiedCombo.setSelectedItem((Object)"Plant Factor - Monthly Total");
                    break;
                }
                this.m_requirementSpecifiedCombo.setSelectedItem((Object)"Plant Factor - Season Total");
                break;
            }
            case 11: {
                this.m_requirementSpecifiedCombo.setSelectedItem((Object)b[0]);
                break;
            }
            case 12: {
                this.m_requirementSpecifiedCombo.setSelectedItem((Object)b[1]);
                break;
            }
            case 13: {
                this.m_requirementSpecifiedCombo.setSelectedItem((Object)"Monthly Total MWH");
                break;
            }
            case 14: {
                this.m_requirementSpecifiedCombo.setSelectedItem((Object)"Season Total MWH");
                break;
            }
            default: {
                this.m_requirementSpecifiedCombo.setSelectedIndex(0);
            }
        }
        n = this.m_hydropowerRule.getGenerationPeriod();
        switch (n) {
            case 0: {
                this.m_periodCombo.setSelectedItem((Object)c[0]);
                break;
            }
            case 1: {
                this.m_periodCombo.setSelectedItem((Object)c[1]);
                break;
            }
            case 2: {
                this.m_periodCombo.setSelectedItem((Object)c[2]);
                break;
            }
            default: {
                this.m_periodCombo.setSelectedIndex(0);
            }
        }
        this.m_startingDayCombo.setSelectedItem((Object)DaysOfWeek.c(this.m_hydropowerRule.getStartingDay()));
        this.m_weekCombo.setSelectedItem((Object)DaysOfWeek.c(this.m_hydropowerRule.getDayBelongsToTerm()));
        this.m_startingPeriodCombo.setSelectedItem((Object)DaysOfWeek.c(this.m_hydropowerRule.getStartDayOfPeriod()));
        this.m_hydropowerRule.setGenerationPeriod(n);
    }

    private void PeriodCombo_ActionPerfomred() {
        String string = (String)this.m_periodCombo.getSelectedItem();
        boolean bl = string != null && string.indexOf("Weekly") >= 0;
        this.m_startingPeriodCombo.setEnabled(bl);
    }

    private String[] generateMonthlyTotalPowerStrings() {
        String[] stringArray = new String[b.length + 2];
        String[] stringArray2 = stringArray;
        stringArray[0] = "Plant Factor - Monthly Total";
        System.arraycopy(b, 0, stringArray2, 1, b.length);
        stringArray2[stringArray2.length - 1] = "Monthly Total MWH";
        return stringArray2;
    }

    private String[] generateSeasonlTotalPowerStrings() {
        String[] stringArray = new String[b.length + 2];
        String[] stringArray2 = stringArray;
        stringArray[0] = "Plant Factor - Season Total";
        System.arraycopy(b, 0, stringArray2, 1, b.length);
        stringArray2[stringArray2.length - 1] = "Season Total MWH";
        return stringArray2;
    }

    public static void a(String[] object) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
        }
        object = new PowerGenerationReqDlg();
        object.setLocation(200, 200);
        object.pack();
        object.setVisible(true);
    }
}

