/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.rss.model.SystemPwrGenerationPattern;
import java.util.Arrays;
import rma.swing.table.AbstractRmaTableModel;
import rma.util.RMAConst;
import rma.util.RMAIO;

public class PowerTableModel
extends AbstractRmaTableModel {
    public static final int EACH_DAY_VIEW = 8;
    public static final int WEEK_DAY_VIEW = 3;
    public static final int ALL_WEEK_VIEW = 2;
    private static final String[] a = new String[]{"S", "M", "T", "W", "T", "F", "S"};
    private static final String[] b = new String[]{"Weekdays", "Weekend"};
    private static final String[] c = new String[]{"Everyday"};
    private static final String[] d = new String[]{"0000-0100", "0100-0200", "0200-0300", "0300-0400", "0400-0500", "0500-0600", "0600-0700", "0700-0800", "0800-0900", "0900-1000", "1000-1100", "1100-1200", "1200-1300", "1300-1400", "1400-1500", "1500-1600", "1600-1700", "1700-1800", "1800-1900", "1900-2000", "2000-2100", "2100-2200", "2200-2300", "2300-2400"};
    private int m_view = 2;
    private SystemPwrGenerationPattern m_pwrGenPattern = null;
    private double[][] m_pattern = new double[7][d.length];

    public PowerTableModel() {
        for (int i = 0; i < this.m_pattern.length; ++i) {
            Arrays.fill(this.m_pattern[i], 1.0);
        }
    }

    public int getRowCount() {
        return d.length;
    }

    public int getColumnCount() {
        return this.m_view;
    }

    public boolean isCellEditable(int n, int n2) {
        return n2 != 0;
    }

    public Object getValueAt(int n, int n2) {
        if (n < 0 || n >= d.length) {
            return null;
        }
        if (n2 == 0) {
            return d[n];
        }
        if (n2 - 1 < 0 || n2 - 1 >= this.m_pattern.length) {
            return null;
        }
        double d = this.m_pattern[n2 - 1][n];
        if (RMAConst.isUndefinedValue((double)d)) {
            return null;
        }
        return d;
    }

    public void setValueAt(Object object, int n, int n2) {
        if (n2 == 0) {
            return;
        }
        if (n < 0 || n >= d.length) {
            return;
        }
        if (n2 - 1 < 0 || n2 - 1 >= this.m_pattern.length) {
            return;
        }
        this.m_pattern[n2 - 1][n] = RMAIO.parseDouble((Object)object);
    }

    public String getColumnName(int n) {
        if (n == 0) {
            return " ";
        }
        switch (this.m_view) {
            case 3: {
                return b[n - 1];
            }
            case 8: {
                return a[n - 1];
            }
            case 2: {
                return c[n - 1];
            }
        }
        return " ";
    }

    public void setTableView(int n) {
        if (n != 3 && n != 8 && n != 2) {
            return;
        }
        this.m_view = n;
        super.fireTableStructureChanged();
    }

    public void setData(SystemPwrGenerationPattern systemPwrGenerationPattern) {
        this.m_pwrGenPattern = systemPwrGenerationPattern;
        int n = this.m_pwrGenPattern.getPwrGenPatternType();
        switch (n) {
            case 1: {
                this.m_view = 2;
                break;
            }
            case 7: {
                this.m_view = 8;
                break;
            }
            case 2: {
                this.m_view = 3;
            }
        }
        double[][] dArray = this.m_pwrGenPattern.getPwrGenPattern();
        for (int i = 0; i < this.m_pattern.length; ++i) {
            if (i < dArray.length) {
                System.arraycopy(dArray[i], 0, this.m_pattern[i], 0, dArray[i].length);
                continue;
            }
            Arrays.fill(this.m_pattern[i], 1.0);
        }
        super.fireTableStructureChanged();
    }

    public void commitData() {
        int n = 0;
        switch (this.m_view) {
            case 3: {
                n = 2;
                break;
            }
            case 8: {
                n = 7;
                break;
            }
            case 2: {
                n = 1;
            }
        }
        this.m_pwrGenPattern.setPwrGenPatternType(n);
        double[][] dArray = this.m_pwrGenPattern.getPwrGenPattern();
        for (int i = 0; i < dArray.length && i < this.m_pattern.length; ++i) {
            System.arraycopy(this.m_pattern[i], 0, dArray[i], 0, dArray[i].length);
        }
    }

    public Class getColumnClass(int n) {
        if (n == 0) {
            return this.getValueAt(0, 0).getClass();
        }
        return Double.class;
    }
}

