/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.client.LookAndFeel;
import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.rss.client.PulseRoutingOptionsDialog$1;
import hec.rss.client.PulseRoutingOptionsDialog$PulseFlowTableModel;
import hec.rss.client.PulseRoutingOptionsRecord;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.table.TableModel;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.MlLabel;
import rma.swing.RmaInsets;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJDialog;
import rma.swing.RmaJLabel;
import rma.swing.RmaJTable;
import rma.swing.event.ReflectMultiListener;
import rma.swing.table.RmaTableModel;
import rma.util.RMAConst;

public class PulseRoutingOptionsDialog
extends RmaJDialog {
    private RmaJTable _table;
    private PulseRoutingOptionsDialog$PulseFlowTableModel _pulseFlowTableModel;
    private ButtonCmdPanel _cmdPanel;
    RmaJDecimalField _defaultPulseFlow_df;
    private boolean _isCanceled;
    private Vector _dataRecords = new Vector(0);
    private Vector _listenerList = new Vector();
    private ReflectMultiListener _listener = new ReflectMultiListener();

    public PulseRoutingOptionsDialog() {
    }

    public PulseRoutingOptionsDialog(Dialog dialog, boolean bl) {
        super(dialog, bl);
        this.buildControls();
    }

    void buildControls() {
        this.setTitle("Pulse Routing Options");
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new GridBagLayout());
        this.setSize(360, 380);
        this.setLocation();
        Object object = new JPanel(new GridBagLayout());
        Object object2 = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        ((GridBagConstraints)object2).gridy = 0;
        ((GridBagConstraints)object2).weightx = 0.0;
        ((GridBagConstraints)object2).weighty = 0.0;
        ((GridBagConstraints)object2).anchor = 18;
        ((GridBagConstraints)object2).fill = 0;
        ((GridBagConstraints)object2).insets = new Insets(10, 10, 10, 10);
        this.getContentPane().add((Component)object, object2);
        MlLabel mlLabel = new MlLabel();
        mlLabel.setHorizontalAlignment(2);
        object2 = "ResSim uses a pulse flow from each reservoir\nrelease point to evalulate lag and attenuation\nassociated with channel routing.  Set the pulse\nflow to value(s)  representative of the river system.\n";
        mlLabel.setText((String)object2);
        object2 = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        ((GridBagConstraints)object2).gridy = 0;
        ((GridBagConstraints)object2).weightx = 0.0;
        ((GridBagConstraints)object2).weighty = 0.0;
        ((GridBagConstraints)object2).insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        ((GridBagConstraints)object2).anchor = 18;
        ((GridBagConstraints)object2).fill = 0;
        ((Container)object).add((Component)mlLabel, object2);
        object = new JSeparator();
        ((JSeparator)object).setOrientation(0);
        object2 = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        ((GridBagConstraints)object2).gridy = 1;
        ((GridBagConstraints)object2).weightx = 1.0;
        ((GridBagConstraints)object2).anchor = 17;
        ((GridBagConstraints)object2).fill = 2;
        ((GridBagConstraints)object2).insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        this.getContentPane().add((Component)object, object2);
        object = new JPanel(new GridBagLayout());
        object2 = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        ((GridBagConstraints)object2).gridy = 2;
        ((GridBagConstraints)object2).weightx = 1.0;
        ((GridBagConstraints)object2).anchor = 18;
        ((GridBagConstraints)object2).fill = 2;
        ((GridBagConstraints)object2).insets = RmaInsets.insets((int)10, (int)5, (int)5, (int)5);
        this.getContentPane().add((Component)object, object2);
        mlLabel = new RmaJLabel("Default Pulse Flow (%S)");
        object2 = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        ((GridBagConstraints)object2).gridy = 0;
        ((GridBagConstraints)object2).weightx = 0.0;
        ((GridBagConstraints)object2).anchor = 17;
        ((GridBagConstraints)object2).fill = 0;
        ((GridBagConstraints)object2).insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        ((Container)object).add((Component)mlLabel, object2);
        this._defaultPulseFlow_df = new RmaJDecimalField();
        this._defaultPulseFlow_df.setEditable(true);
        this._defaultPulseFlow_df.setModifiable(true);
        object2 = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        ((GridBagConstraints)object2).gridy = 0;
        ((GridBagConstraints)object2).weightx = 1.0;
        ((GridBagConstraints)object2).anchor = 18;
        ((GridBagConstraints)object2).fill = 2;
        ((GridBagConstraints)object2).insets = RmaInsets.insets((int)0, (int)10, (int)0, (int)10);
        ((Container)object).add((Component)this._defaultPulseFlow_df, object2);
        mlLabel.setLabelFor((Component)this._defaultPulseFlow_df);
        this._pulseFlowTableModel = new PulseRoutingOptionsDialog$PulseFlowTableModel(this, new String[]{"Reservoir", "Release\nLocation", "Use\nDefault", "Pulse Flow\n(%S)"}, new boolean[]{false, false, true, true});
        this._table = new RmaJTable((Component)((Object)this));
        this._table.setModel((TableModel)((Object)this._pulseFlowTableModel));
        this._table.setMlHeaderRenderer();
        this._table.setUnitsHeaderRenderer();
        this._table.setColumnSelectionAllowed(false);
        this._table.setRowSelectionAllowed(false);
        this._table.setAddRemoveEnabled(false);
        this._table.setCheckBoxCellEditor(2);
        this._table.setDoubleCellEditor(3);
        object = new int[]{120, 120, 60, 80};
        this._table.setColumnWidths((int[])object);
        object2 = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        ((GridBagConstraints)object2).gridy = 3;
        ((GridBagConstraints)object2).weightx = 1.0;
        ((GridBagConstraints)object2).weighty = 1.0;
        ((GridBagConstraints)object2).fill = 1;
        ((GridBagConstraints)object2).insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this._table.getScrollPane(), object2);
        this._cmdPanel = new ButtonCmdPanel(12);
        object2 = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        ((GridBagConstraints)object2).gridy = 4;
        ((GridBagConstraints)object2).weightx = 1.0;
        ((GridBagConstraints)object2).weighty = 0.0;
        ((GridBagConstraints)object2).anchor = 16;
        ((GridBagConstraints)object2).insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        ((GridBagConstraints)object2).fill = 2;
        this.getContentPane().add((Component)this._cmdPanel, object2);
        this._cmdPanel.addCmdPanelListener((ButtonCmdPanelListener)new PulseRoutingOptionsDialog$1(this));
    }

    public void fillForm(List list, ParamDouble object) {
        int n;
        this._table.commitEdit(true);
        this._table.clearCells();
        this._table.setNumRows(0);
        Object object2 = new int[]{-1, -1, -1, Parameter.PARAMID_FLOW};
        this._pulseFlowTableModel.setColumnParameters((int[])object2);
        new ParamDouble();
        this._defaultPulseFlow_df.setValue((ParamDouble)object);
        for (n = 0; n < list.size(); ++n) {
            object = new Vector(4);
            object2 = (PulseRoutingOptionsRecord)list.get(n);
            ((Vector)object).add(object2.reservoirName);
            ((Vector)object).add(object2.releaseOutletName);
            ((Vector)object).add(object2.useDefault);
            ((Vector)object).add(object2.pulseFlow_pd);
            this._table.appendRow((Vector)object);
        }
        int n2 = this._table.getRowCount();
        for (int i = 0; i < n2; ++i) {
            n = (Boolean)this._table.getValueAt(i, 2) == false ? 1 : 0;
            this._pulseFlowTableModel.setCellEnabled(n != 0, i, 3);
        }
        this.setModified(false);
    }

    public boolean saveForm() {
        this._table.commitEdit(true);
        Vector vector = ((RmaTableModel)this._table.getModel()).getDataVector();
        int n = vector.size();
        this._dataRecords = new Vector(n);
        for (int i = 0; i < n; ++i) {
            PulseRoutingOptionsRecord pulseRoutingOptionsRecord = new PulseRoutingOptionsRecord();
            Vector vector2 = (Vector)vector.get(i);
            for (int j = 0; j < 4; ++j) {
                pulseRoutingOptionsRecord.reservoirName = vector2.get(0).toString();
                pulseRoutingOptionsRecord.releaseOutletName = vector2.get(1).toString();
                Object e = vector2.get(2);
                if (e instanceof Boolean) {
                    pulseRoutingOptionsRecord.useDefault = (Boolean)e;
                }
                if (!((e = vector2.get(3)) instanceof ParamDouble)) continue;
                pulseRoutingOptionsRecord.pulseFlow_pd = (ParamDouble)e;
            }
            this._dataRecords.add(pulseRoutingOptionsRecord);
        }
        return true;
    }

    protected boolean isValidData() {
        Object object = this._defaultPulseFlow_df.getParamValue();
        if (object == null || !RMAConst.isValidValue((double)object.getValue()) || object.getValue() <= 0.001) {
            String string = "Default pulse flow value missing, or less than or equal to zero";
            JOptionPane.showMessageDialog((Component)((Object)this), string, "Incomplete Form", 1);
            return false;
        }
        this._table.commitEdit(true);
        Vector vector = ((RmaTableModel)this._table.getModel()).getDataVector();
        int n = vector.size();
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            Vector vector2 = (Vector)vector.get(i);
            object = vector2.get(2);
            if (!(object instanceof Boolean)) {
                bl = false;
                continue;
            }
            boolean bl2 = (Boolean)object;
            object = vector2.get(3);
            if (!(object instanceof ParamDouble)) {
                bl = false;
                continue;
            }
            double d = object.getValue();
            if (bl2 || RMAConst.isValidValue((double)d) && !(d < 0.001)) continue;
            object = "Incomplete Pulse Flow Options Data for: " + String.valueOf(vector2.get(0)) + "-" + String.valueOf(vector2.get(1)) + ".\nNo pulse flow value specified and \"Use Default\" is not checked";
            JOptionPane.showMessageDialog((Component)((Object)this), object, "Incomplete Form", 1);
            return false;
        }
        if (!bl) {
            String string = "Incomplete Pulse Flow Data";
            JOptionPane.showMessageDialog((Component)((Object)this), string, "Incomplete Form", 1);
        }
        return bl;
    }

    public Vector getDataRecords() {
        this.saveForm();
        return this._dataRecords;
    }

    public ParamDouble getDefaultPulseFlow() {
        return this._defaultPulseFlow_df.getParamValue();
    }

    void exportTable() {
        this._table.exportData();
    }

    void printTable() {
        this._table.printData();
    }

    void closeDialog() {
        this.setVisible(false);
    }

    public boolean isCanceled() {
        return this._isCanceled;
    }

    public static void a(String[] object) {
        try {
            LookAndFeel.setLookAndFeel();
        }
        catch (Exception exception) {}
        object = new PulseRoutingOptionsDialog(null, true);
        object.fillForm(null, null);
        object.setVisible(true);
        System.exit(0);
    }

    static {
        new Color(170, 170, 170);
        new Color(220, 220, 220);
    }
}

