/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.gui.NameDescriptionPanel;
import hec.model.SeasonalRecord;
import hec.model.SeasonalRecordTableModel;
import hec.rss.client.JOperationsPanel;
import hec.rss.client.PumpOpRulePanel$1;
import hec.rss.client.PumpOpRulePanel$2;
import hec.rss.client.PumpOpRulePanel$3;
import hec.rss.client.PumpOpRulePanel$4;
import hec.rss.client.PumpOpRulePanel$5;
import hec.rss.client.PumpOpRulePanel$ZoneOpSet;
import hec.rss.client.PumpingHourRangeTableModel;
import hec.rss.client.SunriseSunsetTableModel;
import hec.rss.model.OpRule;
import hec.rss.model.OpRuleRef;
import hec.rss.model.OpSet;
import hec.rss.model.PumpOpRule;
import hec.rss.model.ReservoirElement;
import hec.rss.model.StorageZone;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import rma.swing.DefaultJPanel;
import rma.swing.RmaGridBagConstraints;
import rma.swing.RmaInsets;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJIntegerField;
import rma.swing.RmaJLabel;
import rma.swing.RmaJTable;
import rma.swing.list.RmaListModel;
import rma.swing.table.RmaCellEditor;
import rma.util.RMAIO;

public class PumpOpRulePanel
extends DefaultJPanel
implements FocusListener {
    private static final String[] a = new String[]{"Beginning of Period", "Middle of Period", "End of Period"};
    private static final String[] b = new String[]{"Use full pump capacity", "Use entire pump period"};
    private static final String[] c = new String[]{"Constant", "Storage Zone", "Seasonally Varying"};
    private static final String[] d = new String[]{"Fixed Hour Range", "Between Sunset and Sunrise"};
    public static final String MINPUMPING_OPTSTR_NONE = "No Required Min";
    public static final String MINPUMPING_OPTSTR_ALWAYS = "At Least Min";
    public static final String MINPUMPING_OPTSTR_IFPUMP = "At Least Min if blw Target";
    public static final String MINPUMPING_OPTSTR_THRESHOLD = "Only if Req'd >= Min";
    private static final String[] e = new String[]{"No Required Min", "At Least Min", "At Least Min if blw Target", "Only if Req'd >= Min"};
    OpRuleRef m_currentRuleRef = null;
    JOperationsPanel m_parent = null;
    String m_oldRuleName = "";
    NameDescriptionPanel m_namePanel;
    private JLabel _reservoirLabel = new JLabel("Source Reservoir:");
    private RmaJComboBox _reservoirCombo = new RmaJComboBox();
    RmaJComboBox m_pumpingStrategyCombo = new RmaJComboBox((ComboBoxModel)new RmaListModel(false, (Object[])b));
    RmaJComboBox m_pumpingBiasCombo = new RmaJComboBox((ComboBoxModel)new RmaListModel(false, (Object[])a));
    RmaJCheckBox _wholeHourCheckbox = new RmaJCheckBox("Whole Hour Pumping Option");
    RmaJComboBox _minPumpingCombo = new RmaJComboBox((ComboBoxModel)new RmaListModel(false, (Object[])e));
    RmaJDecimalField _minPumpingTxt;
    JPanel m_targetFillCardPanel;
    RmaJComboBox m_targetFillOptionCombo;
    RmaJTable m_seasonalTable;
    RmaJDecimalField m_targetElevationTxt;
    RmaJComboBox m_targetZoneCombo;
    RmaJComboBox m_dailyPumpingOptionCombo;
    JPanel m_dailyPumpingCardPanel;
    RmaJTable m_fixedHourTable;
    RmaJTable m_sunriseTable;
    RmaJDecimalField m_latitudeTxt;
    RmaJDecimalField m_longitudeTxt;

    public PumpOpRulePanel() {
        this.buildControls();
    }

    private void buildControls() {
        this.setLayout(new GridBagLayout());
        Object object = new RmaGridBagConstraints();
        this.m_namePanel = new NameDescriptionPanel(8L);
        object.set(0, 0, 2, 1, 1.0, 0.0, 18, 2, RmaInsets.INSETS5505, 0, 0);
        PumpOpRulePanel pumpOpRulePanel = this;
        pumpOpRulePanel.add((Component)pumpOpRulePanel.m_namePanel, object);
        this.m_namePanel.addNameFocusListener((FocusListener)this);
        this.m_namePanel.setNameLabel("Pump Rule:");
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder("Target Fill Elevation"));
        object.set(0, 1, 1, 1, 1.0, 1.0, 12, 1, RmaInsets.INSETS5500, 0, 0);
        this.add(jPanel, object);
        Object object2 = new JLabel("Option");
        object.set(0, 0, 1, 1, 0.0, 0.0, 18, 0, RmaInsets.INSETS0500, 0, 0);
        jPanel.add((Component)object2, object);
        this.m_targetFillOptionCombo = new RmaJComboBox((ComboBoxModel)new RmaListModel(false, (Object[])c));
        this.m_targetFillOptionCombo.setSelectedIndex(0);
        this.m_targetFillOptionCombo.setModifiable(true);
        object.set(1, 0, 1, 1, 1.0, 0.0, 18, 2, RmaInsets.INSETS0505, 0, 0);
        jPanel.add((Component)this.m_targetFillOptionCombo, object);
        object2 = new JSeparator();
        object.set(0, 1, 2, 1, 1.0, 0.0, 18, 2, RmaInsets.INSETS5505, 0, 0);
        jPanel.add((Component)object2, object);
        this.m_targetFillCardPanel = new JPanel(new CardLayout());
        object.set(0, 2, 2, 1, 1.0, 1.0, 18, 1, RmaInsets.INSETS5555, 0, 0);
        jPanel.add((Component)this.m_targetFillCardPanel, object);
        object2 = new JLabel("Zone");
        jPanel = new JPanel(new GridBagLayout());
        object.set(0, 0, 1, 1, 0.0, 1.0, 18, 0, RmaInsets.INSETS0000, 0, 0);
        jPanel.add((Component)object2, object);
        this.m_targetZoneCombo = new RmaJComboBox();
        this.m_targetZoneCombo.setModifiable(true);
        object.set(1, 0, 1, 1, 1.0, 1.0, 18, 2, RmaInsets.INSETS0500, 0, 0);
        jPanel.add((Component)this.m_targetZoneCombo, object);
        this.m_targetFillCardPanel.add("Storage Zone", jPanel);
        jPanel = new JPanel(new GridBagLayout());
        object2 = new RmaJLabel("Target Elevation (%S)");
        object.set(0, 0, 1, 1, 0.0, 1.0, 18, 0, RmaInsets.INSETS0000, 0, 0);
        jPanel.add((Component)object2, object);
        this.m_targetElevationTxt = new RmaJDecimalField();
        this.m_targetElevationTxt.setPrecision(2);
        object.set(1, 0, 1, 1, 1.0, 1.0, 18, 2, RmaInsets.INSETS0500, 0, 0);
        jPanel.add((Component)this.m_targetElevationTxt, object);
        this.m_targetElevationTxt.setValue(new ParamDouble(Double.NEGATIVE_INFINITY, Parameter.PARAMID_ELEV, 1));
        object2.setLabelFor((Component)this.m_targetElevationTxt);
        this.m_targetFillCardPanel.add("Constant", jPanel);
        this.m_seasonalTable = new RmaJTable((Component)((Object)this));
        object2 = new PumpOpRulePanel$1(this);
        object2.setColumnNames(new String[]{"Date", "Elevation(%S)"});
        object2.setSeasonalRecord(new SeasonalRecord(), "01Jan");
        this.m_seasonalTable.setModel((TableModel)object2);
        this.m_seasonalTable.setDateCellEditor(0, "DDMMM", true);
        this.m_seasonalTable.setDoubleCellEditor(1, true);
        this.m_seasonalTable.setUnitsHeaderRenderer();
        this.m_seasonalTable.setCellEnabled(false, 0, 0);
        this.m_seasonalTable.setNumRows(10);
        this.m_seasonalTable.setAddRemoveEnabled(true);
        this.m_targetFillCardPanel.add("Seasonally Varying", new JScrollPane((Component)this.m_seasonalTable));
        this.m_targetFillOptionCombo.setSelectedItem((Object)"Constant");
        ((CardLayout)this.m_targetFillCardPanel.getLayout()).show(this.m_targetFillCardPanel, "Constant");
        this.m_targetFillOptionCombo.addActionListener((ActionListener)new PumpOpRulePanel$2(this));
        jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder("Daily Pumping Period"));
        object.set(1, 1, 1, 1, 1.0, 1.0, 12, 1, RmaInsets.INSETS5505, 0, 0);
        this.add(jPanel, object);
        object2 = new JLabel("Option");
        object.set(0, 0, 1, 1, 0.0, 0.0, 18, 0, RmaInsets.INSETS0500, 0, 0);
        jPanel.add((Component)object2, object);
        this.m_dailyPumpingOptionCombo = new RmaJComboBox((ComboBoxModel)new RmaListModel(false, (Object[])d));
        this.m_dailyPumpingOptionCombo.setModifiable(true);
        object.set(1, 0, 1, 1, 1.0, 0.0, 18, 2, RmaInsets.INSETS0505, 0, 0);
        jPanel.add((Component)this.m_dailyPumpingOptionCombo, object);
        object2 = new JSeparator();
        object.set(0, 1, 2, 1, 1.0, 0.0, 18, 2, RmaInsets.INSETS5505, 0, 0);
        jPanel.add((Component)object2, object);
        this.m_dailyPumpingCardPanel = new JPanel(new CardLayout());
        object.set(0, 2, 2, 1, 1.0, 1.0, 18, 1, RmaInsets.INSETS5555, 0, 0);
        jPanel.add((Component)this.m_dailyPumpingCardPanel, object);
        this.m_fixedHourTable = new RmaJTable((Component)((Object)this));
        this.m_fixedHourTable.setModel((TableModel)((Object)new PumpingHourRangeTableModel()));
        this.m_fixedHourTable.setDateCellEditor(0, "DDMMM", true);
        this.m_fixedHourTable.setTimeCellEditor(1);
        this.m_fixedHourTable.setTimeCellEditor(2);
        this.m_fixedHourTable.getColumnModel().getColumn(3).setCellEditor((TableCellEditor)new RmaCellEditor(new RmaJIntegerField()));
        this.m_fixedHourTable.setNumRows(10);
        this.m_dailyPumpingCardPanel.add("Fixed Hour Range", new JScrollPane((Component)this.m_fixedHourTable));
        jPanel = new JPanel(new GridBagLayout());
        this.m_dailyPumpingCardPanel.add("Between Sunset and Sunrise", jPanel);
        this.m_sunriseTable = new RmaJTable((Component)((Object)this));
        this.m_sunriseTable.setModel((TableModel)((Object)new SunriseSunsetTableModel()));
        this.m_sunriseTable.setDateCellEditor(0, "DDMMM", true);
        this.m_sunriseTable.setDoubleCellEditor(1, true);
        this.m_sunriseTable.setDoubleCellEditor(2, true);
        this.m_sunriseTable.getColumnModel().getColumn(3).setCellEditor((TableCellEditor)new RmaCellEditor(new RmaJIntegerField()));
        this.m_sunriseTable.setHorizontalAlignment(4, 3);
        object.set(0, 0, 2, 1, 1.0, 1.0, 18, 1, RmaInsets.INSETS0000, 0, 0);
        jPanel.add((Component)new JScrollPane((Component)this.m_sunriseTable), object);
        object2 = new JLabel("Latitude");
        object.set(0, 1, 1, 1, 0.0, 0.0, 16, 0, RmaInsets.INSETS0000, 0, 0);
        jPanel.add((Component)object2, object);
        this.m_latitudeTxt = new RmaJDecimalField();
        object.set(1, 1, 1, 1, 1.0, 0.0, 16, 2, RmaInsets.INSETS5500, 0, 0);
        jPanel.add((Component)this.m_latitudeTxt, object);
        ((CardLayout)this.m_dailyPumpingCardPanel.getLayout()).show(this.m_dailyPumpingCardPanel, "Fixed Hour Range");
        this.m_dailyPumpingOptionCombo.setSelectedIndex(0);
        this.m_dailyPumpingOptionCombo.addActionListener((ActionListener)new PumpOpRulePanel$3(this));
        object2 = new JLabel("Longitude");
        object.set(0, 2, 1, 1, 0.0, 0.0, 16, 0, RmaInsets.INSETS0000, 0, 0);
        jPanel.add((Component)object2, object);
        this.m_longitudeTxt = new RmaJDecimalField();
        object.set(1, 2, 1, 1, 1.0, 0.0, 16, 2, RmaInsets.INSETS5500, 0, 0);
        jPanel.add((Component)this.m_longitudeTxt, object);
        jPanel = new JPanel(new GridBagLayout());
        object.set(0, 2, 2, 1, 1.0, 0.0, 16, 2, RmaInsets.INSETS0000, 0, 0);
        this.add(jPanel, object);
        object2 = new JLabel("Pumping Strategy");
        object.set(0, 0, 1, 1, 0.0, 0.0, 18, 0, RmaInsets.INSETS5500, 0, 0);
        jPanel.add((Component)object2, object);
        object.set(1, 0, 1, 1, 1.0, 0.0, 18, 2, RmaInsets.INSETS5500, 0, 0);
        jPanel.add((Component)this.m_pumpingStrategyCombo, object);
        this.m_pumpingStrategyCombo.setSelectedIndex(0);
        this.m_pumpingStrategyCombo.setModifiable(true);
        object2 = new JLabel("Pumping Bias");
        object.set(2, 0, 1, 1, 0.0, 0.0, 18, 0, RmaInsets.INSETS5500, 0, 0);
        jPanel.add((Component)object2, object);
        object.set(3, 0, 1, 1, 1.0, 0.0, 18, 2, RmaInsets.INSETS5500, 0, 0);
        jPanel.add((Component)this.m_pumpingBiasCombo, object);
        this.m_pumpingBiasCombo.setSelectedIndex(0);
        this.m_pumpingBiasCombo.setModifiable(true);
        object.set(2, 1, 2, 1, 0.0, 0.0, 18, 0, RmaInsets.INSETS5500, 0, 0);
        jPanel.add((Component)this._wholeHourCheckbox, object);
        object2 = new JLabel("Minimum Pumping");
        object.set(0, 2, 1, 1, 0.0, 0.0, 18, 0, RmaInsets.INSETS5500, 0, 0);
        jPanel.add((Component)object2, object);
        object.set(1, 2, 1, 1, 1.0, 0.0, 18, 2, RmaInsets.INSETS5500, 0, 0);
        jPanel.add((Component)this._minPumpingCombo, object);
        this._minPumpingCombo.setSelectedIndex(0);
        this._minPumpingCombo.setModifiable(true);
        object2 = new JLabel("Min. Pump Unit Hrs");
        object.set(2, 2, 1, 1, 0.0, 0.0, 18, 0, RmaInsets.INSETS5500, 0, 0);
        jPanel.add((Component)object2, object);
        this._minPumpingTxt = new RmaJDecimalField();
        object.set(3, 2, 1, 1, 1.0, 0.0, 18, 2, RmaInsets.INSETS5500, 0, 0);
        jPanel.add((Component)this._minPumpingTxt, object);
        this.m_pumpingStrategyCombo.addActionListener((ActionListener)new PumpOpRulePanel$4(this));
        this._minPumpingCombo.addActionListener((ActionListener)new PumpOpRulePanel$5(this));
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        object.gridy = 1;
        object.gridwidth = 1;
        object.anchor = 18;
        object.fill = 0;
        object.insets = RmaInsets.INSETS5550;
        jPanel.add((Component)this._reservoirLabel, object);
        this._reservoirCombo.setModifiable(true);
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        object.gridy = 1;
        object.gridwidth = 1;
        object.weightx = 1.0;
        object.weighty = 0.0;
        object.anchor = 18;
        object.fill = 2;
        object.insets = RmaInsets.INSETS5550;
        jPanel.add((Component)this._reservoirCombo, object);
    }

    public void setDownstreamReservoirComboModel(Vector vector) {
        Vector vector2 = new Vector();
        for (int i = 0; i < vector.size(); ++i) {
            Object e = vector.get(i);
            if (!(e instanceof ReservoirElement)) continue;
            vector2.add(e);
        }
        this._reservoirCombo.removeItemListener((ItemListener)((Object)this));
        this._reservoirCombo.setModel(new DefaultComboBoxModel(vector2));
        this._reservoirCombo.addItemListener((ItemListener)((Object)this));
    }

    public void setParent(JPanel jPanel) {
        this.m_parent = (JOperationsPanel)((Object)jPanel);
    }

    public void setRuleRef(OpRuleRef vector) {
        if (vector == null) {
            return;
        }
        Object object = ((OpRuleRef)((Object)vector)).getRule();
        if (!(object instanceof PumpOpRule)) {
            return;
        }
        this.m_currentRuleRef = vector;
        vector = (PumpOpRule)object;
        vector = ((OpRule)((Object)vector)).getOperationsElement().getElementOp();
        vector = vector.getOperationSets();
        object = new Vector();
        for (int i = 0; vector != null && i < vector.size(); ++i) {
            OpSet opSet = (OpSet)vector.get(i);
            if (opSet == null) continue;
            Vector vector2 = opSet.getZoneVector();
            for (int j = 0; vector2 != null && j < vector2.size(); ++j) {
                StorageZone storageZone = (StorageZone)vector2.get(j);
                if (storageZone == null) continue;
                object.add(new PumpOpRulePanel$ZoneOpSet(this, opSet, storageZone));
            }
        }
        this.m_targetZoneCombo.setModel((ComboBoxModel)new RmaListModel(false, (Collection)object));
        this.fillPanel();
    }

    public void fillPanel() {
        int n;
        int n2;
        PumpOpRule pumpOpRule = (PumpOpRule)this.m_currentRuleRef.getRule();
        this.m_namePanel.setName(pumpOpRule.getName());
        this.m_namePanel.setDescription(pumpOpRule.getDescription());
        this.m_oldRuleName = pumpOpRule.getName();
        int n3 = pumpOpRule.getPumpingStrategy();
        switch (n3) {
            case 0: {
                this.m_pumpingStrategyCombo.setSelectedItem((Object)"Use full pump capacity");
                break;
            }
            case 1: {
                this.m_pumpingStrategyCombo.setSelectedItem((Object)"Use entire pump period");
            }
        }
        n3 = pumpOpRule.getPumpingBias();
        switch (n3) {
            case 1: {
                this.m_pumpingBiasCombo.setSelectedItem((Object)"Beginning of Period");
                break;
            }
            case 2: {
                this.m_pumpingBiasCombo.setSelectedItem((Object)"Middle of Period");
                break;
            }
            case 3: {
                this.m_pumpingBiasCombo.setSelectedItem((Object)"End of Period");
            }
        }
        this._wholeHourCheckbox.setSelected(pumpOpRule.isWholeHourOption());
        n3 = pumpOpRule.getTargetElevationOption();
        switch (n3) {
            case 0: {
                this.m_targetFillOptionCombo.setSelectedItem((Object)"Constant");
                break;
            }
            case 2: {
                this.m_targetFillOptionCombo.setSelectedItem((Object)"Seasonally Varying");
                break;
            }
            case 1: {
                this.m_targetFillOptionCombo.setSelectedItem((Object)"Storage Zone");
            }
        }
        n3 = pumpOpRule.getDailyPumpingOption();
        switch (n3) {
            case 1: {
                this.m_dailyPumpingOptionCombo.setSelectedItem((Object)"Fixed Hour Range");
                break;
            }
            case 0: {
                this.m_dailyPumpingOptionCombo.setSelectedItem((Object)"Between Sunset and Sunrise");
            }
        }
        this.m_targetElevationTxt.setValue(new ParamDouble(pumpOpRule.getConstantTargetElevation(), Parameter.PARAMID_ELEV, pumpOpRule.getUnitSystem()));
        SeasonalRecord seasonalRecord = pumpOpRule.getSeasonalTargetElevation();
        ((SeasonalRecordTableModel)this.m_seasonalTable.getModel()).setSeasonalRecord(seasonalRecord, "01JAN");
        int n4 = pumpOpRule.getOpSetId();
        int n5 = pumpOpRule.getStorageZoneId();
        RmaListModel rmaListModel = (RmaListModel)this.m_targetZoneCombo.getModel();
        for (n2 = 0; n2 < rmaListModel.size(); ++n2) {
            PumpOpRulePanel$ZoneOpSet pumpOpRulePanel$ZoneOpSet = (PumpOpRulePanel$ZoneOpSet)rmaListModel.elementAt(n2);
            if (pumpOpRulePanel$ZoneOpSet.a.getIndex() != n4 || pumpOpRulePanel$ZoneOpSet.b.getIndex() != n5) continue;
            this.m_targetZoneCombo.setSelectedItem((Object)pumpOpRulePanel$ZoneOpSet);
            break;
        }
        this.m_latitudeTxt.setValue(pumpOpRule.getLatitude());
        this.m_longitudeTxt.setValue(pumpOpRule.getLongitude());
        ((SunriseSunsetTableModel)((Object)this.m_sunriseTable.getModel())).setData(pumpOpRule.getSuriseSunsetModel());
        ((PumpingHourRangeTableModel)((Object)this.m_fixedHourTable.getModel())).setData(pumpOpRule.getPumpingRangeModel());
        this._minPumpingCombo.setSelectedIndex(pumpOpRule.getMinPumpOption());
        this._minPumpingTxt.setValue(pumpOpRule.getMinPumpHours());
        n2 = pumpOpRule.getSourceReservoirId();
        if (n2 < 0) {
            this._reservoirCombo.setSelectedIndex(-1);
            return;
        }
        int n6 = this._reservoirCombo.getItemCount();
        for (n = 1; n < n6; ++n) {
            ReservoirElement reservoirElement = (ReservoirElement)this._reservoirCombo.getItemAt(n);
            if (reservoirElement.getIndex() != n2) continue;
            this._reservoirCombo.setSelectedIndex(n);
            break;
        }
        if (n == n6) {
            this._reservoirCombo.setSelectedIndex(0);
        }
    }

    public void deselectPanel() {
        if (this.isModified()) {
            this.savePanel();
        }
    }

    public boolean savePanel() {
        if (this.m_currentRuleRef == null) {
            return true;
        }
        PumpOpRule pumpOpRule = (PumpOpRule)this.m_currentRuleRef.getRule();
        pumpOpRule.setName(this.m_namePanel.getName());
        pumpOpRule.setDescription(this.m_namePanel.getDescription());
        this.m_oldRuleName = this.m_namePanel.getName();
        Object object = this.m_pumpingStrategyCombo.getSelectedItem();
        if (object == "Use full pump capacity") {
            pumpOpRule.setPumpingStrategy(0);
        } else {
            pumpOpRule.setPumpingStrategy(1);
        }
        object = this.m_pumpingBiasCombo.getSelectedItem();
        if (object == "Beginning of Period") {
            pumpOpRule.setPumpingBias(1);
        } else if (object == "Middle of Period") {
            pumpOpRule.setPumpingBias(2);
        } else {
            pumpOpRule.setPumpingBias(3);
        }
        pumpOpRule.setWholeHourOption(this._wholeHourCheckbox.isSelected());
        object = this.m_targetFillOptionCombo.getSelectedItem();
        if (object == "Constant") {
            pumpOpRule.setTargetElevationOption(0);
        } else if (object == "Seasonally Varying") {
            pumpOpRule.setTargetElevationOption(2);
        } else {
            pumpOpRule.setTargetElevationOption(1);
        }
        object = this.m_dailyPumpingOptionCombo.getSelectedItem();
        if (object == "Fixed Hour Range") {
            pumpOpRule.setDailyPumpingOption(1);
        } else {
            pumpOpRule.setDailyPumpingOption(0);
        }
        double d = RMAIO.parseDouble((ParamDouble)this.m_targetElevationTxt.getParamValue(), (double)Double.NEGATIVE_INFINITY);
        pumpOpRule.setConstantTargetElevation(d);
        object = new SeasonalRecord();
        this.m_seasonalTable.commitEdit(true);
        ((SeasonalRecordTableModel)this.m_seasonalTable.getModel()).storeData((SeasonalRecord)object);
        pumpOpRule.setSeasonalTargetElevation((SeasonalRecord)object);
        object = (PumpOpRulePanel$ZoneOpSet)this.m_targetZoneCombo.getSelectedItem();
        if (object != null) {
            pumpOpRule.setStorageZoneTargetElevation(((PumpOpRulePanel$ZoneOpSet)object).a, ((PumpOpRulePanel$ZoneOpSet)object).b);
        }
        pumpOpRule.setLatitude(this.m_latitudeTxt.getValue());
        pumpOpRule.setLongitude(this.m_longitudeTxt.getValue());
        this.m_sunriseTable.commitEdit(true);
        this.m_fixedHourTable.commitEdit(true);
        ((SunriseSunsetTableModel)((Object)this.m_sunriseTable.getModel())).commitData(pumpOpRule.getSuriseSunsetModel());
        ((PumpingHourRangeTableModel)((Object)this.m_fixedHourTable.getModel())).commitData(pumpOpRule.getPumpingRangeModel());
        object = this._reservoirCombo.getSelectedItem();
        if (object instanceof ReservoirElement) {
            pumpOpRule.setSourceReservoirId(((ReservoirElement)object).getIndex());
        } else {
            pumpOpRule.setSourceReservoirId(-1);
        }
        pumpOpRule.setMinPumpOption(this._minPumpingCombo.getSelectedIndex());
        pumpOpRule.setMinPumpHours(this._minPumpingTxt.getValue());
        pumpOpRule.setModified(true);
        return true;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (this.m_namePanel.getName().equals("")) {
            this.m_namePanel.setName(this.m_currentRuleRef.getRule().getName());
            RMAIO.postError((Component)((Object)this), (String)"Cannot have a blank Rule Name!");
            return;
        }
        this.m_currentRuleRef.getRule().setName(this.m_namePanel.getName());
        this.m_currentRuleRef.setName(this.m_namePanel.getName());
        this.m_parent.treeDataChanged(0, this.m_oldRuleName, this.m_namePanel.getName());
    }
}

