/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import com.google.common.flogger.FluentLogger;
import hec.client.NewWorkspaceSummaryDialog;
import hec.client.WatershedSummaryFormat;
import hec.clientapp.client.ClientApp;
import hec.clientapp.client.HecClientFrame;
import hec.clientapp.client.LoginInfo;
import hec.clientapp.model.DataListContainer;
import hec.clientapp.model.DefaultDataListContainer;
import hec.clientapp.model.SimulationPeriod;
import hec.clientapp.model.SimulationRun;
import hec.clientapp.model.StreamAlignment;
import hec.clientapp.model.TSDataSet;
import hec.clientapp.model.TSRecordImplFactory;
import hec.clientapp.rmi.csinterface.RmiDataListContainer;
import hec.dssgui.ListSelection;
import hec.heclib.dss.HecDataManager;
import hec.model.ClassNameMapper;
import hec.rss.client.HecRssProperties;
import hec.rss.client.NewWatershedDlg;
import hec.rss.client.RSS$1;
import hec.rss.client.RSS$2;
import hec.rss.client.RssFrame;
import hec.rss.client.UncaughtExceptionHandler;
import hec.rss.model.RssTSRecordImpl;
import hec.watershed.model.ModelAlt;
import hec.watershed.model.StreamAlignmentUnits;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Logger;
import rma.swing.DefaultJPanel;
import rma.util.RMAIO;

public class RSS
extends ClientApp {
    private static final FluentLogger a = FluentLogger.forEnclosingClass();
    private static long b;
    String _recentDirectory = null;

    public RSS(LoginInfo loginInfo) {
        super(loginInfo);
        if (loginInfo.serverURL != null) {
            String cfr_ignored_0 = loginInfo.serverURL;
        }
        try {
            this._recentDirectory = System.getProperty("user.dir");
            return;
        }
        catch (Exception exception) {
            this._recentDirectory = null;
            return;
        }
    }

    public static String getResSimVersion() {
        Properties properties = RMAIO.getAppVersionProperties(RSS.class);
        String string = "unknown";
        if (properties != null) {
            string = properties.getProperty("fullVersion");
        }
        return string;
    }

    public boolean newWorkspace() {
        StreamAlignmentUnits streamAlignmentUnits;
        String string;
        int n;
        int n2;
        String string2;
        String string3;
        String string4;
        int n3;
        NewWatershedDlg newWatershedDlg = new NewWatershedDlg((Frame)((Object)RSS.rssFrame()));
        newWatershedDlg.setTitle("Create New Watershed");
        newWatershedDlg.setIconImage(RSS.rssFrame().getIconImage());
        Vector vector = this.getWatershedLocations(true);
        newWatershedDlg.setWatershedLocations(vector);
        vector = _clientFrame.getWatershedDataAccessoryPanel();
        newWatershedDlg.addAccessoryPanel((DefaultJPanel)vector);
        WatershedSummaryFormat watershedSummaryFormat = new WatershedSummaryFormat();
        do {
            newWatershedDlg.setVisible(true);
            if (newWatershedDlg.isCanceled()) {
                return false;
            }
            string3 = newWatershedDlg.getName();
            string2 = newWatershedDlg.getDescription();
            string4 = newWatershedDlg.getTimeZoneText();
            n2 = newWatershedDlg.getUnitSystemId();
            n = newWatershedDlg.getGmtOffset();
            string = newWatershedDlg.getWatershedLocation();
            streamAlignmentUnits = newWatershedDlg.getStreamAlignmentUnits();
            String[] stringArray = new String[5];
            String[] stringArray2 = stringArray;
            stringArray[0] = string3;
            stringArray2[1] = string2;
            if (stringArray2[1] != null) {
                stringArray2[1] = string2.replaceAll("\n", "<br>");
            }
            stringArray2[2] = n2 == 1 ? "English" : "SI";
            stringArray2[3] = string4;
            stringArray2[4] = string + this._baseWkspDirectory + "/" + RMAIO.userNameToFileName((String)string3);
            string4 = new NewWorkspaceSummaryDialog((Frame)_clientFrame, null, true);
            string4.setSize(475, 350);
            string4.setLocationRelativeTo((Component)_clientFrame.getMapPanel());
            string4.setText(watershedSummaryFormat.format((Object)stringArray2));
            string4.setVisible(true);
        } while ((n3 = string4.getResults()) == 2);
        if (n3 == 1) {
            return false;
        }
        if (_Workspace != null && !_Workspace.checkAndSaveChanges()) {
            return false;
        }
        boolean bl = this.newWorkspace(string, string3, string2, n2, n);
        if (bl && vector != null) {
            vector.savePanel();
        }
        this.updateStreamAlignmentUnits(streamAlignmentUnits);
        return bl;
    }

    private void updateStreamAlignmentUnits(StreamAlignmentUnits streamAlignmentUnits) {
        if (streamAlignmentUnits != null) {
            try {
                ClientApp.Workspace().getData().setStreamAlignmentUnits(streamAlignmentUnits.toString());
                return;
            }
            catch (RemoteException remoteException) {
                Logger.getLogger(RSS.class.getName()).warning("Failed to save Stream Alignment Units " + String.valueOf(remoteException));
            }
        }
    }

    public String getAppType() {
        return "rss";
    }

    public void saveDirectories(String string, String string2, String string3, String string4, int n, String string5) {
        super.saveDirectories(string, string2, string3, string4, n, this.getPropertiesClassString());
    }

    public void loadDirectories(String string) {
        RSS rSS = this;
        super.loadDirectories(rSS.getPropertiesClassString());
    }

    public String getRecentDirectory() {
        return this._recentDirectory;
    }

    public void setRecentDirectory(String string) {
        this._recentDirectory = string;
    }

    public static void setRssApp(RSS rSS) {
        ClientApp.setApp((ClientApp)rSS);
    }

    public static RSS rssApp() {
        return (RSS)ClientApp.app();
    }

    public static RssFrame rssFrame() {
        return (RssFrame)ClientApp.frame();
    }

    public static void setRssFrame(RssFrame rssFrame) {
        ClientApp.setClientFrame((HecClientFrame)rssFrame);
    }

    public DefaultJPanel[] getGlobalPanels() {
        return null;
    }

    public String getPropertiesClassString() {
        return HecRssProperties.class.getName();
    }

    public String getAppPermissionString() {
        return "Res";
    }

    public String getApplicationName() {
        return "ResSim";
    }

    public static void main(String[] stringArray) {
        EventQueue.invokeLater(new RSS$1(stringArray));
    }

    public static void startResSim(String[] stringArray) {
        block19: {
            URL uRL;
            if (System.getProperty("nohandler") == null) {
                Thread.setDefaultUncaughtExceptionHandler(new UncaughtExceptionHandler());
            }
            if ((uRL = RSS.class.getClassLoader().getResource("com/fasterxml/jackson/databind/ObjectMapper.class")) != null) {
                ((FluentLogger.Api)a.atFine()).log("startResSim:ObjectMapper's location is %s", (Object)uRL);
            }
            ClassNameMapper.addClassNameMapping((String)"hec.model.StreamAlignment", (String)StreamAlignment.class.getName());
            ClassNameMapper.addClassNameMapping((String)"hec.model.ModelAlt", (String)ModelAlt.class.getName());
            ClassNameMapper.addClassNameMapping((String)"hec.model.SimulationPeriod", (String)SimulationPeriod.class.getName());
            ClassNameMapper.addClassNameMapping((String)"hec.model.TSDataSet", (String)TSDataSet.class.getName());
            SimulationRun.setDefaultModelAltClassName((String)ModelAlt.class.getName());
            b = System.currentTimeMillis();
            boolean bl = false;
            String string = null;
            String string2 = null;
            if (stringArray.length > 0) {
                if ("networked".equalsIgnoreCase(stringArray[0])) {
                    bl = true;
                } else if ("noframe".equalsIgnoreCase(stringArray[0])) {
                    _noFrame = true;
                } else if (stringArray[0].toLowerCase().endsWith(".py")) {
                    string2 = stringArray[0];
                    _noFrame = true;
                } else {
                    string = stringArray[0];
                }
            }
            Object object = bl ? RSS.getLoginInfo((String)" Hec-ResSim ", (boolean)true, (String)"Res") : RSS.getLoginInfo((String)"HEC-ResSim", (String)"Images/rss/dam256contrastbrighter.gif", RSS.class, (!_noFrame ? 1 : 0) != 0);
            RSS.setRssApp(new RSS((LoginInfo)object));
            RSS.setRssFrame(new RssFrame());
            RSS.rssFrame().setRssApp(RSS.rssApp());
            if (object.serverName != null && !object.serverName.isEmpty()) {
                RSS.rssApp().setServerDisplayName(object.serverName);
            }
            RSS.rssFrame().updateTitle();
            String string3 = System.getProperty("DSSLOGFILE");
            RSS.rssFrame().setDssLogFile(string3);
            HecDataManager.setProgramName((String)("ResSim " + RSS.getResSimVersion()));
            if (string != null) {
                ((FluentLogger.Api)a.atInfo()).log("main:openWorkspace %s", (Object)string);
                RSS.rssApp().openWorkspace(string);
            } else if (string2 != null) {
                System.getProperty("user.name");
                if (object.profile != null) {
                    object.profile.getUserId();
                }
                object = null;
                if (stringArray.length > 1) {
                    object = new String[stringArray.length - 1];
                    System.arraycopy(stringArray, 1, object, 0, ((String[])object).length);
                }
                RMAIO.getFileNameNoExtension((String)string2);
                try {
                    int n = stringArray.length > 1 ? RSS.launchScript((String)string2, (String[])object) : RSS.launchScript((String)string2, (String[])stringArray);
                    if (n != 0 && RSS.canExitJVM()) {
                        System.exit(n);
                    }
                }
                catch (Throwable throwable) {
                    ((FluentLogger.Api)a.atWarning()).log("RSS::main. Exception from running script %s, exception %s", (Object)string2, (Object)throwable.getMessage());
                    ((FluentLogger.Api)((FluentLogger.Api)a.atFine()).withCause(throwable)).log();
                    if (!RSS.canExitJVM()) break block19;
                    System.exit(1234);
                }
            }
        }
        RSS.rssFrame().setLocation(50, 50);
        if (!_noFrame) {
            RSS.rssFrame().setVisible(true);
        }
        Runtime.getRuntime().addShutdownHook(new RSS$2());
    }

    public DataListContainer getDataListContainer(RmiDataListContainer rmiDataListContainer) {
        return new DefaultDataListContainer(rmiDataListContainer);
    }

    static {
        TSRecordImplFactory.setTSRecordClass((String)RssTSRecordImpl.class.getName());
        ListSelection._standAlone = false;
    }
}

