/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.clientapp.client.ClientApp;
import hec.clientapp.model.TSDataSet;
import hec.clientapp.model.TSRecordImpl;
import hec.clientapp.model.TSRecordProxy;
import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.heclib.dss.DSSPathname;
import hec.heclib.util.HecTime;
import hec.heclib.util.HecTimeArray;
import hec.heclib.util.Heclib;
import hec.heclib.util.doubleArrayContainer;
import hec.lang.Logger;
import hec.model.ModelVariable;
import hec.model.RunTimeWindow;
import hec.model.TSRecord;
import hec.rss.client.RSSDecisionSummaryReport$HtmlCellRenderer;
import hec.rss.client.ReleaseDecisionReportEditor;
import hec.rss.client.RssSummaryJFrame;
import hec.rss.model.AdjustableFlow;
import hec.rss.model.DivertedOutletElement;
import hec.rss.model.Element;
import hec.rss.model.OpController;
import hec.rss.model.OpRule;
import hec.rss.model.OpSet;
import hec.rss.model.ReservoirElement;
import hec.rss.model.ReservoirOp;
import hec.rss.model.RssAlt;
import hec.rss.model.RssModelVariableConstants;
import hec.rss.model.RssModelVariableSet;
import hec.rss.model.RssNode;
import hec.rss.model.RssRun;
import hec.rss.model.RssSystem;
import hec.rss.model.RssTSLocationObject;
import hec.rss.plugins.model.AltPluginData;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.table.TableCellRenderer;
import rma.swing.RmaJTable;
import rma.swing.table.ColumnGroup;
import rma.swing.table.GroupableTableHeader;
import rma.swing.table.RmaDateTimeRenderer;
import rma.util.RMAConst;

public class RSSDecisionSummaryReport
implements RssModelVariableConstants,
ActionListener {
    private static final String HTML_BOLD_BEGIN = "<html><b>";
    private static final String HTML_BOLD_END = "</b></html>";
    private static final MessageFormat _htmlBoldFormat = new MessageFormat("<html><b>{0}</b></html>");
    private JMenuItem _optionMenuItem;
    private RssSummaryJFrame _report;
    private RssSystem _system;
    private RssAlt _alt;
    private RssRun _run;
    private String _resName;
    private String _collection;
    private String _originalFPart;

    public RSSDecisionSummaryReport(RssSystem rssSystem, RssAlt rssAlt, RssRun rssRun, String string) {
        this._system = rssSystem;
        this._alt = rssAlt;
        this._run = rssRun;
        this._originalFPart = this._run.getOutputFPart();
        this._resName = string;
        this._collection = this._run.getReleaseDecisionReportOptions().getCollection();
        if (this._resName == null) {
            this._resName = this._run.getReleaseDecisionReportOptions().getReservoirName();
            if (this._resName == null || this._resName.isEmpty()) {
                this._resName = rssAlt.getSystem().getReservoirNames()[0];
            }
        }
        this.createAndDisplayReport();
    }

    private void createAndDisplayReport() {
        Object object;
        Object object2;
        TableCellRenderer tableCellRenderer;
        Object object3;
        Object object4;
        TSRecord tSRecord;
        TSRecordProxy tSRecordProxy;
        Object object5;
        Object object6;
        Object[][] objectArray;
        String string;
        Object object7;
        int n;
        Object object8;
        int n2;
        Object object9;
        String[] stringArray;
        int n3;
        Vector vector;
        long l = System.currentTimeMillis();
        if (this._alt == null || this._run == null || this._system == null) {
            if (this._alt == null) {
                System.out.println("RSSDecisionSummaryReport.displayReport: can't display report - alternative is null");
            }
            if (this._run == null) {
                System.out.println("RSSDecisionSummaryReport.displayReport: can't display report - run is null");
            }
            if (this._system == null) {
                System.out.println("RSSDecisionSummaryReport.displayReport: can't display report - network is null");
            }
            return;
        }
        if (this._resName == null) {
            vector = this._system.getElementVectorByClass(ReservoirElement.class.getName());
        } else {
            vector = new Vector();
            ReservoirElement reservoirElement = this._system.findReservoir(this._resName);
            if (reservoirElement != null) {
                vector.addElement(reservoirElement);
            }
        }
        int n4 = vector.size();
        if (n4 <= 0) {
            System.out.println("RSSDecisionSummaryReport.displayReport: no reservoirs to report");
            JOptionPane.showMessageDialog((Component)ClientApp.frame(), "No Reservoirs to report on.", "Release Decision Report", 1);
            return;
        }
        Object object10 = ":";
        int n5 = 0;
        Vector<Vector<OpController>> vector2 = new Vector<Vector<OpController>>();
        for (n3 = 0; n3 < vector.size(); ++n3) {
            stringArray = (String[])vector.elementAt(n3);
            object9 = stringArray.getReservoirOp().getControllers();
            vector2.add((Vector<OpController>)object9);
            n5 += ((Vector)object9).size();
            object10 = n3 == 0 ? (String)object10 + " " + stringArray.getName() : (String)object10 + ", " + stringArray.getName();
        }
        n3 = (n4 << 1) + n5;
        stringArray = new String[n3];
        object9 = new int[n3];
        String[] stringArray2 = "\nNet Inflow (%S)";
        Object object11 = "\nPump Rule\nAvg Pumpback (%S)";
        Object object12 = "Active Zone\nElev (%S)";
        Object object13 = "Active Rule\nFlow (%S)";
        String string2 = "Uncontrolled\nFlow (%S)";
        int n6 = 0;
        for (n2 = 0; n2 < n4; ++n2) {
            ReservoirElement cfr_ignored_0 = (ReservoirElement)vector.elementAt(n2);
            stringArray[n6] = object12;
            object9[n6] = 100;
            stringArray[++n6] = stringArray2;
            object9[n6] = 100;
            ++n6;
            object8 = (Vector)vector2.elementAt(n2);
            for (n = 0; n < ((Vector)object8).size(); ++n) {
                OpController opController = (OpController)((Vector)object8).elementAt(n);
                Element element = opController.getReleaseElement();
                object7 = element.getFunction();
                stringArray[n6] = opController.isUncontrolled() ? this._system.getNameForKeyString(opController.getName()) + "\n" + string2 : (object7 instanceof AdjustableFlow && ((AdjustableFlow)object7).hasPump() ? this._system.getNameForKeyString(opController.getName()) + "\n" + (String)object11 : this._system.getNameForKeyString(opController.getName()) + "\n" + (String)object13);
                int n7 = stringArray[n6].indexOf("-");
                if (n7 > 0) {
                    stringArray[n6] = stringArray[n6].substring(n7);
                }
                object9[n6] = 100;
                ++n6;
            }
        }
        String[] stringArray3 = new String[2];
        stringArray2 = stringArray3;
        stringArray3[0] = "Alternative: " + this._alt.getName();
        stringArray2[1] = "Run: " + this._run.getName();
        if (this._alt != null && this._alt.getPluginDataList() != null && !this._alt.getPluginDataList().isEmpty() && !this._alt.useYieldAnalysis()) {
            List<AltPluginData> list = this._alt.getPluginDataList();
            for (int i = 0; i < list.size(); ++i) {
                object8 = list.get(i);
                if (!object8.useCompute()) continue;
                object7 = object8.getCollectionNumbers(this._alt, this._run.getRunTimeWindow().getStartTime());
                if (this._collection != null && !this._collection.isEmpty() && object7.contains(this._collection)) {
                    object11 = new DSSPathname();
                    object11.setFPart(this._run.getOutputFPart());
                    object11.setCollectionSequence(this._collection);
                    this._run.setOutputFPart(object11.getFPart());
                    stringArray2[1] = "Collection Run: " + object11.getFPart();
                    break;
                }
                if (object7 == null) continue;
                this._collection = object7.get(0);
                object11 = new DSSPathname();
                object11.setFPart(this._run.getOutputFPart());
                object11.setCollectionSequence(this._collection);
                this._run.setOutputFPart(object11.getFPart());
                stringArray2[1] = "Collection Run: " + object11.getFPart();
                break;
            }
        }
        object8 = new String[4];
        RunTimeWindow runTimeWindow = this._run.getRunTimeWindow();
        String string3 = "Start Time:  ";
        if ("cavi".equals(ClientApp.app().getAppType())) {
            string3 = "Forecast Time: ";
        }
        object7 = new SimpleDateFormat("dd MMM yyyy, HHmm");
        object11 = new HecTime();
        object12 = ClientApp.Workspace().getWatershedTimeZone();
        object13 = ClientApp.app().getClientTimeZone();
        ((DateFormat)object7).setTimeZone((TimeZone)object13);
        if (!this._run.getReleaseDecisionReportOptions().getUseSimPeriod() && this.checkTimes()) {
            object13 = this._run.getReleaseDecisionReportOptions().getStartTime();
            string2 = this._run.getReleaseDecisionReportOptions().getEndTime();
            string = object13.toString(4) + " " + string2.toString(4);
            object11.set(runTimeWindow.getStartTimeString());
            object11.getJavaDate(((TimeZone)object12).getRawOffset() / 60000);
            object8[1] = "Start Time:  " + object13.toString(4);
            object11.set(runTimeWindow.getEndTimeString());
            object11.getJavaDate(((TimeZone)object12).getRawOffset() / 60000);
            object8[2] = "End Time:  " + string2.toString(4);
        } else {
            object13 = runTimeWindow.getStartTime();
            string2 = runTimeWindow.getEndTime();
            string = runTimeWindow.getStartTimeString() + " " + runTimeWindow.getEndTimeString();
            object11.set(runTimeWindow.getLookbackTimeString());
            objectArray = object11.getJavaDate(((TimeZone)object12).getRawOffset() / 60000);
            object8[0] = "Lookback:  " + ((DateFormat)object7).format((Date)objectArray);
            object11.set(runTimeWindow.getStartTimeString());
            objectArray = object11.getJavaDate(((TimeZone)object12).getRawOffset() / 60000);
            object8[1] = string3 + ((DateFormat)object7).format((Date)objectArray);
            object11.set(runTimeWindow.getEndTimeString());
            objectArray = object11.getJavaDate(((TimeZone)object12).getRawOffset() / 60000);
            object8[2] = "End Time:  " + ((DateFormat)object7).format((Date)objectArray);
        }
        object8[3] = "Rule Key:  GC=Guide Curve, RO=Release Override, EO=Elevation Override, ZB=Zone Boundary";
        objectArray = null;
        HecTime hecTime = new HecTime();
        Object[][] objectArray2 = null;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        TSDataSet tSDataSet = this._run.getRegOutputTSData(true);
        if (tSDataSet == null) {
            return;
        }
        tSDataSet.initialize(runTimeWindow);
        long l2 = System.currentTimeMillis();
        n6 = 0;
        long l3 = 0L;
        boolean bl = !ClientApp.app().isNetworked();
        if (bl) {
            Heclib.zset((String)"MLEVEL", (String)"", (int)0);
        }
        for (n = 0; n < n4; ++n) {
            TSRecordProxy tSRecordProxy2;
            TSRecord tSRecord2;
            ReservoirElement reservoirElement = (ReservoirElement)vector.elementAt(n);
            ReservoirOp reservoirOp = reservoirElement.getReservoirOp();
            object6 = reservoirOp.getOperationSet(this._alt.getResOpSetSelection(reservoirElement.getIndex()));
            if (tSDataSet.getTSRecords() == null || tSDataSet.getTSRecords().size() == 0) {
                tSDataSet = this._run.getRegOutputTSData(true);
                if (tSDataSet == null) {
                    return;
                }
                string = runTimeWindow.getStartTimeString() + " " + runTimeWindow.getEndTimeString();
                tSDataSet.initialize(runTimeWindow);
            }
            if ((tSRecord2 = tSDataSet.loadTSRecord((tSRecordProxy2 = reservoirElement.getStorageFunction().getTSRecordProxy(13)).getName(), tSRecordProxy2.getParamName(), string)) == null) {
                System.out.println("RSSDecisionSummaryReport.displayReport: did not load net inflow record");
                System.out.println(tSRecordProxy2.getName() + ", " + tSRecordProxy2.getParamName() + ", " + string);
                continue;
            }
            object5 = tSRecord2.getTSArray();
            tSRecordProxy = reservoirElement.getStorageFunction().getTSRecordProxy(10);
            tSRecord = tSDataSet.loadTSRecord(tSRecordProxy.getName(), tSRecordProxy.getParamName(), string);
            if (tSRecord == null) {
                System.out.println("RSSDecisionSummaryReport.displayReport: did not load elevation record");
                System.out.println(tSRecordProxy.getName() + ", " + tSRecordProxy.getParamName() + ", " + string);
                continue;
            }
            object4 = tSRecord.getTSArray();
            object3 = null;
            tableCellRenderer = null;
            object2 = null;
            object = null;
            Vector vector3 = (Vector)vector2.elementAt(n);
            for (int i = 0; i < vector3.size(); ++i) {
                RssNode rssNode;
                Element element;
                TSRecordProxy tSRecordProxy3;
                OpController opController = (OpController)vector3.elementAt(i);
                TSRecordProxy tSRecordProxy4 = ((RssTSLocationObject)opController).getTSRecordProxy(71);
                object3 = tSDataSet.loadTSRecord(tSRecordProxy4.getName(), tSRecordProxy4.getParamName(), string);
                if (object3 == null) {
                    System.out.println("RSSDecisionSummaryReport.displayReport: did not load ruleid record");
                    System.out.println(tSRecordProxy4.getName() + ", " + tSRecordProxy4.getParamName() + ", " + string);
                    continue;
                }
                Element element2 = opController.getReleaseElement();
                boolean bl2 = false;
                if (element2.getFunction() instanceof AdjustableFlow && ((AdjustableFlow)element2.getFunction()).hasPump()) {
                    bl2 = true;
                }
                if (element2 == null || element2 instanceof ReservoirElement) {
                    tSRecordProxy3 = reservoirElement.getStorageFunction().getTSRecordProxy(21);
                } else if (bl2) {
                    tSRecordProxy3 = ((AdjustableFlow)element2.getFunction()).getTSRecordProxy(183);
                } else {
                    element = opController.getReleaseElement();
                    if (element == null || (rssNode = element instanceof DivertedOutletElement ? ((DivertedOutletElement)element).getTailNode() : element.getDownstreamNode()) == null) continue;
                    tSRecordProxy3 = rssNode.getTSRecordProxy(0);
                }
                if (tSRecordProxy3 == null) continue;
                object = tSDataSet.loadTSRecord(tSRecordProxy3.getName(), tSRecordProxy3.getParamName(), string);
                if (object == null) {
                    System.out.println("RSSDecisionSummaryReport.displayReport: did not load flow record");
                    System.out.println(tSRecordProxy3.getName() + ", " + tSRecordProxy3.getParamName() + ", " + string);
                    continue;
                }
                element = ((RssTSLocationObject)opController).getTSRecordProxy(73);
                tableCellRenderer = tSDataSet.loadTSRecord(element.getName(), element.getParamName(), string);
                if (tableCellRenderer == null) {
                    System.out.println("RSSDecisionSummaryReport.displayReport: did not load constraint record");
                    System.out.println(element.getName() + ", " + element.getParamName() + ", " + string);
                    continue;
                }
                rssNode = ((RssTSLocationObject)opController).getTSRecordProxy(72);
                object2 = tSDataSet.loadTSRecord(rssNode.getName(), rssNode.getParamName(), string);
                if (object2 == null) {
                    System.out.println("RSSDecisionSummaryReport.displayReport: did not load zoneid record");
                    System.out.println(rssNode.getName() + ", " + rssNode.getParamName() + ", " + string);
                    continue;
                }
                object11 = object3.getTimeArray();
                object12 = object3.getTSArray();
                object7 = tableCellRenderer.getTSArray();
                double[] dArray = object2.getTSArray();
                string3 = object.getTSContainer();
                ModelVariable modelVariable = RssModelVariableSet.getModelVariable(tSRecordProxy3.getVariableId());
                int n11 = Parameter.PARAMID_FLOW;
                if (modelVariable != null) {
                    n11 = modelVariable.getParamId();
                }
                long l4 = System.currentTimeMillis();
                if (n == 0 && i == 0) {
                    n8 = 0;
                    n9 = ((Object)object11).length - 1;
                    n2 = 0;
                    while (n2 < ((Object)object11).length) {
                        if (object11[n2] <= object13.value()) {
                            n8 = n2;
                        }
                        if (object11[n2] > string2.value()) break;
                        n9 = n2++;
                    }
                    objectArray = new Object[n9 - n8 + 1 << 1][n3];
                    n10 = n9 - n8 + 1 << 1;
                }
                long l5 = System.currentTimeMillis();
                l3 += l5 - l4;
                if (objectArray2 == null) {
                    objectArray2 = new Object[n9 - n8 + 1 << 1][1];
                }
                for (n2 = n8; n2 <= n9; ++n2) {
                    Object object14;
                    if (n == 0 && i == 0) {
                        object14 = new HecTimeArray(1);
                        object14.setTimeZone(ClientApp.Workspace().getTimeZone());
                        hecTime.set((int)object11[n2]);
                        object14.set(0, hecTime);
                        objectArray2[(n2 - n8 << 1) + 1][0] = object14.timeArray()[0].dateAndTime(4);
                    }
                    if (i == 0) {
                        if (dArray[n2] != -3.4028234663852886E38) {
                            object14 = ((OpSet)object6).getZone((int)dArray[n2]);
                            if (object14 != null) {
                                objectArray[n2 - n8 << 1][n6] = object14.getName();
                            }
                        } else if (n2 - n8 << 1 > 0) {
                            objectArray[n2 - n8 << 1][n6] = "Abv Top Zone";
                        }
                        objectArray[(n2 - n8 << 1) + 1][n6] = new ParamDouble(object4[n2], Parameter.PARAMID_ELEV, reservoirElement.getUnitSystem());
                        objectArray[(n2 - n8 << 1) + 1][n6 + 1] = new ParamDouble((double)object5[n2], Parameter.PARAMID_FLOW, reservoirElement.getUnitSystem());
                    }
                    if (opController.isUncontrolled()) {
                        objectArray[n2 - n8 << 1][n6 + 2 + i] = OpController.OBJECTIVE_NAME[10];
                    } else {
                        OpRule opRule;
                        OpController opController2;
                        int n12;
                        int n13;
                        if (RMAConst.isValidValue((double)object12[n2]) && (int)object12[n2] != Integer.MIN_VALUE) {
                            int n14 = (int)object12[n2];
                            if (n14 >= 0) {
                                n13 = n14 >>> 16;
                                n12 = n14 & 0xFFFF;
                                opController2 = reservoirOp.getController(n13);
                                opRule = opController2 != null ? opController2.getRule(n12) : opController.getRule((int)object12[n2]);
                                if (opRule != null) {
                                    objectArray[n2 - n8 << 1][n6 + 2 + i] = _htmlBoldFormat.format(new String[]{opRule.getName()});
                                }
                            } else if (-n14 < OpController.OBJECTIVE_NAME.length) {
                                objectArray[n2 - n8 << 1][n6 + 2 + i] = OpController.OBJECTIVE_NAME[-n14];
                            }
                        }
                        if (RMAConst.isValidValue((double)object7[n2]) && (int)object7[n2] != Integer.MIN_VALUE) {
                            int n15 = (int)object7[n2];
                            if (n15 >= 0) {
                                n13 = n15 >>> 16;
                                n12 = n15 & 0xFFFF;
                                opController2 = reservoirOp.getController(n13);
                                opRule = null;
                                if (opController2 != null) {
                                    opRule = opController2.getRule(n12);
                                }
                                if (opRule != null) {
                                    String string4 = (String)objectArray[n2 - n8 << 1][n6 + 2 + i];
                                    objectArray[n2 - n8 << 1][n6 + 2 + i] = string4 != null ? _htmlBoldFormat.format(new String[]{string4 + ":" + opRule.getName()}) : _htmlBoldFormat.format(new String[]{":" + opRule.getName()});
                                }
                            } else if (!bl2 && Math.abs(n15) < OpController.CNSTRNT_NAME.length) {
                                String string5 = (String)objectArray[n2 - n8 << 1][n6 + 2 + i];
                                if (string5 != null) {
                                    if (string5.startsWith("<")) {
                                        string5 = string5.substring(0, string5.length() - 11);
                                        objectArray[n2 - n8 << 1][n6 + 2 + i] = string5 + ":" + OpController.CNSTRNT_NAME[-n15] + HTML_BOLD_END;
                                    } else {
                                        objectArray[n2 - n8 << 1][n6 + 2 + i] = string5 + ":" + OpController.CNSTRNT_NAME[-n15];
                                    }
                                } else {
                                    objectArray[n2 - n8 << 1][n6 + 2 + i] = ":" + OpController.CNSTRNT_NAME[-n15];
                                }
                            }
                        }
                    }
                    objectArray[(n2 - n8 << 1) + 1][n6 + 2 + i] = new ParamDouble(((doubleArrayContainer)string3).array[n2], n11, reservoirElement.getUnitSystem());
                }
            }
            tSRecordProxy2.unload();
            tSRecordProxy.unload();
            tSRecordProxy2.unloadTSData();
            tSRecordProxy.unloadTSData();
            ((TSRecordImpl)tSRecord2).unloadTSData();
            ((TSRecordImpl)tSRecord).unloadTSData();
            ((TSRecordImpl)object3).unloadTSData();
            ((TSRecordImpl)tableCellRenderer).unloadTSData();
            ((TSRecordImpl)object2).unloadTSData();
            ((TSRecordImpl)object).unloadTSData();
            tSDataSet.unloadTSRecord();
            n6 += vector3.size() + 2;
        }
        this._run.clearOutputTSData();
        this._run.unloading();
        if (bl) {
            Heclib.zset((String)"MLEVEL", (String)"", (int)1);
        }
        long l6 = System.currentTimeMillis();
        if (this._report == null) {
            this._report = new RssSummaryJFrame(stringArray2, (String[])object8, objectArray, stringArray, (int[])object9, true);
            this._report.setSize(750, 530);
            this._report.setLocationRelativeTo((Component)ClientApp.frame());
        } else {
            object6 = this._report.getSize();
            this._report.updateReport(stringArray2, (String[])object8, objectArray, stringArray, (int[])object9, true);
            this._report.setSize((Dimension)object6);
        }
        object6 = new JMenu("Options");
        ((AbstractButton)object6).setMnemonic('O');
        this._optionMenuItem = new JMenuItem("Edit Options");
        this._optionMenuItem.setMnemonic('E');
        this._optionMenuItem.addActionListener(this);
        ((JMenu)object6).add(this._optionMenuItem);
        this._report._menuBar.add((JMenu)object6);
        long l7 = System.currentTimeMillis();
        RmaJTable rmaJTable = this._report.getTable();
        object4 = rmaJTable;
        rmaJTable.setAutoResizeMode(0);
        object4.setUnitsHeaderRenderer();
        object4.setPrecision(2);
        object5 = object4.getColumnModel();
        tSRecord = (GroupableTableHeader)object4.getTableHeader();
        object4.getColumnModel().getColumn(0).setCellRenderer((TableCellRenderer)new RmaDateTimeRenderer(2));
        n6 = 0;
        for (n2 = 0; n2 < n4; ++n2) {
            tSRecordProxy = new ColumnGroup(((ReservoirElement)vector.elementAt(n2)).getName());
            tSRecordProxy.add((Object)object5.getColumn(n6));
            object3 = object4.setDoubleCellEditor(n6, true);
            object3.setPrecision(2);
            tableCellRenderer = object4.getColumnModel().getColumn(n6).getCellRenderer();
            object2 = new RSSDecisionSummaryReport$HtmlCellRenderer(this, tableCellRenderer);
            object4.getColumnModel().getColumn(n6).setCellRenderer((TableCellRenderer)object2);
            object4.setColumnWidth(n6, 120);
            tSRecordProxy.add((Object)object5.getColumn(++n6));
            object3 = object4.setDoubleCellEditor(n6, true);
            object3.setPrecision(2);
            tableCellRenderer = object4.getColumnModel().getColumn(n6).getCellRenderer();
            object2 = new RSSDecisionSummaryReport$HtmlCellRenderer(this, tableCellRenderer);
            object4.getColumnModel().getColumn(n6).setCellRenderer((TableCellRenderer)object2);
            object4.setColumnWidth(n6, 120);
            ++n6;
            object = (Vector)vector2.elementAt(n2);
            for (n = 0; n < ((Vector)object).size(); ++n) {
                object4.setDoubleCellEditor(n6, true);
                object4.setColumnWidth(n6, 120);
                tableCellRenderer = object4.getColumnModel().getColumn(n6).getCellRenderer();
                object2 = new RSSDecisionSummaryReport$HtmlCellRenderer(this, tableCellRenderer);
                object4.getColumnModel().getColumn(n6).setCellRenderer((TableCellRenderer)object2);
                tSRecordProxy.add((Object)object5.getColumn(n6));
                ++n6;
            }
            tSRecord.addColumnGroup((ColumnGroup)tSRecordProxy);
        }
        object4.setRowBackground(1, Color.lightGray);
        object3 = new Color(245, 245, 245);
        for (int i = 3; i < n10; i += 2) {
            object4.setRowBackground(i, (Color)object3);
        }
        String[] stringArray4 = new String[]{"\n\nDate-Time"};
        object2 = object4.setViewportRowHeader(stringArray4, objectArray2, null, null, 130);
        object2.setRowBackground(0, object4.getCellBackground(1, 1));
        object2.setRowBackground(1, object4.getCellBackground(1, 1));
        this._report.setTitle("Release Decision Report" + (String)object10);
        this._report.setDateStrings(runTimeWindow.getLookbackDateString(), runTimeWindow.getStartTimeString(), runTimeWindow.getEndTimeString());
        this._report.setVisible(true);
        this._report.toFront();
        long l8 = System.currentTimeMillis();
        if (Logger.canDebug((String)"ResSimReports")) {
            System.out.println("displayReport:total time=" + (l8 - l) + "ms");
            System.out.println("displayReport:init time=" + (l2 - l) + "ms");
            System.out.println("displayReport:load time=" + (l6 - l2) + "ms");
            System.out.println("displayReport:clip time=" + l3 + "ms");
            System.out.println("displayReport:table build time=" + (l8 - l6) + "ms");
            System.out.println("displayReport:table ctor time=" + (l7 - l6) + "ms");
        }
        this._run.setOutputFPart(this._originalFPart);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._optionMenuItem) {
            this.Options_Action();
            return;
        }
        this._report.actionPerformed(actionEvent);
    }

    private void Options_Action() {
        ReleaseDecisionReportEditor releaseDecisionReportEditor = new ReleaseDecisionReportEditor((JFrame)((Object)this._report), this._run, this._resName, this._system, this._alt);
        releaseDecisionReportEditor.setVisible(true);
        if (!releaseDecisionReportEditor.isCanceled()) {
            this.refillReport();
        }
        releaseDecisionReportEditor.dispose();
    }

    private boolean checkTimes() {
        HecTime hecTime = this._run.getReleaseDecisionReportOptions().getStartTime();
        HecTime hecTime2 = this._run.getReleaseDecisionReportOptions().getEndTime();
        if (hecTime.lessThan(this._run.getRunTimeWindow().getStartTime()) || hecTime.greaterThan(this._run.getRunTimeWindow().getEndTime()) || hecTime.greaterThan(hecTime2)) {
            return false;
        }
        return !hecTime2.greaterThan(this._run.getRunTimeWindow().getEndTime()) && !hecTime2.lessThan(this._run.getRunTimeWindow().getStartTime()) && !hecTime2.lessThan(hecTime);
    }

    private void refillReport() {
        this._resName = this._run.getReleaseDecisionReportOptions().getReservoirName();
        this._collection = this._run.getReleaseDecisionReportOptions().getCollection();
        this.createAndDisplayReport();
    }
}

