/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import com.google.common.flogger.FluentLogger;
import hec.appInterface.AppDaddy;
import hec.clientapp.client.ClientApp;
import hec.clientapp.client.ClientMode;
import hec.clientapp.client.ClientWorkspace;
import hec.clientapp.client.HecClientFrame;
import hec.clientapp.client.PopupMenuHandler;
import hec.clientapp.model.Manager;
import hec.clientapp.model.ManagerProxyListContainer;
import hec.clientapp.model.StreamAlignment;
import hec.event.ModifiableListener;
import hec.gui.NameDialog;
import hec.gui.RenameDlg;
import hec.io.Identifier;
import hec.lang.NamedType;
import hec.lang.UserId;
import hec.map.ButtonGifStrings;
import hec.map.LocalPt;
import hec.map.MapGlyph;
import hec.map.MapToolPanel;
import hec.map.MousePanAdapter;
import hec.map.MouseZoomAdapter;
import hec.map.WorldPt;
import hec.rss.client.AbstractAlternativeEditor;
import hec.rss.client.AlternativeEditor;
import hec.rss.client.ConnectivityDlg;
import hec.rss.client.DeleteSelectedElementsDialog;
import hec.rss.client.EditVerticalDatumAction;
import hec.rss.client.ElementListReport;
import hec.rss.client.ImportAlternativeDialog;
import hec.rss.client.ImportNetworkDialog;
import hec.rss.client.ImportNetworkDialog2;
import hec.rss.client.JunctionElementVerticalDatumSettingsProvider;
import hec.rss.client.NetworkConversionMessage;
import hec.rss.client.NetworkConversionMessage$NetworkChangeStatus;
import hec.rss.client.NetworkReport;
import hec.rss.client.NodeReportDlg;
import hec.rss.client.RSS;
import hec.rss.client.RSimBaseMode;
import hec.rss.client.RSimNetworkMode$1;
import hec.rss.client.RSimPopupMenuHandler;
import hec.rss.client.ResSimAdvancedOptionsPanel;
import hec.rss.client.ResSimReportsFactory;
import hec.rss.client.ReservoirElementVerticalDatumSettingsProvider;
import hec.rss.client.ReservoirJFrame;
import hec.rss.client.ReservoirSystemJDialog;
import hec.rss.client.RssDivOutletMouseAdapter;
import hec.rss.client.RssDiversionMouseAdapter;
import hec.rss.client.RssJuncMouseAdapter;
import hec.rss.client.RssNetworkConnectivityAdapter;
import hec.rss.client.RssRchMouseAdapter;
import hec.rss.client.RssReportsTableListener;
import hec.rss.client.RssResMouseAdapter;
import hec.rss.client.RssSimEditDialog;
import hec.rss.client.RssSystemDPData;
import hec.rss.client.RssSystemGlyph;
import hec.rss.client.RssSystemManagerChooser;
import hec.rss.client.StateVariableDialog;
import hec.rss.client.WaterAccountSetEditor;
import hec.rss.client.datum.VerticalDatumSettingsProvider;
import hec.rss.client.globalvariable.GlobalVariableEditor;
import hec.rss.client.reports.AlternativeInputReportEditor;
import hec.rss.map.ResSimPointerMouseAdapter;
import hec.rss.model.DiversionElement;
import hec.rss.model.DivertedOutletElement;
import hec.rss.model.DownstreamCntrlOpRule;
import hec.rss.model.DownstreamOpRule;
import hec.rss.model.Element;
import hec.rss.model.ElementOp;
import hec.rss.model.JunctionElement;
import hec.rss.model.OpController;
import hec.rss.model.OpRule;
import hec.rss.model.OpSet;
import hec.rss.model.ReachElement;
import hec.rss.model.ReservoirElement;
import hec.rss.model.RssAlt;
import hec.rss.model.RssNode;
import hec.rss.model.RssReturnStatusConstants;
import hec.rss.model.RssSystem;
import hec.rss.model.SystemHydropowerOpRule;
import hec.rss.model.TandemSysOpRule;
import hec.rss.server.DiversionEditorDlg;
import hec.rss.server.JunctionDialog;
import hec.rss.server.ReachDlg;
import hec.rss.util.NetworkElementDeleteComparator;
import hec.watershed.client.ManagerChooser;
import hec.watershed.model.Condition;
import hec.watershed.model.Study;
import hec.watershed.model.StudyDataList;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import mil.army.usace.hec.rmi.client.FileLockInfoJDialog;
import mil.army.usace.hec.rmi.client.RmiFileDialog;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;
import mil.army.usace.hec.rmi.io.dbf.DbfFile;
import mil.army.usace.hec.rmi.security.HecSecurityManager;
import mil.army.usace.hec.rmi.server.RmiFileCallBackImpl;
import rma.lang.Modifiable;
import rma.swing.DefaultJPanel;
import rma.swing.RmaImage;
import rma.swing.RmaInsets;
import rma.swing.RmaJMenuLabel;
import rma.swing.RmaJTextField;
import rma.swing.WindowUtilities;
import rma.swing.event.ReflectMultiListener;
import rma.swing.text.DssPathnamePartDocument;
import rma.swing.text.FilenameDocument;
import rma.util.RMAIO;

public class RSimNetworkMode
extends ClientMode
implements ModifiableListener,
RSimBaseMode,
RssReportsTableListener {
    private static final FluentLogger f = FluentLogger.forEnclosingClass();
    public static final String NO_WAT_NAMES_FILTER = "[^:].*";
    public static final String MODE_NAME = "Reservoir Network";
    public static final String MODELNAME = "rss";
    public static final String NETWORK_CLASSNAME = RssSystem.class.getName();
    public static final String NETWORK_TYPENAME = "Reservoir Network";
    public static final String NETWORK_EXTENSION = "rsys";
    protected JCheckBoxMenuItem a;
    protected ReflectMultiListener b;
    private LocalPt g;
    protected Study c;
    RssSystem d;
    protected StreamAlignment e;
    private ResSimAdvancedOptionsPanel h;
    private StateVariableDialog i;
    private WaterAccountSetEditor j;
    private JMenuItem k;
    private JMenu l;
    private JMenuItem m;
    private JMenuItem n;
    private JMenuItem o;
    private JMenuItem p;
    private JMenuItem q;
    private JMenu r;
    private JMenuItem s;
    private JLabel t;
    private RmaJTextField u;
    private RmiFileCallBackImpl v;
    private JLabel w;
    private RmaJTextField x;
    private JToggleButton y;
    private JMenuItem z;
    private JMenuItem A;
    private JMenuItem B;
    private JMenuItem C;
    private JMenuItem D;
    private JMenuItem E;
    private JMenuItem F;
    private JMenuItem G;
    private NodeReportDlg H;
    private ConnectivityDlg I;
    private AlternativeEditor J = null;
    private ReachDlg K;
    private JunctionDialog L;
    private ReservoirJFrame M;
    private DiversionEditorDlg N;
    private ReservoirSystemJDialog O;
    private RSimPopupMenuHandler P;
    private JMenuItem Q;
    public Boolean plotting = Boolean.FALSE;
    private JMenuItem R;
    private GlobalVariableEditor S;

    public RSimNetworkMode(HecClientFrame hecClientFrame) {
        this(hecClientFrame, false);
    }

    protected RSimNetworkMode(HecClientFrame hecClientFrame, boolean bl) {
        super(hecClientFrame);
        this.b = new ReflectMultiListener();
        this.a = new JCheckBoxMenuItem();
        this.a.setSelected(true);
        if (bl) {
            int n = 0;
            ClientMode[] clientModeArray = this._frame.getModes();
            for (int i = 0; i < clientModeArray.length; ++i) {
                if (!clientModeArray[i].menuName().startsWith("Reservoir Network")) continue;
                ++n;
            }
            this.setMenuName("Reservoir Network" + n);
        } else {
            this.setMenuName("Reservoir Network");
        }
        this._unlockIcon = RmaImage.getImageIcon((String)"Images/smallUnLock.gif");
        this.a(bl);
        this.a();
        this.createFrameToolBar();
    }

    protected void a(boolean bl) {
        JMenuItem jMenuItem;
        this.B = new JMenuItem("Reservoirs...", 82);
        this.B.setName("Edit_Reservoirs");
        RSimNetworkMode rSimNetworkMode = this;
        this.B.addActionListener((ActionListener)this.b.add((Object)rSimNetworkMode, (Object)rSimNetworkMode.B, "editReservoir"));
        RSimNetworkMode rSimNetworkMode2 = this;
        rSimNetworkMode2.addEditMenuItem(rSimNetworkMode2.B);
        this.A = new JMenuItem("Reaches...", 101);
        this.A.setName("Edit_Reaches");
        RSimNetworkMode rSimNetworkMode3 = this;
        this.A.addActionListener((ActionListener)this.b.add((Object)rSimNetworkMode3, (Object)rSimNetworkMode3.A, "editReach"));
        RSimNetworkMode rSimNetworkMode4 = this;
        rSimNetworkMode4.addEditMenuItem(rSimNetworkMode4.A);
        this.C = new JMenuItem("Junctions...", 74);
        this.C.setName("Edit_Junctions");
        RSimNetworkMode rSimNetworkMode5 = this;
        this.C.addActionListener((ActionListener)this.b.add((Object)rSimNetworkMode5, (Object)rSimNetworkMode5.C, "editJunction"));
        RSimNetworkMode rSimNetworkMode6 = this;
        rSimNetworkMode6.addEditMenuItem(rSimNetworkMode6.C);
        this.z = new JMenuItem("Diversions...", 68);
        this.z.setName("Edit_Diversions");
        RSimNetworkMode rSimNetworkMode7 = this;
        this.z.addActionListener((ActionListener)this.b.add((Object)rSimNetworkMode7, (Object)rSimNetworkMode7.z, "editDiversion"));
        RSimNetworkMode rSimNetworkMode8 = this;
        rSimNetworkMode8.addEditMenuItem(rSimNetworkMode8.z);
        this.D = new JMenuItem("Vertical Datum...", 86);
        this.D.setName("Edit_Vertical_Datum");
        RSimNetworkMode rSimNetworkMode9 = this;
        this.D.addActionListener((ActionListener)this.b.add((Object)rSimNetworkMode9, (Object)rSimNetworkMode9.D, "editVerticalDatum"));
        if (Boolean.getBoolean("ResSim.UsesVerticalDatum")) {
            RSimNetworkMode rSimNetworkMode10 = this;
            rSimNetworkMode10.addEditMenuItem(rSimNetworkMode10.D);
        }
        this.E = new JMenuItem("Reservoir Systems...", 83);
        this.E.setName("Edit_Systems");
        RSimNetworkMode rSimNetworkMode11 = this;
        this.E.addActionListener((ActionListener)this.b.add((Object)rSimNetworkMode11, (Object)rSimNetworkMode11.E, "editReservoirSysOps"));
        RSimNetworkMode rSimNetworkMode12 = this;
        rSimNetworkMode12.addEditMenuItem(rSimNetworkMode12.E);
        this.addEditMenuSeparator();
        this.F = new JMenuItem("State Variables...", 86);
        RSimNetworkMode rSimNetworkMode13 = this;
        this.F.addActionListener((ActionListener)this.b.add((Object)rSimNetworkMode13, (Object)rSimNetworkMode13.F, "editStateVariables"));
        RSimNetworkMode rSimNetworkMode14 = this;
        rSimNetworkMode14.addEditMenuItem(rSimNetworkMode14.F);
        this.R = new JMenuItem("Global Variables...", 71);
        RSimNetworkMode rSimNetworkMode15 = this;
        this.R.addActionListener((ActionListener)this.b.add((Object)rSimNetworkMode15, (Object)rSimNetworkMode15.R, "editGlobalVariables"));
        RSimNetworkMode rSimNetworkMode16 = this;
        rSimNetworkMode16.addEditMenuItem(rSimNetworkMode16.R);
        this.G = new JMenuItem("Water Account Sets...", 87);
        RSimNetworkMode rSimNetworkMode17 = this;
        this.G.addActionListener((ActionListener)this.b.add((Object)rSimNetworkMode17, (Object)rSimNetworkMode17.G, "editWaterAccountSets"));
        RSimNetworkMode rSimNetworkMode18 = this;
        rSimNetworkMode18.addEditMenuItem(rSimNetworkMode18.G);
        this.p = new JMenuItem("Import Element Properties...", 73);
        this.p.setName("Net_Import_Elements");
        RSimNetworkMode rSimNetworkMode19 = this;
        this.p.addActionListener((ActionListener)this.b.add((Object)rSimNetworkMode19, (Object)rSimNetworkMode19.p, "importProperties"));
        RSimNetworkMode rSimNetworkMode20 = this;
        rSimNetworkMode20.addEditMenuItem(rSimNetworkMode20.p);
        if (Boolean.getBoolean("ResSim.AllowAlternativeImport")) {
            this.Q = new JMenuItem("Import Alternative");
            this.Q.setName("Alt_Import");
            RSimNetworkMode rSimNetworkMode21 = this;
            this.Q.addActionListener((ActionListener)this.b.add((Object)rSimNetworkMode21, (Object)rSimNetworkMode21.Q, "importAlternative"));
            RSimNetworkMode rSimNetworkMode22 = this;
            rSimNetworkMode22.addEditMenuItem(rSimNetworkMode22.Q);
        }
        this.a.setText("Allow Network Editing");
        if (HecSecurityManager.getSecurityManager().checkPermission("Res.SystemConfigurationModule", "configure") == 4) {
            this.a.setMnemonic(78);
            this.a.setName("editConfiguration");
            RSimNetworkMode rSimNetworkMode23 = this;
            this.a.addActionListener((ActionListener)this.b.add((Object)rSimNetworkMode23, (Object)rSimNetworkMode23.a, "editConfiguration"));
        }
        if (bl) {
            this.addEditMenuSeparator();
            jMenuItem = new JMenuItem("Close Module");
            jMenuItem.setName("closeModule");
            jMenuItem.addActionListener((ActionListener)this.b.add((Object)this, (Object)jMenuItem, "closeModule"));
            this.addEditMenuItem(jMenuItem);
        }
        JMenu jMenu = new JMenu("Network");
        jMenu.setMnemonic('N');
        jMenuItem = new JMenuItem("New...", 78);
        jMenuItem.setName("Net_New");
        jMenuItem.addActionListener((ActionListener)this.b.add((Object)this, (Object)jMenuItem, "newNetwork"));
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Open...", 79);
        jMenuItem.setName("Net_Open");
        jMenuItem.addActionListener((ActionListener)this.b.add((Object)this, (Object)jMenuItem, "openNetwork"));
        jMenu.add(jMenuItem);
        if (Boolean.getBoolean("ResSim.MultipleNetworkModes")) {
            jMenuItem = new JMenuItem("Open in New Module", 73);
            jMenuItem.setName("Net_Open_New_Module");
            jMenuItem.addActionListener((ActionListener)this.b.add((Object)this, (Object)jMenuItem, "openNetworkNewModule"));
            jMenu.add(jMenuItem);
        }
        this.o = new JMenuItem("Edit", 69);
        this.o.setName("Net_Edit");
        RSimNetworkMode rSimNetworkMode24 = this;
        this.o.addActionListener((ActionListener)this.b.add((Object)rSimNetworkMode24, (Object)rSimNetworkMode24.o, "editNetwork"));
        jMenu.add(this.o);
        this.k = new JMenuItem("Save", 83);
        this.k.setName("Net_Save");
        RSimNetworkMode rSimNetworkMode25 = this;
        this.k.addActionListener((ActionListener)this.b.add((Object)rSimNetworkMode25, (Object)rSimNetworkMode25.k, "saveNetwork"));
        jMenu.add(this.k);
        this.n = new JMenuItem("Save As...", 65);
        this.n.setName("Net_SaveAs");
        this.n.setEnabled(false);
        RSimNetworkMode rSimNetworkMode26 = this;
        this.n.addActionListener((ActionListener)this.b.add((Object)rSimNetworkMode26, (Object)rSimNetworkMode26.n, "saveAsNetwork"));
        jMenu.add(this.n);
        this.s = new JMenuItem("Rename...", 82);
        this.s.setName("Net_Rename");
        this.s.setEnabled(false);
        RSimNetworkMode rSimNetworkMode27 = this;
        this.s.addActionListener((ActionListener)this.b.add((Object)rSimNetworkMode27, (Object)rSimNetworkMode27.s, "renameNetwork"));
        jMenu.add(this.s);
        jMenu.addSeparator();
        this.m = new JMenuItem("Update Network from Configuration", 85);
        this.m.setName("Net_UpdateConfig");
        RSimNetworkMode rSimNetworkMode28 = this;
        this.m.addActionListener((ActionListener)this.b.add((Object)rSimNetworkMode28, (Object)rSimNetworkMode28.m, "updateConfiguration"));
        jMenu.add(this.m);
        jMenu.addSeparator();
        this.q = new JMenuItem("Import Network...", 73);
        this.q.setName("Net_Import_Elements");
        RSimNetworkMode rSimNetworkMode29 = this;
        this.q.addActionListener((ActionListener)this.b.add((Object)rSimNetworkMode29, (Object)rSimNetworkMode29.q, "importNetwork"));
        jMenu.add(this.q);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Delete Networks...", 68);
        jMenuItem.setName("Net_Delete");
        jMenuItem.addActionListener((ActionListener)this.b.add((Object)this, (Object)jMenuItem, "deleteNetworks"));
        jMenu.add(jMenuItem);
        this.addMenu(jMenu);
        jMenu = new JMenu("Alternative");
        jMenu.setMnemonic('A');
        jMenuItem = new JMenuItem("Edit...", 69);
        jMenuItem.setName("Sim_Alternative");
        jMenuItem.addActionListener((ActionListener)this.b.add((Object)this, (Object)jMenuItem, "displayAlternativeEditor"));
        jMenu.add(jMenuItem);
        this.addMenu(jMenu);
        this.l = new JMenu("Reports");
        this.l.setMnemonic('R');
        jMenuItem = new JMenuItem("Reservoir List", 82);
        jMenuItem.setName("Rep_Reservoir");
        jMenuItem.addActionListener((ActionListener)this.b.add((Object)this, (Object)jMenuItem, "displayReservoirList"));
        this.l.add(jMenuItem);
        jMenuItem = new JMenuItem("Reach List", 69);
        jMenuItem.setName("Rep_Reach");
        jMenuItem.addActionListener((ActionListener)this.b.add((Object)this, (Object)jMenuItem, "displayReachList"));
        this.l.add(jMenuItem);
        jMenuItem = new JMenuItem("Junction List", 74);
        jMenuItem.setName("Rep_Junction");
        jMenuItem.addActionListener((ActionListener)this.b.add((Object)this, (Object)jMenuItem, "displayJunctionList"));
        this.l.add(jMenuItem);
        jMenuItem = new JMenuItem("Diversion List", 68);
        jMenuItem.setName("Rep_Diversion");
        jMenuItem.addActionListener((ActionListener)this.b.add((Object)this, (Object)jMenuItem, "displayDiversionList"));
        this.l.add(jMenuItem);
        this.l.addSeparator();
        jMenu = new JMenu("Advanced");
        jMenu.setMnemonic('A');
        this.l.add(jMenu);
        JMenu jMenu2 = new JMenu("Network Connectivity");
        jMenu2.setMnemonic(78);
        jMenu.add(jMenu2);
        jMenuItem = new JMenuItem("All Elements", 65);
        jMenuItem.addActionListener((ActionListener)this.b.add((Object)this, (Object)jMenuItem, "displayConnectivityTable"));
        jMenuItem.setName("Rep_Network");
        jMenu2.add(jMenuItem);
        jMenuItem = new JMenuItem("Selected Elements", 83);
        jMenuItem.addActionListener((ActionListener)this.b.add((Object)this, (Object)jMenuItem, "displaySelectedElementsConnectivityTable"));
        jMenuItem.setName("Rep_Network");
        jMenu2.add(jMenuItem);
        jMenuItem = new JMenuItem("Node List", 78);
        jMenuItem.setName("Rep_Node");
        jMenuItem.addActionListener((ActionListener)this.b.add((Object)this, (Object)jMenuItem, "displayNodeTable"));
        jMenu.add(jMenuItem);
        if (Boolean.getBoolean("ResSim.HasNetworkReport")) {
            jMenuItem = new JMenuItem("Network Report", 82);
            jMenuItem.setName("network_report");
            jMenuItem.addActionListener((ActionListener)this.b.add((Object)this, (Object)jMenuItem, "saveNetworkReport"));
            jMenu.add(jMenuItem);
        }
        this.l.addSeparator();
        this.r = new JMenu("Alternative Input");
        jMenu.setMnemonic('t');
        this.l.add(this.r);
        RSimNetworkMode rSimNetworkMode30 = this;
        rSimNetworkMode30.addMenu(rSimNetworkMode30.l);
    }

    protected void a() {
        this.setMapTools(new MapToolPanel(this._frame.getMapPanel()));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 0;
        JToggleButton jToggleButton = new JToggleButton();
        ButtonGifStrings buttonGifStrings = new ButtonGifStrings();
        new ButtonGifStrings().up = "Images/Point.gif";
        buttonGifStrings.down = "Images/Point.gif";
        buttonGifStrings.over = "Images/Point.gif";
        buttonGifStrings.on = "Images/Point.gif";
        buttonGifStrings.toolTipText = "Pointer Tool";
        buttonGifStrings.borderPainted = true;
        buttonGifStrings.adapter = ResSimPointerMouseAdapter.class.getName();
        this._mapTools.addToolButton(jToggleButton, buttonGifStrings, gridBagConstraints);
        jToggleButton = new JToggleButton();
        buttonGifStrings = new ButtonGifStrings();
        new ButtonGifStrings().up = "Images/ZoomUp.gif";
        buttonGifStrings.down = "Images/ZoomDown.gif";
        buttonGifStrings.over = "Images/ZoomUp.gif";
        buttonGifStrings.on = "Images/ZoomDown.gif";
        buttonGifStrings.toolTipText = "Zoom Tool";
        buttonGifStrings.borderPainted = true;
        buttonGifStrings.adapter = MouseZoomAdapter.class.getName();
        buttonGifStrings.cursorType = 1;
        this._mapTools.addToolButton(jToggleButton, buttonGifStrings, gridBagConstraints);
        if (Boolean.getBoolean("Map.HasPanMouseTool")) {
            jToggleButton = new JToggleButton();
            buttonGifStrings = MousePanAdapter.buildDefaultButtonGifStrings();
            this._mapTools.addToolButton(jToggleButton, buttonGifStrings, gridBagConstraints);
        }
        jToggleButton = new JToggleButton();
        buttonGifStrings = new ButtonGifStrings();
        new ButtonGifStrings().up = "Images/Icons/rss/reservoir.gif";
        buttonGifStrings.down = "Images/Icons/rss/reservoirSel.gif";
        buttonGifStrings.over = "Images/Icons/rss/reservoir.gif";
        buttonGifStrings.on = "Images/Icons/rss/reservoirSel.gif";
        buttonGifStrings.toolTipText = "Reservoir Tool";
        buttonGifStrings.borderPainted = true;
        buttonGifStrings.adapter = RssResMouseAdapter.class.getName();
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this._mapTools.addToolButton(jToggleButton, buttonGifStrings, gridBagConstraints);
        jToggleButton = new JToggleButton();
        buttonGifStrings = new ButtonGifStrings();
        new ButtonGifStrings().up = "Images/Icons/rss/divertedoutlet.gif";
        buttonGifStrings.down = "Images/Icons/rss/divertedoutletSel.gif";
        buttonGifStrings.over = "Images/Icons/rss/divertedoutlet.gif";
        buttonGifStrings.on = "Images/Icons/rss/divertedoutletSel.gif";
        buttonGifStrings.toolTipText = "Diverted Outlet Tool";
        buttonGifStrings.borderPainted = true;
        buttonGifStrings.adapter = RssDivOutletMouseAdapter.class.getName();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this._mapTools.addToolButton(jToggleButton, buttonGifStrings, gridBagConstraints);
        jToggleButton = new JToggleButton();
        buttonGifStrings = new ButtonGifStrings();
        new ButtonGifStrings().up = "Images/Icons/rss/reach.gif";
        buttonGifStrings.down = "Images/Icons/rss/reachSel.gif";
        buttonGifStrings.over = "Images/Icons/rss/reach.gif";
        buttonGifStrings.on = "Images/Icons/rss/reachSel.gif";
        buttonGifStrings.toolTipText = "Reach Tool";
        buttonGifStrings.borderPainted = true;
        buttonGifStrings.adapter = RssRchMouseAdapter.class.getName();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this._mapTools.addToolButton(jToggleButton, buttonGifStrings, gridBagConstraints);
        jToggleButton = new JToggleButton();
        buttonGifStrings = new ButtonGifStrings();
        new ButtonGifStrings().up = "Images/Icons/rss/junction.gif";
        buttonGifStrings.down = "Images/Icons/rss/junctionSel.gif";
        buttonGifStrings.over = "Images/Icons/rss/junction.gif";
        buttonGifStrings.toolTipText = "Junction Tool";
        buttonGifStrings.on = "Images/Icons/rss/junctionSel.gif";
        buttonGifStrings.borderPainted = true;
        buttonGifStrings.adapter = RssJuncMouseAdapter.class.getName();
        this._mapTools.addToolButton(jToggleButton, buttonGifStrings, gridBagConstraints);
        jToggleButton = new JToggleButton();
        buttonGifStrings = new ButtonGifStrings();
        new ButtonGifStrings().up = "Images/Icons/rss/diversion.gif";
        buttonGifStrings.down = "Images/Icons/rss/diversionSel.gif";
        buttonGifStrings.over = "Images/Icons/rss/diversion.gif";
        buttonGifStrings.toolTipText = "Diversion Tool";
        buttonGifStrings.on = "Images/Icons/rss/diversionSel.gif";
        buttonGifStrings.borderPainted = true;
        buttonGifStrings.adapter = RssDiversionMouseAdapter.class.getName();
        this._mapTools.addToolButton(jToggleButton, buttonGifStrings, gridBagConstraints);
        jToggleButton = new JToggleButton();
        buttonGifStrings = new ButtonGifStrings();
        new ButtonGifStrings().up = "Images/rss/connectivityUp.gif";
        buttonGifStrings.down = "Images/rss/connectivitySel.gif";
        buttonGifStrings.over = "Images/rss/connectivityUp.gif";
        buttonGifStrings.toolTipText = "Network Connectivity Tool";
        buttonGifStrings.on = "Images/rss/connectivitySel.gif";
        buttonGifStrings.borderPainted = true;
        buttonGifStrings.adapter = RssNetworkConnectivityAdapter.class.getName();
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this._mapTools.addToolButton(jToggleButton, buttonGifStrings, gridBagConstraints);
        this._mapTools.forceSelectButton(0);
    }

    public void createFrameToolBar() {
        this.t = new JLabel();
        this.t.setText("Network:");
        this.t.setToolTipText("Active Reservoir Network Name");
        RSimNetworkMode rSimNetworkMode = this;
        rSimNetworkMode.addToolBarComponent(rSimNetworkMode.t);
        this.u = new RmaJTextField();
        this.u.setEditable(false);
        Dimension dimension = this.u.getPreferredSize();
        this.u.getPreferredSize().width = 125;
        this.u.setMinimumSize(dimension);
        this.u.setPreferredSize(dimension);
        this.u.setToolTipText("Active Reservoir Network Name");
        RSimNetworkMode rSimNetworkMode2 = this;
        rSimNetworkMode2.addToolBarComponent((JComponent)rSimNetworkMode2.u);
        this.y = new JToggleButton(this._unlockIcon);
        Insets insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        this.y.setMargin(insets);
        this.y.setSelectedIcon(this._lockIcon);
        this.y.setToolTipText("Reservoir Network Locked Status");
        this.y.setModel(this.a.getModel());
        this.w = new JLabel();
        this.w.setText("Configuration:");
        this.w.setToolTipText("Configuration associated with the Reservoir Network");
        RSimNetworkMode rSimNetworkMode3 = this;
        rSimNetworkMode3.addToolBarComponent(rSimNetworkMode3.w);
        this.x = new RmaJTextField();
        this.x.setEditable(false);
        this.x.setMinimumSize(dimension);
        this.x.setPreferredSize(dimension);
        this.x.setToolTipText("Configuration associated with the Reservoir Network");
        RSimNetworkMode rSimNetworkMode4 = this;
        rSimNetworkMode4.addToolBarComponent((JComponent)rSimNetworkMode4.x);
    }

    public String getScriptableName() {
        return "Reservoir Network";
    }

    public void newNetwork() {
        if (this.checkAndSaveManagerChanges(MODELNAME, this.d, NETWORK_CLASSNAME, "Reservoir Network") <= 0) {
            return;
        }
        Object object = new RssSystemManagerChooser((Frame)this._frame, true, 3, 3L);
        object.setNameFilter("^[#_a-zA-Z0-9][^:].*");
        object.setNameDocument((Document)new FilenameDocument());
        object.setTitle("Create New Reservoir Network");
        object.setManagerType(MODELNAME, NETWORK_CLASSNAME, "Reservoir Network", NETWORK_EXTENSION);
        object.setVisible(true);
        if (!object.ok()) {
            return;
        }
        Object object2 = object.getIdentifier();
        if (object2 == null) {
            return;
        }
        String string = object2.getName();
        object2 = object2.getDescription();
        string = ClientApp.Workspace().getManagerIdentifier(MODELNAME, NETWORK_CLASSNAME, string, NETWORK_EXTENSION);
        string.setDescription((String)object2);
        String string2 = string;
        string = object.getConfiguration();
        object2 = string2;
        object = this;
        RssSystem rssSystem = (RssSystem)ClientApp.Workspace().newManager(MODELNAME, NETWORK_CLASSNAME);
        if (rssSystem != null) {
            rssSystem.setIdentifier((Identifier)object2);
            rssSystem.setName(object2.getName());
            Study study = null;
            ClientWorkspace clientWorkspace = ClientApp.Workspace();
            if (clientWorkspace != null) {
                if ((clientWorkspace = (StudyDataList)clientWorkspace.getDataListContainer().getDataList(Study.class.getName())) != null) {
                    study = (Study)clientWorkspace.getOpenStudy();
                }
                if (clientWorkspace == null || study == null) {
                    System.out.println("openStudy: Failed to find StudyDataList");
                    return;
                }
                rssSystem.setConfiguration(study, (Condition)string);
                boolean bl = ClientApp.Workspace().saveManagerAs(MODELNAME, (Manager)rssSystem, object2);
                if (!bl) {
                    ClientApp.app().postError("Unable to create new Reservoir Network", "Error Creating network");
                    return;
                }
                if (((RSimNetworkMode)object).d != null) {
                    RSS.Workspace().unloadManager(MODELNAME, ((RSimNetworkMode)object).d.getIdentifier());
                }
                ((RSimNetworkMode)object).d = rssSystem;
                ((RSimNetworkMode)object).updateManagerMaps();
                ((RSimNetworkMode)object).d.setModified(false);
            }
        }
    }

    public void openNetworkNewModule() {
        try {
            Object object = new RssSystemManagerChooser((Frame)this._frame, true, 4, 1L);
            object.setNameFilter("^[#_a-zA-Z0-9][^:].*");
            object.setTitle("Open Reservoir Network");
            object.setManagerType(MODELNAME, NETWORK_CLASSNAME, "Reservoir Network", NETWORK_EXTENSION);
            object.setVisible(true);
            if (!object.ok()) {
                return;
            }
            if ((object = object.getIdentifier()) == null) {
                return;
            }
            if (this.d != null && this.d.getIdentifier().equals(object)) {
                System.out.println("networks are the same");
                return;
            }
            object = (RssSystem)ClientApp.Workspace().openManager(MODELNAME, (Identifier)object);
            if (object == null) {
                ClientApp.app().postError("Unable to open Reservoir Network", "Error opening Network");
                return;
            }
            RSimNetworkMode rSimNetworkMode = new RSimNetworkMode(this._frame, true);
            this._frame.addMode((ClientMode)rSimNetworkMode);
            rSimNetworkMode.mapTools().setEnabled(true);
            this._frame.selectMode(this._frame.getModes().length - 1);
            rSimNetworkMode.setNetwork((RssSystem)object);
            rSimNetworkMode.mapTools().setEnabled(true);
            return;
        }
        finally {
            this._frame.setDefaultCursor();
        }
    }

    public void openNetwork() {
        if (this.checkAndSaveManagerChanges(MODELNAME, this.d, NETWORK_CLASSNAME, "Reservoir Network") <= 0) {
            return;
        }
        this._frame.setWaitCursor();
        try {
            RssSystemManagerChooser rssSystemManagerChooser = new RssSystemManagerChooser((Frame)this._frame, true, 4, 1L);
            rssSystemManagerChooser.setNameFilter(NO_WAT_NAMES_FILTER);
            rssSystemManagerChooser.setTitle("Open Reservoir Network");
            rssSystemManagerChooser.setManagerType(MODELNAME, NETWORK_CLASSNAME, "Reservoir Network", NETWORK_EXTENSION);
            rssSystemManagerChooser.setVisible(true);
            if (!rssSystemManagerChooser.ok()) {
                return;
            }
            if ((rssSystemManagerChooser = rssSystemManagerChooser.getIdentifier()) == null) {
                return;
            }
            this.openNetwork((Identifier)rssSystemManagerChooser);
        }
        finally {
            this._frame.setDefaultCursor();
        }
        this.b();
    }

    public void openNetwork(Identifier object) {
        object = (RssSystem)ClientApp.Workspace().openManager(MODELNAME, object);
        if (object == null) {
            ClientApp.app().postError("Unable to open Reservoir Network", "Error opening Network");
            return;
        }
        NetworkConversionMessage$NetworkChangeStatus networkConversionMessage$NetworkChangeStatus = NetworkConversionMessage.a((RssSystem)object);
        if (networkConversionMessage$NetworkChangeStatus == NetworkConversionMessage$NetworkChangeStatus.ShouldBeSaved) {
            this.setNetwork((RssSystem)object);
            this.saveNetwork();
        } else if (networkConversionMessage$NetworkChangeStatus == NetworkConversionMessage$NetworkChangeStatus.DoNoSave) {
            ((FluentLogger.Api)f.atInfo()).log("Network %s is from an older build and user doesn't want to save it", (Object)object.getName());
        }
        this.setNetwork((RssSystem)object);
    }

    public void setNetwork(RssSystem rssSystem) {
        if (this.d != null) {
            this.lockConfiguration(false);
            RSS.Workspace().unloadManager(MODELNAME, this.d.getIdentifier());
        }
        if (this.d != null) {
            this.d.removeModifiableListener(this);
        }
        this.d = rssSystem;
        if (this.d != null) {
            this.d.addModifiableListener(this);
        }
        this.updateManagerMaps();
    }

    public void editRssAlt() {
        try {
            Object object = new ManagerChooser((Window)this._frame, true, 4, 1L);
            object.setNameFilter("^[#_a-zA-Z0-9][^:].*");
            object.setTitle("Open Reservoir Alternative");
            object.setManagerType(MODELNAME, RssAlt.class.getName(), "Alternative", "ralt");
            object.setVisible(true);
            if (!object.ok()) {
                return;
            }
            if ((object = object.getIdentifier()) == null) {
                return;
            }
            object = (RssAlt)ClientApp.Workspace().openManager(MODELNAME, (Identifier)object);
            if (object == null) {
                ClientApp.app().postError("Unable to open Reservoir Network", "Error opening Alternative");
                return;
            }
            this.editRssAlt((JFrame)ClientApp.frame(), (RssAlt)object);
            return;
        }
        finally {
            this._frame.setDefaultCursor();
        }
    }

    public void editRssAlt(JFrame object, RssAlt rssAlt) {
        object = new RssSimEditDialog((JFrame)object, false);
        ((RssSimEditDialog)((Object)object)).fillForm(rssAlt, null);
        ((RssSimEditDialog)((Object)object)).setVisible(true);
    }

    public void saveNetwork() {
        if (!RSS.Workspace().saveManager(MODELNAME, (Manager)this.d)) {
            this.saveAsNetwork();
        }
    }

    public void editNetwork() {
        if (this.d == null) {
            return;
        }
        Object object = new RenameDlg((Frame)this._frame, "Edit Network", true);
        object.setName(this.d.getName());
        object.setNameEditable(false);
        object.setDescription(this.d.getIdentifier().getDescription());
        object.setFileNameVisible(false);
        object.setVisible(true);
        if (object.getCanceled()) {
            return;
        }
        object = object.getDescription();
        this.d.setDescription((String)object);
        this.d.getIdentifier().setDescription((String)object);
        this.c((String)object);
        ClientApp.Workspace().setModified(true);
    }

    protected String a(String string) {
        return RMAIO.concatPath((String)RMAIO.concatPath((String)MODELNAME, (String)"networks"), (String)RMAIO.userNameToFileName((String)string));
    }

    public void saveAsNetwork() {
        if (this.d == null) {
            return;
        }
        RssSystemManagerChooser rssSystemManagerChooser = new RssSystemManagerChooser((Frame)this._frame, true, 5, 1L);
        rssSystemManagerChooser.setTitle("Save Reservoir Network As");
        rssSystemManagerChooser.setNameFilter("^[#_a-zA-Z0-9][^:].*");
        rssSystemManagerChooser.setNameDocument((Document)new FilenameDocument());
        rssSystemManagerChooser.setManagerType(MODELNAME, NETWORK_CLASSNAME, "Reservoir Network", NETWORK_EXTENSION);
        rssSystemManagerChooser.setName(this.d.getName());
        if (this.d.getDescription() == null || this.d.getDescription().trim().length() == 0) {
            rssSystemManagerChooser.setDescription("Copy of " + this.d.getName());
        } else {
            rssSystemManagerChooser.setDescription(this.d.getDescription());
        }
        rssSystemManagerChooser.setVisible(true);
        if (!rssSystemManagerChooser.ok()) {
            return;
        }
        try {
            this._frame.setWaitCursor();
            rssSystemManagerChooser = rssSystemManagerChooser.getIdentifier();
            String string = rssSystemManagerChooser.getDescription();
            String string2 = rssSystemManagerChooser.getName();
            if (string2.length() == 0) {
                JOptionPane.showMessageDialog((Component)this._frame, "The network must have a valid name.");
                return;
            }
            string2 = ClientApp.Workspace();
            rssSystemManagerChooser = string2.getManagerIdentifier(this.a(rssSystemManagerChooser.getName()), NETWORK_CLASSNAME, rssSystemManagerChooser.getName(), NETWORK_EXTENSION);
            rssSystemManagerChooser.setDescription(string);
            string = string2.getManagerProxy(MODELNAME, NETWORK_CLASSNAME, this.d.getIndex());
            if (string == null) {
                System.out.println("saveAsNetwork: failed to find ManagerProxy for " + this.d.getName());
                return;
            }
            RssSystem rssSystem = (RssSystem)string2.newManager(MODELNAME, NETWORK_CLASSNAME);
            if (rssSystem == null) {
                JOptionPane.showMessageDialog((Component)this._frame, "Failed to create new Network", "Error", 0);
                return;
            }
            if ((rssSystem = string2.getManagerProxy(MODELNAME, NETWORK_CLASSNAME, rssSystem.getIndex())) != null && string != null) {
                this.d.getReservoirSysOps();
                rssSystem.setId((Identifier)rssSystemManagerChooser);
                if (!string.dropManager()) {
                    System.out.println("saveAsNetwork: too many references " + string.getObserverCount() + " to " + String.valueOf(this.d) + " to saveAs");
                    JOptionPane.showMessageDialog((Component)this._frame, "Save As network failed due to an internal error.\nTry saving and closing the network and then reopening it.", "Internal Error", 2);
                    string2.deleteManager(MODELNAME, (Identifier)rssSystemManagerChooser);
                    return;
                }
                rssSystem.setManager(this.d);
                this.d.resetAndSaveOperations();
            }
            if (!string2.saveManager(MODELNAME, (Manager)this.d)) {
                System.out.println("saveAsNetwork: Failed to save new network " + this.d.getName());
            }
        }
        finally {
            this._frame.setDefaultCursor();
        }
        this.updateManagerMaps();
    }

    public void renameNetwork() {
        Identifier identifier;
        if (this.d == null) {
            return;
        }
        Object object = this.d.getName();
        Object object2 = new Identifier(this.d.getIdentifier());
        RssSystemManagerChooser rssSystemManagerChooser = new RssSystemManagerChooser((Frame)this._frame, true, 6, 1L);
        rssSystemManagerChooser.setTitle("Rename Reservoir Network As");
        rssSystemManagerChooser.setNameFilter("^[#_a-zA-Z0-9][^:].*");
        rssSystemManagerChooser.setManagerType(MODELNAME, NETWORK_CLASSNAME, "Reservoir Network", NETWORK_EXTENSION);
        rssSystemManagerChooser.setName((String)object);
        rssSystemManagerChooser.setDescription(this.d.getIdentifier().getDescription());
        rssSystemManagerChooser.setVisible(true);
        if (!rssSystemManagerChooser.ok()) {
            return;
        }
        object = rssSystemManagerChooser.getIdentifier();
        rssSystemManagerChooser = (RmiFileManager)ClientApp.app().getFileManager().getRemote();
        try {
            identifier = rssSystemManagerChooser.newFile(ClientApp.app().getUser(), (Identifier)object);
        }
        catch (RemoteException remoteException) {
            System.out.println("renameNetwork: RemoteException " + String.valueOf(remoteException));
            remoteException.printStackTrace();
            return;
        }
        if (identifier == null) {
            try {
                if (rssSystemManagerChooser.fileExists((Identifier)object)) {
                    System.out.println("renameNetwork: found exising network file " + object.getPath() + ". So stopped rename process");
                    ClientApp.app().postError("Renaming of Network failed.\nAn existing network file named " + object.getPath() + " was found.", "Rename Failed");
                    return;
                }
            }
            catch (RemoteException remoteException) {
                System.out.println("renameNetwork: RemoteException " + String.valueOf(remoteException));
                remoteException.printStackTrace();
                return;
            }
            System.out.println("renameNetwork: failed to open file " + object.getPath());
            ClientApp.app().postError("Renaming of Network failed.\nFailed to open file" + object.getPath(), "Rename Failed");
            return;
        }
        try {
            this._frame.setWaitCursor();
            object = this.d();
            String string = this.c();
            boolean bl = ClientApp.Workspace().renameManager(MODELNAME, (Manager)this.d, identifier);
            if (bl) {
                this.b((String)object);
                this.b(string);
                object = this;
                String string2 = RMAIO.getFileNameNoExtension((String)object2.getPath());
                object2 = RMAIO.getDirectoryFromPath((String)object2.getPath());
                string2 = RMAIO.concatPath((String)object2, (String)(string2 + ".dss"));
                object = ((RSimNetworkMode)object).d.getDSSFileManager();
                try {
                    object.close(string2);
                    rssSystemManagerChooser.deleteFile(string2);
                }
                catch (RemoteException remoteException) {
                    System.out.println("deleteRenamedFiles: RemoteException " + String.valueOf(remoteException));
                    remoteException.printStackTrace();
                }
                RSimNetworkMode.a((RmiFileManager)rssSystemManagerChooser, (String)object2);
                this.updateManagerMaps();
            }
            return;
        }
        finally {
            this._frame.setDefaultCursor();
        }
    }

    private String c() {
        String string = null;
        DbfFile dbfFile = this.d.getResSysOpDbfFile();
        if (dbfFile != null) {
            string = dbfFile.getPath();
            try {
                dbfFile.close();
            }
            catch (IOException iOException) {
                System.out.println("IOException closing ResSysOp file:" + string);
            }
        }
        return string;
    }

    private String d() {
        String string = null;
        DbfFile dbfFile = this.d.getResOpDbfFile();
        if (dbfFile != null) {
            string = dbfFile.getPath();
            try {
                dbfFile.close();
            }
            catch (IOException iOException) {
                System.out.println("IOException closing ResSysOp file:" + string);
            }
        }
        return string;
    }

    private void b(String string) {
        if (string != null) {
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
            linkedHashSet.add(string);
            String string2 = RMAIO.getFileNameNoExtension((String)string);
            string = RMAIO.getDirectoryFromPath((String)string);
            String[] stringArray = new String[]{".dbf", ".dbt", ".mdx"};
            String[] stringArray2 = stringArray;
            stringArray2 = stringArray;
            int cfr_ignored_0 = stringArray.length;
            for (int i = 0; i < 3; ++i) {
                Object object = stringArray2[i];
                object = string2 + (String)object;
                object = RMAIO.concatPath((String)string, (String)object);
                linkedHashSet.add((String)object);
            }
            RSimNetworkMode.a(linkedHashSet);
        }
    }

    private static void a(Collection<String> object) {
        RmiFileManager rmiFileManager = (RmiFileManager)ClientApp.app().getFileManager().getRemote();
        object = object.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            try {
                if (!rmiFileManager.fileExists(string)) continue;
                rmiFileManager.deleteFile(string);
            }
            catch (RemoteException remoteException) {
                System.out.println("RemoteException deleting file:" + string);
                remoteException.printStackTrace();
            }
        }
    }

    private static void a(RmiFileManager rmiFileManager, String string) {
        try {
            Object object = rmiFileManager.getRemoteFileIDList(UserId.getUserId(), RMAIO.concatPath((String)string, (String)"scripts"), null);
            object = ((Vector)object).iterator();
            while (object.hasNext()) {
                Identifier identifier = (Identifier)object.next();
                rmiFileManager.deleteFile(identifier.getPath());
            }
            rmiFileManager.deleteDirectory(RMAIO.concatPath((String)string, (String)"scripts"));
            object = rmiFileManager.getRemoteFileIDList(UserId.getUserId(), string, null);
            if (object == null || ((Vector)object).isEmpty()) {
                rmiFileManager.deleteDirectory(string);
            }
            return;
        }
        catch (RemoteException remoteException) {
            System.out.println("deleteScripts: RemoteException " + String.valueOf(remoteException));
            remoteException.printStackTrace();
            return;
        }
    }

    public void updateConfiguration() {
        if (this.d == null) {
            return;
        }
        int n = JOptionPane.showConfirmDialog((Component)this._frame, "Warning: Updating the Network from the Watershed Configuration can move elements\n and change their names -- possibly invalidating the Network.\nAre you sure you want to Update the Network from the Configuration?", "Confirm Network Update from Configuration", 0, 3);
        if (n == 0) {
            this.d.updateConfiguration();
        }
        this._frame.getMapPanel().paintMap();
        this._frame.getMapPanel().waitforPaintComplete();
        this._frame.repaint();
    }

    public void deleteNetworks() {
        Object object = new RssSystemManagerChooser((Frame)this._frame, true, 2, 1L);
        object.setMultipleSelectionsAllowed(true);
        object.setTitle("ResSim - Delete Networks");
        object.setNameFilter("^[#_a-zA-Z0-9][^:].*");
        object.setManagerType(MODELNAME, NETWORK_CLASSNAME, "Reservoir Network", NETWORK_EXTENSION);
        object.setVisible(true);
        if (!object.ok()) {
            return;
        }
        int n = ((Vector)(object = object.getIdentifierList())).size();
        if (n == 0) {
            System.out.println("No Networks selected to delete");
            return;
        }
        for (int i = 0; i < n; ++i) {
            Identifier identifier = (Identifier)((Vector)object).get(i);
            boolean bl = ClientApp.Workspace().deleteManager(MODELNAME, identifier, true);
            if (!bl) {
                System.out.println("Unable to delete specified network " + identifier.getPath());
                return;
            }
            if (this.d == null || !this.d.getIdentifier().getPath().equals(identifier.getPath())) continue;
            this.d = null;
        }
        this.updateManagerMaps();
    }

    public boolean objectPopupMenu(NamedType namedType, LocalPt localPt) {
        if (namedType instanceof JunctionElement) {
            return this.objectPopupMenu((JunctionElement)namedType, localPt);
        }
        if (namedType instanceof ReachElement) {
            return this.objectPopupMenu((ReachElement)namedType, localPt);
        }
        if (namedType instanceof ReservoirElement) {
            return this.objectPopupMenu((ReservoirElement)namedType, localPt);
        }
        if (namedType instanceof DiversionElement) {
            return this.objectPopupMenu((DiversionElement)namedType, localPt);
        }
        if (namedType instanceof DivertedOutletElement) {
            return this.objectPopupMenu((DivertedOutletElement)namedType, localPt);
        }
        return false;
    }

    public boolean objectPopupMenu(JunctionElement junctionElement, LocalPt localPt) {
        this._selectedObjects.removeAllElements();
        this._selectedObjects.addElement(junctionElement);
        boolean bl = true;
        if (junctionElement.getComputationPointId() != Long.MIN_VALUE) {
            bl = false;
        }
        String string = "Junction";
        JPopupMenu jPopupMenu = new JPopupMenu(junctionElement.getName());
        boolean bl2 = this.a.isSelected();
        Object object = new RmaJMenuLabel(junctionElement.getName());
        jPopupMenu.add((JMenuItem)object);
        jPopupMenu.addSeparator();
        object = new JMenuItem((bl2 ? "Edit " : "View ") + string + " Properties");
        Font font = ((Component)object).getFont();
        ((JComponent)object).setFont(new Font(font.getName(), 1, font.getSize()));
        ((Component)object).setName(junctionElement.getName());
        ((AbstractButton)object).addActionListener((ActionListener)((Object)this));
        jPopupMenu.add((JMenuItem)object);
        jPopupMenu.addSeparator();
        object = new JMenuItem("Rename " + string + "...");
        ((JMenuItem)object).setEnabled(bl2 && bl);
        ((Component)object).setName(junctionElement.getName());
        ((AbstractButton)object).addActionListener((ActionListener)((Object)this));
        jPopupMenu.add((JMenuItem)object);
        object = new JMenuItem("Delete " + string);
        ((JMenuItem)object).setEnabled(bl2);
        ((Component)object).setName(junctionElement.getName());
        ((AbstractButton)object).addActionListener((ActionListener)((Object)this));
        jPopupMenu.add((JMenuItem)object);
        jPopupMenu.addSeparator();
        this.a(jPopupMenu, bl2);
        object = new JMenuItem("Import Properties...");
        ((AbstractButton)object).addActionListener((ActionListener)((Object)this));
        ((JMenuItem)object).setEnabled(bl2);
        jPopupMenu.add((JMenuItem)object);
        object = new JMenuItem("Connectivity");
        ((AbstractButton)object).addActionListener((ActionListener)((Object)this));
        jPopupMenu.show((Component)this._frame.getMapPanel().viewport(), localPt.x, localPt.y);
        return true;
    }

    private void a(JPopupMenu jPopupMenu, boolean bl) {
        Object object2 = (NamedType[])ClientApp.frame().getMapPanel().findGlyphOfClass(RssSystemGlyph.class.getName(), false);
        if (object2 != null && (object2 = ((RssSystemGlyph)object2).getSelections()) != null && ((NamedType[])object2).length > 1) {
            object2 = new JMenuItem("Delete Selected Network Elements...");
            ((JMenuItem)object2).setEnabled(bl);
            ((Component)object2).setName("DeleteSelectedElements");
            ((AbstractButton)object2).addActionListener(object -> {
                object = this;
                Object object2 = (NamedType[])ClientApp.frame().getMapPanel().findGlyphOfClass(RssSystemGlyph.class.getName(), false);
                if (object2 != null) {
                    Object object3;
                    Object object4;
                    String[] stringArray;
                    object2 = ((RssSystemGlyph)object2).getSelections();
                    DeleteSelectedElementsDialog deleteSelectedElementsDialog = new DeleteSelectedElementsDialog((Frame)((RSimNetworkMode)object)._frame, true);
                    Object[] objectArray = object2;
                    if (object2 == null) {
                        stringArray = new String[]{};
                    } else {
                        object4 = new String[objectArray.length];
                        for (int i = 0; i < objectArray.length; ++i) {
                            if (objectArray[i] instanceof JunctionElement) {
                                JunctionElement junctionElement = (JunctionElement)objectArray[i];
                                object3 = junctionElement.getConnectedElements();
                                Iterator iterator = object3.iterator();
                                while (iterator.hasNext()) {
                                    Element element = (Element)iterator.next();
                                    for (int j = 0; j < objectArray.length; ++j) {
                                        if (objectArray[j] != element) continue;
                                        iterator.remove();
                                    }
                                }
                                if (object3.isEmpty()) continue;
                                boolean bl = object3.size() > 1;
                                StringBuilder stringBuilder = new StringBuilder();
                                stringBuilder.append("<html>Need to also delete the ");
                                stringBuilder.append(bl ? "Elements" : "Element");
                                stringBuilder.append(" that ");
                                stringBuilder.append(bl ? "are" : "is");
                                stringBuilder.append(" connected to ");
                                stringBuilder.append(junctionElement.getName());
                                stringBuilder.append(". The following ");
                                stringBuilder.append(bl ? "Elements " : "Element ");
                                stringBuilder.append(bl ? "are" : "is");
                                stringBuilder.append(" not selected to be deleted:");
                                stringBuilder.append("<br>");
                                for (int j = 0; j < object3.size(); ++j) {
                                    stringBuilder.append(((Element)object3.get(j)).getElementType());
                                    stringBuilder.append(": ");
                                    stringBuilder.append(((Element)object3.get(j)).getName());
                                    stringBuilder.append("<br>");
                                }
                                stringBuilder.append("</html>");
                                object4[i] = stringBuilder.toString();
                                continue;
                            }
                            object4[i] = null;
                        }
                        stringArray = object4;
                    }
                    objectArray = stringArray;
                    deleteSelectedElementsDialog.fillForm((NamedType[])object2, (String[])objectArray);
                    deleteSelectedElementsDialog.setVisible(true);
                    if (!deleteSelectedElementsDialog.isCanceled()) {
                        object2 = deleteSelectedElementsDialog.getSelectedElements();
                        Object object5 = object;
                        object = object2;
                        objectArray = object5;
                        if (object != null) {
                            object4 = new NetworkElementDeleteComparator();
                            object.sort(object4);
                            for (int i = 0; i < object.size(); ++i) {
                                Element element = (Element)object.get(i);
                                if (element instanceof JunctionElement) {
                                    object3 = (JunctionElement)element;
                                    objectArray.deleteJunction(object3.getName(), false);
                                    continue;
                                }
                                if (element instanceof ReachElement) {
                                    object3 = (ReachElement)element;
                                    objectArray.deleteReach(object3.getName(), false);
                                    continue;
                                }
                                if (element instanceof DiversionElement) {
                                    object3 = (DiversionElement)element;
                                    objectArray.deleteDiversion(object3.getName(), false);
                                    continue;
                                }
                                if (element instanceof DivertedOutletElement) {
                                    object3 = (DivertedOutletElement)element;
                                    objectArray.deleteDivertedOutlet(object3.getName(), false);
                                    continue;
                                }
                                if (!(element instanceof ReservoirElement)) continue;
                                object3 = (ReservoirElement)element;
                                objectArray.deleteReservoir(object3.getName(), false);
                            }
                        }
                    }
                }
            });
            jPopupMenu.add((JMenuItem)object2);
            jPopupMenu.addSeparator();
        }
    }

    public boolean objectPopupMenu(ReachElement reachElement, LocalPt localPt) {
        this._selectedObjects.removeAllElements();
        this._selectedObjects.addElement(reachElement);
        this.g = localPt;
        boolean bl = this.a.isSelected();
        String string = "Reach";
        JPopupMenu jPopupMenu = new JPopupMenu(reachElement.getName());
        Object object = new RmaJMenuLabel(reachElement.getName());
        jPopupMenu.add((JMenuItem)object);
        jPopupMenu.addSeparator();
        object = new JMenuItem((bl ? "Edit " : "View ") + string + " Properties");
        Font font = ((Component)object).getFont();
        ((JComponent)object).setFont(new Font(font.getName(), 1, font.getSize()));
        ((Component)object).setName(reachElement.getName());
        ((AbstractButton)object).addActionListener((ActionListener)((Object)this));
        jPopupMenu.add((JMenuItem)object);
        jPopupMenu.addSeparator();
        object = new JMenuItem("Rename " + string + "...");
        ((JMenuItem)object).setEnabled(bl);
        ((Component)object).setName(reachElement.getName());
        ((AbstractButton)object).addActionListener((ActionListener)((Object)this));
        jPopupMenu.add((JMenuItem)object);
        object = new JMenuItem("Break " + string);
        ((JMenuItem)object).setEnabled(bl);
        ((Component)object).setName(reachElement.getName());
        ((AbstractButton)object).addActionListener((ActionListener)((Object)this));
        jPopupMenu.add((JMenuItem)object);
        object = new JMenuItem("Delete " + string);
        ((JMenuItem)object).setEnabled(bl);
        ((Component)object).setName(reachElement.getName());
        ((AbstractButton)object).addActionListener((ActionListener)((Object)this));
        jPopupMenu.add((JMenuItem)object);
        jPopupMenu.addSeparator();
        this.a(jPopupMenu, bl);
        object = new JMenuItem("Import Properties...");
        ((AbstractButton)object).addActionListener((ActionListener)((Object)this));
        ((JMenuItem)object).setEnabled(bl);
        jPopupMenu.add((JMenuItem)object);
        object = new JMenuItem("Connectivity");
        ((AbstractButton)object).addActionListener((ActionListener)((Object)this));
        jPopupMenu.show((Component)this._frame.getMapPanel().viewport(), localPt.x, localPt.y);
        return true;
    }

    public boolean objectPopupMenu(ReservoirElement reservoirElement, LocalPt localPt) {
        this._selectedObjects.removeAllElements();
        this._selectedObjects.addElement(reservoirElement);
        boolean bl = true;
        if (reservoirElement.getReservoirProjectId() != Long.MIN_VALUE) {
            bl = false;
        }
        String string = "Reservoir";
        boolean bl2 = this.a.isSelected();
        JPopupMenu jPopupMenu = new JPopupMenu(reservoirElement.getName());
        Object object = new RmaJMenuLabel(reservoirElement.getName());
        jPopupMenu.add((JMenuItem)object);
        jPopupMenu.addSeparator();
        object = new JMenuItem((bl2 ? "Edit " : "View ") + string + " Properties");
        Font font = ((Component)object).getFont();
        ((JComponent)object).setFont(new Font(font.getName(), 1, font.getSize()));
        ((Component)object).setName(reservoirElement.getName());
        ((AbstractButton)object).addActionListener((ActionListener)((Object)this));
        jPopupMenu.add((JMenuItem)object);
        jPopupMenu.addSeparator();
        object = new JMenuItem("Rename " + string + "...");
        ((Component)object).setName(reservoirElement.getName());
        ((AbstractButton)object).addActionListener((ActionListener)((Object)this));
        ((JMenuItem)object).setEnabled(bl2 && bl);
        jPopupMenu.add((JMenuItem)object);
        object = new JMenuItem("Delete " + string);
        ((JMenuItem)object).setEnabled(bl2);
        ((Component)object).setName(reservoirElement.getName());
        ((AbstractButton)object).addActionListener((ActionListener)((Object)this));
        jPopupMenu.add((JMenuItem)object);
        jPopupMenu.addSeparator();
        this.a(jPopupMenu, bl2);
        object = new JMenuItem("Import Properties...");
        ((AbstractButton)object).addActionListener((ActionListener)((Object)this));
        ((JMenuItem)object).setEnabled(bl2);
        jPopupMenu.add((JMenuItem)object);
        object = new JMenuItem("Connectivity");
        ((AbstractButton)object).addActionListener((ActionListener)((Object)this));
        jPopupMenu.show((Component)this._frame.getMapPanel().viewport(), localPt.x, localPt.y);
        return true;
    }

    public boolean objectPopupMenu(DiversionElement diversionElement, LocalPt localPt) {
        this._selectedObjects.removeAllElements();
        this._selectedObjects.addElement(diversionElement);
        boolean bl = this.a.isSelected();
        boolean bl2 = true;
        if (diversionElement.getDiversionProjectId() != Long.MIN_VALUE) {
            bl2 = false;
        }
        String string = "Diversion";
        JPopupMenu jPopupMenu = new JPopupMenu(diversionElement.getName());
        Object object = new RmaJMenuLabel(diversionElement.getName());
        jPopupMenu.add((JMenuItem)object);
        jPopupMenu.addSeparator();
        object = new JMenuItem((bl ? "Edit " : "View ") + string + " Properties");
        Font font = ((Component)object).getFont();
        ((JComponent)object).setFont(new Font(font.getName(), 1, font.getSize()));
        ((Component)object).setName(diversionElement.getName());
        ((AbstractButton)object).addActionListener((ActionListener)((Object)this));
        jPopupMenu.add((JMenuItem)object);
        jPopupMenu.addSeparator();
        object = new JMenuItem("Rename " + string + "...");
        ((JMenuItem)object).setEnabled(bl && bl2);
        ((Component)object).setName(diversionElement.getName());
        ((AbstractButton)object).addActionListener((ActionListener)((Object)this));
        jPopupMenu.add((JMenuItem)object);
        object = new JMenuItem("Delete " + string);
        ((JMenuItem)object).setEnabled(bl);
        ((Component)object).setName(diversionElement.getName());
        ((AbstractButton)object).addActionListener((ActionListener)((Object)this));
        jPopupMenu.add((JMenuItem)object);
        this.a(jPopupMenu, bl);
        if (((Element)diversionElement).getDownstreamNode() != null) {
            object = new JMenuItem("Disconnect Outflow");
            ((Component)object).setName(diversionElement.getName());
            ((JMenuItem)object).setEnabled(bl && bl2);
            ((AbstractButton)object).addActionListener((ActionListener)((Object)this));
            jPopupMenu.add((JMenuItem)object);
        }
        jPopupMenu.addSeparator();
        object = new JMenuItem("Import Properties...");
        ((AbstractButton)object).addActionListener((ActionListener)((Object)this));
        ((JMenuItem)object).setEnabled(bl);
        jPopupMenu.add((JMenuItem)object);
        object = new JMenuItem("Connectivity");
        ((AbstractButton)object).addActionListener((ActionListener)((Object)this));
        jPopupMenu.show((Component)this._frame.getMapPanel().viewport(), localPt.x, localPt.y);
        return true;
    }

    public boolean objectPopupMenu(DivertedOutletElement divertedOutletElement, LocalPt localPt) {
        this._selectedObjects.removeAllElements();
        this._selectedObjects.addElement(divertedOutletElement);
        boolean bl = this.a.isSelected();
        boolean bl2 = true;
        if (divertedOutletElement.getDiversionProjectId() != Long.MIN_VALUE) {
            bl2 = false;
        }
        String string = "Diverted Outlet";
        String string2 = divertedOutletElement.getParent().getName() + "-" + divertedOutletElement.getName();
        JPopupMenu jPopupMenu = new JPopupMenu(string2);
        Object object = new RmaJMenuLabel(string2);
        jPopupMenu.add((JMenuItem)object);
        jPopupMenu.addSeparator();
        object = new JMenuItem((bl ? "Edit " : "View ") + string + " Properties");
        Font font = ((Component)object).getFont();
        ((JComponent)object).setFont(new Font(font.getName(), 1, font.getSize()));
        ((Component)object).setName(string2);
        ((AbstractButton)object).addActionListener((ActionListener)((Object)this));
        jPopupMenu.add((JMenuItem)object);
        jPopupMenu.addSeparator();
        object = new JMenuItem("Rename " + string + "...");
        ((JMenuItem)object).setEnabled(bl && bl2);
        ((Component)object).setName(string2);
        ((AbstractButton)object).addActionListener((ActionListener)((Object)this));
        jPopupMenu.add((JMenuItem)object);
        object = new JMenuItem("Delete " + string);
        ((JMenuItem)object).setEnabled(bl);
        ((Component)object).setName(string2);
        ((AbstractButton)object).addActionListener((ActionListener)((Object)this));
        jPopupMenu.add((JMenuItem)object);
        this.a(jPopupMenu, bl);
        if (((Element)divertedOutletElement).getDownstreamNode() != null) {
            object = new JMenuItem("Disconnect " + string);
            ((Component)object).setName(string2);
            ((JMenuItem)object).setEnabled(bl && bl2);
            ((AbstractButton)object).addActionListener((ActionListener)((Object)this));
            jPopupMenu.add((JMenuItem)object);
        }
        jPopupMenu.addSeparator();
        object = new JMenuItem("Import Properties...");
        ((AbstractButton)object).addActionListener((ActionListener)((Object)this));
        ((JMenuItem)object).setEnabled(bl);
        jPopupMenu.add((JMenuItem)object);
        object = new JMenuItem("Connectivity");
        ((AbstractButton)object).addActionListener((ActionListener)((Object)this));
        jPopupMenu.show((Component)this._frame.getMapPanel().viewport(), localPt.x, localPt.y);
        return true;
    }

    public boolean objectDoubleClick(NamedType namedType, LocalPt localPt) {
        this._selectedObjects.removeAllElements();
        this._selectedObjects.addElement(namedType);
        if (namedType instanceof JunctionElement) {
            this.editJunction(namedType.getName());
        } else if (namedType instanceof ReachElement) {
            this.editReach(namedType.getName());
        } else if (namedType instanceof ReservoirElement) {
            this.editReservoir(namedType.getName());
        } else if (namedType instanceof DiversionElement) {
            this.editDiversion(namedType.getName());
        } else if (namedType instanceof DiversionElement) {
            this.editReservoir(namedType.getName());
        }
        return false;
    }

    public void renameElement(Element element, String string) {
        if (this.d == null || element == null) {
            return;
        }
        NameDialog nameDialog = new NameDialog((Frame)this._frame, true);
        nameDialog.setNameFieldDocument((Document)new DssPathnamePartDocument());
        nameDialog.setName(element.getName());
        nameDialog.setDescription(element.getDescription());
        nameDialog.setTitle(string);
        nameDialog.setExistingNames((List)this.d.getElementVector());
        nameDialog.setVisible(true);
        if (nameDialog.isCanceled()) {
            return;
        }
        element.setName(nameDialog.getName());
        element.setDescription(nameDialog.getDescription());
        this.d.setModified(true);
        this._frame.getMapPanel().paintMap();
    }

    public void breakReach(String string) {
        if (this.d == null || this.g == null) {
            return;
        }
        ReachElement reachElement = this.d.findReach(string);
        if (reachElement == null) {
            return;
        }
        int n = JOptionPane.showConfirmDialog((Component)this._frame, "Break Reach " + string + "?", "Confirm break", 0, 3);
        if (n != 0) {
            return;
        }
        Object object = new NameDialog((Frame)this._frame, true);
        object.setName(this.d.getNextDefaultName(2));
        object.setDescription("");
        object.setTitle("Name New Junction");
        object.setVisible(true);
        if (object.isCanceled()) {
            return;
        }
        String string2 = object.getName();
        String string3 = object.getDescription();
        object = this.d.newJunctionElement(string2);
        if (object == null) {
            this.d.printMessage("Failed to create Junction, cannot break reach");
            return;
        }
        object.setDescription(string3);
        string2 = this._frame.getMapPanel().scale().lp2wp(this.g);
        this.d.breakReach(reachElement, (WorldPt)string2, (JunctionElement)object);
    }

    public void deleteReach(String string, boolean bl) {
        if (this.d == null) {
            return;
        }
        int n = 0;
        if (bl) {
            n = JOptionPane.showConfirmDialog((Component)this._frame, "Delete Reach " + string + "?", "Confirm Delete", 0, 3);
        }
        if (n == 0) {
            RssSystemGlyph rssSystemGlyph = (RssSystemGlyph)this._frame.getMapPanel().findGlyphOfClass(RssSystemGlyph.class.getName());
            if (rssSystemGlyph != null) {
                rssSystemGlyph.clearSelection(string);
            }
            this.d.deleteReach(string);
            this._frame.getMapPanel().paintMap();
        }
    }

    public void deleteJunction(String string, boolean bl) {
        if (this.d == null) {
            return;
        }
        JunctionElement junctionElement = this.d.findJunction(string);
        if (junctionElement == null) {
            return;
        }
        if (junctionElement.hasConnectedElements()) {
            JOptionPane.showMessageDialog((Component)this._frame, "Cannot delete Junction " + string + " because it is connected to other elements.\nDelete connected elements first.", "", 1);
            return;
        }
        int n = 0;
        if (bl) {
            String string2 = junctionElement.getComputationPointId() != Long.MIN_VALUE ? "Junction " + string + " is associated with a Common Computation Point,\nare you sure you want to delete it?" : "Delete Junction " + string + "?";
            n = JOptionPane.showConfirmDialog((Component)this._frame, string2, "Confirm Delete", 0, 3);
        }
        if (n == 0) {
            RssSystemGlyph rssSystemGlyph = (RssSystemGlyph)this._frame.getMapPanel().findGlyphOfClass(RssSystemGlyph.class.getName());
            if (rssSystemGlyph != null) {
                rssSystemGlyph.clearSelection(string);
            }
            this.d.deleteJunction(string);
            this._frame.getMapPanel().paintMap();
        }
    }

    public void deleteReservoir(String string, boolean bl) {
        if (this.d == null) {
            return;
        }
        ReservoirElement reservoirElement = this.d.findReservoir(string);
        if (reservoirElement == null) {
            return;
        }
        int n = 0;
        if (bl) {
            String string2 = reservoirElement.getReservoirProjectId() != Long.MIN_VALUE ? "Reservoir " + string + " is associated with the Watershed Configuration,\nare you sure you want to delete it?" : "Delete Reservoir " + string + "?";
            n = JOptionPane.showConfirmDialog((Component)this._frame, string2, "Confirm Delete", 0, 3);
        }
        if (n == 0) {
            RssSystemGlyph rssSystemGlyph = (RssSystemGlyph)this._frame.getMapPanel().findGlyphOfClass(RssSystemGlyph.class.getName());
            if (rssSystemGlyph != null) {
                rssSystemGlyph.clearSelection(string);
            }
            this.d.deleteReservoir(string);
            this._frame.getMapPanel().paintMap();
        }
    }

    @Override
    public void editDivertedOutlet(String string) {
        if (this.d == null) {
            return;
        }
        DivertedOutletElement divertedOutletElement = this.d.findDivertedOutlet(string);
        if (divertedOutletElement != null) {
            this.editReservoir(divertedOutletElement.getParent().getName());
            return;
        }
        System.out.println("editDivertedOutlet:failed to find DivertedOutlet " + string + " in network " + this.d.getName());
    }

    public void disconnectDivertedOutlet(String object) {
        if (this.d == null) {
            return;
        }
        if ((object = this.d.findDivertedOutlet((String)object)) == null) {
            return;
        }
        if (((DivertedOutletElement)object).getDiversionProjectId() != Long.MIN_VALUE) {
            JOptionPane.showMessageDialog((Component)this._frame, "This diverted outlet is associated with a Watershed Diversion Project.\nPlease edit the diversion in the Watershed Setup Module, then update this Network", "ResSim Message", 1);
            return;
        }
        RssNode rssNode = ((Element)object).getDownstreamNode();
        if (rssNode != null) {
            ((Element)object).removeNode(rssNode);
            JunctionElement junctionElement = this.d.findJunction(rssNode.getLocation(), 1.0);
            if (junctionElement != null) {
                junctionElement.removeNode(rssNode);
            }
            rssNode = new WorldPt(rssNode.getLocation());
            ((WorldPt)rssNode).n += 10.0;
            ((WorldPt)rssNode).e += 10.0;
            ((DivertedOutletElement)object).getLine().getLastPt().init((WorldPt)rssNode);
            this._frame.getMapPanel().paintMap();
        }
    }

    public void deleteDivertedOutlet(String object, boolean n) {
        int n2;
        Object object2;
        if (this.d == null) {
            return;
        }
        DivertedOutletElement divertedOutletElement = this.d.findDivertedOutlet((String)object);
        if (divertedOutletElement == null) {
            return;
        }
        int n3 = 0;
        ArrayList<OpRule> arrayList = new ArrayList<OpRule>();
        Object object3 = divertedOutletElement.getParent();
        if (object3 instanceof ReservoirElement) {
            object2 = (ReservoirElement)object3;
            object3 = ((ReservoirElement)object2).findRulesFor(divertedOutletElement);
            arrayList.addAll((Collection<OpRule>)object3);
            n2 = divertedOutletElement.getChildElementCount();
            for (int i = 0; i < n2; ++i) {
                object3 = divertedOutletElement.getChildElementAt(i);
                object3 = ((ReservoirElement)object2).findRulesFor((Element)object3);
                arrayList.addAll((Collection<OpRule>)object3);
            }
        }
        if (n != 0) {
            object2 = divertedOutletElement.getDiversionProjectId() != Long.MIN_VALUE ? "<html>Diverted Outlet " + (String)object + " is associated with the Watershed Configuration,<br>are you sure you want to delete it?" : "<html>Delete Diverted Outlet " + (String)object + "?";
            if (arrayList.size() > 0) {
                object3 = new StringBuilder();
                n2 = arrayList.size();
                if (n2 > 0) {
                    System.out.println("deleteTreeNode:rules=" + String.valueOf(arrayList));
                    ((StringBuilder)object3).append("<br><br>The following rule" + (n2 > 1 ? "s" : "") + " will also be deleted:");
                    for (n = 0; n < n2; ++n) {
                        object = (OpRule)arrayList.get(n);
                        ((StringBuilder)object3).append("<br>");
                        ((StringBuilder)object3).append(object.getName());
                    }
                    ((StringBuilder)object3).append("</html>");
                }
                if (((StringBuilder)object3).length() > 0) {
                    object2 = (String)object2 + String.valueOf(object3);
                }
            }
            n3 = JOptionPane.showConfirmDialog((Component)this._frame, object2, "Confirm Delete", 0, 3);
        }
        if (n3 == 0) {
            object2 = (RssSystemGlyph)this._frame.getMapPanel().findGlyphOfClass(RssSystemGlyph.class.getName());
            if (object2 != null) {
                ((RssSystemGlyph)object2).clearSelection(divertedOutletElement);
            }
            divertedOutletElement.getParent().removeChild(divertedOutletElement);
            this.d.cleanVectors();
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                object3 = (OpRule)arrayList.get(n2);
                this.deleteRule((OpRule)object3);
            }
            this._frame.getMapPanel().paintMap();
        }
    }

    public void deleteRule(OpRule opRule) {
        RssReturnStatusConstants rssReturnStatusConstants;
        int n;
        Vector<OpSet> vector;
        if (opRule == null) {
            return;
        }
        int n2 = opRule.getIndex();
        OpController opController = opRule.getController();
        ElementOp elementOp = opController.getElementOp();
        elementOp.deleteOpRule(opRule);
        if (!(opRule instanceof DownstreamOpRule) || opRule instanceof DownstreamCntrlOpRule) {
            vector = elementOp.getOperationSets();
            if (vector == null) {
                return;
            }
            for (n = 0; n < vector.size(); ++n) {
                rssReturnStatusConstants = vector.elementAt(n);
                rssReturnStatusConstants.removeAllRuleRef(opController.getIndex(), n2);
            }
            opController.deleteRule(n2);
        }
        if (opRule instanceof DownstreamOpRule) {
            int n3 = opRule.getIndex();
            if (opRule instanceof DownstreamCntrlOpRule) {
                n3 = ((DownstreamCntrlOpRule)opRule).getParentRuleIndex();
            }
            n = ((DownstreamOpRule)opRule).getDownstreamControlLocationID();
            rssReturnStatusConstants = elementOp.getOperationsElement().getSystem();
            ((RssSystem)rssReturnStatusConstants).deleteDownstreamOpRule(n, n3);
            return;
        }
        if (opRule instanceof SystemHydropowerOpRule) {
            vector = elementOp.getOperationsElement().getSystem();
            ((RssSystem)((Object)vector)).deleteSystemHydropowerRule(((SystemHydropowerOpRule)opRule).getParentRuleIndex());
            return;
        }
        if (opRule instanceof TandemSysOpRule) {
            vector = elementOp.getOperationsElement().getSystem();
            ((RssSystem)((Object)vector)).deleteTandemOpParent(((TandemSysOpRule)opRule).getParentIndex());
        }
    }

    public void disconnectOutFlow(String object) {
        if (this.d == null) {
            return;
        }
        if ((object = this.d.findDiversion((String)object)) == null) {
            return;
        }
        if (((DiversionElement)object).getDiversionProjectId() != Long.MIN_VALUE) {
            JOptionPane.showMessageDialog((Component)this._frame, "This diversion is associated with a Watershed Diversion Project.\nPlease edit the diversion in the Watershed Setup Module, then update this Network", "ResSim Message", 1);
            return;
        }
        RssNode rssNode = ((Element)object).getDownstreamNode();
        if (rssNode != null) {
            ((DiversionElement)object).disconnectDownstream(10.0, 10.0);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void deleteDiversion(String string, boolean bl) {
        void var2_8;
        if (this.d == null) {
            return;
        }
        DiversionElement diversionElement = this.d.findDiversion(string);
        if (diversionElement == null) {
            return;
        }
        if (bl) {
            void var2_5;
            if (diversionElement.getDiversionProjectId() != Long.MIN_VALUE) {
                String string2 = "Diversion " + string + " is associated with the Watershed Configuration,\nare you sure you want to delete it?";
            } else {
                String rssSystemGlyph = "Delete Diversion " + string + "?";
            }
            int n = JOptionPane.showConfirmDialog((Component)this._frame, var2_5, "Confirm Delete", 0, 3);
        } else {
            boolean bl2 = false;
        }
        if (var2_8 == false) {
            RssSystemGlyph rssSystemGlyph = (RssSystemGlyph)this._frame.getMapPanel().findGlyphOfClass(RssSystemGlyph.class.getName());
            if (rssSystemGlyph != null) {
                rssSystemGlyph.clearSelection(string);
            }
            this.d.deleteDiversion(string);
            this._frame.getMapPanel().paintMap();
        }
    }

    public void updateWorkspace() {
        super.updateWorkspace();
        this.updateManagerMaps();
    }

    public void resetWorkspace() {
        super.resetWorkspace();
        this.b(false);
        this.u.setEditable(false);
        this.x.setEditable(false);
        ClientWorkspace clientWorkspace = ClientApp.Workspace();
        if (clientWorkspace == null) {
            return;
        }
        this.d = null;
        this.e = null;
        if (!this.c(false)) {
            return;
        }
        this.b(false);
        super.resetWorkspace();
        RssSystemDPData.a();
    }

    public void updateManagerMaps() {
        if (this._frame.getCurrentMode() != this) {
            return;
        }
        if (this.d != null) {
            if (this.d.isModified()) {
                this.u.setText(this.d.getName() + "*");
            } else {
                this.u.setText(this.d.getName());
            }
            this.u.setCaretPosition(0);
            Object object = this.d.getConfiguration();
            if (object != null) {
                this.x.setText(object.getName());
            } else {
                this.x.setText("none");
            }
            this.x.setCaretPosition(0);
            object = this.d.getDescription();
            this.c((String)object);
            this.a.setSelected(true);
            this.editConfiguration();
            this.z.setEnabled(true);
            this.A.setEnabled(true);
            this.B.setEnabled(true);
            this.C.setEnabled(true);
            this.E.setEnabled(true);
            this.D.setEnabled(true);
            this.F.setEnabled(true);
            this.R.setEnabled(true);
            this.G.setEnabled(true);
            this.p.setEnabled(true);
            this.a.setEnabled(true);
        } else {
            this.u.setText("none");
            this.c(null);
            this.x.setText("none");
            this.k.setEnabled(false);
            this.o.setEnabled(false);
            this.n.setEnabled(false);
            this.s.setEnabled(false);
            this.m.setEnabled(false);
            this.q.setEnabled(true);
            this.z.setEnabled(false);
            this.A.setEnabled(false);
            this.B.setEnabled(false);
            this.C.setEnabled(false);
            this.D.setEnabled(false);
            this.E.setEnabled(false);
            this.F.setEnabled(false);
            this.G.setEnabled(false);
            this.R.setEnabled(false);
            this.p.setEnabled(false);
            this.a.setEnabled(false);
            this.l.setEnabled(false);
        }
        this.addManagerMaps();
        this._frame.getMapPanel().paintMap();
    }

    protected void b() {
        this.updateAltInputReportMenu();
    }

    public void updateAltInputReportMenu() {
        ClientWorkspace clientWorkspace = ClientApp.Workspace();
        Vector vector = clientWorkspace.getManagerIDList(MODELNAME, RssAlt.class.getName());
        this.r.removeAll();
        for (int i = 0; i < vector.size(); ++i) {
            Object object = (Identifier)vector.get(i);
            if ((object = (RssAlt)clientWorkspace.openManager(MODELNAME, (Identifier)object)) == null || object == null || ((RssAlt)object).getSystemIndex() == -1 || ((RssAlt)object).getSystemIndex() != this.d.getIndex()) continue;
            object = new JMenuItem(object.getName());
            ((AbstractButton)object).setActionCommand("altInputReportAction");
            ((AbstractButton)object).addActionListener((ActionListener)((Object)this));
            this.r.add((JMenuItem)object);
        }
    }

    private void c(String object) {
        if (object == null || ((String)object).length() == 0) {
            if (this.d == null) {
                this.u.setToolTipText("Active Reservoir Network Name");
                return;
            }
            this.u.setToolTipText(this.d.getName());
            return;
        }
        object = RMAIO.toHtmlString((String)object);
        object = ((String)object).substring(6);
        object = "<html><b>" + this.d.getName() + "</b><br><hr>" + (String)object;
        this.u.setToolTipText((String)object);
    }

    public void addManagerMaps() {
        Vector<Object> vector = new Vector<Object>();
        if (this.e != null) {
            vector.addElement(this.e);
        }
        if (this.d != null) {
            vector.addElement(this.d);
        }
        this._frame.getMapPanel().resetManagerMaps(vector);
        this._frame.setGlyphStateFromToolbar();
    }

    public DefaultJPanel[] getModuleOptionsPanels() {
        ClientApp.Workspace();
        DefaultJPanel[] defaultJPanelArray = super.getModuleOptionsPanels();
        int n = defaultJPanelArray != null ? defaultJPanelArray.length : 0;
        int n2 = n + 1;
        DefaultJPanel[] defaultJPanelArray2 = new DefaultJPanel[n2];
        for (int i = 0; i < n; ++i) {
            defaultJPanelArray2[i] = defaultJPanelArray[i];
        }
        if (this.h == null) {
            this.h = new ResSimAdvancedOptionsPanel();
        }
        defaultJPanelArray2[defaultJPanelArray2.length - 1] = this.h;
        return defaultJPanelArray2;
    }

    @Override
    public void updateGUIState(boolean bl) {
        if (this.M != null && this.M.isVisible()) {
            this.M.setEditable(bl);
        }
        if (this.K != null && this.K.isVisible()) {
            this.K.setEditable(bl);
        }
        if (this.N != null && this.N.isVisible()) {
            this.N.setEditable(bl);
        }
        if (this.L != null && this.L.isVisible()) {
            this.L.setEditable(bl);
        }
        if (this.i != null && this.i.isVisible()) {
            this.i.setEditable(bl);
        }
        this.k.setEnabled(bl);
        this.o.setEnabled(bl);
        this.n.setEnabled(bl);
        this.s.setEnabled(bl);
        this.m.setEnabled(bl);
        this.q.setEnabled(bl);
        this.l.setEnabled(true);
    }

    public void notify(String object) {
        if (!this.a.isSelected()) {
            return;
        }
        System.out.println((String)object);
        object = new StringTokenizer((String)object, "|");
        if (((StringTokenizer)object).countTokens() < 3) {
            return;
        }
        String string = ((StringTokenizer)object).nextToken();
        String string2 = ((StringTokenizer)object).nextToken();
        object = ((StringTokenizer)object).nextToken();
        if (!string2.equalsIgnoreCase("unlocked") || ((String)object).equals(ClientApp.app().getUser())) {
            return;
        }
        object = new RSimNetworkMode$1(this, string, (String)object);
        SwingUtilities.invokeLater((Runnable)object);
    }

    public boolean workspaceClosing() {
        super.workspaceClosing();
        if (this.a.isSelected() && !this.lockConfiguration(false)) {
            return false;
        }
        if (this.e != null) {
            this.e.setLocked(1);
        }
        return true;
    }

    public void modeClosing() {
        if (this.M != null && this.M.isVisible()) {
            this.M.cmdCancel_Action();
        }
        if (this.L != null && this.L.isVisible()) {
            this.L.handleCancelAction();
        }
        if (this.N != null && this.N.isVisible()) {
            this.N.diversionComboChanged();
            this.N.closeDialog();
        }
        if (this.I != null && this.I.isVisible()) {
            this.I.closeDialog();
        }
        if (this.K != null && this.K.isVisible()) {
            this.K.reachChoice_StateChange();
            this.K.closeDialog();
        }
    }

    public boolean canOpen() {
        ClientWorkspace clientWorkspace = ClientApp.Workspace();
        if (clientWorkspace == null) {
            return true;
        }
        if (this.e == null) {
            System.out.println(this.toString() + ".canOpen:Stream Alignment to display");
            return false;
        }
        if (!this.e.setLocked(3) && this._frame.isVisible()) {
            System.out.println(this.toString() + ".canOpen:Unable to display Stream Alignment");
            System.out.println("Unable to display Stream Alignment. Currently being edited.");
            int n = JOptionPane.showOptionDialog((Component)this._frame, "Unable to display Stream Alignment.\nCurrently being edited.", "Lock Failed", 0, 2, null, new Object[]{"OK", "More Info"}, "OK");
            if (n == 0) {
                return false;
            }
            FileLockInfoJDialog fileLockInfoJDialog = new FileLockInfoJDialog((Frame)this._frame);
            RmiFileManager rmiFileManager = (RmiFileManager)ClientApp.app().getFileManager().getRemote();
            fileLockInfoJDialog.setFileManager(rmiFileManager);
            fileLockInfoJDialog.setUserId(ClientApp.app().getUser());
            Vector vector = null;
            try {
                vector = rmiFileManager.getLockers(this.e.getIdentifier());
            }
            catch (RemoteException remoteException) {
                System.out.println("Failed to get Lock info for Stream Alignment " + String.valueOf(remoteException));
            }
            fileLockInfoJDialog.fillForm(this.e.getIdentifier(), vector);
            fileLockInfoJDialog.pack();
            fileLockInfoJDialog.setVisible(true);
            clientWorkspace.unloadManager("main", this.e.getIdentifier());
            return false;
        }
        return true;
    }

    @Override
    public boolean lockConfiguration(boolean bl) {
        Object object = (RmiFileCallBackImpl[])ClientApp.app().getFileManager().getRemote();
        if (bl) {
            if (object == null) {
                return true;
            }
            object = new RmiFileCallBackImpl[1];
            if (this.d != null) {
                RSimNetworkMode rSimNetworkMode = this;
                if (!rSimNetworkMode.lockManager(rSimNetworkMode.d, "Failed to lock Res System", null, this.a, (RmiFileCallBackImpl[])object)) {
                    return false;
                }
                this.v = object[0];
            }
        } else {
            if (this.d != null && this.d.isModified()) {
                int n = JOptionPane.showConfirmDialog((Component)this._frame, "Network has changed. Save Changes?", "Save", 1);
                switch (n) {
                    case 0: {
                        if (this.d == null || !this.d.isModified()) break;
                        this.saveNetwork();
                        break;
                    }
                    case 2: {
                        return false;
                    }
                    default: {
                        try {
                            this._frame.setWaitCursor();
                            this.d.reLoadFile();
                            break;
                        }
                        finally {
                            this._frame.setDefaultCursor();
                        }
                    }
                }
            }
            RSimNetworkMode rSimNetworkMode = this;
            if (!rSimNetworkMode.unlockManager(rSimNetworkMode.d, "failed to unlock Reservoir Network ", this.v, this.a)) {
                return false;
            }
            object = (RssSystemGlyph)this._frame.getMapPanel().findGlyphOfClass(RssSystemGlyph.class.getName());
            if (object != null) {
                ((RssSystemGlyph)object).clearSelection();
            }
            this._frame.getMapPanel().paintMap();
        }
        this.updateGUIState(bl);
        return true;
    }

    public void actionPerformed(ActionEvent object) {
        if ((object = ((EventObject)object).getSource()) instanceof JMenuItem) {
            object = (JMenuItem)object;
            String string = ((Component)object).getName();
            String string2 = ((AbstractButton)object).getText();
            if (string2.equals("Edit Reservoir Properties") || string2.equals("View Reservoir Properties")) {
                this.editReservoir(string);
            } else if (string2.startsWith("Rename Reservoir")) {
                object = this.d.findReservoir(string);
                if (object == null) {
                    return;
                }
                this.renameElement((Element)object, "Rename Reservoir");
            } else if (string2.equals("Delete Reservoir")) {
                this.deleteReservoir(string, true);
            } else if (string2.equals("Edit Reach Properties") || string2.equals("View Reach Properties")) {
                object = string;
                this.editReach((String)object);
            } else if (string2.startsWith("Rename Reach")) {
                object = this.d.findReach(string);
                if (object == null) {
                    return;
                }
                this.renameElement((Element)object, "Rename Reach");
            } else if (string2.equals("Break Reach")) {
                this.breakReach(string);
            } else if (string2.equals("Delete Reach")) {
                this.deleteReach(string, true);
            } else if ("editJunction".equals(string)) {
                this.editJunction(null);
            } else if (string2.equals("Edit Junction Properties") || string2.equals("View Junction Properties")) {
                this.editJunction(string);
            } else if (string2.startsWith("Rename Junction")) {
                object = this.d.findJunction(string);
                if (object == null) {
                    return;
                }
                this.renameElement((Element)object, "Rename Junction");
            } else if (string2.equals("Delete Junction")) {
                this.deleteJunction(string, true);
            } else if ("editDiversion".equals(string)) {
                this.editDiversion(null);
            } else if (string2.equals("Edit Diversion Properties") || string2.equals("View Diversion Properties")) {
                this.editDiversion(string);
            } else if (string2.startsWith("Rename Diversion")) {
                object = this.d.findDiversion(string);
                if (object == null) {
                    return;
                }
                this.renameElement((Element)object, "Rename Diversion");
            } else if (string2.equals("Delete Diversion")) {
                this.deleteDiversion(string, true);
            } else if (string2.equals("Disconnect Outflow")) {
                this.disconnectOutFlow(string);
            } else if (string2.equals("Edit Diverted Outlet Properties") || string2.equals("View Diverted Outlet Properties")) {
                this.editDivertedOutlet(string);
            } else if (string2.startsWith("Rename Diverted Outlet")) {
                object = this.d.findDivertedOutlet(string);
                if (object == null) {
                    return;
                }
                this.renameElement((Element)object, "Rename Diverted Outlet");
            } else if (string2.equals("Delete Diverted Outlet")) {
                this.deleteDivertedOutlet(string, true);
            } else if (string2.equals("Disconnect Diverted Outlet")) {
                this.disconnectDivertedOutlet(string);
            } else if ("Import Properties...".equals(string2)) {
                this.importProperties();
            } else if (((AbstractButton)object).getActionCommand().equals("altInputReportAction")) {
                string = string2;
                object = this;
                string2 = ClientApp.Workspace();
                Vector vector = string2.getManagerIDList(MODELNAME, RssAlt.class.getName());
                for (int i = 0; i < vector.size(); ++i) {
                    Object object2 = (Identifier)vector.get(i);
                    if ((object2 = (RssAlt)string2.openManager(MODELNAME, object2)) == null || !object2.getName().equals(string)) continue;
                    object2 = new AlternativeInputReportEditor((JFrame)object.getFrame(), (RssAlt)object2);
                    object2.setLocationRelativeTo((Component)object.getFrame());
                    object2.setVisible(true);
                }
            }
            this._frame.getMapPanel().paintMap();
            this._frame.repaint();
        }
    }

    public ElementListReport displayReservoirList() {
        return ResSimReportsFactory.displayReservoirList(this.getNetwork(), this);
    }

    public ElementListReport displayReachList() {
        return ResSimReportsFactory.displayReachList(this.getNetwork(), this);
    }

    public ElementListReport displayJunctionList() {
        return ResSimReportsFactory.displayJunctionList(this.getNetwork(), this);
    }

    public AlternativeEditor displayAlternativeEditor() {
        return this.displayAlternativeEditor(null);
    }

    public AlternativeEditor displayAlternativeEditor(RssAlt rssAlt) {
        if (ClientApp.Workspace().getManagerIDList(MODELNAME, NETWORK_CLASSNAME).size() <= 0) {
            JOptionPane.showMessageDialog((Component)this._frame, "Please create a Network before creating an Alternative", "No Networks", 2);
            return null;
        }
        try {
            this._frame.setWaitCursor();
            if (this.J == null) {
                this.J = new AlternativeEditor((Frame)this._frame, false);
                this.J.setLocationByPlatform(true);
                this.J.setLocation(this._frame.getX() + this._frame.getWidth() / 4, this._frame.getY() + this._frame.getHeight() / 4);
            }
            this.J.fillForm((ManagerProxyListContainer)ClientApp.Workspace());
            if (rssAlt != null) {
                ((AbstractAlternativeEditor)this.J).setSelectedAlternative(rssAlt.getName());
            } else {
                ((AbstractAlternativeEditor)this.J).setSelectedAlternative(null);
            }
            ((AbstractAlternativeEditor)this.J).setVisible(true);
            this.J.setAlwaysOnTop(true);
            this.J.toFront();
            this.J.requestFocus();
            this.J.setAlwaysOnTop(false);
        }
        finally {
            this._frame.setDefaultCursor();
        }
        return this.J;
    }

    public ElementListReport displayDiversionList() {
        return ResSimReportsFactory.displayDiversionList(this.getNetwork(), this);
    }

    public void displayNodeTable() {
        System.out.println("Opening Node Table");
        if (this.d == null) {
            JOptionPane.showMessageDialog((Component)this._frame, "You must open a Network before opening the Node Table");
            return;
        }
        try {
            this._frame.setWaitCursor();
            if (this.H == null) {
                this.H = new NodeReportDlg();
            }
            this.H.fillForm(this.d);
            this.H.setLocationRelativeTo((Component)this._frame);
            this.H.setVisible(true);
            return;
        }
        finally {
            this._frame.setDefaultCursor();
        }
    }

    public void displayConnectivityTable() {
        System.out.println("Opening Connectivity Table");
        if (this.d == null) {
            JOptionPane.showMessageDialog((Component)this._frame, "You must open a Network before opening the Connectivity Table");
            return;
        }
        try {
            this._frame.setWaitCursor();
            if (this.I == null) {
                this.I = new ConnectivityDlg();
            }
            this.I.fillForm(this.d);
            this.I.setLocationRelativeTo((Component)this._frame);
            this.I.setVisible(true);
            return;
        }
        finally {
            this._frame.setDefaultCursor();
        }
    }

    public void displaySelectedElementsConnectivityTable() {
        Object object = this._frame.getMapPanel().findGlyphOfClass(this.getGlyphClassName());
        if (object == null) {
            return;
        }
        object = object.getSelections();
        object = Arrays.asList(object);
        System.out.println("Opening Connectivity Table");
        if (this.d == null) {
            JOptionPane.showMessageDialog((Component)this._frame, "You must open a Network before opening the Connectivity Table");
            return;
        }
        try {
            this._frame.setWaitCursor();
            if (this.I == null) {
                this.I = new ConnectivityDlg();
            }
            this.I.fillForm((List)object);
            this.I.setLocationRelativeTo((Component)this._frame);
            this.I.setVisible(true);
            return;
        }
        finally {
            this._frame.setDefaultCursor();
        }
    }

    @Override
    public void reportDoubleClicked(int n, String string) {
        switch (n) {
            case 0: {
                this.editReservoir(string);
                return;
            }
            case 1: {
                this.editReach(string);
                return;
            }
            case 2: {
                this.editJunction(string);
                return;
            }
            case 3: {
                this.editDiversion(string);
            }
        }
    }

    public boolean validateManagers() {
        if (!this.isNetworkLocked()) {
            return true;
        }
        int n = this.checkAndSaveManagerChanges(MODELNAME, this.d, NETWORK_CLASSNAME, "Res Network", false);
        return n != 0;
    }

    @Override
    public PopupMenuHandler getPopupMenuHandler() {
        if (this.P == null) {
            this.P = new RSimPopupMenuHandler(this);
        }
        return this.P;
    }

    @Override
    public boolean isNetworkLocked() {
        return this.a.isSelected();
    }

    @Override
    public void editConfiguration() {
        boolean bl = this.a.isSelected();
        if (!this.lockConfiguration(bl)) {
            this.a.setSelected(!bl);
        }
    }

    @Override
    public void editReservoir() {
        Object object = this._frame.getMapPanel().findGlyphOfClass(this.getGlyphClassName());
        if (object == null) {
            return;
        }
        if ((object = object.getSelectedObject()) instanceof ReservoirElement) {
            this.editReservoir(object.getName());
            return;
        }
        object = this.getNetwork();
        if (object == null) {
            RMAIO.postError((Component)this._frame, (String)"Please open/create a network first");
            return;
        }
        if ((object = ((RssSystem)object).getReservoirNames()) == null || ((Object)object).length <= 0) {
            RMAIO.postWarning((Component)this._frame, (String)"No Reservoirs in current Network to edit");
            return;
        }
        this.editReservoir((String)object[0]);
    }

    @Override
    public void editReservoir(String string) {
        RSimNetworkMode rSimNetworkMode = this;
        rSimNetworkMode.editReservoir(rSimNetworkMode.getNetwork(), string, this.hasWriteLock());
    }

    public void editReservoir(RssSystem rssSystem, String string, boolean bl) {
        this._frame.setWaitCursor();
        try {
            boolean bl2 = false;
            if (this.M != null) {
                int n;
                if (this.M.isModified() && (n = RMAIO.postYesNoWarning((Component)((Object)this.M), (String)"Items have changed! Would you like to Save?")) == 0) {
                    this.M.saveForm();
                }
            } else {
                this.M = new ReservoirJFrame((JFrame)AppDaddy.getFrame(), false);
                this.M.setLocationRelativeTo((JFrame)AppDaddy.getFrame());
                bl2 = true;
            }
            if (!this.M.initDlg(rssSystem)) {
                return;
            }
            this.M.setEditable(bl);
            if (string != null) {
                this.M.selectReservoir(string);
            }
            this.M.setVisible(true);
            if (bl2) {
                Dimension dimension = this.M.getSize();
                this.M.setMinimumSize(dimension);
                this.M.setSize(dimension);
            }
            RSimNetworkMode rSimNetworkMode = this;
            rSimNetworkMode.a((Window)((Object)rSimNetworkMode.M));
            return;
        }
        finally {
            this._frame.setDefaultCursor();
            this._frame.repaint();
        }
    }

    @Override
    public void editReach() {
        Object object = this._frame.getMapPanel().findGlyphOfClass(this.getGlyphClassName());
        if (object == null) {
            return;
        }
        if ((object = object.getSelectedObject()) instanceof ReachElement) {
            this.editReach(object.getName());
            return;
        }
        object = this.getNetwork();
        if (object == null) {
            RMAIO.postError((Component)this._frame, (String)"Please open/create a network first");
            return;
        }
        if ((object = ((RssSystem)object).getReachNames()) == null || ((Object)object).length <= 0) {
            RMAIO.postWarning((Component)this._frame, (String)"No Reaches in current Network to edit");
            return;
        }
        this.editReach((String)object[0]);
    }

    @Override
    public void editReach(String string) {
        RSimNetworkMode rSimNetworkMode = this;
        rSimNetworkMode.editReach(rSimNetworkMode.getNetwork(), string, this.hasWriteLock());
    }

    public void editReach(RssSystem rssSystem, String string, boolean bl) {
        this._frame.setWaitCursor();
        try {
            this.K = new ReachDlg((JFrame)AppDaddy.getFrame(), false);
            this.K.setSystem(rssSystem);
            if (!this.K.initDlg()) {
                return;
            }
            this.K.setEditable(bl);
            if (string != null) {
                this.K.selectReach(string);
            }
            this.K.setVisible(true);
            RSimNetworkMode rSimNetworkMode = this;
            rSimNetworkMode.a((Window)((Object)rSimNetworkMode.K));
            this.K.isCanceled();
            return;
        }
        finally {
            this._frame.setDefaultCursor();
        }
    }

    @Override
    public void editDiversion() {
        Object object = this._frame.getMapPanel().findGlyphOfClass(this.getGlyphClassName());
        if (object == null) {
            return;
        }
        if ((object = object.getSelectedObject()) != null && object instanceof DiversionElement) {
            this.editDiversion(object.getName());
            return;
        }
        object = this.getNetwork();
        if (object == null) {
            RMAIO.postError((Component)this._frame, (String)"Please open/create a network first");
            return;
        }
        if ((object = ((RssSystem)object).getDiversionNames()) == null || ((Object)object).length <= 0) {
            RMAIO.postWarning((Component)this._frame, (String)"No Diversions in current Network to edit");
            return;
        }
        this.editDiversion((String)object[0]);
    }

    @Override
    public void editDiversion(String string) {
        RSimNetworkMode rSimNetworkMode = this;
        rSimNetworkMode.editDiversion(rSimNetworkMode.getNetwork(), string, this.hasWriteLock());
    }

    public void editDiversion(RssSystem rssSystem, String string, boolean bl) {
        this._frame.setWaitCursor();
        try {
            if (this.N == null) {
                this.N = new DiversionEditorDlg((JFrame)AppDaddy.getFrame(), false);
            }
            this.N.setRssSystem(rssSystem);
            if (!this.N.initDlg()) {
                return;
            }
            this.N.selectDiversion(string);
            this.N.setEditable(bl);
            if (!this.N.isVisible()) {
                this.N.setVisible(true);
            }
            RSimNetworkMode rSimNetworkMode = this;
            rSimNetworkMode.a((Window)((Object)rSimNetworkMode.N));
            return;
        }
        finally {
            this._frame.setDefaultCursor();
        }
    }

    @Override
    public void editJunction() {
        Object object = this._frame.getMapPanel().findGlyphOfClass(this.getGlyphClassName());
        if (object == null) {
            return;
        }
        if ((object = object.getSelectedObject()) != null && object instanceof JunctionElement) {
            this.editJunction(object.getName());
            return;
        }
        object = this.getNetwork();
        if (object == null) {
            RMAIO.postError((Component)this._frame, (String)"Please open/create a network first");
            return;
        }
        if ((object = ((RssSystem)object).getJunctionNames()) == null || ((Object)object).length <= 0) {
            RMAIO.postWarning((Component)this._frame, (String)"No Junctions in current Network to edit");
            return;
        }
        this.editJunction((String)object[0]);
    }

    @Override
    public void editJunction(String string) {
        RSimNetworkMode rSimNetworkMode = this;
        rSimNetworkMode.editJunction(rSimNetworkMode.getNetwork(), string, this.hasWriteLock());
    }

    public void editJunction(RssSystem object, String string, boolean bl) {
        this._frame.setWaitCursor();
        try {
            if (this.L == null) {
                this.L = new JunctionDialog((JFrame)AppDaddy.getFrame(), false);
            }
            this.L.setRssSystem((RssSystem)object);
            if (!this.L.initDlg()) {
                return;
            }
            this.L.setEditable(bl);
            if (string != null) {
                this.L.selectJunction(string);
            }
            this.L.setVisible(true);
            object = new Dimension(650, 700);
            this.L.setSize((Dimension)object);
            this.L.setPreferredSize((Dimension)object);
            this.L.setMinimumSize((Dimension)object);
            this.L.setLocationRelativeTo(this.L.getParent());
            RSimNetworkMode rSimNetworkMode = this;
            rSimNetworkMode.a((Window)((Object)rSimNetworkMode.L));
            return;
        }
        finally {
            this._frame.setDefaultCursor();
        }
    }

    @Override
    public RssSystem getNetwork() {
        return this.d;
    }

    @Override
    public String getGlyphClassName() {
        return RssSystemGlyph.class.getName();
    }

    public boolean hasWriteLock(MapGlyph mapGlyph) {
        if (mapGlyph instanceof RssSystemGlyph) {
            return this.hasWriteLock();
        }
        return false;
    }

    @Override
    public boolean hasWriteLock() {
        return this.a.isSelected();
    }

    public void editVerticalDatum() {
        Object object;
        Object object2 = this.getNetwork();
        ArrayList<ReservoirElementVerticalDatumSettingsProvider> arrayList = new ArrayList<ReservoirElementVerticalDatumSettingsProvider>();
        ArrayList<JunctionElementVerticalDatumSettingsProvider> arrayList2 = new ArrayList<JunctionElementVerticalDatumSettingsProvider>();
        object2 = ((RssSystem)object2).getElementVector();
        object2 = ((Vector)object2).iterator();
        while (object2.hasNext()) {
            object = object2.next();
            if (object instanceof ReservoirElement) {
                arrayList.add(new ReservoirElementVerticalDatumSettingsProvider((ReservoirElement)object));
                continue;
            }
            if (!(object instanceof JunctionElement)) continue;
            arrayList2.add(new JunctionElementVerticalDatumSettingsProvider((JunctionElement)object));
        }
        object2 = new ArrayList<ReservoirElementVerticalDatumSettingsProvider>();
        object2.addAll(arrayList);
        object2.addAll(arrayList2);
        object = new EditVerticalDatumAction((List<VerticalDatumSettingsProvider>)object2);
        ((EditVerticalDatumAction)object).a();
    }

    public void editReservoirSysOps() {
        RSimNetworkMode rSimNetworkMode = this;
        rSimNetworkMode.editReservoirSysOps(rSimNetworkMode.getNetwork());
    }

    public void editReservoirSysOps(RssSystem rssSystem) {
        this._frame.setWaitCursor();
        try {
            if (rssSystem == null) {
                RMAIO.postWarning((Component)this._frame, (String)"No Network selected");
                return;
            }
            if (this.O == null) {
                this.O = new ReservoirSystemJDialog((Frame)this._frame, "Reservoir System Editor - Network: " + rssSystem.getName(), false);
                this.O.setSystem(rssSystem);
                if (!this.O.initDlg()) {
                    return;
                }
            } else if (this.O.getSystem() != rssSystem) {
                this.O.clearForm();
                this.O.setSystem(rssSystem);
                this.O.initDlg();
            }
            this.O.setVisible(true);
            return;
        }
        finally {
            this._frame.setDefaultCursor();
        }
    }

    public void editStateVariables() {
        RssSystem rssSystem = this.getNetwork();
        if (rssSystem == null) {
            System.out.println("editStateVariables:no network selected");
            RMAIO.postError((Component)this._frame, (String)"Please open/create a network first");
            return;
        }
        this._frame.setWaitCursor();
        try {
            if (this.i == null) {
                this.i = new StateVariableDialog((Frame)this._frame, false);
            }
            this.i.fillForm(rssSystem);
            this.i.setEditable(this.hasWriteLock());
        }
        finally {
            this._frame.setDefaultCursor();
        }
        this.i.setVisible(true);
        RSimNetworkMode rSimNetworkMode = this;
        rSimNetworkMode.a((Window)((Object)rSimNetworkMode.i));
    }

    public void editGlobalVariables() {
        RssSystem rssSystem = this.getNetwork();
        if (rssSystem == null) {
            System.out.println("editGlobalVariables:no network selected");
            RMAIO.postError((Component)this._frame, (String)"Please open/create a network first");
            return;
        }
        if (this.S == null) {
            this.S = new GlobalVariableEditor((Frame)this._frame);
        }
        this.S.fillForm(rssSystem);
        this.S.setEditable(this.hasWriteLock());
        this.S.setVisible(true);
        RSimNetworkMode rSimNetworkMode = this;
        rSimNetworkMode.a((Window)((Object)rSimNetworkMode.S));
    }

    public void editWaterAccountSets() {
        this.j = new WaterAccountSetEditor((Frame)this._frame, false, this.d);
        this.j.fillForm(this.d.getWaterAccountSetList(), null);
        this.j.setEditable(this.hasWriteLock());
        this.j.setVisible(true);
        this.j.setModified(false);
        RSimNetworkMode rSimNetworkMode = this;
        rSimNetworkMode.a((Window)((Object)rSimNetworkMode.j));
    }

    protected void b(boolean bl) {
        ClientWorkspace clientWorkspace = ClientApp.Workspace();
        if (clientWorkspace == null) {
            return;
        }
        if ((clientWorkspace = (StudyDataList)clientWorkspace.getDataListContainer().getDataList(Study.class.getName())) != null) {
            this.c = (Study)clientWorkspace.getOpenStudy();
        } else {
            System.out.println("openStudy: Failed to find StudyDataList");
        }
        if (this.c == null) {
            return;
        }
    }

    protected boolean c(boolean bl) {
        ClientWorkspace clientWorkspace = ClientApp.Workspace();
        if (clientWorkspace == null) {
            return false;
        }
        Vector vector = clientWorkspace.getManagerIDList(StreamAlignment.class.getName());
        if (vector.size() <= 0) {
            this.e = (StreamAlignment)clientWorkspace.newManager(StreamAlignment.class.getName());
            vector = this.e.getIdentifier();
            vector.setPath("stream.align");
            RmiFileManager rmiFileManager = (RmiFileManager)ClientApp.app().getFileManager().getRemote();
            Identifier identifier = new Identifier(ClientApp.Workspace().getWorkspacePath() + "/stream.align");
            try {
                identifier = rmiFileManager.openFile(ClientApp.app().getUser(), identifier);
                if (identifier != null) {
                    System.out.println("openStreamAlignment:found existing stream.align file.");
                    this.e.readFile(identifier);
                    vector.setName(this.e.getName());
                    vector.setDescription(this.e.getDescription());
                }
            }
            catch (RemoteException remoteException) {
                System.out.println("openStreamAlignment: Exception opening stream.align file. RemoteException " + String.valueOf(remoteException));
            }
            clientWorkspace.saveManager((Manager)this.e);
        } else if ((vector = (Identifier)vector.elementAt(0)) != null) {
            this.e = (StreamAlignment)clientWorkspace.openManager((Identifier)vector);
            if (this.e == null) {
                JOptionPane.showMessageDialog((Component)this._frame, "Failed to Open Stream Alignment");
                return false;
            }
        }
        return true;
    }

    public void refreshMode() {
        if (this.M != null && !this.M.isVisible()) {
            this.M = null;
        }
        if (this.K != null && !this.K.isVisible()) {
            this.K = null;
        }
        if (this.L != null && !this.L.isVisible()) {
            this.L = null;
        }
        if (this.N != null && !this.N.isVisible()) {
            this.N = null;
        }
        if (this.i != null && !this.i.isVisible()) {
            this.i = null;
        }
        if (this.O != null && this.O.isVisible()) {
            this.O = null;
        }
        if (this.J != null && !this.J.isVisible()) {
            this.J = null;
        }
        if (this.H != null && !this.H.isVisible()) {
            this.H = null;
        }
        if (this.I != null && !this.I.isVisible()) {
            this.I = null;
        }
    }

    public void modifiedStateChanged(Modifiable modifiable, boolean bl) {
        if (modifiable == this.d) {
            if (this.d.isModified()) {
                this.u.setText(this.d.getName() + "*");
                return;
            }
            this.u.setText(this.d.getName());
        }
    }

    public void importProperties() {
        NamedType[] namedTypeArray = (NamedType[])this._frame.getMapPanel().findGlyphOfClass(RssSystemGlyph.class.getName());
        if (namedTypeArray == null) {
            return;
        }
        namedTypeArray = namedTypeArray.getSelections();
        ImportNetworkDialog importNetworkDialog = new ImportNetworkDialog((Frame)this._frame, true);
        importNetworkDialog.setNetwork(this.getNetwork());
        importNetworkDialog.setSelectedElements(namedTypeArray);
        importNetworkDialog.setVisible(true);
        importNetworkDialog.dispose();
    }

    public void importNetwork() {
        ImportNetworkDialog2 importNetworkDialog2 = new ImportNetworkDialog2((Frame)this._frame, true);
        importNetworkDialog2.setVisible(true);
        importNetworkDialog2.dispose();
    }

    protected void a(Window window) {
        WindowUtilities.toFront((Window)window);
    }

    public void saveNetworkReport() {
        Object object;
        RssSystem rssSystem = this.getNetwork();
        if (rssSystem == null) {
            return;
        }
        RmiFileDialog rmiFileDialog = new RmiFileDialog((Frame)this._frame, true);
        rmiFileDialog.setSaveTitle();
        rmiFileDialog.setTitle("Save Network Report");
        rmiFileDialog.setDefaultFilename(rssSystem.getName() + ".rpt");
        rmiFileDialog.setVisible(true);
        if (rmiFileDialog.isCanceled()) {
            return;
        }
        if ((rmiFileDialog = rmiFileDialog.getIdentifier()) == null) {
            return;
        }
        if (rmiFileDialog.getFile() == null) {
            object = ClientApp.app().openFile((Identifier)rmiFileDialog, false);
            if (object == null) {
                object = ClientApp.app().createFile((Identifier)rmiFileDialog);
            }
            rmiFileDialog = object;
        }
        if (!(object = new NetworkReport(rssSystem, (Identifier)rmiFileDialog)).a()) {
            ClientApp.app().postError("Error saving network report", "Error");
        }
    }

    public void importAlternative() {
        ImportAlternativeDialog importAlternativeDialog = new ImportAlternativeDialog((Frame)ClientApp.frame(), true);
        importAlternativeDialog.setVisible(true);
    }

    static /* synthetic */ HecClientFrame a(RSimNetworkMode rSimNetworkMode) {
        return rSimNetworkMode._frame;
    }
}

