/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.clientapp.client.ClientApp;
import hec.clientapp.client.HecClientFrame;
import hec.clientapp.client.PopupMenuHandler;
import hec.clientapp.model.SimulationPeriod;
import hec.clientapp.model.SimulationTrialRun;
import hec.clientapp.model.TSDataSet;
import hec.clientapp.model.TSRecordProxy;
import hec.event.PlotTypeChangedEvent;
import hec.event.PlotTypeListener;
import hec.gfx2d.G2dDialog;
import hec.gfx2d.profilePlot.ProfileDataG2dObject;
import hec.gfx2d.profilePlot.ProfileDataRecords;
import hec.heclib.dss.DSSPathname;
import hec.heclib.dss.DataReference;
import hec.heclib.dss.Group;
import hec.heclib.dss.HecTimeSeries;
import hec.heclib.util.HecTime;
import hec.io.DSSIdentifier;
import hec.io.Identifier;
import hec.io.TimeSeriesContainer;
import hec.lang.NamedType;
import hec.lang.UserId;
import hec.map.LocalPt;
import hec.model.ModelVariable;
import hec.model.RunTimeWindow;
import hec.rss.client.PlotDialog;
import hec.rss.client.RSS;
import hec.rss.client.RSimBaseMode;
import hec.rss.client.RSimNetworkMode;
import hec.rss.client.RSimPopupMenuHandler$1;
import hec.rss.client.RSimPopupMenuHandler$PlotMenuItem;
import hec.rss.client.RSimSimulationMode;
import hec.rss.client.ReservoirJFrame;
import hec.rss.client.graph.tree.TreeNode;
import hec.rss.client.jfx.ReservoirLayoutPlotDialog;
import hec.rss.client.systsplot.SystemTSPlotFrame;
import hec.rss.model.AdjustableFlow;
import hec.rss.model.DiversionElement;
import hec.rss.model.DivertedOutletElement;
import hec.rss.model.Element;
import hec.rss.model.ElementGraph$ElementGraphNode;
import hec.rss.model.Function;
import hec.rss.model.JunctionElement;
import hec.rss.model.ReachElement;
import hec.rss.model.ReservoirElement;
import hec.rss.model.ReservoirOp;
import hec.rss.model.ReservoirOutletElement;
import hec.rss.model.RssAlt;
import hec.rss.model.RssModelVariableConstants;
import hec.rss.model.RssNode;
import hec.rss.model.RssRun;
import hec.rss.model.RssSystem;
import hec.rss.model.RssTSLocationObject;
import hec.rss.model.Spillway;
import hec.rss.plugins.waterquality.model.RssWQGeometry;
import hec.rss.server.DiversionEditorDlg;
import hec.rss.server.JunctionDialog;
import hec.rss.server.ReachDlg;
import hec.rss.wq.client.results.ColdWaterPoolVolumeDialog;
import hec.rss.wq.client.results.ColdWaterPoolVolumeDialog$ReservoirElevationStorageProvider;
import hec.rss.wq.client.results.DssTimeSeriesResultsDialog;
import hec.rss.wq.client.results.ProfilePlotDialog;
import hec.rss.wq.client.results.TimeSeriesResultsDialog;
import hec.rss.wq.client.results.TimeSeriesResultsDialog$Filter;
import hec.rss.wq.client.results.TimeSeriesResultsDialog$SetFilter;
import hec.rss.wq.client.results.WQProfileDataRecords;
import hec.rss.wq.client.results.WaterQualityResultsContourDialog;
import hec.watershed.res.model.PlottableObject;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Collections;
import java.util.EventObject;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.event.EventListenerList;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;
import mil.army.usace.hec.rmi.model.PreferencesManager;
import rma.swing.RmaJMenuLabel;
import rma.swing.RmaJPopupMenu;
import rma.swing.WindowUtilities;
import rma.util.RMAIO;

public class RSimPopupMenuHandler
implements PopupMenuHandler,
PlotTypeListener,
RssModelVariableConstants,
ActionListener,
MenuListener {
    public static final String REGULATED_FLOWS = "regulatedflows";
    public static final String OUTLETS = "outlets";
    public static final String RELEASE = "release";
    public static final String SPILL = "spill";
    public static final String ELEVATION = "elevation";
    public static final String STORAGE = "storage";
    public static final String DEFAULT = "default";
    public static final String USER_DEFINED = "User Plots";
    public static final String SHOW_STORAGE_BALANCE_MENU_PROPERTY = "ShowStorageBalanceMenu";
    public static final String SHOW_SYSTEM_STORAGE_MENUS_PROPERTY = "ShowSystemStorageMenus";
    private static Map<String, Map<String, List<JMenu>>> _pluginMenuTable = new HashMap<String, Map<String, List<JMenu>>>();
    private static EventListenerList _listenerList = new EventListenerList();
    private boolean _userDefinedMenuBuilt;
    private JMenu _userDefinedMenu;
    private Vector _userPlotMenus = new Vector();
    RSimBaseMode _mode;
    NamedType[] _selectedObjs;
    ReservoirJFrame _resDlg = null;
    ReachDlg _reachDlg = null;
    JunctionDialog _juncDlg = null;
    DiversionEditorDlg _divDlg = null;
    HecClientFrame _frame = null;
    Map<Element, TreeNode> insertedNodes = new HashMap<Element, TreeNode>();

    public RSimPopupMenuHandler(RSimBaseMode rSimBaseMode) {
        this._mode = rSimBaseMode;
        this._frame = RSS.frame();
    }

    public boolean objectPopupMenu(NamedType[] namedTypeArray, LocalPt localPt) {
        boolean bl;
        if (namedTypeArray == null || namedTypeArray.length <= 0) {
            return false;
        }
        RmaJPopupMenu rmaJPopupMenu = new RmaJPopupMenu();
        this._selectedObjs = namedTypeArray;
        boolean bl2 = true;
        if (namedTypeArray.length > 1) {
            Class<?> clazz = namedTypeArray[0].getClass();
            for (int i = 1; i < namedTypeArray.length; ++i) {
                if (namedTypeArray[i].getClass().equals(clazz)) continue;
                bl2 = false;
            }
        }
        boolean bl3 = bl = namedTypeArray.length == 1;
        if (bl2) {
            Object object = namedTypeArray[0];
            if (!bl) {
                rmaJPopupMenu.add((JMenuItem)new RmaJMenuLabel("Multiple Selections"));
                rmaJPopupMenu.addSeparator();
            }
            if (object instanceof ReservoirElement) {
                object = this.getMenuItems((ReservoirElement)object, true, bl);
                this.addMenuItems((JPopupMenu)rmaJPopupMenu, (Vector)object, false);
                rmaJPopupMenu.addSeparator();
            } else if (object instanceof JunctionElement) {
                object = this.getMenuItems((JunctionElement)object, true, bl);
                this.addMenuItems((JPopupMenu)rmaJPopupMenu, (Vector)object, false);
            } else if (object instanceof ReachElement) {
                object = this.getMenuItems((ReachElement)object, true, bl);
                this.addMenuItems((JPopupMenu)rmaJPopupMenu, (Vector)object, false);
            } else if (object instanceof DiversionElement) {
                object = this.getMenuItems((DiversionElement)object, true, bl);
                this.addMenuItems((JPopupMenu)rmaJPopupMenu, (Vector)object, false);
            } else if (object instanceof DivertedOutletElement) {
                object = this.getMenuItems((DivertedOutletElement)object, true, bl);
                this.addMenuItems((JPopupMenu)rmaJPopupMenu, (Vector)object, false);
            }
        } else {
            rmaJPopupMenu.add((JMenuItem)new RmaJMenuLabel("Multiple Selections"));
            rmaJPopupMenu.addSeparator();
            BitSet bitSet = new BitSet(4);
            Serializable serializable = new JMenuItem("Plot");
            serializable.setActionCommand("all:defaultplot:all");
            serializable.setToolTipText("Default Plot for Elements selected");
            serializable.addActionListener(this);
            rmaJPopupMenu.add((JMenuItem)serializable);
            rmaJPopupMenu.addSeparator();
            for (int i = 0; i < namedTypeArray.length; ++i) {
                serializable = namedTypeArray[i];
                if (serializable instanceof ReservoirElement && !bitSet.get(0)) {
                    JMenu jMenu = new JMenu("Reservoir Plots");
                    jMenu.setToolTipText("Reservoir specific plots");
                    serializable = this.getMenuItems((ReservoirElement)((Object)serializable), false, false);
                    this.addMenuItems(jMenu, (JPopupMenu)rmaJPopupMenu, (Vector)serializable, i != 0);
                    bitSet.set(0);
                    continue;
                }
                if (serializable instanceof JunctionElement && !bitSet.get(1)) {
                    JMenu jMenu = new JMenu("Junction Plots");
                    jMenu.setToolTipText("Junction specific plots");
                    serializable = this.getMenuItems((JunctionElement)((Object)serializable), false, false);
                    this.addMenuItems(jMenu, (JPopupMenu)rmaJPopupMenu, (Vector)serializable, i != 0);
                    bitSet.set(1);
                    continue;
                }
                if (serializable instanceof ReachElement && !bitSet.get(2)) {
                    JMenu jMenu = new JMenu("Reach Plots");
                    jMenu.setToolTipText("Reach specific plots");
                    serializable = this.getMenuItems((ReachElement)((Object)serializable), false, false);
                    this.addMenuItems(jMenu, (JPopupMenu)rmaJPopupMenu, (Vector)serializable, i != 0);
                    bitSet.set(2);
                    continue;
                }
                if (serializable instanceof DiversionElement && !bitSet.get(3)) {
                    JMenu jMenu = new JMenu("Diversion Plots");
                    jMenu.setToolTipText("Diversion specific plots");
                    serializable = this.getMenuItems((DiversionElement)((Object)serializable), false, false);
                    this.addMenuItems(jMenu, (JPopupMenu)rmaJPopupMenu, (Vector)serializable, i != 0);
                    bitSet.set(3);
                    continue;
                }
                if (!(serializable instanceof DivertedOutletElement) || bitSet.get(3)) continue;
                JMenu jMenu = new JMenu("Diverted Outlet Plots");
                jMenu.setToolTipText("Diverted Outlet specific plots");
                serializable = this.getMenuItems((DivertedOutletElement)((Object)serializable), false, false);
                this.addMenuItems(jMenu, (JPopupMenu)rmaJPopupMenu, (Vector)serializable, i != 0);
                bitSet.set(3);
            }
            if (this._mode instanceof RSimSimulationMode) {
                JMenu jMenu = this.createUserDefinedMenu();
                rmaJPopupMenu.addSeparator();
                rmaJPopupMenu.add(jMenu);
            }
            if (this._mode instanceof RSimNetworkMode) {
                rmaJPopupMenu.addSeparator();
                serializable = new JMenuItem("Delete");
                serializable.setEnabled(this._mode.isNetworkLocked());
                serializable.setActionCommand("delete:all:all");
                serializable.addActionListener(this);
                rmaJPopupMenu.add((JMenuItem)serializable);
            }
        }
        if (rmaJPopupMenu.getComponentCount() > 0) {
            rmaJPopupMenu.show((Component)this._frame.getMapPanel().viewport(), localPt.x, localPt.y);
            return true;
        }
        return false;
    }

    protected void displaySystemTSPlot(ReservoirElement object) {
        object = (RSimSimulationMode)this._mode;
        RssSystem rssSystem = ((RSimSimulationMode)object).getNetwork();
        Object object2 = ((RSimSimulationMode)object).getRssRun();
        if (object2 == null) {
            RMAIO.postError((Component)object.getFrame(), (String)"Unable to get RssRun from RSimSimulationMode.");
            return;
        }
        object2.initForPostProcessing();
        object = object2.getRunTimeWindow();
        object2 = new SystemTSPlotFrame((Frame)this._frame, "System TS Plot");
        ((SystemTSPlotFrame)((Object)object2)).setSystem(rssSystem, (RunTimeWindow)object);
        object2.setSize(1000, 600);
        object2.setLocationRelativeTo((Component)this._frame);
        object2.setVisible(true);
    }

    protected void displayProfilePlot(Element element) {
        Object object = (RSimSimulationMode)this._mode;
        object = ((RSimSimulationMode)object).getRssRun();
        RSimPopupMenuHandler.displayProfilePlot(element, (RssRun)object);
    }

    public static ProfilePlotDialog displayProfilePlot(Element object, RssRun object2) {
        Object object3 = ((RssRun)object2).getOutputFile(false);
        object2 = RMAIO.userNameToFileName((String)object2.getName());
        object2 = new File(new File((String)object3).getParentFile(), (String)object2 + ".h5");
        try {
            object2 = new WQProfileDataRecords((File)object2, object.getName());
            ((WQProfileDataRecords)((Object)object2)).a(2);
        }
        catch (IOException iOException) {
            RMAIO.postError((Component)ClientApp.frame(), (String)iOException.getMessage());
            return null;
        }
        object2 = new ProfileDataG2dObject((ProfileDataRecords)object2, object.getName());
        object3 = object2.getParameterNames();
        int n = RSimPopupMenuHandler.getWaterTemperatureIdx((List)object3);
        if (!object3.isEmpty() && object3.get(0) != null) {
            n = n >= 0 ? n : 0;
            object2.getYData(0, object3.get(n).toString());
        }
        object2.setName(object.getName());
        Vector<Object> vector = new Vector<Object>();
        vector.add(object2);
        object = new ProfilePlotDialog((Frame)ClientApp.frame(), "Water Quality Profile Plot", true, vector, new Vector(), false, true);
        object.setSize(1500, 750);
        object.setLocationRelativeTo((Component)ClientApp.frame());
        object.setVisible(true);
        return object;
    }

    private static int getWaterTemperatureIdx(List list) {
        int n = -1;
        if (!list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                Object e = list.get(i);
                if (e == null || !e.toString().toLowerCase().contains("Water Temperature".toLowerCase())) continue;
                n = i;
                break;
            }
        }
        return n;
    }

    public void displayReachWaterQualityPlots(Element element) {
        RSimSimulationMode rSimSimulationMode = (RSimSimulationMode)this._mode;
        RssRun rssRun = rSimSimulationMode.getRssRun();
        rSimSimulationMode = rSimSimulationMode.getSimulation();
        RunTimeWindow runTimeWindow = rSimSimulationMode.getRunTimeWindow();
        RSimPopupMenuHandler.displayReachWaterQualityPlots(element, rssRun, runTimeWindow, rSimSimulationMode.getGmtOffset());
    }

    public static TimeSeriesResultsDialog displayReachWaterQualityPlots(Element element, RssRun object, RunTimeWindow runTimeWindow, int n) {
        Object object2 = ((RssRun)object).getOutputFile(false);
        Object object3 = RMAIO.userNameToFileName((String)object.getName());
        object2 = new File(new File((String)object2).getParentFile(), (String)object3 + ".h5");
        object = ((RssRun)object).getAlternative();
        if ((object = ((RssAlt)object).getWaterQualityOptions().getGeometryManager((RssAlt)object).getRssWqGeometry()) == null) {
            RMAIO.postError((Component)ClientApp.frame(), (String)("Unable to find WQ Geometry for " + element.getName()));
            return null;
        }
        object = ((RssWQGeometry)object).getWQSubdomain(element);
        int n2 = object.getNumCells() - 1;
        HecTime hecTime = new TimeSeriesResultsDialog$SetFilter(Collections.singleton(n2));
        object3 = new TimeSeriesResultsDialog((Frame)ClientApp.frame(), "Plot WQ Time Series", false);
        try {
            ((TimeSeriesResultsDialog)((Object)object3)).setData((File)object2, element.getName(), (TimeSeriesResultsDialog$Filter<Integer>)hecTime);
        }
        catch (IOException iOException) {
            RMAIO.postError((Component)ClientApp.frame(), (String)iOException.getMessage());
            return null;
        }
        element = new HecTime(runTimeWindow.getStartDateString());
        hecTime = new HecTime(runTimeWindow.getEndDateString());
        runTimeWindow = new HecTime(runTimeWindow.getLookbackDateString());
        object3.plotTimeWindow(new RunTimeWindow((HecTime)element, hecTime, (HecTime)runTimeWindow), n, "Time of Simulation");
        object3.setLocationRelativeTo((Component)ClientApp.frame());
        object3.setSize(1500, 750);
        object3.setVisible(true);
        return object3;
    }

    public void displayJunctionWaterQualityPlots(JunctionElement junctionElement) {
        if (!(this._mode instanceof RSimSimulationMode)) {
            return;
        }
        Object object = (RSimSimulationMode)this._mode;
        object = ((RSimSimulationMode)object).getRssRuns(true, true);
        RSimPopupMenuHandler.displayJunctionWaterQualityPlots((Vector<RssRun>)object, junctionElement);
    }

    public static void displayJunctionWaterQualityPlots(Vector<RssRun> vector, JunctionElement junctionElement) {
        DssTimeSeriesResultsDialog dssTimeSeriesResultsDialog = new DssTimeSeriesResultsDialog((Frame)ClientApp.frame(), "Plot WQ Time Series", false);
        try {
            dssTimeSeriesResultsDialog.setData(vector, junctionElement);
        }
        catch (IOException iOException) {
            RMAIO.postError((Component)ClientApp.frame(), (String)("Exception plotting WQ Time Series results. Exception:" + iOException.getMessage()));
            return;
        }
        dssTimeSeriesResultsDialog.setLocationRelativeTo((Component)ClientApp.frame());
        dssTimeSeriesResultsDialog.setSize(1500, 750);
        dssTimeSeriesResultsDialog.setVisible(true);
    }

    protected void displayColdWaterPool(Element element) {
        Object object = (RSimSimulationMode)this._mode;
        ((RSimSimulationMode)object).getActiveRun();
        object = ((RSimSimulationMode)object).getRssRun();
        RSimPopupMenuHandler.displayColdWaterPool((RssRun)object, element);
    }

    public static ColdWaterPoolVolumeDialog displayColdWaterPool(RssRun object, Element element) {
        Object object2 = ((RssRun)object).getOutputFile(false);
        String string = RMAIO.userNameToFileName((String)object.getName()) + ".h5";
        object2 = new File(new File((String)object2).getParentFile(), string);
        object = ((RssRun)object).getNetwork();
        string = ((RssSystem)object).getReservoirNames();
        object = new RSimPopupMenuHandler$1((RssSystem)object);
        ColdWaterPoolVolumeDialog coldWaterPoolVolumeDialog = new ColdWaterPoolVolumeDialog((Window)ClientApp.frame(), false);
        coldWaterPoolVolumeDialog.setData((File)object2, Arrays.asList(string), (ColdWaterPoolVolumeDialog$ReservoirElevationStorageProvider)object, element.getName());
        coldWaterPoolVolumeDialog.setTitle("Cold Water Pool");
        coldWaterPoolVolumeDialog.setSize(1500, 750);
        coldWaterPoolVolumeDialog.setLocationRelativeTo((Component)ClientApp.frame());
        coldWaterPoolVolumeDialog.setVisible(true);
        return coldWaterPoolVolumeDialog;
    }

    protected void displayWaterQualityFlowTemp(Element element, int n) {
        if (!(this._mode instanceof RSimSimulationMode)) {
            return;
        }
        Object object = (RSimSimulationMode)this._mode;
        object = ((RSimSimulationMode)object).getRssRuns(true, true);
        RSimPopupMenuHandler.displayWaterQualityFlowTemp((Vector<RssRun>)object, element, n);
    }

    public static G2dDialog displayWaterQualityFlowTemp(Vector<RssRun> object, Element element, int n) {
        RssRun rssRun;
        Vector<TSRecordProxy> vector = new Vector<TSRecordProxy>();
        element.getTSRecords(new ModelVariable("", "", n, 0), vector, (Vector)object);
        ArrayList arrayList = new ArrayList(vector);
        vector = new Vector();
        object = ((Vector)object).iterator();
        while (object.hasNext()) {
            rssRun = (RssRun)object.next();
            TSDataSet tSDataSet = rssRun.getOutputTSData();
            tSDataSet.getDSSFileManager();
            for (TSRecordProxy tSRecordProxy : arrayList) {
                tSRecordProxy = tSDataSet.getTSRecord(tSRecordProxy.getName(), tSRecordProxy.getVariableId());
                tSRecordProxy.initialize(rssRun.getRunTimeWindow());
                tSRecordProxy.loadTSData();
                tSRecordProxy = tSRecordProxy.getTimeSeriesContainer();
                vector.add(tSRecordProxy);
                String string = tSRecordProxy.getFullName();
                string = new DSSPathname(string);
                string.setCPart("Temp-Water Temperature");
                DSSIdentifier dSSIdentifier = new DSSIdentifier();
                dSSIdentifier.setDSSPath(string.toString());
                dSSIdentifier.setFileName(tSRecordProxy.fileName);
                string = new HecTimeSeries();
                tSRecordProxy = new TimeSeriesContainer();
                new TimeSeriesContainer().fileName = dSSIdentifier.getFileName();
                tSRecordProxy.fullName = dSSIdentifier.getDSSPath();
                string.setRetrieveAllTimes(true);
                int n2 = string.read((TimeSeriesContainer)tSRecordProxy, true);
                if (n2 <= -2) continue;
                vector.add(tSRecordProxy);
            }
        }
        object = "Water Temperature - " + element.getName();
        rssRun = new G2dDialog((Frame)ClientApp.frame(), (String)object, false, vector);
        rssRun.setSize(1500, 750);
        rssRun.setLocationRelativeTo((Component)ClientApp.frame());
        rssRun.setVisible(true);
        return rssRun;
    }

    public void displayWaterQualityColorContour(Element element) {
        RSimSimulationMode rSimSimulationMode = (RSimSimulationMode)this._mode;
        Object object = rSimSimulationMode.getActiveRun();
        SimulationPeriod simulationPeriod = rSimSimulationMode.getSimulation();
        String string = simulationPeriod != null ? simulationPeriod.getName() : "";
        Object object2 = "";
        if (simulationPeriod != null) {
            if (object instanceof SimulationTrialRun) {
                object2 = ((SimulationTrialRun)object).getRunParent().getUserName();
                object = "; " + rSimSimulationMode.getActiveRun().getUserName();
                object2 = (String)object2 + (String)object;
            } else {
                object2 = object.getUserName();
            }
        }
        RSimPopupMenuHandler.displayWaterQualityColorContour(element, rSimSimulationMode.getRssRun(), string, (String)object2);
    }

    public static WaterQualityResultsContourDialog displayWaterQualityColorContour(Element element, RssRun rssRun, String string, String object) {
        object = rssRun.getOutputFile(false);
        object = new File(new File((String)object).getParentFile(), RMAIO.userNameToFileName((String)rssRun.getName()) + ".h5");
        WaterQualityResultsContourDialog waterQualityResultsContourDialog = new WaterQualityResultsContourDialog((Frame)ClientApp.frame(), false);
        try {
            waterQualityResultsContourDialog.setData((File)object, string, element.getName(), rssRun);
        }
        catch (IOException iOException) {
            RMAIO.postError((Component)ClientApp.frame(), (String)iOException.getMessage());
            return null;
        }
        waterQualityResultsContourDialog.setTitle("Water Quality Contour Plot");
        waterQualityResultsContourDialog.setLocation(500, 500);
        waterQualityResultsContourDialog.setSize(1500, 750);
        waterQualityResultsContourDialog.setVisible(true);
        return waterQualityResultsContourDialog;
    }

    protected void displaySystemStoragePlot(ReservoirElement object) {
        object = (RSimSimulationMode)this._mode;
        RssSystem rssSystem = ((RSimSimulationMode)object).getNetwork();
        Serializable serializable = ((RSimSimulationMode)object).getRssRun();
        if (serializable == null) {
            RMAIO.postError((Component)object.getFrame(), (String)"Unable to get RssRun from RSimSimulationMode.");
            return;
        }
        ((RssRun)serializable).initForPostProcessing();
        object = ((RssRun)serializable).getRunTimeWindow();
        serializable = new ReservoirLayoutPlotDialog((Frame)this._frame, "Reservoir System Plot");
        ((ReservoirLayoutPlotDialog)serializable).setRssSystem(rssSystem, (RunTimeWindow)object);
        ((Window)serializable).setSize(1000, 600);
        ((Window)serializable).setLocationRelativeTo((Component)this._frame);
        ((Window)serializable).setVisible(true);
    }

    private void insertNodes(ElementGraph$ElementGraphNode iterator, TreeNode<Element> treeNode) {
        iterator = ((ElementGraph$ElementGraphNode)((Object)iterator)).c();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            ElementGraph$ElementGraphNode elementGraph$ElementGraphNode = iterator.next();
            if (this.insertedNodes.get(elementGraph$ElementGraphNode.b()) != null) {
                treeNode.a(this.insertedNodes.get(elementGraph$ElementGraphNode.b()));
                continue;
            }
            TreeNode<Element> treeNode2 = new TreeNode<Element>(elementGraph$ElementGraphNode.b());
            treeNode.a(treeNode2);
            this.insertedNodes.put(elementGraph$ElementGraphNode.b(), treeNode2);
            this.insertNodes(elementGraph$ElementGraphNode, treeNode2);
        }
    }

    private Vector getMenuItems(DiversionElement diversionElement, boolean bl, boolean bl2) {
        Vector<Object> vector = new Vector<Object>();
        String string = diversionElement.getName();
        if (bl2) {
            vector.addElement(new RmaJMenuLabel(string));
            vector.add(new JSeparator());
            JMenuItem jMenuItem = new JMenuItem(this.getEditViewString() + "Diversion Properties");
            jMenuItem.setActionCommand("diversion:edit:" + string);
            jMenuItem.addActionListener(this);
            vector.addElement(jMenuItem);
            vector.add(new JSeparator());
        }
        if (this._mode instanceof RSimSimulationMode) {
            if (Boolean.getBoolean("oldPlotMenu")) {
                JMenuItem jMenuItem = new JMenuItem("Plot");
                jMenuItem.setActionCommand("diversion:default:" + string);
                jMenuItem.addActionListener(this);
                vector.addElement(jMenuItem);
            } else {
                this.getPlotList(diversionElement, vector, bl);
            }
        }
        return vector;
    }

    private Vector getMenuItems(DivertedOutletElement divertedOutletElement, boolean bl, boolean bl2) {
        Vector<Object> vector = new Vector<Object>();
        String string = divertedOutletElement.getParent().getName() + "-" + divertedOutletElement.getName();
        if (bl2) {
            vector.addElement(new RmaJMenuLabel(string));
            vector.add(new JSeparator());
            JMenuItem jMenuItem = new JMenuItem(this.getEditViewString() + "Diverted Outlet Properties");
            jMenuItem.setActionCommand("divertedoutlet:edit:" + string);
            jMenuItem.addActionListener(this);
            vector.addElement(jMenuItem);
            vector.add(new JSeparator());
        }
        if (this._mode instanceof RSimSimulationMode) {
            if (Boolean.getBoolean("oldPlotMenu")) {
                JMenuItem jMenuItem = new JMenuItem("Plot");
                jMenuItem.setActionCommand("divertedoutlet:default:" + string);
                jMenuItem.addActionListener(this);
                vector.addElement(jMenuItem);
            } else {
                this.getPlotList(divertedOutletElement, vector, bl);
            }
        }
        return vector;
    }

    public Vector getMenuItems(ReservoirElement reservoirElement, boolean bl, boolean bl2) {
        Vector<Object> vector = new Vector<Object>();
        String string = reservoirElement.getName();
        if (bl2) {
            vector.addElement(new RmaJMenuLabel(string));
            vector.add(new JSeparator());
            JMenuItem jMenuItem = new JMenuItem(this.getEditViewString() + "Reservoir Properties");
            jMenuItem.setActionCommand("res:edit:" + string);
            jMenuItem.addActionListener(this);
            vector.addElement(jMenuItem);
            vector.add(new JSeparator());
        }
        if (Boolean.getBoolean("oldPlotMenu")) {
            JMenuItem jMenuItem = new JMenuItem("Plot");
            jMenuItem.setActionCommand("res:default:" + string);
            jMenuItem.addActionListener(this);
            vector.addElement(jMenuItem);
            jMenuItem = new JMenuItem("Plot Regulated Flows");
            jMenuItem.setActionCommand("res:regulatedflows:" + string);
            jMenuItem.addActionListener(this);
            vector.addElement(jMenuItem);
            jMenuItem = new JMenuItem("Plot Outlets");
            jMenuItem.setActionCommand("res:outlets:" + string);
            jMenuItem.addActionListener(this);
            vector.addElement(jMenuItem);
            jMenuItem = new JMenuItem("Plot Release");
            jMenuItem.setActionCommand("res:release:" + string);
            jMenuItem.addActionListener(this);
            vector.addElement(jMenuItem);
            jMenuItem = new JMenuItem("Plot Spill");
            jMenuItem.setActionCommand("res:spill:" + string);
            jMenuItem.addActionListener(this);
            vector.addElement(jMenuItem);
            jMenuItem = new JMenuItem("Plot Elevation");
            jMenuItem.setActionCommand("res:elevation:" + string);
            jMenuItem.addActionListener(this);
            vector.addElement(jMenuItem);
            jMenuItem = new JMenuItem("Plot Storage");
            jMenuItem.setActionCommand("res:storage:" + string);
            jMenuItem.addActionListener(this);
            vector.addElement(jMenuItem);
        } else {
            this.getPlotList(reservoirElement, vector, bl);
        }
        vector.add(new JSeparator());
        JMenuItem jMenuItem = new JMenuItem("Release Decision Report");
        jMenuItem.setActionCommand("res:releasedecisionreport:" + string);
        jMenuItem.addActionListener(this);
        vector.addElement(jMenuItem);
        if (Boolean.getBoolean(SHOW_SYSTEM_STORAGE_MENUS_PROPERTY)) {
            jMenuItem = new JMenuItem("System Storage Plot");
            jMenuItem.setActionCommand("reservoir:systemstorageplot:" + string);
            jMenuItem.addActionListener(this);
            vector.addElement(jMenuItem);
            jMenuItem = new JMenuItem("System Time Series Plot");
            jMenuItem.setActionCommand("reservoir:systemtsplot:" + string);
            jMenuItem.addActionListener(this);
            vector.addElement(jMenuItem);
        }
        return vector;
    }

    private Vector getMenuItems(ReachElement reachElement, boolean bl, boolean bl2) {
        Vector<Object> vector = new Vector<Object>();
        if (bl2) {
            String string = reachElement.getName();
            vector.addElement(new RmaJMenuLabel(string));
            vector.add(new JSeparator());
            JMenuItem jMenuItem = new JMenuItem(this.getEditViewString() + "Reach Properties");
            jMenuItem.setActionCommand("reach:edit:" + string);
            jMenuItem.addActionListener(this);
            vector.addElement(jMenuItem);
            vector.add(new JSeparator());
        }
        if (this._mode instanceof RSimSimulationMode) {
            this.getPlotList(reachElement, vector, bl);
        }
        return vector;
    }

    private Vector getPlotList(Element element, Vector vector, boolean bl) {
        RSimSimulationMode rSimSimulationMode;
        Object object;
        ReservoirElement reservoirElement;
        if (Boolean.getBoolean("oldPlotMenu")) {
            Vector vector2 = new Vector();
            element.getModelVariables(vector2);
            for (int i = 0; i < vector2.size(); ++i) {
                ModelVariable modelVariable = (ModelVariable)vector2.get(i);
                if (modelVariable == null) continue;
                RSimPopupMenuHandler$PlotMenuItem rSimPopupMenuHandler$PlotMenuItem = new RSimPopupMenuHandler$PlotMenuItem(this, "Plot " + modelVariable.getName());
                rSimPopupMenuHandler$PlotMenuItem.setModelVariable(modelVariable);
                rSimPopupMenuHandler$PlotMenuItem.setElement(element);
                rSimPopupMenuHandler$PlotMenuItem.setActionCommand(modelVariable.getObjectType() + ":" + modelVariable.getName() + ":" + element.getName());
                rSimPopupMenuHandler$PlotMenuItem.addActionListener(this);
                vector.addElement(rSimPopupMenuHandler$PlotMenuItem);
            }
            return vector;
        }
        Serializable serializable = element.getPlotTypeNames();
        if (element instanceof ReservoirElement && !(reservoirElement = (ReservoirElement)element).hasPowerPlant()) {
            object = "Power";
            serializable.removeElement(object);
        }
        for (int i = 0; i < serializable.size(); ++i) {
            Object e = serializable.get(i);
            if (e == null) continue;
            String string = e.toString();
            if (DEFAULT.equals(string)) {
                object = new RSimPopupMenuHandler$PlotMenuItem(this, "Plot");
                ((JComponent)object).setToolTipText("Default plot for " + element.getElementType());
            } else {
                object = new RSimPopupMenuHandler$PlotMenuItem(this, "Plot " + string);
            }
            ((RSimPopupMenuHandler$PlotMenuItem)object).setElement(element);
            ((AbstractButton)object).setActionCommand(element.getElementType() + ":plot:" + element.getName());
            ((AbstractButton)object).addActionListener(this);
            vector.addElement(object);
        }
        if (element instanceof ReservoirElement) {
            RSimSimulationMode rSimSimulationMode2 = (RSimSimulationMode)this._mode;
            object = rSimSimulationMode2.getRssRun();
            if (object != null && ((RssRun)object).shouldComputeWaterQuality()) {
                object = new RSimPopupMenuHandler$PlotMenuItem(this, "Plot WQ Color Contour");
                ((RSimPopupMenuHandler$PlotMenuItem)object).setElement(element);
                ((AbstractButton)object).setActionCommand(element.getElementType() + ":plotWQCC:" + element.getName());
                ((AbstractButton)object).addActionListener(this);
                vector.addElement(object);
                object = new RSimPopupMenuHandler$PlotMenuItem(this, "Plot Cold Water Pool");
                ((RSimPopupMenuHandler$PlotMenuItem)object).setElement(element);
                ((AbstractButton)object).setActionCommand(element.getElementType() + ":plotCWP:" + element.getName());
                ((AbstractButton)object).addActionListener(this);
                vector.addElement(object);
                object = new RSimPopupMenuHandler$PlotMenuItem(this, "Plot Outlet Temperature");
                ((RSimPopupMenuHandler$PlotMenuItem)object).setElement(element);
                ((AbstractButton)object).setActionCommand(element.getElementType() + ":plotOutletTemp:" + element.getName());
                ((AbstractButton)object).addActionListener(this);
                vector.addElement(object);
            }
            if (((ReservoirElement)element).getReservoirSysOp() != null && Boolean.getBoolean(SHOW_STORAGE_BALANCE_MENU_PROPERTY)) {
                serializable = this.buildStorageBalanceMenu((ReservoirElement)element);
                vector.add(serializable);
            }
        } else if (element instanceof ReachElement) {
            RSimSimulationMode rSimSimulationMode3 = (RSimSimulationMode)this._mode;
            object = rSimSimulationMode3.getRssRun();
            if (object != null && ((RssRun)object).shouldComputeWaterQuality()) {
                object = new RSimPopupMenuHandler$PlotMenuItem(this, "Plot WQ Time Series");
                ((RSimPopupMenuHandler$PlotMenuItem)object).setElement(element);
                ((AbstractButton)object).setActionCommand(element.getElementType() + ":plotWQTS:" + element.getName());
                ((AbstractButton)object).addActionListener(this);
                vector.addElement(object);
                object = new RSimPopupMenuHandler$PlotMenuItem(this, "Plot WQ Profile");
                ((RSimPopupMenuHandler$PlotMenuItem)object).setElement(element);
                ((AbstractButton)object).setActionCommand(element.getElementType() + ":plotWQPP:" + element.getName());
                ((AbstractButton)object).addActionListener(this);
                vector.addElement(object);
            }
        } else if (element instanceof JunctionElement && (object = (rSimSimulationMode = (RSimSimulationMode)this._mode).getRssRun()) != null && ((RssRun)object).shouldComputeWaterQuality()) {
            object = new RSimPopupMenuHandler$PlotMenuItem(this, "Plot WQ Time Series");
            ((RSimPopupMenuHandler$PlotMenuItem)object).setElement(element);
            ((AbstractButton)object).setActionCommand(element.getElementType() + ":plotJWQTS:" + element.getName());
            ((AbstractButton)object).addActionListener(this);
            vector.addElement(object);
            object = new RSimPopupMenuHandler$PlotMenuItem(this, "Plot Temperature");
            ((RSimPopupMenuHandler$PlotMenuItem)object).setElement(element);
            ((AbstractButton)object).setActionCommand(element.getElementType() + ":plotTotalOutletTemp:" + element.getName());
            ((AbstractButton)object).addActionListener(this);
            vector.addElement(object);
        }
        if (bl) {
            JMenu jMenu = this.createUserDefinedMenu();
            vector.addElement(jMenu);
        }
        vector = this.addPluginMenus(element, vector);
        return vector;
    }

    private JMenu buildStorageBalanceMenu(ReservoirElement reservoirElement) {
        JMenu jMenu = new JMenu("Storage Balance");
        RSimPopupMenuHandler$PlotMenuItem rSimPopupMenuHandler$PlotMenuItem = new RSimPopupMenuHandler$PlotMenuItem(this, "System Balance with Lag");
        rSimPopupMenuHandler$PlotMenuItem.setToolTipText("System Balance with Lag");
        rSimPopupMenuHandler$PlotMenuItem.setElement(reservoirElement);
        rSimPopupMenuHandler$PlotMenuItem.setActionCommand(reservoirElement.getElementType() + ":system balance with lag:" + reservoirElement.getName());
        rSimPopupMenuHandler$PlotMenuItem.addActionListener(this);
        jMenu.add(rSimPopupMenuHandler$PlotMenuItem);
        rSimPopupMenuHandler$PlotMenuItem = new RSimPopupMenuHandler$PlotMenuItem(this, "Percent of Zone Storage");
        rSimPopupMenuHandler$PlotMenuItem.setToolTipText("Percent of Zone Storage");
        rSimPopupMenuHandler$PlotMenuItem.setElement(reservoirElement);
        rSimPopupMenuHandler$PlotMenuItem.setActionCommand(reservoirElement.getElementType() + ":percent of zone storage:" + reservoirElement.getName());
        rSimPopupMenuHandler$PlotMenuItem.addActionListener(this);
        jMenu.add(rSimPopupMenuHandler$PlotMenuItem);
        rSimPopupMenuHandler$PlotMenuItem = new RSimPopupMenuHandler$PlotMenuItem(this, "Elevation Difference Relative to GC");
        rSimPopupMenuHandler$PlotMenuItem.setToolTipText("Elevation Difference in Relation to Top of Conservation");
        rSimPopupMenuHandler$PlotMenuItem.setElement(reservoirElement);
        rSimPopupMenuHandler$PlotMenuItem.setActionCommand(reservoirElement.getElementType() + ":elev diff:" + reservoirElement.getName());
        rSimPopupMenuHandler$PlotMenuItem.addActionListener(this);
        jMenu.add(rSimPopupMenuHandler$PlotMenuItem);
        rSimPopupMenuHandler$PlotMenuItem = new RSimPopupMenuHandler$PlotMenuItem(this, "Coefficient Balance Index");
        rSimPopupMenuHandler$PlotMenuItem.setToolTipText("Coefficient Balance Index");
        rSimPopupMenuHandler$PlotMenuItem.setElement(reservoirElement);
        rSimPopupMenuHandler$PlotMenuItem.setActionCommand(reservoirElement.getElementType() + ":coeff balance index:" + reservoirElement.getName());
        rSimPopupMenuHandler$PlotMenuItem.addActionListener(this);
        jMenu.add(rSimPopupMenuHandler$PlotMenuItem);
        rSimPopupMenuHandler$PlotMenuItem = new RSimPopupMenuHandler$PlotMenuItem(this, "System Zone Index");
        rSimPopupMenuHandler$PlotMenuItem.setToolTipText("System Zone Index");
        rSimPopupMenuHandler$PlotMenuItem.setElement(reservoirElement);
        rSimPopupMenuHandler$PlotMenuItem.setActionCommand(reservoirElement.getElementType() + ":system zone index:" + reservoirElement.getName());
        rSimPopupMenuHandler$PlotMenuItem.addActionListener(this);
        jMenu.add(rSimPopupMenuHandler$PlotMenuItem);
        rSimPopupMenuHandler$PlotMenuItem = new RSimPopupMenuHandler$PlotMenuItem(this, "System Storage Balance Index");
        rSimPopupMenuHandler$PlotMenuItem.setToolTipText("System Storage Balance Index");
        rSimPopupMenuHandler$PlotMenuItem.setElement(reservoirElement);
        rSimPopupMenuHandler$PlotMenuItem.setActionCommand(reservoirElement.getElementType() + ":system storage balance index:" + reservoirElement.getName());
        rSimPopupMenuHandler$PlotMenuItem.addActionListener(this);
        jMenu.add(rSimPopupMenuHandler$PlotMenuItem);
        return jMenu;
    }

    private Vector addPluginMenus(Element object, Vector vector) {
        List<JMenu> list;
        Object object2;
        if (object == null || vector == null) {
            return vector;
        }
        Map<String, List<JMenu>> map = object.getClass().getName();
        if ((map = _pluginMenuTable.get(map)) != null) {
            object2 = (List)map.get(object.getName());
            list = (List<JMenu>)map.get("");
            if (object2 != null) {
                vector.addAll(object2);
            }
            if (list != null) {
                vector.addAll(list);
            }
        }
        if ((object2 = object.getClass().getSuperclass()) != null) {
            map = ((Class)object2).getName();
            if ((map = _pluginMenuTable.get(map)) != null) {
                list = map.get(object.getName());
                object = map.get("");
                if (list != null) {
                    vector.addAll(list);
                }
                if (object != null) {
                    vector.addAll(object);
                }
            }
        }
        return vector;
    }

    JMenu createUserDefinedMenu() {
        if (this._userDefinedMenu == null) {
            this._userDefinedMenu = new JMenu(USER_DEFINED);
            this._userDefinedMenu.setToolTipText("Plots defined by the user");
            this._userDefinedMenu.addMenuListener(this);
        }
        return this._userDefinedMenu;
    }

    private Vector getMenuItems(JunctionElement junctionElement, boolean bl, boolean bl2) {
        Vector<Object> vector = new Vector<Object>();
        String string = junctionElement.getName();
        if (bl2) {
            vector.addElement(new RmaJMenuLabel(string));
            vector.add(new JSeparator());
            JMenuItem jMenuItem = new JMenuItem(this.getEditViewString() + "Junction Properties");
            jMenuItem.setActionCommand("junction:edit:" + string);
            jMenuItem.addActionListener(this);
            vector.addElement(jMenuItem);
            vector.add(new JSeparator());
        }
        if (this._mode instanceof RSimSimulationMode) {
            if (Boolean.getBoolean("oldPlotMenu")) {
                JMenuItem jMenuItem = new JMenuItem("Plot Regulated Flow");
                jMenuItem.setActionCommand("junction:plotregulatedflows:" + string);
                jMenuItem.addActionListener(this);
                vector.addElement(jMenuItem);
                jMenuItem = new JMenuItem("Plot Regulated Stage");
                jMenuItem.setActionCommand("junction:plotregulatedstage:" + string);
                jMenuItem.addActionListener(this);
                vector.addElement(jMenuItem);
            } else {
                this.getPlotList(junctionElement, vector, bl);
            }
        }
        return vector;
    }

    private void addMenuItems(JPopupMenu jPopupMenu, Vector vector, boolean n) {
        if (vector != null) {
            if (n != 0) {
                jPopupMenu.addSeparator();
            }
            for (n = 0; n < vector.size(); ++n) {
                Object e = vector.elementAt(n);
                if (e instanceof JMenuItem) {
                    jPopupMenu.add((JMenuItem)e);
                    continue;
                }
                if (e instanceof JSeparator) {
                    jPopupMenu.add((JSeparator)e);
                    continue;
                }
                jPopupMenu.add((Component)e);
            }
        }
    }

    private void addMenuItems(JMenu jMenu, JPopupMenu jPopupMenu, Vector vector, boolean bl) {
        if (vector != null) {
            int n;
            bl = false;
            for (n = 4; n < jPopupMenu.getComponentCount(); ++n) {
                if (jPopupMenu.getComponent(n) instanceof JMenu) continue;
                jPopupMenu.insert(jMenu, n);
                bl = true;
                break;
            }
            if (!bl) {
                jPopupMenu.add(jMenu);
            }
            for (n = 0; n < vector.size(); ++n) {
                Object e = vector.elementAt(n);
                if (e instanceof RSimPopupMenuHandler$PlotMenuItem) {
                    jMenu.add((RSimPopupMenuHandler$PlotMenuItem)e);
                    continue;
                }
                if (e instanceof JMenuItem) {
                    jPopupMenu.add((JMenuItem)e);
                    continue;
                }
                if (!(e instanceof JSeparator)) continue;
                jPopupMenu.add((JSeparator)e);
            }
        }
    }

    @Override
    public void menuCanceled(MenuEvent menuEvent) {
    }

    @Override
    public void menuDeselected(MenuEvent menuEvent) {
    }

    @Override
    public void menuSelected(MenuEvent object) {
        if (!((object = ((EventObject)object).getSource()) instanceof JMenu)) {
            return;
        }
        if (USER_DEFINED.equals(((AbstractButton)(object = (JMenu)object)).getText())) {
            int n;
            ((JMenu)object).removeAll();
            BitSet bitSet = new BitSet(4);
            Vector vector = new Vector();
            for (n = 0; n < this._selectedObjs.length; ++n) {
                Element element = (Element)this._selectedObjs[n];
                int n2 = element.getElementTypeId();
                if (--n2 < 0 || bitSet.get(n2)) continue;
                this.buildUserDefinedPlotMenu(vector, element);
                bitSet.set(n2);
            }
            Collections.sort(vector);
            for (n = 0; n < vector.size(); ++n) {
                ((JMenu)object).add((JMenuItem)vector.get(n));
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent object) {
        Object object2 = ((ActionEvent)object).getActionCommand();
        if (object2 == null) {
            return;
        }
        if (((StringTokenizer)(object2 = new StringTokenizer((String)object2, ":"))).countTokens() < 3) {
            return;
        }
        String string = ((StringTokenizer)object2).nextToken();
        String string2 = ((StringTokenizer)object2).nextToken();
        object2 = ((StringTokenizer)object2).nextToken();
        object = (JMenuItem)((EventObject)object).getSource();
        if (string2.equals("plot")) {
            RSimPopupMenuHandler rSimPopupMenuHandler = this;
            rSimPopupMenuHandler.plotElement(rSimPopupMenuHandler.findElement((String)object2, string), ((AbstractButton)object).getText());
            return;
        }
        if (string2.equals("plotWQTS")) {
            RSimPopupMenuHandler rSimPopupMenuHandler = this;
            rSimPopupMenuHandler.displayReachWaterQualityPlots(rSimPopupMenuHandler.findElement((String)object2, string));
            return;
        }
        if (string2.equals("plotJWQTS")) {
            object = this.findElement((String)object2, string);
            if (!(object instanceof JunctionElement)) {
                return;
            }
            this.displayJunctionWaterQualityPlots((JunctionElement)object);
            return;
        }
        if (string2.equals("plotWQPP")) {
            RSimPopupMenuHandler rSimPopupMenuHandler = this;
            rSimPopupMenuHandler.displayProfilePlot(rSimPopupMenuHandler.findElement((String)object2, string));
            return;
        }
        if (string2.equals("plotWQCC")) {
            RSimPopupMenuHandler rSimPopupMenuHandler = this;
            rSimPopupMenuHandler.displayWaterQualityColorContour(rSimPopupMenuHandler.findElement((String)object2, string));
            return;
        }
        if (string2.equals("plotCWP")) {
            RSimPopupMenuHandler rSimPopupMenuHandler = this;
            rSimPopupMenuHandler.displayColdWaterPool(rSimPopupMenuHandler.findElement((String)object2, string));
            return;
        }
        if (string2.equals("plotOutletTemp")) {
            RSimPopupMenuHandler rSimPopupMenuHandler = this;
            rSimPopupMenuHandler.displayWaterQualityFlowTemp(rSimPopupMenuHandler.findElement((String)object2, string), 40);
            return;
        }
        if (string2.equals("plotTotalOutletTemp")) {
            RSimPopupMenuHandler rSimPopupMenuHandler = this;
            rSimPopupMenuHandler.displayWaterQualityFlowTemp(rSimPopupMenuHandler.findElement((String)object2, string), 110);
            return;
        }
        if (string2.equals("systemstorageplot")) {
            RSimPopupMenuHandler rSimPopupMenuHandler = this;
            rSimPopupMenuHandler.displaySystemStoragePlot((ReservoirElement)rSimPopupMenuHandler.findElement((String)object2, string));
            return;
        }
        if (string2.equals("systemtsplot")) {
            RSimPopupMenuHandler rSimPopupMenuHandler = this;
            rSimPopupMenuHandler.displaySystemTSPlot((ReservoirElement)rSimPopupMenuHandler.findElement((String)object2, string));
            return;
        }
        if (string2.equals("defaultplot")) {
            this.defaultPlotElements();
            return;
        }
        if (string2.equals("userPlot")) {
            this.plotElements(((Component)object).getName(), ((AbstractButton)object).getText());
            return;
        }
        if (string.equalsIgnoreCase("res") || string.equalsIgnoreCase("reservoir")) {
            if (string2.equals("edit")) {
                this.editReservoir((String)object2);
                return;
            }
            if (REGULATED_FLOWS.equals(string2) || OUTLETS.equals(string2) || RELEASE.equals(string2) || SPILL.equals(string2) || ELEVATION.equals(string2) || STORAGE.equals(string2) || DEFAULT.equals(string2)) {
                this.plotReservoir((String)object2, string2);
                return;
            }
            if (string2.equals("releasedecisionreport")) {
                this.releaseDecisionReport((String)object2);
                return;
            }
        } else if (string.equalsIgnoreCase("diversion")) {
            if (string2.equals("edit")) {
                this.editDiversion((String)object2);
                return;
            }
            if (DEFAULT.equals(string2)) {
                this.plotDiversion((String)object2, string2);
                return;
            }
        } else if (string.equalsIgnoreCase("divertedoutlet")) {
            if (string2.equals("edit")) {
                this.editDivertedOutlet((String)object2);
                return;
            }
            if (DEFAULT.equals(string2)) {
                this.plotDivertedOutlet((String)object2, string2);
                return;
            }
        } else if (string.equalsIgnoreCase("reach")) {
            if (string2.equals("edit")) {
                this.editReach((String)object2);
                return;
            }
            if (object instanceof RSimPopupMenuHandler$PlotMenuItem) {
                object = (RSimPopupMenuHandler$PlotMenuItem)object;
                object = ((RSimPopupMenuHandler$PlotMenuItem)object).getModelVariable();
                this.plotReach((ModelVariable)object, (String)object2, string2);
                return;
            }
        } else if (string.equalsIgnoreCase("junction")) {
            if (string2.equals("edit")) {
                this.editJunction((String)object2);
                return;
            }
            if (object instanceof RSimPopupMenuHandler$PlotMenuItem) {
                object = (RSimPopupMenuHandler$PlotMenuItem)object;
                object = ((RSimPopupMenuHandler$PlotMenuItem)object).getModelVariable();
                this.plotJunction((ModelVariable)object, (String)object2, string2);
                return;
            }
            if (string2.equals("plotregulatedflows") || string2.equals("plotregulatedstage")) {
                this.plotJunction(null, (String)object2, string2);
                return;
            }
        } else if (string.equals("delete") && string2.equals("all")) {
            this.deleteSelectedObjects();
        }
    }

    void buildUserDefinedPlotMenu(Vector vector, Element element) {
        Object object;
        if (vector == null) {
            return;
        }
        if (!this._userDefinedMenuBuilt) {
            object = "/".concat(RSS.app().getAppType());
            this._userPlotMenus.clear();
            RSimPopupMenuHandler rSimPopupMenuHandler = this;
            rSimPopupMenuHandler.getPlotTypes(rSimPopupMenuHandler._userPlotMenus, (String)object, 0, element);
            RSimPopupMenuHandler rSimPopupMenuHandler2 = this;
            rSimPopupMenuHandler2.getPlotTypes(rSimPopupMenuHandler2._userPlotMenus, (String)object, 1, element);
            RSimPopupMenuHandler rSimPopupMenuHandler3 = this;
            rSimPopupMenuHandler3.getPlotTypes(rSimPopupMenuHandler3._userPlotMenus, (String)object, 2, element);
            RSimPopupMenuHandler rSimPopupMenuHandler4 = this;
            rSimPopupMenuHandler4.getPlotTypes(rSimPopupMenuHandler4._userPlotMenus, (String)object, 3, element);
            this._userDefinedMenuBuilt = true;
        }
        if (element == null) {
            return;
        }
        int n = element.getElementTypeId();
        for (int i = 0; i < this._userPlotMenus.size(); ++i) {
            object = (RSimPopupMenuHandler$PlotMenuItem)this._userPlotMenus.get(i);
            int n2 = ((RSimPopupMenuHandler$PlotMenuItem)object).getElementTypeId();
            if ((n2 & n) != n) continue;
            vector.add(object);
        }
    }

    void getPlotTypes(Vector object, String object2, int n, Element element) {
        object = PreferencesManager.getDirectoryForLocation((int)n);
        if (object == null) {
            return;
        }
        object = ((String)object).concat((String)object2);
        object2 = (RmiFileManager)RSS.app().getFileManager().getRemote();
        try {
            object = object2.getRemoteFileIDList(UserId.getUserId(), (String)object, "*.plotType");
        }
        catch (Exception exception) {
            System.out.println("getPlotTypes: RMI Error with FileManager " + String.valueOf(exception));
            return;
        }
        if (object == null) {
            return;
        }
        for (int i = 0; i < ((Vector)object).size(); ++i) {
            int n2;
            Identifier identifier = (Identifier)((Vector)object).get(i);
            object2 = identifier.getName();
            if (((String)object2).endsWith(".plotType")) {
                object2 = ((String)object2).substring(0, ((String)object2).indexOf(".plotType"));
            }
            if ((n2 = ((String)object2).indexOf("-")) == -1) {
                System.out.println("getPlotTypes: invalid plottype name " + (String)object2);
                continue;
            }
            String string = ((String)object2).substring(0, n2);
            object2 = ((String)object2).substring(n2 + 1);
            int n3 = RMAIO.parseInt((String)string, (int)-1);
            if (n3 == -1) {
                System.out.println("getPlotTypes: invalid element type id " + n3 + " for " + identifier.getName());
                continue;
            }
            object2 = DEFAULT.equals(object2) ? new RSimPopupMenuHandler$PlotMenuItem(this, "Plot", n3) : new RSimPopupMenuHandler$PlotMenuItem(this, (String)object2, n3);
            ((Component)object2).setName(identifier.getPath());
            ((AbstractButton)object2).setActionCommand(" :userPlot: ");
            ((AbstractButton)object2).addActionListener(this);
            this._userPlotMenus.add(object2);
        }
    }

    private void editReservoir(String string) {
        this._mode.editReservoir(string);
    }

    public void editReach(String string) {
        this._mode.editReach(string);
    }

    public void editDiversion(String string) {
        this._mode.editDiversion(string);
    }

    public void editDivertedOutlet(String string) {
        this._mode.editDivertedOutlet(string);
    }

    public void editJunction(String string) {
        this._mode.editJunction(string);
    }

    void plotJunction(ModelVariable object, String string, String object2) {
        if (this._selectedObjs == null || this._selectedObjs.length <= 0) {
            return;
        }
        object = new Vector();
        boolean bl = false;
        Element element = null;
        for (int i = 0; i < this._selectedObjs.length; ++i) {
            if (!this._selectedObjs[i].getName().equals(string) || !(this._selectedObjs[i] instanceof JunctionElement)) continue;
            element = (JunctionElement)this._selectedObjs[i];
            break;
        }
        if (element == null) {
            return;
        }
        if (((String)object2).indexOf("plotregulatedflows") >= 0) {
            object2 = element.getNodeVector();
            for (int i = 0; i < ((Vector)object2).size(); ++i) {
                RssNode rssNode = (RssNode)((Vector)object2).elementAt(i);
                if (rssNode == null) continue;
                TSRecordProxy tSRecordProxy = rssNode.getTSRecordProxy(0);
                if (tSRecordProxy == null) {
                    tSRecordProxy = rssNode.getTSRecordProxy(4);
                }
                if (tSRecordProxy == null) continue;
                ((Vector)object).addElement(tSRecordProxy);
            }
            object2 = string + " Regulated Flows";
        } else if (((String)object2).indexOf("plotregulatedstage") >= 0) {
            object2 = element.getFunction().getTSRecordProxy(66);
            if (object2 != null) {
                ((Vector)object).addElement(object2);
            }
            object2 = string + " Regulated Stage";
            bl = true;
        }
        this.plotTSRecords((Vector)object, (String)object2, bl);
    }

    void plotReach(ModelVariable modelVariable, String string, String string2) {
        if (this._selectedObjs == null || this._selectedObjs.length <= 0) {
            return;
        }
        Vector vector = new Vector();
        Element element = null;
        for (int i = 0; i < this._selectedObjs.length; ++i) {
            if (!this._selectedObjs[i].getName().equals(string) || !(this._selectedObjs[i] instanceof ReachElement)) continue;
            element = (ReachElement)this._selectedObjs[i];
            break;
        }
        if (element == null) {
            System.out.println("plotReach: failed to find Reach for " + string);
            return;
        }
        vector = element.getTSRecords(modelVariable, vector);
        this.plotTSRecords(vector, string2);
    }

    Vector getStorageZoneTSProxies(ReservoirElement reservoirElement, Vector vector) {
        Object object;
        if (vector == null) {
            vector = new Vector();
        }
        if ((object = reservoirElement.getReservoirOp()) == null) {
            return vector;
        }
        if (!(this._mode instanceof RSimSimulationMode)) {
            return vector;
        }
        object = (RSimSimulationMode)this._mode;
        Object object2 = ((RSimSimulationMode)object).getNetwork();
        if (object2 == null) {
            return vector;
        }
        object2 = ((RSimSimulationMode)object).getRssRunNames(true);
        int n = ((Vector)object2).size();
        if (n <= 0) {
            return vector;
        }
        for (int i = 0; i < n; ++i) {
            Object object3;
            RssRun rssRun = ((RSimSimulationMode)object).getRssRun(((Vector)object2).elementAt(i).toString());
            if (rssRun == null || (object3 = rssRun.getAlternative()) == null) continue;
            int n2 = ((RssAlt)object3).getResOpSetSelection(reservoirElement.getIndex());
            if ((object3 = ((RssAlt)object3).getSystem()) == null || (object3 = ((RssSystem)object3).findReservoir(reservoirElement.getName())) == null || (object3 = ((ReservoirElement)object3).getReservoirOp()) == null || (object3 = ((ReservoirOp)object3).getOperationSet(n2)) == null) continue;
            ((RssTSLocationObject)object3).updateTSProxyList();
            ((RssTSLocationObject)object3).getTSRecordProxyVec(76, vector);
            object.getSimulation().unloadManager("rss", rssRun.getIdentifier());
        }
        return vector;
    }

    void plotReservoir(String string, String string2) {
        if (this._selectedObjs == null || this._selectedObjs.length <= 0) {
            return;
        }
        ReservoirElement reservoirElement = null;
        for (int i = 0; i < this._selectedObjs.length; ++i) {
            if (!this._selectedObjs[i].getName().equals(string) || !(this._selectedObjs[i] instanceof ReservoirElement)) continue;
            reservoirElement = (ReservoirElement)this._selectedObjs[i];
            break;
        }
        if (reservoirElement == null) {
            System.out.println("plotReservoir: failed to find res element " + string);
            return;
        }
        this.plotReservoir(reservoirElement, string2);
    }

    public G2dDialog plotReservoir(ReservoirElement tSLocation, String object) {
        if (this._selectedObjs == null) {
            this._selectedObjs = new NamedType[]{tSLocation};
        }
        Vector<Object> vector = new Vector<Object>();
        String string = tSLocation.getName();
        if (((String)object).indexOf(DEFAULT) >= 0) {
            this.getStorageZoneTSProxies((ReservoirElement)tSLocation, vector);
            object = tSLocation.getStorageFunction();
            TSRecordProxy tSRecordProxy = ((RssTSLocationObject)object).getTSRecordProxy(10);
            if (tSRecordProxy != null) {
                vector.addElement(tSRecordProxy);
            }
            if ((tSRecordProxy = ((RssTSLocationObject)object).getTSRecordProxy(12)) != null) {
                vector.addElement(tSRecordProxy);
            }
            if ((tSRecordProxy = ((RssTSLocationObject)object).getTSRecordProxy(21)) != null) {
                vector.addElement(tSRecordProxy);
            }
            object = string + " Elevation-Inflow-Outflow";
        } else if (((String)object).indexOf(REGULATED_FLOWS) >= 0) {
            object = tSLocation.getNodeVector();
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                tSLocation = (RssNode)((Vector)object).elementAt(i);
                if (tSLocation == null || (tSLocation = tSLocation.getTSRecordProxy(0)) == null) continue;
                vector.addElement(tSLocation);
            }
            object = string + " Regulated Flows";
        } else if (((String)object).indexOf(OUTLETS) >= 0) {
            object = tSLocation.getElementsByClass(ReservoirOutletElement.class, null);
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                tSLocation = (Element)((Vector)object).elementAt(i);
                if ((tSLocation = tSLocation.getDownstreamNode()) == null) {
                    return null;
                }
                if ((tSLocation = tSLocation.getTSRecordProxy(0)) == null) continue;
                vector.addElement(tSLocation);
            }
            object = string + " Outlets";
        } else if (((String)object).indexOf(RELEASE) >= 0) {
            object = tSLocation.getElementsByClass(AdjustableFlow.class, null);
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                tSLocation = (Element)((Vector)object).elementAt(i);
                if ((tSLocation = tSLocation.getDownstreamNode()) == null) {
                    return null;
                }
                if ((tSLocation = tSLocation.getTSRecordProxy(0)) == null) continue;
                vector.addElement(tSLocation);
            }
            object = string + " Release";
        } else if (((String)object).indexOf(SPILL) >= 0) {
            object = tSLocation.getElementsByClass(Spillway.class, null);
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                tSLocation = (Element)((Vector)object).elementAt(i);
                if ((tSLocation = tSLocation.getDownstreamNode()) == null) {
                    return null;
                }
                if ((tSLocation = tSLocation.getTSRecordProxy(0)) == null) continue;
                vector.addElement(tSLocation);
            }
            object = string + " Spillway";
        } else if (((String)object).indexOf(ELEVATION) >= 0) {
            object = tSLocation.getStorageFunction();
            TSRecordProxy tSRecordProxy = ((RssTSLocationObject)object).getTSRecordProxy(10);
            if (tSRecordProxy != null) {
                vector.addElement(tSRecordProxy);
            }
            object = string + " Elevation";
        } else if (((String)object).indexOf(STORAGE) >= 0) {
            object = tSLocation.getStorageFunction();
            TSRecordProxy tSRecordProxy = ((RssTSLocationObject)object).getTSRecordProxy(11);
            if (tSRecordProxy != null) {
                vector.addElement(tSRecordProxy);
            }
            object = string + " Storage";
        } else {
            System.out.println("plotReservoir: unknown plot type " + (String)object);
            System.out.println("plotReservoir known plot type are [default, regulatedflows, outlets, release, spill, elevation, storage]");
            return null;
        }
        return this.plotTSRecords(vector, (String)object);
    }

    void plotDiversion(String string, String object) {
        if (this._selectedObjs == null || this._selectedObjs.length <= 0) {
            return;
        }
        Vector<Object> vector = new Vector<Object>();
        DiversionElement diversionElement = null;
        for (int i = 0; i < this._selectedObjs.length; ++i) {
            if (!this._selectedObjs[i].getName().equals(string) || !(this._selectedObjs[i] instanceof DiversionElement)) continue;
            diversionElement = (DiversionElement)this._selectedObjs[i];
            break;
        }
        if (diversionElement == null) {
            System.out.println("plotDiversion: failed to find diversion element " + string);
            return;
        }
        if (((String)object).indexOf(DEFAULT) >= 0) {
            object = diversionElement.getControlElement();
            object = ((Function)object).getElement();
            RssNode rssNode = ((Element)object).getDownstreamNode();
            if ((object = rssNode.getTSRecordProxy(0)) != null) {
                vector.addElement(object);
            }
        } else {
            System.out.println("plotReservoir: unknown plot type " + (String)object);
            return;
        }
        object = string + " Diversion";
        this.plotTSRecords(vector, (String)object);
    }

    void plotDivertedOutlet(String string, String object) {
        if (this._selectedObjs == null || this._selectedObjs.length <= 0) {
            return;
        }
        Vector<String> vector = new Vector<String>();
        Element element = null;
        for (int i = 0; i < this._selectedObjs.length; ++i) {
            if (!this._selectedObjs[i].getName().equals(string) || !(this._selectedObjs[i] instanceof DivertedOutletElement)) continue;
            element = (DivertedOutletElement)this._selectedObjs[i];
            break;
        }
        if (element == null) {
            System.out.println("plotDivertedOutlet: failed to find diversion element " + string);
            return;
        }
        if (((String)object).indexOf(DEFAULT) >= 0) {
            RssNode rssNode = element.getNode(0);
            object = rssNode.getTSRecordProxy(0);
            if (object != null) {
                vector.addElement((String)object);
            }
        } else {
            System.out.println("plotReservoir: unknown plot type " + (String)object);
            return;
        }
        object = string + " Diverted Outlet";
        this.plotTSRecords(vector, (String)object);
    }

    public Element findElement(String string, String string2) {
        if (this._selectedObjs == null || this._selectedObjs.length <= 0) {
            return null;
        }
        Element element = null;
        for (int i = 0; i < this._selectedObjs.length; ++i) {
            if (!this._selectedObjs[i].getName().equals(string) || !((Element)this._selectedObjs[i]).getElementType().equals(string2)) continue;
            element = (Element)this._selectedObjs[i];
            break;
        }
        if (element == null) {
            System.out.println("findElement: failed to find element " + string + " type=" + string2);
            return null;
        }
        return element;
    }

    public String getTimeWindow() {
        if (!(this._mode instanceof RSimSimulationMode)) {
            return null;
        }
        RSimSimulationMode rSimSimulationMode = (RSimSimulationMode)this._mode;
        return rSimSimulationMode.getSimulation().getTimeWindowString();
    }

    Vector getTSDataList(boolean bl) {
        Vector<TSDataSet> vector = new Vector<TSDataSet>();
        if (!(this._mode instanceof RSimSimulationMode)) {
            return vector;
        }
        RSimSimulationMode rSimSimulationMode = (RSimSimulationMode)this._mode;
        Vector vector2 = rSimSimulationMode.getRssRunNames(true);
        int n = vector2.size();
        System.out.println("getTSDataList: plotting " + n + " runs");
        if (n <= 0) {
            this.noRunsSelectedMessage("ResSim");
            return vector;
        }
        for (int i = 0; i < n; ++i) {
            RssRun rssRun = rSimSimulationMode.getRssRun(vector2.elementAt(i).toString());
            if (rssRun == null) {
                System.out.println("getTSDataVector: failed to find RssRun " + vector2.elementAt(0).toString());
                continue;
            }
            if (rssRun.getInputTSData() != null) {
                vector.addElement(rssRun.getInputTSData());
            }
            if (rssRun.getRegOutputTSData() != null) {
                vector.addElement(rssRun.getRegOutputTSData());
            }
            if (rssRun.getObservedTSData() != null) {
                vector.addElement(rssRun.getObservedTSData());
            }
            if (bl && rssRun.getUnregOutputTSData() != null) {
                vector.addElement(rssRun.getUnregOutputTSData());
            }
            if (bl && rssRun.getCumLocOutputTSData() != null) {
                vector.addElement(rssRun.getCumLocOutputTSData());
            }
            rSimSimulationMode.getSimulation().unloadManager("rss", rssRun.getIdentifier());
        }
        return vector;
    }

    public PlotDialog plotElements(String string, String object) {
        if (string == null) {
            return null;
        }
        if (!(this._mode instanceof RSimSimulationMode)) {
            return null;
        }
        RSimSimulationMode rSimSimulationMode = (RSimSimulationMode)this._mode;
        object = new PlotDialog((Frame)this._frame, (String)object, false);
        int n = this._selectedObjs.length;
        RSimPopupMenuHandler.addPlotTypeListeners((PlotDialog)object, this);
        ((PlotDialog)object).setTSDataList(this.getTSDataList(false));
        Vector<NamedType> vector = new Vector<NamedType>(n);
        for (int i = 0; i < n; ++i) {
            if (!(this._selectedObjs[i] instanceof PlottableObject)) continue;
            vector.add(this._selectedObjs[i]);
        }
        ((PlotDialog)object).setRssRuns(rSimSimulationMode.getRssRuns(true, true));
        object.setTimeWindow(this.getTimeWindow());
        ((PlotDialog)object).setPlotObjects(vector);
        ((PlotDialog)object).openPlotType(new Identifier(string));
        HecTime hecTime = new HecTime(rSimSimulationMode.getSimulation().getStartDateString());
        string = new HecTime(rSimSimulationMode.getSimulation().getEndDateString());
        HecTime hecTime2 = new HecTime(rSimSimulationMode.getSimulation().getLookbackDateString());
        ((PlotDialog)object).plotTimeWindow(new RunTimeWindow(hecTime, (HecTime)string, hecTime2), rSimSimulationMode.getSimulation().getGmtOffset(), "Time of Simulation");
        ((PlotDialog)object).setVisible(true);
        this._frame.repaint();
        return object;
    }

    private static void addPlotTypeListeners(PlotDialog plotDialog, PlotTypeListener plotTypeListenerArray) {
        if (plotTypeListenerArray != null) {
            plotDialog.addPlotTypeListener((PlotTypeListener)plotTypeListenerArray);
        }
        if ((plotTypeListenerArray = (PlotTypeListener[])_listenerList.getListeners(PlotTypeListener.class)) != null) {
            for (int i = 0; i < plotTypeListenerArray.length; ++i) {
                plotDialog.addPlotTypeListener(plotTypeListenerArray[i]);
            }
        }
    }

    void plotElement(Element element, String string) {
        int n;
        if (element == null || string == null) {
            return;
        }
        if (!(this._mode instanceof RSimSimulationMode)) {
            return;
        }
        RSimSimulationMode rSimSimulationMode = (RSimSimulationMode)this._mode;
        Vector vector = rSimSimulationMode.getRssRuns(true, true);
        HecTime hecTime = new HecTime(rSimSimulationMode.getSimulation().getStartDateString());
        HecTime hecTime2 = new HecTime(rSimSimulationMode.getSimulation().getEndDateString());
        HecTime hecTime3 = new HecTime(rSimSimulationMode.getSimulation().getLookbackDateString());
        int n2 = this._selectedObjs.length;
        Vector<NamedType> vector2 = new Vector<NamedType>(n2);
        for (n = 0; n < n2; ++n) {
            if (!(this._selectedObjs[n] instanceof PlottableObject)) continue;
            vector2.add(this._selectedObjs[n]);
        }
        RSimPopupMenuHandler.plotElement(element, string, vector, hecTime3, hecTime, hecTime2, rSimSimulationMode.getSimulation().getGmtOffset(), this, vector2);
        for (n = 0; n < vector.size(); ++n) {
            rSimSimulationMode.getSimulation().unloadManager("rss", ((RssRun)vector.get(n)).getIdentifier());
        }
        this._frame.repaint();
    }

    public static void plotElement(Element rssModelVariableConstants, String object, Vector vector, HecTime hecTime, HecTime hecTime2, HecTime hecTime3, int n, PlotTypeListener plotTypeListener, Vector vector2) {
        Object object2 = "";
        if (((String)object).startsWith("Plot")) {
            String string = object;
            object2 = object = string.substring(string.indexOf("Plot") + 4).trim();
        }
        if (object == null || ((String)object).length() == 0) {
            object = DEFAULT;
            object2 = "Default Plot";
        }
        Object object3 = new String();
        for (int i = 0; i < vector2.size(); ++i) {
            object3 = (String)object3 + " " + vector2.get(i).toString() + ",";
        }
        object2 = (String)object2 + " -" + (String)object3;
        BufferedReader bufferedReader = ((Element)rssModelVariableConstants).getPlotTypeFile((String)object);
        rssModelVariableConstants = new PlotDialog((Frame)ClientApp.frame(), (String)object2, false);
        RSimPopupMenuHandler.addPlotTypeListeners((PlotDialog)rssModelVariableConstants, plotTypeListener);
        ((PlotDialog)rssModelVariableConstants).setRssRuns(vector);
        if (hecTime != null) {
            object = hecTime.dateAndTime(104) + " " + hecTime3.dateAndTime(104);
        } else {
            if (hecTime2 == null || hecTime3 == null) {
                JOptionPane.showMessageDialog((Component)ClientApp.frame(), "Missing timewindow information for plot.\nStart time=" + String.valueOf(hecTime2) + "\n End Time=" + String.valueOf(hecTime3), "Missing Timewindow", 2);
                return;
            }
            object = hecTime2.dateAndTime(104) + " " + hecTime3.dateAndTime(104);
        }
        rssModelVariableConstants.setTimeWindow((String)object);
        ((PlotDialog)rssModelVariableConstants).setPlotObjects(vector2);
        if (!((PlotDialog)rssModelVariableConstants).openPlotType(bufferedReader)) {
            return;
        }
        ((PlotDialog)rssModelVariableConstants).plotTimeWindow(new RunTimeWindow(hecTime2, hecTime3, hecTime), n, "Time of Simulation");
        WindowUtilities.toFront((Window)((Object)rssModelVariableConstants));
        ((PlotDialog)rssModelVariableConstants).setVisible(true);
    }

    public void defaultPlotElements() {
        if (this._selectedObjs == null) {
            return;
        }
        if (!(this._mode instanceof RSimSimulationMode)) {
            return;
        }
        RSimSimulationMode rSimSimulationMode = (RSimSimulationMode)this._mode;
        Object object = "Plot -";
        int n = this._selectedObjs.length;
        Vector<NamedType> vector = new Vector<NamedType>(n);
        for (int i = 0; i < n; ++i) {
            if (!(this._selectedObjs[i] instanceof PlottableObject)) continue;
            vector.add(this._selectedObjs[i]);
            object = (String)object + " " + vector.get(i).toString() + ",";
        }
        PlotDialog plotDialog = new PlotDialog((Frame)this._frame, (String)object, false, vector, rSimSimulationMode.getRssRuns(true, true), this.getTimeWindow());
        plotDialog.addPlotTypeListener(this);
        object = (String)object + "-";
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        int n2 = gregorianCalendar.get(12);
        String string = "" + n2;
        if (string.length() < 2) {
            string = "0" + string;
        }
        object = (String)object + " " + gregorianCalendar.get(10) + ":" + string + (gregorianCalendar.get(9) == 0 ? "AM" : "PM");
        plotDialog.setTitle((String)object);
        object = new HecTime(rSimSimulationMode.getSimulation().getStartDateString());
        gregorianCalendar = new HecTime(rSimSimulationMode.getSimulation().getEndDateString());
        string = new HecTime(rSimSimulationMode.getSimulation().getLookbackDateString());
        plotDialog.plotTimeWindow(new RunTimeWindow((HecTime)object, (HecTime)gregorianCalendar, (HecTime)string), rSimSimulationMode.getSimulation().getGmtOffset(), "Time of Simulation");
        plotDialog.setVisible(true);
        this._frame.repaint();
    }

    public void plotElement(Element object, ModelVariable object2) {
        if (object == null || object2 == null) {
            return;
        }
        if (!(this._mode instanceof RSimSimulationMode)) {
            return;
        }
        object = (RSimSimulationMode)this._mode;
        object2 = ((RSimSimulationMode)object).getNetwork();
        if (object2 == null) {
            System.out.println("plotTSRecords: no network found");
            return;
        }
        object2 = ((RSimSimulationMode)object).getRssRunNames(true);
        int n = ((Vector)object2).size();
        System.out.println("plotElement: plotting " + n + " runs");
        if (n <= 0) {
            this.noRunsSelectedMessage("ResSim");
            return;
        }
        String string = "Run: ";
        String string2 = null;
        for (int i = 0; i < n; ++i) {
            RssRun rssRun = ((RSimSimulationMode)object).getRssRun(((Vector)object2).elementAt(i).toString());
            if (rssRun == null) {
                System.out.println("plotTSRecords: failed to find RssRun " + ((Vector)object2).elementAt(0).toString());
                continue;
            }
            if (string2 == null) {
                string2 = rssRun.getTimeWindowString();
            }
            Vector<TSDataSet> vector = new Vector<TSDataSet>();
            if (rssRun.getInputTSData() != null) {
                vector.addElement(rssRun.getInputTSData());
            }
            if (rssRun.getRegOutputTSData() != null) {
                vector.addElement(rssRun.getRegOutputTSData());
            }
            if (rssRun.getObservedTSData() != null) {
                vector.addElement(rssRun.getObservedTSData());
            }
            object.getSimulation().unloadManager("rss", rssRun.getIdentifier());
            if (vector.size() != 0) continue;
            return;
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        int n2 = gregorianCalendar.get(12);
        object = "" + n2;
        if (((String)object).length() < 2) {
            object = "0" + (String)object;
        }
        String cfr_ignored_0 = string + " " + gregorianCalendar.get(10) + ":" + (String)object + (gregorianCalendar.get(9) == 0 ? "AM" : "PM");
    }

    public G2dDialog plotTSRecords(Vector vector, String string) {
        return this.plotTSRecords(vector, string, false);
    }

    public G2dDialog plotTSRecords(Vector vector, String string, boolean bl) {
        Object object;
        Object object2;
        int n;
        String string2;
        int n2;
        if (vector.size() <= 0) {
            return null;
        }
        if (!(this._mode instanceof RSimSimulationMode)) {
            return null;
        }
        RSimSimulationMode rSimSimulationMode = (RSimSimulationMode)this._mode;
        Object object3 = rSimSimulationMode.getNetwork();
        if (object3 == null) {
            System.out.println("plotTSRecords: no network found");
            return null;
        }
        object3 = rSimSimulationMode.getRssRunNames(true);
        int n3 = ((Vector)object3).size();
        System.out.println("plotTSRecords: plotting " + n3 + " runs");
        if (n3 <= 0) {
            this.noRunsSelectedMessage("ResSim");
            return null;
        }
        Object object4 = "Run: ";
        String string3 = null;
        RunTimeWindow runTimeWindow = null;
        Vector<Object> vector2 = new Vector<Object>();
        Vector<TSDataSet> vector3 = new Vector<TSDataSet>();
        Object object5 = RSS.Workspace();
        int n4 = object5.getWatershedTimeZone().getRawOffset() / 3600000;
        for (int i = 0; i < n3; ++i) {
            object5 = rSimSimulationMode.getRssRun(((Vector)object3).elementAt(i).toString());
            if (object5 == null) {
                System.out.println("plotTSRecords: failed to find RssRun " + ((Vector)object3).elementAt(0).toString());
                continue;
            }
            if (string3 == null) {
                string3 = ((RssRun)object5).getTimeWindowString();
            }
            if (runTimeWindow == null) {
                runTimeWindow = new RunTimeWindow(((RssRun)object5).getRunTimeWindow());
                object5.getGmtOffset();
            }
            vector3.clear();
            if (((RssRun)object5).getInputTSData() != null) {
                vector3.addElement(((RssRun)object5).getInputTSData());
            }
            if (((RssRun)object5).getRegOutputTSData() != null) {
                vector3.addElement(((RssRun)object5).getRegOutputTSData());
            }
            if (((RssRun)object5).getObservedTSData() != null) {
                vector3.addElement(((RssRun)object5).getObservedTSData());
            }
            if (bl && ((RssRun)object5).getUnregOutputTSData() != null) {
                vector3.addElement(((RssRun)object5).getUnregOutputTSData());
            }
            if (bl && ((RssRun)object5).getCumLocOutputTSData() != null) {
                vector3.addElement(((RssRun)object5).getCumLocOutputTSData());
            }
            rSimSimulationMode.getSimulation().unloadManager("rss", object5.getIdentifier());
            if (vector3.size() == 0) {
                return null;
            }
            try {
                for (n2 = 0; n2 < vector.size(); ++n2) {
                    string2 = (TSRecordProxy)vector.elementAt(n2);
                    if (string2 == null) continue;
                    for (n = 0; n < vector3.size(); ++n) {
                        object2 = (TSDataSet)vector3.elementAt(n);
                        if ((object2 = object2.getTSRecord(string2.getName(), string2.getVariableId())) == null) continue;
                        object = object2.getDSSFilename();
                        String string4 = object2.getDSSPathname();
                        System.out.println("plotTSRecords: file=" + (String)object + "\n path=" + string4);
                        object2 = new DataReference(string4, (String)object);
                        object2.setGmtOffset(n4);
                        vector2.addElement(object2);
                    }
                }
                continue;
            }
            catch (Exception exception) {
                System.out.println("Failed to get DSS records for run " + String.valueOf(object5) + " plot.");
            }
        }
        if (vector2.size() == 0) {
            return null;
        }
        Group group = new Group((String)object4, vector2, string3);
        object4 = (String)object4 + "-" + string;
        object2 = new GregorianCalendar();
        n2 = ((Calendar)object2).get(12);
        string2 = "" + n2;
        if (string2.length() < 2) {
            string2 = "0" + string2;
        }
        object4 = (String)object4 + " " + ((Calendar)object2).get(10) + ":" + string2 + (((Calendar)object2).get(9) == 0 ? "AM" : "PM");
        object2 = new PlotDialog((Frame)this._frame, (String)object4, false, group);
        n = this._selectedObjs.length;
        ((PlotDialog)object2).setTSDataList(vector3);
        object = new Vector(n);
        for (int i = 0; i < n; ++i) {
            if (!(this._selectedObjs[i] instanceof PlottableObject)) continue;
            ((Vector)object).add(this._selectedObjs[i]);
        }
        ((PlotDialog)object2).setPlotObjects((Vector)object);
        HecTime hecTime = new HecTime(rSimSimulationMode.getSimulation().getStartDateString());
        vector = new HecTime(rSimSimulationMode.getSimulation().getEndDateString());
        string = new HecTime(rSimSimulationMode.getSimulation().getLookbackDateString());
        ((PlotDialog)object2).plotTimeWindow(new RunTimeWindow(hecTime, (HecTime)vector, (HecTime)string), rSimSimulationMode.getSimulation().getGmtOffset(), "Time of Simulation");
        ((PlotDialog)object2).setVisible(true);
        this._frame.repaint();
        return object2;
    }

    public void releaseDecisionReport(String string) {
        if (this._mode instanceof RSimSimulationMode) {
            RSimSimulationMode rSimSimulationMode = (RSimSimulationMode)this._mode;
            rSimSimulationMode.menuResReleaseDecisionReport_Action(string);
        }
    }

    private void noRunsSelectedMessage(String string) {
        JOptionPane.showMessageDialog((Component)RSS.frame(), "No Runs Selected or no selected Runs contain " + string + " models", "No Runs Found", 1);
    }

    protected String getEditViewString() {
        if (this._mode.hasWriteLock()) {
            return "Edit ";
        }
        return "View ";
    }

    protected void deleteSelectedObjects() {
        int n;
        if (this._selectedObjs == null || this._selectedObjs.length == 0) {
            return;
        }
        if (!(this._mode instanceof RSimNetworkMode)) {
            return;
        }
        RSimNetworkMode rSimNetworkMode = (RSimNetworkMode)this._mode;
        int n2 = JOptionPane.showConfirmDialog((Component)this._frame, "Delete all selected Network elements?", "Confirm Deletion", 0);
        if (n2 == 1) {
            return;
        }
        for (n = 0; n < this._selectedObjs.length; ++n) {
            Element element = (Element)this._selectedObjs[n];
            if (element instanceof DiversionElement) {
                rSimNetworkMode.deleteDiversion(element.getName(), false);
                continue;
            }
            if (element instanceof ReservoirElement) {
                rSimNetworkMode.deleteReservoir(element.getName(), false);
                continue;
            }
            if (element instanceof ReachElement) {
                rSimNetworkMode.deleteReach(element.getName(), false);
                continue;
            }
            if (!(element instanceof DivertedOutletElement)) continue;
            rSimNetworkMode.deleteDivertedOutlet(element.getName(), false);
        }
        for (n = 0; n < this._selectedObjs.length; ++n) {
            Element element = (Element)this._selectedObjs[n];
            if (!(element instanceof JunctionElement)) continue;
            rSimNetworkMode.deleteJunction(element.getName(), false);
        }
    }

    public void plotTypesChanged(PlotTypeChangedEvent plotTypeChangedEvent) {
        this._userDefinedMenuBuilt = false;
    }

    public static <T extends Element> void addElementMenu(Class<T> arrayList, String string, JMenu jMenu) {
        if (arrayList == null || jMenu == null) {
            return;
        }
        Map<String, List<JMenu>> map = _pluginMenuTable.get(((Class)((Object)arrayList)).getName());
        if (map == null) {
            map = new HashMap<String, List<JMenu>>();
            _pluginMenuTable.put(((Class)((Object)arrayList)).getName(), map);
        }
        if (string == null) {
            string = "";
        }
        if ((arrayList = map.get(string)) == null) {
            arrayList = new ArrayList<JMenu>();
            map.put(string, arrayList);
        }
        arrayList.add(jMenu);
    }

    public void setSelectedElements(Element ... elementArray) {
        this._selectedObjs = elementArray;
    }

    public void addPlotTypeListener(PlotTypeListener plotTypeListener) {
        if (plotTypeListener == null) {
            return;
        }
        _listenerList.add(PlotTypeListener.class, plotTypeListener);
    }

    public void removePlotTypeListener(PlotTypeListener plotTypeListener) {
        _listenerList.remove(PlotTypeListener.class, plotTypeListener);
    }
}

