/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import com.google.common.flogger.FluentLogger;
import hec.appInterface.AppDaddy;
import hec.client.RunObserver;
import hec.client.TextFileEditorDialog;
import hec.clientapp.client.AbstractSimulationMode;
import hec.clientapp.client.ClientApp;
import hec.clientapp.client.ClientWorkspace;
import hec.clientapp.client.CreateSimulationDialog;
import hec.clientapp.client.HecClientFrame;
import hec.clientapp.client.PopupMenuHandler;
import hec.clientapp.client.RemoteFileChooser;
import hec.clientapp.client.RmiProgressImpl;
import hec.clientapp.client.SimTrialRunTreeNode;
import hec.clientapp.client.SimulationMode;
import hec.clientapp.client.SimulationRunDetailsPanel;
import hec.clientapp.client.SimulationRunTreeNode;
import hec.clientapp.client.SimulationTree;
import hec.clientapp.client.SimulationTreeCellRenderer;
import hec.clientapp.client.SimulationTreeNode;
import hec.clientapp.model.AbstractSimulation;
import hec.clientapp.model.Manager;
import hec.clientapp.model.ManagerProxyListContainer;
import hec.clientapp.model.SimulationExtract;
import hec.clientapp.model.SimulationPeriod;
import hec.clientapp.model.SimulationRun;
import hec.clientapp.model.SimulationTrialRun;
import hec.clientapp.rmi.csinterface.HecRmiWorkspace;
import hec.data.TimeWindow;
import hec.event.ActiveRunChangeListener;
import hec.event.ModifiableListener;
import hec.gfx2d.G2dDialog;
import hec.gfx2d.G2dGlyph;
import hec.gfx2d.G2dTimeSeriesLine;
import hec.gfx2d.Viewport;
import hec.io.DSSIdentifier;
import hec.io.Identifier;
import hec.map.MapMouseAdapter;
import hec.model.RunInfo;
import hec.model.RunTimeWindow;
import hec.model.StreamElement;
import hec.rss.RssRmiWorkspace;
import hec.rss.client.AbstractAlternativeEditor;
import hec.rss.client.AltDssComparisonDlg;
import hec.rss.client.AlternativeEditor;
import hec.rss.client.ConnectivityDlg;
import hec.rss.client.CopySimulationDataDialog;
import hec.rss.client.EditVerticalDatumAction;
import hec.rss.client.ElementListReport;
import hec.rss.client.EnsembleRmiProgressImpl;
import hec.rss.client.EnsembleRmiTextFileReaderJDialog;
import hec.rss.client.ExtractFailuresDialog;
import hec.rss.client.FloatingWaterAccountDialog;
import hec.rss.client.JunctionElementVerticalDatumSettingsProvider;
import hec.rss.client.NetworkConversionMessage;
import hec.rss.client.NetworkConversionMessage$NetworkChangeStatus;
import hec.rss.client.PlotDialog;
import hec.rss.client.PowerReportEditor;
import hec.rss.client.RSSDecisionSummaryReport;
import hec.rss.client.RSSSimRunDetailsPanel;
import hec.rss.client.RSimBaseMode;
import hec.rss.client.RSimPopupMenuHandler;
import hec.rss.client.RSimSimulationMode$1;
import hec.rss.client.RSimSimulationMode$2;
import hec.rss.client.RSimSimulationMode$3;
import hec.rss.client.RSimSimulationMode$4;
import hec.rss.client.RSimSimulationMode$5;
import hec.rss.client.RSimSimulationMode$6;
import hec.rss.client.ResSimAdvancedOptionsPanel;
import hec.rss.client.ResSimComputeOptionsPanel;
import hec.rss.client.ResSimReportsFactory;
import hec.rss.client.ReservoirElementVerticalDatumSettingsProvider;
import hec.rss.client.ReservoirJFrame;
import hec.rss.client.ReservoirSystemJDialog;
import hec.rss.client.ReservoirVsYieldAnalysisPlotDialog;
import hec.rss.client.RssReportsTableListener;
import hec.rss.client.RssSimEditDialog;
import hec.rss.client.RssSimTrialRunTreeNode;
import hec.rss.client.RssSimulationRunTreeNode;
import hec.rss.client.RssSimulationTree;
import hec.rss.client.RssSpecifyOverridesDialog;
import hec.rss.client.RssSummaryJFrame;
import hec.rss.client.RssSystemDPData;
import hec.rss.client.RssSystemGlyph;
import hec.rss.client.RunDetailsUtilities;
import hec.rss.client.SimulationDialog;
import hec.rss.client.SimulationListReport;
import hec.rss.client.SimulationRunGlyph;
import hec.rss.client.StateVariableDialog;
import hec.rss.client.WaterAccountMultipleReservoirsPlotDialog;
import hec.rss.client.WaterAccountPlotDialog;
import hec.rss.client.WaterAccountSetEditor;
import hec.rss.client.YieldAnalysisResultsPlotDialog;
import hec.rss.client.YieldFlowConvergencePlot;
import hec.rss.client.YieldStorageConvergencePlot;
import hec.rss.client.YieldTrialResultsPlot;
import hec.rss.client.datum.VerticalDatumSettingsProvider;
import hec.rss.client.globalvariable.GlobalVariableEditor;
import hec.rss.client.reports.AlternativeInputReportEditor;
import hec.rss.client.reports.UserReportEditor;
import hec.rss.client.reports.UserReportViewerFrame;
import hec.rss.client.reports.YieldAnalysisReportDialog;
import hec.rss.map.ResSimPointerMouseAdapter;
import hec.rss.model.ComputeStatus;
import hec.rss.model.DiversionElement;
import hec.rss.model.Element;
import hec.rss.model.JunctionElement;
import hec.rss.model.OpSet;
import hec.rss.model.ReachElement;
import hec.rss.model.ReservoirElement;
import hec.rss.model.ReservoirOp;
import hec.rss.model.ReservoirStorageVsYieldAnalysis;
import hec.rss.model.RssAlt;
import hec.rss.model.RssNode;
import hec.rss.model.RssReturnStatusConstants;
import hec.rss.model.RssRun;
import hec.rss.model.RssSimRun;
import hec.rss.model.RssSimulationRun;
import hec.rss.model.RssSystem;
import hec.rss.model.SimulationExtractModel;
import hec.rss.model.StorageZoneRef;
import hec.rss.model.WaterAccountSet;
import hec.rss.model.YieldAnalysisType;
import hec.rss.server.DiversionEditorDlg;
import hec.rss.server.JunctionDialog;
import hec.rss.server.ReachDlg;
import hec.rss.server.RssAdvancedOptions;
import hec.rss.wq.client.WaterQualityEditors;
import hec.rss.wq.client.WqClientMode;
import hec.rss.wq.client.WqTsTable;
import hec.rss.wq.client.boundarycondition.BoundaryConditionEditorDialog;
import hec.rss.wq.client.constituentSet.ConstituentSetEditor;
import hec.rss.wq.client.dispersionCoeff.client.DispersionCoefEditor;
import hec.rss.wq.client.geometry.GeometryEditor;
import hec.rss.wq.client.geometry.ReachCellsMapObject;
import hec.rss.wq.client.geometry.ReachWaterQualitySegmentPopupMenuHandler;
import hec.rss.wq.client.initialcondition.InitialConditionsEditor;
import hec.rss.wq.client.massinjection.MassInjectionEditor;
import hec.rss.wq.client.metstation.MetStationSetDialog;
import hec.rss.wq.client.observeddataset.ObservedStationNamedType;
import hec.rss.wq.client.observeddataset.ObservedStationSetDialog;
import hec.rss.wq.client.observeddataset.ObservedStationSimulationPopupMenuHandler;
import hec.rss.wq.client.wqParameters.ParameterSetEditor;
import hec.rss.wq.model.AltWaterQualityOptions;
import hec.rss.wq.model.BoundaryConditionSetManager;
import hec.rss.wq.model.ConstituentSetManager;
import hec.rss.wq.model.InitialConditionSetManager;
import hec.rss.wq.model.MetData;
import hec.rss.wq.model.ObsDatasetManager;
import hec.rss.wq.model.ReachWaterQualitySegment;
import hec.rss.wq.model.WqGeometry;
import hec.rss.wq.model.dispersionCoeff.DispersionSetManager;
import hec.rss.wq.model.massinjection.MassInjectionManager;
import hec.rss.wq.model.massinjection.MassInjectionSetManager;
import hec.rss.wq.model.wqParameters.ParameterSetManager;
import hec.rss.wq.util.WqI18n;
import hec.wqengineimpl.massInjection.WQMassInjectionSite;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import mil.army.usace.hec.rmi.csinterface.DSSManager;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;
import mil.army.usace.hec.rmi.gfx2d.SimpleDSSTimeSeries;
import mil.army.usace.hec.rmi.gfx2d.SimpleDSSTimeSeriesGlyph;
import mil.army.usace.hec.rmi.server.RmiFileCallBackImpl;
import rma.lang.Modifiable;
import rma.swing.ButtonCmdPanel;
import rma.swing.ClosableDialog;
import rma.swing.DefaultJPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJDialog;
import rma.swing.RmaJFrame;
import rma.swing.RmaJTextArea;
import rma.swing.RmaJTextField;
import rma.swing.event.ReflectMultiListener;
import rma.swing.tree.CheckBoxNode;
import rma.util.RMAConst;
import rma.util.RMAIO;

public class RSimSimulationMode
extends AbstractSimulationMode
implements RunObserver,
SimulationMode,
ActiveRunChangeListener,
ModifiableListener,
RSimBaseMode,
RssReportsTableListener,
WqClientMode,
ActionListener {
    private static final FluentLogger LOGGER = FluentLogger.forEnclosingClass();
    public static final String MODE_NAME = "Simulation";
    private static final String SIMULATION_TYPE = "Simulation";
    private static final String SIMULATION_RUN_CLASS = RssSimRun.class.getName();
    private WaterAccountPlotDialog _waterAccountPlotDialog;
    private WaterAccountMultipleReservoirsPlotDialog _waterAccountMultipleReservoirsPlotDialog;
    JMenu _roMenu;
    JMenu _computeLogsMenu;
    JMenuItem _editDiversionsMenuItem;
    JMenuItem _editReservoirsMenuItem;
    JMenuItem _editReachesMenuItem;
    JMenuItem _releaseDecisionMenuItem;
    JMenuItem _editJunctionsMenuItem;
    JMenuItem _editVerticalDatumMenuItem;
    JMenuItem _editResSysOpMenuItem;
    JMenuItem _editStateVariablesMenuItem;
    JMenuItem _editWaterAccountSetsMenuItem;
    ElementListReport _reservoirListReport;
    ElementListReport _reachListReport;
    ElementListReport _junctionListReport;
    ElementListReport _diversionListReport;
    ConnectivityDlg _connectivityDlg;
    AlternativeEditor m_alternativeEditor = null;
    AlternativeEditor m_singleAlternativeEditor = null;
    protected JCheckBoxMenuItem _editConfigMenuItem;
    private WaterAccountSetEditor _waterAccountSetEditor;
    RssSimulationRun _activeSimRun;
    RssSummaryJFrame _repRssSumm = null;
    RssSummaryJFrame _repJctSumm = null;
    RssSummaryJFrame _repStageSumm = null;
    RssSummaryJFrame _powerReport;
    RssSummaryJFrame _gatesReport;
    RssSpecifyOverridesDialog _specRelDlg;
    private List<String> _failedRunNames;
    private RSimPopupMenuHandler _popupMenuHandler;
    RssSystem _network;
    ReachDlg _reachDlg;
    JunctionDialog fillForm;
    ReservoirJFrame _resDlg;
    DiversionEditorDlg _divDlg;
    JunctionDialog _juncDlg;
    StateVariableDialog _stateVariableDialog;
    private ResSimComputeOptionsPanel _computeOptionsPanel;
    private ResSimAdvancedOptionsPanel _advancedOptionsPanel;
    HecClientFrame _parent;
    RmiFileCallBackImpl _networkCallBack;
    ReservoirSystemJDialog _resSysOpsDlg;
    private JMenu _userReportsMenu;
    private JMenuItem _editUserReportsMenuItem;
    private UserReportEditor _userReportEditor;
    private JMenuItem _saveResultsMenu;
    private JMenuItem _runDssCompareMenu;
    private JMenuItem _editRunPropMenuItem;
    private RssSimEditDialog _runEditDialog;
    private SimulationListReport _simulationsReport;
    private JMenuItem _replaceFromBaseMenuItem;
    private JLabel _networkLabel;
    private RmaJTextField _networkTxt;
    private JMenuItem _extractMenu;
    private JMenu _altInputReportMenu;
    private JMenu _yieldAnalysisMenu;
    private JMenu _waterAccountPlotMenu;
    private JMenu _waterAccountMultipleReservoirsPlotMenu;
    private JMenu _floatingWaterAccountPlotMenu;
    private FloatingWaterAccountDialog _floatingWaterAccountDialog;
    private JMenuItem _debugV4ReportMenu;
    private JCheckBoxMenuItem _setPlotsToRefreshMenu;
    private JMenu _wqEditorsMenu;
    private JMenu _wqDebugReportsMenu;
    private WaterQualityEditors _wqEditorLauncher;
    private MassInjectionManager _massInjectionMgr;
    private JMenuItem _editGlobalVariablesMenuItem;
    private GlobalVariableEditor _globalVariableDialog;

    public RSimSimulationMode(HecClientFrame hecClientFrame) {
        super(hecClientFrame);
        this._parent = hecClientFrame;
        this._listener = new ReflectMultiListener();
        this._editConfigMenuItem = new JCheckBoxMenuItem();
        this.setMenuName("Simulation");
        this.createFrameToolBar();
        this._wqEditorLauncher = new WaterQualityEditors();
        this.addPopupMenuHandler(ObservedStationNamedType.class, new ObservedStationSimulationPopupMenuHandler(this));
        this.addPopupMenuHandler(ReachWaterQualitySegment.class, new ReachWaterQualitySegmentPopupMenuHandler(this));
        this._reportsMenu.addMenuListener(new RSimSimulationMode$1(this));
    }

    public DefaultJPanel[] getModuleOptionsPanels() {
        boolean bl = ClientApp.Workspace() != null;
        DefaultJPanel[] defaultJPanelArray = super.getModuleOptionsPanels();
        int n = defaultJPanelArray != null ? defaultJPanelArray.length : 0;
        int n2 = n + 1;
        if (bl) {
            ++n2;
        }
        DefaultJPanel[] defaultJPanelArray2 = new DefaultJPanel[n2];
        for (int i = 0; i < n; ++i) {
            defaultJPanelArray2[i] = defaultJPanelArray[i];
        }
        if (this._advancedOptionsPanel == null) {
            this._advancedOptionsPanel = new ResSimAdvancedOptionsPanel();
        }
        defaultJPanelArray2[defaultJPanelArray2.length - 2] = this._advancedOptionsPanel;
        if (bl) {
            if (this._computeOptionsPanel == null) {
                this._computeOptionsPanel = new ResSimComputeOptionsPanel();
            }
            defaultJPanelArray2[defaultJPanelArray2.length - 1] = this._computeOptionsPanel;
        }
        return defaultJPanelArray2;
    }

    public void nodeSelected(CheckBoxNode checkBoxNode) {
        this.updateMenus();
    }

    public void createFrameToolBar() {
        this._networkLabel = new JLabel();
        this._networkLabel.setText("Network:");
        this._networkLabel.setToolTipText("Active Reservoir Network Name");
        RSimSimulationMode rSimSimulationMode = this;
        rSimSimulationMode.addToolBarComponent(rSimSimulationMode._networkLabel);
        this._networkTxt = new RmaJTextField();
        this._networkTxt.setEditable(false);
        Dimension dimension = this._networkTxt.getPreferredSize();
        this._networkTxt.getPreferredSize().width = 125;
        this._networkTxt.setMinimumSize(dimension);
        this._networkTxt.setPreferredSize(dimension);
        this._networkTxt.setToolTipText("Active Reservoir Network Name");
        RSimSimulationMode rSimSimulationMode2 = this;
        rSimSimulationMode2.addToolBarComponent((JComponent)rSimSimulationMode2._networkTxt);
    }

    protected boolean hasPanMouseAdapter() {
        return Boolean.getBoolean("Map.HasPanMouseTool");
    }

    protected Class<? extends MapMouseAdapter> getPointerMouseToolClass() {
        return ResSimPointerMouseAdapter.class;
    }

    protected void createModeMenu() {
        super.createModeMenu();
        this._replaceFromBaseMenuItem = new JMenuItem("Replace from Base...", 66);
        RSimSimulationMode rSimSimulationMode = this;
        this._replaceFromBaseMenuItem.addActionListener((ActionListener)this._listener.add((Object)rSimSimulationMode, (Object)rSimSimulationMode._replaceFromBaseMenuItem, "replaceFromBaseAction"));
        this._simMenu.insert(this._replaceFromBaseMenuItem, 4);
        JMenuItem jMenuItem = new JMenuItem("Simulation List...", 83);
        jMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)jMenuItem, "displaySimulationsReport"));
        this._simMenu.insert(jMenuItem, 4);
        this._editReservoirsMenuItem = new JMenuItem("Reservoirs...", 82);
        this._editReservoirsMenuItem.setName("Edit_Reservoirs");
        RSimSimulationMode rSimSimulationMode2 = this;
        this._editReservoirsMenuItem.addActionListener((ActionListener)this._listener.add((Object)rSimSimulationMode2, (Object)rSimSimulationMode2._editReservoirsMenuItem, "editReservoir"));
        RSimSimulationMode rSimSimulationMode3 = this;
        rSimSimulationMode3.addEditMenuItem(rSimSimulationMode3._editReservoirsMenuItem);
        this._editReachesMenuItem = new JMenuItem("Reaches...", 101);
        this._editReachesMenuItem.setName("Edit_Reaches");
        RSimSimulationMode rSimSimulationMode4 = this;
        this._editReachesMenuItem.addActionListener((ActionListener)this._listener.add((Object)rSimSimulationMode4, (Object)rSimSimulationMode4._editReachesMenuItem, "editReach"));
        RSimSimulationMode rSimSimulationMode5 = this;
        rSimSimulationMode5.addEditMenuItem(rSimSimulationMode5._editReachesMenuItem);
        this._editJunctionsMenuItem = new JMenuItem("Junctions...", 74);
        this._editJunctionsMenuItem.setName("Edit_Junctions");
        RSimSimulationMode rSimSimulationMode6 = this;
        this._editJunctionsMenuItem.addActionListener((ActionListener)this._listener.add((Object)rSimSimulationMode6, (Object)rSimSimulationMode6._editJunctionsMenuItem, "editJunction"));
        RSimSimulationMode rSimSimulationMode7 = this;
        rSimSimulationMode7.addEditMenuItem(rSimSimulationMode7._editJunctionsMenuItem);
        this._editDiversionsMenuItem = new JMenuItem("Diversions...", 68);
        this._editDiversionsMenuItem.setName("Edit_Diversions");
        RSimSimulationMode rSimSimulationMode8 = this;
        this._editDiversionsMenuItem.addActionListener((ActionListener)this._listener.add((Object)rSimSimulationMode8, (Object)rSimSimulationMode8._editDiversionsMenuItem, "editDiversion"));
        RSimSimulationMode rSimSimulationMode9 = this;
        rSimSimulationMode9.addEditMenuItem(rSimSimulationMode9._editDiversionsMenuItem);
        this._editVerticalDatumMenuItem = new JMenuItem("Vertical Datum...", 86);
        this._editVerticalDatumMenuItem.setName("Edit_Vertical_Datum");
        RSimSimulationMode rSimSimulationMode10 = this;
        this._editVerticalDatumMenuItem.addActionListener((ActionListener)this._listener.add((Object)rSimSimulationMode10, (Object)rSimSimulationMode10._editVerticalDatumMenuItem, "editVerticalDatum"));
        if (Boolean.getBoolean("ResSim.UsesVerticalDatum")) {
            RSimSimulationMode rSimSimulationMode11 = this;
            rSimSimulationMode11.addEditMenuItem(rSimSimulationMode11._editVerticalDatumMenuItem);
        }
        this._editResSysOpMenuItem = new JMenuItem("Reservoir Systems...", 83);
        this._editResSysOpMenuItem.setName("Edit_Systems");
        RSimSimulationMode rSimSimulationMode12 = this;
        this._editResSysOpMenuItem.addActionListener((ActionListener)this._listener.add((Object)rSimSimulationMode12, (Object)rSimSimulationMode12._editResSysOpMenuItem, "editReservoirSysOps"));
        RSimSimulationMode rSimSimulationMode13 = this;
        rSimSimulationMode13.addEditMenuItem(rSimSimulationMode13._editResSysOpMenuItem);
        this.addEditMenuSeparator();
        this._wqEditorsMenu = new JMenu("Water Quality");
        this._wqEditorsMenu.setMnemonic('W');
        this._wqEditorsMenu.setVisible(false);
        RSimSimulationMode rSimSimulationMode14 = this;
        rSimSimulationMode14.addEditMenuItem(rSimSimulationMode14._wqEditorsMenu);
        this.createWaterQualityMenus();
        this._editStateVariablesMenuItem = new JMenuItem("State Variables...", 86);
        RSimSimulationMode rSimSimulationMode15 = this;
        this._editStateVariablesMenuItem.addActionListener((ActionListener)this._listener.add((Object)rSimSimulationMode15, (Object)rSimSimulationMode15._editStateVariablesMenuItem, "editStateVariables"));
        RSimSimulationMode rSimSimulationMode16 = this;
        rSimSimulationMode16.addEditMenuItem(rSimSimulationMode16._editStateVariablesMenuItem);
        this._editGlobalVariablesMenuItem = new JMenuItem("Global Variables...", 71);
        RSimSimulationMode rSimSimulationMode17 = this;
        this._editGlobalVariablesMenuItem.addActionListener((ActionListener)this._listener.add((Object)rSimSimulationMode17, (Object)rSimSimulationMode17._editGlobalVariablesMenuItem, "editGlobalVariables"));
        RSimSimulationMode rSimSimulationMode18 = this;
        rSimSimulationMode18.addEditMenuItem(rSimSimulationMode18._editGlobalVariablesMenuItem);
        this._editWaterAccountSetsMenuItem = new JMenuItem("Water Account Sets...", 86);
        RSimSimulationMode rSimSimulationMode19 = this;
        this._editWaterAccountSetsMenuItem.addActionListener((ActionListener)this._listener.add((Object)rSimSimulationMode19, (Object)rSimSimulationMode19._editWaterAccountSetsMenuItem, "editWaterAccountSets"));
        RSimSimulationMode rSimSimulationMode20 = this;
        rSimSimulationMode20.addEditMenuItem(rSimSimulationMode20._editWaterAccountSetsMenuItem);
        this.addEditMenuSeparator();
        this._editRunPropMenuItem = new JMenuItem("Run...", 82);
        this._editRunPropMenuItem.setEnabled(false);
        RSimSimulationMode rSimSimulationMode21 = this;
        this._editRunPropMenuItem.addActionListener((ActionListener)this._listener.add((Object)rSimSimulationMode21, (Object)rSimSimulationMode21._editRunPropMenuItem, "editRunProperties"));
        RSimSimulationMode rSimSimulationMode22 = this;
        rSimSimulationMode22.addEditMenuItem(rSimSimulationMode22._editRunPropMenuItem);
        this.addEditMenuSeparator();
        jMenuItem = new JMenuItem("Reservoir Summary", 82);
        jMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)jMenuItem, "displayReservoirSummaryReport"));
        this._reportsMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Flow Summary", 70);
        jMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)jMenuItem, "displayFlowSummaryReport"));
        this._reportsMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Power Summary", 70);
        jMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)jMenuItem, "displayPowerSummaryReport"));
        this._reportsMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Gates Summary", 70);
        jMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)jMenuItem, "displayGatesSummaryReport"));
        this._reportsMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Stage Summary", 83);
        jMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)jMenuItem, "displayStageSummaryReport"));
        this._reportsMenu.add(jMenuItem);
        this._reportsMenu.addSeparator();
        this._releaseDecisionMenuItem = new JMenuItem("Release Decision", 68);
        RSimSimulationMode rSimSimulationMode23 = this;
        this._releaseDecisionMenuItem.addActionListener((ActionListener)this._listener.add((Object)rSimSimulationMode23, (Object)rSimSimulationMode23._releaseDecisionMenuItem, "menuResReleaseDecisionReport"));
        this._reportsMenu.add(this._releaseDecisionMenuItem);
        this._reportsMenu.addSeparator();
        this._userReportsMenu = new JMenu("User Reports");
        this._userReportsMenu.setMnemonic(85);
        this._reportsMenu.add(this._userReportsMenu);
        this._reportsMenu.addSeparator();
        this._editUserReportsMenuItem = new JMenuItem("Edit...");
        RSimSimulationMode rSimSimulationMode24 = this;
        this._editUserReportsMenuItem.addActionListener((ActionListener)this._listener.add((Object)rSimSimulationMode24, (Object)rSimSimulationMode24._editUserReportsMenuItem, "menuEditUserReports"));
        this._userReportsMenu.add(this._editUserReportsMenuItem);
        this._userReportsMenu.addSeparator();
        this._computeLogsMenu = new JMenu("Compute");
        this._computeLogsMenu.setMnemonic('C');
        this._reportsMenu.add(this._computeLogsMenu);
        JMenu jMenu = new JMenu("Network");
        jMenu.setMnemonic('N');
        jMenuItem = new JMenuItem("Reservoir List", 82);
        jMenuItem.setName("Rep_Reservoir");
        jMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)jMenuItem, "displayReservoirList"));
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Reach List", 69);
        jMenuItem.setName("Rep_Reach");
        jMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)jMenuItem, "displayReachList"));
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Junction List", 74);
        jMenuItem.setName("Rep_Junction");
        jMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)jMenuItem, "displayJunctionList"));
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Diversion List", 68);
        jMenuItem.setName("Rep_Diversion");
        jMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)jMenuItem, "displayDiversionList"));
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        JMenu jMenu2 = new JMenu("Advanced");
        jMenu2.setMnemonic('A');
        jMenu.add(jMenu2);
        jMenuItem = new JMenuItem("Network Connectivity", 78);
        jMenuItem.setName("Rep_Network");
        jMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)jMenuItem, "displayConnectivityTable"));
        jMenu2.add(jMenuItem);
        this._reportsMenu.addSeparator();
        this._reportsMenu.add(jMenu);
        jMenuItem = new JMenuItem("Refresh All Plots", 80);
        jMenuItem.setName("plotRefresh");
        jMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)jMenuItem, "refreshPlots"));
        this._reportsMenu.add(jMenuItem);
        this._reportsMenu.addSeparator();
        this._altInputReportMenu = new JMenu("Alternative Input");
        jMenu2.setMnemonic('t');
        this._reportsMenu.add(this._altInputReportMenu);
        this._reportsMenu.addSeparator();
        this._yieldAnalysisMenu = new JMenu("Storage Yield Analysis");
        jMenu2.setMnemonic('y');
        this._reportsMenu.add(this._yieldAnalysisMenu);
        this._waterAccountPlotMenu = new JMenu("Water Account Plot");
        this._reportsMenu.add(this._waterAccountPlotMenu);
        this._floatingWaterAccountPlotMenu = new JMenu("Floating Water Account Plot");
        this._reportsMenu.add(this._floatingWaterAccountPlotMenu);
        this._reportsMenu.addSeparator();
        this._debugV4ReportMenu = new JMenuItem("Debug Report for recent v4 Compute", 66);
        this._debugV4ReportMenu.addActionListener(new RSimSimulationMode$2(this));
        this._reportsMenu.add(this._debugV4ReportMenu);
        this._wqDebugReportsMenu = new JMenu("Water Quality");
        this._wqDebugReportsMenu.setVisible(false);
        this._reportsMenu.add(this._wqDebugReportsMenu);
        RSimSimulationMode rSimSimulationMode25 = this;
        rSimSimulationMode25.addMenu(rSimSimulationMode25._reportsMenu);
        this._simMenu.addSeparator();
        this._roMenu = new JMenu("Overrides");
        this._roMenu.setMnemonic(79);
        this._simMenu.add(this._roMenu);
        this._extractMenu = new JMenuItem("Rerun Extract");
        RSimSimulationMode rSimSimulationMode26 = this;
        this._extractMenu.addActionListener((ActionListener)this._listener.add((Object)rSimSimulationMode26, (Object)rSimSimulationMode26._extractMenu, "runSimulationExtract"));
        this._extractMenu.setMnemonic(82);
        this._simMenu.add(this._extractMenu);
        this._saveResultsMenu = new JMenuItem("Save Reference Results");
        this._saveResultsMenu.setToolTipText("Saves the Active Run's output to the reference results directory");
        this._alternativeMenu.add(this._saveResultsMenu);
        this._saveResultsMenu.setEnabled(false);
        RSimSimulationMode rSimSimulationMode27 = this;
        this._saveResultsMenu.addActionListener((ActionListener)this._listener.add((Object)rSimSimulationMode27, (Object)rSimSimulationMode27._saveResultsMenu, "saveAlternativeResults"));
        this._runDssCompareMenu = new JMenuItem("DSS Results Comparison");
        this._alternativeMenu.add(this._runDssCompareMenu);
        this._runDssCompareMenu.setEnabled(false);
        RSimSimulationMode rSimSimulationMode28 = this;
        this._runDssCompareMenu.addActionListener((ActionListener)this._listener.add((Object)rSimSimulationMode28, (Object)rSimSimulationMode28._runDssCompareMenu, "runDssComparison"));
        this.checkTestingComponentsState();
        this._alternativeMenu.addMenuListener(new RSimSimulationMode$3(this));
        this._setPlotsToRefreshMenu = new JCheckBoxMenuItem("Set All Plots to Refresh");
        RSimSimulationMode rSimSimulationMode29 = this;
        rSimSimulationMode29.addViewMenuItem(rSimSimulationMode29._setPlotsToRefreshMenu);
        this._setPlotsToRefreshMenu.addActionListener(new RSimSimulationMode$4(this));
    }

    private void createWaterQualityMenus() {
        JMenuItem jMenuItem = WqI18n.a("WqModule.MenuItem.Geometry").createMenuItem();
        jMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)jMenuItem, "displayGeometryEditor"));
        this._wqEditorsMenu.add(jMenuItem);
        this._wqEditorsMenu.addSeparator();
        jMenuItem = WqI18n.a("WqModule.Menu.Constituents").createMenuItem();
        jMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)jMenuItem, "displayWqConstituentsEditor"));
        this._wqEditorsMenu.add(jMenuItem);
        jMenuItem = WqI18n.a("WqModule.Menu.WqParameters").createMenuItem();
        jMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)jMenuItem, "displayWqParameterEditor"));
        this._wqEditorsMenu.add(jMenuItem);
        this._wqEditorsMenu.addSeparator();
        jMenuItem = WqI18n.a("WqModule.Menu.MetData").createMenuItem();
        jMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)jMenuItem, "displayMetDataSetEditor"));
        this._wqEditorsMenu.add(jMenuItem);
        jMenuItem = WqI18n.a("WqModule.Menu.ObjData").createMenuItem();
        jMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)jMenuItem, "displayObservedDataSetEditor"));
        this._wqEditorsMenu.add(jMenuItem);
        this._wqEditorsMenu.addSeparator();
        jMenuItem = WqI18n.a("WqModule.Menu.BC").createMenuItem();
        jMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)jMenuItem, "displayBoundaryConditionEditor"));
        this._wqEditorsMenu.add(jMenuItem);
        jMenuItem = WqI18n.a("WqModule.Menu.IC").createMenuItem();
        jMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)jMenuItem, "displayInitialConditionsEditor"));
        this._wqEditorsMenu.add(jMenuItem);
        jMenuItem = WqI18n.a("WqModule.Menu.MassInjections").createMenuItem();
        jMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)jMenuItem, "displayMassInjectionEditor"));
        this._wqEditorsMenu.add(jMenuItem);
        this._wqEditorsMenu.addSeparator();
        jMenuItem = WqI18n.a("WqModule.Menu.DispParameters").createMenuItem();
        jMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)jMenuItem, "displayDispersionCoeffEditor"));
        this._wqEditorsMenu.add(jMenuItem);
        this._wqEditorsMenu.addSeparator();
        jMenuItem = WqI18n.a("WqModel.MenuItem.WqTsTable").createMenuItem();
        jMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)jMenuItem, "displayWqInputsDialog"));
        this._wqEditorsMenu.add(jMenuItem);
    }

    protected void setPlotsToRefreshAction() {
        Vector vector = G2dDialog.getVisibleDialogs();
        boolean bl = this._setPlotsToRefreshMenu.isSelected();
        for (int i = 0; i < vector.size(); ++i) {
            if (!(vector.get(i) instanceof PlotDialog)) continue;
            PlotDialog plotDialog = (PlotDialog)vector.get(i);
            plotDialog.setRefresh(bl);
        }
    }

    public void editRunProperties() {
        if (this._activeSimRun == null) {
            this._editRunPropMenuItem.setEnabled(false);
            ClientApp.app().postWarning("Please set a Run active before attempting to edit it", "No Active Run");
            return;
        }
        RssAlt rssAlt = this._activeSimRun.getRssAlt();
        RssRun rssRun = this.getRssRun();
        this._runEditDialog = new RssSimEditDialog((JFrame)this._frame, false);
        this._runEditDialog.fillForm(rssAlt, rssRun);
        this._runEditDialog.setEditable(this.checkModePermission(3));
        this._runEditDialog.setVisible(true);
    }

    private void checkTestingComponentsState() {
        Object object = ClientApp.app().getProperties();
        if (Boolean.getBoolean("computeTesting") && object != null) {
            object = object.getProp("computeTestingEnabled");
            boolean bl = Boolean.parseBoolean((String)object);
            this._saveResultsMenu.setVisible(bl);
            this._runDssCompareMenu.setVisible(bl);
            return;
        }
        this._saveResultsMenu.setVisible(false);
        this._runDssCompareMenu.setVisible(false);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof JMenuItem) {
            if ("ReleaseOverrides".equals(((Component)(object = (JMenuItem)object)).getName())) {
                this.releaseOverride(((AbstractButton)object).getActionCommand());
                return;
            }
            if ("viewLog".equals(((AbstractButton)object).getActionCommand())) {
                this.viewLog(((Component)object).getName());
                return;
            }
            if ("userReport".equals(((AbstractButton)object).getActionCommand())) {
                this.displayUserReport(((Component)object).getName());
            } else if ("altInputReportAction".equals(((AbstractButton)object).getActionCommand())) {
                this.altInputReportAction(((Component)object).getName());
            } else if ("wqDebugReportAction".equals(((AbstractButton)object).getActionCommand())) {
                this.wqDebugReportAction(((Component)object).getName());
            } else if ("yieldAnalysisOuputSummaryReportAction".equals(((AbstractButton)object).getActionCommand())) {
                this.yieldAnalysisOuputSummaryReportAction(((Component)object).getName());
            } else if ("yieldAnalysisOuputPlotAction".equals(((AbstractButton)object).getActionCommand())) {
                this.yieldAnalysisOuputPlotAction(((Component)object).getName());
            } else if ("yieldResultPlotAction".equals(((AbstractButton)object).getActionCommand())) {
                this.yieldResultPlotAction(((Component)object).getName());
            } else if ("waterAccountPlotAction".equals(((AbstractButton)object).getActionCommand())) {
                this.waterAccountPlotAction(((Component)object).getName());
            } else if ("floatingWaterAccountPlotAction".equals(((AbstractButton)object).getActionCommand())) {
                this.floatingWaterAccountPlotAction(((Component)object).getName());
            }
        }
        super.actionPerformed(actionEvent);
    }

    public String getScriptableName() {
        return "Simulation";
    }

    public RssSummaryJFrame displayReservoirSummaryReport() {
        SimulationPeriod simulationPeriod = this.getSimulation();
        Vector vector = this.getRssRunNames(true);
        return ResSimReportsFactory.displayReservoirSummaryReport((AbstractSimulation)simulationPeriod, vector);
    }

    public RssSummaryJFrame displayGatesSummaryReport() {
        SimulationPeriod simulationPeriod = this.getSimulation();
        Vector vector = this.getRssRunNames(true);
        return ResSimReportsFactory.displayGatesSummaryReport((AbstractSimulation)simulationPeriod, vector);
    }

    public RssSummaryJFrame displayPowerSummaryReport() {
        SimulationPeriod simulationPeriod = this.getSimulation();
        Vector vector = this.getRssRunNames(true);
        return ResSimReportsFactory.displayPowerSummaryReport((AbstractSimulation)simulationPeriod, vector);
    }

    public RssSummaryJFrame displayPowerReportEditor() {
        SimulationPeriod simulationPeriod = this.getSimulation();
        Vector vector = this.getRssRunNames(true);
        PowerReportEditor powerReportEditor = new PowerReportEditor((Frame)this._parent);
        powerReportEditor.setLocationRelativeTo((Component)this._parent);
        powerReportEditor.setVisible(true);
        powerReportEditor.getReportType();
        if (powerReportEditor.isCanceled()) {
            return null;
        }
        return ResSimReportsFactory.displayPowerSummaryReport((AbstractSimulation)simulationPeriod, vector);
    }

    public RssSummaryJFrame displayFlowSummaryReport() {
        SimulationPeriod simulationPeriod = this.getSimulation();
        Vector vector = this.getRssRunNames(true);
        return ResSimReportsFactory.displayFlowSummaryReport((AbstractSimulation)simulationPeriod, vector);
    }

    public RssSummaryJFrame displayStageSummaryReport() {
        SimulationPeriod simulationPeriod = this.getSimulation();
        Vector vector = this.getRssRunNames(true);
        return ResSimReportsFactory.displayStageSummaryReport((AbstractSimulation)simulationPeriod, vector);
    }

    public void menuResReleaseDecisionReport() {
        this.menuResReleaseDecisionReport_Action(null);
    }

    public void menuResReleaseDecisionReport_Action(String string) {
        Object object = this.getSimulation();
        if (object == null) {
            System.out.println("releaseDecisionReport: no Simulation!");
            return;
        }
        object = (SimulationRun)this._activeSimRun;
        if (object == null) {
            System.out.println("releaseDecisionReport: no Run found");
            return;
        }
        try {
            this._frame.setWaitCursor();
            Cloneable cloneable = object.getModelNames("rss");
            RssRun rssRun = null;
            if (cloneable != null && ((Vector)cloneable).size() > 0) {
                rssRun = this.getRssRun(((Vector)cloneable).elementAt(0).toString());
            }
            if (rssRun == null) {
                System.out.println("releaseDecisionReport: failed to find RssRun " + object.getName());
                return;
            }
            cloneable = rssRun.getAlternative();
            if (cloneable == null) {
                System.out.println("releaseDecisionReport: failed to find RssAlt " + object.getModel("rss"));
                return;
            }
            object = ((RssAlt)cloneable).getSystem();
            new RSSDecisionSummaryReport((RssSystem)object, (RssAlt)cloneable, rssRun, string);
            return;
        }
        finally {
            this._frame.setDefaultCursor();
        }
    }

    public void displayAlternativeEditor(String string) {
        SimulationPeriod simulationPeriod = this.getSimulation();
        if (simulationPeriod == null) {
            ClientApp.app().postWarning("Please create/open a Simulation before editing Alternatives", "No Simulation");
            return;
        }
        try {
            this._frame.setWaitCursor();
            if (this.m_alternativeEditor == null) {
                this.m_alternativeEditor = new AlternativeEditor((Frame)this._frame, false);
                this.m_alternativeEditor.setLocationByPlatform(true);
                this.m_alternativeEditor.setLocationRelativeTo((Component)this._frame);
            }
            this.m_alternativeEditor.fillForm((ManagerProxyListContainer)simulationPeriod);
            ((AbstractAlternativeEditor)this.m_alternativeEditor).setSelectedAlternative(string);
            ((AbstractAlternativeEditor)this.m_alternativeEditor).setVisible(true);
            this.m_alternativeEditor.toFront();
            return;
        }
        finally {
            this._frame.setDefaultCursor();
        }
    }

    public void displaySingleAlternativeEditor(String string) {
        SimulationPeriod simulationPeriod = this.getSimulation();
        if (simulationPeriod == null) {
            ClientApp.app().postWarning("Please create/open a Simulation before editing Alternatives", "No Simulation");
            return;
        }
        try {
            this._frame.setWaitCursor();
            if (this.m_singleAlternativeEditor == null) {
                this.m_singleAlternativeEditor = new AlternativeEditor((Frame)this._frame, false);
                this.m_singleAlternativeEditor.setLocationByPlatform(true);
                this.m_singleAlternativeEditor.setLocationRelativeTo((Component)this._frame);
            }
            this.m_singleAlternativeEditor.fillForm((ManagerProxyListContainer)simulationPeriod);
            ((AbstractAlternativeEditor)this.m_singleAlternativeEditor).setSelectedAlternative(string);
            ((AbstractAlternativeEditor)this.m_singleAlternativeEditor).setVisible(true);
            this.m_singleAlternativeEditor.setAlwaysOnTop(true);
            this.m_singleAlternativeEditor.toFront();
            this.m_singleAlternativeEditor.requestFocus();
            this.m_singleAlternativeEditor.setAlwaysOnTop(false);
            return;
        }
        finally {
            this._frame.setDefaultCursor();
        }
    }

    public ElementListReport displayReservoirList() {
        return ResSimReportsFactory.displayReservoirList(this.getNetwork(), this);
    }

    public ElementListReport displayReachList() {
        return ResSimReportsFactory.displayReachList(this.getNetwork(), this);
    }

    public void modeClosing() {
        Vector vector = RmaJDialog.getOpenWindows();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            RmaJDialog rmaJDialog = (RmaJDialog)vector.get(i);
            if (rmaJDialog == null || !rmaJDialog.isVisible()) continue;
            if (rmaJDialog != null && rmaJDialog.isVisible()) {
                if (rmaJDialog instanceof ReservoirJFrame) {
                    ((ReservoirJFrame)rmaJDialog).cmdCancel_Action();
                }
                if (rmaJDialog instanceof JunctionDialog) {
                    ((JunctionDialog)rmaJDialog).handleCancelAction();
                }
                if (rmaJDialog instanceof DiversionEditorDlg) {
                    ((DiversionEditorDlg)rmaJDialog).diversionComboChanged();
                    ((DiversionEditorDlg)rmaJDialog).closeDialog();
                }
                if (rmaJDialog instanceof ReachDlg) {
                    ((ReachDlg)rmaJDialog).reachChoice_StateChange();
                    ((ReachDlg)rmaJDialog).closeDialog();
                }
                if (rmaJDialog instanceof AlternativeEditor) {
                    ((AlternativeEditor)rmaJDialog).AlternativeEditor_Closing();
                }
            }
            if (rmaJDialog.isModified() && rmaJDialog instanceof ClosableDialog) {
                ((ClosableDialog)rmaJDialog).closeDialog();
                continue;
            }
            if (!rmaJDialog.isSystemClosable()) continue;
            rmaJDialog.setVisible(false);
        }
        this._wqEditorLauncher.resetEditors();
    }

    public void modeOpening() {
        super.modeOpening();
        this.updateSimRunDetailsPanel();
        this.checkTestingComponentsState();
    }

    public ElementListReport displayJunctionList() {
        return ResSimReportsFactory.displayJunctionList(this.getNetwork(), this);
    }

    public ElementListReport displayDiversionList() {
        return ResSimReportsFactory.displayDiversionList(this.getNetwork(), this);
    }

    public ConnectivityDlg displayConnectivityTable() {
        SimulationPeriod simulationPeriod = this.getSimulation();
        Vector vector = this.getRssRunNames(true);
        return ResSimReportsFactory.displayConnectivitySummaryReport((AbstractSimulation)simulationPeriod, vector, this.getNetwork());
    }

    @Override
    public void reportDoubleClicked(int n, String string) {
        switch (n) {
            case 0: {
                this.editReservoir(string);
                return;
            }
            case 1: {
                this.editReach(string);
                return;
            }
            case 2: {
                this.editJunction(string);
                return;
            }
            case 3: {
                this.editDiversion(string);
            }
        }
    }

    @Override
    public void updateGUIState(boolean bl) {
        if (this._resDlg != null && this._resDlg.isVisible()) {
            this._resDlg.setEditable(bl);
        }
        if (this._reachDlg != null && this._reachDlg.isVisible()) {
            this._reachDlg.setEditable(bl);
        }
        if (this._divDlg != null && this._divDlg.isVisible()) {
            this._divDlg.setEditable(bl);
        }
        if (this._juncDlg != null && this._juncDlg.isVisible()) {
            this._juncDlg.setEditable(bl);
        }
        if (this._stateVariableDialog != null && this._stateVariableDialog.isVisible()) {
            this._stateVariableDialog = null;
        }
    }

    @Override
    public boolean lockConfiguration(boolean bl) {
        return true;
    }

    private List getRssRunNamesVector() {
        return this.getRssRunNames(false);
    }

    public RssRun getRssRun(String object) {
        SimulationPeriod simulationPeriod = this.getSimulation();
        if (simulationPeriod == null) {
            return null;
        }
        Identifier identifier = null;
        Object object2 = RMAIO.userNameToFileName((String)object);
        Object object3 = object;
        object3 = simulationPeriod.getSimulationPath() + "/rss/" + (String)object3 + ".rssrun";
        object2 = simulationPeriod.getSimulationPath() + "/rss/" + (String)object2 + ".rssrun";
        Identifier identifier2 = new Identifier();
        String[] stringArray = new String[2];
        String[] stringArray2 = stringArray;
        stringArray[0] = object2;
        stringArray2[1] = object3;
        object2 = (RmiFileManager)ClientApp.app().getFileManager().getRemote();
        for (int i = 0; i < stringArray2.length; ++i) {
            identifier2.setPath(stringArray2[i]);
            try {
                identifier = object2.openFile(ClientApp.app().getUser(), identifier2);
            }
            catch (RemoteException remoteException) {
                System.out.println("RemoteException opening " + (String)object3 + " error " + String.valueOf(remoteException));
                ClientApp.app().postError("Error opening ResSim run file.", "Can't find Run");
                return null;
            }
            if (identifier != null) break;
        }
        if (identifier == null) {
            System.out.println("Failed to open ResSim Run file for " + (String)object);
            if (this._failedRunNames == null) {
                this._failedRunNames = new ArrayList<String>();
            }
            this._failedRunNames.add((String)object);
            return null;
        }
        object = (RssRun)simulationPeriod.openManager("rss", identifier);
        if (object == null) {
            object = (RssRun)simulationPeriod.newManager("rss", RssRun.class.getName());
            if (object == null) {
                ClientApp.app().postError("Failed to load ResSim run file.", "Error Loading");
                return null;
            }
            object.getIdentifier().setPath(identifier.getPath());
            ((RssRun)object).readFile(identifier);
            object.getIdentifier().setName(object.getName());
            object.getIdentifier().setDescription(object.getDescription());
            ((RssRun)object).setDSSOutputFile(simulationPeriod.getSimulationPath() + "/" + simulationPeriod.getOutputDSSFileName());
            simulationPeriod.saveManager("rss", (Manager)object);
        }
        return object;
    }

    public String getRunName(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        if (this._simulationTree.hasTrials()) {
            return string;
        }
        return string;
    }

    public Vector getRssRunNames(boolean bl) {
        return this.getRunNames(bl, "rss");
    }

    public Vector getRssRuns(boolean bl, boolean bl2) {
        Vector vector = this.getRssRunNames(bl);
        Vector<RunInfo> vector2 = new Vector<RunInfo>(vector.size());
        this._failedRunNames = new ArrayList<String>();
        for (int i = 0; i < vector.size(); ++i) {
            Object object = (RunInfo)vector.get(i);
            object = this.getRssRun(object.runName);
            if (object == null) continue;
            vector2.add((RunInfo)object);
        }
        if (bl2) {
            RSimSimulationMode rSimSimulationMode = this;
            rSimSimulationMode.checkRuns(rSimSimulationMode._failedRunNames);
        }
        return vector2;
    }

    public Vector<RssRun> getActiveRssRuns() {
        return this.getActiveRssRuns(true);
    }

    public Vector<RssRun> getActiveRssRuns(boolean bl) {
        Vector<RunInfo> vector = this.getActiveRssRunNames();
        Vector<RssRun> vector2 = new Vector<RssRun>(vector.size());
        this._failedRunNames = new ArrayList<String>();
        for (int i = 0; i < vector.size(); ++i) {
            Object object = vector.get(i);
            object = this.getRssRun(object.runName);
            if (object == null) continue;
            vector2.add((RssRun)object);
        }
        if (bl) {
            RSimSimulationMode rSimSimulationMode = this;
            rSimSimulationMode.checkRuns(rSimSimulationMode._failedRunNames);
        }
        return vector2;
    }

    public Vector<RunInfo> getActiveRssRunNames() {
        Object object = this.getActiveRun();
        if (object == null) {
            return null;
        }
        Vector<RunInfo> vector = new Vector<RunInfo>();
        String string = object.toString();
        object = object.getModelNames("rss");
        for (int i = 0; i < ((Vector)object).size(); ++i) {
            RunInfo runInfo = new RunInfo((String)((Vector)object).get(i), string);
            if (vector.contains(((Vector)object).get(i))) continue;
            vector.add(runInfo);
        }
        return vector;
    }

    public Vector<RunInfo> getRunInfo(SimulationRun object) {
        if (object == null) {
            return null;
        }
        Vector<RunInfo> vector = new Vector<RunInfo>();
        String string = object.toString();
        object = object.getModelNames("rss");
        for (int i = 0; i < ((Vector)object).size(); ++i) {
            RunInfo runInfo = new RunInfo((String)((Vector)object).get(i), string);
            if (vector.contains(((Vector)object).get(i))) continue;
            vector.add(runInfo);
        }
        return vector;
    }

    private boolean checkRuns(List list) {
        int n = list.size();
        if (n == 0) {
            return true;
        }
        String string = "";
        for (int i = 0; i < n; ++i) {
            string = string.concat("<br>").concat((String)list.get(i));
        }
        ClientApp.app().postWarning("<html>Failed to open ResSim Run file" + (n > 1 ? "s" : "") + " for:<br>" + string + "<br><br><hr>Alternative" + (n > 1 ? "s" : "") + " probably " + (n > 1 ? "haven't" : "hasn't") + " been computed.</html>", "Missing Run File");
        return false;
    }

    public RssRun getRssRun() {
        Object object = (SimulationRun)this._activeSimRun;
        if (object == null) {
            return null;
        }
        object = object.getModelNames("rss");
        RssRun rssRun = null;
        if (object != null && ((Vector)object).size() > 0) {
            rssRun = this.getRssRun(((Vector)object).elementAt(0).toString());
        }
        return rssRun;
    }

    @Override
    public RssSystem getNetwork() {
        if (this._activeSimRun == null) {
            return null;
        }
        return this._activeSimRun.getRssSystem();
    }

    protected void updateMenus() {
        this.makeReleaseOverrideMenu();
        this.updateAltInputReportMenu();
        this.updateWQReportMenu();
        this.updateYieldAnalysisMenu();
        this.updateWaterAccountPlotMenu();
        this.updateFloatingWaterAccountPlotMenu();
        RSimSimulationMode rSimSimulationMode = this;
        rSimSimulationMode.getMenuLogFiles(rSimSimulationMode._computeLogsMenu, "rss", "*.log,*.html", "viewLog", true, true);
        this.syncMenusWithTree();
    }

    private void makeReleaseOverrideMenu() {
        int n;
        Object object = this.getSimulation();
        if (object == null) {
            return;
        }
        if (this._roMenu.getItemCount() > 0) {
            this._roMenu.removeAll();
        }
        if ((n = (object = this.getRssRunNames(false)).size()) <= 0) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            RunInfo runInfo = (RunInfo)object.get(i);
            JMenuItem jMenuItem = new JMenuItem(runInfo.simRunName);
            jMenuItem.setActionCommand(runInfo.runName);
            jMenuItem.setName("ReleaseOverrides");
            jMenuItem.addActionListener(this);
            this._roMenu.add(jMenuItem);
        }
    }

    public void updateWQReportMenu() {
        Object object = this.getSimulation();
        if (object == null) {
            return;
        }
        this._wqDebugReportsMenu.removeAll();
        object = this.getRssRunNames(false);
        int n = object.size();
        if (n <= 0) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            RunInfo runInfo = (RunInfo)object.get(i);
            JMenuItem jMenuItem = new JMenuItem(runInfo.simRunName);
            jMenuItem.setActionCommand("wqDebugReportAction");
            jMenuItem.setName(runInfo.runName);
            jMenuItem.addActionListener(this);
            this._wqDebugReportsMenu.add(jMenuItem);
        }
    }

    public void updateAltInputReportMenu() {
        Object object = this.getSimulation();
        if (object == null) {
            return;
        }
        this._altInputReportMenu.removeAll();
        object = this.getRssRunNames(false);
        int n = object.size();
        if (n <= 0) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            RunInfo runInfo = (RunInfo)object.get(i);
            JMenuItem jMenuItem = new JMenuItem(runInfo.simRunName);
            jMenuItem.setActionCommand("altInputReportAction");
            jMenuItem.setName(runInfo.runName);
            jMenuItem.addActionListener(this);
            this._altInputReportMenu.add(jMenuItem);
        }
    }

    public void updateYieldAnalysisMenu() {
        Object object2 = this.getSimulation();
        if (object2 == null) {
            return;
        }
        if (this._yieldAnalysisMenu == null) {
            return;
        }
        this._yieldAnalysisMenu.removeAll();
        object2 = this.getRssRuns(true, false);
        if (object2 == null) {
            return;
        }
        int n = object2.size();
        if (n <= 0) {
            return;
        }
        this._yieldAnalysisMenu.setEnabled(false);
        for (Object object2 : object2) {
            RssRun rssRun;
            if (!(object2 instanceof RssRun) || (object2 = (rssRun = (RssRun)object2).getAlternative()) == null || !object2.useYieldAnalysis()) continue;
            this._yieldAnalysisMenu.setEnabled(true);
            JMenu jMenu = new JMenu(rssRun.getName());
            object2 = new JMenuItem("Output Summary Report");
            object2.setName(rssRun.getName());
            object2.setActionCommand("yieldAnalysisOuputSummaryReportAction");
            object2.addActionListener(this);
            jMenu.add((JMenuItem)object2);
            object2 = new JMenuItem("Results Plots");
            object2.setActionCommand("yieldResultPlotAction");
            object2.setName(rssRun.getName());
            object2.addActionListener(this);
            jMenu.add((JMenuItem)object2);
            this._yieldAnalysisMenu.add(jMenu);
        }
    }

    private void updateWaterAccountPlotMenuItems() {
        this._waterAccountPlotMenu.removeAll();
        Object object = this.getRssRuns(true, false);
        if (object == null || ((Vector)object).size() <= 0) {
            this._waterAccountPlotMenu.setEnabled(false);
            return;
        }
        Iterator iterator = ((Vector)object).iterator();
        while (iterator.hasNext()) {
            RssRun rssRun;
            object = iterator.next();
            if (!(object instanceof RssRun) || (object = (rssRun = (RssRun)object).getAlternative()) == null || ((RssAlt)object).getWaterAccountSetIndex() == Integer.MIN_VALUE) continue;
            System.out.println(object.getDisplayName());
            System.out.println(((RssAlt)object).getWaterAccountSetIndex());
            JMenu jMenu = new JMenu(rssRun.getName());
            object = new JMenuItem("Water Account Plot");
            ((AbstractButton)object).setActionCommand("waterAccountPlotAction");
            ((Component)object).setName(rssRun.getName());
            jMenu.add((JMenuItem)object);
            this._waterAccountPlotMenu.add(jMenu);
        }
        this._waterAccountPlotMenu.setEnabled(this._waterAccountPlotMenu.getMenuComponentCount() > 0);
    }

    private void updateWaterAccountPlotMenu() {
        Object object = this.getSimulation();
        if (object == null) {
            return;
        }
        if (this._waterAccountPlotMenu == null) {
            return;
        }
        this._waterAccountPlotMenu.removeAll();
        object = this.getRssRuns(true, false);
        if (object == null) {
            return;
        }
        int n = ((Vector)object).size();
        if (n <= 0) {
            return;
        }
        this._waterAccountPlotMenu.setEnabled(false);
        for (int i = 0; i < n; ++i) {
            RssRun rssRun;
            Object object2;
            if (!(((Vector)object).get(i) instanceof RssRun) || (object2 = (rssRun = (RssRun)((Vector)object).get(i)).getAlternative()) == null || ((RssAlt)object2).getWaterAccountSet() == null || ((RssAlt)object2).getWaterAccountSet().getSize() <= 0) continue;
            this._waterAccountPlotMenu.setEnabled(true);
            JMenu jMenu = new JMenu(rssRun.getName());
            object2 = new JMenuItem("Water Account Plot");
            ((AbstractButton)object2).setActionCommand("waterAccountPlotAction");
            ((Component)object2).setName(rssRun.getName());
            ((AbstractButton)object2).addActionListener(this);
            jMenu.add((JMenuItem)object2);
            this._waterAccountPlotMenu.add(jMenu);
        }
    }

    private void updateFloatingWaterAccountPlotMenu() {
        Object object = this.getSimulation();
        if (object == null) {
            return;
        }
        if (this._floatingWaterAccountPlotMenu == null) {
            return;
        }
        this._floatingWaterAccountPlotMenu.removeAll();
        object = this.getRssRuns(true, false);
        if (object == null) {
            return;
        }
        int n = ((Vector)object).size();
        if (n <= 0) {
            return;
        }
        this._floatingWaterAccountPlotMenu.setEnabled(false);
        for (int i = 0; i < n; ++i) {
            RssRun rssRun;
            Object object2;
            if (!(((Vector)object).get(i) instanceof RssRun) || (object2 = (rssRun = (RssRun)((Vector)object).get(i)).getAlternative()) == null || ((RssAlt)object2).getWaterAccountSet() == null) continue;
            this._floatingWaterAccountPlotMenu.setEnabled(true);
            JMenu jMenu = new JMenu(rssRun.getName());
            object2 = new JMenuItem("Floating Water Account Plot");
            ((AbstractButton)object2).setActionCommand("floatingWaterAccountPlotAction");
            ((Component)object2).setName(rssRun.getName());
            ((AbstractButton)object2).addActionListener(this);
            jMenu.add((JMenuItem)object2);
            this._floatingWaterAccountPlotMenu.add(jMenu);
        }
    }

    private void wqDebugReportAction(String string) {
        Vector vector = this.getRssRunNames(false);
        for (int i = 0; i < vector.size(); ++i) {
            Object object = (RunInfo)vector.get(i);
            if (!((RunInfo)object).runName.equals(string)) continue;
            object = this.getRssRun(((RunInfo)object).runName);
            if (object == null) {
                return;
            }
            Object object2 = ((RssRun)object).getOutputFile(false);
            object = new File(new File((String)object2).getParentFile(), object.getName() + ".wqEngineLog");
            object2 = (RmiFileManager)ClientApp.app().getFileManager().getRemote();
            object = new Identifier(((File)object).getAbsolutePath());
            try {
                object = object2.openFile(ClientApp.app().getUser(), (Identifier)object);
            }
            catch (RemoteException remoteException) {
                object2 = remoteException;
                remoteException.printStackTrace();
                ClientApp.app().postError("Error opening Water Quality Log file. " + String.valueOf(object2), "Error");
                return;
            }
            object2 = object.getFile();
            if (object2 != null && object2.exists()) {
                object = new TextFileEditorDialog((Frame)this.getFrame(), false, (Identifier)object, false);
                object.pack();
                object.setSize(950, 600);
                object.setLocationRelativeTo((Component)this.getFrame());
                object.setVisible(true);
                continue;
            }
            ClientApp.app().postError("Error opening Water Quality Log file.", "Error");
        }
    }

    private void altInputReportAction(String string) {
        Vector vector = this.getRssRunNames(false);
        for (int i = 0; i < vector.size(); ++i) {
            Object object = (RunInfo)vector.get(i);
            if (!object.runName.equals(string)) continue;
            object = new AlternativeInputReportEditor((JFrame)this.getFrame(), this.getRssRun(object.runName));
            object.setLocationRelativeTo((Component)this.getFrame());
            object.setVisible(true);
        }
    }

    private void yieldAnalysisOuputSummaryReportAction(String string) {
        ClientWorkspace clientWorkspace = ClientApp.Workspace();
        Vector vector = this.getRssRunNames(false);
        for (int i = 0; i < vector.size(); ++i) {
            Object object = (RunInfo)vector.get(i);
            if (!object.runName.equals(string)) continue;
            object = new YieldAnalysisReportDialog((Frame)this.getFrame(), this.getRssRun(object.runName), (ManagerProxyListContainer)clientWorkspace);
            object.setVisible(true);
        }
    }

    private void yieldAnalysisOuputPlotAction(String string) {
        Vector vector = this.getRssRunNames(false);
        for (int i = 0; i < vector.size(); ++i) {
            Object object = (RunInfo)vector.get(i);
            if (!((RunInfo)object).runName.equals(string)) continue;
            this.getRssRun(((RunInfo)object).runName);
            object = new PlotDialog((Frame)this.getFrame(), "Yield Analysis Plot", false);
            object.setLocationRelativeTo((Component)this.getFrame());
            ((PlotDialog)object).setVisible(true);
        }
    }

    private void yieldResultPlotAction(String string) {
        Object object2 = this.getRssRunNames(false);
        for (Object object2 : object2) {
            object2 = (RunInfo)object2;
            if (!((RunInfo)object2).runName.equals(string)) continue;
            object2 = this.getRssRun(((RunInfo)object2).runName);
            if (((RssRun)object2).getAlternative().getSelectedYieldAnalysis() == YieldAnalysisType.RESERVOIR_STORAGE_VS_YIELD_ANALYSIS) {
                ReservoirStorageVsYieldAnalysis reservoirStorageVsYieldAnalysis = ((RssRun)object2).getAlternative().getReservoirStorageVsYieldAnalysis();
                object2 = new ReservoirVsYieldAnalysisPlotDialog((Frame)this.getFrame(), this.createDataSetVector(reservoirStorageVsYieldAnalysis, (RssRun)object2));
                object2.setLocationRelativeTo((Component)this.getFrame());
                object2.setTitle("Reservoir Storage vs Yield Analysis");
                object2.setVisible(true);
                continue;
            }
            object2 = new YieldAnalysisResultsPlotDialog(new YieldTrialResultsPlot((RssRun)object2), new YieldStorageConvergencePlot((RssRun)object2), new YieldFlowConvergencePlot((RssRun)object2));
            object2.setLocationRelativeTo((Component)this.getFrame());
            object2.setTitle("Yield Result Plots");
            object2.setVisible(true);
        }
    }

    private void waterAccountPlotAction(String string) {
        Serializable serializable2 = this.getRssRunNames(false);
        for (Serializable serializable2 : serializable2) {
            WaterAccountSet waterAccountSet;
            serializable2 = (RunInfo)serializable2;
            if (!((RunInfo)serializable2).runName.equals(string) || (waterAccountSet = ((RssRun)(serializable2 = this.getRssRun(((RunInfo)serializable2).runName))).getAlternative().getWaterAccountSet()) == null) continue;
            int n = this.getWaterAccountActiveReservoirs(waterAccountSet);
            if (n > 1) {
                this._waterAccountMultipleReservoirsPlotDialog = new WaterAccountMultipleReservoirsPlotDialog();
                this._waterAccountMultipleReservoirsPlotDialog.fillDialog((RssRun)serializable2);
                this._waterAccountMultipleReservoirsPlotDialog.setTitle("Water Account Multiple Reservoirs Plot -" + serializable2.getDisplayName());
                this._waterAccountMultipleReservoirsPlotDialog.setLocationRelativeTo((Component)this.getFrame());
                this._waterAccountMultipleReservoirsPlotDialog.setVisible(true);
                continue;
            }
            this._waterAccountPlotDialog = new WaterAccountPlotDialog();
            this._waterAccountPlotDialog.fillDialog((RssRun)serializable2);
            this._waterAccountPlotDialog.setTitle("Water Account Plot - " + serializable2.getDisplayName());
            this._waterAccountPlotDialog.setLocationRelativeTo((Component)this.getFrame());
            this._waterAccountPlotDialog.setVisible(true);
        }
    }

    private int getWaterAccountActiveReservoirs(WaterAccountSet iterator) {
        int n = 0;
        iterator = ((WaterAccountSet)((Object)iterator)).getResZoneRefs();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            StorageZoneRef storageZoneRef = iterator.next();
            if (!storageZoneRef.isActive()) continue;
            ++n;
        }
        return n;
    }

    private void floatingWaterAccountPlotAction(String string) {
        Serializable serializable2 = this.getRssRunNames(false);
        for (Serializable serializable2 : serializable2) {
            WaterAccountSet waterAccountSet;
            serializable2 = (RunInfo)serializable2;
            if (!((RunInfo)serializable2).runName.equals(string) || (waterAccountSet = ((RssRun)(serializable2 = this.getRssRun(((RunInfo)serializable2).runName))).getAlternative().getWaterAccountSet()) == null) continue;
            this._floatingWaterAccountDialog = new FloatingWaterAccountDialog((Frame)this.getFrame(), false);
            this._floatingWaterAccountDialog.fillDialog((RssRun)serializable2);
            this._floatingWaterAccountDialog.setLocationRelativeTo((Component)this.getFrame());
            this._floatingWaterAccountDialog.setTitle("Floating Water Account Plot");
            this._floatingWaterAccountDialog.setVisible(true);
        }
    }

    private Vector createDataSetVector(ReservoirStorageVsYieldAnalysis reservoirStorageVsYieldAnalysis, RssRun rssRun) {
        Vector<ReservoirStorageVsYieldAnalysis> vector = new Vector<ReservoirStorageVsYieldAnalysis>();
        reservoirStorageVsYieldAnalysis = reservoirStorageVsYieldAnalysis.c(rssRun);
        vector.add(reservoirStorageVsYieldAnalysis);
        return vector;
    }

    public void releaseOverride(String string) {
        RssRun rssRun = this.getRssRun(string);
        if (rssRun == null || rssRun.getLastComputeStatus() == ComputeStatus.NOT_COMPUTED) {
            ClientApp.app().postWarning("<html>No Compute Results found. The Alternative <b>" + string + "</b> must be computed before using Overrides.</html>", "Overrides Unavailable");
            return;
        }
        this.releaseOverride(rssRun);
    }

    void releaseOverride(RssRun rssRun) {
        if (this._specRelDlg != null) {
            this._specRelDlg.setVisible(false);
            this._specRelDlg.dispose();
        }
        RmiFileCallBackImpl[] rmiFileCallBackImplArray = new RmiFileCallBackImpl[1];
        RssRun rssRun2 = rssRun;
        if (!this.lockManager(rssRun2, "Failed to lock ResSim Run " + rssRun2.getName(), null, null, rmiFileCallBackImplArray)) {
            return;
        }
        this._specRelDlg = new RssSpecifyOverridesDialog((Frame)this._frame, false);
        this._specRelDlg.setRun(rssRun);
        this._specRelDlg.setLockCallback(rmiFileCallBackImplArray[0]);
        this._specRelDlg.setVisible(true);
        this.getSimulation().unloadManager("rss", rssRun.getIdentifier());
    }

    protected void updateComputeButton() {
        super.updateComputeButton();
        SimulationPeriod simulationPeriod = this.getSimulation();
        if (simulationPeriod == null) {
            this._editDiversionsMenuItem.setEnabled(false);
            this._editReservoirsMenuItem.setEnabled(false);
            this._editReachesMenuItem.setEnabled(false);
            this._editJunctionsMenuItem.setEnabled(false);
            this._editResSysOpMenuItem.setEnabled(false);
            this._releaseDecisionMenuItem.setEnabled(false);
            this._editRunPropMenuItem.setEnabled(false);
            this._editStateVariablesMenuItem.setEnabled(false);
            this._editGlobalVariablesMenuItem.setEnabled(false);
            this._editVerticalDatumMenuItem.setEnabled(false);
            this._editWaterAccountSetsMenuItem.setEnabled(false);
            this._replaceFromBaseMenuItem.setEnabled(false);
            this._extractMenu.setEnabled(false);
            this._roMenu.setEnabled(false);
            return;
        }
        simulationPeriod = this._simulationTree.getActiveRun();
        boolean bl = simulationPeriod != null;
        this._editDiversionsMenuItem.setEnabled(bl);
        this._editReservoirsMenuItem.setEnabled(bl);
        this._editReachesMenuItem.setEnabled(bl);
        this._editJunctionsMenuItem.setEnabled(bl);
        this._editResSysOpMenuItem.setEnabled(bl);
        this._releaseDecisionMenuItem.setEnabled(bl);
        this._editRunPropMenuItem.setEnabled(bl);
        this._editStateVariablesMenuItem.setEnabled(bl);
        this._editVerticalDatumMenuItem.setEnabled(bl);
        this._editGlobalVariablesMenuItem.setEnabled(bl);
        this._editWaterAccountSetsMenuItem.setEnabled(bl);
        this._replaceFromBaseMenuItem.setEnabled(bl);
        this._extractMenu.setEnabled(bl);
        this._roMenu.setEnabled(bl);
    }

    @Override
    public String getGlyphClassName() {
        return SimulationRunGlyph.class.getName();
    }

    public void runComplete(Object object) {
        super.runComplete(object);
        this.updateSimRunDetailsPanel();
        if ("Compute Complete".equals(object)) {
            EventQueue.invokeLater(new RSimSimulationMode$5(this));
        }
    }

    protected void closeAlternativeEditor() {
        ClientApp.app().closeOpenDialogs();
        if (this.m_alternativeEditor != null && this.m_alternativeEditor.isVisible()) {
            this.m_alternativeEditor.menuItemExit_Action();
            ((AbstractAlternativeEditor)this.m_alternativeEditor).setVisible(false);
        }
        if (this.m_singleAlternativeEditor != null && this.m_singleAlternativeEditor.isVisible()) {
            this.m_singleAlternativeEditor.menuItemExit_Action();
            ((AbstractAlternativeEditor)this.m_singleAlternativeEditor).setVisible(false);
        }
    }

    protected String getWorkspaceType() {
        return "rss";
    }

    protected String getSimulationType() {
        return "Simulation";
    }

    protected String getSimulationRunClass() {
        return SIMULATION_RUN_CLASS;
    }

    public SimulationExtract getExtractModel() {
        return new SimulationExtractModel((ManagerProxyListContainer)ClientApp.Workspace());
    }

    @Override
    public PopupMenuHandler getPopupMenuHandler() {
        if (this._popupMenuHandler == null) {
            this._popupMenuHandler = new RSimPopupMenuHandler(this);
        }
        return this._popupMenuHandler;
    }

    @Override
    public void editReservoir() {
        Object object = this._frame.getMapPanel().findGlyphOfClass(this.getGlyphClassName());
        if (object == null) {
            return;
        }
        if ((object = object.getSelectedObject()) != null && object instanceof ReservoirElement) {
            this.editReservoir(object.getName());
            return;
        }
        object = this.getNetwork();
        if (object == null) {
            RMAIO.postError((Component)this._frame, (String)"Please open/create a network first");
            return;
        }
        if ((object = ((RssSystem)object).getReservoirNames()) == null || ((Object)object).length <= 0) {
            RMAIO.postWarning((Component)this._frame, (String)"No Reservoirs in current Network to edit");
            return;
        }
        this.editReservoir((String)object[0]);
    }

    public void editVerticalDatum() {
        Object object;
        Object object2 = this.getNetwork();
        ArrayList<ReservoirElementVerticalDatumSettingsProvider> arrayList = new ArrayList<ReservoirElementVerticalDatumSettingsProvider>();
        ArrayList<JunctionElementVerticalDatumSettingsProvider> arrayList2 = new ArrayList<JunctionElementVerticalDatumSettingsProvider>();
        object2 = ((RssSystem)object2).getElementVector();
        object2 = ((Vector)object2).iterator();
        while (object2.hasNext()) {
            object = object2.next();
            if (object instanceof ReservoirElement) {
                arrayList.add(new ReservoirElementVerticalDatumSettingsProvider((ReservoirElement)object));
                continue;
            }
            if (!(object instanceof JunctionElement)) continue;
            arrayList2.add(new JunctionElementVerticalDatumSettingsProvider((JunctionElement)object));
        }
        object2 = new ArrayList<ReservoirElementVerticalDatumSettingsProvider>();
        object2.addAll(arrayList);
        object2.addAll(arrayList2);
        object = new EditVerticalDatumAction((List<VerticalDatumSettingsProvider>)object2);
        ((EditVerticalDatumAction)object).a();
    }

    @Override
    public void editReservoir(String object) {
        this._frame.setWaitCursor();
        try {
            boolean bl = false;
            if (this._resDlg != null) {
                int n;
                if (this._resDlg.isModified() && (n = RMAIO.postYesNoWarning((Component)((Object)this._resDlg), (String)"Items have changed! Would you like to Save?")) == 0) {
                    this._resDlg.saveForm();
                }
            } else {
                this._resDlg = new ReservoirJFrame((JFrame)AppDaddy.getFrame(), false);
                this._resDlg.setLocationRelativeTo((JFrame)AppDaddy.getFrame());
                bl = true;
            }
            RssReturnStatusConstants rssReturnStatusConstants = this.getNetwork();
            if (!this._resDlg.initDlg(this.getNetwork())) {
                return;
            }
            Object object2 = this.getActiveRun();
            if (object2 instanceof RssSimulationRun) {
                this._resDlg.setAlternative(((RssSimulationRun)object2).getRssAlt());
            }
            this._resDlg.setEditable(this.hasWriteLock());
            if (object != null) {
                this._resDlg.selectReservoir((String)object);
            }
            object2 = this._activeSimRun.getRssAlt();
            if (rssReturnStatusConstants != null && object2 != null) {
                if ((rssReturnStatusConstants = (object = ((RssSystem)rssReturnStatusConstants).findReservoir((String)object)) != null ? ((ReservoirElement)object).getReservoirOp() : null) != null) {
                    ((ReservoirOp)rssReturnStatusConstants).getOperationSets();
                    int n = ((RssAlt)object2).getResOpSetSelection(object.getIndex());
                    object = ((ReservoirOp)rssReturnStatusConstants).getOperationSet(n);
                    this._resDlg.setSelectedOpSet((OpSet)object);
                }
                if (this.getSimulation() != null) {
                    this._resDlg.setRunTimeWindow(this.getSimulation().getRunTimeWindow());
                }
            }
            this._resDlg.setVisible(true);
            if (bl) {
                object = this._resDlg.getSize();
                this._resDlg.setMinimumSize((Dimension)object);
                this._resDlg.setSize((Dimension)object);
            }
            this._resDlg.setAlwaysOnTop(true);
            this._resDlg.toFront();
            this._resDlg.requestFocus();
            this._resDlg.setAlwaysOnTop(false);
            return;
        }
        finally {
            this._frame.setDefaultCursor();
            this._frame.repaint();
        }
    }

    @Override
    public void editReach() {
        Object object = this._frame.getMapPanel().findGlyphOfClass(this.getGlyphClassName());
        if (object == null) {
            return;
        }
        if ((object = object.getSelectedObject()) instanceof ReachElement) {
            this.editReach(object.getName());
            return;
        }
        object = this.getNetwork();
        if (object == null) {
            RMAIO.postError((Component)this._frame, (String)"Please open/create a network first");
            return;
        }
        if ((object = ((RssSystem)object).getReachNames()) == null || ((Object)object).length <= 0) {
            RMAIO.postWarning((Component)this._frame, (String)"No Reaches in current Network to edit");
            return;
        }
        this.editReach((String)object[0]);
    }

    @Override
    public void editReach(String string) {
        this._frame.setWaitCursor();
        try {
            if (this._reachDlg == null) {
                this._reachDlg = new ReachDlg((Frame)this._frame, false);
            }
            this._reachDlg.setSystem(this.getNetwork());
            if (!this._reachDlg.initDlg()) {
                return;
            }
            SimulationRun simulationRun = this.getActiveRun();
            if (simulationRun instanceof RssSimulationRun) {
                this._reachDlg.setAlternative(((RssSimulationRun)simulationRun).getRssAlt());
            }
            this._reachDlg.setEditable(this.hasWriteLock());
            if (string != null) {
                this._reachDlg.selectReach(string);
            }
            this._reachDlg.setVisible(true);
            this._reachDlg.setAlwaysOnTop(true);
            this._reachDlg.toFront();
            this._reachDlg.requestFocus();
            this._reachDlg.setAlwaysOnTop(false);
            return;
        }
        finally {
            this._frame.setDefaultCursor();
        }
    }

    @Override
    public void editDiversion() {
        Object object = this._frame.getMapPanel().findGlyphOfClass(this.getGlyphClassName());
        if (object == null) {
            return;
        }
        if ((object = object.getSelectedObject()) instanceof DiversionElement) {
            this.editDiversion(object.getName());
            return;
        }
        object = this.getNetwork();
        if (object == null) {
            RMAIO.postError((Component)this._frame, (String)"Please open/create a network first");
            return;
        }
        if ((object = ((RssSystem)object).getDiversionNames()) == null || ((Object)object).length <= 0) {
            RMAIO.postWarning((Component)this._frame, (String)"No Diversions in current Network to edit");
            return;
        }
        this.editDiversion((String)object[0]);
    }

    @Override
    public void editDiversion(String string) {
        this._frame.setWaitCursor();
        try {
            if (this._divDlg == null) {
                this._divDlg = new DiversionEditorDlg((Frame)this._frame, false);
            }
            this._divDlg.setRssSystem(this.getNetwork());
            if (!this._divDlg.initDlg()) {
                return;
            }
            SimulationRun simulationRun = this.getActiveRun();
            if (simulationRun instanceof RssSimulationRun) {
                this._divDlg.setAlternative(((RssSimulationRun)simulationRun).getRssAlt());
            }
            this._divDlg.selectDiversion(string);
            this._divDlg.setEditable(this.hasWriteLock());
            if (!this._divDlg.isVisible()) {
                this._divDlg.setVisible(true);
            }
            this._divDlg.setAlwaysOnTop(true);
            this._divDlg.toFront();
            this._divDlg.requestFocus();
            this._divDlg.setAlwaysOnTop(false);
            return;
        }
        finally {
            this._frame.setDefaultCursor();
        }
    }

    @Override
    public void editDivertedOutlet(String object) {
        this._frame.setWaitCursor();
        try {
            if (this._resDlg == null) {
                this._resDlg = new ReservoirJFrame((Frame)this._frame, false);
            }
            RssReturnStatusConstants rssReturnStatusConstants = this.getNetwork();
            if (!this._resDlg.initDlg(this.getNetwork())) {
                return;
            }
            this._resDlg.setEditable(this.hasWriteLock());
            RssAlt rssAlt = this._activeSimRun.getRssAlt();
            if (rssReturnStatusConstants != null && rssAlt != null) {
                if ((object = ((RssSystem)rssReturnStatusConstants).findDivertedOutlet((String)object)) == null) {
                    return;
                }
                object = (ReservoirElement)((Element)object).getParent();
                this._resDlg.selectReservoir(object.getName());
                rssReturnStatusConstants = object != null ? ((ReservoirElement)object).getReservoirOp() : null;
                if (rssReturnStatusConstants != null) {
                    ((ReservoirOp)rssReturnStatusConstants).getOperationSets();
                    int n = rssAlt.getResOpSetSelection(object.getIndex());
                    object = ((ReservoirOp)rssReturnStatusConstants).getOperationSet(n);
                    this._resDlg.setSelectedOpSet((OpSet)object);
                }
            }
            this._resDlg.setVisible(true);
            object = this._resDlg.getSize();
            this._resDlg.setMinimumSize((Dimension)object);
            this._resDlg.setSize((Dimension)object);
            return;
        }
        finally {
            this._frame.setDefaultCursor();
            this._frame.repaint();
        }
    }

    @Override
    public void editJunction() {
        Object object = this._frame.getMapPanel().findGlyphOfClass(this.getGlyphClassName());
        if (object == null) {
            return;
        }
        if ((object = object.getSelectedObject()) instanceof JunctionElement) {
            this.editJunction(object.getName());
            return;
        }
        object = this.getNetwork();
        if (object == null) {
            RMAIO.postError((Component)this._frame, (String)"Please open/create a network first");
            return;
        }
        if ((object = ((RssSystem)object).getJunctionNames()) == null || ((Object)object).length <= 0) {
            RMAIO.postWarning((Component)this._frame, (String)"No Junctions in current Network to edit");
            return;
        }
        this.editJunction((String)object[0]);
    }

    @Override
    public void editJunction(String object) {
        this._frame.setWaitCursor();
        try {
            if (this._juncDlg == null) {
                this._juncDlg = new JunctionDialog((Frame)this._frame, false);
            }
            this._juncDlg.setRssSystem(this.getNetwork());
            if (!this._juncDlg.initDlg()) {
                return;
            }
            this._juncDlg.setAllowJunctionMovement(false);
            this._juncDlg.setEditable(this.hasWriteLock());
            if (object != null) {
                this._juncDlg.selectJunction((String)object);
            }
            this._juncDlg.toFront();
            this._juncDlg.setVisible(true);
            object = new Dimension(650, 700);
            this._juncDlg.setSize((Dimension)object);
            this._juncDlg.setPreferredSize((Dimension)object);
            this._juncDlg.setMinimumSize((Dimension)object);
            this._juncDlg.setLocationRelativeTo(this._juncDlg.getParent());
            this._juncDlg.setAlwaysOnTop(false);
            return;
        }
        finally {
            this._frame.setDefaultCursor();
        }
    }

    public void editReservoirSysOps() {
        this._frame.setWaitCursor();
        try {
            RssSystem rssSystem = this.getNetwork();
            if (rssSystem == null) {
                RMAIO.postWarning((Component)this._frame, (String)"No Network selected");
                return;
            }
            if (this._resSysOpsDlg == null) {
                this._resSysOpsDlg = new ReservoirSystemJDialog((Frame)this._frame, "Reservoir System Editor - Network: " + rssSystem.getName(), false);
                rssSystem.getRssRun();
                RssRun rssRun = this.getRssRun();
                rssSystem.setRssRun(rssRun);
                this._resSysOpsDlg.setSystem(rssSystem);
                if (!this._resSysOpsDlg.initDlg()) {
                    return;
                }
            } else if (this._resSysOpsDlg.getSystem() != rssSystem) {
                this._resSysOpsDlg.clearForm();
                this._resSysOpsDlg.setSystem(rssSystem);
                this._resSysOpsDlg.initDlg();
            }
            this._resSysOpsDlg.setVisible(true);
            return;
        }
        finally {
            this._frame.setDefaultCursor();
        }
    }

    public void editGlobalVariables() {
        RssSystem rssSystem = this.getNetwork();
        if (rssSystem == null) {
            System.out.println("editGlobalVariables:no network selected");
            RMAIO.postError((Component)this._frame, (String)"Please open/create a network first");
            return;
        }
        if (this._globalVariableDialog == null) {
            this._globalVariableDialog = new GlobalVariableEditor((Frame)this._frame);
        }
        this._globalVariableDialog.fillForm(rssSystem);
        this._globalVariableDialog.setEditable(this.hasWriteLock());
        this._globalVariableDialog.setVisible(true);
    }

    public void editStateVariables() {
        RssSystem rssSystem = this.getNetwork();
        if (rssSystem == null) {
            RMAIO.postError((Component)this._frame, (String)"Please open/create a network first");
            return;
        }
        this._frame.setWaitCursor();
        try {
            if (this._stateVariableDialog == null) {
                this._stateVariableDialog = new StateVariableDialog((Frame)this._frame, false);
            }
            this._stateVariableDialog = new StateVariableDialog((Frame)this._frame, false);
            this._stateVariableDialog.fillForm(this.getNetwork());
            this._stateVariableDialog.setEditable(this.hasWriteLock());
            this._stateVariableDialog.setVisible(true);
            return;
        }
        finally {
            this._frame.setDefaultCursor();
        }
    }

    public void editWaterAccountSets() {
        RssSystem rssSystem = this.getNetwork();
        if (rssSystem == null) {
            RMAIO.postError((Component)this._frame, (String)"Please open/create a network first");
            return;
        }
        this._waterAccountSetEditor = new WaterAccountSetEditor((Frame)this._frame, false, this.getNetwork());
        this._waterAccountSetEditor.fillForm(this.getNetwork().getWaterAccountSetList(), null);
        this._waterAccountSetEditor.setEditable(this.hasWriteLock());
        this._waterAccountSetEditor.setModified(false);
        this._waterAccountSetEditor.setVisible(true);
    }

    @Override
    public void editConfiguration() {
        boolean bl = this._editConfigMenuItem.isSelected();
        if (!this.lockConfiguration(bl)) {
            this._editConfigMenuItem.setSelected(!bl);
        }
    }

    @Override
    public boolean isNetworkLocked() {
        return this._activeSimRun != null;
    }

    protected void syncMenusWithTree() {
        Vector vector = this._simulationTree.getSelectedRuns();
        Vector<String> vector2 = new Vector<String>(vector.size());
        for (int i = 0; i < vector.size(); ++i) {
            vector2.add(vector.get(i).toString());
        }
        RSimSimulationMode rSimSimulationMode = this;
        rSimSimulationMode.syncMenuWithTree(rSimSimulationMode._computeLogsMenu, vector2);
    }

    void syncMenuWithTree(JMenu jMenu, Vector vector) {
        JMenu jMenu2 = jMenu;
        synchronized (jMenu2) {
            Component component;
            int n;
            int n2 = jMenu.getMenuComponentCount();
            ((FluentLogger.Api)LOGGER.atInfo()).log("syncMenuWithTree:menu size = " + n2);
            for (n = 0; n < n2; ++n) {
                ((FluentLogger.Api)LOGGER.atInfo()).log("syncMenuWithTree:menu size now = " + jMenu.getMenuComponentCount());
                component = jMenu.getMenuComponent(n);
                if (!(component instanceof JMenuItem)) continue;
                component = (JMenuItem)component;
                ((JComponent)component).setVisible(vector.contains(((AbstractButton)component).getText()));
            }
            n = 0;
            for (int i = 0; i < n2; ++i) {
                component = jMenu.getMenuComponent(i);
                if (!component.isVisible()) continue;
                n = 1;
                break;
            }
            jMenu.setEnabled(n != 0);
            return;
        }
    }

    public void getMenuLogFiles(JMenu jMenu, String object, String object2, String string, boolean bl, boolean bl2) {
        JMenu jMenu2 = jMenu;
        synchronized (jMenu2) {
            Object object3 = this.getSimulation();
            jMenu.removeAll();
            if (object3 == null) {
                return;
            }
            RmiFileManager rmiFileManager = (RmiFileManager)ClientApp.app().getFileManager().getRemote();
            if (rmiFileManager == null) {
                System.out.println("getMenuLogsFiles: ERROR no RmiFileManager! ");
                return;
            }
            try {
                Identifier identifier = new Vector();
                object2 = new StringTokenizer((String)object2, ",");
                while (((StringTokenizer)object2).hasMoreTokens()) {
                    identifier.add(((StringTokenizer)object2).nextToken());
                }
                object = object3.getSimulationPath() + "/" + (String)object;
                object = rmiFileManager.getRemoteFileIDList(ClientApp.app().getUser(), (String)object, identifier);
                if (object == null) {
                    return;
                }
                Vector<Object> vector = new Vector<Object>(((Vector)object).size());
                for (int i = ((Vector)object).size() - 1; i >= 0; --i) {
                    rmiFileManager = (Identifier)((Vector)object).get(i);
                    object2 = RMAIO.getPathNoExtension((String)rmiFileManager.getPath());
                    boolean bl3 = false;
                    if (i > 0) {
                        for (int j = i - 1; j >= 0; --j) {
                            identifier = (Identifier)((Vector)object).get(j);
                            object3 = RMAIO.getPathNoExtension((String)identifier.getPath());
                            if (!object3.equals(object2) || rmiFileManager.getPath().equals(identifier.getPath())) continue;
                            if (rmiFileManager.lastModified() > identifier.lastModified()) {
                                vector.add(rmiFileManager);
                                ((Vector)object).remove(identifier);
                            } else {
                                vector.add(identifier);
                                ((Vector)object).remove(identifier);
                            }
                            bl3 = true;
                            break;
                        }
                    }
                    if (bl3 || vector.contains(rmiFileManager)) continue;
                    vector.add(rmiFileManager);
                }
                for (int i = 0; i < vector.size(); ++i) {
                    rmiFileManager = (Identifier)vector.get(i);
                    if (rmiFileManager == null) continue;
                    String string2 = rmiFileManager.getName();
                    string2 = RMAIO.getFileNameNoExtension((String)string2);
                    if (bl2) {
                        string2 = this.convertRunIDtoName(string2);
                    }
                    JMenuItem jMenuItem = new JMenuItem(string2);
                    jMenuItem.setName(rmiFileManager.getPath());
                    jMenuItem.setActionCommand(string);
                    jMenuItem.setToolTipText(rmiFileManager.getPath());
                    jMenuItem.addActionListener(this);
                    jMenu.add(jMenuItem);
                }
            }
            catch (RemoteException remoteException) {
                System.out.println("getMenuLogFiles: RMI Error getting directory listing from FileManager " + String.valueOf(remoteException));
            }
            return;
        }
    }

    String convertRunIDtoName(String string) {
        int n;
        if (string == null || string.length() == 0) {
            return string;
        }
        Object object = this.getSimulation();
        if (object == null) {
            return string;
        }
        if ((object = object.getSimulationRuns()) == null || (n = ((Vector)object).size()) == 0) {
            return string;
        }
        for (int i = 0; i < n; ++i) {
            int n2;
            SimulationRun simulationRun = (SimulationRun)((Vector)object).get(i);
            if (simulationRun == null) continue;
            if (RMAIO.userNameToFileName((String)simulationRun.getName()).equals(string)) {
                return simulationRun.getUserName();
            }
            Vector vector = simulationRun.getTrials();
            if (vector == null || (n2 = vector.size()) == 0) continue;
            for (int j = 0; j < n2; ++j) {
                SimulationTrialRun simulationTrialRun = (SimulationTrialRun)vector.get(j);
                if (simulationTrialRun == null || !RMAIO.userNameToFileName((String)simulationTrialRun.getName()).equals(string)) continue;
                return simulationTrialRun.getUserName();
            }
        }
        return string;
    }

    public G2dDialog plotReservoir(String string, String string2) {
        Object object = (SimulationRunGlyph)this._frame.getMapPanel().findGlyphOfClass(SimulationRunGlyph.class.getName());
        if (object == null) {
            System.out.println("plotReservoir: failed to find SimulationGlyph");
            return null;
        }
        if ((object = (RssSystemGlyph)object.findGlyphOfClass(RssSystemGlyph.class.getName())) == null) {
            System.out.println("plotReservoir: failed to find RssSystemGlyph");
            return null;
        }
        if ((object = object.selectReservoir(string, false, false)) == null) {
            System.out.println("plotReservoir: failed to find Reservoir " + string);
            return null;
        }
        return ((RSimPopupMenuHandler)this.getPopupMenuHandler()).plotReservoir((ReservoirElement)object, string2);
    }

    public void resetWorkspace() {
        super.resetWorkspace();
        RssSystemDPData.a();
        this._popupMenuHandler = null;
        this._userReportEditor = null;
        this._networkTxt.setEditable(false);
        if (ClientApp.Workspace() != null) {
            this.buildUserReportMenu(ClientApp.Workspace().getWorkspacePath() + "/rss/reports");
        }
        this._massInjectionMgr = null;
        if (this._wqEditorLauncher != null) {
            this._wqEditorLauncher.resetEditors();
        }
        this.openMassInjectionManager();
    }

    private boolean openMassInjectionManager() {
        ClientWorkspace clientWorkspace = ClientApp.Workspace();
        if (clientWorkspace == null) {
            return false;
        }
        Vector vector = clientWorkspace.getManagerIDList("rss", MassInjectionManager.class.getName());
        if (vector.size() > 0 && (vector = (Identifier)vector.elementAt(0)) != null) {
            this._massInjectionMgr = (MassInjectionManager)clientWorkspace.openManager("rss", (Identifier)vector);
            if (this._massInjectionMgr == null) {
                JOptionPane.showMessageDialog((Component)this._frame, "Failed to Open Mass Injection Manager");
                return false;
            }
        }
        return true;
    }

    public void refreshMode() {
        if (this._resDlg != null && !this._resDlg.isVisible()) {
            this._resDlg = null;
        }
        if (this._reachDlg != null && !this._reachDlg.isVisible()) {
            this._reachDlg = null;
        }
        if (this._juncDlg != null && !this._juncDlg.isVisible()) {
            this._juncDlg = null;
        }
        if (this._divDlg != null && !this._divDlg.isVisible()) {
            this._divDlg = null;
        }
        if (this._stateVariableDialog != null && !this._stateVariableDialog.isVisible()) {
            this._stateVariableDialog = null;
        }
        if (this._resSysOpsDlg != null && !this._resSysOpsDlg.isVisible()) {
            this._resSysOpsDlg = null;
        }
        if (this._userReportEditor != null && !this._userReportEditor.isVisible()) {
            this._userReportEditor = null;
        }
    }

    public void setActiveSimRun(SimulationRun object) {
        if (object instanceof RssSimulationRun) {
            object = (RssSimulationRun)object;
            RssAlt rssAlt = object.getRssAlt();
            this.updateWQMenus(rssAlt);
            RssSystem rssSystem = object.getRssSystem();
            if (object != this._activeSimRun) {
                Object object2 = NetworkConversionMessage.a(rssSystem);
                if (object2 == NetworkConversionMessage$NetworkChangeStatus.ShouldBeSaved) {
                    object2 = this.getSimulation();
                    object2.saveManager("rss", rssSystem);
                    if (rssAlt != null) {
                        if (rssAlt.getSystemIndex() != rssSystem.getIndex()) {
                            rssAlt.setSystemIndex(rssSystem.getIndex());
                        }
                        if (rssAlt.getSystemPath() != rssSystem.getPath()) {
                            rssAlt.setSystemPath(rssSystem.getPath());
                        }
                        if (rssAlt.isModified()) {
                            object2.saveManager("rss", rssAlt);
                        }
                    }
                }
                if (rssAlt != null) {
                    rssAlt.addModifiableListener(this);
                }
                if (this._activeSimRun != null && (object2 = this._activeSimRun.getRssAlt()) != null) {
                    object2.removeModifiableListener(this);
                }
            }
            this._activeSimRun = object;
            return;
        }
        this._activeSimRun = null;
    }

    private void updateWQMenus(RssAlt rssAlt) {
        boolean bl = false;
        if (rssAlt != null) {
            bl = rssAlt.hasWaterQualityOptions() && rssAlt.getWaterQualityOptions().shouldRunWq();
        }
        this._wqEditorsMenu.setVisible(bl);
        this._wqEditorsMenu.setEnabled(bl);
        this._wqDebugReportsMenu.setVisible(bl);
        this._wqDebugReportsMenu.setEnabled(bl);
    }

    public SimulationRun getActiveRun() {
        return (SimulationRun)this._activeSimRun;
    }

    public TimeWindow getSimTimeWindow() {
        Object object = this.getSimulation();
        Object object2 = null;
        if (object != null && (object = this.getSimulation().getRunTimeWindow()) != null) {
            object2 = object.getStartTime();
            object = object.getEndTime();
            object2 = object2.getJavaDate(0);
            object = object.getJavaDate(0);
            object2 = new TimeWindow((Date)object2, true, (Date)object, true);
        }
        return object2;
    }

    public SimulationRunTreeNode newSimulationRunTreeNode(SimulationRun simulationRun, JTree jTree) {
        if (simulationRun instanceof SimulationTrialRun) {
            return new RssSimTrialRunTreeNode((SimulationTrialRun)simulationRun, jTree);
        }
        return new RssSimulationRunTreeNode(simulationRun, jTree);
    }

    protected SimulationTree createSimulationTree(SimulationTreeNode object) {
        object = new RssSimulationTree((SimulationTreeNode)object);
        object.setCellRenderer((TreeCellRenderer)new SimulationTreeCellRenderer());
        return object;
    }

    public void menuEditUserReports() {
        Object object = this.getSimulation();
        if (object == null) {
            ClientApp.app().postWarning("Please open a Simulation before attempting to display a report", "No Simulation");
            return;
        }
        object = (SimulationRun)this._activeSimRun;
        if (object == null) {
            ClientApp.app().postWarning("Please set a Run active before attempting to display a report", "No Forecast Run");
            return;
        }
        if (this._userReportEditor == null) {
            this._userReportEditor = new UserReportEditor((Frame)this._frame);
        }
        object = ClientApp.Workspace().getWorkspacePath() + "/rss/reports";
        this._userReportEditor.setReportDirectory((String)object);
        this._userReportEditor.setRun(this.getRssRun());
        this._userReportEditor.setNetwork(this.getNetwork());
        this._userReportEditor.setVisible(true);
        this.buildUserReportMenu((String)object);
    }

    public void buildUserReportMenu(String string) {
        ResSimReportsFactory.buildUserReportMenu(string, this._userReportsMenu, this);
    }

    public UserReportViewerFrame displayUserReportByName(String string, boolean bl) {
        this._userReportsMenu.getMenuComponentCount();
        String string2 = ClientApp.Workspace().getWorkspacePath() + "/rss/reports";
        this.buildUserReportMenu(string2);
        int n = this._userReportsMenu.getMenuComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = this._userReportsMenu.getMenuComponent(i);
            if (!(component instanceof JMenuItem) || !"userReport".equals(((AbstractButton)(component = (JMenuItem)component)).getActionCommand()) || !string.equalsIgnoreCase(((AbstractButton)component).getText())) continue;
            return this.displayUserReport(component.getName(), bl);
        }
        System.out.println("displayUserReportByName:failed to find script item " + string);
        return null;
    }

    public UserReportViewerFrame displayUserReport(String string) {
        return ResSimReportsFactory.displayUserReport((AbstractSimulation)this.getSimulation(), (SimulationRun)this._activeSimRun, this.getRssRun(), string, true);
    }

    public UserReportViewerFrame displayUserReport(String string, boolean bl) {
        return ResSimReportsFactory.displayUserReport((AbstractSimulation)this.getSimulation(), (SimulationRun)this._activeSimRun, this.getRssRun(), string, bl);
    }

    protected CreateSimulationDialog getSimulationDialog(Frame object, boolean bl) {
        object = new SimulationDialog((Frame)object, bl);
        object.setTablePanelBorderTitle(this.getTablePanelBorder());
        return object;
    }

    public void runSimulationExtract() {
        SimulationPeriod simulationPeriod = this.getSimulation();
        if (simulationPeriod == null) {
            ClientApp.app().postWarning("Please open a Simulation first", "No Simulation");
            return;
        }
        if (this._wqEditorLauncher != null) {
            this._wqEditorLauncher.resetEditors();
        }
        this._frame.setWaitCursor();
        try {
            SimulationExtract simulationExtract = this.getExtractModel();
            if (!simulationPeriod.runExtract(simulationExtract) || ((SimulationExtractModel)simulationExtract).hasError()) {
                this.tellUserAboutExtractErrors(((SimulationExtractModel)simulationExtract).getErrors());
            } else {
                this._frame.printMessage("Extract Complete.");
            }
            return;
        }
        finally {
            this._frame.setDefaultCursor();
        }
    }

    private void tellUserAboutExtractErrors(List<String> object) {
        if (this._frame != null && this._frame.isVisible()) {
            ExtractFailuresDialog extractFailuresDialog = new ExtractFailuresDialog((Window)this._frame);
            extractFailuresDialog.setVisible(true);
            if (!extractFailuresDialog.wasCanceled()) {
                extractFailuresDialog = new RmaJDialog((Frame)this._frame, "Extract Errors", false);
                extractFailuresDialog.getContentPane().setLayout(new GridBagLayout());
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = 0; i < object.size(); ++i) {
                    stringBuilder.append(object.get(i));
                    stringBuilder.append("\n");
                }
                RmaJTextArea rmaJTextArea = new RmaJTextArea(stringBuilder.toString());
                rmaJTextArea.setEditable(false);
                object = new GridBagConstraints();
                new GridBagConstraints().gridx = -1;
                ((GridBagConstraints)object).gridy = -1;
                ((GridBagConstraints)object).gridwidth = 0;
                ((GridBagConstraints)object).weightx = 1.0;
                ((GridBagConstraints)object).weighty = 1.0;
                ((GridBagConstraints)object).anchor = 18;
                ((GridBagConstraints)object).fill = 1;
                ((GridBagConstraints)object).insets = RmaInsets.INSETS5505;
                extractFailuresDialog.getContentPane().add((Component)new JScrollPane((Component)rmaJTextArea), object);
                stringBuilder = new ButtonCmdPanel(256);
                ((GridBagConstraints)object).gridx = -1;
                ((GridBagConstraints)object).gridy = -1;
                ((GridBagConstraints)object).gridwidth = 0;
                ((GridBagConstraints)object).weightx = 1.0;
                ((GridBagConstraints)object).weighty = 0.0;
                ((GridBagConstraints)object).anchor = 16;
                ((GridBagConstraints)object).fill = 2;
                ((GridBagConstraints)object).insets = RmaInsets.INSETS5555;
                extractFailuresDialog.getContentPane().add((Component)((Object)stringBuilder), object);
                stringBuilder.addCmdPanelListener(new RSimSimulationMode$6(extractFailuresDialog));
                extractFailuresDialog.pack();
                extractFailuresDialog.setSize(900, 400);
                extractFailuresDialog.setLocationRelativeTo((Component)this._frame);
                extractFailuresDialog.setVisible(true);
            }
        }
        ((FluentLogger.Api)LOGGER.atInfo()).log("Errors Occurred in the Simulation Extract");
        ClientApp.frame().printMessage("Errors Occurred in the Simulation Extract");
    }

    public void saveAlternativeResults() {
        block19: {
            Object object = this.getActiveRun();
            if (object == null) {
                ClientApp.app().postWarning("No Active Run", "Warning");
                return;
            }
            Object object2 = this.getSimulation();
            if (object2 == null) {
                ClientApp.app().postWarning("No Simulation Selected", "Warning");
                return;
            }
            int n = 0;
            if (ClientApp.frame() != null && ClientApp.frame().isVisible()) {
                n = JOptionPane.showConfirmDialog((Component)this._frame, "Saving the reference results will overwrite any previous reference results.\nAre you sure?", "Confirm Save", 0);
            }
            if (n != 0) {
                return;
            }
            String string = object2.getReferenceResultsPath();
            String string2 = string + "/" + object2.getOutputDSSFileName();
            DSSManager dSSManager = object2.getDSSFileManager();
            DSSIdentifier dSSIdentifier = new DSSIdentifier(object2.getOutputDSSFilePath());
            new DSSIdentifier(string2);
            try {
                object = dSSManager.searchDSSPaths(dSSIdentifier, "", "", "", "", "", object.getKey());
            }
            catch (RemoteException remoteException) {
                System.out.println("saveAlternativeResults:Error searching dss paths. RemoteException " + String.valueOf(remoteException));
                remoteException.printStackTrace();
                return;
            }
            dSSIdentifier = (RmiFileManager)ClientApp.app().getFileManager().getRemote();
            if (object != null && ((Vector)object).size() > 0) {
                try {
                    if (!dSSIdentifier.fileExists(string2)) {
                        Identifier identifier = new Identifier(string2);
                        if (dSSIdentifier.newFile(ClientApp.app().getUser(), identifier) == null) {
                            ClientApp.app().postError("Failed to create reference results dss file\n" + string2, "Error");
                            return;
                        }
                    }
                }
                catch (RemoteException remoteException) {
                    System.out.println("saveAlternativeResults:Error creating results DSS file. RemoteException " + String.valueOf(remoteException));
                    remoteException.printStackTrace();
                }
                try {
                    int n2 = dSSManager.copyRecordsFrom(object2.getOutputDSSFilePath(), string2, (List)object);
                    ClientApp.app().postMessage("Saved " + n2 + " of " + ((Vector)object).size() + " pathnames to " + string2, "", -1);
                }
                catch (RemoteException remoteException) {
                    System.out.println("saveAlternativeResults:Error saving results. RemoteException " + String.valueOf(remoteException));
                    remoteException.printStackTrace();
                }
            } else {
                ClientApp.app().postMessage("No pathnames found", "", -1);
            }
            RssRun rssRun = this.getRssRun();
            if (rssRun != null) {
                object = rssRun.getOutputFile(true);
                try {
                    if (dSSIdentifier.fileExists((String)object)) {
                        object2 = RMAIO.getFileFromPath((String)object);
                        if (!dSSIdentifier.copyFile((Identifier)(object = new Identifier((String)object)), (Identifier)(string = new Identifier((String)(object2 = string + "/" + (String)object2))))) {
                            ClientApp.app().postError("Failed to copy RssOut file to " + (String)object2, "Copy Failed");
                        }
                        break block19;
                    }
                    ClientApp.app().postError("Failed to find RssOutFile " + (String)object, "Missing File");
                    return;
                }
                catch (RemoteException remoteException) {
                    System.out.println("saveAlternativeResults:Error copying RssOut file. RemoteException " + String.valueOf(remoteException));
                    remoteException.printStackTrace();
                }
            }
        }
    }

    public void runDssComparison() {
        Object object = new RemoteFileChooser((Frame)this._frame, true);
        SimulationPeriod simulationPeriod = this.getSimulation();
        String string = simulationPeriod.getReferenceResultsPath();
        object.setPath(string);
        object.setFile("*.out");
        object.setWorkspace(ClientApp.Workspace());
        object.setFileManager((RmiFileManager)ClientApp.app().getFileManager().getRemote());
        object.fillDialog();
        object.setTitle("Select Results output");
        object.setVisible(true);
        if (!object.ok()) {
            return;
        }
        object = object.getIdentifier();
        object = new AltDssComparisonDlg(this._frame, simulationPeriod, (Identifier)object);
        object.setVisible(true);
    }

    public void displaySimulationsReport() {
        if (this._simulationsReport == null) {
            this._simulationsReport = new SimulationListReport((Frame)this._frame);
        } else {
            this._simulationsReport.fillForm();
        }
        this._simulationsReport.setVisible(true);
    }

    public boolean switchModeOk() {
        if (this._simulation != null) {
            if (this.checkAndSaveManagerChanges(ClientApp.app().getAppType(), (Manager)this._simulation, this._simulation.getClass().getName(), "Simulation", false) <= 0) {
                return false;
            }
            this._simulation.reloadManagers();
            this.updateManagerMaps();
        }
        return true;
    }

    public void replaceFromBaseAction() {
        this.saveSimulation();
        CopySimulationDataDialog copySimulationDataDialog = new CopySimulationDataDialog((Frame)ClientApp.frame(), true);
        copySimulationDataDialog.setRefreshData();
        if (this.getSimulation() != null) {
            copySimulationDataDialog.setSimulation(this.getSimulation());
        }
        copySimulationDataDialog.setVisible(true);
        if (copySimulationDataDialog.isCanceled()) {
            return;
        }
        this.updateAfterReplaceFromBase();
    }

    void updateAfterReplaceFromBase() {
        if (this._wqEditorLauncher != null) {
            this._wqEditorLauncher.resetEditors();
        }
        RssAlt rssAlt = this.getActiveRssAlt();
        this.updateWQMenus(rssAlt);
    }

    public RssAlt getActiveRssAlt() {
        Object object = this.getActiveRun();
        if (object instanceof RssSimulationRun) {
            object = (RssSimulationRun)object;
            return object.getRssAlt();
        }
        return null;
    }

    public boolean computeRun(SimulationRun simulationRun, int n, boolean bl, boolean bl2) {
        Object object = simulationRun.getModelAlt("rss");
        if (this._wqEditorLauncher != null) {
            this._wqEditorLauncher.resetEditors();
        }
        if (object != null && (object = (RssAlt)object.getManager()) != null) {
            Object object2;
            String string;
            if (((RssAlt)object).getTimestep() == -1 || ((RssAlt)object).getTimestepIncrement() == -1) {
                int[] nArray;
                int n2;
                RssRun rssRun = this.getRssRun(simulationRun.getName());
                if (rssRun != null) {
                    ((RssAlt)object).setComputeHoldout(rssRun.getComputeHoldout());
                    ((RssAlt)object).setComputeUnReg(rssRun.getComputeUnReg());
                    ((RssAlt)object).setLogLevel(rssRun.getLogLevel());
                }
                if (rssRun != null && rssRun.getRunTimeWindow() != null && RMAConst.isValidValue((int)rssRun.getRunTimeWindow().getTimeStep())) {
                    n2 = rssRun.getRunTimeWindow().getTimeStepSeconds();
                    string = rssRun.getRunTimeWindow().getTimeStepString(0);
                    nArray = RunTimeWindow.getTimeStep((String)string);
                } else {
                    nArray = RssAlt.a((RssAlt)object);
                    string = RunTimeWindow.getTimeStepString((int)nArray[0], (int)nArray[1]);
                    n2 = RunTimeWindow.getTimeStepSeconds((int)nArray[0], (int)nArray[1]);
                }
                RssSystem rssSystem = ((RssAlt)object).getSystem();
                if (rssSystem != null) {
                    rssSystem.setRssRun(rssRun);
                }
                int n3 = ((RssAlt)object).getFlowComputeType(n2);
                object2 = "default";
                switch (n3) {
                    case 2: {
                        object2 = "instantanteous";
                        break;
                    }
                    case 1: {
                        object2 = "period average";
                    }
                }
                int n4 = 0;
                if (ClientApp.frame() != null && ClientApp.frame().isVisible()) {
                    n4 = JOptionPane.showConfirmDialog((Component)this._frame, "<html>" + simulationRun.getUserName() + "'s timestep is undefined.<br>To set it to the simulation's timestep of <b>" + string + "</b><br>with a flow compute type of <b>" + (String)object2 + "</b><br> and continue the compute, select OK.<br>To set it to something else, select Cancel<br>and edit " + simulationRun.getUserName() + "'s in the Alternative Editor", "Undefined TimeStep", 2, 1);
                } else {
                    System.out.println(simulationRun.getUserName() + "'s timestep is undefined. It is being set to the simulation's timestep of " + string + " with a flow compute type of " + (String)object2);
                }
                if (n4 != 0) {
                    return false;
                }
                ((RssAlt)object).setTimeStep(nArray[0], nArray[1]);
                ((RssAlt)object).setPerAvgFlow(n3 == 1);
            } else if (((RssAlt)object).getFlowComputeType() == 2) {
                object.printMessage("User-Determined Flow Computation Method: Instantaneous");
            } else {
                object.printMessage("User-Determined Flow Computation Method: Period Average");
            }
            if (!bl && this.getFrame().isVisible()) {
                Object object3 = RunDetailsUtilities.a(simulationRun);
                object2 = "";
                string = "";
                if (object3 != null) {
                    object2 = object3.getAltName();
                    string = Integer.toString(object3.getAltIndex());
                }
                long l = this.getSimulation().getAltComputeTime((String)object2 + string, "rss");
                object3 = this.getRunInfo(simulationRun);
                if (object3 != null && !object3.isEmpty() && (object2 = this.getRssRun(((RunInfo)object3.get((int)0)).runName)) != null) {
                    ComputeStatus computeStatus = ((RssRun)object2).getLastComputeStatus();
                    if (l < ((RssRun)object2).getLastModifiedTime()) {
                        bl = true;
                    } else if (l != 0L || computeStatus == ComputeStatus.SUCCESSFUL || computeStatus == ComputeStatus.SKIPPED) {
                        String string2 = "<html><b>" + simulationRun.getUserName() + "</b> has not been changed since its last successful compute.<br><br>Continue with re-compute?</html>";
                        object = "Confirm Compute for " + simulationRun.getUserName();
                        object3 = RmaJFrame.getTopWindow();
                        if (object3 == null) {
                            object3 = this.getFrame();
                        }
                        if (!(bl = JOptionPane.showConfirmDialog((Component)object3, string2, (String)object, 0))) {
                            bl = true;
                        } else {
                            return false;
                        }
                    }
                }
            }
        }
        return super.computeRun(simulationRun, n, bl, bl2);
    }

    protected void simulationEditComplete() {
        RssReturnStatusConstants rssReturnStatusConstants = this.getNetwork();
        if (this._wqEditorLauncher != null) {
            this._wqEditorLauncher.resetEditors();
        }
        if (rssReturnStatusConstants == null) {
            return;
        }
        this._alignment = this._simulation.getStreamAlignment();
        if (this._alignment == null) {
            return;
        }
        Vector vector = rssReturnStatusConstants.getNodeVector();
        for (int i = 0; i < vector.size(); ++i) {
            RssNode rssNode = (RssNode)vector.get(i);
            int n = rssNode.getStreamIndex();
            StreamElement streamElement = this._alignment.findReach(n);
            if (streamElement == null) continue;
            rssNode.setStream(streamElement);
        }
        Vector<JunctionElement> vector2 = rssReturnStatusConstants.getElementVectorByClass(JunctionElement.class);
        for (int i = 0; i < vector2.size(); ++i) {
            rssReturnStatusConstants = vector2.get(i);
            ((JunctionElement)rssReturnStatusConstants).resetStream();
        }
        this.updateSimRunDetailsPanel();
    }

    public void updateManagerMaps() {
        super.updateManagerMaps();
        Object object = this.getNetwork();
        if (object != this._network && this._network != null) {
            this._network.removeModifiableListener(this);
        }
        this._network = object;
        if (this._network != null) {
            this._network.addModifiableListener(this);
            if (this._network.isModified()) {
                this._networkTxt.setText(this._network.getName() + "*");
            } else {
                this._networkTxt.setText(this._network.getName());
            }
            this._networkTxt.setCaretPosition(0);
            object = this._network.getDescription();
            this.setNetworkFieldToolTip((String)object);
            return;
        }
        this._networkTxt.setText("none");
        this.setNetworkFieldToolTip(null);
    }

    public void addManagerMaps() {
        Object object;
        Manager manager;
        Vector<Object> vector = new Vector<Object>();
        if (this._alignment != null) {
            vector.addElement(this._alignment);
        }
        if (this._massInjectionMgr != null && this.shouldComputeWaterQuality()) {
            vector.add((Object)this._massInjectionMgr);
        }
        if ((manager = this.getGeometryDataManager()) != null && this.shouldComputeWaterQuality()) {
            vector.add(new ReachCellsMapObject((WqGeometry)manager));
            manager = manager.getCrossSectionManager();
            if (manager != null && (object = manager.getRasFile()) != null && !((String)object).isEmpty()) {
                RmiFileManager rmiFileManager = (RmiFileManager)ClientApp.app().getFileManager().getRemote();
                try {
                    if (rmiFileManager.fileExists((String)object)) {
                        vector.add(manager);
                    }
                }
                catch (RemoteException remoteException) {
                    Logger.getLogger(RssSystemGlyph.class.getName()).log(Level.FINE, "RAS Cross Section File does not exist. Ignoring glyph draw.", remoteException);
                }
            }
        }
        if ((manager = this.getMetDataManager()) != null && this.shouldComputeWaterQuality()) {
            vector.add(manager);
        }
        if ((object = this.getObservedDataSetManager()) != null && this.shouldComputeWaterQuality()) {
            vector.add(object);
        }
        if (this.getActiveRun() != null) {
            vector.addElement(this.getActiveRun());
        }
        this._frame.getMapPanel().resetManagerMaps(vector);
        this._frame.setGlyphStateFromToolbar();
    }

    @Override
    public MetStationSetDialog displayMetDataSetEditor(MetData metData) {
        return this._wqEditorLauncher.displayMetDataSetEditor(metData);
    }

    @Override
    public ObsDatasetManager getSelectedObsDataSet() {
        Object object = this.getActiveRun();
        if (object instanceof RssSimulationRun && (object = ((RssSimulationRun)object).getRssAlt()) != null && ((RssAlt)object).hasWaterQualityOptions()) {
            AltWaterQualityOptions altWaterQualityOptions = ((RssAlt)object).getWaterQualityOptions();
            return altWaterQualityOptions.getObservedDataSetManager((RssAlt)object);
        }
        return null;
    }

    private void setNetworkFieldToolTip(String object) {
        RssSystem rssSystem = this.getNetwork();
        if (object == null || ((String)object).length() == 0) {
            if (rssSystem != null) {
                this._networkTxt.setToolTipText(rssSystem.getName());
                return;
            }
        } else {
            object = RMAIO.toHtmlString((String)object);
            object = ((String)object).substring(6);
            if (rssSystem != null) {
                object = "<html><b>" + rssSystem.getName() + "</b><br><hr>" + (String)object;
                this._networkTxt.setToolTipText((String)object);
                return;
            }
        }
        this._networkTxt.setToolTipText("Active Reservoir Network Name");
    }

    public void modifiedStateChanged(Modifiable modifiable, boolean bl) {
        this.updateSimRunDetailsPanel();
        if (modifiable != this._network) {
            return;
        }
        if (this._network.isModified()) {
            this._networkTxt.setText(this._network.getName() + "*");
            return;
        }
        this._networkTxt.setText(this._network.getName());
    }

    private void updateSimRunDetailsPanel() {
        Object object = this._simulationTree.getLastSelectedPathComponent();
        SimulationTrialRun simulationTrialRun = null;
        if (object instanceof SimTrialRunTreeNode) {
            simulationTrialRun = ((SimTrialRunTreeNode)object).getTrialSimulationRun();
        } else if (object instanceof SimulationRunTreeNode) {
            simulationTrialRun = ((SimulationRunTreeNode)object).getSimulationRun();
        }
        if (simulationTrialRun != null) {
            this.getSimRunDetailsPanel().fillPanel(this.getSimulation(), (SimulationRun)simulationTrialRun);
        }
    }

    public void refreshPlots() {
        Vector vector = G2dDialog.getVisibleDialogs();
        for (int i = 0; i < vector.size(); ++i) {
            G2dDialog g2dDialog = (G2dDialog)vector.get(i);
            Viewport[] viewportArray = g2dDialog.getPlotpanel().getViewports();
            for (int j = 0; j < viewportArray.length; ++j) {
                Vector vector2 = viewportArray[j].getGlyphVector();
                for (int k = 0; k < vector2.size(); ++k) {
                    G2dGlyph g2dGlyph = (G2dGlyph)vector2.get(k);
                    if (!(g2dGlyph instanceof SimpleDSSTimeSeriesGlyph)) continue;
                    g2dGlyph = (SimpleDSSTimeSeriesGlyph)g2dGlyph;
                    SimpleDSSTimeSeries simpleDSSTimeSeries = (SimpleDSSTimeSeries)g2dGlyph.getG2dObject();
                    simpleDSSTimeSeries.setLoaded(false);
                    simpleDSSTimeSeries.load();
                    g2dGlyph = (G2dTimeSeriesLine)g2dGlyph.getLine();
                    g2dGlyph.clearLineData();
                    g2dGlyph.setRawTimeSeriesData(simpleDSSTimeSeries.tdata, simpleDSSTimeSeries.ydata, null);
                }
                viewportArray[j].setDirty();
            }
            g2dDialog.getPlotpanel().paintGfx();
        }
    }

    protected RmiProgressImpl createComputeProgress(SimulationRun simulationRun, Frame frame) {
        if (simulationRun instanceof RssSimulationRun) {
            try {
                return new EnsembleRmiProgressImpl(frame);
            }
            catch (RemoteException remoteException) {
                return null;
            }
        }
        return super.createComputeProgress(simulationRun, frame);
    }

    public void viewLog(String string) {
        if (string == null) {
            return;
        }
        this._frame.setWaitCursor();
        try {
            string = new Identifier(string);
            string = ClientApp.app().openRemoteFileID((Identifier)string);
            EnsembleRmiTextFileReaderJDialog ensembleRmiTextFileReaderJDialog = new EnsembleRmiTextFileReaderJDialog(this._frame, false, string.getName());
            ensembleRmiTextFileReaderJDialog.setHTTPText(string.getPath().endsWith(".html"));
            ensembleRmiTextFileReaderJDialog.fillForm((Identifier)string);
            ensembleRmiTextFileReaderJDialog.setLocationRelativeTo((Component)this._frame);
            ensembleRmiTextFileReaderJDialog.setVisible(true);
            return;
        }
        finally {
            this._frame.setDefaultCursor();
        }
    }

    public boolean setSimulation(SimulationPeriod simulationPeriod) {
        boolean bl = super.setSimulation(simulationPeriod);
        this._wqEditorLauncher.setWorkspace((ManagerProxyListContainer)simulationPeriod);
        return bl;
    }

    public GeometryEditor displayGeometryEditor() {
        if (this.getSimulation() == null) {
            return null;
        }
        WqGeometry wqGeometry = this.getGeometryDataManager();
        return this._wqEditorLauncher.displayGeometryEditor(wqGeometry);
    }

    public ConstituentSetEditor displayWqConstituentsEditor() {
        if (this.getSimulation() == null) {
            return null;
        }
        ConstituentSetManager constituentSetManager = this.getConstituentSetManager();
        return this._wqEditorLauncher.displayWqConstituentsEditor(constituentSetManager);
    }

    public DispersionCoefEditor displayDispersionCoeffEditor() {
        if (this.getSimulation() == null) {
            return null;
        }
        DispersionSetManager dispersionSetManager = this.getDispersionSetManager();
        return this._wqEditorLauncher.displayDispersionCoeffEditor(dispersionSetManager);
    }

    public WqTsTable displayWqInputsDialog() {
        Object object;
        if (this.getSimulation() == null) {
            return null;
        }
        if (this.shouldComputeWaterQuality() && (object = this.getActiveRun()) instanceof RssSimulationRun) {
            object = (RssSimulationRun)object;
            if ((object = object.getRssAlt()) == null) {
                return null;
            }
            if (((RssAlt)object).hasWaterQualityOptions()) {
                return this._wqEditorLauncher.displayWqTsTable((RssAlt)object);
            }
        }
        return null;
    }

    public MetStationSetDialog displayMetDataSetEditor() {
        if (this.getSimulation() == null) {
            return null;
        }
        MetData metData = this.getMetDataManager();
        return this._wqEditorLauncher.displayMetDataSetEditor(metData);
    }

    public BoundaryConditionEditorDialog displayBoundaryConditionEditor() {
        if (this.getSimulation() == null) {
            return null;
        }
        BoundaryConditionSetManager boundaryConditionSetManager = this.getBoundaryConditionSetManager();
        return this._wqEditorLauncher.displayBoundaryConditionEditor(boundaryConditionSetManager);
    }

    public MassInjectionEditor displayMassInjectionEditor() {
        if (this.getSimulation() == null) {
            return null;
        }
        MassInjectionSetManager massInjectionSetManager = this.getMassInjectionSetManager();
        return this._wqEditorLauncher.displayMassInjectionEditor(massInjectionSetManager);
    }

    public ObservedStationSetDialog displayObservedDataSetEditor() {
        if (this.getSimulation() == null) {
            return null;
        }
        ObsDatasetManager obsDatasetManager = this.getObservedDataSetManager();
        return this._wqEditorLauncher.displayObservedDataSetEditor(obsDatasetManager);
    }

    public InitialConditionsEditor displayInitialConditionsEditor() {
        if (this.getSimulation() == null) {
            return null;
        }
        InitialConditionSetManager initialConditionSetManager = this.getInitialConditionsSetManager();
        return this._wqEditorLauncher.displayInitialConditionsEditor(initialConditionSetManager);
    }

    public ParameterSetEditor displayWqParameterEditor() {
        if (this.getSimulation() == null) {
            return null;
        }
        ParameterSetManager parameterSetManager = this.getParameterSetManager();
        return this._wqEditorLauncher.displayWqParameterEditor(parameterSetManager);
    }

    protected SimulationRunDetailsPanel createSimulationRunDetailsPanel() {
        return new RSSSimRunDetailsPanel();
    }

    public WqGeometry getGeometryDataManager() {
        Object object;
        if (this.getSimulation() == null) {
            return null;
        }
        if (this.shouldComputeWaterQuality() && (object = this.getActiveRun()) instanceof RssSimulationRun) {
            object = (RssSimulationRun)object;
            if ((object = object.getRssAlt()) == null) {
                return null;
            }
            if (((RssAlt)object).hasWaterQualityOptions()) {
                return ((RssAlt)object).getWaterQualityOptions().getGeometryManager((RssAlt)object);
            }
        }
        return null;
    }

    public ObsDatasetManager getObservedDataSetManager() {
        Object object;
        if (this.getSimulation() == null) {
            return null;
        }
        if (this.shouldComputeWaterQuality() && (object = this.getActiveRun()) instanceof RssSimulationRun) {
            object = (RssSimulationRun)object;
            if ((object = object.getRssAlt()) == null) {
                return null;
            }
            if (((RssAlt)object).hasWaterQualityOptions()) {
                return ((RssAlt)object).getWaterQualityOptions().getObservedDataSetManager((RssAlt)object);
            }
        }
        return null;
    }

    @Override
    public MassInjectionSetManager getMassInjectionSetManager() {
        Object object;
        if (this.getSimulation() == null) {
            return null;
        }
        if (this.shouldComputeWaterQuality() && (object = this.getActiveRun()) instanceof RssSimulationRun) {
            object = (RssSimulationRun)object;
            if ((object = object.getRssAlt()) == null) {
                return null;
            }
            if (((RssAlt)object).hasWaterQualityOptions()) {
                return ((RssAlt)object).getWaterQualityOptions().getMassInjectionSetManager((RssAlt)object);
            }
        }
        return null;
    }

    @Override
    public MassInjectionEditor displayMassInjectionEditor(WQMassInjectionSite wQMassInjectionSite) {
        return this._wqEditorLauncher.displayMassInjectionEditor(this.getMassInjectionSetManager(), wQMassInjectionSite);
    }

    @Override
    public MassInjectionManager getMassInjectionMgr() {
        return this._massInjectionMgr;
    }

    @Override
    public WaterQualityEditors getEditorLaucher() {
        return this._wqEditorLauncher;
    }

    public InitialConditionSetManager getInitialConditionsSetManager() {
        Object object;
        if (this.getSimulation() == null) {
            return null;
        }
        if (this.shouldComputeWaterQuality() && (object = this.getActiveRun()) instanceof RssSimulationRun) {
            object = (RssSimulationRun)object;
            if ((object = object.getRssAlt()) == null) {
                return null;
            }
            if (((RssAlt)object).hasWaterQualityOptions()) {
                return ((RssAlt)object).getWaterQualityOptions().getInitialConditionsSetManager((RssAlt)object);
            }
        }
        return null;
    }

    public ParameterSetManager getParameterSetManager() {
        Object object;
        if (this.getSimulation() == null) {
            return null;
        }
        if (this.shouldComputeWaterQuality() && (object = this.getActiveRun()) instanceof RssSimulationRun) {
            object = (RssSimulationRun)object;
            if ((object = object.getRssAlt()) == null) {
                return null;
            }
            if (((RssAlt)object).hasWaterQualityOptions()) {
                return ((RssAlt)object).getWaterQualityOptions().getParameterSetManager((RssAlt)object);
            }
        }
        return null;
    }

    public BoundaryConditionSetManager getBoundaryConditionSetManager() {
        Object object;
        if (this.getSimulation() == null) {
            return null;
        }
        if (this.shouldComputeWaterQuality() && (object = this.getActiveRun()) instanceof RssSimulationRun) {
            object = (RssSimulationRun)object;
            if ((object = object.getRssAlt()) == null) {
                return null;
            }
            if (((RssAlt)object).hasWaterQualityOptions()) {
                return ((RssAlt)object).getWaterQualityOptions().getBcManager((RssAlt)object);
            }
        }
        return null;
    }

    public MetData getMetDataManager() {
        Object object;
        if (this.getSimulation() == null) {
            return null;
        }
        if (this.shouldComputeWaterQuality() && (object = this.getActiveRun()) instanceof RssSimulationRun) {
            object = (RssSimulationRun)object;
            if ((object = object.getRssAlt()) == null) {
                return null;
            }
            if (((RssAlt)object).hasWaterQualityOptions()) {
                return ((RssAlt)object).getWaterQualityOptions().getMetDataManager((RssAlt)object);
            }
        }
        return null;
    }

    public ConstituentSetManager getConstituentSetManager() {
        Object object;
        if (this.getSimulation() == null) {
            return null;
        }
        if (this.shouldComputeWaterQuality() && (object = this.getActiveRun()) instanceof RssSimulationRun) {
            object = (RssSimulationRun)object;
            if ((object = object.getRssAlt()) == null) {
                return null;
            }
            if (((RssAlt)object).hasWaterQualityOptions()) {
                return ((RssAlt)object).getWaterQualityOptions().getConstituentSetManager((RssAlt)object);
            }
        }
        return null;
    }

    public DispersionSetManager getDispersionSetManager() {
        Object object;
        if (this.getSimulation() == null) {
            return null;
        }
        if (this.shouldComputeWaterQuality() && (object = this.getActiveRun()) instanceof RssSimulationRun) {
            object = (RssSimulationRun)object;
            if ((object = object.getRssAlt()) == null) {
                return null;
            }
            if (((RssAlt)object).hasWaterQualityOptions()) {
                return ((RssAlt)object).getWaterQualityOptions().getDispersionSetManager((RssAlt)object);
            }
        }
        return null;
    }

    public boolean shouldComputeWaterQuality() {
        Object object;
        RssRmiWorkspace rssRmiWorkspace = (RssRmiWorkspace)ClientApp.Workspace().getChildWorkspace("rss");
        try {
            object = rssRmiWorkspace.getChildWorkspace("");
            if (object instanceof HecRmiWorkspace) {
                rssRmiWorkspace = ((HecRmiWorkspace)object).getBaseWorkspace();
                rssRmiWorkspace = (RssRmiWorkspace)rssRmiWorkspace.getChildWorkspace("rss");
            }
        }
        catch (RemoteException remoteException) {
            System.out.println("shouldComputeWaterQuality:exception getting base wksp options" + String.valueOf(remoteException));
            return false;
        }
        object = null;
        try {
            if (rssRmiWorkspace != null) {
                object = rssRmiWorkspace.getRssAdvancedOptions();
            }
        }
        catch (RemoteException remoteException) {
            System.out.println("shouldComputeWaterQuality:exception getting advanced options" + String.valueOf(remoteException));
            return false;
        }
        if (object != null && ((RssAdvancedOptions)object).hasWaterQuality()) {
            return this.doesAltUseWaterQuality();
        }
        return false;
    }

    public boolean doesAltUseWaterQuality() {
        Object object = this.getActiveRun();
        if (object instanceof RssSimulationRun) {
            object = (RssSimulationRun)object;
            if ((object = object.getRssAlt()) == null) {
                return false;
            }
            if (((RssAlt)object).hasWaterQualityOptions()) {
                return ((RssAlt)object).getWaterQualityOptions().shouldRunWq();
            }
        }
        return false;
    }
}

