/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.gui.NameDescriptionPanel;
import hec.rss.client.RulePanel;
import hec.rss.model.ReRegRule;
import hec.rss.model.ReRegRule$ReRegPeriod;
import hec.rss.model.ReleaseFuncOpRule;
import hec.rss.model.StorageZone;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.text.Document;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJLabel;
import rma.swing.RmaJPanel;
import rma.swing.RmaJRadioButton;
import rma.swing.text.DssPathnamePartDocument;

public class ReRegRulePanel
extends RulePanel {
    RmaJLabel _upstreamReservoirLabel;
    RmaJLabel _upperZoneLabel;
    RmaJLabel _lowerZoneLabel;
    RmaJComboBox _upstreamReservoirCombo;
    RmaJComboBox _upperZoneCombo;
    RmaJComboBox _lowerZoneCombo;
    RmaJRadioButton _weeklyPeriodRadButton;
    RmaJRadioButton _averagingPeriodRadButton;
    ButtonGroup _periodButtonGroup;
    RmaJComboBox _weekdayCombo;
    RmaJDecimalField _averagingPeriodField;
    Vector<StorageZone> _storageZones;
    String[] _reservoirNames;
    private ReRegRule _rule;

    @Override
    protected void buildControls() {
        this.initComponents();
        new GridBagConstraints();
        new JLabel("Operates Release From:");
        this._nameDescPanel = new NameDescriptionPanel(8L);
        this._nameDescPanel.setNameEditable(false);
        this._nameDescPanel.setNameDocument((Document)new DssPathnamePartDocument());
        this._nameDescPanel.setNameLabel("Rule Name:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        ReRegRulePanel reRegRulePanel = this;
        reRegRulePanel.add((Component)reRegRulePanel._nameDescPanel, gridBagConstraints);
        RmaJPanel rmaJPanel = this.buildReservoirSettingsPanel();
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        this.add((Component)rmaJPanel, gridBagConstraints);
        rmaJPanel = new RmaJPanel();
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        this.add((Component)rmaJPanel, gridBagConstraints);
    }

    private RmaJPanel buildReservoirSettingsPanel() {
        RmaJPanel rmaJPanel = new RmaJPanel((LayoutManager)new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)10, (int)5, (int)5);
        rmaJPanel.add((Component)this._upstreamReservoirLabel, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        rmaJPanel.add((Component)this._upstreamReservoirCombo, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)10, (int)5, (int)5);
        rmaJPanel.add((Component)this._upperZoneLabel, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)5, (int)5, (int)5);
        rmaJPanel.add((Component)this._upperZoneCombo, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)10, (int)5, (int)5);
        rmaJPanel.add((Component)this._lowerZoneLabel, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)5, (int)5, (int)5);
        rmaJPanel.add((Component)this._lowerZoneCombo, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)5, (int)5, (int)5);
        rmaJPanel.add((Component)this._weeklyPeriodRadButton, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)5, (int)5, (int)5);
        rmaJPanel.add((Component)this._weekdayCombo, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)5, (int)5, (int)5);
        rmaJPanel.add((Component)this._averagingPeriodRadButton, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)5, (int)5, (int)5);
        rmaJPanel.add((Component)this._averagingPeriodField, (Object)gridBagConstraints);
        return rmaJPanel;
    }

    private void initComponents() {
        this._upstreamReservoirLabel = new RmaJLabel("Upstream Reservoir:");
        this._upperZoneLabel = new RmaJLabel("Upper Zone Limit:");
        this._lowerZoneLabel = new RmaJLabel("Lower Zone Limit:");
        this._upstreamReservoirCombo = new RmaJComboBox();
        this._upstreamReservoirCombo.addActionListener(actionEvent -> this.setModified(true));
        this._upperZoneCombo = new RmaJComboBox();
        this._upperZoneCombo.addActionListener(actionEvent -> this.setModified(true));
        this._lowerZoneCombo = new RmaJComboBox();
        this._lowerZoneCombo.addActionListener(actionEvent -> this.setModified(true));
        this._weeklyPeriodRadButton = new RmaJRadioButton("Weekly Period Starting On:");
        this._weeklyPeriodRadButton.setSelected(true);
        this._weeklyPeriodRadButton.addActionListener(actionEvent -> {
            this._averagingPeriodField.setEnabled(false);
            this._weekdayCombo.setEnabled(true);
            this.setModified(true);
        });
        this._averagingPeriodRadButton = new RmaJRadioButton("Averaging Period:");
        this._averagingPeriodRadButton.addActionListener(actionEvent -> {
            this._averagingPeriodField.setEnabled(true);
            this._weekdayCombo.setEnabled(false);
            this.setModified(true);
        });
        this._weekdayCombo = new RmaJComboBox((Object[])new String[]{"Monday", "Tuesday", "Wendesday", "Thursday", "Friday", "Saturday", "Sunday"});
        this._averagingPeriodField = new RmaJDecimalField();
        this._averagingPeriodField.setValue(3.5);
        this._averagingPeriodField.setEnabled(false);
        this._periodButtonGroup = new ButtonGroup();
        this._periodButtonGroup.add((AbstractButton)this._weeklyPeriodRadButton);
        this._periodButtonGroup.add((AbstractButton)this._averagingPeriodRadButton);
    }

    @Override
    public void fillPanel(ReleaseFuncOpRule releaseFuncOpRule) {
        if (releaseFuncOpRule instanceof ReRegRule) {
            this._rule = (ReRegRule)releaseFuncOpRule;
            this._nameDescPanel.setName(releaseFuncOpRule.getName());
            this._nameDescPanel.setDescription(releaseFuncOpRule.getDescription());
            ReRegRulePanel reRegRulePanel = this;
            reRegRulePanel.selectUpstreamReservoir(reRegRulePanel._rule.getUpstreamReservoir());
            ReRegRulePanel reRegRulePanel2 = this;
            reRegRulePanel2.selectUpperZone(reRegRulePanel2._rule.getUpperZoneLimit());
            ReRegRulePanel reRegRulePanel3 = this;
            reRegRulePanel3.selectLowerZone(reRegRulePanel3._rule.getLowerZoneLimit());
            ReRegRulePanel reRegRulePanel4 = this;
            reRegRulePanel4.selectStartingWeekday(reRegRulePanel4._rule.getStartingWeekday());
            this._averagingPeriodField.setValue(this._rule.getReRegAveragingPeriod().doubleValue());
            if (this._rule.getReRegPeriod() == ReRegRule$ReRegPeriod.AVERAGING) {
                this._averagingPeriodRadButton.setSelected(true);
                return;
            }
            this._weeklyPeriodRadButton.setSelected(true);
        }
    }

    private void selectUpstreamReservoir(String string) {
        this._upstreamReservoirCombo.setSelectedItem((Object)string);
    }

    private void selectStartingWeekday(String string) {
        this._weekdayCombo.setSelectedItem((Object)string);
    }

    private void selectUpperZone(String object) {
        if (object != null) {
            object = this.getZoneByString((String)object);
            this._upperZoneCombo.setSelectedItem(object);
        }
    }

    private void selectLowerZone(String object) {
        if (object != null) {
            object = this.getZoneByString((String)object);
            this._lowerZoneCombo.setSelectedItem(object);
        }
    }

    private StorageZone getZoneByString(String string) {
        for (StorageZone storageZone : this._storageZones) {
            if (!string.equalsIgnoreCase(storageZone.toString())) continue;
            return storageZone;
        }
        return null;
    }

    @Override
    public void clearPanel() {
    }

    public void fillReservoirNames(String[] stringArray) {
        this._reservoirNames = stringArray;
        if (stringArray != null) {
            this._upstreamReservoirCombo.setModel(new DefaultComboBoxModel<String>(stringArray));
        }
    }

    public void fillZones(Vector<StorageZone> vector) {
        this._storageZones = vector;
        this._upperZoneCombo.setModel(new DefaultComboBoxModel<StorageZone>(vector));
        this._lowerZoneCombo.setModel(new DefaultComboBoxModel<StorageZone>(vector));
    }

    @Override
    public boolean savePanel() {
        if (this._currentRuleRef == null) {
            return true;
        }
        ReRegRule reRegRule = (ReRegRule)this._currentRuleRef.getRule();
        if (this._rule == null) {
            return false;
        }
        reRegRule.setDescription(this._nameDescPanel.getDescription());
        reRegRule.setUpstreamReservoir(this._upstreamReservoirCombo.getSelectedItem().toString());
        reRegRule.setUpperZoneLimit(this._upperZoneCombo.getSelectedItem().toString());
        reRegRule.setLowerZoneLimit(this._lowerZoneCombo.getSelectedItem().toString());
        if (this._averagingPeriodRadButton.isSelected()) {
            reRegRule.setReRegPeriod(ReRegRule$ReRegPeriod.AVERAGING);
        } else {
            reRegRule.setReRegPeriod(ReRegRule$ReRegPeriod.WEEKLY);
        }
        reRegRule.setStartingWeekday(this._weekdayCombo.getSelectedItem().toString());
        reRegRule.setAveragingPeriod(this._averagingPeriodField.getValue());
        return true;
    }
}

