/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.clientapp.client.ClientApp;
import hec.heclib.util.HecTime;
import hec.rss.client.ReleaseDecisionReportEditor$1;
import hec.rss.client.ReleaseDecisionReportEditor$2;
import hec.rss.client.reports.ReleaseDecisionReportOptions;
import hec.rss.model.RssAlt;
import hec.rss.model.RssRun;
import hec.rss.model.RssSystem;
import hec.rss.plugins.model.AltPluginData;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.DateTimePanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDialog;

public class ReleaseDecisionReportEditor
extends RmaJDialog {
    private RmaJComboBox _reservoirCombo;
    private JRadioButton _simulationPeriodRadio;
    private JRadioButton _specifyDateRadio;
    private DateTimePanel _startTimePanel;
    private DateTimePanel _endTimePanel;
    private JPanel _collectionPanel;
    private RmaJComboBox _collectionCombo;
    private ButtonCmdPanel _cmdPanel;
    private RssRun _run;
    private RssSystem _system;
    private RssAlt _alt;
    private List<String> _collections = new ArrayList<String>();
    private boolean _canceled = false;

    public ReleaseDecisionReportEditor(JFrame jFrame, RssRun rssRun, String string, RssSystem rssSystem, RssAlt rssAlt) {
        super((Frame)jFrame, true);
        this._run = rssRun;
        this._system = rssSystem;
        this._alt = rssAlt;
        this.buildControls();
        this.fill(string);
        this.pack();
        ReleaseDecisionReportEditor releaseDecisionReportEditor = this;
        releaseDecisionReportEditor.setLocationRelativeTo(releaseDecisionReportEditor.getParent());
    }

    private void buildControls() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Release Decision Report Options");
        Object object = new JPanel(new GridBagLayout());
        Object object2 = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        ((GridBagConstraints)object2).gridy = 0;
        ((GridBagConstraints)object2).weightx = 0.0;
        ((GridBagConstraints)object2).weighty = 0.0;
        ((GridBagConstraints)object2).gridwidth = 2;
        ((GridBagConstraints)object2).anchor = 18;
        ((GridBagConstraints)object2).fill = 1;
        ((GridBagConstraints)object2).insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)object, object2);
        Object object3 = new JLabel("Reservoir:");
        object2 = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        ((GridBagConstraints)object2).gridy = 0;
        ((GridBagConstraints)object2).weightx = 0.0;
        ((GridBagConstraints)object2).weighty = 0.0;
        ((GridBagConstraints)object2).anchor = 18;
        ((GridBagConstraints)object2).fill = 0;
        ((GridBagConstraints)object2).insets = RmaInsets.INSETS5505;
        ((Container)object).add((Component)object3, object2);
        this._reservoirCombo = new RmaJComboBox((Object[])this._system.getReservoirNames());
        object2 = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        ((GridBagConstraints)object2).gridy = 0;
        ((GridBagConstraints)object2).weightx = 1.0;
        ((GridBagConstraints)object2).weighty = 1.0;
        ((GridBagConstraints)object2).anchor = 18;
        ((GridBagConstraints)object2).fill = 2;
        ((GridBagConstraints)object2).insets = RmaInsets.INSETS5505;
        ((Container)object).add((Component)this._reservoirCombo, object2);
        object = new JPanel(new GridBagLayout());
        ((JComponent)object).setBorder(new TitledBorder("Time Window"));
        object2 = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        ((GridBagConstraints)object2).gridy = 1;
        ((GridBagConstraints)object2).weightx = 0.0;
        ((GridBagConstraints)object2).weighty = 0.0;
        ((GridBagConstraints)object2).anchor = 18;
        ((GridBagConstraints)object2).fill = 1;
        ((GridBagConstraints)object2).insets = RmaInsets.INSETS5555;
        this.getContentPane().add((Component)object, object2);
        this._simulationPeriodRadio = new JRadioButton("Simulation Period");
        object2 = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        ((GridBagConstraints)object2).gridy = 0;
        ((GridBagConstraints)object2).weightx = 0.0;
        ((GridBagConstraints)object2).weighty = 0.0;
        ((GridBagConstraints)object2).anchor = 18;
        ((GridBagConstraints)object2).fill = 1;
        ((GridBagConstraints)object2).insets = RmaInsets.INSETS5505;
        ((Container)object).add((Component)this._simulationPeriodRadio, object2);
        this._specifyDateRadio = new JRadioButton("Specify");
        object2 = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        ((GridBagConstraints)object2).gridy = 1;
        ((GridBagConstraints)object2).weightx = 0.0;
        ((GridBagConstraints)object2).weighty = 0.0;
        ((GridBagConstraints)object2).anchor = 18;
        ((GridBagConstraints)object2).fill = 1;
        ((GridBagConstraints)object2).insets = RmaInsets.INSETS0505;
        ((Container)object).add((Component)this._specifyDateRadio, object2);
        object3 = new ButtonGroup();
        ((ButtonGroup)object3).add(this._specifyDateRadio);
        ((ButtonGroup)object3).add(this._simulationPeriodRadio);
        object3 = new ReleaseDecisionReportEditor$1(this);
        this._specifyDateRadio.addActionListener((ActionListener)object3);
        this._simulationPeriodRadio.addActionListener((ActionListener)object3);
        JPanel jPanel = new JPanel(new GridBagLayout());
        ((GridBagConstraints)object2).gridx = 0;
        ((GridBagConstraints)object2).gridy = 2;
        ((GridBagConstraints)object2).anchor = 18;
        ((GridBagConstraints)object2).fill = 1;
        ((GridBagConstraints)object2).weightx = 0.0;
        ((GridBagConstraints)object2).weighty = 0.0;
        ((GridBagConstraints)object2).insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        ((Container)object).add((Component)jPanel, object2);
        object3 = new JLabel("Start Date:");
        ((JLabel)object3).setDisplayedMnemonic('S');
        ((GridBagConstraints)object2).gridx = 0;
        ((GridBagConstraints)object2).gridy = 0;
        ((GridBagConstraints)object2).anchor = 18;
        ((GridBagConstraints)object2).fill = 0;
        ((GridBagConstraints)object2).insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        jPanel.add((Component)object3, object2);
        this._startTimePanel = new DateTimePanel(1, "", "Time:", "DDMMMYYYY");
        ((JLabel)object3).setLabelFor((Component)this._startTimePanel);
        this._startTimePanel.setTimeZone(ClientApp.app().getClientTimeZone());
        this._startTimePanel.setDataTimeZone(ClientApp.Workspace().getTimeZone());
        ((GridBagConstraints)object2).gridx = 1;
        ((GridBagConstraints)object2).gridy = 0;
        ((GridBagConstraints)object2).anchor = 18;
        ((GridBagConstraints)object2).fill = 2;
        ((GridBagConstraints)object2).insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        jPanel.add((Component)this._startTimePanel, object2);
        object = new JLabel("End Date:");
        ((JLabel)object3).setDisplayedMnemonic('E');
        ((GridBagConstraints)object2).gridx = 0;
        ((GridBagConstraints)object2).gridy = 1;
        ((GridBagConstraints)object2).anchor = 18;
        ((GridBagConstraints)object2).fill = 0;
        ((GridBagConstraints)object2).insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        jPanel.add((Component)object, object2);
        this._endTimePanel = new DateTimePanel(1, "", "Time:", "DDMMMYYYY");
        ((JLabel)object3).setLabelFor((Component)this._endTimePanel);
        this._endTimePanel.setTimeZone(ClientApp.app().getClientTimeZone());
        this._endTimePanel.setDataTimeZone(ClientApp.Workspace().getTimeZone());
        ((GridBagConstraints)object2).gridx = 1;
        ((GridBagConstraints)object2).gridy = 1;
        ((GridBagConstraints)object2).anchor = 18;
        ((GridBagConstraints)object2).fill = 2;
        ((GridBagConstraints)object2).insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        jPanel.add((Component)this._endTimePanel, object2);
        this._collectionPanel = new JPanel(new GridBagLayout());
        object2 = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        ((GridBagConstraints)object2).gridy = 4;
        ((GridBagConstraints)object2).weightx = 0.0;
        ((GridBagConstraints)object2).weighty = 0.0;
        ((GridBagConstraints)object2).anchor = 18;
        ((GridBagConstraints)object2).fill = 2;
        ((GridBagConstraints)object2).insets = RmaInsets.INSETS5555;
        this.getContentPane().add((Component)this._collectionPanel, object2);
        object3 = new JLabel("Collection Record:");
        object2 = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        ((GridBagConstraints)object2).gridy = 0;
        ((GridBagConstraints)object2).weightx = 0.0;
        ((GridBagConstraints)object2).weighty = 0.0;
        ((GridBagConstraints)object2).anchor = 18;
        ((GridBagConstraints)object2).fill = 1;
        ((GridBagConstraints)object2).insets = RmaInsets.INSETS5505;
        this._collectionPanel.add((Component)object3, object2);
        if (this._alt != null && this._alt.getPluginDataList() != null && !this._alt.getPluginDataList().isEmpty() && !this._alt.useYieldAnalysis()) {
            object2 = this._alt.getPluginDataList();
            for (int i = 0; i < object2.size(); ++i) {
                object = (AltPluginData)object2.get(i);
                if (!object.useCompute()) continue;
                this._collections = object.getCollectionNumbers(this._alt, this._run.getRunTimeWindow().getStartTime());
                break;
            }
        }
        this._collectionCombo = !this._collections.isEmpty() ? new RmaJComboBox(this._collections.toArray()) : new RmaJComboBox();
        object2 = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        ((GridBagConstraints)object2).gridy = 0;
        ((GridBagConstraints)object2).weightx = 1.0;
        ((GridBagConstraints)object2).weighty = 1.0;
        ((GridBagConstraints)object2).anchor = 18;
        ((GridBagConstraints)object2).fill = 2;
        ((GridBagConstraints)object2).insets = RmaInsets.INSETS5505;
        this._collectionPanel.add((Component)this._collectionCombo, object2);
        this._cmdPanel = new ButtonCmdPanel(12);
        ((GridBagConstraints)object2).gridx = 0;
        ((GridBagConstraints)object2).gridy = 5;
        ((GridBagConstraints)object2).weightx = 1.0;
        ((GridBagConstraints)object2).weighty = 0.0;
        ((GridBagConstraints)object2).anchor = 16;
        ((GridBagConstraints)object2).fill = 2;
        ((GridBagConstraints)object2).insets = RmaInsets.INSETS5555;
        this.getContentPane().add((Component)this._cmdPanel, object2);
        this._cmdPanel.addCmdPanelListener((ButtonCmdPanelListener)new ReleaseDecisionReportEditor$2(this));
    }

    public boolean isCanceled() {
        return this._canceled;
    }

    private void timeWindowOptionAction() {
        if (this._simulationPeriodRadio.isSelected()) {
            this._startTimePanel.setEnabled(false);
            this._endTimePanel.setEnabled(false);
            return;
        }
        this._startTimePanel.setEnabled(true);
        this._endTimePanel.setEnabled(true);
    }

    private boolean checkData() {
        if (this._specifyDateRadio.isSelected()) {
            HecTime hecTime = this._startTimePanel.getDateTime().element(0);
            HecTime hecTime2 = this._endTimePanel.getDateTime().element(0);
            if (hecTime.lessThan(this._run.getRunTimeWindow().getStartTime()) || hecTime.greaterThan(this._run.getRunTimeWindow().getEndTime()) || hecTime.greaterThan(hecTime2)) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Specified Start Time must fall within the actually Simulation Start and End Times.", "Start Time Error", 0);
                return false;
            }
            if (hecTime2.greaterThan(this._run.getRunTimeWindow().getEndTime()) || hecTime2.lessThan(this._run.getRunTimeWindow().getStartTime()) || hecTime2.lessThan(hecTime)) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Specified End Time must fall within the actually Simulation Start and End Times.", "Start Time Error", 0);
                return false;
            }
        }
        return true;
    }

    private void fill(String object) {
        this._reservoirCombo.setSelectedItem(object);
        object = this._run.getReleaseDecisionReportOptions();
        if (object != null) {
            this._reservoirCombo.setSelectedItem((Object)((ReleaseDecisionReportOptions)object).getReservoirName());
            if (((ReleaseDecisionReportOptions)object).getUseSimPeriod()) {
                this._simulationPeriodRadio.setSelected(true);
            } else {
                this._specifyDateRadio.setSelected(true);
            }
            this._startTimePanel.setDateTime(((ReleaseDecisionReportOptions)object).getStartTime(), ClientApp.Workspace().getTimeZone());
            this._endTimePanel.setDateTime(((ReleaseDecisionReportOptions)object).getEndTime(), ClientApp.Workspace().getTimeZone());
            if (this._collections.isEmpty()) {
                this._collectionPanel.setVisible(false);
                return;
            }
            this._collectionCombo.setSelectedItem((Object)((ReleaseDecisionReportOptions)object).getCollection());
        }
        this.timeWindowOptionAction();
    }

    public void save() {
        ReleaseDecisionReportOptions releaseDecisionReportOptions = new ReleaseDecisionReportOptions();
        releaseDecisionReportOptions.setReservoirName((String)this._reservoirCombo.getSelectedItem());
        releaseDecisionReportOptions.setUseSimPeriod(this._simulationPeriodRadio.isSelected());
        releaseDecisionReportOptions.setStartTime(this._startTimePanel.getDateTime().element(0));
        releaseDecisionReportOptions.setEndTime(this._endTimePanel.getDateTime().element(0));
        releaseDecisionReportOptions.setCollection((String)this._collectionCombo.getSelectedItem());
        this._run.setReleaseDecisionReportOptions(releaseDecisionReportOptions);
    }
}

