/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.client.MoverDialog;
import hec.clientapp.client.ClientApp;
import hec.data.ParamDouble;
import hec.lang.NamedType;
import hec.rss.RssRmiWorkspace;
import hec.rss.client.DamLeakageTreeNode;
import hec.rss.client.DivertedOutletTreeNode;
import hec.rss.client.ElementTreeNode;
import hec.rss.client.FunctionTreeNode;
import hec.rss.client.JOperationsPanel;
import hec.rss.client.OutletElementTreeNode;
import hec.rss.client.OutletGroupElementTreeNode;
import hec.rss.client.PoolElementTreeNode;
import hec.rss.client.PoolEvapTreeNode;
import hec.rss.client.PoolSeepageTreeNode;
import hec.rss.client.PowerPlantTreeNode;
import hec.rss.client.PulseRoutingOptionsDialog;
import hec.rss.client.PumpTreeNode;
import hec.rss.client.RSimTreeNode;
import hec.rss.client.ResPhysicalJTree$NodeSelectionListener;
import hec.rss.client.ResPhysicalJTree$TreeModelHandler;
import hec.rss.client.ResPhysicalTreeModel;
import hec.rss.client.ResTreeCellRenderer;
import hec.rss.client.ReservoirDamElementTreeNode;
import hec.rss.client.ReservoirJFrame;
import hec.rss.client.ReversiblePumpTreeNode;
import hec.rss.client.RoutingTreeNode;
import hec.rss.client.TailElevTreeNode;
import hec.rss.client.WaterControlDeviceTreeNode;
import hec.rss.model.Element;
import hec.rss.model.ElementOp;
import hec.rss.model.OpRule;
import hec.rss.model.ReservoirElement;
import hec.rss.model.Spillway;
import hec.rss.server.RssAdvancedOptions;
import hec.server.NameDialog;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import rma.swing.event.ReflectMultiListener;
import rma.swing.text.DssPathnamePartDocument;
import rma.util.RMAUtil;

public class ResPhysicalJTree
extends JTree {
    ReservoirJFrame _parentFrame;
    ResPhysicalTreeModel _resPhysicalModel;
    JPopupMenu _reservoirDamPopup;
    JPopupMenu _outletPopup;
    JPopupMenu _pumpPopup;
    JPopupMenu _outletGroupPopup;
    JPopupMenu _divertedOutletPopup;
    JPopupMenu _poolPopup;
    JPopupMenu _elementPopup;
    JPopupMenu _functionPopup;
    JPopupMenu _waterControlDevicePopup;
    Vector _poolMenus;
    Vector _functionMenus;
    ReflectMultiListener _listener = new ReflectMultiListener();
    HashMap _menuCache = new HashMap();
    private JMenuItem _damAddWQMenuItem;
    private JMenuItem _outletGroupAddWQMenuItem;
    private JMenuItem _outletAddWQMenuItem;
    private JMenuItem _divertedOutletAddWQMenuItem;

    public ResPhysicalJTree(ReservoirJFrame reservoirJFrame) {
        this._parentFrame = reservoirJFrame;
        ResPhysicalJTree resPhysicalJTree = this;
        this.addMouseListener(new ResPhysicalJTree$NodeSelectionListener(resPhysicalJTree, resPhysicalJTree));
        this.setToolTipText("");
    }

    public void setResPhysicalModel(ResPhysicalTreeModel resPhysicalTreeModel) {
        this._resPhysicalModel = resPhysicalTreeModel;
        this.setModel(resPhysicalTreeModel);
    }

    @Override
    public void setModel(TreeModel treeModel) {
        super.setModel(treeModel);
        treeModel.addTreeModelListener(new ResPhysicalJTree$TreeModelHandler(this));
    }

    boolean hasWatershedWq() {
        RssRmiWorkspace rssRmiWorkspace = (RssRmiWorkspace)ClientApp.Workspace().getChildWorkspace("rss");
        RssAdvancedOptions rssAdvancedOptions = null;
        try {
            rssAdvancedOptions = rssRmiWorkspace.getRssAdvancedOptions();
        }
        catch (RemoteException remoteException) {
            System.out.println("resetWorkspace:error getting ResSim Options " + String.valueOf(remoteException));
        }
        if (rssAdvancedOptions != null) {
            boolean bl = rssAdvancedOptions.hasWaterQuality();
            return bl;
        }
        return false;
    }

    protected void displayPopup(MouseEvent mouseEvent) {
        if (mouseEvent == null) {
            return;
        }
        Object object = this.getSelectionPath();
        if ((object = ((TreePath)object).getLastPathComponent()) == null) {
            return;
        }
        if ((object = this.getPopupMenu(object)) == null) {
            return;
        }
        ((JPopupMenu)object).show(this, mouseEvent.getX(), mouseEvent.getY());
    }

    JPopupMenu getPopupMenu(Object object) {
        JPopupMenu jPopupMenu = null;
        if (this._resPhysicalModel.getRoot() == object) {
            jPopupMenu = null;
        } else if (object instanceof ReservoirDamElementTreeNode) {
            if (this._reservoirDamPopup == null) {
                this.buildReservoirDamPopupMenu();
            }
            jPopupMenu = this._reservoirDamPopup;
        } else if (object instanceof PumpTreeNode) {
            if (this._pumpPopup == null) {
                this.buildPumpPopupMenu();
            }
            jPopupMenu = this._pumpPopup;
        } else if (object instanceof OutletElementTreeNode || object instanceof ReversiblePumpTreeNode || object instanceof PowerPlantTreeNode) {
            if (this._outletPopup == null) {
                this.buildOutletPopupMenu(object);
            }
            jPopupMenu = this._outletPopup;
        } else if (object instanceof OutletGroupElementTreeNode) {
            if (this._outletGroupPopup == null) {
                this.buildOutletGroupPopupMenu();
            }
            jPopupMenu = this._outletGroupPopup;
        } else if (object instanceof DivertedOutletTreeNode) {
            if (this._divertedOutletPopup == null) {
                this.buildDivertedOutletPopupMenu();
            }
            jPopupMenu = this._divertedOutletPopup;
        } else if (object instanceof PoolElementTreeNode) {
            if (this._poolPopup == null) {
                this.buildPoolPopupMenu();
            }
            jPopupMenu = this._poolPopup;
        } else if (object instanceof RoutingTreeNode) {
            jPopupMenu = null;
        } else if (object instanceof FunctionTreeNode) {
            if (this._functionPopup == null) {
                this.buildFunctionPopupMenu();
            }
            jPopupMenu = this._functionPopup;
        } else if (object instanceof ElementTreeNode) {
            if (this._elementPopup == null) {
                this.buildElementPopupMenu();
            }
            jPopupMenu = this._elementPopup;
        } else if (object instanceof WaterControlDeviceTreeNode) {
            if (this._waterControlDevicePopup == null) {
                this.buildWaterControlPopupMenu();
            }
            jPopupMenu = this._waterControlDevicePopup;
        }
        return jPopupMenu;
    }

    Vector getMenusFor(RSimTreeNode rSimTreeNode) {
        if (rSimTreeNode == null) {
            return null;
        }
        Vector vector = (Vector)this._menuCache.get(rSimTreeNode.getClass());
        if (vector != null) {
            return vector;
        }
        if (this._resPhysicalModel.getRoot() == rSimTreeNode) {
            return null;
        }
        if (rSimTreeNode instanceof ReservoirDamElementTreeNode) {
            vector = this.getReservoirDamMenuItems();
        } else if (rSimTreeNode instanceof PumpTreeNode) {
            vector = this.getPumpMenuItems();
        } else if (rSimTreeNode instanceof OutletElementTreeNode) {
            vector = this.getOutletMenuItems(rSimTreeNode);
        } else if (rSimTreeNode instanceof OutletGroupElementTreeNode) {
            vector = this.getOutletGroupMenuItems();
        } else if (rSimTreeNode instanceof DivertedOutletTreeNode) {
            vector = this.getDivertedOutletMenuItems();
        } else if (rSimTreeNode instanceof PoolElementTreeNode) {
            vector = this.getPoolMenuItems();
        } else if (rSimTreeNode instanceof RoutingTreeNode) {
            vector = null;
        } else if (rSimTreeNode instanceof FunctionTreeNode) {
            vector = this.getFunctionMenuItems();
        } else if (rSimTreeNode instanceof ElementTreeNode) {
            vector = this.getElementMenuItems();
        } else if (rSimTreeNode instanceof WaterControlDeviceTreeNode) {
            vector = this.getWaterControlDeviceMenuItems();
        }
        this._menuCache.put(rSimTreeNode.getClass(), vector);
        return vector;
    }

    void buildReservoirDamPopupMenu() {
        this._reservoirDamPopup = new JPopupMenu();
        Vector vector = this.getReservoirDamMenuItems();
        for (int i = 0; i < vector.size(); ++i) {
            this._reservoirDamPopup.add((JComponent)vector.get(i));
        }
    }

    Vector getReservoirDamMenuItems() {
        Vector<Object> vector = new Vector<Object>(5);
        ResTreeCellRenderer resTreeCellRenderer = (ResTreeCellRenderer)this.getCellRenderer();
        Object object = resTreeCellRenderer.getIcon(TailElevTreeNode.class);
        object = new JMenuItem("Add Tailwater Elevation", (Icon)object);
        ((AbstractButton)object).addActionListener((ActionListener)this._listener.add((Object)this, object, "addTailElev"));
        vector.add(object);
        object = resTreeCellRenderer.getIcon(TailElevTreeNode.class);
        object = new JMenuItem("Add Forebay Head Loss", (Icon)object);
        ((AbstractButton)object).addActionListener((ActionListener)this._listener.add((Object)this, object, "addForebayHeadLoss"));
        vector.add(object);
        object = resTreeCellRenderer.getIcon(DamLeakageTreeNode.class);
        object = new JMenuItem("Add Leakage", (Icon)object);
        ((AbstractButton)object).addActionListener((ActionListener)this._listener.add((Object)this, object, "addDamLeakage"));
        vector.add(object);
        object = resTreeCellRenderer.getIcon(OutletElementTreeNode.class);
        object = new JMenuItem("Add Controlled Outlet", (Icon)object);
        ((AbstractButton)object).addActionListener((ActionListener)this._listener.add((Object)this, object, "addControlledOutlet"));
        vector.add(object);
        object = resTreeCellRenderer.getIcon(ElementTreeNode.class);
        object = new JMenuItem("Add Uncontrolled Outlet", (Icon)object);
        ((AbstractButton)object).addActionListener((ActionListener)this._listener.add((Object)this, object, "addSpillway"));
        vector.add(object);
        object = resTreeCellRenderer.getIcon(OutletGroupElementTreeNode.class);
        object = new JMenuItem("Add Outlet Group", (Icon)object);
        ((AbstractButton)object).addActionListener((ActionListener)this._listener.add((Object)this, object, "addOutletGroup"));
        vector.add(object);
        object = resTreeCellRenderer.getIcon(PowerPlantTreeNode.class);
        object = new JMenuItem("Add Power Plant", (Icon)object);
        ((AbstractButton)object).addActionListener((ActionListener)this._listener.add((Object)this, object, "addPowerPlant"));
        vector.add(object);
        object = resTreeCellRenderer.getIcon(PumpTreeNode.class);
        object = new JMenuItem("Add Pump", (Icon)object);
        ((AbstractButton)object).addActionListener((ActionListener)this._listener.add((Object)this, object, "addPump"));
        vector.add(object);
        object = resTreeCellRenderer.getIcon(WaterControlDeviceTreeNode.class);
        this._damAddWQMenuItem = new JMenuItem("Add WQ Control Device", (Icon)object);
        ResPhysicalJTree resPhysicalJTree = this;
        this._damAddWQMenuItem.addActionListener((ActionListener)this._listener.add((Object)resPhysicalJTree, (Object)resPhysicalJTree._damAddWQMenuItem, "addWaterControlDevice"));
        vector.add(this._damAddWQMenuItem);
        vector.add(new JSeparator());
        object = new JMenuItem("Pulse Flow Options");
        ((AbstractButton)object).addActionListener((ActionListener)this._listener.add((Object)this, object, "pulseFlowOptions"));
        vector.add(object);
        vector.add(new JSeparator());
        object = new JMenuItem("Rename");
        ((AbstractButton)object).addActionListener((ActionListener)this._listener.add((Object)this, object, "renameTreeNode"));
        vector.add(object);
        return vector;
    }

    void buildPumpPopupMenu() {
        this._pumpPopup = new JPopupMenu();
        Vector vector = this.getPumpMenuItems();
        for (int i = 0; i < vector.size(); ++i) {
            this._pumpPopup.add((JComponent)vector.get(i));
        }
    }

    void buildOutletPopupMenu(Object object) {
        this._outletPopup = new JPopupMenu();
        object = this.getOutletMenuItems(object);
        for (int i = 0; i < ((Vector)object).size(); ++i) {
            this._outletPopup.add((JComponent)((Vector)object).get(i));
        }
    }

    Vector getPumpMenuItems() {
        Vector<Object> vector = new Vector<Object>(4);
        ResTreeCellRenderer resTreeCellRenderer = (ResTreeCellRenderer)this.getCellRenderer();
        Object object = resTreeCellRenderer.getIcon(TailElevTreeNode.class);
        object = new JMenuItem("Add Tailwater Elevation", (Icon)object);
        ((AbstractButton)object).addActionListener((ActionListener)this._listener.add((Object)this, object, "addTailElev"));
        vector.add(object);
        object = resTreeCellRenderer.getIcon(TailElevTreeNode.class);
        object = new JMenuItem("Add Forebay Head Loss", (Icon)object);
        ((AbstractButton)object).addActionListener((ActionListener)this._listener.add((Object)this, object, "addForebayHeadLoss"));
        vector.add(object);
        vector.add(new JSeparator());
        object = new JMenuItem("Rename");
        ((AbstractButton)object).addActionListener((ActionListener)this._listener.add((Object)this, object, "renameTreeNode"));
        vector.add(object);
        object = new JMenuItem("Delete");
        ((AbstractButton)object).addActionListener((ActionListener)this._listener.add((Object)this, object, "deleteTreeNode"));
        vector.add(object);
        return vector;
    }

    Vector getOutletMenuItems(Object vector) {
        vector = new Vector<Object>(4);
        ResTreeCellRenderer resTreeCellRenderer = (ResTreeCellRenderer)this.getCellRenderer();
        Object object = resTreeCellRenderer.getIcon(TailElevTreeNode.class);
        object = new JMenuItem("Add Tailwater Elevation", (Icon)object);
        ((AbstractButton)object).addActionListener((ActionListener)this._listener.add((Object)this, object, "addTailElev"));
        vector.add(object);
        object = resTreeCellRenderer.getIcon(TailElevTreeNode.class);
        object = new JMenuItem("Add Forebay Head Loss", (Icon)object);
        ((AbstractButton)object).addActionListener((ActionListener)this._listener.add((Object)this, object, "addForebayHeadLoss"));
        vector.add(object);
        object = resTreeCellRenderer.getIcon(WaterControlDeviceTreeNode.class);
        this._outletAddWQMenuItem = new JMenuItem("Add WQ Control Device", (Icon)object);
        ResPhysicalJTree resPhysicalJTree = this;
        this._outletAddWQMenuItem.addActionListener((ActionListener)this._listener.add((Object)resPhysicalJTree, (Object)resPhysicalJTree._outletAddWQMenuItem, "addWaterControlDevice"));
        vector.add(this._outletAddWQMenuItem);
        vector.add(new JSeparator());
        object = new JMenuItem("Rename");
        ((AbstractButton)object).addActionListener((ActionListener)this._listener.add((Object)this, object, "renameTreeNode"));
        vector.add(object);
        object = new JMenuItem("Delete");
        ((AbstractButton)object).addActionListener((ActionListener)this._listener.add((Object)this, object, "deleteTreeNode"));
        vector.add(object);
        return vector;
    }

    void buildOutletGroupPopupMenu() {
        this._outletGroupPopup = new JPopupMenu();
        Vector vector = this.getOutletGroupMenuItems();
        for (int i = 0; i < vector.size(); ++i) {
            this._outletGroupPopup.add((JComponent)vector.get(i));
        }
    }

    Vector getOutletGroupMenuItems() {
        Vector<Object> vector = new Vector<Object>(6);
        ResTreeCellRenderer resTreeCellRenderer = (ResTreeCellRenderer)this.getCellRenderer();
        Object object = resTreeCellRenderer.getIcon(TailElevTreeNode.class);
        object = new JMenuItem("Add Tailwater Elevation", (Icon)object);
        ((AbstractButton)object).addActionListener((ActionListener)this._listener.add((Object)this, object, "addTailElev"));
        vector.add(object);
        object = resTreeCellRenderer.getIcon(TailElevTreeNode.class);
        object = new JMenuItem("Add Forebay Head Loss", (Icon)object);
        ((AbstractButton)object).addActionListener((ActionListener)this._listener.add((Object)this, object, "addForebayHeadLoss"));
        vector.add(object);
        object = resTreeCellRenderer.getIcon(OutletElementTreeNode.class);
        object = new JMenuItem("Add Controlled Outlet", (Icon)object);
        ((AbstractButton)object).addActionListener((ActionListener)this._listener.add((Object)this, object, "addControlledOutlet"));
        vector.add(object);
        object = resTreeCellRenderer.getIcon(ElementTreeNode.class);
        object = new JMenuItem("Add Uncontrolled Outlet", (Icon)object);
        ((AbstractButton)object).addActionListener((ActionListener)this._listener.add((Object)this, object, "addSpillway"));
        vector.add(object);
        object = resTreeCellRenderer.getIcon(OutletGroupElementTreeNode.class);
        object = new JMenuItem("Add Outlet Group", (Icon)object);
        ((AbstractButton)object).addActionListener((ActionListener)this._listener.add((Object)this, object, "addOutletGroup"));
        vector.add(object);
        object = resTreeCellRenderer.getIcon(PowerPlantTreeNode.class);
        object = new JMenuItem("Add Power Plant", (Icon)object);
        ((AbstractButton)object).addActionListener((ActionListener)this._listener.add((Object)this, object, "addPowerPlant"));
        vector.add(object);
        object = resTreeCellRenderer.getIcon(PumpTreeNode.class);
        object = new JMenuItem("Add Pump", (Icon)object);
        ((AbstractButton)object).addActionListener((ActionListener)this._listener.add((Object)this, object, "addPump"));
        vector.add(object);
        object = resTreeCellRenderer.getIcon(WaterControlDeviceTreeNode.class);
        this._outletGroupAddWQMenuItem = new JMenuItem("Add WQ Control Device", (Icon)object);
        ResPhysicalJTree resPhysicalJTree = this;
        this._outletGroupAddWQMenuItem.addActionListener((ActionListener)this._listener.add((Object)resPhysicalJTree, (Object)resPhysicalJTree._outletGroupAddWQMenuItem, "addWaterControlDevice"));
        vector.add(this._outletGroupAddWQMenuItem);
        vector.add(new JSeparator());
        object = new JMenuItem("Rename");
        ((AbstractButton)object).addActionListener((ActionListener)this._listener.add((Object)this, object, "renameTreeNode"));
        vector.add(object);
        object = new JMenuItem("Delete");
        ((AbstractButton)object).addActionListener((ActionListener)this._listener.add((Object)this, object, "deleteTreeNode"));
        vector.add(object);
        return vector;
    }

    void buildDivertedOutletPopupMenu() {
        this._divertedOutletPopup = new JPopupMenu();
        Vector vector = this.getDivertedOutletMenuItems();
        for (int i = 0; i < vector.size(); ++i) {
            this._divertedOutletPopup.add((JComponent)vector.get(i));
        }
    }

    Vector getDivertedOutletMenuItems() {
        Vector<Object> vector = new Vector<Object>(6);
        ResTreeCellRenderer resTreeCellRenderer = (ResTreeCellRenderer)this.getCellRenderer();
        Object object = resTreeCellRenderer.getIcon(TailElevTreeNode.class);
        object = new JMenuItem("Add Tailwater Elevation", (Icon)object);
        ((AbstractButton)object).addActionListener((ActionListener)this._listener.add((Object)this, object, "addTailElev"));
        vector.add(object);
        object = resTreeCellRenderer.getIcon(TailElevTreeNode.class);
        object = new JMenuItem("Add Forebay Head Loss", (Icon)object);
        ((AbstractButton)object).addActionListener((ActionListener)this._listener.add((Object)this, object, "addForebayHeadLoss"));
        vector.add(object);
        object = resTreeCellRenderer.getIcon(OutletElementTreeNode.class);
        object = new JMenuItem("Add Controlled Outlet", (Icon)object);
        ((AbstractButton)object).addActionListener((ActionListener)this._listener.add((Object)this, object, "addControlledOutlet"));
        vector.add(object);
        object = resTreeCellRenderer.getIcon(ElementTreeNode.class);
        object = new JMenuItem("Add Uncontrolled Outlet", (Icon)object);
        ((AbstractButton)object).addActionListener((ActionListener)this._listener.add((Object)this, object, "addSpillway"));
        vector.add(object);
        object = resTreeCellRenderer.getIcon(OutletGroupElementTreeNode.class);
        object = new JMenuItem("Add Outlet Group", (Icon)object);
        ((AbstractButton)object).addActionListener((ActionListener)this._listener.add((Object)this, object, "addOutletGroup"));
        vector.add(object);
        object = resTreeCellRenderer.getIcon(PowerPlantTreeNode.class);
        object = new JMenuItem("Add Power Plant", (Icon)object);
        ((AbstractButton)object).addActionListener((ActionListener)this._listener.add((Object)this, object, "addPowerPlant"));
        vector.add(object);
        object = resTreeCellRenderer.getIcon(PumpTreeNode.class);
        object = new JMenuItem("Add Pump", (Icon)object);
        ((AbstractButton)object).addActionListener((ActionListener)this._listener.add((Object)this, object, "addPump"));
        vector.add(object);
        object = resTreeCellRenderer.getIcon(WaterControlDeviceTreeNode.class);
        this._divertedOutletAddWQMenuItem = new JMenuItem("Add WQ Control Device", (Icon)object);
        ResPhysicalJTree resPhysicalJTree = this;
        this._divertedOutletAddWQMenuItem.addActionListener((ActionListener)this._listener.add((Object)resPhysicalJTree, (Object)resPhysicalJTree._divertedOutletAddWQMenuItem, "addWaterControlDevice"));
        vector.add(this._divertedOutletAddWQMenuItem);
        vector.add(new JSeparator());
        object = new JMenuItem("Rename");
        ((AbstractButton)object).addActionListener((ActionListener)this._listener.add((Object)this, object, "renameTreeNode"));
        vector.add(object);
        object = new JMenuItem("Delete");
        ((AbstractButton)object).addActionListener((ActionListener)this._listener.add((Object)this, object, "deleteTreeNode"));
        vector.add(object);
        return vector;
    }

    void buildPoolPopupMenu() {
        this._poolPopup = new JPopupMenu();
        Vector vector = this.getPoolMenuItems();
        for (int i = 0; i < vector.size(); ++i) {
            this._poolPopup.add((JComponent)vector.get(i));
        }
    }

    Vector getPoolMenuItems() {
        Vector<Object> vector = new Vector<Object>(2);
        ResTreeCellRenderer resTreeCellRenderer = (ResTreeCellRenderer)this.getCellRenderer();
        Object object = resTreeCellRenderer.getIcon(PoolEvapTreeNode.class);
        object = new JMenuItem("Add Pool Evaporation", (Icon)object);
        ((AbstractButton)object).addActionListener((ActionListener)this._listener.add((Object)this, object, "addPoolEvap"));
        vector.add(object);
        object = resTreeCellRenderer.getIcon(PoolSeepageTreeNode.class);
        object = new JMenuItem("Add Pool Seepage", (Icon)object);
        ((AbstractButton)object).addActionListener((ActionListener)this._listener.add((Object)this, object, "addPoolSeep"));
        vector.add(object);
        return vector;
    }

    void buildElementPopupMenu() {
        this._elementPopup = new JPopupMenu();
        Vector vector = this.getElementMenuItems();
        for (int i = 0; i < vector.size(); ++i) {
            this._elementPopup.add((JComponent)vector.get(i));
        }
    }

    void buildWaterControlPopupMenu() {
        this._waterControlDevicePopup = new JPopupMenu();
        Vector vector = this.getWaterControlDeviceMenuItems();
        for (int i = 0; i < vector.size(); ++i) {
            this._waterControlDevicePopup.add((JComponent)vector.get(i));
        }
    }

    Vector getWaterControlDeviceMenuItems() {
        Vector<JMenuItem> vector = new Vector<JMenuItem>(2);
        JMenuItem jMenuItem = new JMenuItem("Rename");
        jMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)jMenuItem, "renameWaterControlDeviceNode"));
        vector.add(jMenuItem);
        jMenuItem = new JMenuItem("Delete");
        jMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)jMenuItem, "deleteTreeNode"));
        vector.add(jMenuItem);
        return vector;
    }

    Vector getElementMenuItems() {
        Vector<JMenuItem> vector = new Vector<JMenuItem>(2);
        JMenuItem jMenuItem = new JMenuItem("Rename");
        jMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)jMenuItem, "renameTreeNode"));
        vector.add(jMenuItem);
        jMenuItem = new JMenuItem("Delete");
        jMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)jMenuItem, "deleteTreeNode"));
        vector.add(jMenuItem);
        return vector;
    }

    void buildFunctionPopupMenu() {
        this._functionPopup = new JPopupMenu();
        Vector vector = this.getFunctionMenuItems();
        for (int i = 0; i < vector.size(); ++i) {
            this._functionPopup.add((JComponent)vector.get(i));
        }
    }

    Vector getFunctionMenuItems() {
        Vector<JMenuItem> vector = new Vector<JMenuItem>(1);
        JMenuItem jMenuItem = new JMenuItem("Remove");
        jMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)jMenuItem, "deleteTreeNode"));
        vector.add(jMenuItem);
        return vector;
    }

    public String getFullNameForPath(TreePath treePath) {
        Object object = "";
        int n = treePath.getPathCount();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                object = (String)object + "-";
                object = (String)object + treePath.getPathComponent(i).toString();
                continue;
            }
            object = treePath.getPathComponent(i).toString();
        }
        return object;
    }

    public String getDescriptionForPath(TreePath object) {
        String string = "  ";
        ((TreePath)object).getPathCount();
        object = ((TreePath)object).getLastPathComponent();
        if (object instanceof ElementTreeNode) {
            object = (ElementTreeNode)object;
            object = ((RSimTreeNode)object).d();
            string = object.getDescription();
        }
        return string;
    }

    public void renameTreeNode() {
        if (this._resPhysicalModel == null) {
            return;
        }
        TreePath treePath = this.getSelectionPath();
        RSimTreeNode rSimTreeNode = (RSimTreeNode)treePath.getLastPathComponent();
        NameDialog nameDialog = new NameDialog((Frame)ClientApp.frame(), true);
        nameDialog.setNameFieldDocument((Document)new DssPathnamePartDocument());
        nameDialog.setName(rSimTreeNode.toString());
        nameDialog.setDescription(rSimTreeNode.d() != null ? rSimTreeNode.d().getDescription() : "");
        nameDialog.setTitle("Rename Reservoir Component");
        nameDialog.setVisible(true);
        if (nameDialog.isCanceled()) {
            return;
        }
        Object object = nameDialog.getName();
        ReservoirElement reservoirElement = (ReservoirElement)((RSimTreeNode)((ElementTreeNode)this._resPhysicalModel.getRoot())).d();
        object = reservoirElement.getElementByName((String)object);
        if (object != null && object != rSimTreeNode.d()) {
            int n = JOptionPane.showConfirmDialog(this, "The component name must be unique.\nPlease enter a new name.", "", 2, 1);
            if (n == 0) {
                this.renameTreeNode();
            }
            return;
        }
        this._resPhysicalModel.a(treePath, nameDialog.getName(), nameDialog.getDescription());
        RMAUtil.setParentModified((Component)this);
        this._parentFrame.cmdApply_Action();
    }

    public void renameWaterControlDeviceNode() {
        Object object2;
        if (this._resPhysicalModel == null) {
            return;
        }
        TreePath treePath = this.getSelectionPath();
        Object object3 = (RSimTreeNode)treePath.getLastPathComponent();
        ClientApp.app();
        NameDialog nameDialog = new NameDialog((Frame)ClientApp.frame(), true);
        nameDialog.setNameFieldDocument((Document)new DssPathnamePartDocument());
        nameDialog.setName(((RSimTreeNode)object3).toString());
        nameDialog.setDescription(((RSimTreeNode)object3).d() != null ? ((RSimTreeNode)object3).d().getDescription() : "");
        nameDialog.setTitle("Rename Reservoir Component");
        nameDialog.setVisible(true);
        if (nameDialog.isCanceled()) {
            return;
        }
        object3 = nameDialog.getName();
        Object object4 = (ReservoirElement)((RSimTreeNode)((ElementTreeNode)this._resPhysicalModel.getRoot())).d();
        object4 = ((Element)object4).getElementVector();
        Object object5 = new ArrayList<Element>();
        Object object6 = object4.iterator();
        while (object6.hasNext()) {
            object2 = object6.next();
            object5.add((Element)object2);
        }
        object6 = new LinkedList();
        object2 = object4;
        while (!object2.isEmpty()) {
            object4 = object2.stream().map(object -> ((Element)object).getElementVector()).flatMap(Collection::stream).filter(arg_0 -> ResPhysicalJTree.a((List)object6, arg_0)).collect(Collectors.toList());
            object6.addAll(object2);
            object2 = object4;
        }
        boolean bl = false;
        object5 = object6.iterator();
        while (object5.hasNext()) {
            object6 = object5.next();
            if (!((Element)(object6 = (Element)object6)).hasWaterControlDevice() || ((Element)object6).getWaterControlDevice() == null || !((Element)object6).getWaterControlDevice().getName().equalsIgnoreCase((String)object3)) continue;
            bl = true;
            break;
        }
        if (bl) {
            int n = JOptionPane.showConfirmDialog(this, "The water control device name must be unique.\nPlease enter a new name.", "", 2, 1);
            if (n == 0) {
                this.renameWaterControlDeviceNode();
            }
            return;
        }
        this._resPhysicalModel.a(treePath, nameDialog.getName(), nameDialog.getDescription());
        RMAUtil.setParentModified((Component)this);
        this._parentFrame.cmdApply_Action();
    }

    public void deleteTreeNode() {
        int n;
        int n2;
        Object object;
        if (this._resPhysicalModel == null) {
            return;
        }
        Object object2 = this.getSelectionPath();
        String string = this.getFullNameForPath((TreePath)object2);
        Object object3 = ((TreePath)object2).getLastPathComponent();
        String string2 = "Delete Reservoir Component " + string + "?";
        JOperationsPanel jOperationsPanel = this._parentFrame.getOperationsPanel();
        ArrayList<OpRule> arrayList = new ArrayList<OpRule>();
        if (object3 instanceof OutletElementTreeNode || object3 instanceof DivertedOutletTreeNode || object3 instanceof OutletGroupElementTreeNode || object3 instanceof PumpTreeNode) {
            object = (ElementTreeNode)object3;
            object3 = ((RSimTreeNode)object).d();
            object3.getSystem();
            ReservoirElement reservoirElement = this._resPhysicalModel.a();
            object3.getChildElementCount();
            this.getRulesForElement(reservoirElement, (Element)object3, arrayList);
            object = new StringBuilder();
            n2 = arrayList.size();
            if (n2 > 0) {
                System.out.println("deleteTreeNode:rules=" + String.valueOf(null));
                for (int i = 0; i < n2; ++i) {
                    object3 = (OpRule)arrayList.get(i);
                    ((StringBuilder)object).append("<br>");
                    ((StringBuilder)object).append(object3.getName());
                }
                ((StringBuilder)object).append("</html>");
            }
            if (((StringBuilder)object).length() > 0) {
                string2 = "<html>Delete Reservoir Component " + string + "?<br><br>The following rule" + (n2 > 1 ? "s" : "") + " will also be deleted:" + String.valueOf(object);
            }
        }
        if ((n = JOptionPane.showConfirmDialog(SwingUtilities.windowForComponent(this), string2, "Confirm Delete", 0, 3)) == 0) {
            RMAUtil.setParentModified((Component)this);
            object = this._resPhysicalModel.b((TreePath)object2);
            if (object != null) {
                for (n2 = 0; n2 < arrayList.size(); ++n2) {
                    object3 = (OpRule)arrayList.get(n2);
                    object2 = object3.getController().getElementOp();
                    jOperationsPanel.mDeleteRule((ElementOp)object2, (OpRule)object3, n2 == arrayList.size() - 1);
                }
            }
            object3 = new TreePath[]{object};
            if (object != null) {
                this.setSelectionPaths((TreePath[])object3);
            }
            if (this._parentFrame != null) {
                this._parentFrame.saveForm();
            }
        }
    }

    private void getRulesForElement(ReservoirElement reservoirElement, Element element, List<OpRule> list) {
        Object object = this._parentFrame.getOperationsPanel();
        object = ((JOperationsPanel)object).areControlsCreated() ? ((JOperationsPanel)object).findRulesFor(element) : reservoirElement.findRulesFor(element);
        list.addAll((Collection<OpRule>)object);
        int n = element.getChildElementCount();
        for (int i = 0; i < n; ++i) {
            this.getRulesForElement(reservoirElement, element.getChildElementAt(i), list);
        }
    }

    public void addTailElev() {
        if (this._resPhysicalModel == null) {
            return;
        }
        TreePath treePath = this._resPhysicalModel.a(this.getSelectionPath(), 7);
        if (treePath != null) {
            this.selectAndShowPath(treePath);
        }
    }

    public void addWaterControlDevice() {
        if (this._resPhysicalModel == null) {
            return;
        }
        TreePath treePath = this._resPhysicalModel.a(this.getSelectionPath());
        if (treePath != null) {
            this.selectAndShowPath(treePath);
        }
    }

    public void addForebayHeadLoss() {
        if (this._resPhysicalModel == null) {
            return;
        }
        TreePath treePath = this._resPhysicalModel.a(this.getSelectionPath(), 10);
        if (treePath != null) {
            this.selectAndShowPath(treePath);
        }
    }

    public void addDamLeakage() {
        if (this._resPhysicalModel == null) {
            return;
        }
        TreePath treePath = this._resPhysicalModel.a(this.getSelectionPath(), 5);
        if (treePath != null) {
            this.selectAndShowPath(treePath);
        }
    }

    public void addControlledOutlet() {
        if (this._resPhysicalModel == null) {
            return;
        }
        TreePath treePath = this._resPhysicalModel.a(this.getSelectionPath(), 0);
        if (treePath != null) {
            this.selectAndShowPath(treePath);
        }
        this._parentFrame.cmdApply_Action();
    }

    public void addSpillway() {
        if (this._resPhysicalModel == null) {
            return;
        }
        TreePath treePath = this._resPhysicalModel.a(this.getSelectionPath(), 1);
        if (treePath != null) {
            this.selectAndShowPath(treePath);
        }
    }

    public void duplicateOutlet() {
        MoverDialog moverDialog = (MoverDialog)this._resPhysicalModel.getRoot();
        if (moverDialog == null) {
            return;
        }
        Object object = new Vector<Object[]>();
        if (moverDialog instanceof OutletElementTreeNode) {
            object.add(moverDialog);
        }
        this.duplicateOutlet((List)object, (TreeNode)moverDialog);
        Window window = SwingUtilities.windowForComponent(this);
        moverDialog = window instanceof JFrame ? new MoverDialog((Frame)window, true, "Select Outlets to duplicate") : new MoverDialog((JDialog)window, true, "Select Outlets to duplicate");
        moverDialog.setLocationRelativeTo((Component)window);
        moverDialog.setData(object, new Vector());
        moverDialog.setVisible(true);
        moverDialog = moverDialog.getSelectedObjects();
        if (moverDialog == null || ((Object[])moverDialog).length == 0) {
            return;
        }
        object = this.getSelectionPath();
        object = (ElementTreeNode)((TreePath)object).getLastPathComponent();
        for (int i = 0; i < ((Object[])moverDialog).length; ++i) {
            Object object2 = (ElementTreeNode)moverDialog[i];
            object2 = ((RSimTreeNode)object2).d();
            Element element = ((Element)object2).getSystem().newElement(false);
            int n = element.getIndex();
            element.copyInto((Element)object2);
            element.setIndex(n);
            object2 = element.getName();
            n = ((String)object2).indexOf(" Copy");
            if (n >= 0) {
                object2 = ((String)object2).substring(0, n);
            }
            String string = (String)object2 + " Copy";
            int n2 = 1;
            while (true) {
                Element element2;
                if ((element2 = ((RSimTreeNode)object).d().findElement(string)) == null) break;
                string = (String)object2 + " Copy " + n2++;
            }
            element.setName(string);
            element.setParentElement(((RSimTreeNode)object).d());
            ((RSimTreeNode)object).d().addChildElement(element);
        }
        ((ElementTreeNode)object).b();
        this._resPhysicalModel.a((TreeNode)object);
        this._parentFrame.cmdApply_Action();
    }

    private void duplicateOutlet(List list, TreeNode treeNode) {
        if (list == null || treeNode == null) {
            return;
        }
        for (int i = 0; i < treeNode.getChildCount(); ++i) {
            if (!(treeNode.getChildAt(i) instanceof ElementTreeNode)) continue;
            ElementTreeNode elementTreeNode = (ElementTreeNode)treeNode.getChildAt(i);
            if (elementTreeNode instanceof OutletElementTreeNode || ((RSimTreeNode)elementTreeNode).d().getFunction() instanceof Spillway) {
                list.add(elementTreeNode);
            }
            this.duplicateOutlet(list, elementTreeNode);
        }
    }

    public void addOutletGroup() {
        if (this._resPhysicalModel == null) {
            return;
        }
        TreePath treePath = this._resPhysicalModel.a(this.getSelectionPath(), 2);
        if (treePath != null) {
            this.selectAndShowPath(treePath);
        }
    }

    public void addPoolEvap() {
        if (this._resPhysicalModel == null) {
            return;
        }
        TreePath treePath = this._resPhysicalModel.a(this.getSelectionPath(), 3);
        if (treePath != null) {
            this.selectAndShowPath(treePath);
        }
    }

    public void addPoolSeep() {
        if (this._resPhysicalModel == null) {
            return;
        }
        TreePath treePath = this._resPhysicalModel.a(this.getSelectionPath(), 4);
        if (treePath != null) {
            this.selectAndShowPath(treePath);
        }
    }

    public void addPowerPlant() {
        if (this._resPhysicalModel == null) {
            return;
        }
        TreePath treePath = this._resPhysicalModel.a(this.getSelectionPath(), 6);
        if (treePath != null) {
            this.selectAndShowPath(treePath);
        }
        this._parentFrame.cmdApply_Action();
    }

    public void addPump() {
        if (this._resPhysicalModel == null) {
            return;
        }
        TreePath treePath = this._resPhysicalModel.a(this.getSelectionPath(), 8);
        if (treePath != null) {
            this.selectAndShowPath(treePath);
        }
        this._parentFrame.cmdApply_Action();
    }

    public void addReversiblePump() {
        if (this._resPhysicalModel == null) {
            return;
        }
        TreePath treePath = this._resPhysicalModel.a(this.getSelectionPath(), 9);
        if (treePath != null) {
            this.selectAndShowPath(treePath);
        }
        this._parentFrame.cmdApply_Action();
    }

    public void pulseFlowOptions() {
        Vector vector = this._parentFrame.getPulseRoutingOptions();
        ParamDouble paramDouble = this._parentFrame.getDefaultPulseFlow();
        PulseRoutingOptionsDialog pulseRoutingOptionsDialog = new PulseRoutingOptionsDialog((Dialog)((Object)this._parentFrame), true);
        pulseRoutingOptionsDialog.fillForm(vector, paramDouble);
        pulseRoutingOptionsDialog.setVisible(true);
        if (pulseRoutingOptionsDialog.isCanceled()) {
            return;
        }
        if (pulseRoutingOptionsDialog.isModified()) {
            this._parentFrame.setDefaultPulseFlow(pulseRoutingOptionsDialog.getDefaultPulseFlow());
            this._parentFrame.setPulseRoutingOptions(pulseRoutingOptionsDialog.getDataRecords());
            this._parentFrame.setModified(true);
        }
    }

    public void expandAllTreeNodes() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.expandRow(i);
        }
    }

    public void selectAndShowPath(TreePath treePath) {
        TreePath[] treePathArray = new TreePath[1];
        TreePath[] treePathArray2 = treePathArray;
        treePathArray[0] = treePath;
        this.expandPath(treePath);
        this.setSelectionPaths(treePathArray2);
        RMAUtil.setParentModified((Component)this);
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        RSimTreeNode rSimTreeNode;
        Object object = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (object == null) {
            return null;
        }
        object = ((TreePath)object).getLastPathComponent();
        Element element = null;
        if (mouseEvent.isControlDown() && mouseEvent.isAltDown() && mouseEvent.isShiftDown()) {
            Object object2;
            if (object instanceof RSimTreeNode) {
                object2 = (RSimTreeNode)object;
                element = ((RSimTreeNode)object2).d();
            }
            object2 = "<html>x=" + mouseEvent.getX() + " y=" + mouseEvent.getY() + "<br>Node:" + object.getClass().getName();
            if (element != null) {
                object2 = ((String)object2).concat("<br>Element:" + element.getClass().getName());
            }
            object2 = ((String)object2).concat("</html>");
            return object2;
        }
        if (object instanceof RSimTreeNode && (element = (rSimTreeNode = (RSimTreeNode)object).d()) instanceof NamedType) {
            return ((NamedType)element).getDescription();
        }
        return null;
    }

    private static /* synthetic */ boolean a(List list, Object object) {
        return !list.contains(object);
    }
}

