/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.clientapp.client.ClientApp;
import hec.clientapp.client.ClientWorkspace;
import hec.rss.RssRmiWorkspace;
import hec.rss.server.RssAdvancedOptions;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.Serializable;
import java.rmi.RemoteException;
import javax.swing.JOptionPane;
import rma.swing.DefaultJPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJCheckBox;

public class ResSimAdvancedOptionsPanel
extends DefaultJPanel {
    private RmaJCheckBox _stateVarJavaClassCheckbox;
    private RmaJCheckBox _scriptedRulesJavaClassCheckbox;
    private RssAdvancedOptions _opts = null;

    public ResSimAdvancedOptionsPanel() {
        this.buildControls();
    }

    protected void buildControls() {
        this.setLayout(new GridBagLayout());
        this._stateVarJavaClassCheckbox = new RmaJCheckBox("Allow State Variables to be defined as Java Classes");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)0, (int)5, (int)5);
        ResSimAdvancedOptionsPanel resSimAdvancedOptionsPanel = this;
        resSimAdvancedOptionsPanel.add((Component)resSimAdvancedOptionsPanel._stateVarJavaClassCheckbox, gridBagConstraints);
        this._scriptedRulesJavaClassCheckbox = new RmaJCheckBox("Allow Reservoir Operation Scripted Rules to be defined as Java Classes");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)0, (int)5, (int)5);
        gridBagConstraints.weighty = 0.0;
        ResSimAdvancedOptionsPanel resSimAdvancedOptionsPanel2 = this;
        resSimAdvancedOptionsPanel2.add((Component)resSimAdvancedOptionsPanel2._scriptedRulesJavaClassCheckbox, gridBagConstraints);
    }

    private RssRmiWorkspace getRssRmiWorkspace() {
        ClientWorkspace clientWorkspace = ClientApp.Workspace();
        if (clientWorkspace == null) {
            return null;
        }
        return (RssRmiWorkspace)clientWorkspace.getChildWorkspace("rss");
    }

    public String getName() {
        return "Advanced";
    }

    public void refresh() {
    }

    public void fillPanel() {
        RssRmiWorkspace rssRmiWorkspace = this.getRssRmiWorkspace();
        if (rssRmiWorkspace == null) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
        try {
            this._opts = rssRmiWorkspace.getRssAdvancedOptions();
        }
        catch (RemoteException remoteException) {
            StringBuffer stringBuffer = new StringBuffer("An error occured while trying to get the ResSim Advanced Options from the server.\n");
            stringBuffer.append(remoteException.getMessage());
            JOptionPane.showMessageDialog((Component)((Object)this), stringBuffer.toString(), "Error!", 0);
            return;
        }
        this._stateVarJavaClassCheckbox.setSelected(this._opts.allowStateVarsAsJavaClasses());
        this._scriptedRulesJavaClassCheckbox.setSelected(this._opts.allowScriptedRulesAsJavaClasses());
    }

    public boolean savePanel() {
        Serializable serializable = this._opts;
        if (serializable == null) {
            serializable = new RssAdvancedOptions();
        }
        ((RssAdvancedOptions)serializable).setAllowStateVarsAsJavaClasses(this._stateVarJavaClassCheckbox.isSelected());
        ((RssAdvancedOptions)serializable).setAllowScriptedRulesAsJavaClasses(this._scriptedRulesJavaClassCheckbox.isSelected());
        try {
            RssRmiWorkspace rssRmiWorkspace = this.getRssRmiWorkspace();
            if (rssRmiWorkspace != null) {
                rssRmiWorkspace.setRssAdvancedOptions((RssAdvancedOptions)serializable);
                if (this.isModified()) {
                    ClientApp.Workspace().setModified(true);
                }
            }
            this.setModified(false);
        }
        catch (RemoteException remoteException) {
            serializable = new StringBuffer("An error occured while trying to save the ResSim Advanced Options to the server.\n");
            ((StringBuffer)serializable).append(remoteException.getMessage());
            JOptionPane.showMessageDialog((Component)((Object)this), ((StringBuffer)serializable).toString(), "Error!", 0);
        }
        return true;
    }
}

