/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.clientapp.client.ClientApp;
import hec.clientapp.client.ClientWorkspace;
import hec.rss.RssRmiWorkspace;
import hec.rss.client.ResSimComputeOptionsPanel$1;
import hec.rss.client.ResSimComputeOptionsPanel$2;
import hec.rss.server.RssComputeOptions;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.text.DecimalFormat;
import java.util.Properties;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import rma.swing.DefaultJPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJButton;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJIntegerField;
import rma.swing.RmaJLabel;

public class ResSimComputeOptionsPanel
extends DefaultJPanel {
    private RmaJIntegerField _minPassesText;
    private RmaJDecimalField _storErrFacText;
    private RmaJIntegerField _substepsText;
    private RmaJButton _resetButton;
    private RmaJButton _rocEditButton;
    private RmaJCheckBox _saveGCReleaseCheck;
    private Properties _props;
    private RmaJCheckBox _computeTestingCheck;
    private RmaJCheckBox _computeEngineDebugCheck;
    private RmaJCheckBox _noSyHydroRoutingSteps;
    private RmaJCheckBox _invalidGvIsErrorCheck;

    public ResSimComputeOptionsPanel() {
        this.buildControls();
    }

    protected void buildControls() {
        this.setLayout(new GridBagLayout());
        Object object = new RmaJLabel("Minimum Number of Compute Passes");
        object.setToolTipText("Increasing the number of compute passes may provide better results with complex downstream operation or large diversions at the expense of additional compute time.");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)15, (int)5, (int)0, (int)5);
        this.add((Component)object, gridBagConstraints);
        this._minPassesText = new RmaJIntegerField();
        this._minPassesText.setMinValue(2);
        Dimension dimension = this._minPassesText.getPreferredSize();
        this._minPassesText.getPreferredSize().width = 150;
        this._minPassesText.setPreferredSize(dimension);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)15, (int)5, (int)0, (int)5);
        gridBagConstraints.weightx = 1.0;
        ResSimComputeOptionsPanel resSimComputeOptionsPanel = this;
        resSimComputeOptionsPanel.add((Component)resSimComputeOptionsPanel._minPassesText, gridBagConstraints);
        object = new RmaJLabel("Error Tolerance Factor for Storage Calculation");
        object.setToolTipText("Recommended Range 0.001 to 0.00000001, reservoirs with outlet capacity that varies rapidly with elevation may require smaller tolerance.");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.add((Component)object, gridBagConstraints);
        this._storErrFacText = new RmaJDecimalField();
        this._storErrFacText.setMinValue(1.0E-15);
        object = this._storErrFacText.getDecimalFormatter();
        ((DecimalFormat)object).setMaximumFractionDigits(15);
        this._storErrFacText.setDecimalFormat((DecimalFormat)object);
        this._storErrFacText.setPreferredSize(dimension);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        gridBagConstraints.weightx = 1.0;
        ResSimComputeOptionsPanel resSimComputeOptionsPanel2 = this;
        resSimComputeOptionsPanel2.add((Component)resSimComputeOptionsPanel2._storErrFacText, gridBagConstraints);
        object = new RmaJLabel("Max sub-steps for Storage Calculation");
        object.setToolTipText("Additional sub-steps may be required when small error tolerance is used.");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.add((Component)object, gridBagConstraints);
        this._substepsText = new RmaJIntegerField();
        this._substepsText.setMinValue(1);
        this._substepsText.setPreferredSize(dimension);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        gridBagConstraints.weightx = 1.0;
        ResSimComputeOptionsPanel resSimComputeOptionsPanel3 = this;
        resSimComputeOptionsPanel3.add((Component)resSimComputeOptionsPanel3._substepsText, gridBagConstraints);
        this._saveGCReleaseCheck = new RmaJCheckBox("Save Release to Guide Curve to DSS");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS0505;
        ResSimComputeOptionsPanel resSimComputeOptionsPanel4 = this;
        resSimComputeOptionsPanel4.add((Component)resSimComputeOptionsPanel4._saveGCReleaseCheck, gridBagConstraints);
        this._computeTestingCheck = new RmaJCheckBox("Enable Compute Testing Options");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS0505;
        if (Boolean.getBoolean("computeTesting")) {
            ResSimComputeOptionsPanel resSimComputeOptionsPanel5 = this;
            resSimComputeOptionsPanel5.add((Component)resSimComputeOptionsPanel5._computeTestingCheck, gridBagConstraints);
        }
        this._computeEngineDebugCheck = new RmaJCheckBox("Enable Compute Engine Debug Output");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS0505;
        if (Boolean.getBoolean("ResSim.HasComputeEngineDebug")) {
            ResSimComputeOptionsPanel resSimComputeOptionsPanel6 = this;
            resSimComputeOptionsPanel6.add((Component)resSimComputeOptionsPanel6._computeEngineDebugCheck, gridBagConstraints);
        }
        this._noSyHydroRoutingSteps = new RmaJCheckBox("Do Not Include System Hydropower in Requirement for Number of Routing Steps");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS0505;
        ResSimComputeOptionsPanel resSimComputeOptionsPanel7 = this;
        resSimComputeOptionsPanel7.add((Component)resSimComputeOptionsPanel7._noSyHydroRoutingSteps, gridBagConstraints);
        this._invalidGvIsErrorCheck = new RmaJCheckBox("Invalid value for a Global Variable will stop the compute");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS0505;
        ResSimComputeOptionsPanel resSimComputeOptionsPanel8 = this;
        resSimComputeOptionsPanel8.add((Component)resSimComputeOptionsPanel8._invalidGvIsErrorCheck, gridBagConstraints);
        object = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)object, gridBagConstraints);
        this._resetButton = new RmaJButton("Reset Defaults");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        ((Container)object).add((Component)this._resetButton, gridBagConstraints);
        this._resetButton.addActionListener((ActionListener)new ResSimComputeOptionsPanel$1(this));
        this._rocEditButton = new RmaJButton("Edit Global ROC Options");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        ((Container)object).add((Component)this._rocEditButton, gridBagConstraints);
        this._rocEditButton.addActionListener((ActionListener)new ResSimComputeOptionsPanel$2(this));
    }

    private RssRmiWorkspace getRssRmiWorkspace() {
        ClientWorkspace clientWorkspace = ClientApp.Workspace();
        if (clientWorkspace == null) {
            return null;
        }
        return (RssRmiWorkspace)clientWorkspace.getChildWorkspace("rss");
    }

    public String getName() {
        return "ResSim Compute";
    }

    public void setProperties(Properties properties) {
        this._props = properties;
    }

    public void refresh() {
    }

    public void fillPanel() {
        String string;
        Object object = this.getRssRmiWorkspace();
        if (object == null) {
            return;
        }
        try {
            object = object.getRssComputeOptions();
        }
        catch (RemoteException remoteException) {
            StringBuilder stringBuilder = new StringBuilder("An error occurred while trying to get the ResSim Compute Options from the server.\n");
            stringBuilder.append(remoteException.getMessage());
            JOptionPane.showMessageDialog((Component)((Object)this), stringBuilder.toString(), "Error!", 0);
            return;
        }
        this._minPassesText.setValue(((RssComputeOptions)object).getMinComputePasses());
        this._substepsText.setValue(((RssComputeOptions)object).getStorCalcSubSteps());
        this._storErrFacText.setValue(((RssComputeOptions)object).getStorCalcErrTolFac());
        this._saveGCReleaseCheck.setSelected(((RssComputeOptions)object).saveReleaseToGuideCurve());
        this._noSyHydroRoutingSteps.setSelected(((RssComputeOptions)object).noSysHydroRoutingSteps());
        this._invalidGvIsErrorCheck.setSelected(((RssComputeOptions)object).invalidGlobalVariableIsError());
        object = ClientApp.app().getProperties();
        if (object != null && Boolean.getBoolean("computeTesting")) {
            string = object.getProp("computeTestingEnabled");
            this._computeTestingCheck.setSelected(Boolean.parseBoolean(string));
        }
        if (object != null) {
            string = object.getProp("computeDebugOutput");
            this._computeEngineDebugCheck.setSelected(Boolean.parseBoolean(string));
        }
    }

    public boolean savePanel() {
        Object object;
        boolean bl;
        Object object2 = ClientApp.app().getProperties();
        if (object2 != null && Boolean.getBoolean("computeTesting")) {
            bl = this._computeTestingCheck.isSelected();
            object2.setProp("computeTestingEnabled", String.valueOf(bl));
        }
        if (object2 != null) {
            bl = this._computeEngineDebugCheck.isSelected();
            object2.setProp("computeDebugOutput", String.valueOf(bl));
        }
        if ((object = ClientApp.Workspace()) == null) {
            return false;
        }
        object.setModified(true);
        object2 = (RssRmiWorkspace)object.getChildWorkspace("rss");
        if (object2 == null) {
            return false;
        }
        object = this.getOptions();
        if (object == null) {
            object = new RssComputeOptions();
        }
        ((RssComputeOptions)object).setMinComputePasses(this._minPassesText.getValue());
        ((RssComputeOptions)object).setStorCalcErrTolFac(this._storErrFacText.getValue());
        ((RssComputeOptions)object).setStorCalcSubSteps(this._substepsText.getValue());
        ((RssComputeOptions)object).setSaveReleaseToGuideCurve(this._saveGCReleaseCheck.isSelected());
        ((RssComputeOptions)object).setNoSysHydroRoutingSteps(this._noSyHydroRoutingSteps.isSelected());
        ((RssComputeOptions)object).setInvalidGlobalVariableIsError(this._invalidGvIsErrorCheck.isSelected());
        try {
            object2.setRssComputeOptions((RssComputeOptions)object);
        }
        catch (RemoteException remoteException) {
            object = new StringBuilder("An error occurred while trying to save the ResSim Compute Options to the server.\n");
            ((StringBuilder)object).append(remoteException.getMessage());
            JOptionPane.showMessageDialog((Component)((Object)this), ((StringBuilder)object).toString(), "Error!", 0);
            return false;
        }
        return true;
    }

    private RssComputeOptions getOptions() {
        Object object = ClientApp.Workspace();
        if (object == null) {
            return null;
        }
        if ((object = (RssRmiWorkspace)object.getChildWorkspace("rss")) == null) {
            return null;
        }
        try {
            object = object.getRssComputeOptions();
        }
        catch (RemoteException remoteException) {
            StringBuilder stringBuilder = new StringBuilder("An error occurred while trying to get the ResSim Compute Options to the server.\n");
            stringBuilder.append(remoteException.getMessage());
            JOptionPane.showMessageDialog((Component)((Object)this), stringBuilder.toString(), "Error!", 0);
            return null;
        }
        return object;
    }
}

