/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.lang.NamedType;
import hec.rss.model.ReservoirElement;
import hec.rss.model.RssSystem;
import hec.rss.model.SystemStorageZone;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import rma.util.RMASort;

public class ResSystemStorageZoneRootNode
extends DefaultMutableTreeNode {
    RssSystem m_system = null;

    public ResSystemStorageZoneRootNode() {
    }

    public ResSystemStorageZoneRootNode(RssSystem rssSystem) {
        this.m_system = rssSystem;
    }

    public void setSystem(RssSystem rssSystem) {
        this.m_system = rssSystem;
        this.sortChildrenTreeNodes();
    }

    public DefaultMutableTreeNode add(SystemStorageZone cloneable) {
        cloneable = new DefaultMutableTreeNode(cloneable);
        super.add((MutableTreeNode)((Object)cloneable));
        this.sortChildrenTreeNodes();
        return cloneable;
    }

    public DefaultMutableTreeNode insert(SystemStorageZone cloneable, int n) {
        cloneable = new DefaultMutableTreeNode(cloneable);
        super.insert((MutableTreeNode)((Object)cloneable), n);
        this.sortChildrenTreeNodes();
        return cloneable;
    }

    public void sortChildrenTreeNodes() {
        if (this.children == null || this.children.size() == 0) {
            return;
        }
        if (this.m_system == null) {
            if (Boolean.getBoolean("SYSTEM_STORAGENODE_DEBUG")) {
                System.out.println("NO System to use to sort child nodes. Returning");
            }
            return;
        }
        double[] dArray = new double[this.children.size()];
        int[] cfr_ignored_0 = new int[this.children.size()];
        Vector vector = this.m_system.getElementVectorByClass("hec.rss.model.ReservoirElement");
        for (int i = 0; i < this.children.size(); ++i) {
            Cloneable cloneable = (DefaultMutableTreeNode)this.children.elementAt(i);
            cloneable = (SystemStorageZone)((DefaultMutableTreeNode)cloneable).getUserObject();
            for (int j = 0; j < vector.size(); ++j) {
                NamedType namedType;
                ReservoirElement reservoirElement = (ReservoirElement)vector.elementAt(j);
                if (reservoirElement == null || (namedType = ((SystemStorageZone)cloneable).getStorageZoneBounds(reservoirElement.getIndex())) == null || (namedType = namedType.getUpperBound()) == null) continue;
                double d = namedType.getFirstElevation();
                int n = i;
                dArray[n] = dArray[n] + reservoirElement.getStorageFunction().elevationToStorage(d);
            }
            if (!Boolean.getBoolean("SYSTEM_STORAGENODE_DEBUG")) continue;
            System.out.println("System Storage Zone " + cloneable.getName() + " Has Storage " + dArray[i]);
        }
        Object[] objectArray = new Object[this.children.size()];
        this.children.copyInto(objectArray);
        RMASort.quickSort((double[])dArray, (Object[])objectArray, (boolean)false);
        this.children.removeAllElements();
        for (int i = 0; i < objectArray.length; ++i) {
            this.children.addElement((TreeNode)objectArray[i]);
        }
    }
}

