/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.clientapp.client.ClientApp;
import hec.data.ParamDouble;
import hec.gui.NameDialog;
import hec.model.RunTimeWindow;
import hec.rss.client.JOperationsPanel;
import hec.rss.client.JPhysicalPanel;
import hec.rss.client.ObsDataPanel;
import hec.rss.client.PulseRoutingOptionsRecord;
import hec.rss.client.ReservoirJFrame$SymWindow;
import hec.rss.model.Element;
import hec.rss.model.OpSet;
import hec.rss.model.ReservoirElement;
import hec.rss.model.ReservoirOutletElement;
import hec.rss.model.RssAlt;
import hec.rss.model.RssNode;
import hec.rss.model.RssSystem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Observable;
import java.util.Vector;
import java.util.function.Predicate;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.Document;
import rma.services.ServiceLookup;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.ClosableDialog;
import rma.swing.RmaGridBagConstraints;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDescriptionField;
import rma.swing.RmaJDialog;
import rma.swing.RmaJTabbedPane;
import rma.swing.RmaJTextField;
import rma.swing.RmaNavigationPanel;
import rma.swing.text.DssPathnamePartDocument;
import rma.util.RMAIO;

public class ReservoirJFrame
extends RmaJDialog
implements ActionListener,
ItemListener,
ChangeListener,
ButtonCmdPanelListener,
ClosableDialog {
    public static int a = 0;
    public static int b = 1;
    String units = "";
    RssSystem _system = null;
    String _currentReservoir = "";
    ReservoirElement _originalResElem = null;
    ReservoirElement _resElem = null;
    String currentRes;
    Vector<RssNode> _downstreamLocationVec = new Vector();
    Vector _downstreamElementVec = new Vector();
    boolean _physicalPanelFilled = false;
    boolean _obsDataPanelFilled = false;
    boolean _operationsPanelFilled = false;
    int _editingMode = a;
    boolean _isRssLp = false;
    boolean _pulseRoutingModified = false;
    Vector _pulseRoutingData = new Vector();
    ParamDouble _defaultPulseFlow;
    RunTimeWindow _runTimeWindow;
    OpSet m_selectedOpSet = null;
    private static ReservoirJFrame c;
    RmaJTabbedPane jResTabbedPane = new RmaJTabbedPane();
    JPhysicalPanel _jPanelPhysical = new JPhysicalPanel();
    JOperationsPanel jPanelOperations = new JOperationsPanel();
    ObsDataPanel jPanelObsData = new ObsDataPanel();
    JPanel jNamePanel = new JPanel();
    RmaJTextField jReservoirTextField = new RmaJTextField();
    RmaJComboBox resNameComboBox = new RmaJComboBox();
    RmaJDescriptionField jDescriptionTextField = new RmaJDescriptionField();
    JLabel jReservoirLabel = new JLabel();
    JLabel jLabelDescription = new JLabel();
    JMenuBar jMenuBar1 = new JMenuBar();
    JMenu jFileMenu = new JMenu();
    JMenuItem jRenameMenuItem = new JMenuItem();
    JMenuItem jSummaryMenuItem = new JMenuItem();
    JMenuItem jCloseMenuItem = new JMenuItem();
    JMenu jEditMenu = new JMenu();
    JMenuItem jUndoMenuItem = new JMenuItem();
    JMenu jPhysicalMenu = new JMenu();
    JMenu jStorageMenu = new JMenu();
    JMenuItem jImportMenuItem = new JMenuItem();
    JMenuItem jExportMenuItem = new JMenuItem();
    JMenu jCntrlOutletMenu = new JMenu();
    JMenu jUnCntrlOutletMenu = new JMenu();
    JMenuItem jAddControllerMenuItem = new JMenuItem();
    JMenuItem jAddOutletMenuItem = new JMenuItem();
    JMenu jLossesMenu = new JMenu();
    ButtonCmdPanel buttonCmdPanel = new ButtonCmdPanel(14);

    public ReservoirJFrame(Frame object, boolean bl, int n) {
        super((Frame)object, bl);
        if (n == a) {
            this._editingMode = a;
        } else if (n == b) {
            this._editingMode = b;
        }
        this.getContentPane().setLayout(new GridBagLayout());
        this.setSize(700, 550);
        this.setDefaultSize(720, 570);
        this.setSize(820, 650);
        this.setVisible(false);
        this.getContentPane().add((Component)this.jResTabbedPane, new RmaGridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
        this._jPanelPhysical.setParent(this);
        this.jResTabbedPane.add((Component)((Object)this._jPanelPhysical), (Object)"Physical");
        this.jResTabbedPane.setMnemonicAt(0, 80);
        if (this._editingMode == a) {
            this.jResTabbedPane.add((Component)((Object)this.jPanelOperations), (Object)"Operations");
            this.jResTabbedPane.setMnemonicAt(1, 79);
            this.jResTabbedPane.add((Component)this.jPanelObsData, (Object)"Observed Data");
            this.jResTabbedPane.setMnemonicAt(2, 66);
        }
        this.jResTabbedPane.setSelectedIndex(0);
        if (this._editingMode == a) {
            this.jPanelOperations.setParent((JDialog)((Object)this));
        }
        this._jPanelPhysical.createControls();
        this.jNamePanel.setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.jNamePanel, new RmaGridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0));
        object = this.jDescriptionTextField.getPreferredSize();
        this.jDescriptionTextField.getPreferredSize().width = 150;
        this.resNameComboBox.setPreferredSize((Dimension)object);
        this.resNameComboBox.setMinimumSize((Dimension)object);
        this.jNamePanel.add((Component)this.resNameComboBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        object = new RmaNavigationPanel();
        object.fillForm((JComboBox)this.resNameComboBox);
        this.jNamePanel.add((Component)object, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 13, 0, RmaInsets.INSETS5555, 0, 0));
        this.jNamePanel.add((Component)this.jDescriptionTextField, new GridBagConstraints(3, 0, 1, 1, 2.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.jReservoirLabel.setText("Reservoir");
        this.jReservoirLabel.setDisplayedMnemonic('V');
        this.jReservoirLabel.setLabelFor((Component)this.resNameComboBox);
        this.jNamePanel.add((Component)this.jReservoirLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.jReservoirLabel.setForeground(Color.black);
        this.jLabelDescription.setText("Description");
        this.jLabelDescription.setDisplayedMnemonic('D');
        this.jLabelDescription.setLabelFor((Component)this.jDescriptionTextField);
        this.jNamePanel.add((Component)this.jLabelDescription, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.jLabelDescription.setForeground(Color.black);
        this.getContentPane().add((Component)this.buttonCmdPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 16, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.jFileMenu.setText("Reservoir");
        this.jFileMenu.setActionCommand("File");
        this.jFileMenu.setMnemonic('R');
        this.jMenuBar1.add(this.jFileMenu);
        this.jRenameMenuItem.setText("Rename");
        this.jRenameMenuItem.setAccelerator(KeyStroke.getKeyStroke(82, 2, false));
        this.jRenameMenuItem.setMnemonic('e');
        this.jRenameMenuItem.setActionCommand("Rename");
        this.jRenameMenuItem.setEnabled(false);
        this.jFileMenu.add(this.jRenameMenuItem);
        this.jSummaryMenuItem.setText("Summary Report");
        this.jSummaryMenuItem.setAccelerator(KeyStroke.getKeyStroke(77, 2, false));
        this.jSummaryMenuItem.setMnemonic('S');
        this.jSummaryMenuItem.setEnabled(false);
        this.jFileMenu.add(this.jSummaryMenuItem);
        this.jFileMenu.addSeparator();
        this.jCloseMenuItem.setText("Close");
        this.jCloseMenuItem.setAccelerator(KeyStroke.getKeyStroke(87, 2, false));
        this.jCloseMenuItem.setMnemonic('C');
        this.jCloseMenuItem.setActionCommand("Close");
        this.jFileMenu.add(this.jCloseMenuItem);
        this.jEditMenu.setText("Edit");
        this.jEditMenu.setMnemonic('E');
        this.jEditMenu.setActionCommand("Edit");
        this.jMenuBar1.add(this.jEditMenu);
        this.jUndoMenuItem.setText("Undo All Edits");
        this.jUndoMenuItem.setAccelerator(KeyStroke.getKeyStroke(90, 2, false));
        this.jUndoMenuItem.setMnemonic('U');
        this.jUndoMenuItem.setEnabled(false);
        this.jEditMenu.add(this.jUndoMenuItem);
        this.jStorageMenu.setText("Storage");
        this.jStorageMenu.setMnemonic('S');
        this.jStorageMenu.setActionCommand("Storage");
        this.jMenuBar1.add(this.jPhysicalMenu);
        this.jImportMenuItem.setText("Import from DSS");
        this.jImportMenuItem.setMnemonic('I');
        this.jImportMenuItem.setActionCommand("Import from DSS");
        this.jImportMenuItem.setEnabled(false);
        this.jStorageMenu.add(this.jImportMenuItem);
        this.jExportMenuItem.setText("Export to DSS");
        this.jExportMenuItem.setMnemonic('E');
        this.jExportMenuItem.setActionCommand("Export to DSS");
        this.jExportMenuItem.setEnabled(false);
        this.jStorageMenu.add(this.jExportMenuItem);
        this.jLossesMenu.setText("Losses");
        this.jLossesMenu.setMnemonic('L');
        this.jLossesMenu.setActionCommand("Loses");
        this.jCntrlOutletMenu.setText("Controlled");
        this.jCntrlOutletMenu.setMnemonic('C');
        this.jCntrlOutletMenu.setActionCommand("Controlled");
        this.jUnCntrlOutletMenu.setText("Uncontrolled");
        this.jUnCntrlOutletMenu.setMnemonic('U');
        this.jUnCntrlOutletMenu.setActionCommand("Uncontrolled");
        this.jAddControllerMenuItem.setText("Add Controller");
        this.jAddControllerMenuItem.setMnemonic('C');
        this.jAddControllerMenuItem.setActionCommand("Add Controller");
        this.jAddControllerMenuItem.setEnabled(false);
        this.jAddOutletMenuItem.setText("Add Outlet");
        this.jAddOutletMenuItem.setMnemonic('O');
        this.jAddOutletMenuItem.setActionCommand("Add Outlet");
        this.jAddOutletMenuItem.setEnabled(false);
        this.jUnCntrlOutletMenu.add(this.jAddOutletMenuItem);
        this.jResTabbedPane.setSelectedComponent((Component)((Object)this._jPanelPhysical));
        this.jResTabbedPane.setSelectedIndex(0);
        this.setTitle("Reservoir Editor ");
        ReservoirJFrame reservoirJFrame = this;
        reservoirJFrame.setJMenuBar(reservoirJFrame.jMenuBar1);
        this._jPanelPhysical.updateDialogMenu();
        object = new ReservoirJFrame$SymWindow(this);
        this.addWindowListener((WindowListener)object);
        this.jCloseMenuItem.addActionListener(this);
        this.jRenameMenuItem.addActionListener(this);
        this.jResTabbedPane.addChangeListener((ChangeListener)this);
        this.resNameComboBox.addItemListener((ItemListener)this);
        this.jResTabbedPane.addChangeListener((ChangeListener)this);
        this.buttonCmdPanel.addCmdPanelListener((ButtonCmdPanelListener)this);
        this.jResTabbedPane.setSelectedIndex(0);
        ReservoirJFrame reservoirJFrame2 = this;
        reservoirJFrame2.setLocationRelativeTo(reservoirJFrame2.getParent());
    }

    public void addNotify() {
        super.addNotify();
        this.getRootPane().setDefaultButton(null);
    }

    public ReservoirJFrame(Frame frame, String string, boolean bl, int n) {
        this(frame, bl, n);
        this.setTitle(string);
        ReservoirJFrame reservoirJFrame = this;
        reservoirJFrame.setLocationRelativeTo(reservoirJFrame.getParent());
    }

    public ReservoirJFrame(Frame frame, String string, boolean bl) {
        this(frame, string, bl, a);
        ReservoirJFrame reservoirJFrame = this;
        reservoirJFrame.setLocationRelativeTo(reservoirJFrame.getParent());
    }

    public ReservoirJFrame(Frame frame, boolean bl) {
        this(frame, bl, a);
        ReservoirJFrame reservoirJFrame = this;
        reservoirJFrame.setLocationRelativeTo(reservoirJFrame.getParent());
    }

    public void setVisible(boolean bl) {
        if (bl) {
            c = this;
        } else {
            this._operationsPanelFilled = false;
            this._obsDataPanelFilled = false;
        }
        super.setVisible(bl);
        if (bl) {
            this.registerEnterKey(false);
            this.getRootPane().setDefaultButton(null);
            return;
        }
        this._jPanelPhysical.clearSelectedPanel();
    }

    void ReservoirJFrame_WindowClosing(WindowEvent windowEvent) {
        int n;
        if (this.isModified() && (n = RMAIO.postYesNoWarning((Component)((Object)this), (String)"Data Has Changed! Save before closing?")) == 0) {
            this.saveForm();
        }
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.jCloseMenuItem) {
            this.MenuClose_Action();
            return;
        }
        if (actionEvent.getSource() == this.jRenameMenuItem) {
            this.MenuRename_Action();
        }
    }

    public void buttonCmdActionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getID() == 8) {
            this.cmdOK_Action();
            return;
        }
        if (actionEvent.getID() == 4) {
            this.cmdCancel_Action();
            return;
        }
        if (actionEvent.getID() == 2) {
            this.cmdApply_Action();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent object) {
        if (((ItemEvent)object).getStateChange() == 2) {
            return;
        }
        if ((object = ((EventObject)object).getSource()) == this.resNameComboBox) {
            this.reservoirCombo_StateChanged();
        }
    }

    @Override
    public void stateChanged(ChangeEvent object) {
        if (!this.isVisible()) {
            return;
        }
        if ((object = ((EventObject)object).getSource()) == this.jResTabbedPane) {
            this.configureDialogItems();
        }
    }

    private void cmdOK_Action() {
        boolean bl = this.saveForm();
        if (!bl) {
            return;
        }
        this.setVisible(false);
        ClientApp.frame().getMapPanel().paintMap();
        this.dispose();
    }

    public void cmdCancel_Action() {
        boolean bl = true;
        if (this.isModified() && this.isEditable()) {
            int n = RMAIO.postYesNoCancelWarning((Component)((Object)this), (String)"Data Has Changed! Save before closing?");
            if (n == 2) {
                return;
            }
            if (n == 0) {
                bl = this.saveForm();
            }
            this.setModified(false);
        }
        if (!bl) {
            return;
        }
        this.setVisible(false);
        this.dispose();
    }

    protected void cmdApply_Action() {
        if (!this.saveForm()) {
            return;
        }
        ClientApp.frame().getMapPanel().paintMap();
        Component component = this.jResTabbedPane.getSelectedComponent();
        if (component == this.jPanelOperations && this.jPanelOperations._currentTab == null) {
            this.jPanelOperations.fillPanel(this.jPanelOperations._currentOpSet);
            this.jPanelOperations.setModified(false);
            this.setModified(false);
        }
    }

    private void MenuSave_Action() {
        this.saveForm();
    }

    public void MenuClose_Action() {
        boolean bl = true;
        if (this.isModified()) {
            int n = RMAIO.postYesNoCancelWarning((Component)((Object)this), (String)"Data Has Changed! Save before closing?");
            if (n == 2) {
                return;
            }
            if (n == 0) {
                bl = this.saveForm();
            }
        }
        if (!bl) {
            return;
        }
        this.setVisible(false);
        this.dispose();
    }

    private void MenuRename_Action() {
        if (this._currentReservoir == null) {
            return;
        }
        Object object = new NameDialog((Dialog)((Object)this));
        object.setNameFieldDocument((Document)new DssPathnamePartDocument());
        object.setTitle("Rename Reservoir");
        object.setName(this._resElem.getName());
        object.setDescription(this._resElem.getDescription());
        object.setVisible(true);
        if (object.isCanceled()) {
            return;
        }
        String string = this._resElem.getName();
        String string2 = object.getName();
        object = object.getDescription();
        this._resElem.setName(string2);
        this._resElem.setDescription((String)object);
        this.resNameComboBox.removeItemListener((ItemListener)this);
        int n = ((DefaultComboBoxModel)this.resNameComboBox.getModel()).getIndexOf(string);
        ((DefaultComboBoxModel)this.resNameComboBox.getModel()).insertElementAt(string2, n);
        this.resNameComboBox.setSelectedIndex(n);
        ((DefaultComboBoxModel)this.resNameComboBox.getModel()).removeElement(string);
        this.resNameComboBox.addItemListener((ItemListener)this);
    }

    private void MenuRenameReservoir_Action() {
        RMAIO.postWarning((Component)((Object)this), (String)"Need to Implement Rename Reservoir");
    }

    private void MenuPrint_Action() {
    }

    void setPhysicalMenu(String string, Vector vector) {
        this.jPhysicalMenu.setText(string);
        this.jPhysicalMenu.removeAll();
        if (vector == null) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            this.jPhysicalMenu.add((JComponent)vector.get(i));
        }
    }

    private void configureDialogItems() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        for (int i = this.jMenuBar1.getMenuCount() - 1; i >= 2; --i) {
            JMenu jMenu = this.jMenuBar1.getMenu(i);
            this.jMenuBar1.remove(jMenu);
        }
        Serializable serializable = this.jResTabbedPane.getSelectedComponent();
        boolean bl = this.isEditable();
        if (serializable == this._jPanelPhysical) {
            this.jMenuBar1.add(this.jPhysicalMenu);
            this._jPanelPhysical.updateDialogMenu();
        } else if (serializable == this.jPanelOperations) {
            serializable = this.jPanelOperations.getPanelMenus();
            for (int i = 0; i < serializable.size(); ++i) {
                this.jMenuBar1.add((JMenu)serializable.get(i));
            }
            if (!this.jPanelOperations.areControlsCreated()) {
                this.jPanelOperations.createControls();
                ReservoirJFrame reservoirJFrame = this;
                reservoirJFrame.setComponentsEditable(reservoirJFrame.jPanelOperations.getComponents(), bl);
            }
        } else if (serializable == this.jPanelObsData && !this.jPanelObsData.areControlsCreated()) {
            this.jPanelObsData.createControls();
            ReservoirJFrame reservoirJFrame = this;
            reservoirJFrame.setComponentsEditable(reservoirJFrame.jPanelObsData.getComponents(), bl);
        }
        this.jMenuBar1.repaint();
        this.fillSelectedPanel();
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void reservoirCombo_StateChanged() {
        int n;
        if (this.isModified() && (n = RMAIO.postYesNoWarning((Component)((Object)this), (String)"Items have changed! Would you like to Save?")) == 0) {
            this.saveForm();
        }
        this._physicalPanelFilled = false;
        this._operationsPanelFilled = false;
        this._obsDataPanelFilled = false;
        this.currentRes = (String)this.resNameComboBox.getSelectedItem();
        if (this.currentRes == null) {
            this._currentReservoir = null;
            return;
        }
        this._currentReservoir = this.currentRes;
        ReservoirJFrame reservoirJFrame = this;
        reservoirJFrame.fillForm(reservoirJFrame.currentRes);
    }

    @Deprecated
    public void setSelectedOpSet(OpSet opSet) {
        this.m_selectedOpSet = opSet;
    }

    public void setRunTimeWindow(RunTimeWindow runTimeWindow) {
        this._runTimeWindow = runTimeWindow;
    }

    public RunTimeWindow getRunTimeWindow() {
        return this._runTimeWindow;
    }

    public void fillForm(String object) {
        if (object == null) {
            return;
        }
        this.clearForm();
        this.resNameComboBox.removeItemListener((ItemListener)this);
        this.resNameComboBox.setSelectedItem(object);
        this.resNameComboBox.addItemListener((ItemListener)this);
        this._originalResElem = this._system.findReservoir((String)object);
        if (this._originalResElem == null) {
            return;
        }
        this._originalResElem.getReservoirOp().loadSystemDownstreamRules();
        this._originalResElem.getReservoirOp().loadSystemSystemHydropowerRules();
        this._resElem = (ReservoirElement)((Element)this._originalResElem).clone();
        this.jDescriptionTextField.setText(this._resElem.getDescription());
        this._downstreamLocationVec.removeAllElements();
        object = rssNode -> !rssNode.toString().endsWith("Tailwater");
        this._system.getDownstreamNodeList(this._resElem, this._downstreamLocationVec, (Predicate<RssNode>)object);
        object = this._system.getDownstreamElements(this._resElem);
        this._downstreamElementVec.removeAllElements();
        int n = ((Vector)object).size();
        for (int i = 0; i < n; ++i) {
            this._downstreamElementVec.add(((Vector)object).get(i));
        }
        this.fillSelectedPanel();
        this.setModified(false);
    }

    public void fillSelectedPanel() {
        if (this._resElem == null) {
            return;
        }
        Component component = this.jResTabbedPane.getSelectedComponent();
        if (component == this._jPanelPhysical && !this._physicalPanelFilled) {
            this._jPanelPhysical.fillPanel(this._system, this._resElem);
            component = ServiceLookup.getUnitsDisplayService();
            component.updateUnitSystem((Container)((Object)this._jPanelPhysical));
            this._physicalPanelFilled = true;
            return;
        }
        if (component == this.jPanelOperations && !this._operationsPanelFilled) {
            this.jPanelOperations.setDownstreamLocationComboModel(this._downstreamLocationVec);
            this.jPanelOperations.setDownstreamElementComboModel(this._downstreamElementVec);
            this.jPanelOperations.setData(this._resElem);
            this.jPanelOperations.fillPanel();
            ReservoirJFrame reservoirJFrame = this;
            reservoirJFrame.updateUnitSystem((Container)((Object)reservoirJFrame.jPanelOperations));
            this._operationsPanelFilled = true;
            return;
        }
        if (component == this.jPanelObsData) {
            this.jPanelObsData.fillPanel(this._resElem);
            ReservoirJFrame reservoirJFrame = this;
            reservoirJFrame.updateUnitSystem(reservoirJFrame.jPanelObsData);
            this._obsDataPanelFilled = true;
        }
    }

    public boolean initDlg(RssSystem rssSystem) {
        this.setSystem(rssSystem);
        return this.initDlg();
    }

    public boolean initDlg() {
        if (this._system == null) {
            RMAIO.postError((Component)((Object)this), (String)"Invalid Reservoir Network");
            return false;
        }
        this.clearForm();
        this.clearPulseRouting();
        this.resNameComboBox.removeAllItems();
        String[] stringArray = this._system.getReservoirNames();
        if (stringArray == null || stringArray.length == 0) {
            RMAIO.postError((Component)((Object)this), (String)"Need to create a Reservoir first");
            return false;
        }
        this.resNameComboBox.removeItemListener((ItemListener)this);
        for (int i = 0; i < stringArray.length; ++i) {
            this.resNameComboBox.addItem((Object)stringArray[i]);
        }
        this.resNameComboBox.setSelectedIndex(-1);
        this.resNameComboBox.addItemListener((ItemListener)this);
        return true;
    }

    public boolean saveForm() {
        ReservoirJFrame reservoirJFrame = this;
        boolean bl = reservoirJFrame.validateComponents(reservoirJFrame.getContentPane());
        if (!bl) {
            return false;
        }
        String string = (String)this.resNameComboBox.getSelectedItem();
        if (string == null) {
            RMAIO.postError((Component)((Object)this), (String)"Invalid Reservoir Element Selected");
            return false;
        }
        this._resElem.setDescription(this.jDescriptionTextField.getText());
        boolean bl2 = true;
        if (this._physicalPanelFilled) {
            bl2 = true & this._jPanelPhysical.savePanel();
        }
        if (this._obsDataPanelFilled) {
            bl2 &= this.jPanelObsData.savePanel(this._resElem);
        }
        if (this._operationsPanelFilled) {
            bl2 &= this.jPanelOperations.savePanel();
        }
        if (bl2) {
            this._originalResElem.copyInto(this._resElem);
            if (this._pulseRoutingModified) {
                this.storePulseRoutingOptions();
            }
            this._system.cleanVectors();
            this._system.setModified(true);
            this.setModified(false);
        }
        return bl2;
    }

    public void update(Observable observable, Object object) {
    }

    public String getUnits() {
        return this.units;
    }

    public void setSystem(RssSystem rssSystem) {
        if (rssSystem != this._system) {
            this.jPanelOperations._selectedOpSets.clear();
        }
        this._system = rssSystem;
        this.jPanelOperations.setAlternative(this._system.getAlternative());
        this.setTitle("Reservoir Editor - Network: " + rssSystem.getName());
    }

    public void selectReservoir(String string) {
        this._physicalPanelFilled = false;
        this._operationsPanelFilled = false;
        this._obsDataPanelFilled = false;
        if (string == null) {
            return;
        }
        this.resNameComboBox.removeItemListener((ItemListener)this);
        this.resNameComboBox.setSelectedItem((Object)string);
        this.resNameComboBox.addItemListener((ItemListener)this);
        this._currentReservoir = string;
        this.fillForm(string);
    }

    public Vector getDownStreamLocationVec() {
        return this._downstreamLocationVec;
    }

    public Vector getPulseRoutingOptions() {
        if (this._pulseRoutingData == null) {
            this._pulseRoutingData = new Vector();
        }
        String[] stringArray = this._system.getReservoirNames();
        if (this._pulseRoutingData.size() <= 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                ReservoirElement reservoirElement = this._system.findReservoir(stringArray[i]);
                List list = reservoirElement.getReservoirOutletElements(null);
                for (int j = 0; j < list.size(); ++j) {
                    PulseRoutingOptionsRecord pulseRoutingOptionsRecord = new PulseRoutingOptionsRecord();
                    ReservoirOutletElement reservoirOutletElement = (ReservoirOutletElement)list.get(j);
                    pulseRoutingOptionsRecord.reservoirName = reservoirElement.getName();
                    pulseRoutingOptionsRecord.releaseOutletName = reservoirOutletElement.getName();
                    pulseRoutingOptionsRecord.useDefault = reservoirOutletElement.getUseDefaultPulseFlow();
                    reservoirOutletElement.getPulseFlow(pulseRoutingOptionsRecord.pulseFlow_pd);
                    this._pulseRoutingData.add(pulseRoutingOptionsRecord);
                }
            }
        }
        return this._pulseRoutingData;
    }

    public void setPulseRoutingOptions(Vector vector) {
        this._pulseRoutingModified = true;
        this._pulseRoutingData = vector;
    }

    protected void clearPulseRouting() {
        this._pulseRoutingModified = false;
        this._pulseRoutingData = null;
        this._defaultPulseFlow = null;
    }

    protected void storePulseRoutingOptions() {
        if (this._pulseRoutingModified && this._pulseRoutingData != null && this._pulseRoutingData.size() > 0) {
            String string;
            PulseRoutingOptionsRecord pulseRoutingOptionsRecord;
            HashMap<CallSite, PulseRoutingOptionsRecord> hashMap = new HashMap<CallSite, PulseRoutingOptionsRecord>();
            for (int i = 0; i < this._pulseRoutingData.size(); ++i) {
                pulseRoutingOptionsRecord = (PulseRoutingOptionsRecord)this._pulseRoutingData.get(i);
                string = pulseRoutingOptionsRecord.reservoirName + "_" + pulseRoutingOptionsRecord.releaseOutletName;
                hashMap.put((CallSite)((Object)string), pulseRoutingOptionsRecord);
            }
            String[] stringArray = this._system.getReservoirNames();
            for (int i = 0; i < stringArray.length; ++i) {
                ReservoirElement reservoirElement = this._system.findReservoir(stringArray[i]);
                List list = reservoirElement.getReservoirOutletElements(null);
                for (int j = 0; j < list.size(); ++j) {
                    ReservoirOutletElement reservoirOutletElement = (ReservoirOutletElement)list.get(j);
                    string = stringArray[i] + "_" + reservoirOutletElement.getName();
                    pulseRoutingOptionsRecord = (PulseRoutingOptionsRecord)hashMap.get(string);
                    reservoirOutletElement.setUseDefaultPulseFlow(pulseRoutingOptionsRecord.useDefault);
                    reservoirOutletElement.setPulseFlow(pulseRoutingOptionsRecord.pulseFlow_pd);
                    reservoirOutletElement.setModified(true);
                    reservoirElement.setModified(true);
                }
            }
            this._system.setDefaultPulseFlow(this._defaultPulseFlow);
            this._system.setModified(true);
        }
    }

    public ParamDouble getDefaultPulseFlow() {
        if (this._defaultPulseFlow == null) {
            this._defaultPulseFlow = new ParamDouble();
            this._system.getDefaultPulseFlow(this._defaultPulseFlow);
        }
        return this._defaultPulseFlow;
    }

    public void setDefaultPulseFlow(ParamDouble paramDouble) {
        this._defaultPulseFlow = paramDouble;
    }

    public boolean isModified() {
        return this.jPanelOperations.isModified() || super.isModified();
    }

    public boolean closeDialog() {
        this.setVisible(false);
        return true;
    }

    public JOperationsPanel getOperationsPanel() {
        return this.jPanelOperations;
    }

    public static ReservoirJFrame a() {
        return c;
    }

    public ButtonCmdPanel getButtonCmdPanel() {
        return this.buttonCmdPanel;
    }

    public void setAlternative(RssAlt rssAlt) {
        this._jPanelPhysical.setAlternative(rssAlt);
    }
}

