/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.rss.client.AbstractElementOverridesPanel;
import hec.rss.client.OverridesPanel;
import hec.rss.client.RssSpecifyOverridesDialog;
import hec.rss.client.StorElevOverridesPanel;
import hec.rss.model.ReservoirElement;
import hec.rss.model.RssRun;
import hec.rss.model.RssSystem;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemListener;
import javax.swing.JTabbedPane;
import rma.swing.RmaInsets;

public class ReservoirOverridesPanel
extends AbstractElementOverridesPanel {
    private RssSpecifyOverridesDialog _editor;
    private OverridesPanel _elevationPanel;
    private OverridesPanel _releasePanel;
    private OverridesPanel _gatesPanel;
    private OverridesPanel _capacityPanel;
    private StorElevOverridesPanel _storagePanel;
    private JTabbedPane _tabbedPane;
    private RssRun _rssRun;

    public ReservoirOverridesPanel(RssSpecifyOverridesDialog rssSpecifyOverridesDialog) {
        super(new GridBagLayout(), rssSpecifyOverridesDialog);
        this._editor = rssSpecifyOverridesDialog;
        this.buildControls();
    }

    private void buildControls() {
        super.buildControls("Reservoir:", 'R');
        this._elevationPanel = new OverridesPanel(this);
        this._releasePanel = new OverridesPanel(this);
        this._releasePanel.setUseAltResultsPanelVisible(true);
        this._gatesPanel = new OverridesPanel(this);
        this._capacityPanel = new OverridesPanel(this);
        this._storagePanel = new StorElevOverridesPanel(this);
        this._tabbedPane = new JTabbedPane();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        ReservoirOverridesPanel reservoirOverridesPanel = this;
        reservoirOverridesPanel.add(reservoirOverridesPanel._tabbedPane, gridBagConstraints);
        this._tabbedPane.add("Elevation Target", (Component)((Object)this._elevationPanel));
        this._tabbedPane.add("Release", (Component)((Object)this._releasePanel));
        this._tabbedPane.add("Capacity", (Component)((Object)this._capacityPanel));
        this._tabbedPane.add("Storage", (Component)((Object)this._storagePanel));
        this._tabbedPane.setSelectedIndex(1);
    }

    public void setUseAltResultsPanelVisible(boolean bl) {
        this._releasePanel.setUseAltResultsPanelVisible(bl);
    }

    public void initPanel(RssRun stringArray) {
        this._rssRun = stringArray;
        this._releasePanel.setRun(this._rssRun);
        this._elevationPanel.setRun(this._rssRun);
        this._gatesPanel.setRun(this._rssRun);
        this._capacityPanel.setRun(this._rssRun);
        this._storagePanel.setRun(this._rssRun);
        System.out.println("setting release Overrides");
        this._releasePanel.setReleaseOverrides(this._rssRun.getReleaseOverrides());
        System.out.println("setting elevation Overrides");
        this._elevationPanel.setReleaseOverrides(this._rssRun.getElevationOverrides());
        System.out.println("setting gate overrides");
        this._gatesPanel.setReleaseOverrides(this._rssRun.getGateOverrides());
        System.out.println("setting capacity overrides");
        this._capacityPanel.setReleaseOverrides(this._rssRun.getCapacityOverrides());
        this._storagePanel.setReleaseOverrides(this._rssRun.getStorageOverrides(), this._rssRun.getElevationStorageOverrides());
        stringArray = this._rssRun.getAlternative().getSystem();
        stringArray = stringArray.getReservoirNames();
        if (stringArray == null) {
            return;
        }
        this._elementCombo.removeItemListener((ItemListener)this);
        if (this._elementCombo.getItemCount() > 0) {
            this._elementCombo.removeAllItems();
        }
        for (int i = 0; i < stringArray.length; ++i) {
            this._elementCombo.addItem((Object)stringArray[i]);
        }
        if (this._elementCombo.getItemCount() < 0) {
            return;
        }
        this._elementCombo.setSelectedIndex(0);
        this._elementCombo.addItemListener((ItemListener)this);
        if (this._releasePanel != null) {
            this._releasePanel.setModified(false);
        }
        if (this._elevationPanel != null) {
            this._elevationPanel.setModified(false);
        }
        if (this._gatesPanel != null) {
            this._gatesPanel.setModified(false);
        }
        if (this._capacityPanel != null) {
            this._capacityPanel.setModified(false);
        }
        if (this._storagePanel != null) {
            this._storagePanel.setModified(false);
        }
        this.setModified(false);
    }

    @Override
    public void fillForm(String object) {
        if (this._rssRun == null) {
            return;
        }
        if (object == null || ((String)object).length() <= 0) {
            return;
        }
        RssSystem rssSystem = this._rssRun.getAlternative().getSystem();
        object = rssSystem.findReservoir((String)object);
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.setFowardModifiedEvents(false);
        this._releasePanel.setReservoir((ReservoirElement)object);
        this._elevationPanel.setReservoir((ReservoirElement)object);
        this._gatesPanel.setReservoir((ReservoirElement)object);
        this._capacityPanel.setReservoir((ReservoirElement)object);
        this._storagePanel.setReservoir((ReservoirElement)object);
        this.setFowardModifiedEvents(true);
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.setModified(false);
    }

    @Override
    public void savePanel() {
        if (this._releasePanel != null) {
            this._releasePanel.savePanel();
        }
        if (this._elevationPanel != null) {
            this._elevationPanel.savePanel();
        }
        if (this._gatesPanel != null) {
            this._gatesPanel.savePanel();
        }
        if (this._capacityPanel != null) {
            this._capacityPanel.savePanel();
        }
        if (this._storagePanel != null) {
            this._storagePanel.savePanel();
        }
    }

    @Override
    protected OverridesPanel getSelectedOverridesPanel() {
        if (this._tabbedPane == null || !(this._tabbedPane.getSelectedComponent() instanceof OverridesPanel)) {
            return null;
        }
        OverridesPanel overridesPanel = (OverridesPanel)((Object)this._tabbedPane.getSelectedComponent());
        return overridesPanel;
    }

    @Override
    protected OverridesPanel getReleasePanel() {
        return this._releasePanel;
    }

    @Override
    public void setEnsemblePrefix(String string) {
        this._elevationPanel.setEnsemblePrefix(string);
        this._releasePanel.setEnsemblePrefix(string);
        this._gatesPanel.setEnsemblePrefix(string);
        this._capacityPanel.setEnsemblePrefix(string);
        this._storagePanel.setEnsemblePrefix(string);
    }
}

