/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.lang.NamedType;
import hec.rss.client.AlternativeEditor;
import hec.rss.client.ReservoirStorageVsYieldDemandRulePanel;
import hec.rss.client.YieldAnalysisPanelBase;
import hec.rss.model.ReservoirStorageVsYieldAnalysis;
import hec.rss.model.RssAlt;
import hec.rss.model.YieldAnalysis;
import hec.rss.model.YieldAnalysisType;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJIntegerField;
import rma.swing.RmaJIntegerSetField;
import rma.swing.RmaJLabel;

public class ReservoirStorageVsYieldAnalysisPanel
extends YieldAnalysisPanelBase {
    private RmaJIntegerField _numberOfIntervalsFld;
    private RmaJIntegerSetField _iterationsToWriteOutField;

    ReservoirStorageVsYieldAnalysisPanel(AlternativeEditor alternativeEditor) {
        super(alternativeEditor);
        this.buildControls();
        this.addClearAllActionListener();
    }

    private void buildControls() {
        this._demPanel = new ReservoirStorageVsYieldDemandRulePanel(this._editor);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        ReservoirStorageVsYieldAnalysisPanel reservoirStorageVsYieldAnalysisPanel = this;
        reservoirStorageVsYieldAnalysisPanel.add((Component)reservoirStorageVsYieldAnalysisPanel._demPanel, gridBagConstraints);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        ReservoirStorageVsYieldAnalysisPanel reservoirStorageVsYieldAnalysisPanel2 = this;
        reservoirStorageVsYieldAnalysisPanel2.add((Component)reservoirStorageVsYieldAnalysisPanel2.createIterationsPanel(), gridBagConstraints);
    }

    private JPanel createIterationsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = new JLabel("Number of Yield Analyses:");
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5005;
        jPanel.add((Component)jLabel, gridBagConstraints);
        this._numberOfIntervalsFld = new RmaJIntegerField(10, 5);
        this._numberOfIntervalsFld.setMinValue(0);
        jLabel.setLabelFor((Component)this._numberOfIntervalsFld);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        jPanel.add((Component)this._numberOfIntervalsFld, gridBagConstraints);
        jLabel = new JLabel("Max Iterations for each Yield Analysis:");
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        jPanel.add((Component)jLabel, gridBagConstraints);
        this._maxIterationFld = new RmaJIntegerField(10, 5);
        this._maxIterationFld.setMinValue(0);
        jLabel.setLabelFor((Component)this._maxIterationFld);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        jPanel.add((Component)this._maxIterationFld, gridBagConstraints);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        jPanel.add((Component)new RmaJLabel("Yield Analyses to Output:"), gridBagConstraints);
        this._iterationsToWriteOutField = new RmaJIntegerSetField();
        this._iterationsToWriteOutField.setText("1-11");
        this._iterationsToWriteOutField.setToolTipText("Writes the specified yield analyses to DSS.");
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        jPanel.add((Component)this._iterationsToWriteOutField, gridBagConstraints);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        jPanel.add((Component)this._clearAll, gridBagConstraints);
        return jPanel;
    }

    public void fillPanel(NamedType object) {
        if (!(object instanceof RssAlt)) {
            return;
        }
        this._alternative = (RssAlt)object;
        object = this._alternative.getReservoirStorageVsYieldAnalysis();
        ((ReservoirStorageVsYieldDemandRulePanel)this._demPanel).fillPanel((ReservoirStorageVsYieldAnalysis)object, this._alternative);
        if (object == null) {
            this._maxIterationFld.setValue(25);
            this._numberOfIntervalsFld.setValue(10);
            this._iterationsToWriteOutField.setText("1-11");
            return;
        }
        this._maxIterationFld.setValue(((YieldAnalysis)object).getMaxIterations());
        int n = ((ReservoirStorageVsYieldAnalysis)object).d();
        this._numberOfIntervalsFld.setValue(n);
        object = ((ReservoirStorageVsYieldAnalysis)object).b();
        if (object == null) {
            this._iterationsToWriteOutField.setText("1-" + n);
            return;
        }
        this._iterationsToWriteOutField.setText((String)object);
    }

    public boolean savePanel(RssAlt rssAlt) {
        int[] nArray = this._iterationsToWriteOutField.getIntegerSet();
        Object object = rssAlt.getSelectedYieldAnalysis();
        if (object == YieldAnalysisType.RESERVOIR_STORAGE_VS_YIELD_ANALYSIS && (nArray == null || nArray.length == 0)) {
            JOptionPane.showMessageDialog(this, "<html>The 'Yield Analyses to Output' text field has no valid integers. <br>This is likely because it is empty or it is not in a correct format.<br> Example: 1,2,4-7", "Yield Analyses to Output Error", 2);
            nArray = new int[]{};
            object = "";
        } else {
            object = this._iterationsToWriteOutField.getText();
        }
        ReservoirStorageVsYieldAnalysis reservoirStorageVsYieldAnalysis = new ReservoirStorageVsYieldAnalysis(rssAlt);
        reservoirStorageVsYieldAnalysis.setMaxIterations(this._maxIterationFld.getValue());
        reservoirStorageVsYieldAnalysis.b(this._numberOfIntervalsFld.getValue());
        YieldAnalysis yieldAnalysis = ((ReservoirStorageVsYieldDemandRulePanel)this._demPanel).savePanel(reservoirStorageVsYieldAnalysis);
        if (yieldAnalysis == null) {
            return false;
        }
        rssAlt.setReservoirStorageVsYieldAnalysis(reservoirStorageVsYieldAnalysis);
        reservoirStorageVsYieldAnalysis.a(nArray);
        reservoirStorageVsYieldAnalysis.a((String)object);
        return true;
    }

    public void clearPanel() {
        this._demPanel.clearPanel();
        this._maxIterationFld.setValue(25);
        this._numberOfIntervalsFld.setValue(10);
    }
}

