/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.clientapp.client.ClientApp;
import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.lang.NamedType;
import hec.rss.client.AlternativeEditor;
import hec.rss.client.ReservoirStorageVsYieldAdjustmentOptions;
import hec.rss.client.ReservoirStorageVsYieldAdjustmentOptionsDialog;
import hec.rss.client.ReservoirStorageVsYieldDemandRulePanel$1;
import hec.rss.client.ReservoirYieldDemandPanelBase;
import hec.rss.client.StorageVsYieldReservoirTableRowItem;
import hec.rss.client.UneditableTextField;
import hec.rss.model.OpSet;
import hec.rss.model.ReservoirElement;
import hec.rss.model.ReservoirStorageVsYieldAnalysis;
import hec.rss.model.RssAlt;
import hec.rss.model.StorageZone;
import hec.rss.model.StorageZoneRef;
import hec.rss.model.YieldAnalysis;
import hec.rss.model.YieldAnalysisRuleRef;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ressim.rma.swing.table.TwoVariableTableHeaderRender;
import rma.swing.RmaInsets;
import rma.swing.RmaJButton;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJLabel;
import rma.swing.RmaJPanel;
import rma.swing.table.ColumnGroup;
import rma.swing.table.GroupableTableHeader;
import rma.swing.table.RmaTableModel;
import rma.util.RMAUtil;

public class ReservoirStorageVsYieldDemandRulePanel
extends ReservoirYieldDemandPanelBase {
    private Vector<ReservoirElement> _resElems;
    private List<StorageVsYieldReservoirTableRowItem> _resTableRows = new ArrayList<StorageVsYieldReservoirTableRowItem>();
    private ReservoirStorageVsYieldAdjustmentOptions _selectedAdjustmentOptions;
    private RmaJButton _adjustmentButton;
    private UneditableTextField _seasonalCurveField;
    private UneditableTextField _adjacentZoneField;

    ReservoirStorageVsYieldDemandRulePanel(AlternativeEditor alternativeEditor) {
        super(alternativeEditor);
        this.setBorder(new TitledBorder("Select \"Demand\" Rule to Maximize"));
        this.buildControls();
        this.createTableHeaders();
        this.addListeners();
    }

    public void buildControls() {
        this.buildReservoirTable();
        this.buildSummaryPanel();
        this.buildTheSelectedRulesTable();
    }

    private void buildSummaryPanel() {
        RmaJPanel rmaJPanel = new RmaJPanel((LayoutManager)new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        RmaJLabel rmaJLabel = new RmaJLabel("Seasonal Curve Strategy:");
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        rmaJPanel.add((Component)rmaJLabel, (Object)gridBagConstraints);
        this._seasonalCurveField = new UneditableTextField();
        this._seasonalCurveField.setEditable(false);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        rmaJPanel.add((Component)((Object)this._seasonalCurveField), (Object)gridBagConstraints);
        rmaJLabel = new RmaJLabel("Adjacent Zone Strategy:");
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        rmaJPanel.add((Component)rmaJLabel, (Object)gridBagConstraints);
        this._adjacentZoneField = new UneditableTextField();
        this._adjacentZoneField.setEditable(false);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        rmaJPanel.add((Component)((Object)this._adjacentZoneField), (Object)gridBagConstraints);
        this._adjustmentButton = new RmaJButton("Edit Adjustment Options...");
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        rmaJPanel.add((Component)this._adjustmentButton, (Object)gridBagConstraints);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)0, (int)5, (int)5);
        this.add((Component)rmaJPanel, gridBagConstraints);
    }

    private void buildTheSelectedRulesTable() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        ReservoirStorageVsYieldDemandRulePanel reservoirStorageVsYieldDemandRulePanel = this;
        reservoirStorageVsYieldDemandRulePanel.add((Component)reservoirStorageVsYieldDemandRulePanel._selectedRulesTable.getScrollPane(), gridBagConstraints);
    }

    private void buildReservoirTable() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = ClientApp.app().getClientUnitSystem();
        ReservoirStorageVsYieldDemandRulePanel reservoirStorageVsYieldDemandRulePanel = this;
        this._resZoneTable = new ReservoirStorageVsYieldDemandRulePanel$1(reservoirStorageVsYieldDemandRulePanel, reservoirStorageVsYieldDemandRulePanel);
        this._resZoneTable.setAddRemoveEnabled(false);
        this._resZoneTable.setRowHeight(this._resZoneTable.getRowHeight() + 5);
        this._resZoneTable.deleteCells();
        this._resZoneTable.setDoubleCellEditor(3, true);
        int[] nArray = new int[]{0, 0, 0, Parameter.PARAMID_ELEV, Parameter.PARAMID_ELEV, Parameter.PARAMID_ELEV, Parameter.PARAMID_ELEV};
        this._resZoneTable.setDisplayUnitsSystem(n);
        GroupableTableHeader groupableTableHeader = new GroupableTableHeader(this._resZoneTable.getColumnModel());
        this._resZoneTable.setTableHeader((JTableHeader)groupableTableHeader);
        this._resZoneTable.setColumnParameters(nArray);
        this._resZoneTable.setUnitsHeaderRenderer();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        ReservoirStorageVsYieldDemandRulePanel reservoirStorageVsYieldDemandRulePanel2 = this;
        reservoirStorageVsYieldDemandRulePanel2.add((Component)reservoirStorageVsYieldDemandRulePanel2._resZoneTable.getScrollPane(), gridBagConstraints);
    }

    protected void addListeners() {
        this._resZoneTable.getModel().addTableModelListener(this::resZoneTableChanged);
        this._adjustmentButton.addActionListener(actionEvent -> this.launchAdjustmentOptions());
    }

    private StorageVsYieldReservoirTableRowItem getResTableRowItem(ReservoirElement reservoirElement) {
        if (reservoirElement != null) {
            for (StorageVsYieldReservoirTableRowItem storageVsYieldReservoirTableRowItem : this._resTableRows) {
                if (storageVsYieldReservoirTableRowItem.c().getIndex() != reservoirElement.getIndex()) continue;
                return storageVsYieldReservoirTableRowItem;
            }
        }
        return null;
    }

    private void launchAdjustmentOptions() {
        ReservoirStorageVsYieldAdjustmentOptionsDialog reservoirStorageVsYieldAdjustmentOptionsDialog = new ReservoirStorageVsYieldAdjustmentOptionsDialog((JDialog)((Object)this._editor));
        reservoirStorageVsYieldAdjustmentOptionsDialog.fillPanel(this._selectedAdjustmentOptions);
        reservoirStorageVsYieldAdjustmentOptionsDialog.setVisible(true);
        if (!reservoirStorageVsYieldAdjustmentOptionsDialog.wasCanceled()) {
            RMAUtil.setParentModified((Component)this);
            this._selectedAdjustmentOptions = reservoirStorageVsYieldAdjustmentOptionsDialog.getAdjustmentOptions();
            ReservoirStorageVsYieldDemandRulePanel reservoirStorageVsYieldDemandRulePanel = this;
            reservoirStorageVsYieldDemandRulePanel.fillSummaryPanel(reservoirStorageVsYieldDemandRulePanel._selectedAdjustmentOptions);
        }
    }

    private void fillSummaryPanel(ReservoirStorageVsYieldAdjustmentOptions reservoirStorageVsYieldAdjustmentOptions) {
        if (reservoirStorageVsYieldAdjustmentOptions == null) {
            return;
        }
        this._seasonalCurveField.setText(reservoirStorageVsYieldAdjustmentOptions.b().toString());
        this._adjacentZoneField.setText(reservoirStorageVsYieldAdjustmentOptions.a().toString());
    }

    private void updateResTable(ReservoirElement namedType) {
        StorageVsYieldReservoirTableRowItem storageVsYieldReservoirTableRowItem = this.getResTableRowItem((ReservoirElement)namedType);
        if (storageVsYieldReservoirTableRowItem == null) {
            return;
        }
        this._resZoneTable.deleteCells();
        Vector<Cloneable> vector = new Vector<Cloneable>(7);
        vector.add((Cloneable)namedType);
        int n = this._alternative.getResOpSetSelection(namedType.getIndex());
        namedType = namedType.getReservoirOp().getOperationSet(n);
        if (namedType == null) {
            return;
        }
        vector.add((Cloneable)namedType);
        vector.add(storageVsYieldReservoirTableRowItem.b());
        vector.add((Cloneable)storageVsYieldReservoirTableRowItem.a());
        vector.add((Cloneable)storageVsYieldReservoirTableRowItem.f());
        vector.add((Cloneable)storageVsYieldReservoirTableRowItem.g());
        vector.add((Cloneable)storageVsYieldReservoirTableRowItem.e());
        this._resZoneTable.setComboBoxEditor(2, storageVsYieldReservoirTableRowItem.b());
        this._resZoneTable.appendRow(vector);
        this._resZoneTable.setValueAt((Object)storageVsYieldReservoirTableRowItem.d(), 0, 2);
    }

    private void createResTableRowItems(RssAlt object) {
        this._resTableRows = new ArrayList<StorageVsYieldReservoirTableRowItem>();
        object = ((RssAlt)object).getSystem().getElementVectorByClass(ReservoirElement.class);
        this._resElems = object;
        object = ((Vector)object).iterator();
        while (object.hasNext()) {
            ReservoirElement reservoirElement = (ReservoirElement)object.next();
            this.createResTableRowItem(reservoirElement);
        }
    }

    private void doInitialFillOfResTable(ReservoirStorageVsYieldAnalysis reservoirStorageVsYieldAnalysis) {
        ReservoirStorageVsYieldDemandRulePanel reservoirStorageVsYieldDemandRulePanel = this;
        reservoirStorageVsYieldDemandRulePanel.createResTableRowItems(reservoirStorageVsYieldDemandRulePanel._alternative);
        this._resZoneTable.setComboBoxEditor(0, this._resElems);
        if (!this._resElems.isEmpty()) {
            ReservoirStorageVsYieldDemandRulePanel reservoirStorageVsYieldDemandRulePanel2 = this;
            reservoirStorageVsYieldDemandRulePanel2.updateResTable(reservoirStorageVsYieldDemandRulePanel2._resElems.get(0));
        }
        if (this._resZoneTable.getRowCount() == 0) {
            return;
        }
        if (reservoirStorageVsYieldAnalysis != null) {
            NamedType namedType;
            ReservoirElement reservoirElement = reservoirStorageVsYieldAnalysis.k();
            if (reservoirElement != null) {
                int n = this._alternative.getResOpSetSelection(reservoirElement.getIndex());
                namedType = reservoirElement.getReservoirOp().getOperationSet(n);
                this._resZoneTable.setValueAt((Object)reservoirElement, 0, 0);
                this._resZoneTable.setValueAt((Object)namedType, 0, 1);
                double d = namedType.getGuideCurveZone().getSeasonalRecord().getAnnualAverage();
                reservoirElement = new ParamDouble(d, Parameter.PARAMID_ELEV);
                this._resZoneTable.setValueAt((Object)reservoirElement, 0, 3);
            }
            if ((namedType = reservoirStorageVsYieldAnalysis.m()) != null) {
                this._resZoneTable.setValueAt((Object)namedType, 0, 2);
            }
            namedType = reservoirStorageVsYieldAnalysis.f();
            this._resZoneTable.setValueAt((Object)namedType, 0, 5);
            ParamDouble paramDouble = reservoirStorageVsYieldAnalysis.e();
            this._resZoneTable.setValueAt((Object)paramDouble, 0, 4);
            ParamDouble paramDouble2 = reservoirStorageVsYieldAnalysis.p();
            this._resZoneTable.setValueAt((Object)paramDouble2, 0, 6);
        }
    }

    private void createResTableRowItem(ReservoirElement reservoirElement) {
        int n = this._alternative.getResOpSetSelection(reservoirElement.getIndex());
        int n2 = this._alternative.getUnitSystem();
        OpSet opSet = reservoirElement.getReservoirOp().getOperationSet(n);
        if (opSet == null) {
            return;
        }
        Vector vector = opSet.getZoneVector();
        ParamDouble paramDouble = new ParamDouble(1000.0, Parameter.PARAMID_STOR, n2);
        StorageZone storageZone = null;
        if (!vector.isEmpty()) {
            storageZone = (StorageZone)vector.get(0);
        }
        double d = opSet.getGuideCurveZone().getSeasonalRecord().getAnnualAverage();
        opSet = new ParamDouble(d, Parameter.PARAMID_ELEV, n2);
        ParamDouble paramDouble2 = new ParamDouble(0.0, Parameter.PARAMID_ELEV, n2);
        ParamDouble paramDouble3 = new ParamDouble(0.0, Parameter.PARAMID_ELEV, n2);
        this._resTableRows.add(new StorageVsYieldReservoirTableRowItem(reservoirElement, vector, storageZone, paramDouble, (ParamDouble)opSet, paramDouble2, paramDouble3));
    }

    public void fillPanel(ReservoirStorageVsYieldAnalysis reservoirStorageVsYieldAnalysis, RssAlt rssAlt) {
        Object object;
        if (rssAlt == null) {
            return;
        }
        this._alternative = rssAlt;
        this._selectedRulesTable.deleteCells();
        if (reservoirStorageVsYieldAnalysis == null) {
            this._selectedAdjustmentOptions = ReservoirStorageVsYieldAdjustmentOptions.g();
        } else {
            object = reservoirStorageVsYieldAnalysis.getYieldAnalysisRuleRefs();
            object = object.iterator();
            while (object.hasNext()) {
                YieldAnalysisRuleRef yieldAnalysisRuleRef = (YieldAnalysisRuleRef)object.next();
                if (yieldAnalysisRuleRef.isInitialized()) continue;
                yieldAnalysisRuleRef.initializeData(rssAlt.getSystem());
            }
            this._satisfyMap = reservoirStorageVsYieldAnalysis.a_();
            this._selectedAdjustmentOptions = reservoirStorageVsYieldAnalysis.g();
        }
        this.doInitialFillOfResTable(reservoirStorageVsYieldAnalysis);
        object = this._resZoneTable.setDoubleCellEditor(6, true);
        object.setMinValue(0.0);
        object.setEmptyOk(false);
        ReservoirStorageVsYieldDemandRulePanel reservoirStorageVsYieldDemandRulePanel = this;
        reservoirStorageVsYieldDemandRulePanel.fillSummaryPanel(reservoirStorageVsYieldDemandRulePanel._selectedAdjustmentOptions);
        this.reservoirSelectionChanged();
    }

    private void resZoneTableChanged(TableModelEvent tableModelEvent) {
        if (tableModelEvent.getColumn() == 0) {
            this.reservoirSelectionChanged();
            return;
        }
        if (tableModelEvent.getColumn() == 2) {
            this.zoneSelectionChanged();
            return;
        }
        if (tableModelEvent.getColumn() == 4) {
            tableModelEvent = this.getMin();
            ParamDouble paramDouble = this.getMax();
            if (paramDouble != null && tableModelEvent != null && paramDouble.getValue() < tableModelEvent.getValue()) {
                JOptionPane.showMessageDialog(this, "Min value is greater than the max value.", "Min Greater Than Max", 2);
            }
            this.minValueChanged();
            return;
        }
        if (tableModelEvent.getColumn() == 5) {
            tableModelEvent = this.getMin();
            ParamDouble paramDouble = this.getMax();
            if (paramDouble != null && tableModelEvent != null && paramDouble.getValue() < tableModelEvent.getValue()) {
                JOptionPane.showMessageDialog(this, "Max value is less than the min value.", "Max Less Than Min", 2);
            }
            this.maxValueChanged();
            return;
        }
        if (tableModelEvent.getColumn() == 6) {
            this.toleranceChanged();
        }
    }

    private void maxValueChanged() {
        ReservoirStorageVsYieldDemandRulePanel reservoirStorageVsYieldDemandRulePanel = this;
        StorageVsYieldReservoirTableRowItem storageVsYieldReservoirTableRowItem = reservoirStorageVsYieldDemandRulePanel.getResTableRowItem(reservoirStorageVsYieldDemandRulePanel._selectedReservoir);
        if (storageVsYieldReservoirTableRowItem != null) {
            storageVsYieldReservoirTableRowItem.c(this.getMax());
        }
    }

    private void minValueChanged() {
        ReservoirStorageVsYieldDemandRulePanel reservoirStorageVsYieldDemandRulePanel = this;
        StorageVsYieldReservoirTableRowItem storageVsYieldReservoirTableRowItem = reservoirStorageVsYieldDemandRulePanel.getResTableRowItem(reservoirStorageVsYieldDemandRulePanel._selectedReservoir);
        if (storageVsYieldReservoirTableRowItem != null) {
            storageVsYieldReservoirTableRowItem.b(this.getMin());
        }
    }

    private void toleranceChanged() {
        ReservoirStorageVsYieldDemandRulePanel reservoirStorageVsYieldDemandRulePanel = this;
        StorageVsYieldReservoirTableRowItem storageVsYieldReservoirTableRowItem = reservoirStorageVsYieldDemandRulePanel.getResTableRowItem(reservoirStorageVsYieldDemandRulePanel._selectedReservoir);
        if (storageVsYieldReservoirTableRowItem != null) {
            storageVsYieldReservoirTableRowItem.a(this.getTolerance());
        }
    }

    private void zoneSelectionChanged() {
        StorageZone storageZone = this.getSelectedZone();
        if (storageZone == null) {
            return;
        }
        ReservoirStorageVsYieldDemandRulePanel reservoirStorageVsYieldDemandRulePanel = this;
        StorageVsYieldReservoirTableRowItem storageVsYieldReservoirTableRowItem = reservoirStorageVsYieldDemandRulePanel.getResTableRowItem(reservoirStorageVsYieldDemandRulePanel._selectedReservoir);
        if (storageVsYieldReservoirTableRowItem != null) {
            storageVsYieldReservoirTableRowItem.a(storageZone);
        }
    }

    private void reservoirSelectionChanged() {
        this._selectedReservoir = this.getSelectedReservoir();
        ReservoirStorageVsYieldDemandRulePanel reservoirStorageVsYieldDemandRulePanel = this;
        reservoirStorageVsYieldDemandRulePanel.updateResTable(reservoirStorageVsYieldDemandRulePanel._selectedReservoir);
        this._selectedRulesTable.deleteCells();
        this._ruleRefList.clear();
        ReservoirStorageVsYieldDemandRulePanel reservoirStorageVsYieldDemandRulePanel2 = this;
        Object object = reservoirStorageVsYieldDemandRulePanel2.getAllReservoirRules(reservoirStorageVsYieldDemandRulePanel2._alternative.getReservoirStorageVsYieldAnalysis());
        if (object != null && !object.isEmpty()) {
            object = object.iterator();
            while (object.hasNext()) {
                YieldAnalysisRuleRef yieldAnalysisRuleRef = (YieldAnalysisRuleRef)object.next();
                int n = yieldAnalysisRuleRef.getRule().getIndex();
                if (this._satisfyMap.containsKey(n)) {
                    n = this._satisfyMap.get(n).booleanValue() ? 1 : 0;
                    this.addRuleToSelectedRulesTable(yieldAnalysisRuleRef, n != 0);
                    continue;
                }
                this.addRuleToSelectedRulesTable(yieldAnalysisRuleRef);
            }
        }
    }

    private void addRuleToSelectedRulesTable(YieldAnalysisRuleRef yieldAnalysisRuleRef) {
        this.addRuleToSelectedRulesTable(yieldAnalysisRuleRef, true);
    }

    private ParamDouble getMin() {
        if (this._resZoneTable.getRowCount() > 0 && this._resZoneTable.getValueAt(0, 4) instanceof ParamDouble) {
            return (ParamDouble)this._resZoneTable.getValueAt(0, 4);
        }
        return null;
    }

    private ParamDouble getMax() {
        if (this._resZoneTable.getRowCount() > 0 && this._resZoneTable.getValueAt(0, 5) instanceof ParamDouble) {
            return (ParamDouble)this._resZoneTable.getValueAt(0, 5);
        }
        return null;
    }

    public YieldAnalysis savePanel(ReservoirStorageVsYieldAnalysis reservoirStorageVsYieldAnalysis) {
        reservoirStorageVsYieldAnalysis.a(this._selectedAdjustmentOptions);
        Object object = this.getZoneData();
        object = this.getRuleRefList((Map<ReservoirElement, StorageZoneRef>)object);
        reservoirStorageVsYieldAnalysis.setRuleRefs((List<YieldAnalysisRuleRef>)object);
        reservoirStorageVsYieldAnalysis.a(this.getSatisfyMap());
        reservoirStorageVsYieldAnalysis.a(this._selectedAdjustmentOptions);
        if (this._selectedReservoir != null) {
            ReservoirStorageVsYieldDemandRulePanel reservoirStorageVsYieldDemandRulePanel = this;
            object = reservoirStorageVsYieldDemandRulePanel.getResTableRowItem(reservoirStorageVsYieldDemandRulePanel._selectedReservoir);
            if (object != null) {
                reservoirStorageVsYieldAnalysis.a(this._selectedReservoir);
                reservoirStorageVsYieldAnalysis.a(((StorageVsYieldReservoirTableRowItem)object).d());
                reservoirStorageVsYieldAnalysis.c(((StorageVsYieldReservoirTableRowItem)object).e());
                reservoirStorageVsYieldAnalysis.a(((StorageVsYieldReservoirTableRowItem)object).f());
                reservoirStorageVsYieldAnalysis.b(((StorageVsYieldReservoirTableRowItem)object).g());
            }
        }
        return reservoirStorageVsYieldAnalysis;
    }

    @Override
    public void clearPanel() {
        this._resZoneTable.deleteCells();
        this._selectedRulesTable.deleteCells();
        this._ruleRefList = new ArrayList<YieldAnalysisRuleRef>();
        this.repaint();
    }

    private void createTableHeaders() {
        RmaJDecimalField rmaJDecimalField = new String[7];
        Object object = new int[7];
        String[] stringArray = new String[7];
        String[] stringArray2 = stringArray;
        stringArray[0] = "Reservoir";
        rmaJDecimalField[0] = "Reservoir";
        object[0] = -1;
        stringArray2[1] = "Operations Set";
        rmaJDecimalField[1] = "Operations Set";
        object[1] = -1;
        stringArray2[2] = "Lower Limit of \nCon Pool";
        rmaJDecimalField[2] = "<html>The top of the conservation pool is the designated guide curve level<br> in the operation set. The lower limit of the conservation to be<br> used in this Yield Analysis is the user specified selection in this field.<html>";
        object[2] = -1;
        stringArray2[3] = "Base";
        rmaJDecimalField[3] = "Base";
        object[3] = -1;
        stringArray2[4] = "Min";
        rmaJDecimalField[4] = "Min";
        object[4] = -1;
        stringArray2[5] = "Max";
        rmaJDecimalField[5] = "Max";
        object[5] = -1;
        stringArray2[6] = "Storage Test\nTolerance (%S)";
        rmaJDecimalField[6] = "Storage Test\nTolerance (%S)";
        object[6] = -1;
        boolean[] blArray = new boolean[stringArray2.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            int n = i;
            blArray[n] = n == 2 || i == 4 || i == 5 || i == 6;
        }
        this._resZoneTable.setModel((TableModel)new RmaTableModel(stringArray2, new Object[0][0], blArray));
        ((RmaTableModel)this._resZoneTable.getModel()).setColumnParameters(object);
        this._resZoneTable.setMlHeaderRenderer();
        this._resZoneTable.setUnitsHeaderRenderer();
        GroupableTableHeader groupableTableHeader = (GroupableTableHeader)this._resZoneTable.getTableHeader();
        ColumnGroup columnGroup = new ColumnGroup((TableCellRenderer)((Object)new TwoVariableTableHeaderRender()), "Peak Guide Curve Elev (%S)");
        object = columnGroup;
        columnGroup.add((Object)this._resZoneTable.getColumnModel().getColumn(3));
        object.add((Object)this._resZoneTable.getColumnModel().getColumn(4));
        object.add((Object)this._resZoneTable.getColumnModel().getColumn(5));
        groupableTableHeader.addColumnGroup((ColumnGroup)object);
        groupableTableHeader.setToolTipStrings((String[])rmaJDecimalField);
        this._resZoneTable.setColumnPrecision(3, 2);
        this._resZoneTable.setColumnPrecision(4, 2);
        this._resZoneTable.setColumnPrecision(5, 2);
        rmaJDecimalField = this._resZoneTable.setDoubleCellEditor(4, true);
        rmaJDecimalField.setMinValue(Double.MIN_VALUE);
        rmaJDecimalField.setEmptyOk(false);
        rmaJDecimalField = this._resZoneTable.setDoubleCellEditor(5, true);
        rmaJDecimalField.setMinValue(Double.MIN_VALUE);
        rmaJDecimalField.setEmptyOk(false);
    }

    @Override
    int getResToleranceColumn() {
        return 6;
    }
}

