/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.client.RenameDlg;
import hec.rss.client.JResSysSysOpsPanel;
import hec.rss.client.NewReservoirSystemDialog;
import hec.rss.client.ReservoirSystemJDialog$SymWindow;
import hec.rss.client.jfx.ReservoirLayoutPlotDialog;
import hec.rss.client.jfx.ReservoirLayoutPlotDialog$ResPlotMode;
import hec.rss.model.AbstractReservoirOp;
import hec.rss.model.ResSystemOpSet;
import hec.rss.model.ReservoirElement;
import hec.rss.model.ReservoirSysOp;
import hec.rss.model.RssSystem;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.Document;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaGridBagConstraints;
import rma.swing.RmaImage;
import rma.swing.RmaJButton;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDescriptionField;
import rma.swing.RmaJDialog;
import rma.swing.RmaJFrame;
import rma.swing.RmaNavigationPanel;
import rma.swing.text.DssPathnamePartDocument;
import rma.util.RMAIO;

public class ReservoirSystemJDialog
extends RmaJDialog
implements ActionListener,
ItemListener,
Observer,
ChangeListener,
ButtonCmdPanelListener {
    String units = "";
    RssSystem _system = null;
    ReservoirSysOp _currentResSysOp = null;
    boolean _newSysOp = false;
    Vector _updatedReservoirs = new Vector();
    boolean _updatedResvoirsInSystem = false;
    boolean _ignoreChanges = false;
    JPanel jPanel_Name = new JPanel();
    JResSysSysOpsPanel _systemOperationsPanel = new JResSysSysOpsPanel();
    RmaJButton _systemBalancePlotButton = new RmaJButton("Show System Balance Plot");
    JLabel _resSystemLabel = new JLabel("Reservoir System");
    JLabel _descLabel = new JLabel("Description");
    RmaJComboBox _resSystemComboBox = new RmaJComboBox();
    RmaJDescriptionField _descField = new RmaJDescriptionField();
    ButtonCmdPanel _buttonCmdPanel = new ButtonCmdPanel(14);
    JMenuBar jMenuBar_ResSys = new JMenuBar();
    JMenu jMenu_ResSystem = new JMenu("Reservoir System");
    JMenuItem jMenuItem_NewResSys = new JMenuItem("New...", 110);
    JMenuItem jMenuItem_EditResSys = new JMenuItem("Edit...", 101);
    JMenuItem jMenuItem_RenameResSys = new JMenuItem("Rename...", 114);
    JMenuItem jMenuItem_DeleteResSys = new JMenuItem("Delete...", 118);
    JMenuItem jMenuItem_Close = new JMenuItem("Close", 99);
    JMenu jMenu_SysOperations = new JMenu("System Balance");
    JMenuItem jMenuItem_NewSysOps = new JMenuItem("New...", 110);
    JMenuItem jMenuItem_RenameSysOps = new JMenuItem("Rename...", 114);
    JMenuItem jMenuItem_DeleteSysOps = new JMenuItem("Delete...", 100);
    JMenu jMenu_Zone = new JMenu("System Zones");
    JMenuItem jMenuItem_NewZone = new JMenuItem("New...", 110);
    JMenuItem jMenuItem_DeleteZone = new JMenuItem("Delete...", 100);

    public ReservoirSystemJDialog(Frame object, boolean bl) {
        super((Frame)object, bl);
        this.setTitle("Reservoir System Editor - watershed");
        this.initIcon();
        this.buildActions();
        this.setSize(800, 600);
        this.setDefaultSize(800, 600);
        object = new Dimension(800, 600);
        this.setMinimumSize((Dimension)object);
        this.setLocation();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setVisible(false);
        this._systemOperationsPanel.setParent((JDialog)((Object)this));
        this.jPanel_Name.setLayout(new GridBagLayout());
        this._buttonCmdPanel.setApplyAlwaysOn(false);
        this._buttonCmdPanel.setButtonEnable(8, false);
        object = new Insets(5, 5, 0, 5);
        Insets insets = new Insets(5, 10, 10, 10);
        this.getContentPane().add((Component)this.jPanel_Name, new RmaGridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 18, 2, (Insets)object, 0, 0));
        this._systemBalancePlotButton.setEnabled(false);
        this._systemOperationsPanel.createControls();
        this.getContentPane().add((Component)((Object)this._systemOperationsPanel), new RmaGridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 18, 1, (Insets)object, 0, 0));
        this.getContentPane().add((Component)this._systemBalancePlotButton, new RmaGridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0));
        this.getContentPane().add((Component)this._buttonCmdPanel, new RmaGridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 13, 0, insets, 0, 0));
        insets = new RmaNavigationPanel();
        insets.fillForm((JComboBox)this._resSystemComboBox);
        this.jPanel_Name.add((Component)this._resSystemLabel, new RmaGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, (Insets)object, 0, 0));
        this.jPanel_Name.add((Component)this._descLabel, new RmaGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, (Insets)object, 0, 0));
        this.jPanel_Name.add((Component)this._resSystemComboBox, new RmaGridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 4, 0, 35), 0, 0));
        this.jPanel_Name.add((Component)((Object)insets), new RmaGridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, (Insets)object, 0, 0));
        this.jPanel_Name.add((Component)new JPanel(), new RmaGridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 18, 2, (Insets)object, 0, 0));
        this.jPanel_Name.add((Component)this._descField, new RmaGridBagConstraints(1, 1, 3, 1, 1.0, 1.0, 17, 1, new Insets(5, 4, 0, 5), 0, -3));
        this._descLabel.setLabelFor((Component)this._descField);
        this._descField.setLineWrap(true);
        this._descField.setWrapStyleWord(true);
        this.initDialogMenus();
        object = new ReservoirSystemJDialog$SymWindow(this);
        this.addWindowListener((WindowListener)object);
        this._resSystemComboBox.addItemListener((ItemListener)this);
        this._buttonCmdPanel.addCmdPanelListener((ButtonCmdPanelListener)this);
        this.jMenuItem_NewResSys.addActionListener(this);
        this.jMenuItem_EditResSys.addActionListener(this);
        this.jMenuItem_RenameResSys.addActionListener(this);
        this.jMenuItem_DeleteResSys.addActionListener(this);
        this.jMenuItem_Close.addActionListener(this);
        this.jMenuItem_NewSysOps.addActionListener(this._systemOperationsPanel);
        this.jMenuItem_RenameSysOps.addActionListener(this._systemOperationsPanel);
        this.jMenuItem_DeleteSysOps.addActionListener(this._systemOperationsPanel);
        this.jMenuItem_NewZone.addActionListener(this._systemOperationsPanel);
        this.jMenuItem_DeleteZone.addActionListener(this._systemOperationsPanel);
        this._resSystemLabel.setDisplayedMnemonic('y');
        this._resSystemLabel.setLabelFor((Component)this._resSystemComboBox);
        this._descLabel.setDisplayedMnemonic('D');
        this._descLabel.setLabelFor((Component)this._descField);
        this.jMenu_ResSystem.setMnemonic('R');
        this.jMenuItem_EditResSys.setMnemonic('E');
        this.jMenu_SysOperations.setMnemonic('S');
        this.jMenu_Zone.setMnemonic('Z');
        this.registerEnterKey(true);
        this.registerEscapeKey(true);
    }

    private void initDialogMenus() {
        this.setSystemActionsEnabled(false);
        this.setBalanceMenuEnabled(false);
        this.setZoneMenuEnabled(false);
        this.setBalanceActionsEnabled(false);
        this.jMenuBar_ResSys.add(this.jMenu_ResSystem);
        this.jMenuBar_ResSys.add(this.jMenu_SysOperations);
        this.jMenuBar_ResSys.add(this.jMenu_Zone);
        this.jMenu_ResSystem.add(this.jMenuItem_NewResSys);
        this.jMenu_ResSystem.add(this.jMenuItem_EditResSys);
        this.jMenu_ResSystem.add(this.jMenuItem_RenameResSys);
        this.jMenu_ResSystem.add(this.jMenuItem_DeleteResSys);
        this.jMenu_ResSystem.addSeparator();
        this.jMenu_ResSystem.add(this.jMenuItem_Close);
        this.jMenu_SysOperations.add(this.jMenuItem_NewSysOps);
        this.jMenu_SysOperations.add(this.jMenuItem_RenameSysOps);
        this.jMenu_SysOperations.add(this.jMenuItem_DeleteSysOps);
        this.jMenuItem_NewSysOps.setActionCommand("NewOperationsSet");
        this.jMenuItem_DeleteSysOps.setActionCommand("DeleteOperationSet");
        this.jMenuItem_RenameSysOps.setActionCommand("RenameOperationSet");
        this.jMenu_Zone.add(this.jMenuItem_NewZone);
        this.jMenu_Zone.add(this.jMenuItem_DeleteZone);
        this.jMenuItem_NewZone.setActionCommand("NewZone");
        this.jMenuItem_DeleteZone.setActionCommand("RemoveZone");
        ReservoirSystemJDialog reservoirSystemJDialog = this;
        reservoirSystemJDialog.setJMenuBar(reservoirSystemJDialog.jMenuBar_ResSys);
    }

    private void initIcon() {
        Image image = RmaImage.loadURLImage((Component)((Object)this), (String)"Images/rss.gif");
        if (image != null) {
            this.setIconImage(image);
            RmaJFrame.setDefaultIconImage((Image)image);
        }
    }

    private void buildActions() {
        this._systemBalancePlotButton.addActionListener(actionEvent -> this.displaySystemStoragePlot());
    }

    public ReservoirSystemJDialog(Frame frame, String string, boolean bl) {
        this(frame, bl);
        this.setTitle(string);
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.registerEnterKey(false);
            this.getRootPane().setDefaultButton(null);
        }
    }

    public void setSystem(RssSystem rssSystem) {
        this._system = rssSystem;
    }

    public RssSystem getSystem() {
        return this._system;
    }

    public void setZoneMenuEnabled(boolean bl) {
        this.jMenu_Zone.setEnabled(bl);
    }

    public void setZoneActionsEnabled(boolean bl) {
        this.jMenuItem_DeleteZone.setEnabled(bl);
    }

    public void setBalanceActionsEnabled(boolean bl) {
        this.jMenuItem_RenameSysOps.setEnabled(bl);
        this.jMenuItem_DeleteSysOps.setEnabled(bl);
    }

    public void setPlotButtonEnabled(boolean bl) {
        this._systemBalancePlotButton.setEnabled(bl);
    }

    public void setBalanceMenuEnabled(boolean bl) {
        this.jMenu_SysOperations.setEnabled(bl);
    }

    public void setSystemActionsEnabled(boolean bl) {
        this.jMenuItem_DeleteResSys.setEnabled(bl);
        this.jMenuItem_EditResSys.setEnabled(bl);
        this.jMenuItem_RenameResSys.setEnabled(bl);
        this._descField.setEnabled(bl);
        this._resSystemComboBox.setEnabled(bl);
        this._systemOperationsPanel.setEnabled(bl);
    }

    public String getUnits() {
        return this.units;
    }

    public boolean isModified() {
        return this._systemOperationsPanel.isModified() || super.isModified();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.jMenuItem_NewResSys) {
            this.menuAction_NewResSys();
            return;
        }
        if (actionEvent.getSource() == this.jMenuItem_EditResSys) {
            this.menuAction_EditResSys();
            return;
        }
        if (actionEvent.getSource() == this.jMenuItem_RenameResSys) {
            this.menuAction_RenameResSys();
            return;
        }
        if (actionEvent.getSource() == this.jMenuItem_DeleteResSys) {
            this.menuAction_DeleteResSys();
            return;
        }
        if (actionEvent.getSource() == this.jMenuItem_Close) {
            this.menuAction_Close();
        }
    }

    private ResSystemOpSet getSelectedSystemBalance() {
        ResSystemOpSet resSystemOpSet = this._systemOperationsPanel.getSelectedSystemBalance();
        return resSystemOpSet;
    }

    public void buttonCmdActionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getID() == 8) {
            this.cmdOK_Action();
            return;
        }
        if (actionEvent.getID() == 4) {
            this.cmdCancel_Action();
            return;
        }
        if (actionEvent.getID() == 2) {
            this.cmdApply_Action();
        }
    }

    protected void displaySystemStoragePlot() {
        ResSystemOpSet resSystemOpSet = this.getSelectedSystemBalance();
        Serializable serializable = new StringBuilder();
        ((StringBuilder)serializable).append("Reservoir System Plot - ");
        ((StringBuilder)serializable).append(this._currentResSysOp.getUserName());
        ((StringBuilder)serializable).append(": ");
        ((StringBuilder)serializable).append(resSystemOpSet.getName());
        serializable = new ReservoirLayoutPlotDialog(new JFrame(), ((StringBuilder)serializable).toString(), ReservoirLayoutPlotDialog$ResPlotMode.RES_ONLY_1YEAR);
        ((ReservoirLayoutPlotDialog)serializable).setSystemBalance(resSystemOpSet);
        ((ReservoirLayoutPlotDialog)serializable).fillPanel(this._currentResSysOp);
        ((Window)serializable).setSize(1000, 600);
        ((Window)serializable).setLocationRelativeTo((Component)((Object)this));
        ((Window)serializable).setVisible(true);
    }

    @Override
    public void itemStateChanged(ItemEvent object) {
        if (!this._ignoreChanges) {
            if (((ItemEvent)object).getStateChange() == 2) {
                return;
            }
            if ((object = ((EventObject)object).getSource()) == this._resSystemComboBox) {
                this.ResSys_CB_StateChanged();
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (!this.isVisible()) {
            return;
        }
    }

    public void fillForm(ReservoirSysOp reservoirSysOp) {
        this.clearForm();
        if (reservoirSysOp == null) {
            this.setBalanceMenuEnabled(false);
            this.setSystemActionsEnabled(false);
            this._currentResSysOp = null;
            return;
        }
        this.setBalanceMenuEnabled(true);
        this.setSystemActionsEnabled(true);
        this._currentResSysOp = (ReservoirSysOp)((AbstractReservoirOp)reservoirSysOp).clone();
        this._resSystemComboBox.removeItemListener((ItemListener)this);
        this._resSystemComboBox.setSelectedItem((Object)reservoirSysOp);
        this._resSystemComboBox.addItemListener((ItemListener)this);
        this._descField.setText(this._currentResSysOp.getDescription());
        this._systemOperationsPanel.setData(this._currentResSysOp);
        this._systemOperationsPanel.fillPanel();
        this._updatedResvoirsInSystem = false;
        this._updatedReservoirs.clear();
        this.setModified(false);
    }

    public void clearForm() {
        super.clearForm();
        this._descField.setText("");
        this._systemOperationsPanel.clearBalanceComboBox();
        this._systemOperationsPanel.clearPanel();
        this.setPlotButtonEnabled(false);
        this.setBalanceActionsEnabled(false);
    }

    public boolean initDlg() {
        this._ignoreChanges = true;
        if (this._system == null) {
            RMAIO.postError((Component)((Object)this), (String)"Invalid Reservoir System");
            return false;
        }
        this.clearForm();
        this._resSystemComboBox.removeAllItems();
        ReservoirSysOp[] reservoirSysOpArray = this._system.getReservoirSysOps();
        this._resSystemComboBox.removeItemListener((ItemListener)this);
        for (int i = 0; i < reservoirSysOpArray.length; ++i) {
            this._resSystemComboBox.addItem((Object)reservoirSysOpArray[i]);
        }
        if (reservoirSysOpArray.length > 0) {
            this._resSystemComboBox.setSelectedItem((Object)reservoirSysOpArray[0]);
            this.setBalanceMenuEnabled(true);
            this.setSystemActionsEnabled(true);
            this.fillForm(reservoirSysOpArray[0]);
        } else {
            this.setSystemActionsEnabled(false);
            this.setBalanceMenuEnabled(false);
            this.setZoneMenuEnabled(false);
        }
        this._resSystemComboBox.addItemListener((ItemListener)this);
        this._ignoreChanges = false;
        return true;
    }

    public boolean saveForm() {
        ReservoirSystemJDialog reservoirSystemJDialog = this;
        boolean bl = reservoirSystemJDialog.validateComponents(reservoirSystemJDialog.getContentPane());
        if (!bl) {
            RMAIO.postError((Component)((Object)this), (String)"Invalid Data on Form");
            return false;
        }
        if (this._currentResSysOp == null) {
            return true;
        }
        this._currentResSysOp.setDescription(this._descField.getText());
        bl = true & this._systemOperationsPanel.savePanel();
        if (bl) {
            this.setModified(false);
            if (this._newSysOp) {
                ReservoirSysOp reservoirSysOp = (ReservoirSysOp)((AbstractReservoirOp)this._currentResSysOp).clone();
                this._system.addReservoirSysOp(reservoirSysOp);
                this._newSysOp = false;
                this.saveToSystem(reservoirSysOp);
                this._ignoreChanges = true;
                this._resSystemComboBox.removeAllItems();
                ReservoirSysOp[] reservoirSysOpArray = this._system.getReservoirSysOps();
                this._resSystemComboBox.removeItemListener((ItemListener)this);
                for (int i = 0; i < reservoirSysOpArray.length; ++i) {
                    this._resSystemComboBox.addItem((Object)reservoirSysOpArray[i]);
                }
                this._resSystemComboBox.setSelectedItem((Object)reservoirSysOp);
                this.fillForm(reservoirSysOp);
                this._resSystemComboBox.addItemListener((ItemListener)this);
                this._ignoreChanges = false;
            } else {
                ReservoirSysOp reservoirSysOp = this._system.getReservoirSysOp(this._currentResSysOp.getName());
                if (reservoirSysOp == null) {
                    return false;
                }
                reservoirSysOp.copyInto(this._currentResSysOp);
                this.saveToSystem(reservoirSysOp);
            }
        }
        this._updatedResvoirsInSystem = false;
        this._updatedReservoirs.clear();
        return bl;
    }

    private void saveToSystem(ReservoirSysOp reservoirSysOp) {
        if (this._system != null) {
            int[] nArray = reservoirSysOp.getReservoirIDs();
            for (int i = 0; i < nArray.length; ++i) {
                ReservoirElement reservoirElement = (ReservoirElement)this._system.getElement(nArray[i]);
                if (reservoirElement == null) continue;
                reservoirElement.setReservoirSysOp(reservoirSysOp);
            }
            this._system.setModified(true);
        }
    }

    @Override
    public void update(Observable observable, Object object) {
    }

    public void reservoirSystemChanged() {
        this._systemOperationsPanel.fillPanel();
    }

    void ReservoirSystemJDialog_WindowClosing() {
        if (this.isModified()) {
            int n = RMAIO.postYesNoWarning((Component)((Object)this), (String)"Data Has Changed! Save before closing?");
            if (n == 0) {
                this.saveForm();
            } else if (n == 1) {
                this.undoReservoirChanges();
            }
        }
        this.setVisible(false);
    }

    private void cmdOK_Action() {
        boolean bl = this.saveForm();
        if (!bl) {
            return;
        }
        this.setVisible(false);
        this.dispose();
    }

    private void cmdCancel_Action() {
        boolean bl = true;
        if (this.isModified()) {
            int n = RMAIO.postYesNoCancelWarning((Component)((Object)this), (String)"Data Has Changed! Save before closing?");
            if (n == 2) {
                return;
            }
            if (n == 0) {
                bl = this.saveForm();
            } else if (n == 1) {
                this.undoReservoirChanges();
                this.clearForm();
                this.setModified(false);
                this._resSystemComboBox.setSelectedIndex(0);
            }
        }
        if (!bl) {
            return;
        }
        this.setVisible(false);
        this.dispose();
    }

    private void cmdApply_Action() {
        this.saveForm();
    }

    private void menuAction_NewResSys() {
        this.checkModified();
        boolean bl = this.verifyAvailableReservoirs();
        if (!bl) {
            String string = "At least 2 reservoirs must be available (not assigned to an existing Reservoir System) to establish a new Reservoir System.";
            String string2 = "Not Enough Reservoirs Available";
            JOptionPane.showMessageDialog((Component)((Object)this), string, string2, 1);
            return;
        }
        Object object = new NewReservoirSystemDialog((Dialog)((Object)this), true, this._system);
        Object object2 = new Dimension(450, 350);
        object.setSize((Dimension)object2);
        object.setLocationRelativeTo((Component)((Object)this));
        object.setVisible(true);
        if (object.isCanceled()) {
            return;
        }
        object2 = object.getName();
        String string = object.getDescription();
        object = object.getAssignedReservoirs();
        this.buildNewResSysOp((String)object2, string, (List<ReservoirElement>)object);
        this.setModified(true);
    }

    private void buildNewResSysOp(String string, String string2, List<ReservoirElement> list) {
        this._system.loadReservoirSysOps(false);
        ReservoirSysOp reservoirSysOp = new ReservoirSysOp();
        reservoirSysOp.setUserName(string);
        reservoirSysOp.setName(this._system.createReservoirSysOpName(string));
        reservoirSysOp.setDescription(string2);
        reservoirSysOp.setIndex(this._system.getNextResSysOpId());
        list.forEach(reservoirElement -> reservoirSysOp.addReservoir((ReservoirElement)reservoirElement));
        reservoirSysOp.setRssSystem(this._system);
        this._resSystemComboBox.addItem((Object)reservoirSysOp);
        this._resSystemComboBox.getItemCount();
        this.clearForm();
        this._resSystemComboBox.setSelectedItem((Object)reservoirSysOp);
        this._newSysOp = true;
    }

    private boolean verifyAvailableReservoirs() {
        Vector<ReservoirElement> vector = this._system.getElementVectorByClass(ReservoirElement.class);
        ArrayList<ReservoirElement> arrayList = new ArrayList<ReservoirElement>();
        ReservoirSysOp[] reservoirSysOpArray = this._system.getReservoirSysOps();
        for (int i = 0; i < reservoirSysOpArray.length; ++i) {
            Object object = reservoirSysOpArray[i];
            object = ((ReservoirSysOp)object).getReservoirList();
            object.forEach(reservoirElement -> vector.remove(reservoirElement));
        }
        arrayList.addAll(vector);
        return vector.size() >= 2;
    }

    private void menuAction_RenameResSys() {
        if (this._currentResSysOp == null) {
            return;
        }
        if (this._system == null) {
            return;
        }
        RenameDlg renameDlg = new RenameDlg((Dialog)((Object)this), "Rename Reservoir System", true);
        renameDlg.setNameFieldDocument((Document)new DssPathnamePartDocument());
        renameDlg.removeFileComponents();
        renameDlg.setName(this._currentResSysOp.getUserName());
        renameDlg.setDescription(this._currentResSysOp.getDescription());
        renameDlg.setVisible(true);
        if (renameDlg.getCanceled()) {
            return;
        }
        this._system.renameReservoirSysOp(this._currentResSysOp.getName(), renameDlg.getName());
        this._resSystemComboBox.repaint();
        boolean bl = this._descField.getText().equals(renameDlg.getDescription());
        this._descField.setText(renameDlg.getDescription());
        this._currentResSysOp.setDescription(renameDlg.getDescription());
        this._currentResSysOp.setName(this._system.createReservoirSysOpName(renameDlg.getName()));
        this._currentResSysOp.setUserName(renameDlg.getName());
        if (bl) {
            this.setModified(bl);
        }
    }

    private void menuAction_EditResSys() {
        if (this._currentResSysOp == null) {
            return;
        }
        if (this._system == null) {
            return;
        }
        Object object = new NewReservoirSystemDialog((Dialog)((Object)this), true, this._system);
        Dimension dimension = new Dimension(450, 350);
        object.setSize(dimension);
        object.setLocationRelativeTo((Component)((Object)this));
        ((NewReservoirSystemDialog)((Object)object)).editReservoir(this._currentResSysOp);
        object.setVisible(true);
        if (((NewReservoirSystemDialog)((Object)object)).isCanceled()) {
            return;
        }
        boolean bl = false;
        String string = ((NewReservoirSystemDialog)((Object)object)).getDescription();
        if (!this._currentResSysOp.getDescription().equals(string)) {
            this._currentResSysOp.setDescription(string);
            bl = true;
        }
        object = ((NewReservoirSystemDialog)((Object)object)).getAssignedReservoirs();
        ReservoirSystemJDialog reservoirSystemJDialog = this;
        if (!reservoirSystemJDialog.compareReservoirLists(reservoirSystemJDialog._currentResSysOp.getReservoirList(), (List<ReservoirElement>)object)) {
            this._currentResSysOp.clearReservoirs();
            object.forEach(reservoirElement -> this._currentResSysOp.addReservoir((ReservoirElement)reservoirElement));
            this._updatedResvoirsInSystem = true;
            bl = true;
        }
        if (bl) {
            this.reservoirSystemChanged();
            this.setModified(true);
        }
    }

    public boolean compareReservoirLists(List<ReservoirElement> list, List<ReservoirElement> list2) {
        if (list == null && list2 != null) {
            return false;
        }
        if (list.size() != list2.size()) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i).getReservoirProjectId() == list2.get(i).getReservoirProjectId()) continue;
            return false;
        }
        return true;
    }

    private void menuAction_DeleteResSys() {
        if (this._currentResSysOp == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No Reservoir System Operation available to delete", "Delete Reservoir System Operation", 0);
            return;
        }
        ReservoirSystemJDialog reservoirSystemJDialog = this;
        int n = JOptionPane.showConfirmDialog((Component)((Object)reservoirSystemJDialog), "Delete Reservoir System Operation - " + reservoirSystemJDialog._currentResSysOp.getUserName(), "Delete Reservoir System Operation", 0);
        if (n == 0) {
            ReservoirSysOp reservoirSysOp = (ReservoirSysOp)this._resSystemComboBox.getSelectedItem();
            this._system.deleteReservoirSysOp(reservoirSysOp);
            this._system.setModified(true);
            this._currentResSysOp = null;
            this.initDlg();
        }
    }

    private void menuAction_PrintSummary() {
        System.out.println("-- print selected --");
    }

    private void menuAction_Close() {
        boolean bl = true;
        if (this.isModified()) {
            int n = RMAIO.postYesNoCancelWarning((Component)((Object)this), (String)"Data Has Changed! Save before closing?");
            if (n == 2) {
                return;
            }
            if (n == 0) {
                bl = this.saveForm();
            } else if (n == 1) {
                this.undoReservoirChanges();
            }
        }
        if (!bl) {
            return;
        }
        this.setVisible(false);
    }

    private void menuAction_Undo() {
        System.out.println("-- undo selected --");
    }

    private void ResSys_CB_StateChanged() {
        this.checkModified();
        ReservoirSysOp reservoirSysOp = (ReservoirSysOp)this._resSystemComboBox.getSelectedItem();
        if (reservoirSysOp == null || reservoirSysOp == this._currentResSysOp) {
            return;
        }
        this.fillForm(reservoirSysOp);
    }

    public void setModified(boolean bl) {
        super.setModified(bl);
        this._buttonCmdPanel.setButtonEnable(2, bl);
        this._buttonCmdPanel.setButtonEnable(8, bl);
    }

    public void checkModified() {
        if (this.isModified()) {
            int n = RMAIO.postYesNoWarning((Component)((Object)this), (String)"Items have changed! Would you like to Save?");
            if (n == 0) {
                this.saveForm();
                return;
            }
            if (n == 1) {
                this.undoReservoirChanges();
            }
        }
    }

    private void undoReservoirChanges() {
        if (!this._updatedResvoirsInSystem) {
            return;
        }
        for (int i = 0; i < this._updatedReservoirs.size(); ++i) {
            ReservoirElement reservoirElement = (ReservoirElement)this._updatedReservoirs.get(i);
            this._currentResSysOp.removeReservoir(reservoirElement);
        }
    }

    public static void a(String[] object) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
        object = new ReservoirSystemJDialog(null, false);
        object.setVisible(true);
    }
}

