/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.lang.NamedType;
import hec.rss.client.AlternativeEditor;
import hec.rss.client.YieldDemandRulePanel;
import hec.rss.model.ReservoirYieldAnalysis;
import hec.rss.model.RssAlt;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJIntegerField;

public class ReservoirYieldAnalysisPanel
extends JPanel {
    private YieldDemandRulePanel _demPanel;
    private RmaJIntegerField _maxIterationFld;
    private RmaJCheckBox _useDemandVarLimitCheck;
    private RmaJIntegerField _demandVarLimitFld;
    private AlternativeEditor _editor;

    ReservoirYieldAnalysisPanel(AlternativeEditor alternativeEditor) {
        super(new GridBagLayout());
        this._editor = alternativeEditor;
        this.buildControls();
        this.addListeners();
    }

    private void buildControls() {
        this._demPanel = new YieldDemandRulePanel(this._editor);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        ReservoirYieldAnalysisPanel reservoirYieldAnalysisPanel = this;
        reservoirYieldAnalysisPanel.add((Component)reservoirYieldAnalysisPanel._demPanel, gridBagConstraints);
        JPanel jPanel = new JPanel(new GridBagLayout());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.add((Component)jPanel, gridBagConstraints);
        JLabel jLabel = new JLabel("Maximum Iterations:");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        jPanel.add((Component)jLabel, gridBagConstraints);
        this._maxIterationFld = new RmaJIntegerField();
        this._maxIterationFld.setMinValue(0);
        jLabel.setLabelFor((Component)this._maxIterationFld);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        jPanel.add((Component)this._maxIterationFld, gridBagConstraints);
        this._useDemandVarLimitCheck = new RmaJCheckBox("Demand Variation Limit:");
        this._useDemandVarLimitCheck.setToolTipText("<html>When selected, demand will be varied within +/- this percent of the original demand rule<br>values to find the reservoir firm yield.");
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        jPanel.add((Component)this._useDemandVarLimitCheck, gridBagConstraints);
        this._demandVarLimitFld = new RmaJIntegerField();
        this._demandVarLimitFld.setMinValue(1);
        jLabel.setLabelFor((Component)this._demandVarLimitFld);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        jPanel.add((Component)this._demandVarLimitFld, gridBagConstraints);
        this.useDemandLimitCheckAction();
    }

    private void addListeners() {
        this._useDemandVarLimitCheck.addActionListener(actionEvent -> this.useDemandLimitCheckAction());
    }

    private void useDemandLimitCheckAction() {
        this._demandVarLimitFld.setEnabled(this._useDemandVarLimitCheck.isSelected());
    }

    public void fillPanel(NamedType object) {
        if (!(object instanceof RssAlt)) {
            return;
        }
        object = (RssAlt)object;
        ReservoirYieldAnalysis reservoirYieldAnalysis = object.getReservoirYieldAnalysis();
        this._demPanel.fillPanel(reservoirYieldAnalysis, (RssAlt)object);
        if (reservoirYieldAnalysis != null) {
            this._maxIterationFld.setValue(reservoirYieldAnalysis.getMaxIterations());
            this._useDemandVarLimitCheck.setSelected(reservoirYieldAnalysis.b());
            int n = reservoirYieldAnalysis.a();
            if (n <= 0) {
                n = Integer.MIN_VALUE;
            }
            this._demandVarLimitFld.setValue(n);
        }
        this.useDemandLimitCheckAction();
    }

    public boolean savePanel(RssAlt rssAlt) {
        ReservoirYieldAnalysis reservoirYieldAnalysis = new ReservoirYieldAnalysis();
        reservoirYieldAnalysis.setMaxIterations(this._maxIterationFld.getValue());
        reservoirYieldAnalysis.a(this._useDemandVarLimitCheck.isSelected());
        reservoirYieldAnalysis.a(this._demandVarLimitFld.getValue());
        this._demPanel.savePanel(reservoirYieldAnalysis);
        rssAlt.setReservoirYieldAnalysis(reservoirYieldAnalysis);
        return true;
    }

    public void clearPanel() {
        this._demPanel.clearPanel();
        this._maxIterationFld.setValue(25);
        this._useDemandVarLimitCheck.setSelected(false);
        this._demandVarLimitFld.clearPerformed();
        this.useDemandLimitCheckAction();
    }
}

