/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.rss.client.AlternativeEditor;
import hec.rss.client.YieldDemandPanelBase;
import hec.rss.model.ReservoirElement;
import hec.rss.model.StorageZone;
import hec.rss.model.StorageZoneRef;
import hec.rss.model.YieldAnalysis;
import hec.rss.model.YieldAnalysisRuleRef;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import rma.swing.RmaJTable;
import rma.util.RMAIO;

abstract class ReservoirYieldDemandPanelBase
extends YieldDemandPanelBase {
    RmaJTable _resZoneTable;
    ReservoirElement _selectedReservoir;

    ReservoirYieldDemandPanelBase(AlternativeEditor alternativeEditor) {
        super(alternativeEditor);
    }

    Map<ReservoirElement, StorageZoneRef> getZoneData() {
        int n = this._resZoneTable.getRowCount();
        HashMap<ReservoirElement, StorageZoneRef> hashMap = new HashMap<ReservoirElement, StorageZoneRef>();
        this._resZoneTable.commitEdit(true);
        for (int i = 0; i < n; ++i) {
            if (!(this._resZoneTable.getValueAt(i, 2) instanceof StorageZone)) continue;
            StorageZoneRef storageZoneRef = new StorageZoneRef((StorageZone)this._resZoneTable.getValueAt(i, 2));
            Object object = this._resZoneTable.getValueAt(i, this.getResToleranceColumn());
            if (object == null) continue;
            storageZoneRef.setTolerance(((ParamDouble)object).getValue());
            if (hashMap.containsKey(storageZoneRef.getStorageZone().getReservoirElement())) continue;
            hashMap.put(storageZoneRef.getStorageZone().getReservoirElement(), storageZoneRef);
        }
        return hashMap;
    }

    List<YieldAnalysisRuleRef> getRuleRefList(Map<ReservoirElement, StorageZoneRef> map) {
        int n = this._selectedRulesTable.getRowCount();
        ArrayList<YieldAnalysisRuleRef> arrayList = new ArrayList<YieldAnalysisRuleRef>();
        this._selectedRulesTable.commitEdit(true);
        for (int i = 0; i < n; ++i) {
            YieldAnalysisRuleRef yieldAnalysisRuleRef = this._ruleRefList.get(i);
            yieldAnalysisRuleRef.setTolerence(this.getToleranceAtRow(i));
            ArrayList<StorageZoneRef> arrayList2 = new ArrayList<StorageZoneRef>();
            if (arrayList.contains(yieldAnalysisRuleRef)) continue;
            Object object = yieldAnalysisRuleRef.getReservoirList(this._alternative);
            object = object.iterator();
            while (object.hasNext()) {
                ReservoirElement reservoirElement = (ReservoirElement)object.next();
                if (!map.containsKey(reservoirElement)) continue;
                arrayList2.add(map.get(reservoirElement));
            }
            yieldAnalysisRuleRef.setZones(arrayList2);
            arrayList.add(yieldAnalysisRuleRef);
        }
        return arrayList;
    }

    private double getToleranceAtRow(int n) {
        return RMAIO.parseDouble((Object)this._selectedRulesTable.getValueAt(n, 1));
    }

    int getResToleranceColumn() {
        return 3;
    }

    ReservoirElement getSelectedReservoir() {
        if (this._resZoneTable.getRowCount() > 0 && this._resZoneTable.getValueAt(0, 0) instanceof ReservoirElement) {
            return (ReservoirElement)this._resZoneTable.getValueAt(0, 0);
        }
        return null;
    }

    void addRuleToSelectedRulesTable(YieldAnalysisRuleRef object, boolean bl) {
        this._ruleRefList.add((YieldAnalysisRuleRef)object);
        Vector<Object> vector = new Vector<Object>();
        vector.add(((YieldAnalysisRuleRef)object).getLocationName() + " - " + ((YieldAnalysisRuleRef)object).getRuleName());
        object = "Local Hydropower".equals(((YieldAnalysisRuleRef)object).getRuleTypeString()) ? new ParamDouble(((YieldAnalysisRuleRef)object).getTolerance(), this._paramPower, this._alternative.getUnitSystem()) : new ParamDouble(((YieldAnalysisRuleRef)object).getTolerance(), this._paramFlow, this._alternative.getUnitSystem());
        vector.add(object);
        object = Parameter.getUnitsStringForSystem((int)object.getParameterId(), (int)object.getUnitSystem());
        vector.add(object);
        vector.add(bl);
        this._selectedRulesTable.appendRow(vector);
    }

    ParamDouble getTolerance() {
        if (this._resZoneTable.getRowCount() > 0 && this._resZoneTable.getValueAt(0, this.getResToleranceColumn()) instanceof ParamDouble) {
            return (ParamDouble)this._resZoneTable.getValueAt(0, this.getResToleranceColumn());
        }
        return null;
    }

    StorageZone getSelectedZone() {
        if (this._resZoneTable.getRowCount() > 0 && this._resZoneTable.getValueAt(0, 2) instanceof StorageZone) {
            return (StorageZone)this._resZoneTable.getValueAt(0, 2);
        }
        return null;
    }

    List<YieldAnalysisRuleRef> getAllReservoirRules(YieldAnalysis iterator) {
        ArrayList<YieldAnalysisRuleRef> arrayList = new ArrayList<YieldAnalysisRuleRef>();
        if (this._alternative == null) {
            return arrayList;
        }
        if (iterator != null) {
            arrayList.addAll(((YieldAnalysis)((Object)iterator)).getYieldAnalysisRuleRefs());
        }
        iterator = this._alternative.getYieldAnalysisWaterSupplyRules();
        List<YieldAnalysisRuleRef> list = this._alternative.getYieldAnalysisHydropowerRules();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            YieldAnalysisRuleRef yieldAnalysisRuleRef = (YieldAnalysisRuleRef)iterator.next();
            ReservoirYieldDemandPanelBase reservoirYieldDemandPanelBase = this;
            if (reservoirYieldDemandPanelBase.doesRuleAlreadyExist(reservoirYieldDemandPanelBase._alternative, arrayList, yieldAnalysisRuleRef)) continue;
            arrayList.add(yieldAnalysisRuleRef);
        }
        for (YieldAnalysisRuleRef yieldAnalysisRuleRef : list) {
            ReservoirYieldDemandPanelBase reservoirYieldDemandPanelBase = this;
            if (reservoirYieldDemandPanelBase.doesRuleAlreadyExist(reservoirYieldDemandPanelBase._alternative, arrayList, yieldAnalysisRuleRef)) continue;
            arrayList.add(yieldAnalysisRuleRef);
        }
        return this.filterRulesForSelectedReservoir(arrayList);
    }

    private List<YieldAnalysisRuleRef> filterRulesForSelectedReservoir(List<YieldAnalysisRuleRef> object) {
        ArrayList<YieldAnalysisRuleRef> arrayList = new ArrayList<YieldAnalysisRuleRef>();
        if (this._selectedReservoir == null) {
            return object;
        }
        int n = this._selectedReservoir.getIndex();
        object = object.iterator();
        block0: while (object.hasNext()) {
            YieldAnalysisRuleRef yieldAnalysisRuleRef = (YieldAnalysisRuleRef)object.next();
            Object object2 = yieldAnalysisRuleRef.getReservoirList(this._alternative);
            object2 = object2.iterator();
            while (object2.hasNext()) {
                ReservoirElement reservoirElement = (ReservoirElement)object2.next();
                if (reservoirElement.getIndex() != n) continue;
                arrayList.add(yieldAnalysisRuleRef);
                continue block0;
            }
        }
        return arrayList;
    }
}

