/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.clientapp.client.ClientWorkspace;
import hec.clientapp.model.StreamAlignment;
import hec.gui.WizardPanel;
import hec.rss.client.ResolveComputationPointsPanel$1;
import hec.rss.client.ResolveComputationPointsPanel$2;
import hec.rss.client.ResolveComputationPointsPanel$ReservoirChildElement;
import hec.rss.client.SelectStreamsDialog;
import hec.rss.model.DiversionElement;
import hec.rss.model.DivertedOutletElement;
import hec.rss.model.Element;
import hec.rss.model.JunctionElement;
import hec.rss.model.ReachElement;
import hec.rss.model.ReservoirElement;
import hec.rss.model.RssSystem;
import hec.watershed.model.ComputationPoint;
import hec.watershed.model.Condition;
import hec.watershed.model.ConditionDataList;
import hec.watershed.model.Diversion;
import hec.watershed.model.Reservoir;
import hec.watershed.model.Study;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJTable;
import rma.swing.RmaJTextField;
import rma.swing.list.RmaListModel;
import rma.swing.table.RmaTableModel;

public class ResolveComputationPointsPanel
extends WizardPanel {
    public static final String PANEL_NAME = "ResolveComputationPoints";
    private JLabel _panelTitle;
    private JLabel _selectedNetworkLabel;
    private JLabel _currentNetworkLabel;
    private RmaJTextField _watershedNameTxt;
    private RmaJTable _networkTable;
    private JButton _setStreamNamesButton;
    private SelectStreamsDialog _selectStreamsDialog;
    private JLabel _configurationLabel;
    private RmaJComboBox _configurationCombo;
    private ItemListener _configComboItemListener;
    private TableModelListener _networkTableListener;
    private String[] _columnNames;
    private RmaTableModel _networkTableModel;
    private RssSystem _importFromNetwork;
    private StreamAlignment _currentStreamAlignment;
    private String[] _streamNames;
    private HashMap _cpMap;
    private List _elementList;
    private ConditionDataList _conditionList;
    private ClientWorkspace _currentWksp;
    private Study _study;
    Vector _junctionList;
    Vector _reservoirList;
    Vector _diversionList;
    Condition _configuration;
    long _configurationID;
    Vector _cpJunctionsVec;

    public ResolveComputationPointsPanel() {
        super((LayoutManager)new GridBagLayout());
        this.buildControls();
    }

    protected void buildControls() {
        this._panelTitle = new JLabel("Resolve Network Computation Points");
        Serializable serializable = this._panelTitle.getFont();
        this._panelTitle.setFont(new Font(serializable.getName(), 1, serializable.getSize()));
        serializable = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        ((GridBagConstraints)serializable).gridy = 0;
        ((GridBagConstraints)serializable).gridwidth = 0;
        ((GridBagConstraints)serializable).weightx = 1.0;
        ((GridBagConstraints)serializable).anchor = 18;
        ((GridBagConstraints)serializable).fill = 2;
        ((GridBagConstraints)serializable).insets = RmaInsets.insets((int)4, (int)4, (int)4, (int)4);
        ResolveComputationPointsPanel resolveComputationPointsPanel = this;
        resolveComputationPointsPanel.add(resolveComputationPointsPanel._panelTitle, serializable);
        JPanel jPanel = new JPanel(new GridBagLayout());
        serializable = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        ((GridBagConstraints)serializable).gridy = 1;
        ((GridBagConstraints)serializable).weightx = 1.0;
        ((GridBagConstraints)serializable).weighty = 0.0;
        ((GridBagConstraints)serializable).gridwidth = 0;
        ((GridBagConstraints)serializable).anchor = 18;
        ((GridBagConstraints)serializable).fill = 2;
        ((GridBagConstraints)serializable).insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.add(jPanel, serializable);
        JLabel jLabel = new JLabel("Watershed:");
        serializable = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        ((GridBagConstraints)serializable).gridy = 0;
        ((GridBagConstraints)serializable).gridwidth = -1;
        ((GridBagConstraints)serializable).anchor = 18;
        ((GridBagConstraints)serializable).fill = 0;
        ((GridBagConstraints)serializable).insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        jPanel.add((Component)jLabel, serializable);
        this._watershedNameTxt = new RmaJTextField();
        this._watershedNameTxt.setEditable(false);
        serializable = new GridBagConstraints();
        new GridBagConstraints().gridwidth = 0;
        ((GridBagConstraints)serializable).anchor = 18;
        ((GridBagConstraints)serializable).fill = 2;
        ((GridBagConstraints)serializable).insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        jPanel.add((Component)this._watershedNameTxt, serializable);
        this._configurationLabel = new JLabel("Configuration:", 4);
        this._configurationLabel.setDisplayedMnemonic('c');
        serializable = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        ((GridBagConstraints)serializable).gridy = 1;
        ((GridBagConstraints)serializable).anchor = 18;
        ((GridBagConstraints)serializable).fill = 0;
        ((GridBagConstraints)serializable).insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        jPanel.add((Component)this._configurationLabel, serializable);
        this._configurationCombo = new RmaJComboBox();
        this._configurationLabel.setLabelFor((Component)this._configurationCombo);
        serializable = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        ((GridBagConstraints)serializable).gridy = 1;
        ((GridBagConstraints)serializable).gridwidth = 1;
        ((GridBagConstraints)serializable).anchor = 18;
        ((GridBagConstraints)serializable).fill = 2;
        ((GridBagConstraints)serializable).insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        ((GridBagConstraints)serializable).weightx = 1.0;
        jPanel.add((Component)this._configurationCombo, serializable);
        jPanel = new JPanel(new GridBagLayout());
        serializable = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        ((GridBagConstraints)serializable).gridy = 3;
        ((GridBagConstraints)serializable).weightx = 1.0;
        ((GridBagConstraints)serializable).weighty = 1.0;
        ((GridBagConstraints)serializable).gridwidth = 0;
        ((GridBagConstraints)serializable).anchor = 18;
        ((GridBagConstraints)serializable).fill = 1;
        ((GridBagConstraints)serializable).insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.add(jPanel, serializable);
        this._currentNetworkLabel = new JLabel("New Network: ");
        serializable = new GridBagConstraints();
        new GridBagConstraints().weightx = 1.0;
        ((GridBagConstraints)serializable).gridwidth = -1;
        ((GridBagConstraints)serializable).anchor = 18;
        ((GridBagConstraints)serializable).fill = 2;
        ((GridBagConstraints)serializable).insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        jPanel.add((Component)this._currentNetworkLabel, serializable);
        this._selectedNetworkLabel = new JLabel("Import From Network: ", 4);
        serializable = new GridBagConstraints();
        new GridBagConstraints().weightx = 1.0;
        ((GridBagConstraints)serializable).gridwidth = 0;
        ((GridBagConstraints)serializable).anchor = 12;
        ((GridBagConstraints)serializable).fill = 2;
        ((GridBagConstraints)serializable).insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        jPanel.add((Component)this._selectedNetworkLabel, serializable);
        this._columnNames = new String[]{"Imported Element Name", "Element Type", "Watershed Computation Point"};
        this._networkTableModel = this.createTableModel();
        ResolveComputationPointsPanel resolveComputationPointsPanel2 = this;
        this._networkTable = new ResolveComputationPointsPanel$1(resolveComputationPointsPanel2, (Component)((Object)resolveComputationPointsPanel2));
        this._networkTable.setModel((TableModel)this._networkTableModel);
        this._networkTable.setColumnEnabled(false, 0);
        this._networkTable.setColumnEnabled(false, 1);
        this._networkTable.setComboBoxEditor(2, new Object[0]);
        int n = this._networkTable.getRowHeight();
        this._networkTable.setRowHeight(n + 5);
        this._networkTable.setCellSelectionEnabled(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        jPanel.add((Component)this._networkTable.getScrollPane(), gridBagConstraints);
        this._configComboItemListener = new ResolveComputationPointsPanel$2(this);
        this._configurationCombo.addItemListener(this._configComboItemListener);
    }

    private RmaTableModel createTableModel() {
        return new RmaTableModel(this._columnNames, new Object[1][this._columnNames.length], new boolean[this._columnNames.length]);
    }

    public String getPanelName() {
        return PANEL_NAME;
    }

    public boolean isValidPanel() {
        List list = this.saveAssignments();
        if (list.size() > 0) {
            String[] stringArray = new String[list.size() + 1];
            String[] stringArray2 = stringArray;
            stringArray[0] = "The following elements were not assigned computation points:";
            for (int i = 0; i < list.size(); ++i) {
                Object object = list.get(i);
                object = "<html><b>" + object.toString() + "</b></html>";
                stringArray2[i + 1] = object;
            }
            JOptionPane.showMessageDialog((Component)((Object)this), stringArray2, "Assignment Warnings", 2);
        }
        return true;
    }

    public void setWorkspace(ClientWorkspace clientWorkspace) {
        if (clientWorkspace != null) {
            this._watershedNameTxt.setText(clientWorkspace.getTitleName());
        } else {
            this._watershedNameTxt.setText("");
        }
        this._currentWksp = clientWorkspace;
    }

    public void setConfigurationList(ConditionDataList objectArray, Study study) {
        this._study = study;
        this._conditionList = objectArray;
        objectArray = objectArray.getObjects();
        this.setConfigurationList(objectArray);
    }

    private void setConfigurationList(Object[] objectArray) {
        Vector<Condition> vector = new Vector<Condition>(objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            Condition condition;
            if (objectArray[i] == null || (condition = (Condition)objectArray[i]).isStudyCondition()) continue;
            vector.add(condition);
        }
        this._configurationCombo.setModel((ComboBoxModel)new RmaListModel(true, vector));
        if (this._configurationCombo.getItemCount() > 0) {
            this._configurationCombo.setSelectedIndex(0);
        }
    }

    private void configurationChanged() {
        Object object = this._configurationCombo.getSelectedItem();
        if (object instanceof Condition) {
            this.setConfiguration((Condition)object);
        }
    }

    private void setConfiguration(Condition condition) {
        Object object;
        Reservoir reservoir;
        int n;
        ComputationPoint computationPoint;
        this._configuration = condition;
        if (this._configuration == null) {
            this._configurationID = Long.MIN_VALUE;
            return;
        }
        this._configurationID = this._configuration.getId();
        condition = this._study;
        if (condition == null) {
            return;
        }
        Vector<String> vector = new Vector<String>();
        vector.add("");
        Object object2 = condition.getComputationPointList();
        if (object2 != null) {
            for (int i = 0; i < ((Object[])object2).length; ++i) {
                computationPoint = (ComputationPoint)object2[i];
                if (computationPoint == null || !computationPoint.getSnapToStream() || computationPoint.getStreamId() < 0) continue;
                vector.add((String)computationPoint);
            }
        }
        computationPoint = new Vector();
        computationPoint.add("");
        object2 = this._configuration.getProjects(Reservoir.class.getName());
        int n2 = ((Vector)object2).size();
        for (n = 0; n < n2; ++n) {
            reservoir = (Reservoir)((Vector)object2).elementAt(n);
            if (reservoir == null) continue;
            computationPoint.add(reservoir);
        }
        reservoir = new Vector();
        reservoir.add("");
        object2 = this._configuration.getProjects(Diversion.class.getName());
        n2 = ((Vector)object2).size();
        for (n = 0; n < n2; ++n) {
            object = (Diversion)((Vector)object2).elementAt(n);
            if (object == null) continue;
            reservoir.add(object);
        }
        this._junctionList = vector;
        this._reservoirList = computationPoint;
        this._diversionList = reservoir;
        this._networkTable.commitEdit(true);
        n2 = this._networkTable.getRowCount();
        for (n = 0; n < n2; ++n) {
            object = this._networkTable.getValueAt(n, 0);
            if (object instanceof JunctionElement) {
                this._networkTable.setComboBoxRowEditor(n, 2, vector);
                object2 = object.toString();
                int n3 = this.findName((String)object2, vector);
                if (n3 <= 0) continue;
                this._networkTable.setValueAt(vector.get(n3), n, 2);
                continue;
            }
            if (object instanceof ReservoirElement) {
                this._networkTable.setComboBoxRowEditor(n, 2, (Vector)computationPoint);
                object2 = object.toString();
                int n4 = this.findName((String)object2, (List)computationPoint);
                if (n4 <= 0) continue;
                this._networkTable.setValueAt(computationPoint.get(n4), n, 2);
                continue;
            }
            if (object instanceof DiversionElement) {
                this._networkTable.setComboBoxRowEditor(n, 2, (Vector)reservoir);
                object2 = object.toString();
                int n5 = this.findName((String)object2, (List)reservoir);
                if (n5 <= 0) continue;
                this._networkTable.setValueAt(reservoir.get(n5), n, 2);
                continue;
            }
            if (!(object instanceof ResolveComputationPointsPanel$ReservoirChildElement)) continue;
            object2 = (ResolveComputationPointsPanel$ReservoirChildElement)object;
            this._networkTable.setComboBoxRowEditor(n, 2, (Vector)reservoir);
            object2 = ((ResolveComputationPointsPanel$ReservoirChildElement)object2).a.toString();
            int n6 = this.findName((String)object2, (List)reservoir);
            if (n6 <= 0) continue;
            this._networkTable.setValueAt(reservoir.get(n6), n, 2);
        }
    }

    protected int findName(String string, List list) {
        int n = -1;
        if (string != null && list != null) {
            n = 0;
            int n2 = list.size();
            for (int i = 1; i < n2; ++i) {
                if (!string.equals(list.get(i).toString())) continue;
                return i;
            }
        }
        return n;
    }

    public void setImportFromNetwork(RssSystem object) {
        Object object2;
        int n;
        if (object == null) {
            this._selectedNetworkLabel.setText("Selected Network: ");
            return;
        }
        this._importFromNetwork = object;
        new Vector(0);
        Vector vector = ((RssSystem)object).getElementVector();
        this._selectedNetworkLabel.setText("Selected Network: " + object.getName());
        this._networkTableModel.clearNonEditableCells();
        this._networkTable.setColumnEnabled(false, 0);
        this._networkTable.setColumnEnabled(false, 1);
        this._networkTable.setColumnEnabled(true, 2);
        this._networkTable.getModel().removeTableModelListener(this._networkTableListener);
        this._networkTable.commitEdit(false);
        this._networkTable.deleteCells();
        this._networkTable.getColumnCount();
        int n2 = vector.size();
        for (n = 0; n < n2; ++n) {
            object2 = vector.get(n);
            if (object2 instanceof ReachElement) continue;
            object = (Element)object2;
            Object object3 = this.newRow(object);
            this._networkTable.appendRow((Vector)object3);
            if (!(object2 instanceof ReservoirElement)) continue;
            ReservoirElement reservoirElement = (ReservoirElement)object2;
            object = reservoirElement.getElementsByClass(DivertedOutletElement.class, null);
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                object3 = new ResolveComputationPointsPanel$ReservoirChildElement(reservoirElement, (Element)((Vector)object).get(i));
                object3 = this.newRow(object3);
                this._networkTable.appendRow((Vector)object3);
            }
        }
        n = this._configurationCombo.getItemCount();
        if (n > 0) {
            this._configurationCombo.removeItemListener(this._configComboItemListener);
            this._configurationCombo.setSelectedIndex(0);
            for (int i = 0; i < n; ++i) {
                object2 = this._configurationCombo.getItemAt(i);
                if (!(object2 instanceof Condition) || ((Condition)object2).getId() != this._importFromNetwork.getConfigurationId()) continue;
                this._configurationCombo.setSelectedIndex(i);
                break;
            }
            this.configurationChanged();
            this._configurationCombo.addItemListener(this._configComboItemListener);
        }
    }

    protected Vector newRow(Object object) {
        int n = this._networkTable.getColumnCount();
        String string = "";
        Vector<Object> vector = new Vector<Object>(n);
        vector.add(object);
        if (object instanceof Element) {
            string = ((Element)object).getElementType();
        } else if (object instanceof ResolveComputationPointsPanel$ReservoirChildElement) {
            string = ((ResolveComputationPointsPanel$ReservoirChildElement)object).a();
        }
        vector.add(string);
        vector.add("");
        return vector;
    }

    public void setNewNetworkName(String string) {
        if (string != null) {
            this._currentNetworkLabel.setText("New Network: " + string);
            return;
        }
        this._currentNetworkLabel.setText("New Network: ");
    }

    public List saveAssignments() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        this._networkTable.commitEdit(true);
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        this._networkTable.commitEdit(true);
        int n = this._networkTable.getRowCount();
        for (int i = 0; i < n; ++i) {
            Object object = this._networkTable.getValueAt(i, 0);
            Object object2 = this._networkTable.getValueAt(i, 2);
            if (object2 instanceof ComputationPoint || object2 instanceof Reservoir || object2 instanceof Diversion) {
                if (object instanceof ResolveComputationPointsPanel$ReservoirChildElement) {
                    hashMap.put(((ResolveComputationPointsPanel$ReservoirChildElement)object).a, object2);
                    continue;
                }
                hashMap.put(object, object2);
                continue;
            }
            arrayList.add(object);
        }
        this._cpMap = hashMap;
        return arrayList;
    }

    public HashMap getComputationPointMap() {
        this.saveAssignments();
        return this._cpMap;
    }

    public Condition getSelectedConfiguration() {
        return this._configuration;
    }

    public List getAssignedList() {
        Vector vector = new Vector(this._networkTable.getRowCount());
        int n = this._networkTable.getRowCount();
        for (int i = 0; i < n; ++i) {
            Vector<String> vector2 = this._networkTable.getValueAt(i, 0);
            Object object = this._networkTable.getValueAt(i, 2);
            String string = "";
            String string2 = "";
            if (!(object instanceof ComputationPoint) && !(object instanceof Reservoir) && !(object instanceof Diversion)) continue;
            if (vector2 instanceof ResolveComputationPointsPanel$ReservoirChildElement) {
                string = ((ResolveComputationPointsPanel$ReservoirChildElement)((Object)vector2)).toString();
                string2 = ((ResolveComputationPointsPanel$ReservoirChildElement)((Object)vector2)).a();
            } else if (vector2 instanceof Element) {
                string = ((Object)vector2).toString();
                string2 = ((Element)((Object)vector2)).getElementType();
            }
            vector2 = new Vector<String>(3);
            vector2.add(string);
            vector2.add(string2);
            vector2.add(object.toString());
            vector.add(vector2);
        }
        return vector;
    }

    public List getNotAssignedList() {
        Vector vector = new Vector(this._networkTable.getRowCount());
        int n = this._networkTable.getRowCount();
        for (int i = 0; i < n; ++i) {
            Vector<String> vector2 = this._networkTable.getValueAt(i, 0);
            Object object = this._networkTable.getValueAt(i, 2);
            String string = "";
            String string2 = "";
            if (!(object instanceof ComputationPoint || object instanceof Reservoir || object instanceof Diversion)) {
                if (vector2 instanceof ResolveComputationPointsPanel$ReservoirChildElement) {
                    string = ((ResolveComputationPointsPanel$ReservoirChildElement)((Object)vector2)).toString();
                    string2 = ((ResolveComputationPointsPanel$ReservoirChildElement)((Object)vector2)).a();
                } else if (vector2 instanceof Element) {
                    string = ((Object)vector2).toString();
                    string2 = ((Element)((Object)vector2)).getElementType();
                }
            }
            vector2 = new Vector<String>(2);
            vector2.add(string);
            vector2.add(string2);
            vector.add(vector2);
        }
        return vector;
    }

    public List getUnusedCpList() {
        Vector<String> vector;
        Object object;
        if (this._junctionList == null && this._reservoirList == null && this._diversionList == null) {
            return new ArrayList(0);
        }
        Vector vector2 = (Vector)this._junctionList.clone();
        Vector vector3 = (Vector)this._reservoirList.clone();
        Vector vector4 = (Vector)this._diversionList.clone();
        vector2.remove("");
        vector3.remove("");
        vector4.remove("");
        int n = this._networkTable.getRowCount();
        for (int i = 0; i < n; ++i) {
            object = this._networkTable.getValueAt(i, 2);
            if (vector2.contains(object)) {
                vector2.remove(object);
                continue;
            }
            if (vector3.contains(object)) {
                vector3.remove(object);
                continue;
            }
            if (!vector4.contains(object)) continue;
            vector4.remove(object);
        }
        Vector vector5 = new Vector();
        for (n = 0; n < vector2.size(); ++n) {
            object = vector2.get(n);
            vector = new Vector<String>(2);
            vector.add("Computation Point ");
            vector.add(object.toString());
            vector5.add(vector);
        }
        for (n = 0; n < vector3.size(); ++n) {
            object = vector3.get(n);
            vector = new Vector<String>(2);
            vector.add("Reservoir Project ");
            vector.add(object.toString());
            vector5.add(vector);
        }
        for (n = 0; n < vector4.size(); ++n) {
            object = vector4.get(n);
            vector = new Vector<String>(2);
            vector.add("Diversion Project ");
            vector.add(object.toString());
            vector5.add(vector);
        }
        return vector5;
    }
}

