/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.clientapp.client.ClientWorkspace;
import hec.clientapp.model.TSRecordProxy;
import hec.gui.WizardPanel;
import hec.lang.NamedType;
import hec.model.ModelVariable;
import hec.model.TSLocation;
import hec.rss.client.ImportNetworkDialog;
import hec.rss.client.ResolveNetworkPanel$1;
import hec.rss.client.ResolveNetworkPanel$2;
import hec.rss.client.ResolveNetworkPanel$3;
import hec.rss.client.ResolveNetworkPanel$ResolveNetworkTableModel;
import hec.rss.client.SelectElementDialog;
import hec.rss.model.Dam;
import hec.rss.model.DivertedOutletElement;
import hec.rss.model.Element;
import hec.rss.model.ElementAssignmentContainer;
import hec.rss.model.Function;
import hec.rss.model.IndependentVariable;
import hec.rss.model.IndependentVariableInfo;
import hec.rss.model.Junction;
import hec.rss.model.JunctionElement;
import hec.rss.model.ReleaseFuncOpRule;
import hec.rss.model.ReservoirDamElement;
import hec.rss.model.ReservoirElement;
import hec.rss.model.Routing;
import hec.rss.model.RssModelVariableSet;
import hec.rss.model.RssNode;
import hec.rss.model.RssSystem;
import hec.rss.model.RuleConnectivityRef;
import hec.rss.model.RuleResolution;
import hec.rss.model.Storage;
import hec.rss.model.StorageZone;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;
import rma.swing.RmaInsets;
import rma.swing.RmaJTable;
import rma.swing.RmaJTextField;
import rma.util.RMASort;

public class ResolveNetworkPanel
extends WizardPanel {
    public static final String PANEL_NAME = "ResolveElements";
    private JLabel _panelTitle;
    private RmaJTextField _watershedNameTxt;
    private RmaJTable _networkTable;
    private ResolveNetworkPanel$ResolveNetworkTableModel _networkTableModel;
    private JButton _selectElementButton;
    private JLabel _noResolvingLabel;
    private JPanel _cardPanel;
    private RssSystem _importFromNetwork;
    private SelectElementDialog _selectElementDialog;
    private Map<Integer, List> _elementListMap = new HashMap<Integer, List>();

    public ResolveNetworkPanel() {
        super((LayoutManager)new GridBagLayout());
        this.buildControls();
    }

    protected void buildControls() {
        this._panelTitle = new JLabel("Resolve Network Connectivity");
        Serializable serializable = this._panelTitle.getFont();
        this._panelTitle.setFont(new Font(serializable.getName(), 1, serializable.getSize()));
        serializable = new GridBagConstraints();
        new GridBagConstraints().gridwidth = 0;
        ((GridBagConstraints)serializable).weightx = 1.0;
        ((GridBagConstraints)serializable).anchor = 18;
        ((GridBagConstraints)serializable).fill = 2;
        ((GridBagConstraints)serializable).insets = RmaInsets.insets((int)4, (int)4, (int)4, (int)4);
        ResolveNetworkPanel resolveNetworkPanel = this;
        resolveNetworkPanel.add(resolveNetworkPanel._panelTitle, serializable);
        JComponent jComponent = new JLabel("Watershed:");
        serializable = new GridBagConstraints();
        new GridBagConstraints().gridwidth = -1;
        ((GridBagConstraints)serializable).anchor = 18;
        ((GridBagConstraints)serializable).fill = 0;
        ((GridBagConstraints)serializable).insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.add(jComponent, serializable);
        this._watershedNameTxt = new RmaJTextField();
        this._watershedNameTxt.setEditable(false);
        serializable = new GridBagConstraints();
        new GridBagConstraints().gridwidth = 0;
        ((GridBagConstraints)serializable).anchor = 18;
        ((GridBagConstraints)serializable).fill = 2;
        ((GridBagConstraints)serializable).insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        ResolveNetworkPanel resolveNetworkPanel2 = this;
        resolveNetworkPanel2.add((Component)resolveNetworkPanel2._watershedNameTxt, serializable);
        this._cardPanel = new JPanel(new CardLayout());
        serializable = new GridBagConstraints();
        new GridBagConstraints().weighty = 1.0;
        ((GridBagConstraints)serializable).weightx = 1.0;
        ((GridBagConstraints)serializable).gridwidth = 0;
        ((GridBagConstraints)serializable).anchor = 18;
        ((GridBagConstraints)serializable).fill = 1;
        ((GridBagConstraints)serializable).insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        ResolveNetworkPanel resolveNetworkPanel3 = this;
        resolveNetworkPanel3.add(resolveNetworkPanel3._cardPanel, serializable);
        jComponent = new JPanel(new GridBagLayout());
        this._cardPanel.add("table", jComponent);
        ResolveNetworkPanel resolveNetworkPanel4 = this;
        this._networkTable = new ResolveNetworkPanel$1(resolveNetworkPanel4, (Component)((Object)resolveNetworkPanel4), new String[]{"Import from\nNetwork Element", " \nRule", " \nReferences Element", "Select\nNetwork Element"});
        this._networkTableModel = new ResolveNetworkPanel$ResolveNetworkTableModel(this);
        this._networkTable.setModel((TableModel)((Object)this._networkTableModel));
        this._networkTable.setCellSelectionEnabled(false);
        this._networkTable.setRowSelectionAllowed(true);
        this._networkTable.setMlHeaderRenderer();
        this._networkTable.setAddRemoveEnabled(false);
        int n = this._networkTable.getRowHeight();
        this._networkTable.setRowHeight(n + 5);
        ((GridBagConstraints)serializable).gridx = 0;
        ((GridBagConstraints)serializable).gridy = 0;
        ((GridBagConstraints)serializable).weightx = 1.0;
        ((GridBagConstraints)serializable).weighty = 1.0;
        ((GridBagConstraints)serializable).anchor = 18;
        ((GridBagConstraints)serializable).fill = 1;
        ((GridBagConstraints)serializable).insets = RmaInsets.INSETS5505;
        jComponent.add((Component)this._networkTable.getScrollPane(), serializable);
        this._selectElementButton = new JButton("Select Network Element");
        this._selectElementButton.setEnabled(false);
        ((GridBagConstraints)serializable).gridx = 0;
        ((GridBagConstraints)serializable).gridy = 1;
        ((GridBagConstraints)serializable).weightx = 0.0;
        ((GridBagConstraints)serializable).weighty = 0.0;
        ((GridBagConstraints)serializable).anchor = 15;
        ((GridBagConstraints)serializable).fill = 0;
        ((GridBagConstraints)serializable).insets = RmaInsets.INSETS5505;
        jComponent.add((Component)this._selectElementButton, serializable);
        this._noResolvingLabel = new JLabel("<html><b>No Unresolved Network Connectivity</b></html>");
        this._noResolvingLabel.setHorizontalAlignment(0);
        this._cardPanel.add("label", this._noResolvingLabel);
        this._selectElementButton.addActionListener(new ResolveNetworkPanel$2(this));
        this._networkTable.getSelectionModel().addListSelectionListener(new ResolveNetworkPanel$3(this));
    }

    public void selectElementAction() {
        Object object;
        int n = this._networkTable.getSelectedRow();
        if (n == -1) {
            return;
        }
        Object object2 = n;
        object2 = this._elementListMap.get(object2);
        if (this._selectElementDialog == null) {
            object = (ImportNetworkDialog)((Object)SwingUtilities.windowForComponent((Component)((Object)this)));
            this._selectElementDialog = new SelectElementDialog((Dialog)object);
        }
        this._selectElementDialog.setElements((List)object2);
        this._selectElementDialog.setVisible(true);
        if (this._selectElementDialog.isCanceled()) {
            return;
        }
        object = this._selectElementDialog.getSelectedElement();
        int[] nArray = this._networkTable.getSelectedRows();
        boolean bl = false;
        this._networkTable.commitEdit(true);
        for (int i = 0; i < nArray.length; ++i) {
            object2 = new Integer(nArray[i]);
            if ((object2 = this._elementListMap.get(object2)) == null) continue;
            if (object2.contains(object)) {
                this._networkTable.setValueAt(object, nArray[i], 4);
                continue;
            }
            bl = true;
        }
        this._networkTable.repaint();
        if (bl) {
            JOptionPane.showMessageDialog((Component)((Object)this), "The selected Element was invalid for one or more rows.");
        }
    }

    public String getPanelName() {
        return PANEL_NAME;
    }

    public void setWorkspace(ClientWorkspace clientWorkspace) {
        if (clientWorkspace != null) {
            this._watershedNameTxt.setText(clientWorkspace.getTitleName());
            return;
        }
        this._watershedNameTxt.setText("");
    }

    public void setImportFromNetwork(RssSystem rssSystem) {
        this._importFromNetwork = rssSystem;
        for (int i = 0; i < this._networkTable.getRowCount(); ++i) {
            this._networkTable.setValueAt(null, i, 4);
        }
    }

    public void setImportToNetwork(RssSystem rssSystem) {
        for (int i = 0; i < this._networkTable.getRowCount(); ++i) {
        }
    }

    public void setSelectedElements(NamedType[] namedTypeArray) {
        for (int i = 0; i < namedTypeArray.length; ++i) {
            Element cfr_ignored_0 = (Element)namedTypeArray[i];
        }
    }

    public void setImportFromElements(List list) {
        this._elementListMap.clear();
        this._networkTable.clearAllComboBoxRowEditorValues(4);
        this._networkTable.commitEdit(false);
        this._networkTable.deleteCells();
        boolean bl = false;
        for (int i = 0; i < list.size(); ++i) {
            Object object = list.get(i);
            if (!(object instanceof ElementAssignmentContainer)) continue;
            ElementAssignmentContainer elementAssignmentContainer = (ElementAssignmentContainer)object;
            object = elementAssignmentContainer.b;
            if ((object = ((Element)object).getRuleConnectivityRefs()) == null || object.size() == 0) {
                this._networkTableModel.addRuleRef(null, elementAssignmentContainer);
                continue;
            }
            for (int j = 0; j < object.size(); ++j) {
                RuleConnectivityRef ruleConnectivityRef = (RuleConnectivityRef)object.get(j);
                this._networkTableModel.addRuleRef(ruleConnectivityRef, elementAssignmentContainer);
                this.fillSelectionCombo(elementAssignmentContainer.a, ruleConnectivityRef);
                bl = true;
            }
        }
        this._networkTable.repaint();
        if (bl && this._networkTableModel.getRowCount() > 0) {
            ((CardLayout)this._cardPanel.getLayout()).show(this._cardPanel, "table");
            return;
        }
        ((CardLayout)this._cardPanel.getLayout()).show(this._cardPanel, "label");
    }

    protected void fillSelectionCombo(Element vector, RuleConnectivityRef ruleConnectivityRef) {
        int n;
        String[] stringArray;
        if (ruleConnectivityRef == null || vector == null) {
            return;
        }
        Vector<String> vector2 = null;
        Object object = ((Element)((Object)vector)).getSystem();
        block0 : switch (ruleConnectivityRef.c()) {
            case 1: {
                vector2 = ((RssSystem)object).getNodeVector();
                break;
            }
            case 0: {
                vector2 = new Vector<String>();
                stringArray = new ArrayList<RssNode>();
                ((RssSystem)object).getDownstreamNodeList((Element)((Object)vector), (List<RssNode>)stringArray);
                vector2.addAll((Collection<String>)stringArray);
                break;
            }
            case 3: {
                vector = ((RssSystem)object).getElementVectorByClass(JunctionElement.class);
                vector2 = new Vector<String>(vector.size());
                for (n = 0; n < vector.size(); ++n) {
                    object = (JunctionElement)((Object)vector.get(n));
                    vector2.addAll(((Element)object).getDownstreamNodes(null));
                }
                break;
            }
            case 4: {
                vector = ((RssSystem)object).getElementVectorByClass(ReservoirElement.class);
                RMASort.quickSort(vector);
                vector.add(0, (ReservoirElement)((Object)""));
                int n2 = this._networkTable.getRowCount() - 1;
                this._networkTable.setComboBoxRowEditor(n2, 4, vector);
                this._elementListMap.put(n2, vector);
                if (ruleConnectivityRef.b() instanceof ReservoirElement) {
                    int n3;
                    ReservoirElement reservoirElement = (ReservoirElement)ruleConnectivityRef.b();
                    boolean bl = false;
                    for (n3 = 1; n3 < vector.size(); ++n3) {
                        ReservoirElement reservoirElement2 = vector.get(n3);
                        if (!reservoirElement.getName().equals(reservoirElement2.getName())) continue;
                        this._networkTable.setValueAt((Object)reservoirElement2, this._networkTable.getRowCount() - 1, 4);
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        for (n3 = 1; n3 < vector.size(); ++n3) {
                            ReservoirElement reservoirElement3 = vector.get(n3);
                            if (!reservoirElement.getName().equalsIgnoreCase(reservoirElement3.getName())) continue;
                            this._networkTable.setValueAt((Object)reservoirElement3, this._networkTable.getRowCount() - 1, 4);
                            return;
                        }
                    }
                }
                return;
            }
            case 2: {
                String string;
                vector2 = this.getModelVariableNodes((IndependentVariable)ruleConnectivityRef.b(), (Element)((Object)vector));
                if (vector2 == null || (string = ruleConnectivityRef.a() instanceof ReleaseFuncOpRule ? ((IndependentVariable)ruleConnectivityRef.b()).buildFunctionOfString((ReleaseFuncOpRule)ruleConnectivityRef.a()) : ((IndependentVariable)ruleConnectivityRef.b()).buildFunctionOfString((StorageZone)ruleConnectivityRef.a())) == null) break;
                for (int i = 0; i < vector2.size(); ++i) {
                    object = vector2.get(i).toString();
                    if (!((String)object).startsWith("[") || !((String)object).endsWith("]")) continue;
                    object = ((String)object).substring(1);
                    stringArray = ((String)(object = ((String)object).substring(0, ((String)object).length() - 1))).split(",");
                    if (stringArray == null || stringArray.length < 3 || string.indexOf(stringArray[0]) < 0 || string.indexOf(stringArray[2]) < 0) continue;
                    this._networkTable.setValueAt(vector2.get(i), this._networkTable.getRowCount() - 1, 4);
                    break block0;
                }
                break;
            }
            case 5: {
                vector2 = new Vector();
            }
        }
        if (vector2 != null) {
            RMASort.quickSort(vector2);
            vector2.add(0, "");
            int n4 = this._networkTable.getRowCount() - 1;
            this._networkTable.setComboBoxRowEditor(n4, 4, vector2);
            this._elementListMap.put(n4, vector2);
            if (ruleConnectivityRef.b() instanceof RssNode) {
                stringArray = (RssNode)ruleConnectivityRef.b();
                for (n = 1; n < vector2.size(); ++n) {
                    RssNode rssNode = (RssNode)vector2.get(n);
                    if (!stringArray.toString().equals(rssNode.toString())) continue;
                    this._networkTable.setValueAt((Object)rssNode, this._networkTable.getRowCount() - 1, 4);
                    return;
                }
                for (n = 1; n < vector2.size(); ++n) {
                    RssNode rssNode = (RssNode)vector2.get(n);
                    if (!stringArray.toString().equalsIgnoreCase(rssNode.toString())) continue;
                    this._networkTable.setValueAt((Object)rssNode, this._networkTable.getRowCount() - 1, 4);
                    return;
                }
            }
        }
    }

    public Vector getModelVariableNodes(IndependentVariable object, Element object2) {
        RssSystem rssSystem = ((Element)object2).getSystem();
        if (object2 instanceof ReservoirDamElement || object2 instanceof DivertedOutletElement) {
            object2 = ((Element)object2).getParent();
        }
        String string = ((Element)object2).getElementType();
        object = ((IndependentVariable)object).getModelVariable().toString();
        string = this.getFilterString(string);
        object = this.getFilterString((String)object);
        Vector vector = rssSystem.getActiveTSProxies(null, 1);
        vector = rssSystem.getActiveTSProxies(vector, 0);
        if (((Element)object2).getElementTypeId() == 1) {
            vector = this.filterProxyVec(vector, rssSystem);
        }
        int n = vector.size();
        Vector vector2 = new Vector(n);
        for (int i = 0; i < n; ++i) {
            TSRecordProxy tSRecordProxy = (TSRecordProxy)vector.elementAt(i);
            if (tSRecordProxy == null || (object2 = this.getElementForTSProxy(rssSystem, tSRecordProxy)) == null) continue;
            object2 = ((Element)object2).getTopParent();
            String string2 = ((Element)object2).getElementType();
            object2 = rssSystem.getNameForKeyString(tSRecordProxy.getName());
            tSRecordProxy.setFullName((String)object2);
            int n2 = tSRecordProxy.getVariableId();
            ModelVariable modelVariable = RssModelVariableSet.getModelVariable(n2);
            if (!this.passesFilter(string2, string) || !this.passesFilter(modelVariable.toString(), (String)object)) continue;
            Vector<Object> vector3 = new Vector<Object>(3);
            vector3.add(tSRecordProxy);
            vector3.add(string2);
            vector3.add(modelVariable);
            vector2.add(vector3);
        }
        return vector2;
    }

    private Element getElementForTSProxy(RssSystem rssReturnStatusConstants, TSRecordProxy tSRecordProxy) {
        if (tSRecordProxy == null) {
            return null;
        }
        if ((tSRecordProxy = tSRecordProxy.getParent()) == null) {
            return null;
        }
        if (tSRecordProxy instanceof Element) {
            rssReturnStatusConstants = (Element)tSRecordProxy;
        } else if (tSRecordProxy instanceof Function) {
            rssReturnStatusConstants = ((Function)tSRecordProxy).getElement();
        } else {
            if (tSRecordProxy instanceof RssNode) {
                rssReturnStatusConstants = ((RssNode)tSRecordProxy).getUpstreamElement();
                if (rssReturnStatusConstants != null && ((Element)rssReturnStatusConstants).isNodeComputed((RssNode)tSRecordProxy)) {
                    return rssReturnStatusConstants;
                }
                rssReturnStatusConstants = ((RssNode)tSRecordProxy).getDownstreamElement();
                if (rssReturnStatusConstants != null && ((Element)rssReturnStatusConstants).isNodeComputed((RssNode)tSRecordProxy)) {
                    return rssReturnStatusConstants;
                }
                return null;
            }
            rssReturnStatusConstants = null;
        }
        return rssReturnStatusConstants;
    }

    private Vector filterProxyVec(List list, RssSystem rssSystem) {
        Vector<TSRecordProxy> vector = new Vector<TSRecordProxy>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            TSRecordProxy tSRecordProxy = (TSRecordProxy)list.get(i);
            Object object = this.getElementForTSProxy(rssSystem, tSRecordProxy);
            if (object == null || !(object instanceof ReservoirDamElement) && !(object instanceof DivertedOutletElement) && !(((Element)object).getFunction() instanceof Storage) && !(((Element)object).getFunction() instanceof Junction) && !(((Element)object).getFunction() instanceof Dam) && !(((Element)object).getFunction() instanceof Routing)) continue;
            object = rssSystem.getNameForKeyString(tSRecordProxy.getName());
            if (((String)object).indexOf("Gate") >= 0) {
                System.out.println("filterProxyVec:proxy=" + tSRecordProxy.getName() + " " + tSRecordProxy.toString());
            }
            vector.add(tSRecordProxy);
        }
        return vector;
    }

    private boolean passesFilter(String string, String string2) {
        if (string2 == null || string2.length() == 0) {
            return true;
        }
        if (string == null) {
            return false;
        }
        return string.toLowerCase().startsWith(string2);
    }

    private String getFilterString(String string) {
        if (string != null) {
            return string.toLowerCase();
        }
        return "";
    }

    public boolean isValidPanel() {
        return true;
    }

    public List getRuleResolutionList() {
        this._networkTable.commitEdit(true);
        int n = this._networkTableModel.getItemCount();
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        for (int i = 0; i < n; ++i) {
            Object object = this._networkTableModel.getRuleRef(i);
            ElementAssignmentContainer elementAssignmentContainer = this._networkTableModel.getElements(i);
            Object object2 = this._networkTableModel.getCell(i, 4);
            if (object2 instanceof RssNode || object2 instanceof ReservoirElement) {
                object = new RuleResolution((RuleConnectivityRef)object, object2);
            } else if (object2 instanceof List) {
                List list = (List)object2;
                object2 = list.get(0);
                IndependentVariableInfo independentVariableInfo = new IndependentVariableInfo();
                new IndependentVariableInfo().a = (TSRecordProxy)object2;
                independentVariableInfo.c = (ModelVariable)list.get(2);
                independentVariableInfo.b = this.getElementForTSProxy(independentVariableInfo.a);
                object = new RuleResolution((RuleConnectivityRef)object, independentVariableInfo);
            } else {
                object = new RuleResolution((RuleConnectivityRef)object);
            }
            ((RuleResolution)object).b(elementAssignmentContainer);
            arrayList.add(object);
        }
        return arrayList;
    }

    private Element getElementForTSProxy(TSRecordProxy object) {
        if (object == null) {
            return null;
        }
        TSLocation tSLocation = object.getParent();
        if (tSLocation == null) {
            return null;
        }
        if (tSLocation instanceof Element) {
            object = (Element)tSLocation;
        } else if (tSLocation instanceof Function) {
            object = ((Function)tSLocation).getElement();
        } else if (tSLocation instanceof RssNode) {
            object = ((RssNode)tSLocation).getUpstreamElement();
            if (object == null) {
                object = ((RssNode)tSLocation).getDownstreamElement();
            }
        } else {
            object = null;
        }
        return object;
    }
}

