/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.rss.client.AdjustmentLimitsPanel;
import hec.rss.client.AdjustmentOptions;
import hec.rss.client.AdjustmentOptions$ZoneAdjustments;
import hec.rss.client.AdjustmentStrategyPanel;
import hec.rss.client.AskToSaveDialogBase;
import hec.rss.model.ReservoirElement;
import hec.rss.model.StorageZone;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import rma.swing.ButtonCmdPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJRadioButton;

public class ReverseReservoirYieldAdjustmentOptionsDialog
extends AskToSaveDialogBase {
    private JDialog _parent;
    private RmaJRadioButton _adjustTopOfConRadio;
    private RmaJRadioButton _adjustBottomOfConRadio;
    private AdjustmentStrategyPanel _adjustmentStrategyPanel;
    private AdjustmentLimitsPanel _limitsPanel;
    private RmaJComboBox _zoneAdjustmentCombo;

    ReverseReservoirYieldAdjustmentOptionsDialog(JDialog jDialog) {
        super(jDialog, true);
        this.setLayout(new GridBagLayout());
        this._parent = jDialog;
        this.setTitle("Adjustment Options");
        this.setSize(650, 300);
        this.buildControls();
        ReverseReservoirYieldAdjustmentOptionsDialog reverseReservoirYieldAdjustmentOptionsDialog = this;
        reverseReservoirYieldAdjustmentOptionsDialog.setLocationRelativeTo(reverseReservoirYieldAdjustmentOptionsDialog.getParent());
        this.setDefaultCloseOperation(0);
        this.addActionListeners();
    }

    private void buildControls() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)5, (int)5, (int)0);
        ReverseReservoirYieldAdjustmentOptionsDialog reverseReservoirYieldAdjustmentOptionsDialog = this;
        reverseReservoirYieldAdjustmentOptionsDialog.add(reverseReservoirYieldAdjustmentOptionsDialog.createAdjustConservationPoolDirectionPanel(), gridBagConstraints);
        this._adjustmentStrategyPanel = new AdjustmentStrategyPanel();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)5, (int)5, (int)0);
        ReverseReservoirYieldAdjustmentOptionsDialog reverseReservoirYieldAdjustmentOptionsDialog2 = this;
        reverseReservoirYieldAdjustmentOptionsDialog2.add(reverseReservoirYieldAdjustmentOptionsDialog2._adjustmentStrategyPanel, gridBagConstraints);
        this._limitsPanel = new AdjustmentLimitsPanel(this._parent);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)5, (int)5, (int)0);
        ReverseReservoirYieldAdjustmentOptionsDialog reverseReservoirYieldAdjustmentOptionsDialog3 = this;
        reverseReservoirYieldAdjustmentOptionsDialog3.add(reverseReservoirYieldAdjustmentOptionsDialog3._limitsPanel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)5, (int)5, (int)0);
        ReverseReservoirYieldAdjustmentOptionsDialog reverseReservoirYieldAdjustmentOptionsDialog4 = this;
        reverseReservoirYieldAdjustmentOptionsDialog4.add(reverseReservoirYieldAdjustmentOptionsDialog4.createZoneAdjustmentPanel(), gridBagConstraints);
        this._cmdButtonPanel = new ButtonCmdPanel(12);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)5, (int)5, (int)5);
        ReverseReservoirYieldAdjustmentOptionsDialog reverseReservoirYieldAdjustmentOptionsDialog5 = this;
        reverseReservoirYieldAdjustmentOptionsDialog5.add((Component)reverseReservoirYieldAdjustmentOptionsDialog5._cmdButtonPanel, gridBagConstraints);
    }

    public void fill(AdjustmentOptions adjustmentOptions, Vector<StorageZone> vector, ReservoirElement reservoirElement) {
        if (adjustmentOptions == null) {
            return;
        }
        boolean bl = adjustmentOptions.g();
        this._adjustTopOfConRadio.setSelected(bl);
        this._adjustBottomOfConRadio.setSelected(!bl);
        this._adjustmentStrategyPanel.fillPanel(adjustmentOptions);
        this._limitsPanel.fillPanel(adjustmentOptions, vector, reservoirElement);
        this._zoneAdjustmentCombo.setSelectedItem((Object)adjustmentOptions.n());
        this.setModified(false);
    }

    public void setModified(boolean bl) {
    }

    private JPanel createZoneAdjustmentPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel("Adjacent Zone Adjustments:");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this._zoneAdjustmentCombo = new RmaJComboBox((Object[])AdjustmentOptions$ZoneAdjustments.values());
        this._zoneAdjustmentCombo.setModifiable(true);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        jPanel.add((Component)this._zoneAdjustmentCombo, gridBagConstraints);
        return jPanel;
    }

    private JPanel createAdjustConservationPoolDirectionPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this._adjustTopOfConRadio = new RmaJRadioButton("Adjust Top of Conservation Pool");
        this._adjustTopOfConRadio.setToolTipText("<html>To optimize the water supply storage required to satisfy the demand rules required by this alternative, <br>the Reverse Yield Analysis will automatically adjust the Top of the Conservation Pool per the adjustment <br>strategy and limits defined below.</html>");
        this._adjustTopOfConRadio.setSelected(true);
        Serializable serializable = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        ((GridBagConstraints)serializable).gridy = 0;
        ((GridBagConstraints)serializable).weightx = 0.0;
        ((GridBagConstraints)serializable).weighty = 0.0;
        ((GridBagConstraints)serializable).anchor = 18;
        ((GridBagConstraints)serializable).fill = 2;
        ((GridBagConstraints)serializable).insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        jPanel.add((Component)this._adjustTopOfConRadio, serializable);
        this._adjustBottomOfConRadio = new RmaJRadioButton("Adjust Bottom of Conservation Pool");
        this._adjustBottomOfConRadio.setToolTipText("<html>To optimize the water supply storage required to satisfy the demand rules required by this alternative, <br>the Reverse Yield Analysis will automatically adjust the Bottom of the Conservation Pool per the adjustment <br>strategy and limits defined below.</html>");
        serializable = new GridBagConstraints();
        new GridBagConstraints().gridx = 2;
        ((GridBagConstraints)serializable).gridy = 0;
        ((GridBagConstraints)serializable).weightx = 1.0;
        ((GridBagConstraints)serializable).weighty = 1.0;
        ((GridBagConstraints)serializable).anchor = 18;
        ((GridBagConstraints)serializable).fill = 2;
        ((GridBagConstraints)serializable).insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        jPanel.add((Component)this._adjustBottomOfConRadio, serializable);
        serializable = new ButtonGroup();
        ((ButtonGroup)serializable).add((AbstractButton)this._adjustBottomOfConRadio);
        ((ButtonGroup)serializable).add((AbstractButton)this._adjustTopOfConRadio);
        return jPanel;
    }

    AdjustmentOptions getAdjustmentOptions() {
        AdjustmentOptions adjustmentOptions = new AdjustmentOptions();
        adjustmentOptions.a(this._adjustTopOfConRadio.isSelected());
        adjustmentOptions.a(this._adjustmentStrategyPanel.getAdjustmentStrategy());
        adjustmentOptions.b(this._adjustmentStrategyPanel.getExcludePeriod());
        adjustmentOptions.a(this._adjustmentStrategyPanel.getStartDate());
        adjustmentOptions.b(this._adjustmentStrategyPanel.getEndDate());
        adjustmentOptions.a(this._limitsPanel.getMaxLimitType());
        adjustmentOptions.b(this._limitsPanel.getMinLimitType());
        adjustmentOptions.b(this._limitsPanel.getMaxElevation());
        adjustmentOptions.a(this._limitsPanel.getMinElevation());
        adjustmentOptions.d(this._limitsPanel.getMaxStorage());
        adjustmentOptions.c(this._limitsPanel.getMinStorage());
        StorageZone storageZone = this._limitsPanel.getMinZone();
        if (storageZone != null) {
            adjustmentOptions.a(this._limitsPanel.getMinZone().getIndex());
        } else {
            adjustmentOptions.a(-1);
        }
        storageZone = this._limitsPanel.getMaxZone();
        if (storageZone != null) {
            adjustmentOptions.b(this._limitsPanel.getMaxZone().getIndex());
        } else {
            adjustmentOptions.b(-1);
        }
        adjustmentOptions.a((AdjustmentOptions$ZoneAdjustments)((Object)this._zoneAdjustmentCombo.getSelectedItem()));
        return adjustmentOptions;
    }
}

