/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.clientapp.client.ClientApp;
import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.lang.NamedType;
import hec.rss.client.AlternativeEditor;
import hec.rss.client.ReverseYieldDemandWAccountPanel;
import hec.rss.client.YieldAnalysisPanelBase;
import hec.rss.model.ReverseWaterAccountYieldAnalysis;
import hec.rss.model.ReverseYieldAnalysisBase;
import hec.rss.model.RssAlt;
import hec.rss.model.WaterAccount;
import hec.rss.model.WaterAccountSet;
import hec.rss.model.YieldAnalysis;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.util.ArrayList;
import javax.swing.ComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import rma.services.ServiceLookup;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJIntegerField;
import rma.swing.RmaJLabel;
import rma.swing.RmaJPanel;
import rma.swing.list.RmaListModel;

public class ReverseWaterAccountYieldAnalysisPanel
extends YieldAnalysisPanelBase {
    private RmaJComboBox<WaterAccount> _waterAccountCombo;
    private RmaJDecimalField _accountToleranceField;

    ReverseWaterAccountYieldAnalysisPanel(AlternativeEditor alternativeEditor) {
        super(alternativeEditor);
        this.buildControls();
        this.addActionListener();
    }

    private void addActionListener() {
        super.addClearAllActionListener();
        this._waterAccountCombo.addActionListener(actionEvent -> this.waterAccountComboAction());
    }

    private void buildControls() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        RmaJPanel rmaJPanel = new RmaJPanel((LayoutManager)new GridBagLayout());
        rmaJPanel.setBorder((Border)new TitledBorder("Select a Water Account Storage Volume to Optimize"));
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)5, (int)0, (int)5);
        rmaJPanel.add((Component)this.createTopRowPanel(), (Object)gridBagConstraints);
        this._demPanel = new ReverseYieldDemandWAccountPanel(this._editor);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        rmaJPanel.add((Component)this._demPanel, (Object)gridBagConstraints);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        this.add((Component)rmaJPanel, gridBagConstraints);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.001;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        ReverseWaterAccountYieldAnalysisPanel reverseWaterAccountYieldAnalysisPanel = this;
        reverseWaterAccountYieldAnalysisPanel.add((Component)reverseWaterAccountYieldAnalysisPanel.createMaxIterationsPanel(), gridBagConstraints);
    }

    private RmaJPanel createTopRowPanel() {
        RmaJPanel rmaJPanel = new RmaJPanel((LayoutManager)new GridBagLayout());
        JLabel jLabel = new JLabel("Water Account:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        rmaJPanel.add((Component)jLabel, (Object)gridBagConstraints);
        this._waterAccountCombo = new RmaJComboBox();
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        rmaJPanel.add(this._waterAccountCombo, (Object)gridBagConstraints);
        jLabel = new RmaJLabel("Tolerance (%S):");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        rmaJPanel.add((Component)jLabel, (Object)gridBagConstraints);
        this._accountToleranceField = new RmaJDecimalField();
        this._accountToleranceField.setMinValue(0.0);
        this._accountToleranceField.setEmptyOk(false);
        this._accountToleranceField.setDisplayUnitsSystem(ServiceLookup.getUnitsDisplayService().getDisplayUnitsSystem());
        jLabel.setLabelFor((Component)this._accountToleranceField);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        rmaJPanel.add((Component)this._accountToleranceField, (Object)gridBagConstraints);
        return rmaJPanel;
    }

    private JPanel createMaxIterationsPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel("Maximum Iterations:");
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS0000;
        jPanel.add((Component)jLabel, gridBagConstraints);
        this._maxIterationFld = new RmaJIntegerField();
        this._maxIterationFld.setMinValue(0);
        jLabel.setLabelFor((Component)this._maxIterationFld);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        jPanel.add((Component)this._maxIterationFld, gridBagConstraints);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        jPanel.add((Component)this._clearAll, gridBagConstraints);
        return jPanel;
    }

    public void fillPanel(NamedType object) {
        if (!(object instanceof RssAlt)) {
            return;
        }
        this._alternative = (RssAlt)object;
        object = this._alternative.getReverseWaterAccountYieldAnalysis();
        ((ReverseYieldDemandWAccountPanel)this._demPanel).fillPanel((ReverseWaterAccountYieldAnalysis)object, this._alternative);
        this.fillAccountCombo();
        if (object == null) {
            this._accountToleranceField.setValue(new ParamDouble(100.0, Parameter.PARAMID_STOR, this._alternative.getUnitSystem()));
            return;
        }
        this.setSelectedWaterAccountComboValue((ReverseWaterAccountYieldAnalysis)object);
        this._accountToleranceField.setValue(((ReverseYieldAnalysisBase)object).p());
        this._maxIterationFld.setValue(((YieldAnalysis)object).getMaxIterations());
    }

    private void waterAccountComboAction() {
        if (this._waterAccountCombo.getSelectedItem() instanceof WaterAccount) {
            this._demPanel.clearPanel();
            ((ReverseYieldDemandWAccountPanel)this._demPanel).fillTable((WaterAccount)this._waterAccountCombo.getSelectedItem());
        }
    }

    private void setSelectedWaterAccountComboValue(ReverseWaterAccountYieldAnalysis cloneable) {
        WaterAccountSet waterAccountSet = this._alternative.getWaterAccountSet();
        if (waterAccountSet != null && (cloneable = waterAccountSet.getWaterAccountSet(cloneable.c())) != null) {
            this._waterAccountCombo.setSelectedItem((Object)cloneable);
        }
    }

    private void fillAccountCombo() {
        WaterAccountSet waterAccountSet = this._alternative.getWaterAccountSet();
        ArrayList<WaterAccount> arrayList = new ArrayList<WaterAccount>();
        if (waterAccountSet != null && waterAccountSet.getWaterAccounts() != null && !waterAccountSet.getWaterAccounts().isEmpty()) {
            for (int i = 0; i < waterAccountSet.getWaterAccounts().size(); ++i) {
                WaterAccount waterAccount = waterAccountSet.getWaterAccounts().get(i);
                if (waterAccount == null) continue;
                arrayList.add(waterAccount);
            }
        }
        this._waterAccountCombo.setModel((ComboBoxModel)new RmaListModel(false, arrayList));
        if (waterAccountSet != null && !waterAccountSet.getWaterAccounts().isEmpty()) {
            this._waterAccountCombo.setSelectedIndex(0);
        }
    }

    public boolean savePanel(RssAlt rssAlt) {
        ReverseWaterAccountYieldAnalysis reverseWaterAccountYieldAnalysis = new ReverseWaterAccountYieldAnalysis(rssAlt);
        reverseWaterAccountYieldAnalysis.setMaxIterations(this._maxIterationFld.getValue());
        reverseWaterAccountYieldAnalysis.c(new ParamDouble(this._accountToleranceField.getValue(), Parameter.PARAMID_STOR, rssAlt.getUnitSystem()));
        if (this._waterAccountCombo.getSelectedItem() instanceof WaterAccount) {
            reverseWaterAccountYieldAnalysis.a(((WaterAccount)this._waterAccountCombo.getSelectedItem()).getIndex());
        }
        ((ReverseYieldDemandWAccountPanel)this._demPanel).savePanel(reverseWaterAccountYieldAnalysis);
        rssAlt.setReverseWaterAccountYieldAnalysis(reverseWaterAccountYieldAnalysis);
        return true;
    }

    public void clearPanel() {
        this._demPanel.clearPanel();
        this._accountToleranceField.setValue(new ParamDouble(0.0, Parameter.PARAMID_STOR, ClientApp.Workspace().getUnitSystem()));
        this._maxIterationFld.setValue(25);
        this._waterAccountCombo.setSelectedIndex(-1);
    }
}

