/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.clientapp.client.ClientApp;
import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.lang.NamedType;
import hec.rss.client.AdjustmentOptions;
import hec.rss.client.AlternativeEditor;
import hec.rss.client.ReservoirYieldDemandPanelBase;
import hec.rss.client.ReverseReservoirTableRowItem;
import hec.rss.client.ReverseReservoirYieldAdjustmentOptionsDialog;
import hec.rss.client.ReverseYieldDemandRulePanel$1;
import hec.rss.client.UneditableDecimalField;
import hec.rss.client.UneditableTextField;
import hec.rss.model.OpSet;
import hec.rss.model.ReservoirElement;
import hec.rss.model.ReservoirOp;
import hec.rss.model.ReverseReservoirYieldAnalysis;
import hec.rss.model.RssAlt;
import hec.rss.model.StorageZone;
import hec.rss.model.StorageZoneRef;
import hec.rss.model.YieldAnalysisRuleRef;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import rma.services.ServiceLookup;
import rma.swing.RmaInsets;
import rma.swing.RmaJButton;
import rma.swing.RmaJLabel;
import rma.swing.RmaJPanel;
import rma.swing.table.ToolTipHeader;
import rma.util.RMAConst;
import rma.util.RMAUtil;

public class ReverseYieldDemandRulePanel
extends ReservoirYieldDemandPanelBase {
    private RmaJButton _adjustmentOptionsBtn;
    private AdjustmentOptions _selectedAdjustmentOptions;
    private UneditableTextField _adjustmentLevelField;
    private UneditableTextField _seasonalCurveField;
    private UneditableDecimalField _maxLimitField;
    private UneditableTextField _adjacentZoneField;
    private UneditableDecimalField _minLimitField;
    private UneditableTextField _maxLimitZoneField;
    private UneditableTextField _minLimitZoneField;
    private RmaJPanel _minLimitCardPanel;
    private RmaJPanel _maxLimitCardPanel;
    private RmaJLabel _minAdjLimitLabel;
    private RmaJLabel _maxAdjLimitLabel;
    private List<ReverseReservoirTableRowItem> _resTableRows = new ArrayList<ReverseReservoirTableRowItem>();
    private Vector<ReservoirElement> _resElems;

    ReverseYieldDemandRulePanel(AlternativeEditor alternativeEditor) {
        super(alternativeEditor);
        this.setBorder(new TitledBorder("Select Reservoir Storage Level to Optimize"));
        this._ruleRefList = new ArrayList<YieldAnalysisRuleRef>();
        this.buildControls();
        this.addListeners();
    }

    private void buildResTable() {
        int n = ClientApp.app().getClientUnitSystem();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        ReverseYieldDemandRulePanel reverseYieldDemandRulePanel = this;
        this._resZoneTable = new ReverseYieldDemandRulePanel$1(reverseYieldDemandRulePanel, reverseYieldDemandRulePanel, new String[]{"Reservoir", "Operations Set", "Lower Limit \nof Con Pool", "Tolerance (%S)"});
        Object[] objectArray = new String[]{"Reservoir", "Operations Set", "<html>The top of the conservation pool is the designated guide curve level<br> in the operation set. The lower limit of the conservation to be<br> used in this Yield Analysis is the user specified selection in this field.<html>", "Tolerance (%S)"};
        ToolTipHeader toolTipHeader = new ToolTipHeader(this._resZoneTable.getColumnModel());
        toolTipHeader.setToolTipStrings(objectArray);
        this._resZoneTable.setTableHeader((JTableHeader)toolTipHeader);
        this._resZoneTable.setEditable(true);
        this._resZoneTable.setAddRemoveEnabled(false);
        this._resZoneTable.setRowHeight(this._resZoneTable.getRowHeight() + 5);
        this._resZoneTable.deleteCells();
        this._resZoneTable.removePopupMenuSumOptions();
        this._resZoneTable.removePopuMenuFillOptions();
        this._resZoneTable.setColumnEnabled(true, 0);
        this._resZoneTable.setColumnEnabled(false, 1);
        this._resZoneTable.setUnitsHeaderRenderer();
        objectArray = this._resZoneTable.setDoubleCellEditor(3, true);
        objectArray.setMinValue(0.0);
        objectArray.setEmptyOk(false);
        objectArray = new int[]{-1, -1, -1, Parameter.PARAMID_STOR};
        this._resZoneTable.setColumnParameters((int[])objectArray);
        this._resZoneTable.setDisplayUnitsSystem(n);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)5, (int)0, (int)5);
        ReverseYieldDemandRulePanel reverseYieldDemandRulePanel2 = this;
        reverseYieldDemandRulePanel2.add((Component)reverseYieldDemandRulePanel2._resZoneTable.getScrollPane(), gridBagConstraints);
    }

    private void buildTheSelectedRulesTable() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        ReverseYieldDemandRulePanel reverseYieldDemandRulePanel = this;
        reverseYieldDemandRulePanel.add((Component)reverseYieldDemandRulePanel._selectedRulesTable.getScrollPane(), gridBagConstraints);
    }

    public void buildControls() {
        this.buildResTable();
        JPanel jPanel = this.createSummaryOptionsPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)0, (int)5, (int)0);
        this.add((Component)jPanel, gridBagConstraints);
        this.buildTheSelectedRulesTable();
    }

    private JPanel createSummaryOptionsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        RmaJLabel rmaJLabel = new RmaJLabel("Adjustment Level:");
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        jPanel.add((Component)rmaJLabel, gridBagConstraints);
        this._adjustmentLevelField = new UneditableTextField();
        this._adjustmentLevelField.setEditable(false);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        jPanel.add((Component)((Object)this._adjustmentLevelField), gridBagConstraints);
        rmaJLabel = new RmaJLabel("Seasonal Curve Strategy:");
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        jPanel.add((Component)rmaJLabel, gridBagConstraints);
        this._seasonalCurveField = new UneditableTextField();
        this._seasonalCurveField.setEditable(false);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        jPanel.add((Component)((Object)this._seasonalCurveField), gridBagConstraints);
        this._maxAdjLimitLabel = new RmaJLabel("Max Adjustment Limit (%S):");
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        jPanel.add((Component)this._maxAdjLimitLabel, gridBagConstraints);
        this._maxLimitCardPanel = new RmaJPanel((LayoutManager)new CardLayout());
        this._maxLimitCardPanel.add("maxDecimalField", (Component)this.createMaxLimitDecimalPanel());
        this._maxLimitCardPanel.add("maxZoneField", (Component)this.createMaxLimitZonePanel());
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        jPanel.add((Component)this._maxLimitCardPanel, gridBagConstraints);
        rmaJLabel = new RmaJLabel("Adjacent Zone Strategy:");
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        jPanel.add((Component)rmaJLabel, gridBagConstraints);
        this._adjacentZoneField = new UneditableTextField();
        this._adjacentZoneField.setEditable(false);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        jPanel.add((Component)((Object)this._adjacentZoneField), gridBagConstraints);
        this._minAdjLimitLabel = new RmaJLabel("Min Adjustment Limit (%S):");
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        jPanel.add((Component)this._minAdjLimitLabel, gridBagConstraints);
        this._minLimitCardPanel = new RmaJPanel((LayoutManager)new CardLayout());
        this._minLimitCardPanel.add("minDecimalField", (Component)this.createMinLimitDecimalPanel());
        this._minLimitCardPanel.add("minZoneField", (Component)this.createMinLimitZonePanel());
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        jPanel.add((Component)this._minLimitCardPanel, gridBagConstraints);
        this._adjustmentOptionsBtn = new RmaJButton("Edit Adjustment Options...");
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        jPanel.add((Component)this._adjustmentOptionsBtn, gridBagConstraints);
        return jPanel;
    }

    private RmaJPanel createMinLimitZonePanel() {
        RmaJPanel rmaJPanel = new RmaJPanel((LayoutManager)new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this._minLimitZoneField = new UneditableTextField();
        this._minLimitZoneField.setEditable(false);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        rmaJPanel.add((Component)((Object)this._minLimitZoneField), (Object)gridBagConstraints);
        return rmaJPanel;
    }

    private RmaJPanel createMaxLimitZonePanel() {
        RmaJPanel rmaJPanel = new RmaJPanel((LayoutManager)new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this._maxLimitZoneField = new UneditableTextField();
        this._maxLimitZoneField.setEditable(false);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        rmaJPanel.add((Component)((Object)this._maxLimitZoneField), (Object)gridBagConstraints);
        return rmaJPanel;
    }

    private RmaJPanel createMinLimitDecimalPanel() {
        this._minLimitField = new UneditableDecimalField();
        ReverseYieldDemandRulePanel reverseYieldDemandRulePanel = this;
        return reverseYieldDemandRulePanel.createLimitDecimalPanel(reverseYieldDemandRulePanel._minLimitField, this._minAdjLimitLabel);
    }

    private RmaJPanel createMaxLimitDecimalPanel() {
        this._maxLimitField = new UneditableDecimalField();
        ReverseYieldDemandRulePanel reverseYieldDemandRulePanel = this;
        return reverseYieldDemandRulePanel.createLimitDecimalPanel(reverseYieldDemandRulePanel._maxLimitField, this._maxAdjLimitLabel);
    }

    private RmaJPanel createLimitDecimalPanel(UneditableDecimalField uneditableDecimalField, RmaJLabel rmaJLabel) {
        RmaJPanel rmaJPanel = new RmaJPanel((LayoutManager)new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        uneditableDecimalField.setEditable(false);
        rmaJLabel.setLabelFor((Component)((Object)uneditableDecimalField));
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        rmaJPanel.add((Component)((Object)uneditableDecimalField), (Object)gridBagConstraints);
        return rmaJPanel;
    }

    protected void addListeners() {
        this._adjustmentOptionsBtn.addActionListener(actionEvent -> this.launchAdjustmentOptions());
        this._resZoneTable.getModel().addTableModelListener(this::resZoneTableChanged);
    }

    private void resZoneTableChanged(TableModelEvent tableModelEvent) {
        if (tableModelEvent.getColumn() == 0) {
            this.reservoirSelectionChanged();
            return;
        }
        if (tableModelEvent.getColumn() == 2) {
            this.zoneSelectionChanged();
            return;
        }
        if (tableModelEvent.getColumn() == 3) {
            this.toleranceChanged();
        }
    }

    private void launchAdjustmentOptions() {
        if (this._selectedReservoir != null) {
            ReverseReservoirYieldAdjustmentOptionsDialog reverseReservoirYieldAdjustmentOptionsDialog = new ReverseReservoirYieldAdjustmentOptionsDialog((JDialog)((Object)this._editor));
            reverseReservoirYieldAdjustmentOptionsDialog.fill(this._selectedAdjustmentOptions, this.getZonesFromSelectedReservoir(), this._selectedReservoir);
            reverseReservoirYieldAdjustmentOptionsDialog.setVisible(true);
            if (!reverseReservoirYieldAdjustmentOptionsDialog.wasCanceled()) {
                RMAUtil.setParentModified((Component)this);
                this._selectedAdjustmentOptions = reverseReservoirYieldAdjustmentOptionsDialog.getAdjustmentOptions();
                ReverseYieldDemandRulePanel reverseYieldDemandRulePanel = this;
                reverseYieldDemandRulePanel.fillSummaryOptions(reverseYieldDemandRulePanel._selectedAdjustmentOptions);
            }
        }
    }

    private Vector<StorageZone> getZonesFromSelectedReservoir() {
        OpSet opSet;
        ReservoirOp reservoirOp;
        int n;
        if (this._selectedReservoir != null && (n = this._alternative.getResOpSetSelection(this._selectedReservoir.getIndex())) != Integer.MIN_VALUE && (reservoirOp = this._selectedReservoir.getReservoirOp()) != null && (opSet = reservoirOp.getOperationSet(n)) != null) {
            return opSet.getZoneVector();
        }
        return new Vector<StorageZone>();
    }

    private ReverseReservoirTableRowItem getResTableRowItem(ReservoirElement reservoirElement) {
        for (ReverseReservoirTableRowItem reverseReservoirTableRowItem : this._resTableRows) {
            if (reverseReservoirTableRowItem.b().getIndex() != reservoirElement.getIndex()) continue;
            return reverseReservoirTableRowItem;
        }
        return null;
    }

    private void updateResTable(ReservoirElement namedType) {
        ReverseReservoirTableRowItem reverseReservoirTableRowItem = this.getResTableRowItem((ReservoirElement)namedType);
        if (reverseReservoirTableRowItem == null) {
            return;
        }
        this._resZoneTable.deleteCells();
        Vector<Cloneable> vector = new Vector<Cloneable>(4);
        vector.add((Cloneable)namedType);
        int n = this._alternative.getResOpSetSelection(namedType.getIndex());
        namedType = namedType.getReservoirOp().getOperationSet(n);
        if (namedType == null) {
            return;
        }
        vector.add((Cloneable)namedType);
        vector.add(reverseReservoirTableRowItem.a());
        vector.add((Cloneable)reverseReservoirTableRowItem.d());
        this._resZoneTable.setComboBoxEditor(2, reverseReservoirTableRowItem.a());
        this._resZoneTable.appendRow(vector);
        this._resZoneTable.setValueAt((Object)reverseReservoirTableRowItem.c(), 0, 2);
    }

    private void toleranceChanged() {
        if (this._selectedReservoir == null) {
            return;
        }
        ReverseYieldDemandRulePanel reverseYieldDemandRulePanel = this;
        ReverseReservoirTableRowItem reverseReservoirTableRowItem = reverseYieldDemandRulePanel.getResTableRowItem(reverseYieldDemandRulePanel._selectedReservoir);
        if (reverseReservoirTableRowItem != null) {
            reverseReservoirTableRowItem.a(this.getTolerance());
        }
    }

    private void zoneSelectionChanged() {
        StorageZone storageZone = this.getSelectedZone();
        if (this._selectedReservoir == null || storageZone == null) {
            return;
        }
        ReverseYieldDemandRulePanel reverseYieldDemandRulePanel = this;
        ReverseReservoirTableRowItem reverseReservoirTableRowItem = reverseYieldDemandRulePanel.getResTableRowItem(reverseYieldDemandRulePanel._selectedReservoir);
        if (reverseReservoirTableRowItem != null) {
            reverseReservoirTableRowItem.a(storageZone);
        }
    }

    private void reservoirSelectionChanged() {
        this._selectedReservoir = this.getSelectedReservoir();
        ReverseYieldDemandRulePanel reverseYieldDemandRulePanel = this;
        reverseYieldDemandRulePanel.updateResTable(reverseYieldDemandRulePanel._selectedReservoir);
        this._selectedRulesTable.deleteCells();
        this._ruleRefList.clear();
        ReverseYieldDemandRulePanel reverseYieldDemandRulePanel2 = this;
        Object object = reverseYieldDemandRulePanel2.getAllReservoirRules(reverseYieldDemandRulePanel2._alternative.getReverseReservoirYieldAnalysis());
        if (object != null && !object.isEmpty()) {
            object = object.iterator();
            while (object.hasNext()) {
                YieldAnalysisRuleRef yieldAnalysisRuleRef = (YieldAnalysisRuleRef)object.next();
                int n = yieldAnalysisRuleRef.getRule().getIndex();
                if (this._satisfyMap.containsKey(n)) {
                    n = this._satisfyMap.get(n).booleanValue() ? 1 : 0;
                    this.addRuleToSelectedRulesTable(yieldAnalysisRuleRef, n != 0);
                    continue;
                }
                this.addRuleToSelectedRulesTable(yieldAnalysisRuleRef);
            }
        }
    }

    private void addRuleToSelectedRulesTable(YieldAnalysisRuleRef yieldAnalysisRuleRef) {
        this.addRuleToSelectedRulesTable(yieldAnalysisRuleRef, true);
    }

    private void createResTableRowItems(RssAlt object) {
        this._resTableRows = new ArrayList<ReverseReservoirTableRowItem>();
        object = ((RssAlt)object).getSystem().getElementVectorByClass(ReservoirElement.class);
        this._resElems = object;
        object = ((Vector)object).iterator();
        while (object.hasNext()) {
            ReservoirElement reservoirElement = (ReservoirElement)object.next();
            this.createResTableRowItem(reservoirElement);
        }
    }

    private void createResTableRowItem(ReservoirElement reservoirElement) {
        int n = this._alternative.getResOpSetSelection(reservoirElement.getIndex());
        Object object = reservoirElement.getReservoirOp().getOperationSet(n);
        if (object == null) {
            return;
        }
        object = ((OpSet)object).getZoneVector();
        ParamDouble paramDouble = new ParamDouble(1000.0, Parameter.PARAMID_STOR, this._alternative.getUnitSystem());
        StorageZone storageZone = null;
        if (!((Vector)object).isEmpty()) {
            storageZone = (StorageZone)((Vector)object).get(0);
        }
        this._resTableRows.add(new ReverseReservoirTableRowItem(reservoirElement, (Vector<StorageZone>)object, storageZone, paramDouble));
    }

    private void fillSummaryOptions(AdjustmentOptions adjustmentOptions) {
        if (adjustmentOptions == null) {
            return;
        }
        if (adjustmentOptions.g()) {
            this._adjustmentLevelField.setText("Top of Conservation");
        } else {
            this._adjustmentLevelField.setText("Bottom of Conservation");
        }
        this._seasonalCurveField.setText(adjustmentOptions.h().toString());
        this.assignMinLimitValue(adjustmentOptions);
        this.assignMaxLimitValue(adjustmentOptions);
        this._adjacentZoneField.setText(adjustmentOptions.n().toString());
    }

    private void assignMinLimitValue(AdjustmentOptions cloneable) {
        int n = ServiceLookup.getUnitsDisplayService().getDisplayUnitsSystem();
        int n2 = ClientApp.Workspace().getUnitSystem();
        switch (((AdjustmentOptions)cloneable).m()) {
            case ELEVATION: {
                double d = ((AdjustmentOptions)cloneable).a();
                cloneable = new ParamDouble(d, Parameter.PARAMID_ELEV, n2);
                this._minAdjLimitLabel.setText("Min Adjustment Limit (%S):");
                this._minAdjLimitLabel.setDisplayUnitsSystem(n);
                this._minLimitField.setValue((ParamDouble)cloneable);
                ((CardLayout)this._minLimitCardPanel.getLayout()).show((Container)this._minLimitCardPanel, "minDecimalField");
                return;
            }
            case STORAGE: {
                double d = ((AdjustmentOptions)cloneable).c();
                cloneable = new ParamDouble(d, Parameter.PARAMID_STOR, n2);
                this._minAdjLimitLabel.setText("Min Adjustment Limit (%S):");
                this._minAdjLimitLabel.setDisplayUnitsSystem(n);
                this._minLimitField.setValue((ParamDouble)cloneable);
                ((CardLayout)this._minLimitCardPanel.getLayout()).show((Container)this._minLimitCardPanel, "minDecimalField");
                return;
            }
            case ZONE: {
                if (this._selectedReservoir == null) break;
                int n3 = this._alternative.getResOpSetSelection(this._selectedReservoir.getIndex());
                OpSet opSet = this._selectedReservoir.getReservoirOp().getOperationSet(n3);
                if (opSet == null || (cloneable = opSet.getZone(((AdjustmentOptions)cloneable).f())) == null) break;
                this._minLimitZoneField.setText(((StorageZone)cloneable).toString());
                ((CardLayout)this._minLimitCardPanel.getLayout()).show((Container)this._minLimitCardPanel, "minZoneField");
                this._minAdjLimitLabel.setText("Min Adjustment Limit:");
            }
        }
    }

    private void assignMaxLimitValue(AdjustmentOptions cloneable) {
        int n = ServiceLookup.getUnitsDisplayService().getDisplayUnitsSystem();
        int n2 = ClientApp.Workspace().getUnitSystem();
        switch (((AdjustmentOptions)cloneable).l()) {
            case ELEVATION: {
                double d = ((AdjustmentOptions)cloneable).b();
                cloneable = new ParamDouble(d, Parameter.PARAMID_ELEV, n2);
                this._maxAdjLimitLabel.setText("Max Adjustment Limit (%S):");
                this._maxAdjLimitLabel.setDisplayUnitsSystem(n);
                this._maxLimitField.setValue((ParamDouble)cloneable);
                ((CardLayout)this._maxLimitCardPanel.getLayout()).show((Container)this._maxLimitCardPanel, "maxDecimalField");
                return;
            }
            case STORAGE: {
                double d = ((AdjustmentOptions)cloneable).d();
                cloneable = new ParamDouble(d, Parameter.PARAMID_STOR, n2);
                this._maxAdjLimitLabel.setText("Max Adjustment Limit (%S):");
                this._maxAdjLimitLabel.setDisplayUnitsSystem(n);
                this._maxLimitField.setValue((ParamDouble)cloneable);
                ((CardLayout)this._maxLimitCardPanel.getLayout()).show((Container)this._maxLimitCardPanel, "maxDecimalField");
                return;
            }
            case ZONE: {
                if (this._selectedReservoir == null) break;
                int n3 = this._alternative.getResOpSetSelection(this._selectedReservoir.getIndex());
                OpSet opSet = this._selectedReservoir.getReservoirOp().getOperationSet(n3);
                if (opSet == null || (cloneable = opSet.getZone(((AdjustmentOptions)cloneable).e())) == null) break;
                this._maxLimitZoneField.setText(((StorageZone)cloneable).toString());
                ((CardLayout)this._maxLimitCardPanel.getLayout()).show((Container)this._maxLimitCardPanel, "maxZoneField");
                this._maxAdjLimitLabel.setText("Max Adjustment Limit:");
            }
        }
    }

    public void fillPanel(ReverseReservoirYieldAnalysis reverseReservoirYieldAnalysis, RssAlt rssAlt) {
        if (rssAlt == null) {
            return;
        }
        this._alternative = rssAlt;
        this._selectedRulesTable.deleteCells();
        if (reverseReservoirYieldAnalysis == null) {
            this._selectedAdjustmentOptions = AdjustmentOptions.p();
        } else {
            Object object = reverseReservoirYieldAnalysis.getYieldAnalysisRuleRefs();
            object = object.iterator();
            while (object.hasNext()) {
                YieldAnalysisRuleRef yieldAnalysisRuleRef = (YieldAnalysisRuleRef)object.next();
                if (yieldAnalysisRuleRef.isInitialized()) continue;
                yieldAnalysisRuleRef.initializeData(rssAlt.getSystem());
            }
            this._satisfyMap = reverseReservoirYieldAnalysis.a_();
            this._selectedAdjustmentOptions = reverseReservoirYieldAnalysis.a();
            if (this._selectedAdjustmentOptions == null) {
                this._selectedAdjustmentOptions = AdjustmentOptions.p();
            }
        }
        this.doInitialFillOfResTable(reverseReservoirYieldAnalysis);
        ReverseYieldDemandRulePanel reverseYieldDemandRulePanel = this;
        reverseYieldDemandRulePanel.fillSummaryOptions(reverseYieldDemandRulePanel._selectedAdjustmentOptions);
        this.reservoirSelectionChanged();
        EventQueue.invokeLater(() -> this._editor.isYieldAnalysisSelected());
    }

    private void doInitialFillOfResTable(ReverseReservoirYieldAnalysis reverseReservoirYieldAnalysis) {
        ReverseYieldDemandRulePanel reverseYieldDemandRulePanel = this;
        reverseYieldDemandRulePanel.createResTableRowItems(reverseYieldDemandRulePanel._alternative);
        this._resZoneTable.setComboBoxEditor(0, this._resElems);
        if (!this._resElems.isEmpty()) {
            ReverseYieldDemandRulePanel reverseYieldDemandRulePanel2 = this;
            reverseYieldDemandRulePanel2.updateResTable(reverseYieldDemandRulePanel2._resElems.get(0));
        }
        if (this._resZoneTable.getRowCount() == 0) {
            return;
        }
        if (reverseReservoirYieldAnalysis != null) {
            NamedType namedType;
            ReservoirElement reservoirElement = reverseReservoirYieldAnalysis.k();
            if (reservoirElement != null) {
                int n = this._alternative.getResOpSetSelection(reservoirElement.getIndex());
                namedType = reservoirElement.getReservoirOp().getOperationSet(n);
                this._resZoneTable.setValueAt((Object)reservoirElement, 0, 0);
                this._resZoneTable.setValueAt((Object)namedType, 0, 1);
            }
            if ((namedType = reverseReservoirYieldAnalysis.m()) != null) {
                this._resZoneTable.setValueAt((Object)namedType, 0, 2);
            }
            namedType = reverseReservoirYieldAnalysis.p();
            this._resZoneTable.setValueAt((Object)namedType, 0, 3);
        }
    }

    public boolean savePanel(ReverseReservoirYieldAnalysis reverseReservoirYieldAnalysis) {
        TableCellEditor tableCellEditor;
        int n = this._resZoneTable.getEditingColumn();
        if (n == this.getResToleranceColumn() && (tableCellEditor = this._resZoneTable.getCellEditor()) != null) {
            if (RMAConst.isValidValue((double)(tableCellEditor = (ParamDouble)tableCellEditor.getCellEditorValue()).getValue()) && tableCellEditor.getValue() < 0.0) {
                this._resZoneTable.commitEdit(false);
            } else {
                this._resZoneTable.commitEdit(true);
            }
        }
        Object object = this.getZoneData();
        object = this.getRuleRefList((Map<ReservoirElement, StorageZoneRef>)object);
        reverseReservoirYieldAnalysis.setRuleRefs((List<YieldAnalysisRuleRef>)object);
        reverseReservoirYieldAnalysis.a(this.getSatisfyMap());
        reverseReservoirYieldAnalysis.a(this._selectedAdjustmentOptions);
        if (this._selectedReservoir != null) {
            ReverseYieldDemandRulePanel reverseYieldDemandRulePanel = this;
            object = reverseYieldDemandRulePanel.getResTableRowItem(reverseYieldDemandRulePanel._selectedReservoir);
            if (object != null) {
                reverseReservoirYieldAnalysis.a(this._selectedReservoir);
                reverseReservoirYieldAnalysis.a(((ReverseReservoirTableRowItem)object).c());
                reverseReservoirYieldAnalysis.c(((ReverseReservoirTableRowItem)object).d());
            }
        }
        return true;
    }

    @Override
    public void clearPanel() {
        this._resZoneTable.deleteCells();
        this._selectedRulesTable.deleteCells();
        this._ruleRefList = new ArrayList<YieldAnalysisRuleRef>();
        this.clearSummaryPanel();
        this._adjustmentOptionsBtn.setEnabled(false);
        this.repaint();
    }

    private void clearSummaryPanel() {
        this._adjustmentLevelField.setText("");
        this._seasonalCurveField.setText("");
        this._maxLimitField.setText("");
        this._adjacentZoneField.setText("");
    }
}

