/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.rss.client.AlternativeEditor;
import hec.rss.client.ReverseWaterAccountAdjustmentOptions;
import hec.rss.client.ReverseWaterAccountAdjustmentOptionsDialog;
import hec.rss.client.UneditableTextField;
import hec.rss.client.YieldDemandPanelBase;
import hec.rss.model.ReverseWaterAccountYieldAnalysis;
import hec.rss.model.ReverseYieldAnalysisBase;
import hec.rss.model.RssAlt;
import hec.rss.model.WaterAccount;
import hec.rss.model.YieldAnalysis;
import hec.rss.model.YieldAnalysisRuleRef;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import javax.swing.JDialog;
import rma.swing.EnabledJPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJButton;
import rma.swing.RmaJLabel;
import rma.swing.RmaJPanel;
import rma.util.RMAUtil;

public class ReverseYieldDemandWAccountPanel
extends YieldDemandPanelBase {
    private WaterAccount _currentAccount = null;
    private RmaJButton _adjustmentOptionsButton;
    private ReverseWaterAccountAdjustmentOptions _selectedAdjustmentOptions;
    private UneditableTextField _maxTypeField;
    private UneditableTextField _adjacentZoneField;

    ReverseYieldDemandWAccountPanel(AlternativeEditor alternativeEditor) {
        super(alternativeEditor);
        this.buildControls();
        this.addListeners();
    }

    private RmaJPanel createSummaryPanel() {
        RmaJPanel rmaJPanel = new RmaJPanel((LayoutManager)new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        RmaJLabel rmaJLabel = new RmaJLabel("Max Adjustment Limit:");
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        rmaJPanel.add((Component)rmaJLabel, (Object)gridBagConstraints);
        this._maxTypeField = new UneditableTextField();
        this._maxTypeField.setEditable(false);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        rmaJPanel.add((Component)((Object)this._maxTypeField), (Object)gridBagConstraints);
        rmaJLabel = new RmaJLabel("Adjacent Zone Strategy:");
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        rmaJPanel.add((Component)rmaJLabel, (Object)gridBagConstraints);
        this._adjacentZoneField = new UneditableTextField();
        this._adjacentZoneField.setEditable(false);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        rmaJPanel.add((Component)((Object)this._adjacentZoneField), (Object)gridBagConstraints);
        return rmaJPanel;
    }

    public void buildControls() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        RmaJPanel rmaJPanel = this.createSummaryPanel();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        this.add((Component)rmaJPanel, gridBagConstraints);
        this._adjustmentOptionsButton = new RmaJButton("Edit Adjustment Options...");
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        ReverseYieldDemandWAccountPanel reverseYieldDemandWAccountPanel = this;
        reverseYieldDemandWAccountPanel.add((Component)reverseYieldDemandWAccountPanel._adjustmentOptionsButton, gridBagConstraints);
        rmaJPanel = new EnabledJPanel((LayoutManager)new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        this.add((Component)rmaJPanel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.75;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        rmaJPanel.add((Component)this._selectedRulesTable.getScrollPane(), (Object)gridBagConstraints);
        this._selectedRulesTable.deleteCells();
    }

    protected void addListeners() {
        this._adjustmentOptionsButton.addActionListener(actionEvent -> this.launchAdjustmentOptions());
    }

    private void launchAdjustmentOptions() {
        ReverseWaterAccountAdjustmentOptionsDialog reverseWaterAccountAdjustmentOptionsDialog = new ReverseWaterAccountAdjustmentOptionsDialog((JDialog)((Object)this._editor));
        reverseWaterAccountAdjustmentOptionsDialog.fillPanel(this._selectedAdjustmentOptions);
        reverseWaterAccountAdjustmentOptionsDialog.setVisible(true);
        if (!reverseWaterAccountAdjustmentOptionsDialog.wasCanceled()) {
            RMAUtil.setParentModified((Component)this);
            this._selectedAdjustmentOptions = reverseWaterAccountAdjustmentOptionsDialog.getAdjustmentOptions();
            ReverseYieldDemandWAccountPanel reverseYieldDemandWAccountPanel = this;
            reverseYieldDemandWAccountPanel.fillSummaryOptions(reverseYieldDemandWAccountPanel._selectedAdjustmentOptions);
        }
    }

    public void fillPanel(ReverseWaterAccountYieldAnalysis reverseWaterAccountYieldAnalysis, RssAlt rssAlt) {
        if (rssAlt == null) {
            return;
        }
        this._alternative = rssAlt;
        this._selectedRulesTable.deleteCells();
        if (reverseWaterAccountYieldAnalysis == null) {
            this._selectedAdjustmentOptions = ReverseWaterAccountAdjustmentOptions.e();
        } else {
            Object object = reverseWaterAccountYieldAnalysis.getYieldAnalysisRuleRefs();
            object = object.iterator();
            while (object.hasNext()) {
                YieldAnalysisRuleRef yieldAnalysisRuleRef = (YieldAnalysisRuleRef)object.next();
                if (yieldAnalysisRuleRef.isInitialized()) continue;
                yieldAnalysisRuleRef.initializeData(rssAlt.getSystem());
            }
            this._satisfyMap = ((ReverseYieldAnalysisBase)reverseWaterAccountYieldAnalysis).a_();
            this._selectedAdjustmentOptions = reverseWaterAccountYieldAnalysis.b();
            if (this._selectedAdjustmentOptions == null) {
                this._selectedAdjustmentOptions = ReverseWaterAccountAdjustmentOptions.e();
            }
        }
        ReverseYieldDemandWAccountPanel reverseYieldDemandWAccountPanel = this;
        reverseYieldDemandWAccountPanel.fillSummaryOptions(reverseYieldDemandWAccountPanel._selectedAdjustmentOptions);
        EventQueue.invokeLater(() -> this._editor.isYieldAnalysisSelected());
    }

    private void fillSummaryOptions(ReverseWaterAccountAdjustmentOptions reverseWaterAccountAdjustmentOptions) {
        if (reverseWaterAccountAdjustmentOptions.a() != null) {
            this._maxTypeField.setText(reverseWaterAccountAdjustmentOptions.a().toString());
        } else {
            this._maxTypeField.setText("");
        }
        if (reverseWaterAccountAdjustmentOptions.d() != null) {
            this._adjacentZoneField.setText(reverseWaterAccountAdjustmentOptions.d().toString());
            return;
        }
        this._adjacentZoneField.setText("");
    }

    private List<YieldAnalysisRuleRef> getRulesFromWaterAccount(WaterAccount waterAccount) {
        List<YieldAnalysisRuleRef> list = new ArrayList<YieldAnalysisRuleRef>();
        if (waterAccount != null && this._editor._selectedAlt != null && waterAccount.initializeRules(this._editor._selectedAlt.getSystem())) {
            list = waterAccount.getRuleRefs();
        }
        return list;
    }

    private void addRuleToTable(YieldAnalysisRuleRef object, boolean bl) {
        this._ruleRefList.add((YieldAnalysisRuleRef)object);
        Vector<Object> vector = new Vector<Object>();
        vector.add(((YieldAnalysisRuleRef)object).getLocationName() + " - " + ((YieldAnalysisRuleRef)object).getRuleName());
        object = "Local Hydropower".equals(((YieldAnalysisRuleRef)object).getRuleTypeString()) ? new ParamDouble(((YieldAnalysisRuleRef)object).getTolerance(), this._paramPower, this._alternative.getUnitSystem()) : new ParamDouble(((YieldAnalysisRuleRef)object).getTolerance(), this._paramFlow, this._alternative.getUnitSystem());
        vector.add(object);
        object = Parameter.getUnitsStringForSystem((int)object.getParameterId(), (int)object.getUnitSystem());
        vector.add(object);
        vector.add(bl);
        this._selectedRulesTable.appendRow(vector);
    }

    private List<YieldAnalysisRuleRef> getAllRules() {
        Object object;
        ArrayList<YieldAnalysisRuleRef> arrayList = new ArrayList<YieldAnalysisRuleRef>();
        if (this._alternative != null && (object = this._alternative.getReverseWaterAccountYieldAnalysis()) != null) {
            object = ((YieldAnalysis)object).getYieldAnalysisRuleRefs();
            arrayList.addAll((Collection<YieldAnalysisRuleRef>)object);
        }
        if (this._currentAccount != null) {
            ReverseYieldDemandWAccountPanel reverseYieldDemandWAccountPanel = this;
            object = reverseYieldDemandWAccountPanel.getRulesFromWaterAccount(reverseYieldDemandWAccountPanel._currentAccount);
            object = object.iterator();
            while (object.hasNext()) {
                YieldAnalysisRuleRef yieldAnalysisRuleRef = (YieldAnalysisRuleRef)object.next();
                ReverseYieldDemandWAccountPanel reverseYieldDemandWAccountPanel2 = this;
                if (reverseYieldDemandWAccountPanel2.doesRuleAlreadyExist(reverseYieldDemandWAccountPanel2._alternative, arrayList, yieldAnalysisRuleRef)) continue;
                arrayList.add(yieldAnalysisRuleRef);
            }
        }
        return arrayList;
    }

    public void fillTable(WaterAccount iterator) {
        this._currentAccount = iterator;
        iterator = this.getAllRules();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            YieldAnalysisRuleRef yieldAnalysisRuleRef = iterator.next();
            int n = yieldAnalysisRuleRef.getRule().getIndex();
            if (this._satisfyMap.containsKey(n)) {
                n = this._satisfyMap.get(n).booleanValue() ? 1 : 0;
                this.addRuleToTable(yieldAnalysisRuleRef, n != 0);
                continue;
            }
            this.addRuleToTable(yieldAnalysisRuleRef, true);
        }
    }

    public YieldAnalysis savePanel(ReverseWaterAccountYieldAnalysis reverseWaterAccountYieldAnalysis) {
        ArrayList<YieldAnalysisRuleRef> arrayList = new ArrayList<YieldAnalysisRuleRef>();
        this._selectedRulesTable.commitEdit(true);
        for (int i = 0; i < this._selectedRulesTable.getRowCount(); ++i) {
            YieldAnalysisRuleRef yieldAnalysisRuleRef = this._ruleRefList.get(i);
            yieldAnalysisRuleRef.setTolerence(((ParamDouble)this._selectedRulesTable.getValueAt(i, 1)).getValue());
            if (arrayList.contains(yieldAnalysisRuleRef)) continue;
            arrayList.add(yieldAnalysisRuleRef);
        }
        reverseWaterAccountYieldAnalysis.setRuleRefs(arrayList);
        ((ReverseYieldAnalysisBase)reverseWaterAccountYieldAnalysis).a(this.getSatisfyMap());
        reverseWaterAccountYieldAnalysis.a(this._selectedAdjustmentOptions);
        return reverseWaterAccountYieldAnalysis;
    }

    @Override
    public void clearPanel() {
        this._selectedRulesTable.deleteCells();
        this._ruleRefList = new ArrayList<YieldAnalysisRuleRef>();
    }
}

